// Compiled by ClojureScript 1.7.228 {}
goog.provide('taoensso.sente');
goog.require('cljs.core');
goog.require('taoensso.timbre');
goog.require('taoensso.sente.interfaces');
goog.require('cljs.core.async');
goog.require('taoensso.encore');
goog.require('clojure.string');
if(cljs.core.vector_QMARK_.call(null,taoensso.encore.encore_version)){
taoensso.encore.assert_min_encore_version.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(2),(11),(0)], null));
} else {
taoensso.encore.assert_min_encore_version.call(null,2.11);
}
taoensso.sente.validate_event = (function taoensso$sente$validate_event(x){
if(!(cljs.core.vector_QMARK_.call(null,x))){
return new cljs.core.Keyword(null,"wrong-type","wrong-type",929556915);
} else {
if(cljs.core.not.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [(1),null,(2),null], null), null).call(null,cljs.core.count.call(null,x)))){
return new cljs.core.Keyword(null,"wrong-length","wrong-length",1367572281);
} else {
var vec__27629 = x;
var ev_id = cljs.core.nth.call(null,vec__27629,(0),null);
var _ = cljs.core.nth.call(null,vec__27629,(1),null);
if(!((ev_id instanceof cljs.core.Keyword))){
return new cljs.core.Keyword(null,"wrong-id-type","wrong-id-type",-1213601689);
} else {
if(cljs.core.not.call(null,cljs.core.namespace.call(null,ev_id))){
return new cljs.core.Keyword(null,"unnamespaced-id","unnamespaced-id",1976189772);
} else {
return null;

}
}

}
}
});
/**
 * Valid [ev-id ?ev-data] form?
 */
taoensso.sente.event_QMARK_ = (function taoensso$sente$event_QMARK_(x){
return (taoensso.sente.validate_event.call(null,x) == null);
});
taoensso.sente.as_event = (function taoensso$sente$as_event(x){
if(cljs.core.truth_(taoensso.sente.event_QMARK_.call(null,x))){
return x;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("chsk","bad-event","chsk/bad-event",-565206930),x], null);
}
});
taoensso.sente.assert_event = (function taoensso$sente$assert_event(x){
var temp__4657__auto__ = taoensso.sente.validate_event.call(null,x);
if(cljs.core.truth_(temp__4657__auto__)){
var _QMARK_err = temp__4657__auto__;
var err_fmt = [cljs.core.str((function (){var G__27634 = (((_QMARK_err instanceof cljs.core.Keyword))?_QMARK_err.fqn:null);
switch (G__27634) {
case "wrong-type":
return "Malformed event (wrong type).";

break;
case "wrong-length":
return "Malformed event (wrong length).";

break;
case "wrong-id-type":
return "Malformed event (`ev-id` should be a namespaced keyword).";

break;
case "unnamespaced-id":
return "Malformed event (`ev-id` should be a namespaced keyword).";

break;
case "else":
return "Malformed event (unknown error).";

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(_QMARK_err)].join('')));

}
})()),cljs.core.str(" Event should be of `[ev-id ?ev-data]` form: %s")].join('');
throw cljs.core.ex_info.call(null,taoensso.encore.format.call(null,err_fmt,[cljs.core.str(x)].join('')),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"malformed-event","malformed-event",-2090896605),x], null));
} else {
return null;
}
});
taoensso.sente.client_event_msg_QMARK_ = (function taoensso$sente$client_event_msg_QMARK_(x){
var and__6037__auto__ = cljs.core.map_QMARK_.call(null,x);
if(and__6037__auto__){
var and__6037__auto____$1 = taoensso.encore.keys_EQ_.call(null,x,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"event","event",301435442),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"?data","?data",-9471433),null,new cljs.core.Keyword(null,"send-fn","send-fn",351002041),null], null), null));
if(cljs.core.truth_(and__6037__auto____$1)){
var map__27642 = x;
var map__27642__$1 = ((((!((map__27642 == null)))?((((map__27642.cljs$lang$protocol_mask$partition0$ & (64))) || (map__27642.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27642):map__27642);
var ch_recv = cljs.core.get.call(null,map__27642__$1,new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861));
var send_fn = cljs.core.get.call(null,map__27642__$1,new cljs.core.Keyword(null,"send-fn","send-fn",351002041));
var state = cljs.core.get.call(null,map__27642__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var event = cljs.core.get.call(null,map__27642__$1,new cljs.core.Keyword(null,"event","event",301435442));
var and__6037__auto____$2 = taoensso.encore.chan_QMARK_.call(null,ch_recv);
if(cljs.core.truth_(and__6037__auto____$2)){
var and__6037__auto____$3 = cljs.core.ifn_QMARK_.call(null,send_fn);
if(and__6037__auto____$3){
var and__6037__auto____$4 = taoensso.encore.atom_QMARK_.call(null,state);
if(cljs.core.truth_(and__6037__auto____$4)){
return taoensso.sente.event_QMARK_.call(null,event);
} else {
return and__6037__auto____$4;
}
} else {
return and__6037__auto____$3;
}
} else {
return and__6037__auto____$2;
}
} else {
return and__6037__auto____$1;
}
} else {
return and__6037__auto__;
}
});
taoensso.sente.server_event_msg_QMARK_ = (function taoensso$sente$server_event_msg_QMARK_(x){
var and__6037__auto__ = cljs.core.map_QMARK_.call(null,x);
if(and__6037__auto__){
var and__6037__auto____$1 = taoensso.encore.keys_EQ_.call(null,x,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 10, [new cljs.core.Keyword(null,"?reply-fn","?reply-fn",-1479510592),null,new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861),null,new cljs.core.Keyword(null,"client-id","client-id",-464622140),null,new cljs.core.Keyword(null,"connected-uids","connected-uids",1454332231),null,new cljs.core.Keyword(null,"uid","uid",-1447769400),null,new cljs.core.Keyword(null,"event","event",301435442),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"ring-req","ring-req",-747861961),null,new cljs.core.Keyword(null,"?data","?data",-9471433),null,new cljs.core.Keyword(null,"send-fn","send-fn",351002041),null], null), null));
if(cljs.core.truth_(and__6037__auto____$1)){
var map__27646 = x;
var map__27646__$1 = ((((!((map__27646 == null)))?((((map__27646.cljs$lang$protocol_mask$partition0$ & (64))) || (map__27646.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27646):map__27646);
var ch_recv = cljs.core.get.call(null,map__27646__$1,new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861));
var send_fn = cljs.core.get.call(null,map__27646__$1,new cljs.core.Keyword(null,"send-fn","send-fn",351002041));
var connected_uids = cljs.core.get.call(null,map__27646__$1,new cljs.core.Keyword(null,"connected-uids","connected-uids",1454332231));
var ring_req = cljs.core.get.call(null,map__27646__$1,new cljs.core.Keyword(null,"ring-req","ring-req",-747861961));
var client_id = cljs.core.get.call(null,map__27646__$1,new cljs.core.Keyword(null,"client-id","client-id",-464622140));
var event = cljs.core.get.call(null,map__27646__$1,new cljs.core.Keyword(null,"event","event",301435442));
var _QMARK_reply_fn = cljs.core.get.call(null,map__27646__$1,new cljs.core.Keyword(null,"?reply-fn","?reply-fn",-1479510592));
var and__6037__auto____$2 = taoensso.encore.chan_QMARK_.call(null,ch_recv);
if(cljs.core.truth_(and__6037__auto____$2)){
var and__6037__auto____$3 = cljs.core.ifn_QMARK_.call(null,send_fn);
if(and__6037__auto____$3){
var and__6037__auto____$4 = taoensso.encore.atom_QMARK_.call(null,connected_uids);
if(cljs.core.truth_(and__6037__auto____$4)){
var and__6037__auto____$5 = cljs.core.map_QMARK_.call(null,ring_req);
if(and__6037__auto____$5){
var and__6037__auto____$6 = taoensso.encore.nblank_str_QMARK_.call(null,client_id);
if(cljs.core.truth_(and__6037__auto____$6)){
var and__6037__auto____$7 = taoensso.sente.event_QMARK_.call(null,event);
if(cljs.core.truth_(and__6037__auto____$7)){
return ((_QMARK_reply_fn == null)) || (cljs.core.ifn_QMARK_.call(null,_QMARK_reply_fn));
} else {
return and__6037__auto____$7;
}
} else {
return and__6037__auto____$6;
}
} else {
return and__6037__auto____$5;
}
} else {
return and__6037__auto____$4;
}
} else {
return and__6037__auto____$3;
}
} else {
return and__6037__auto____$2;
}
} else {
return and__6037__auto____$1;
}
} else {
return and__6037__auto__;
}
});
/**
 * All server `event-msg`s go through this
 */
taoensso.sente.put_server_event_msg_GT_ch_recv_BANG_ = (function taoensso$sente$put_server_event_msg_GT_ch_recv_BANG_(ch_recv,p__27648){
var map__27652 = p__27648;
var map__27652__$1 = ((((!((map__27652 == null)))?((((map__27652.cljs$lang$protocol_mask$partition0$ & (64))) || (map__27652.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27652):map__27652);
var ev_msg = map__27652__$1;
var event = cljs.core.get.call(null,map__27652__$1,new cljs.core.Keyword(null,"event","event",301435442));
var _QMARK_reply_fn = cljs.core.get.call(null,map__27652__$1,new cljs.core.Keyword(null,"?reply-fn","?reply-fn",-1479510592));
var vec__27654 = taoensso.sente.as_event.call(null,event);
var ev_id = cljs.core.nth.call(null,vec__27654,(0),null);
var ev__QMARK_data = cljs.core.nth.call(null,vec__27654,(1),null);
var valid_event = vec__27654;
var ev_msg_STAR_ = cljs.core.merge.call(null,ev_msg,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"event","event",301435442),valid_event,new cljs.core.Keyword(null,"?reply-fn","?reply-fn",-1479510592),_QMARK_reply_fn,new cljs.core.Keyword(null,"id","id",-1388402092),ev_id,new cljs.core.Keyword(null,"?data","?data",-9471433),ev__QMARK_data], null));
if(cljs.core.not.call(null,taoensso.sente.server_event_msg_QMARK_.call(null,ev_msg_STAR_))){
return taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente","/tmp/form-init5145320441605965266.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),(new cljs.core.Delay(((function (vec__27654,ev_id,ev__QMARK_data,valid_event,ev_msg_STAR_,map__27652,map__27652__$1,ev_msg,event,_QMARK_reply_fn){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Bad ev-msg: %s",ev_msg], null);
});})(vec__27654,ev_id,ev__QMARK_data,valid_event,ev_msg_STAR_,map__27652,map__27652__$1,ev_msg,event,_QMARK_reply_fn))
,null)),null);
} else {
return cljs.core.async.put_BANG_.call(null,ch_recv,ev_msg_STAR_);
}
});
taoensso.sente.cb_error_QMARK_ = (function taoensso$sente$cb_error_QMARK_(cb_reply_clj){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword("chsk","closed","chsk/closed",-922855264),null,new cljs.core.Keyword("chsk","error","chsk/error",-984175439),null,new cljs.core.Keyword("chsk","timeout","chsk/timeout",-319776489),null], null), null).call(null,cb_reply_clj);
});
taoensso.sente.cb_success_QMARK_ = (function taoensso$sente$cb_success_QMARK_(cb_reply_clj){
return cljs.core.not.call(null,taoensso.sente.cb_error_QMARK_.call(null,cb_reply_clj));
});
/**
 * pstr->clj
 */
taoensso.sente.unpack_STAR_ = (function taoensso$sente$unpack_STAR_(packer,pstr){
try{return taoensso.sente.interfaces.unpack.call(null,packer,taoensso.encore.hcond.call(null,false,"taoensso.sente",173,(new cljs.core.Delay((function (){
return pstr;
}),null)),new cljs.core.Symbol(null,"pstr","pstr",221763868,null),cljs.core.string_QMARK_,new cljs.core.Symbol(null,"string?","string?",-1129175764,null)));
}catch (e27656){var t = e27656;
taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"debug","debug",-1608172596),"taoensso.sente","/tmp/form-init5145320441605965266.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),(new cljs.core.Delay(((function (t){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Bad package: %s (%s)",pstr,t], null);
});})(t))
,null)),null);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("chsk","bad-package","chsk/bad-package",501893679),pstr], null);
}});
taoensso.sente.with__QMARK_meta = (function taoensso$sente$with__QMARK_meta(x,_QMARK_m){
if(cljs.core.seq.call(null,_QMARK_m)){
return cljs.core.with_meta.call(null,x,_QMARK_m);
} else {
return x;
}
});
/**
 * clj->prefixed-pstr
 */
taoensso.sente.pack_STAR_ = (function taoensso$sente$pack_STAR_(var_args){
var args27657 = [];
var len__7107__auto___27660 = arguments.length;
var i__7108__auto___27661 = (0);
while(true){
if((i__7108__auto___27661 < len__7107__auto___27660)){
args27657.push((arguments[i__7108__auto___27661]));

var G__27662 = (i__7108__auto___27661 + (1));
i__7108__auto___27661 = G__27662;
continue;
} else {
}
break;
}

var G__27659 = args27657.length;
switch (G__27659) {
case 3:
return taoensso.sente.pack_STAR_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return taoensso.sente.pack_STAR_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args27657.length)].join('')));

}
});

taoensso.sente.pack_STAR_.cljs$core$IFn$_invoke$arity$3 = (function (packer,_QMARK_packer_meta,clj){
return [cljs.core.str("-"),cljs.core.str(taoensso.sente.interfaces.pack.call(null,packer,taoensso.sente.with__QMARK_meta.call(null,clj,_QMARK_packer_meta)))].join('');
});

taoensso.sente.pack_STAR_.cljs$core$IFn$_invoke$arity$4 = (function (packer,_QMARK_packer_meta,clj,_QMARK_cb_uuid){
var _QMARK_cb_uuid__$1 = ((cljs.core._EQ_.call(null,_QMARK_cb_uuid,new cljs.core.Keyword(null,"ajax-cb","ajax-cb",-807060321)))?(0):_QMARK_cb_uuid);
var wrapped_clj = (cljs.core.truth_(_QMARK_cb_uuid__$1)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [clj,_QMARK_cb_uuid__$1], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [clj], null));
return [cljs.core.str("+"),cljs.core.str(taoensso.sente.interfaces.pack.call(null,packer,taoensso.sente.with__QMARK_meta.call(null,wrapped_clj,_QMARK_packer_meta)))].join('');
});

taoensso.sente.pack_STAR_.cljs$lang$maxFixedArity = 4;
taoensso.sente.pack = (function taoensso$sente$pack(var_args){
var args__7114__auto__ = [];
var len__7107__auto___27665 = arguments.length;
var i__7108__auto___27666 = (0);
while(true){
if((i__7108__auto___27666 < len__7107__auto___27665)){
args__7114__auto__.push((arguments[i__7108__auto___27666]));

var G__27667 = (i__7108__auto___27666 + (1));
i__7108__auto___27666 = G__27667;
continue;
} else {
}
break;
}

var argseq__7115__auto__ = ((((0) < args__7114__auto__.length))?(new cljs.core.IndexedSeq(args__7114__auto__.slice((0)),(0))):null);
return taoensso.sente.pack.cljs$core$IFn$_invoke$arity$variadic(argseq__7115__auto__);
});

taoensso.sente.pack.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var pstr = cljs.core.apply.call(null,taoensso.sente.pack_STAR_,args);
taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/tmp/form-init5145320441605965266.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),(new cljs.core.Delay(((function (pstr){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Packing: %s -> %s",args,pstr], null);
});})(pstr))
,null)),null);

return pstr;
});

taoensso.sente.pack.cljs$lang$maxFixedArity = (0);

taoensso.sente.pack.cljs$lang$applyTo = (function (seq27664){
return taoensso.sente.pack.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq27664));
});
/**
 * prefixed-pstr->[clj ?cb-uuid]
 */
taoensso.sente.unpack = (function taoensso$sente$unpack(packer,prefixed_pstr){
taoensso.encore.hcond.call(null,false,"taoensso.sente",null,(new cljs.core.Delay((function (){
return prefixed_pstr;
}),null)),new cljs.core.Symbol(null,"prefixed-pstr","prefixed-pstr",-515747107,null),cljs.core.string_QMARK_,new cljs.core.Symbol(null,"string?","string?",-1129175764,null));


var prefix = taoensso.encore.substr.call(null,prefixed_pstr,(0),(1));
var pstr = taoensso.encore.substr.call(null,prefixed_pstr,(1));
var clj = taoensso.sente.unpack_STAR_.call(null,packer,pstr);
var wrapped_QMARK_ = (function (){var G__27671 = prefix;
switch (G__27671) {
case "-":
return false;

break;
case "+":
return true;

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(prefix)].join('')));

}
})();
var vec__27670 = (cljs.core.truth_(wrapped_QMARK_)?clj:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [clj,null], null));
var clj__$1 = cljs.core.nth.call(null,vec__27670,(0),null);
var _QMARK_cb_uuid = cljs.core.nth.call(null,vec__27670,(1),null);
var _QMARK_cb_uuid__$1 = ((cljs.core._EQ_.call(null,(0),_QMARK_cb_uuid))?new cljs.core.Keyword(null,"ajax-cb","ajax-cb",-807060321):_QMARK_cb_uuid);
taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/tmp/form-init5145320441605965266.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),(new cljs.core.Delay(((function (prefix,pstr,clj,wrapped_QMARK_,vec__27670,clj__$1,_QMARK_cb_uuid,_QMARK_cb_uuid__$1){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Unpacking: %s -> %s",prefixed_pstr,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [clj__$1,_QMARK_cb_uuid__$1], null)], null);
});})(prefix,pstr,clj,wrapped_QMARK_,vec__27670,clj__$1,_QMARK_cb_uuid,_QMARK_cb_uuid__$1))
,null)),null);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [clj__$1,_QMARK_cb_uuid__$1], null);
});

/**
 * Takes a web server adapter[1] and returns a map with keys:
 *  :ch-recv ; core.async channel to receive `event-msg`s (internal or from clients).
 *  :send-fn ; (fn [user-id ev] for server>user push.
 *  :ajax-post-fn                ; (fn [ring-req]) for Ring CSRF-POST + chsk URL.
 *  :ajax-get-or-ws-handshake-fn ; (fn [ring-req]) for Ring GET + chsk URL.
 *  :connected-uids ; Watchable, read-only (atom {:ws #{_} :ajax #{_} :any #{_}}).
 * 
 *   Common options:
 *  :user-id-fn        ; (fn [ring-req]) -> unique user-id for server>user push.
 *  :csrf-token-fn     ; (fn [ring-req]) -> CSRF token for Ajax POSTs.
 *  :handshake-data-fn ; (fn [ring-req]) -> arb user data to append to handshake evs.
 *  :send-buf-ms-ajax  ; [2]
 *  :send-buf-ms-ws    ; [2]
 *  :packer            ; :edn (default), or an IPacker implementation (experimental).
 * 
 *   [1] e.g. `taoensso.sente.server-adapters.http-kit/http-kit-adapter` or
 *         `taoensso.sente.server-adapters.immutant/immutant-adapter`.
 *    You must have the necessary web-server dependency in your project.clj and
 *    the necessary entry in your namespace's `ns` form.
 * 
 *   [2] Optimization to allow transparent batching of rapidly-triggered
 *    server>user pushes. This is esp. important for Ajax clients which use a
 *    (slow) reconnecting poller. Actual event dispatch may occur <= given ms
 *    after send call (larger values => larger batch windows).
 */
taoensso.sente.make_channel_socket_server_BANG_ = (function taoensso$sente$make_channel_socket_server_BANG_(var_args){
var args__7114__auto__ = [];
var len__7107__auto___27835 = arguments.length;
var i__7108__auto___27836 = (0);
while(true){
if((i__7108__auto___27836 < len__7107__auto___27835)){
args__7114__auto__.push((arguments[i__7108__auto___27836]));

var G__27837 = (i__7108__auto___27836 + (1));
i__7108__auto___27836 = G__27837;
continue;
} else {
}
break;
}

var argseq__7115__auto__ = ((((1) < args__7114__auto__.length))?(new cljs.core.IndexedSeq(args__7114__auto__.slice((1)),(0))):null);
return taoensso.sente.make_channel_socket_server_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7115__auto__);
});

taoensso.sente.make_channel_socket_server_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (web_server_adapter,p__27676){
var vec__27677 = p__27676;
var map__27678 = cljs.core.nth.call(null,vec__27677,(0),null);
var map__27678__$1 = ((((!((map__27678 == null)))?((((map__27678.cljs$lang$protocol_mask$partition0$ & (64))) || (map__27678.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27678):map__27678);
var recv_buf_or_n = cljs.core.get.call(null,map__27678__$1,new cljs.core.Keyword(null,"recv-buf-or-n","recv-buf-or-n",1363950355),cljs.core.async.sliding_buffer.call(null,(1000)));
var send_buf_ms_ajax = cljs.core.get.call(null,map__27678__$1,new cljs.core.Keyword(null,"send-buf-ms-ajax","send-buf-ms-ajax",1546129037),(100));
var send_buf_ms_ws = cljs.core.get.call(null,map__27678__$1,new cljs.core.Keyword(null,"send-buf-ms-ws","send-buf-ms-ws",-1149586238),(30));
var user_id_fn = cljs.core.get.call(null,map__27678__$1,new cljs.core.Keyword(null,"user-id-fn","user-id-fn",-1532150029),((function (vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws){
return (function (ring_req){
return cljs.core.get_in.call(null,ring_req,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"session","session",1008279103),new cljs.core.Keyword(null,"uid","uid",-1447769400)], null));
});})(vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws))
);
var csrf_token_fn = cljs.core.get.call(null,map__27678__$1,new cljs.core.Keyword(null,"csrf-token-fn","csrf-token-fn",-1846298394),((function (vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn){
return (function (ring_req){
var or__6049__auto__ = cljs.core.get_in.call(null,ring_req,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"session","session",1008279103),new cljs.core.Keyword(null,"csrf-token","csrf-token",-1872302856)], null));
if(cljs.core.truth_(or__6049__auto__)){
return or__6049__auto__;
} else {
var or__6049__auto____$1 = cljs.core.get_in.call(null,ring_req,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"session","session",1008279103),new cljs.core.Keyword("ring.middleware.anti-forgery","anti-forgery-token","ring.middleware.anti-forgery/anti-forgery-token",571563484)], null));
if(cljs.core.truth_(or__6049__auto____$1)){
return or__6049__auto____$1;
} else {
return cljs.core.get_in.call(null,ring_req,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"session","session",1008279103),"__anti-forgery-token"], null));
}
}
});})(vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn))
);
var handshake_data_fn = cljs.core.get.call(null,map__27678__$1,new cljs.core.Keyword(null,"handshake-data-fn","handshake-data-fn",2011983089),((function (vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn){
return (function (ring_req){
return null;
});})(vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn))
);
var packer = cljs.core.get.call(null,map__27678__$1,new cljs.core.Keyword(null,"packer","packer",66077544),new cljs.core.Keyword(null,"edn","edn",1317840885));
if((function (){
new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [taoensso.encore.hcond.call(null,false,"taoensso.sente",null,(new cljs.core.Delay(((function (vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
return send_buf_ms_ajax;
});})(vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,null)),new cljs.core.Symbol(null,"send-buf-ms-ajax","send-buf-ms-ajax",-1108306732,null),taoensso.encore.pos_int_QMARK_,new cljs.core.Symbol("enc","pos-int?","enc/pos-int?",-1205796829,null)),taoensso.encore.hcond.call(null,false,"taoensso.sente",null,(new cljs.core.Delay(((function (vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
return send_buf_ms_ws;
});})(vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,null)),new cljs.core.Symbol(null,"send-buf-ms-ws","send-buf-ms-ws",490945289,null),taoensso.encore.pos_int_QMARK_,new cljs.core.Symbol("enc","pos-int?","enc/pos-int?",-1205796829,null))], null);

return true;
})()
){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"have?","have?",-1685305646,null),new cljs.core.Symbol("enc","pos-int?","enc/pos-int?",-1205796829,null),new cljs.core.Symbol(null,"send-buf-ms-ajax","send-buf-ms-ajax",-1108306732,null),new cljs.core.Symbol(null,"send-buf-ms-ws","send-buf-ms-ws",490945289,null))))].join('')));
}

if((function (){
taoensso.encore.hcond.call(null,false,"taoensso.sente",null,(new cljs.core.Delay(((function (vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
return web_server_adapter;
});})(vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,null)),new cljs.core.Symbol(null,"web-server-adapter","web-server-adapter",-1122606046,null),((function (vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (p1__27673_SHARP_){
if(!((p1__27673_SHARP_ == null))){
if((false) || (p1__27673_SHARP_.taoensso$sente$interfaces$IServerChanAdapter$)){
return true;
} else {
if((!p1__27673_SHARP_.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,taoensso.sente.interfaces.IServerChanAdapter,p1__27673_SHARP_);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,taoensso.sente.interfaces.IServerChanAdapter,p1__27673_SHARP_);
}
});})(vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__27673#","p1__27673#",-1678313456,null)], null),cljs.core.list(new cljs.core.Symbol(null,"satisfies?","satisfies?",-433227199,null),new cljs.core.Symbol("interfaces","IServerChanAdapter","interfaces/IServerChanAdapter",-455981296,null),new cljs.core.Symbol(null,"p1__27673#","p1__27673#",-1678313456,null))));

return true;
})()
){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"have?","have?",-1685305646,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__27673#","p1__27673#",-1678313456,null)], null),cljs.core.list(new cljs.core.Symbol(null,"satisfies?","satisfies?",-433227199,null),new cljs.core.Symbol("interfaces","IServerChanAdapter","interfaces/IServerChanAdapter",-455981296,null),new cljs.core.Symbol(null,"p1__27673#","p1__27673#",-1678313456,null))),new cljs.core.Symbol(null,"web-server-adapter","web-server-adapter",-1122606046,null))))].join('')));
}

var packer__$1 = taoensso.sente.interfaces.coerce_packer.call(null,packer);
var ch_recv = cljs.core.async.chan.call(null,recv_buf_or_n);
var conns_ = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ws","ws",86841443),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"ajax","ajax",814345549),cljs.core.PersistentArrayMap.EMPTY], null));
var connected_uids_ = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"ws","ws",86841443),cljs.core.PersistentHashSet.EMPTY,new cljs.core.Keyword(null,"ajax","ajax",814345549),cljs.core.PersistentHashSet.EMPTY,new cljs.core.Keyword(null,"any","any",1705907423),cljs.core.PersistentHashSet.EMPTY], null));
var send_buffers_ = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ws","ws",86841443),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"ajax","ajax",814345549),cljs.core.PersistentArrayMap.EMPTY], null));
var user_id_fn__$1 = ((function (packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (ring_req,client_id){
var or__6049__auto__ = user_id_fn.call(null,cljs.core.assoc.call(null,ring_req,new cljs.core.Keyword(null,"client-id","client-id",-464622140),client_id));
if(cljs.core.truth_(or__6049__auto__)){
return or__6049__auto__;
} else {
return new cljs.core.Keyword("taoensso.sente","nil-uid","taoensso.sente/nil-uid",-2111603486);
}
});})(packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
;
var connect_uid_BANG_ = ((function (packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (type,uid){
if((function (){
taoensso.encore.hcond.call(null,false,"taoensso.sente",null,(new cljs.core.Delay(((function (packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
return uid;
});})(packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,null)),new cljs.core.Symbol(null,"uid","uid",192762127,null),taoensso.encore.nnil_QMARK_,new cljs.core.Symbol("taoensso.encore","nnil?","taoensso.encore/nnil?",-1813154343,null));

return true;
})()
){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"have?","have?",-1685305646,null),new cljs.core.Symbol(null,"uid","uid",192762127,null))))].join('')));
}

var newly_connected_QMARK_ = taoensso.encore.swap_in_BANG_.call(null,connected_uids_,cljs.core.PersistentVector.EMPTY,((function (packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (p__27681){
var map__27682 = p__27681;
var map__27682__$1 = ((((!((map__27682 == null)))?((((map__27682.cljs$lang$protocol_mask$partition0$ & (64))) || (map__27682.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27682):map__27682);
var old_m = map__27682__$1;
var ws = cljs.core.get.call(null,map__27682__$1,new cljs.core.Keyword(null,"ws","ws",86841443));
var ajax = cljs.core.get.call(null,map__27682__$1,new cljs.core.Keyword(null,"ajax","ajax",814345549));
var any = cljs.core.get.call(null,map__27682__$1,new cljs.core.Keyword(null,"any","any",1705907423));
var new_m = (function (){var G__27684 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__27684) {
case "ws":
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"ws","ws",86841443),cljs.core.conj.call(null,ws,uid),new cljs.core.Keyword(null,"ajax","ajax",814345549),ajax,new cljs.core.Keyword(null,"any","any",1705907423),cljs.core.conj.call(null,any,uid)], null);

break;
case "ajax":
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"ws","ws",86841443),ws,new cljs.core.Keyword(null,"ajax","ajax",814345549),cljs.core.conj.call(null,ajax,uid),new cljs.core.Keyword(null,"any","any",1705907423),cljs.core.conj.call(null,any,uid)], null);

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}
})();
return taoensso.encore.swapped.call(null,new_m,(function (){var old_any = new cljs.core.Keyword(null,"any","any",1705907423).cljs$core$IFn$_invoke$arity$1(old_m);
var new_any = new cljs.core.Keyword(null,"any","any",1705907423).cljs$core$IFn$_invoke$arity$1(new_m);
if((!(cljs.core.contains_QMARK_.call(null,old_any,uid))) && (cljs.core.contains_QMARK_.call(null,new_any,uid))){
return new cljs.core.Keyword(null,"newly-connected","newly-connected",-2029862681);
} else {
return null;
}
})());
});})(packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
);
return newly_connected_QMARK_;
});})(packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
;
var upd_connected_uid_BANG_ = ((function (packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (uid){
if((function (){
taoensso.encore.hcond.call(null,false,"taoensso.sente",null,(new cljs.core.Delay(((function (packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
return uid;
});})(packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,null)),new cljs.core.Symbol(null,"uid","uid",192762127,null),taoensso.encore.nnil_QMARK_,new cljs.core.Symbol("taoensso.encore","nnil?","taoensso.encore/nnil?",-1813154343,null));

return true;
})()
){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"have?","have?",-1685305646,null),new cljs.core.Symbol(null,"uid","uid",192762127,null))))].join('')));
}

var newly_disconnected_QMARK_ = taoensso.encore.swap_in_BANG_.call(null,connected_uids_,cljs.core.PersistentVector.EMPTY,((function (packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (p__27685){
var map__27686 = p__27685;
var map__27686__$1 = ((((!((map__27686 == null)))?((((map__27686.cljs$lang$protocol_mask$partition0$ & (64))) || (map__27686.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27686):map__27686);
var old_m = map__27686__$1;
var ws = cljs.core.get.call(null,map__27686__$1,new cljs.core.Keyword(null,"ws","ws",86841443));
var ajax = cljs.core.get.call(null,map__27686__$1,new cljs.core.Keyword(null,"ajax","ajax",814345549));
var any = cljs.core.get.call(null,map__27686__$1,new cljs.core.Keyword(null,"any","any",1705907423));
var conns_SINGLEQUOTE_ = cljs.core.deref.call(null,conns_);
var any_ws_clients_QMARK_ = cljs.core.contains_QMARK_.call(null,new cljs.core.Keyword(null,"ws","ws",86841443).cljs$core$IFn$_invoke$arity$1(conns_SINGLEQUOTE_),uid);
var any_ajax_clients_QMARK_ = cljs.core.contains_QMARK_.call(null,new cljs.core.Keyword(null,"ajax","ajax",814345549).cljs$core$IFn$_invoke$arity$1(conns_SINGLEQUOTE_),uid);
var any_clients_QMARK_ = (any_ws_clients_QMARK_) || (any_ajax_clients_QMARK_);
var new_m = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"ws","ws",86841443),((any_ws_clients_QMARK_)?cljs.core.conj.call(null,ws,uid):cljs.core.disj.call(null,ws,uid)),new cljs.core.Keyword(null,"ajax","ajax",814345549),((any_ajax_clients_QMARK_)?cljs.core.conj.call(null,ajax,uid):cljs.core.disj.call(null,ajax,uid)),new cljs.core.Keyword(null,"any","any",1705907423),((any_clients_QMARK_)?cljs.core.conj.call(null,any,uid):cljs.core.disj.call(null,any,uid))], null);
return taoensso.encore.swapped.call(null,new_m,(function (){var old_any = new cljs.core.Keyword(null,"any","any",1705907423).cljs$core$IFn$_invoke$arity$1(old_m);
var new_any = new cljs.core.Keyword(null,"any","any",1705907423).cljs$core$IFn$_invoke$arity$1(new_m);
if((cljs.core.contains_QMARK_.call(null,old_any,uid)) && (!(cljs.core.contains_QMARK_.call(null,new_any,uid)))){
return new cljs.core.Keyword(null,"newly-disconnected","newly-disconnected",-1586164962);
} else {
return null;
}
})());
});})(packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
);
return newly_disconnected_QMARK_;
});})(packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
;
var send_fn = ((function (packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function() { 
var G__27839__delegate = function (user_id,ev,p__27688){
var vec__27689 = p__27688;
var map__27690 = cljs.core.nth.call(null,vec__27689,(0),null);
var map__27690__$1 = ((((!((map__27690 == null)))?((((map__27690.cljs$lang$protocol_mask$partition0$ & (64))) || (map__27690.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27690):map__27690);
var opts = map__27690__$1;
var flush_QMARK_ = cljs.core.get.call(null,map__27690__$1,new cljs.core.Keyword(null,"flush?","flush?",-108887231));
var uid_27840 = ((cljs.core._EQ_.call(null,user_id,new cljs.core.Keyword("sente","all-users-without-uid","sente/all-users-without-uid",-42979578)))?new cljs.core.Keyword("taoensso.sente","nil-uid","taoensso.sente/nil-uid",-2111603486):user_id);
var __27841 = taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/tmp/form-init5145320441605965266.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),(new cljs.core.Delay(((function (uid_27840,vec__27689,map__27690,map__27690__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Chsk send: (->uid %s) %s",uid_27840,ev], null);
});})(uid_27840,vec__27689,map__27690,map__27690__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,null)),null);
var __27842__$1 = (cljs.core.truth_(uid_27840)?null:(function(){throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("Support for sending to `nil` user-ids has been REMOVED. "),cljs.core.str("Please send to `:sente/all-users-without-uid` instead.")].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"uid","uid",192762127,null)))].join('')))})());
var __27843__$2 = taoensso.sente.assert_event.call(null,ev);
var ev_uuid_27844 = taoensso.encore.uuid_str.call(null);
var flush_buffer_BANG__27845 = ((function (uid_27840,__27841,__27842__$1,__27843__$2,ev_uuid_27844,vec__27689,map__27690,map__27690__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (type){
var temp__4657__auto__ = taoensso.encore.swap_in_BANG_.call(null,send_buffers_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [type], null),((function (uid_27840,__27841,__27842__$1,__27843__$2,ev_uuid_27844,vec__27689,map__27690,map__27690__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (m){
var vec__27692 = cljs.core.get.call(null,m,uid_27840);
var ___$3 = cljs.core.nth.call(null,vec__27692,(0),null);
var ev_uuids = cljs.core.nth.call(null,vec__27692,(1),null);
if(cljs.core.contains_QMARK_.call(null,ev_uuids,ev_uuid_27844)){
return taoensso.encore.swapped.call(null,cljs.core.dissoc.call(null,m,uid_27840),cljs.core.get.call(null,m,uid_27840));
} else {
return taoensso.encore.swapped.call(null,m,null);
}
});})(uid_27840,__27841,__27842__$1,__27843__$2,ev_uuid_27844,vec__27689,map__27690,map__27690__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
);
if(cljs.core.truth_(temp__4657__auto__)){
var pulled = temp__4657__auto__;
var vec__27693 = pulled;
var buffered_evs = cljs.core.nth.call(null,vec__27693,(0),null);
var ev_uuids = cljs.core.nth.call(null,vec__27693,(1),null);
taoensso.encore.hcond.call(null,false,"taoensso.sente",null,(new cljs.core.Delay(((function (vec__27693,buffered_evs,ev_uuids,pulled,temp__4657__auto__,uid_27840,__27841,__27842__$1,__27843__$2,ev_uuid_27844,vec__27689,map__27690,map__27690__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
return buffered_evs;
});})(vec__27693,buffered_evs,ev_uuids,pulled,temp__4657__auto__,uid_27840,__27841,__27842__$1,__27843__$2,ev_uuid_27844,vec__27689,map__27690,map__27690__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,null)),new cljs.core.Symbol(null,"buffered-evs","buffered-evs",42083054,null),cljs.core.vector_QMARK_,new cljs.core.Symbol(null,"vector?","vector?",-61367869,null));


taoensso.encore.hcond.call(null,false,"taoensso.sente",null,(new cljs.core.Delay(((function (vec__27693,buffered_evs,ev_uuids,pulled,temp__4657__auto__,uid_27840,__27841,__27842__$1,__27843__$2,ev_uuid_27844,vec__27689,map__27690,map__27690__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
return ev_uuids;
});})(vec__27693,buffered_evs,ev_uuids,pulled,temp__4657__auto__,uid_27840,__27841,__27842__$1,__27843__$2,ev_uuid_27844,vec__27689,map__27690,map__27690__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,null)),new cljs.core.Symbol(null,"ev-uuids","ev-uuids",1824628525,null),cljs.core.set_QMARK_,new cljs.core.Symbol(null,"set?","set?",1636014792,null));


var packer_metas = cljs.core.mapv.call(null,cljs.core.meta,buffered_evs);
var combined_packer_meta = cljs.core.reduce.call(null,cljs.core.merge,cljs.core.PersistentArrayMap.EMPTY,packer_metas);
var buffered_evs_ppstr = taoensso.sente.pack.call(null,packer__$1,combined_packer_meta,buffered_evs);
taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/tmp/form-init5145320441605965266.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),(new cljs.core.Delay(((function (packer_metas,combined_packer_meta,buffered_evs_ppstr,vec__27693,buffered_evs,ev_uuids,pulled,temp__4657__auto__,uid_27840,__27841,__27842__$1,__27843__$2,ev_uuid_27844,vec__27689,map__27690,map__27690__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["buffered-evs-ppstr: %s (with meta %s)",buffered_evs_ppstr,combined_packer_meta], null);
});})(packer_metas,combined_packer_meta,buffered_evs_ppstr,vec__27693,buffered_evs,ev_uuids,pulled,temp__4657__auto__,uid_27840,__27841,__27842__$1,__27843__$2,ev_uuid_27844,vec__27689,map__27690,map__27690__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,null)),null);

var G__27694 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__27694) {
case "ws":
return taoensso.sente.send_buffered_server_evs_GT_ws_clients_BANG_.call(null,conns_,uid_27840,buffered_evs_ppstr);

break;
case "ajax":
return taoensso.sente.send_buffered_server_evs_GT_ajax_clients_BANG_.call(null,conns_,uid_27840,buffered_evs_ppstr);

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}
} else {
return null;
}
});})(uid_27840,__27841,__27842__$1,__27843__$2,ev_uuid_27844,vec__27689,map__27690,map__27690__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
;
if(cljs.core._EQ_.call(null,ev,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("chsk","close","chsk/close",1840295819)], null))){
taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"debug","debug",-1608172596),"taoensso.sente","/tmp/form-init5145320441605965266.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),(new cljs.core.Delay(((function (uid_27840,__27841,__27842__$1,__27843__$2,ev_uuid_27844,flush_buffer_BANG__27845,vec__27689,map__27690,map__27690__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Chsk closing (client may reconnect): %s",uid_27840], null);
});})(uid_27840,__27841,__27842__$1,__27843__$2,ev_uuid_27844,flush_buffer_BANG__27845,vec__27689,map__27690,map__27690__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,null)),null);

if(cljs.core.truth_(flush_QMARK_)){
var seq__27695_27847 = cljs.core.seq.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"ajax","ajax",814345549)], null));
var chunk__27696_27848 = null;
var count__27697_27849 = (0);
var i__27698_27850 = (0);
while(true){
if((i__27698_27850 < count__27697_27849)){
var type_27851 = cljs.core._nth.call(null,chunk__27696_27848,i__27698_27850);
flush_buffer_BANG__27845.call(null,type_27851);

var G__27852 = seq__27695_27847;
var G__27853 = chunk__27696_27848;
var G__27854 = count__27697_27849;
var G__27855 = (i__27698_27850 + (1));
seq__27695_27847 = G__27852;
chunk__27696_27848 = G__27853;
count__27697_27849 = G__27854;
i__27698_27850 = G__27855;
continue;
} else {
var temp__4657__auto___27856 = cljs.core.seq.call(null,seq__27695_27847);
if(temp__4657__auto___27856){
var seq__27695_27857__$1 = temp__4657__auto___27856;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__27695_27857__$1)){
var c__6852__auto___27858 = cljs.core.chunk_first.call(null,seq__27695_27857__$1);
var G__27859 = cljs.core.chunk_rest.call(null,seq__27695_27857__$1);
var G__27860 = c__6852__auto___27858;
var G__27861 = cljs.core.count.call(null,c__6852__auto___27858);
var G__27862 = (0);
seq__27695_27847 = G__27859;
chunk__27696_27848 = G__27860;
count__27697_27849 = G__27861;
i__27698_27850 = G__27862;
continue;
} else {
var type_27863 = cljs.core.first.call(null,seq__27695_27857__$1);
flush_buffer_BANG__27845.call(null,type_27863);

var G__27864 = cljs.core.next.call(null,seq__27695_27857__$1);
var G__27865 = null;
var G__27866 = (0);
var G__27867 = (0);
seq__27695_27847 = G__27864;
chunk__27696_27848 = G__27865;
count__27697_27849 = G__27866;
i__27698_27850 = G__27867;
continue;
}
} else {
}
}
break;
}
} else {
}

var seq__27699_27868 = cljs.core.seq.call(null,cljs.core.vals.call(null,cljs.core.get_in.call(null,cljs.core.deref.call(null,conns_),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ws","ws",86841443),uid_27840], null))));
var chunk__27700_27869 = null;
var count__27701_27870 = (0);
var i__27702_27871 = (0);
while(true){
if((i__27702_27871 < count__27701_27870)){
var server_ch_27872 = cljs.core._nth.call(null,chunk__27700_27869,i__27702_27871);
taoensso.sente.interfaces.sch_close_BANG_.call(null,server_ch_27872);

var G__27873 = seq__27699_27868;
var G__27874 = chunk__27700_27869;
var G__27875 = count__27701_27870;
var G__27876 = (i__27702_27871 + (1));
seq__27699_27868 = G__27873;
chunk__27700_27869 = G__27874;
count__27701_27870 = G__27875;
i__27702_27871 = G__27876;
continue;
} else {
var temp__4657__auto___27877 = cljs.core.seq.call(null,seq__27699_27868);
if(temp__4657__auto___27877){
var seq__27699_27878__$1 = temp__4657__auto___27877;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__27699_27878__$1)){
var c__6852__auto___27879 = cljs.core.chunk_first.call(null,seq__27699_27878__$1);
var G__27880 = cljs.core.chunk_rest.call(null,seq__27699_27878__$1);
var G__27881 = c__6852__auto___27879;
var G__27882 = cljs.core.count.call(null,c__6852__auto___27879);
var G__27883 = (0);
seq__27699_27868 = G__27880;
chunk__27700_27869 = G__27881;
count__27701_27870 = G__27882;
i__27702_27871 = G__27883;
continue;
} else {
var server_ch_27884 = cljs.core.first.call(null,seq__27699_27878__$1);
taoensso.sente.interfaces.sch_close_BANG_.call(null,server_ch_27884);

var G__27885 = cljs.core.next.call(null,seq__27699_27878__$1);
var G__27886 = null;
var G__27887 = (0);
var G__27888 = (0);
seq__27699_27868 = G__27885;
chunk__27700_27869 = G__27886;
count__27701_27870 = G__27887;
i__27702_27871 = G__27888;
continue;
}
} else {
}
}
break;
}

var seq__27703_27889 = cljs.core.seq.call(null,cljs.core.vals.call(null,cljs.core.get_in.call(null,cljs.core.deref.call(null,conns_),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ajax","ajax",814345549),uid_27840], null))));
var chunk__27704_27890 = null;
var count__27705_27891 = (0);
var i__27706_27892 = (0);
while(true){
if((i__27706_27892 < count__27705_27891)){
var vec__27707_27893 = cljs.core._nth.call(null,chunk__27704_27890,i__27706_27892);
var _QMARK_server_ch_27894 = cljs.core.nth.call(null,vec__27707_27893,(0),null);
var __27895__$3 = cljs.core.nth.call(null,vec__27707_27893,(1),null);
var temp__4657__auto___27896 = _QMARK_server_ch_27894;
if(cljs.core.truth_(temp__4657__auto___27896)){
var server_ch_27897 = temp__4657__auto___27896;
taoensso.sente.interfaces.sch_close_BANG_.call(null,server_ch_27897);
} else {
}

var G__27898 = seq__27703_27889;
var G__27899 = chunk__27704_27890;
var G__27900 = count__27705_27891;
var G__27901 = (i__27706_27892 + (1));
seq__27703_27889 = G__27898;
chunk__27704_27890 = G__27899;
count__27705_27891 = G__27900;
i__27706_27892 = G__27901;
continue;
} else {
var temp__4657__auto___27902 = cljs.core.seq.call(null,seq__27703_27889);
if(temp__4657__auto___27902){
var seq__27703_27903__$1 = temp__4657__auto___27902;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__27703_27903__$1)){
var c__6852__auto___27904 = cljs.core.chunk_first.call(null,seq__27703_27903__$1);
var G__27905 = cljs.core.chunk_rest.call(null,seq__27703_27903__$1);
var G__27906 = c__6852__auto___27904;
var G__27907 = cljs.core.count.call(null,c__6852__auto___27904);
var G__27908 = (0);
seq__27703_27889 = G__27905;
chunk__27704_27890 = G__27906;
count__27705_27891 = G__27907;
i__27706_27892 = G__27908;
continue;
} else {
var vec__27708_27909 = cljs.core.first.call(null,seq__27703_27903__$1);
var _QMARK_server_ch_27910 = cljs.core.nth.call(null,vec__27708_27909,(0),null);
var __27911__$3 = cljs.core.nth.call(null,vec__27708_27909,(1),null);
var temp__4657__auto___27912__$1 = _QMARK_server_ch_27910;
if(cljs.core.truth_(temp__4657__auto___27912__$1)){
var server_ch_27913 = temp__4657__auto___27912__$1;
taoensso.sente.interfaces.sch_close_BANG_.call(null,server_ch_27913);
} else {
}

var G__27914 = cljs.core.next.call(null,seq__27703_27903__$1);
var G__27915 = null;
var G__27916 = (0);
var G__27917 = (0);
seq__27703_27889 = G__27914;
chunk__27704_27890 = G__27915;
count__27705_27891 = G__27916;
i__27706_27892 = G__27917;
continue;
}
} else {
}
}
break;
}
} else {
var seq__27709_27918 = cljs.core.seq.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"ajax","ajax",814345549)], null));
var chunk__27710_27919 = null;
var count__27711_27920 = (0);
var i__27712_27921 = (0);
while(true){
if((i__27712_27921 < count__27711_27920)){
var type_27922 = cljs.core._nth.call(null,chunk__27710_27919,i__27712_27921);
taoensso.encore.swap_in_BANG_.call(null,send_buffers_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [type_27922,uid_27840], null),((function (seq__27709_27918,chunk__27710_27919,count__27711_27920,i__27712_27921,type_27922,uid_27840,__27841,__27842__$1,__27843__$2,ev_uuid_27844,flush_buffer_BANG__27845,vec__27689,map__27690,map__27690__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (_QMARK_v){
if(cljs.core.not.call(null,_QMARK_v)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ev], null),cljs.core.PersistentHashSet.fromArray([ev_uuid_27844], true)], null);
} else {
var vec__27713 = _QMARK_v;
var buffered_evs = cljs.core.nth.call(null,vec__27713,(0),null);
var ev_uuids = cljs.core.nth.call(null,vec__27713,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,buffered_evs,ev),cljs.core.conj.call(null,ev_uuids,ev_uuid_27844)], null);
}
});})(seq__27709_27918,chunk__27710_27919,count__27711_27920,i__27712_27921,type_27922,uid_27840,__27841,__27842__$1,__27843__$2,ev_uuid_27844,flush_buffer_BANG__27845,vec__27689,map__27690,map__27690__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
);

var G__27923 = seq__27709_27918;
var G__27924 = chunk__27710_27919;
var G__27925 = count__27711_27920;
var G__27926 = (i__27712_27921 + (1));
seq__27709_27918 = G__27923;
chunk__27710_27919 = G__27924;
count__27711_27920 = G__27925;
i__27712_27921 = G__27926;
continue;
} else {
var temp__4657__auto___27927 = cljs.core.seq.call(null,seq__27709_27918);
if(temp__4657__auto___27927){
var seq__27709_27928__$1 = temp__4657__auto___27927;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__27709_27928__$1)){
var c__6852__auto___27929 = cljs.core.chunk_first.call(null,seq__27709_27928__$1);
var G__27930 = cljs.core.chunk_rest.call(null,seq__27709_27928__$1);
var G__27931 = c__6852__auto___27929;
var G__27932 = cljs.core.count.call(null,c__6852__auto___27929);
var G__27933 = (0);
seq__27709_27918 = G__27930;
chunk__27710_27919 = G__27931;
count__27711_27920 = G__27932;
i__27712_27921 = G__27933;
continue;
} else {
var type_27934 = cljs.core.first.call(null,seq__27709_27928__$1);
taoensso.encore.swap_in_BANG_.call(null,send_buffers_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [type_27934,uid_27840], null),((function (seq__27709_27918,chunk__27710_27919,count__27711_27920,i__27712_27921,type_27934,seq__27709_27928__$1,temp__4657__auto___27927,uid_27840,__27841,__27842__$1,__27843__$2,ev_uuid_27844,flush_buffer_BANG__27845,vec__27689,map__27690,map__27690__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (_QMARK_v){
if(cljs.core.not.call(null,_QMARK_v)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ev], null),cljs.core.PersistentHashSet.fromArray([ev_uuid_27844], true)], null);
} else {
var vec__27714 = _QMARK_v;
var buffered_evs = cljs.core.nth.call(null,vec__27714,(0),null);
var ev_uuids = cljs.core.nth.call(null,vec__27714,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,buffered_evs,ev),cljs.core.conj.call(null,ev_uuids,ev_uuid_27844)], null);
}
});})(seq__27709_27918,chunk__27710_27919,count__27711_27920,i__27712_27921,type_27934,seq__27709_27928__$1,temp__4657__auto___27927,uid_27840,__27841,__27842__$1,__27843__$2,ev_uuid_27844,flush_buffer_BANG__27845,vec__27689,map__27690,map__27690__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
);

var G__27935 = cljs.core.next.call(null,seq__27709_27928__$1);
var G__27936 = null;
var G__27937 = (0);
var G__27938 = (0);
seq__27709_27918 = G__27935;
chunk__27710_27919 = G__27936;
count__27711_27920 = G__27937;
i__27712_27921 = G__27938;
continue;
}
} else {
}
}
break;
}

var c__14368__auto___27939 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto___27939,uid_27840,__27841,__27842__$1,__27843__$2,ev_uuid_27844,flush_buffer_BANG__27845,vec__27689,map__27690,map__27690__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto___27939,uid_27840,__27841,__27842__$1,__27843__$2,ev_uuid_27844,flush_buffer_BANG__27845,vec__27689,map__27690,map__27690__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (state_27724){
var state_val_27725 = (state_27724[(1)]);
if((state_val_27725 === (1))){
var state_27724__$1 = state_27724;
if(cljs.core.truth_(flush_QMARK_)){
var statearr_27726_27940 = state_27724__$1;
(statearr_27726_27940[(1)] = (2));

} else {
var statearr_27727_27941 = state_27724__$1;
(statearr_27727_27941[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27725 === (2))){
var state_27724__$1 = state_27724;
var statearr_27728_27942 = state_27724__$1;
(statearr_27728_27942[(2)] = null);

(statearr_27728_27942[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27725 === (3))){
var inst_27717 = cljs.core.async.timeout.call(null,send_buf_ms_ws);
var state_27724__$1 = state_27724;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27724__$1,(5),inst_27717);
} else {
if((state_val_27725 === (4))){
var inst_27721 = (state_27724[(2)]);
var inst_27722 = flush_buffer_BANG__27845.call(null,new cljs.core.Keyword(null,"ws","ws",86841443));
var state_27724__$1 = (function (){var statearr_27729 = state_27724;
(statearr_27729[(7)] = inst_27721);

return statearr_27729;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27724__$1,inst_27722);
} else {
if((state_val_27725 === (5))){
var inst_27719 = (state_27724[(2)]);
var state_27724__$1 = state_27724;
var statearr_27730_27943 = state_27724__$1;
(statearr_27730_27943[(2)] = inst_27719);

(statearr_27730_27943[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});})(c__14368__auto___27939,uid_27840,__27841,__27842__$1,__27843__$2,ev_uuid_27844,flush_buffer_BANG__27845,vec__27689,map__27690,map__27690__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
;
return ((function (switch__14236__auto__,c__14368__auto___27939,uid_27840,__27841,__27842__$1,__27843__$2,ev_uuid_27844,flush_buffer_BANG__27845,vec__27689,map__27690,map__27690__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function() {
var taoensso$sente$state_machine__14237__auto__ = null;
var taoensso$sente$state_machine__14237__auto____0 = (function (){
var statearr_27734 = [null,null,null,null,null,null,null,null];
(statearr_27734[(0)] = taoensso$sente$state_machine__14237__auto__);

(statearr_27734[(1)] = (1));

return statearr_27734;
});
var taoensso$sente$state_machine__14237__auto____1 = (function (state_27724){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_27724);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e27735){if((e27735 instanceof Object)){
var ex__14240__auto__ = e27735;
var statearr_27736_27944 = state_27724;
(statearr_27736_27944[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27724);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27735;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27945 = state_27724;
state_27724 = G__27945;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
taoensso$sente$state_machine__14237__auto__ = function(state_27724){
switch(arguments.length){
case 0:
return taoensso$sente$state_machine__14237__auto____0.call(this);
case 1:
return taoensso$sente$state_machine__14237__auto____1.call(this,state_27724);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
taoensso$sente$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = taoensso$sente$state_machine__14237__auto____0;
taoensso$sente$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = taoensso$sente$state_machine__14237__auto____1;
return taoensso$sente$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto___27939,uid_27840,__27841,__27842__$1,__27843__$2,ev_uuid_27844,flush_buffer_BANG__27845,vec__27689,map__27690,map__27690__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
})();
var state__14370__auto__ = (function (){var statearr_27737 = f__14369__auto__.call(null);
(statearr_27737[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto___27939);

return statearr_27737;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto___27939,uid_27840,__27841,__27842__$1,__27843__$2,ev_uuid_27844,flush_buffer_BANG__27845,vec__27689,map__27690,map__27690__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
);


var c__14368__auto___27946 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto___27946,uid_27840,__27841,__27842__$1,__27843__$2,ev_uuid_27844,flush_buffer_BANG__27845,vec__27689,map__27690,map__27690__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto___27946,uid_27840,__27841,__27842__$1,__27843__$2,ev_uuid_27844,flush_buffer_BANG__27845,vec__27689,map__27690,map__27690__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (state_27747){
var state_val_27748 = (state_27747[(1)]);
if((state_val_27748 === (1))){
var state_27747__$1 = state_27747;
if(cljs.core.truth_(flush_QMARK_)){
var statearr_27749_27947 = state_27747__$1;
(statearr_27749_27947[(1)] = (2));

} else {
var statearr_27750_27948 = state_27747__$1;
(statearr_27750_27948[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27748 === (2))){
var state_27747__$1 = state_27747;
var statearr_27751_27949 = state_27747__$1;
(statearr_27751_27949[(2)] = null);

(statearr_27751_27949[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27748 === (3))){
var inst_27740 = cljs.core.async.timeout.call(null,send_buf_ms_ajax);
var state_27747__$1 = state_27747;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27747__$1,(5),inst_27740);
} else {
if((state_val_27748 === (4))){
var inst_27744 = (state_27747[(2)]);
var inst_27745 = flush_buffer_BANG__27845.call(null,new cljs.core.Keyword(null,"ajax","ajax",814345549));
var state_27747__$1 = (function (){var statearr_27752 = state_27747;
(statearr_27752[(7)] = inst_27744);

return statearr_27752;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27747__$1,inst_27745);
} else {
if((state_val_27748 === (5))){
var inst_27742 = (state_27747[(2)]);
var state_27747__$1 = state_27747;
var statearr_27753_27950 = state_27747__$1;
(statearr_27753_27950[(2)] = inst_27742);

(statearr_27753_27950[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});})(c__14368__auto___27946,uid_27840,__27841,__27842__$1,__27843__$2,ev_uuid_27844,flush_buffer_BANG__27845,vec__27689,map__27690,map__27690__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
;
return ((function (switch__14236__auto__,c__14368__auto___27946,uid_27840,__27841,__27842__$1,__27843__$2,ev_uuid_27844,flush_buffer_BANG__27845,vec__27689,map__27690,map__27690__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function() {
var taoensso$sente$state_machine__14237__auto__ = null;
var taoensso$sente$state_machine__14237__auto____0 = (function (){
var statearr_27757 = [null,null,null,null,null,null,null,null];
(statearr_27757[(0)] = taoensso$sente$state_machine__14237__auto__);

(statearr_27757[(1)] = (1));

return statearr_27757;
});
var taoensso$sente$state_machine__14237__auto____1 = (function (state_27747){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_27747);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e27758){if((e27758 instanceof Object)){
var ex__14240__auto__ = e27758;
var statearr_27759_27951 = state_27747;
(statearr_27759_27951[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27747);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27758;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27952 = state_27747;
state_27747 = G__27952;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
taoensso$sente$state_machine__14237__auto__ = function(state_27747){
switch(arguments.length){
case 0:
return taoensso$sente$state_machine__14237__auto____0.call(this);
case 1:
return taoensso$sente$state_machine__14237__auto____1.call(this,state_27747);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
taoensso$sente$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = taoensso$sente$state_machine__14237__auto____0;
taoensso$sente$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = taoensso$sente$state_machine__14237__auto____1;
return taoensso$sente$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto___27946,uid_27840,__27841,__27842__$1,__27843__$2,ev_uuid_27844,flush_buffer_BANG__27845,vec__27689,map__27690,map__27690__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
})();
var state__14370__auto__ = (function (){var statearr_27760 = f__14369__auto__.call(null);
(statearr_27760[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto___27946);

return statearr_27760;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto___27946,uid_27840,__27841,__27842__$1,__27843__$2,ev_uuid_27844,flush_buffer_BANG__27845,vec__27689,map__27690,map__27690__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
);

}

return null;
};
var G__27839 = function (user_id,ev,var_args){
var p__27688 = null;
if (arguments.length > 2) {
var G__27953__i = 0, G__27953__a = new Array(arguments.length -  2);
while (G__27953__i < G__27953__a.length) {G__27953__a[G__27953__i] = arguments[G__27953__i + 2]; ++G__27953__i;}
  p__27688 = new cljs.core.IndexedSeq(G__27953__a,0);
} 
return G__27839__delegate.call(this,user_id,ev,p__27688);};
G__27839.cljs$lang$maxFixedArity = 2;
G__27839.cljs$lang$applyTo = (function (arglist__27954){
var user_id = cljs.core.first(arglist__27954);
arglist__27954 = cljs.core.next(arglist__27954);
var ev = cljs.core.first(arglist__27954);
var p__27688 = cljs.core.rest(arglist__27954);
return G__27839__delegate(user_id,ev,p__27688);
});
G__27839.cljs$core$IFn$_invoke$arity$variadic = G__27839__delegate;
return G__27839;
})()
;})(packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
;
var ev_msg_const = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861),ch_recv,new cljs.core.Keyword(null,"send-fn","send-fn",351002041),send_fn,new cljs.core.Keyword(null,"connected-uids","connected-uids",1454332231),connected_uids_], null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861),ch_recv,new cljs.core.Keyword(null,"send-fn","send-fn",351002041),send_fn,new cljs.core.Keyword(null,"connected-uids","connected-uids",1454332231),connected_uids_,new cljs.core.Keyword(null,"ajax-post-fn","ajax-post-fn",1830071264),((function (packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (ring_req){
return taoensso.sente.interfaces.ring_req__GT_server_ch_resp.call(null,web_server_adapter,ring_req,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-open","on-open",-1391088163),((function (packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (server_ch){
var params = cljs.core.get.call(null,ring_req,new cljs.core.Keyword(null,"params","params",710516235));
var ppstr = cljs.core.get.call(null,params,new cljs.core.Keyword(null,"ppstr","ppstr",1557495252));
var client_id = cljs.core.get.call(null,params,new cljs.core.Keyword(null,"client-id","client-id",-464622140));
var vec__27761 = taoensso.sente.unpack.call(null,packer__$1,ppstr);
var clj = cljs.core.nth.call(null,vec__27761,(0),null);
var has_cb_QMARK_ = cljs.core.nth.call(null,vec__27761,(1),null);
taoensso.sente.put_server_event_msg_GT_ch_recv_BANG_.call(null,ch_recv,cljs.core.merge.call(null,ev_msg_const,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"client-id","client-id",-464622140),client_id,new cljs.core.Keyword(null,"ring-req","ring-req",-747861961),ring_req,new cljs.core.Keyword(null,"event","event",301435442),clj,new cljs.core.Keyword(null,"uid","uid",-1447769400),user_id_fn__$1.call(null,ring_req,client_id),new cljs.core.Keyword(null,"?reply-fn","?reply-fn",-1479510592),(cljs.core.truth_(has_cb_QMARK_)?((function (params,ppstr,client_id,vec__27761,clj,has_cb_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function taoensso$sente$reply_fn(resp_clj){
taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/tmp/form-init5145320441605965266.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),(new cljs.core.Delay(((function (params,ppstr,client_id,vec__27761,clj,has_cb_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Chsk send (ajax reply): %s",resp_clj], null);
});})(params,ppstr,client_id,vec__27761,clj,has_cb_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,null)),null);

return taoensso.sente.interfaces.sch_send_BANG_.call(null,server_ch,taoensso.sente.pack.call(null,packer__$1,cljs.core.meta.call(null,resp_clj),resp_clj),new cljs.core.Keyword(null,"close-after-send","close-after-send",1264946103));
});})(params,ppstr,client_id,vec__27761,clj,has_cb_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
:null)], null)));

if(cljs.core.truth_(has_cb_QMARK_)){
return null;
} else {
taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/tmp/form-init5145320441605965266.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),(new cljs.core.Delay(((function (params,ppstr,client_id,vec__27761,clj,has_cb_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Chsk send (ajax reply): dummy-cb-200"], null);
});})(params,ppstr,client_id,vec__27761,clj,has_cb_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,null)),null);

return taoensso.sente.interfaces.sch_send_BANG_.call(null,server_ch,taoensso.sente.pack.call(null,packer__$1,null,new cljs.core.Keyword("chsk","dummy-cb-200","chsk/dummy-cb-200",-1663130337)),new cljs.core.Keyword(null,"close-after-send","close-after-send",1264946103));
}
});})(packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
], null));
});})(packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,new cljs.core.Keyword(null,"ajax-get-or-ws-handshake-fn","ajax-get-or-ws-handshake-fn",-1210409233),((function (packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (ring_req){
var csrf_token = csrf_token_fn.call(null,ring_req);
var params = cljs.core.get.call(null,ring_req,new cljs.core.Keyword(null,"params","params",710516235));
var client_id = cljs.core.get.call(null,params,new cljs.core.Keyword(null,"client-id","client-id",-464622140));
var uid = user_id_fn__$1.call(null,ring_req,client_id);
var websocket_QMARK_ = new cljs.core.Keyword(null,"websocket?","websocket?",1552493139).cljs$core$IFn$_invoke$arity$1(ring_req);
var receive_event_msg_BANG_ = ((function (csrf_token,params,client_id,uid,websocket_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function() { 
var G__27955__delegate = function (event,p__27762){
var vec__27763 = p__27762;
var _QMARK_reply_fn = cljs.core.nth.call(null,vec__27763,(0),null);
return taoensso.sente.put_server_event_msg_GT_ch_recv_BANG_.call(null,ch_recv,cljs.core.merge.call(null,ev_msg_const,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"client-id","client-id",-464622140),client_id,new cljs.core.Keyword(null,"ring-req","ring-req",-747861961),ring_req,new cljs.core.Keyword(null,"event","event",301435442),event,new cljs.core.Keyword(null,"?reply-fn","?reply-fn",-1479510592),_QMARK_reply_fn,new cljs.core.Keyword(null,"uid","uid",-1447769400),uid], null)));
};
var G__27955 = function (event,var_args){
var p__27762 = null;
if (arguments.length > 1) {
var G__27956__i = 0, G__27956__a = new Array(arguments.length -  1);
while (G__27956__i < G__27956__a.length) {G__27956__a[G__27956__i] = arguments[G__27956__i + 1]; ++G__27956__i;}
  p__27762 = new cljs.core.IndexedSeq(G__27956__a,0);
} 
return G__27955__delegate.call(this,event,p__27762);};
G__27955.cljs$lang$maxFixedArity = 1;
G__27955.cljs$lang$applyTo = (function (arglist__27957){
var event = cljs.core.first(arglist__27957);
var p__27762 = cljs.core.rest(arglist__27957);
return G__27955__delegate(event,p__27762);
});
G__27955.cljs$core$IFn$_invoke$arity$variadic = G__27955__delegate;
return G__27955;
})()
;})(csrf_token,params,client_id,uid,websocket_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
;
var handshake_BANG_ = ((function (csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (server_ch){
taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/tmp/form-init5145320441605965266.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),(new cljs.core.Delay(((function (csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Handshake!"], null);
});})(csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,null)),null);

var _QMARK_handshake_data = handshake_data_fn.call(null,ring_req);
var handshake_ev = ((!((_QMARK_handshake_data == null)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("chsk","handshake","chsk/handshake",64910686),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [uid,csrf_token,_QMARK_handshake_data], null)], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("chsk","handshake","chsk/handshake",64910686),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [uid,csrf_token], null)], null));
return taoensso.sente.interfaces.sch_send_BANG_.call(null,server_ch,taoensso.sente.pack.call(null,packer__$1,null,handshake_ev),cljs.core.not.call(null,websocket_QMARK_));
});})(csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
;
if(clojure.string.blank_QMARK_.call(null,client_id)){
var err_msg = "Client's Ring request doesn't have a client id. Does your server have the necessary keyword Ring middleware (`wrap-params` & `wrap-keyword-params`)?";
taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"error","error",-978969032),"taoensso.sente","/tmp/form-init5145320441605965266.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),(new cljs.core.Delay(((function (err_msg,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str(err_msg),cljs.core.str(": %s")].join(''),ring_req], null);
});})(err_msg,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,null)),null);

throw cljs.core.ex_info.call(null,err_msg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"ring-req","ring-req",-747861961),ring_req], null));
} else {
return taoensso.sente.interfaces.ring_req__GT_server_ch_resp.call(null,web_server_adapter,ring_req,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"on-open","on-open",-1391088163),((function (csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (server_ch){
if(cljs.core.truth_(websocket_QMARK_)){
taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/tmp/form-init5145320441605965266.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),(new cljs.core.Delay(((function (csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["New WebSocket channel: %s (%s)",uid,[cljs.core.str(server_ch)].join('')], null);
});})(csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,null)),null);

taoensso.encore.reset_in_BANG_.call(null,conns_,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ws","ws",86841443),uid,client_id], null),server_ch);

if(cljs.core.truth_(connect_uid_BANG_.call(null,new cljs.core.Keyword(null,"ws","ws",86841443),uid))){
receive_event_msg_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("chsk","uidport-open","chsk/uidport-open",1685786954)], null));
} else {
}

return handshake_BANG_.call(null,server_ch);
} else {
var initial_conn_from_client_QMARK_ = taoensso.encore.swap_in_BANG_.call(null,conns_,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ajax","ajax",814345549),uid,client_id], null),((function (csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (_QMARK_v){
return taoensso.encore.swapped.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [server_ch,taoensso.encore.now_udt.call(null)], null),(_QMARK_v == null));
});})(csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
);
var handshake_QMARK_ = (function (){var or__6049__auto__ = initial_conn_from_client_QMARK_;
if(cljs.core.truth_(or__6049__auto__)){
return or__6049__auto__;
} else {
return new cljs.core.Keyword(null,"handshake?","handshake?",-423743093).cljs$core$IFn$_invoke$arity$1(params);
}
})();
if(cljs.core.truth_(connect_uid_BANG_.call(null,new cljs.core.Keyword(null,"ajax","ajax",814345549),uid))){
receive_event_msg_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("chsk","uidport-open","chsk/uidport-open",1685786954)], null));
} else {
}

if(cljs.core.truth_(handshake_QMARK_)){
return handshake_BANG_.call(null,server_ch);
} else {
return null;
}
}
});})(csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,new cljs.core.Keyword(null,"on-msg","on-msg",-2021925279),((function (csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (server_ch,req_ppstr){
var vec__27764 = taoensso.sente.unpack.call(null,packer__$1,req_ppstr);
var clj = cljs.core.nth.call(null,vec__27764,(0),null);
var _QMARK_cb_uuid = cljs.core.nth.call(null,vec__27764,(1),null);
return receive_event_msg_BANG_.call(null,clj,(cljs.core.truth_(_QMARK_cb_uuid)?((function (vec__27764,clj,_QMARK_cb_uuid,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function taoensso$sente$reply_fn(resp_clj){
taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/tmp/form-init5145320441605965266.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),(new cljs.core.Delay(((function (vec__27764,clj,_QMARK_cb_uuid,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Chsk send (ws reply): %s",resp_clj], null);
});})(vec__27764,clj,_QMARK_cb_uuid,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,null)),null);

return taoensso.sente.interfaces.sch_send_BANG_.call(null,server_ch,taoensso.sente.pack.call(null,packer__$1,cljs.core.meta.call(null,resp_clj),resp_clj,_QMARK_cb_uuid));
});})(vec__27764,clj,_QMARK_cb_uuid,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
:null));
});})(csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,new cljs.core.Keyword(null,"on-close","on-close",-761178394),((function (csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (server_ch,status){
if(cljs.core.truth_(websocket_QMARK_)){
taoensso.encore.swap_in_BANG_.call(null,conns_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ws","ws",86841443),uid], null),((function (csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (_QMARK_m){
var new_m = cljs.core.dissoc.call(null,_QMARK_m,client_id);
if(cljs.core.empty_QMARK_.call(null,new_m)){
return new cljs.core.Keyword("swap","dissoc","swap/dissoc",-605373782);
} else {
return new_m;
}
});})(csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
);

var c__14368__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto__,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto__,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (state_27778){
var state_val_27779 = (state_27778[(1)]);
if((state_val_27779 === (1))){
var inst_27765 = cljs.core.async.timeout.call(null,(5000));
var state_27778__$1 = state_27778;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27778__$1,(2),inst_27765);
} else {
if((state_val_27779 === (2))){
var inst_27767 = (state_27778[(2)]);
var inst_27768 = upd_connected_uid_BANG_.call(null,uid);
var state_27778__$1 = (function (){var statearr_27780 = state_27778;
(statearr_27780[(7)] = inst_27767);

return statearr_27780;
})();
if(cljs.core.truth_(inst_27768)){
var statearr_27781_27958 = state_27778__$1;
(statearr_27781_27958[(1)] = (3));

} else {
var statearr_27782_27959 = state_27778__$1;
(statearr_27782_27959[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27779 === (3))){
var inst_27770 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27771 = [new cljs.core.Keyword("chsk","uidport-close","chsk/uidport-close",901058678)];
var inst_27772 = (new cljs.core.PersistentVector(null,1,(5),inst_27770,inst_27771,null));
var inst_27773 = receive_event_msg_BANG_.call(null,inst_27772);
var state_27778__$1 = state_27778;
var statearr_27783_27960 = state_27778__$1;
(statearr_27783_27960[(2)] = inst_27773);

(statearr_27783_27960[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27779 === (4))){
var state_27778__$1 = state_27778;
var statearr_27784_27961 = state_27778__$1;
(statearr_27784_27961[(2)] = null);

(statearr_27784_27961[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27779 === (5))){
var inst_27776 = (state_27778[(2)]);
var state_27778__$1 = state_27778;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27778__$1,inst_27776);
} else {
return null;
}
}
}
}
}
});})(c__14368__auto__,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
;
return ((function (switch__14236__auto__,c__14368__auto__,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function() {
var taoensso$sente$state_machine__14237__auto__ = null;
var taoensso$sente$state_machine__14237__auto____0 = (function (){
var statearr_27788 = [null,null,null,null,null,null,null,null];
(statearr_27788[(0)] = taoensso$sente$state_machine__14237__auto__);

(statearr_27788[(1)] = (1));

return statearr_27788;
});
var taoensso$sente$state_machine__14237__auto____1 = (function (state_27778){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_27778);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e27789){if((e27789 instanceof Object)){
var ex__14240__auto__ = e27789;
var statearr_27790_27962 = state_27778;
(statearr_27790_27962[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27778);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27789;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27963 = state_27778;
state_27778 = G__27963;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
taoensso$sente$state_machine__14237__auto__ = function(state_27778){
switch(arguments.length){
case 0:
return taoensso$sente$state_machine__14237__auto____0.call(this);
case 1:
return taoensso$sente$state_machine__14237__auto____1.call(this,state_27778);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
taoensso$sente$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = taoensso$sente$state_machine__14237__auto____0;
taoensso$sente$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = taoensso$sente$state_machine__14237__auto____1;
return taoensso$sente$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto__,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
})();
var state__14370__auto__ = (function (){var statearr_27791 = f__14369__auto__.call(null);
(statearr_27791[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto__);

return statearr_27791;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto__,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
);

return c__14368__auto__;
} else {
taoensso.encore.swap_in_BANG_.call(null,conns_,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [uid,new cljs.core.Keyword(null,"ajax","ajax",814345549),client_id], null),((function (csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (p__27792){
var vec__27793 = p__27792;
var server_ch__$1 = cljs.core.nth.call(null,vec__27793,(0),null);
var udt_last_connected = cljs.core.nth.call(null,vec__27793,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,udt_last_connected], null);
});})(csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
);

var udt_disconnected = taoensso.encore.now_udt.call(null);
var c__14368__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto__,udt_disconnected,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto__,udt_disconnected,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (state_27816){
var state_val_27817 = (state_27816[(1)]);
if((state_val_27817 === (1))){
var inst_27794 = cljs.core.async.timeout.call(null,(5000));
var state_27816__$1 = state_27816;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27816__$1,(2),inst_27794);
} else {
if((state_val_27817 === (2))){
var inst_27796 = (state_27816[(2)]);
var inst_27797 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27798 = [new cljs.core.Keyword(null,"ajax","ajax",814345549),uid];
var inst_27799 = (new cljs.core.PersistentVector(null,2,(5),inst_27797,inst_27798,null));
var inst_27800 = (function (){return ((function (inst_27796,inst_27797,inst_27798,inst_27799,state_val_27817,c__14368__auto__,udt_disconnected,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (_QMARK_m){
var vec__27818 = cljs.core.get.call(null,_QMARK_m,client_id);
var _ = cljs.core.nth.call(null,vec__27818,(0),null);
var _QMARK_udt_last_connected = cljs.core.nth.call(null,vec__27818,(1),null);
var disconnected_QMARK_ = (function (){var and__6037__auto__ = _QMARK_udt_last_connected;
if(cljs.core.truth_(and__6037__auto__)){
return (udt_disconnected >= _QMARK_udt_last_connected);
} else {
return and__6037__auto__;
}
})();
if(cljs.core.not.call(null,disconnected_QMARK_)){
return taoensso.encore.swapped.call(null,_QMARK_m,cljs.core.not.call(null,new cljs.core.Keyword(null,"disconnected","disconnected",-1908014586)));
} else {
var new_m = cljs.core.dissoc.call(null,_QMARK_m,client_id);
return taoensso.encore.swapped.call(null,((cljs.core.empty_QMARK_.call(null,new_m))?new cljs.core.Keyword("swap","dissoc","swap/dissoc",-605373782):new_m),new cljs.core.Keyword(null,"disconnected","disconnected",-1908014586));
}
});
;})(inst_27796,inst_27797,inst_27798,inst_27799,state_val_27817,c__14368__auto__,udt_disconnected,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
})();
var inst_27801 = taoensso.encore.swap_in_BANG_.call(null,conns_,inst_27799,inst_27800);
var state_27816__$1 = (function (){var statearr_27819 = state_27816;
(statearr_27819[(7)] = inst_27796);

return statearr_27819;
})();
if(cljs.core.truth_(inst_27801)){
var statearr_27820_27964 = state_27816__$1;
(statearr_27820_27964[(1)] = (3));

} else {
var statearr_27821_27965 = state_27816__$1;
(statearr_27821_27965[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27817 === (3))){
var inst_27803 = upd_connected_uid_BANG_.call(null,uid);
var state_27816__$1 = state_27816;
if(cljs.core.truth_(inst_27803)){
var statearr_27822_27966 = state_27816__$1;
(statearr_27822_27966[(1)] = (6));

} else {
var statearr_27823_27967 = state_27816__$1;
(statearr_27823_27967[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27817 === (4))){
var state_27816__$1 = state_27816;
var statearr_27824_27968 = state_27816__$1;
(statearr_27824_27968[(2)] = null);

(statearr_27824_27968[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27817 === (5))){
var inst_27814 = (state_27816[(2)]);
var state_27816__$1 = state_27816;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27816__$1,inst_27814);
} else {
if((state_val_27817 === (6))){
var inst_27805 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27806 = [new cljs.core.Keyword("chsk","uidport-close","chsk/uidport-close",901058678)];
var inst_27807 = (new cljs.core.PersistentVector(null,1,(5),inst_27805,inst_27806,null));
var inst_27808 = receive_event_msg_BANG_.call(null,inst_27807);
var state_27816__$1 = state_27816;
var statearr_27825_27969 = state_27816__$1;
(statearr_27825_27969[(2)] = inst_27808);

(statearr_27825_27969[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27817 === (7))){
var state_27816__$1 = state_27816;
var statearr_27826_27970 = state_27816__$1;
(statearr_27826_27970[(2)] = null);

(statearr_27826_27970[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27817 === (8))){
var inst_27811 = (state_27816[(2)]);
var state_27816__$1 = state_27816;
var statearr_27827_27971 = state_27816__$1;
(statearr_27827_27971[(2)] = inst_27811);

(statearr_27827_27971[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__14368__auto__,udt_disconnected,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
;
return ((function (switch__14236__auto__,c__14368__auto__,udt_disconnected,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function() {
var taoensso$sente$state_machine__14237__auto__ = null;
var taoensso$sente$state_machine__14237__auto____0 = (function (){
var statearr_27831 = [null,null,null,null,null,null,null,null];
(statearr_27831[(0)] = taoensso$sente$state_machine__14237__auto__);

(statearr_27831[(1)] = (1));

return statearr_27831;
});
var taoensso$sente$state_machine__14237__auto____1 = (function (state_27816){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_27816);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e27832){if((e27832 instanceof Object)){
var ex__14240__auto__ = e27832;
var statearr_27833_27972 = state_27816;
(statearr_27833_27972[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27816);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27832;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27973 = state_27816;
state_27816 = G__27973;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
taoensso$sente$state_machine__14237__auto__ = function(state_27816){
switch(arguments.length){
case 0:
return taoensso$sente$state_machine__14237__auto____0.call(this);
case 1:
return taoensso$sente$state_machine__14237__auto____1.call(this,state_27816);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
taoensso$sente$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = taoensso$sente$state_machine__14237__auto____0;
taoensso$sente$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = taoensso$sente$state_machine__14237__auto____1;
return taoensso$sente$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto__,udt_disconnected,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
})();
var state__14370__auto__ = (function (){var statearr_27834 = f__14369__auto__.call(null);
(statearr_27834[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto__);

return statearr_27834;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto__,udt_disconnected,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
);

return c__14368__auto__;
}
});})(csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
], null));
}
});})(packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__27677,map__27678,map__27678__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
], null);
});

taoensso.sente.make_channel_socket_server_BANG_.cljs$lang$maxFixedArity = (1);

taoensso.sente.make_channel_socket_server_BANG_.cljs$lang$applyTo = (function (seq27674){
var G__27675 = cljs.core.first.call(null,seq27674);
var seq27674__$1 = cljs.core.next.call(null,seq27674);
return taoensso.sente.make_channel_socket_server_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__27675,seq27674__$1);
});
/**
 * Actually pushes buffered events (as packed-str) to all uid's WebSocket conns.
 */
taoensso.sente.send_buffered_server_evs_GT_ws_clients_BANG_ = (function taoensso$sente$send_buffered_server_evs_GT_ws_clients_BANG_(conns_,uid,buffered_evs_pstr){
taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/tmp/form-init5145320441605965266.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["send-buffered-server-evs>ws-clients!: %s",buffered_evs_pstr], null);
}),null)),null);

var seq__27978 = cljs.core.seq.call(null,cljs.core.vals.call(null,cljs.core.get_in.call(null,cljs.core.deref.call(null,conns_),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ws","ws",86841443),uid], null))));
var chunk__27979 = null;
var count__27980 = (0);
var i__27981 = (0);
while(true){
if((i__27981 < count__27980)){
var server_ch = cljs.core._nth.call(null,chunk__27979,i__27981);
taoensso.sente.interfaces.sch_send_BANG_.call(null,server_ch,buffered_evs_pstr);

var G__27982 = seq__27978;
var G__27983 = chunk__27979;
var G__27984 = count__27980;
var G__27985 = (i__27981 + (1));
seq__27978 = G__27982;
chunk__27979 = G__27983;
count__27980 = G__27984;
i__27981 = G__27985;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__27978);
if(temp__4657__auto__){
var seq__27978__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__27978__$1)){
var c__6852__auto__ = cljs.core.chunk_first.call(null,seq__27978__$1);
var G__27986 = cljs.core.chunk_rest.call(null,seq__27978__$1);
var G__27987 = c__6852__auto__;
var G__27988 = cljs.core.count.call(null,c__6852__auto__);
var G__27989 = (0);
seq__27978 = G__27986;
chunk__27979 = G__27987;
count__27980 = G__27988;
i__27981 = G__27989;
continue;
} else {
var server_ch = cljs.core.first.call(null,seq__27978__$1);
taoensso.sente.interfaces.sch_send_BANG_.call(null,server_ch,buffered_evs_pstr);

var G__27990 = cljs.core.next.call(null,seq__27978__$1);
var G__27991 = null;
var G__27992 = (0);
var G__27993 = (0);
seq__27978 = G__27990;
chunk__27979 = G__27991;
count__27980 = G__27992;
i__27981 = G__27993;
continue;
}
} else {
return null;
}
}
break;
}
});
/**
 * Actually pushes buffered events (as packed-str) to all uid's Ajax conns.
 *   Allows some time for possible Ajax poller reconnects.
 */
taoensso.sente.send_buffered_server_evs_GT_ajax_clients_BANG_ = (function taoensso$sente$send_buffered_server_evs_GT_ajax_clients_BANG_(var_args){
var args__7114__auto__ = [];
var len__7107__auto___28078 = arguments.length;
var i__7108__auto___28079 = (0);
while(true){
if((i__7108__auto___28079 < len__7107__auto___28078)){
args__7114__auto__.push((arguments[i__7108__auto___28079]));

var G__28080 = (i__7108__auto___28079 + (1));
i__7108__auto___28079 = G__28080;
continue;
} else {
}
break;
}

var argseq__7115__auto__ = ((((3) < args__7114__auto__.length))?(new cljs.core.IndexedSeq(args__7114__auto__.slice((3)),(0))):null);
return taoensso.sente.send_buffered_server_evs_GT_ajax_clients_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7115__auto__);
});

taoensso.sente.send_buffered_server_evs_GT_ajax_clients_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (conns_,uid,buffered_evs_pstr,p__27998){
var vec__27999 = p__27998;
var map__28000 = cljs.core.nth.call(null,vec__27999,(0),null);
var map__28000__$1 = ((((!((map__28000 == null)))?((((map__28000.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28000.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28000):map__28000);
var nmax_attempts = cljs.core.get.call(null,map__28000__$1,new cljs.core.Keyword(null,"nmax-attempts","nmax-attempts",1471144610),(7));
var ms_base = cljs.core.get.call(null,map__28000__$1,new cljs.core.Keyword(null,"ms-base","ms-base",-1962784511),(90));
var ms_rand = cljs.core.get.call(null,map__28000__$1,new cljs.core.Keyword(null,"ms-rand","ms-rand",1169398874),(90));

taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/tmp/form-init5145320441605965266.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),(new cljs.core.Delay(((function (vec__27999,map__28000,map__28000__$1,nmax_attempts,ms_base,ms_rand){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["send-buffered-server-evs>ajax-clients!: %s",buffered_evs_pstr], null);
});})(vec__27999,map__28000,map__28000__$1,nmax_attempts,ms_base,ms_rand))
,null)),null);

var client_ids_unsatisfied = cljs.core.keys.call(null,cljs.core.get_in.call(null,cljs.core.deref.call(null,conns_),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ajax","ajax",814345549),uid], null)));
if(cljs.core.empty_QMARK_.call(null,client_ids_unsatisfied)){
return null;
} else {
var c__14368__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto__,client_ids_unsatisfied,vec__27999,map__28000,map__28000__$1,nmax_attempts,ms_base,ms_rand){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto__,client_ids_unsatisfied,vec__27999,map__28000,map__28000__$1,nmax_attempts,ms_base,ms_rand){
return (function (state_28049){
var state_val_28050 = (state_28049[(1)]);
if((state_val_28050 === (7))){
var inst_28027 = (state_28049[(7)]);
var inst_28030 = cljs.core.complement.call(null,inst_28027);
var inst_28031 = cljs.core.some.call(null,inst_28030,client_ids_unsatisfied);
var state_28049__$1 = state_28049;
var statearr_28051_28081 = state_28049__$1;
(statearr_28051_28081[(2)] = inst_28031);

(statearr_28051_28081[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28050 === (1))){
var inst_28002 = cljs.core.PersistentHashSet.EMPTY;
var inst_28003 = (0);
var inst_28004 = inst_28002;
var state_28049__$1 = (function (){var statearr_28052 = state_28049;
(statearr_28052[(8)] = inst_28003);

(statearr_28052[(9)] = inst_28004);

return statearr_28052;
})();
var statearr_28053_28082 = state_28049__$1;
(statearr_28053_28082[(2)] = null);

(statearr_28053_28082[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28050 === (4))){
var inst_28003 = (state_28049[(8)]);
var inst_28004 = (state_28049[(9)]);
var inst_28010 = (state_28049[(10)]);
var inst_28021 = (function (){var n = inst_28003;
var client_ids_satisfied = inst_28004;
var _QMARK_pulled = inst_28010;
return ((function (n,client_ids_satisfied,_QMARK_pulled,inst_28003,inst_28004,inst_28010,state_val_28050,c__14368__auto__,client_ids_unsatisfied,vec__27999,map__28000,map__28000__$1,nmax_attempts,ms_base,ms_rand){
return (function (s,client_id,p__28020){
var vec__28054 = p__28020;
var _QMARK_server_ch = cljs.core.nth.call(null,vec__28054,(0),null);
var _ = cljs.core.nth.call(null,vec__28054,(1),null);
if(((_QMARK_server_ch == null)) || (cljs.core.not.call(null,taoensso.sente.interfaces.sch_send_BANG_.call(null,_QMARK_server_ch,buffered_evs_pstr,new cljs.core.Keyword(null,"close-after-send","close-after-send",1264946103))))){
return s;
} else {
return cljs.core.conj.call(null,s,client_id);
}
});
;})(n,client_ids_satisfied,_QMARK_pulled,inst_28003,inst_28004,inst_28010,state_val_28050,c__14368__auto__,client_ids_unsatisfied,vec__27999,map__28000,map__28000__$1,nmax_attempts,ms_base,ms_rand))
})();
var inst_28022 = cljs.core.PersistentHashSet.EMPTY;
var inst_28023 = cljs.core.reduce_kv.call(null,inst_28021,inst_28022,inst_28010);
var state_28049__$1 = state_28049;
var statearr_28055_28083 = state_28049__$1;
(statearr_28055_28083[(2)] = inst_28023);

(statearr_28055_28083[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28050 === (13))){
var inst_28003 = (state_28049[(8)]);
var inst_28027 = (state_28049[(7)]);
var inst_28040 = (state_28049[(2)]);
var inst_28041 = (inst_28003 + (1));
var inst_28003__$1 = inst_28041;
var inst_28004 = inst_28027;
var state_28049__$1 = (function (){var statearr_28056 = state_28049;
(statearr_28056[(8)] = inst_28003__$1);

(statearr_28056[(9)] = inst_28004);

(statearr_28056[(11)] = inst_28040);

return statearr_28056;
})();
var statearr_28057_28084 = state_28049__$1;
(statearr_28057_28084[(2)] = null);

(statearr_28057_28084[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28050 === (6))){
var inst_28003 = (state_28049[(8)]);
var inst_28028 = (state_28049[(12)]);
var inst_28004 = (state_28049[(9)]);
var inst_28026 = (state_28049[(2)]);
var inst_28027 = cljs.core.into.call(null,inst_28004,inst_28026);
var inst_28028__$1 = (inst_28003 < nmax_attempts);
var state_28049__$1 = (function (){var statearr_28058 = state_28049;
(statearr_28058[(12)] = inst_28028__$1);

(statearr_28058[(7)] = inst_28027);

return statearr_28058;
})();
if(cljs.core.truth_(inst_28028__$1)){
var statearr_28059_28085 = state_28049__$1;
(statearr_28059_28085[(1)] = (7));

} else {
var statearr_28060_28086 = state_28049__$1;
(statearr_28060_28086[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28050 === (3))){
var inst_28047 = (state_28049[(2)]);
var state_28049__$1 = state_28049;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28049__$1,inst_28047);
} else {
if((state_val_28050 === (12))){
var inst_28045 = (state_28049[(2)]);
var state_28049__$1 = state_28049;
var statearr_28061_28087 = state_28049__$1;
(statearr_28061_28087[(2)] = inst_28045);

(statearr_28061_28087[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28050 === (2))){
var inst_28003 = (state_28049[(8)]);
var inst_28004 = (state_28049[(9)]);
var inst_28010 = (state_28049[(10)]);
var inst_28006 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28007 = [new cljs.core.Keyword(null,"ajax","ajax",814345549),uid];
var inst_28008 = (new cljs.core.PersistentVector(null,2,(5),inst_28006,inst_28007,null));
var inst_28009 = (function (){var n = inst_28003;
var client_ids_satisfied = inst_28004;
return ((function (n,client_ids_satisfied,inst_28003,inst_28004,inst_28010,inst_28006,inst_28007,inst_28008,state_val_28050,c__14368__auto__,client_ids_unsatisfied,vec__27999,map__28000,map__28000__$1,nmax_attempts,ms_base,ms_rand){
return (function (m){
var ks_to_pull = cljs.core.remove.call(null,client_ids_satisfied,cljs.core.keys.call(null,m));
if(cljs.core.empty_QMARK_.call(null,ks_to_pull)){
return taoensso.encore.swapped.call(null,m,null);
} else {
return taoensso.encore.swapped.call(null,cljs.core.reduce.call(null,((function (ks_to_pull,n,client_ids_satisfied,inst_28003,inst_28004,inst_28010,inst_28006,inst_28007,inst_28008,state_val_28050,c__14368__auto__,client_ids_unsatisfied,vec__27999,map__28000,map__28000__$1,nmax_attempts,ms_base,ms_rand){
return (function (m__$1,k){
var vec__28062 = cljs.core.get.call(null,m__$1,k);
var _QMARK_server_ch = cljs.core.nth.call(null,vec__28062,(0),null);
var udt_last_connected = cljs.core.nth.call(null,vec__28062,(1),null);
return cljs.core.assoc.call(null,m__$1,k,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,udt_last_connected], null));
});})(ks_to_pull,n,client_ids_satisfied,inst_28003,inst_28004,inst_28010,inst_28006,inst_28007,inst_28008,state_val_28050,c__14368__auto__,client_ids_unsatisfied,vec__27999,map__28000,map__28000__$1,nmax_attempts,ms_base,ms_rand))
,m,ks_to_pull),cljs.core.select_keys.call(null,m,ks_to_pull));
}
});
;})(n,client_ids_satisfied,inst_28003,inst_28004,inst_28010,inst_28006,inst_28007,inst_28008,state_val_28050,c__14368__auto__,client_ids_unsatisfied,vec__27999,map__28000,map__28000__$1,nmax_attempts,ms_base,ms_rand))
})();
var inst_28010__$1 = taoensso.encore.swap_in_BANG_.call(null,conns_,inst_28008,inst_28009);
var inst_28011 = (function (){var n = inst_28003;
var client_ids_satisfied = inst_28004;
var _QMARK_pulled = inst_28010__$1;
return ((function (n,client_ids_satisfied,_QMARK_pulled,inst_28003,inst_28004,inst_28010,inst_28006,inst_28007,inst_28008,inst_28009,inst_28010__$1,state_val_28050,c__14368__auto__,client_ids_unsatisfied,vec__27999,map__28000,map__28000__$1,nmax_attempts,ms_base,ms_rand){
return (function (){
return _QMARK_pulled;
});
;})(n,client_ids_satisfied,_QMARK_pulled,inst_28003,inst_28004,inst_28010,inst_28006,inst_28007,inst_28008,inst_28009,inst_28010__$1,state_val_28050,c__14368__auto__,client_ids_unsatisfied,vec__27999,map__28000,map__28000__$1,nmax_attempts,ms_base,ms_rand))
})();
var inst_28012 = (new cljs.core.Delay(inst_28011,null));
var inst_28013 = new cljs.core.Symbol(null,"?pulled","?pulled",-1428161534,null);
var inst_28014 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28015 = [new cljs.core.Keyword(null,"or","or",235744169),cljs.core.nil_QMARK_,cljs.core.map_QMARK_];
var inst_28016 = (new cljs.core.PersistentVector(null,3,(5),inst_28014,inst_28015,null));
var inst_28017 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"or","or",235744169),new cljs.core.Symbol(null,"nil?","nil?",1612038930,null),new cljs.core.Symbol(null,"map?","map?",-1780568534,null)], null);
var inst_28018 = taoensso.encore.hcond.call(null,false,"taoensso.sente",null,inst_28012,inst_28013,inst_28016,inst_28017);
var state_28049__$1 = (function (){var statearr_28063 = state_28049;
(statearr_28063[(13)] = inst_28018);

(statearr_28063[(10)] = inst_28010__$1);

return statearr_28063;
})();
if(cljs.core.truth_(inst_28010__$1)){
var statearr_28064_28088 = state_28049__$1;
(statearr_28064_28088[(1)] = (4));

} else {
var statearr_28065_28089 = state_28049__$1;
(statearr_28065_28089[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28050 === (11))){
var state_28049__$1 = state_28049;
var statearr_28066_28090 = state_28049__$1;
(statearr_28066_28090[(2)] = null);

(statearr_28066_28090[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28050 === (9))){
var inst_28034 = (state_28049[(2)]);
var state_28049__$1 = state_28049;
if(cljs.core.truth_(inst_28034)){
var statearr_28067_28091 = state_28049__$1;
(statearr_28067_28091[(1)] = (10));

} else {
var statearr_28068_28092 = state_28049__$1;
(statearr_28068_28092[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28050 === (5))){
var state_28049__$1 = state_28049;
var statearr_28069_28093 = state_28049__$1;
(statearr_28069_28093[(2)] = null);

(statearr_28069_28093[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28050 === (10))){
var inst_28036 = cljs.core.rand_int.call(null,ms_rand);
var inst_28037 = (ms_base + inst_28036);
var inst_28038 = cljs.core.async.timeout.call(null,inst_28037);
var state_28049__$1 = state_28049;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28049__$1,(13),inst_28038);
} else {
if((state_val_28050 === (8))){
var inst_28028 = (state_28049[(12)]);
var state_28049__$1 = state_28049;
var statearr_28070_28094 = state_28049__$1;
(statearr_28070_28094[(2)] = inst_28028);

(statearr_28070_28094[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14368__auto__,client_ids_unsatisfied,vec__27999,map__28000,map__28000__$1,nmax_attempts,ms_base,ms_rand))
;
return ((function (switch__14236__auto__,c__14368__auto__,client_ids_unsatisfied,vec__27999,map__28000,map__28000__$1,nmax_attempts,ms_base,ms_rand){
return (function() {
var taoensso$sente$state_machine__14237__auto__ = null;
var taoensso$sente$state_machine__14237__auto____0 = (function (){
var statearr_28074 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28074[(0)] = taoensso$sente$state_machine__14237__auto__);

(statearr_28074[(1)] = (1));

return statearr_28074;
});
var taoensso$sente$state_machine__14237__auto____1 = (function (state_28049){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_28049);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e28075){if((e28075 instanceof Object)){
var ex__14240__auto__ = e28075;
var statearr_28076_28095 = state_28049;
(statearr_28076_28095[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28049);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28075;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28096 = state_28049;
state_28049 = G__28096;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
taoensso$sente$state_machine__14237__auto__ = function(state_28049){
switch(arguments.length){
case 0:
return taoensso$sente$state_machine__14237__auto____0.call(this);
case 1:
return taoensso$sente$state_machine__14237__auto____1.call(this,state_28049);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
taoensso$sente$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = taoensso$sente$state_machine__14237__auto____0;
taoensso$sente$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = taoensso$sente$state_machine__14237__auto____1;
return taoensso$sente$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto__,client_ids_unsatisfied,vec__27999,map__28000,map__28000__$1,nmax_attempts,ms_base,ms_rand))
})();
var state__14370__auto__ = (function (){var statearr_28077 = f__14369__auto__.call(null);
(statearr_28077[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto__);

return statearr_28077;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto__,client_ids_unsatisfied,vec__27999,map__28000,map__28000__$1,nmax_attempts,ms_base,ms_rand))
);

return c__14368__auto__;
}
});

taoensso.sente.send_buffered_server_evs_GT_ajax_clients_BANG_.cljs$lang$maxFixedArity = (3);

taoensso.sente.send_buffered_server_evs_GT_ajax_clients_BANG_.cljs$lang$applyTo = (function (seq27994){
var G__27995 = cljs.core.first.call(null,seq27994);
var seq27994__$1 = cljs.core.next.call(null,seq27994);
var G__27996 = cljs.core.first.call(null,seq27994__$1);
var seq27994__$2 = cljs.core.next.call(null,seq27994__$1);
var G__27997 = cljs.core.first.call(null,seq27994__$2);
var seq27994__$3 = cljs.core.next.call(null,seq27994__$2);
return taoensso.sente.send_buffered_server_evs_GT_ajax_clients_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__27995,G__27996,G__27997,seq27994__$3);
});
/**
 * Alias of `taoensso.encore/ajax-lite`
 */
taoensso.sente.ajax_lite = taoensso.encore.ajax_lite;

/**
 * @interface
 */
taoensso.sente.IChSocket = function(){};

/**
 * Implementation detail
 */
taoensso.sente._chsk_connect_BANG_ = (function taoensso$sente$_chsk_connect_BANG_(chsk){
if((!((chsk == null))) && (!((chsk.taoensso$sente$IChSocket$_chsk_connect_BANG_$arity$1 == null)))){
return chsk.taoensso$sente$IChSocket$_chsk_connect_BANG_$arity$1(chsk);
} else {
var x__6704__auto__ = (((chsk == null))?null:chsk);
var m__6705__auto__ = (taoensso.sente._chsk_connect_BANG_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,chsk);
} else {
var m__6705__auto____$1 = (taoensso.sente._chsk_connect_BANG_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,chsk);
} else {
throw cljs.core.missing_protocol.call(null,"IChSocket.-chsk-connect!",chsk);
}
}
}
});

/**
 * Implementation detail
 */
taoensso.sente._chsk_send_BANG_ = (function taoensso$sente$_chsk_send_BANG_(chsk,ev,opts){
if((!((chsk == null))) && (!((chsk.taoensso$sente$IChSocket$_chsk_send_BANG_$arity$3 == null)))){
return chsk.taoensso$sente$IChSocket$_chsk_send_BANG_$arity$3(chsk,ev,opts);
} else {
var x__6704__auto__ = (((chsk == null))?null:chsk);
var m__6705__auto__ = (taoensso.sente._chsk_send_BANG_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,chsk,ev,opts);
} else {
var m__6705__auto____$1 = (taoensso.sente._chsk_send_BANG_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,chsk,ev,opts);
} else {
throw cljs.core.missing_protocol.call(null,"IChSocket.-chsk-send!",chsk);
}
}
}
});

/**
 * DEPRECATED: Please use `chsk-disconnect!` instead
 */
taoensso.sente.chsk_destroy_BANG_ = (function taoensso$sente$chsk_destroy_BANG_(chsk){
if((!((chsk == null))) && (!((chsk.taoensso$sente$IChSocket$chsk_destroy_BANG_$arity$1 == null)))){
return chsk.taoensso$sente$IChSocket$chsk_destroy_BANG_$arity$1(chsk);
} else {
var x__6704__auto__ = (((chsk == null))?null:chsk);
var m__6705__auto__ = (taoensso.sente.chsk_destroy_BANG_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,chsk);
} else {
var m__6705__auto____$1 = (taoensso.sente.chsk_destroy_BANG_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,chsk);
} else {
throw cljs.core.missing_protocol.call(null,"IChSocket.chsk-destroy!",chsk);
}
}
}
});

/**
 * Disconnects channel socket
 */
taoensso.sente.chsk_disconnect_BANG_ = (function taoensso$sente$chsk_disconnect_BANG_(chsk){
if((!((chsk == null))) && (!((chsk.taoensso$sente$IChSocket$chsk_disconnect_BANG_$arity$1 == null)))){
return chsk.taoensso$sente$IChSocket$chsk_disconnect_BANG_$arity$1(chsk);
} else {
var x__6704__auto__ = (((chsk == null))?null:chsk);
var m__6705__auto__ = (taoensso.sente.chsk_disconnect_BANG_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,chsk);
} else {
var m__6705__auto____$1 = (taoensso.sente.chsk_disconnect_BANG_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,chsk);
} else {
throw cljs.core.missing_protocol.call(null,"IChSocket.chsk-disconnect!",chsk);
}
}
}
});

/**
 * Reconnects channel socket (useful for reauthenticating after login/logout, etc.)
 */
taoensso.sente.chsk_reconnect_BANG_ = (function taoensso$sente$chsk_reconnect_BANG_(chsk){
if((!((chsk == null))) && (!((chsk.taoensso$sente$IChSocket$chsk_reconnect_BANG_$arity$1 == null)))){
return chsk.taoensso$sente$IChSocket$chsk_reconnect_BANG_$arity$1(chsk);
} else {
var x__6704__auto__ = (((chsk == null))?null:chsk);
var m__6705__auto__ = (taoensso.sente.chsk_reconnect_BANG_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,chsk);
} else {
var m__6705__auto____$1 = (taoensso.sente.chsk_reconnect_BANG_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,chsk);
} else {
throw cljs.core.missing_protocol.call(null,"IChSocket.chsk-reconnect!",chsk);
}
}
}
});

/**
 * Sends `[ev-id ev-?data :as event]`, returns true on apparent success.
 */
taoensso.sente.chsk_send_BANG_ = (function taoensso$sente$chsk_send_BANG_(var_args){
var args28097 = [];
var len__7107__auto___28100 = arguments.length;
var i__7108__auto___28101 = (0);
while(true){
if((i__7108__auto___28101 < len__7107__auto___28100)){
args28097.push((arguments[i__7108__auto___28101]));

var G__28102 = (i__7108__auto___28101 + (1));
i__7108__auto___28101 = G__28102;
continue;
} else {
}
break;
}

var G__28099 = args28097.length;
switch (G__28099) {
case 2:
return taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 3:
return taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28097.length)].join('')));

}
});

taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (chsk,ev){
return taoensso.sente.chsk_send_BANG_.call(null,chsk,ev,cljs.core.PersistentArrayMap.EMPTY);
});

taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (chsk,ev,_QMARK_timeout_ms,_QMARK_cb){
return taoensso.sente.chsk_send_BANG_.call(null,chsk,ev,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406),_QMARK_timeout_ms,new cljs.core.Keyword(null,"cb","cb",589947841),_QMARK_cb], null));
});

taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (chsk,ev,opts){
taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/tmp/form-init5145320441605965266.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Chsk send: (%s) %s",cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"cb","cb",589947841),cljs.core.boolean$.call(null,new cljs.core.Keyword(null,"cb","cb",589947841).cljs$core$IFn$_invoke$arity$1(opts))),ev], null);
}),null)),null);

return taoensso.sente._chsk_send_BANG_.call(null,chsk,ev,opts);
});

taoensso.sente.chsk_send_BANG_.cljs$lang$maxFixedArity = 4;
taoensso.sente.assert_send_args = (function taoensso$sente$assert_send_args(x,_QMARK_timeout_ms,_QMARK_cb){
taoensso.sente.assert_event.call(null,x);

if(cljs.core.truth_((function (){var or__6049__auto__ = ((_QMARK_timeout_ms == null)) && ((_QMARK_cb == null));
if(or__6049__auto__){
return or__6049__auto__;
} else {
return taoensso.encore.nneg_int_QMARK_.call(null,_QMARK_timeout_ms);
}
})())){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(taoensso.encore.format.call(null,"cb requires a timeout; timeout-ms should be a +ive integer: %s",_QMARK_timeout_ms)),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"or","or",1876275696,null),cljs.core.list(new cljs.core.Symbol(null,"and","and",668631710,null),cljs.core.list(new cljs.core.Symbol(null,"nil?","nil?",1612038930,null),new cljs.core.Symbol(null,"?timeout-ms","?timeout-ms",-651193632,null)),cljs.core.list(new cljs.core.Symbol(null,"nil?","nil?",1612038930,null),new cljs.core.Symbol(null,"?cb","?cb",-1346810436,null))),cljs.core.list(new cljs.core.Symbol(null,"and","and",668631710,null),cljs.core.list(new cljs.core.Symbol("enc","nneg-int?","enc/nneg-int?",803640858,null),new cljs.core.Symbol(null,"?timeout-ms","?timeout-ms",-651193632,null))))))].join('')));
}

if(cljs.core.truth_((function (){var or__6049__auto__ = (_QMARK_cb == null);
if(or__6049__auto__){
return or__6049__auto__;
} else {
var or__6049__auto____$1 = cljs.core.ifn_QMARK_.call(null,_QMARK_cb);
if(or__6049__auto____$1){
return or__6049__auto____$1;
} else {
return taoensso.encore.chan_QMARK_.call(null,_QMARK_cb);
}
}
})())){
return null;
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(taoensso.encore.format.call(null,"cb should be nil, an ifn, or a channel: %s",cljs.core.type.call(null,_QMARK_cb))),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"or","or",1876275696,null),cljs.core.list(new cljs.core.Symbol(null,"nil?","nil?",1612038930,null),new cljs.core.Symbol(null,"?cb","?cb",-1346810436,null)),cljs.core.list(new cljs.core.Symbol(null,"ifn?","ifn?",-2106461064,null),new cljs.core.Symbol(null,"?cb","?cb",-1346810436,null)),cljs.core.list(new cljs.core.Symbol("enc","chan?","enc/chan?",1377166,null),new cljs.core.Symbol(null,"?cb","?cb",-1346810436,null)))))].join('')));
}
});
taoensso.sente.pull_unused_cb_fn_BANG_ = (function taoensso$sente$pull_unused_cb_fn_BANG_(cbs_waiting_,_QMARK_cb_uuid){
var temp__4657__auto__ = _QMARK_cb_uuid;
if(cljs.core.truth_(temp__4657__auto__)){
var cb_uuid = temp__4657__auto__;
return taoensso.encore.swap_in_BANG_.call(null,cbs_waiting_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cb_uuid], null),((function (cb_uuid,temp__4657__auto__){
return (function (_QMARK_f){
return taoensso.encore.swapped.call(null,new cljs.core.Keyword("swap","dissoc","swap/dissoc",-605373782),_QMARK_f);
});})(cb_uuid,temp__4657__auto__))
);
} else {
return null;
}
});
taoensso.sente.merge_GT_chsk_state_BANG_ = (function taoensso$sente$merge_GT_chsk_state_BANG_(p__28104,merge_state){
var map__28108 = p__28104;
var map__28108__$1 = ((((!((map__28108 == null)))?((((map__28108.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28108.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28108):map__28108);
var chsk = map__28108__$1;
var chs = cljs.core.get.call(null,map__28108__$1,new cljs.core.Keyword(null,"chs","chs",376886120));
var state_ = cljs.core.get.call(null,map__28108__$1,new cljs.core.Keyword(null,"state_","state_",957667102));
var vec__28110 = taoensso.encore.swap_in_BANG_.call(null,state_,cljs.core.PersistentVector.EMPTY,((function (map__28108,map__28108__$1,chsk,chs,state_){
return (function (old_state){
var new_state = cljs.core.merge.call(null,old_state,merge_state);
var new_state__$1 = ((cljs.core.not.call(null,(function (){var and__6037__auto__ = new cljs.core.Keyword(null,"requested-reconnect-pending?","requested-reconnect-pending?",-299841116).cljs$core$IFn$_invoke$arity$1(old_state);
if(cljs.core.truth_(and__6037__auto__)){
var and__6037__auto____$1 = new cljs.core.Keyword(null,"open?","open?",1238443125).cljs$core$IFn$_invoke$arity$1(new_state);
if(cljs.core.truth_(and__6037__auto____$1)){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"open?","open?",1238443125).cljs$core$IFn$_invoke$arity$1(old_state));
} else {
return and__6037__auto____$1;
}
} else {
return and__6037__auto__;
}
})()))?new_state:cljs.core.assoc.call(null,cljs.core.dissoc.call(null,new_state,new cljs.core.Keyword(null,"requested-reconnect-pending?","requested-reconnect-pending?",-299841116)),new cljs.core.Keyword(null,"requested-reconnect?","requested-reconnect?",-1504983666),true));
return taoensso.encore.swapped.call(null,new_state__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [old_state,new_state__$1], null));
});})(map__28108,map__28108__$1,chsk,chs,state_))
);
var old_state = cljs.core.nth.call(null,vec__28110,(0),null);
var new_state = cljs.core.nth.call(null,vec__28110,(1),null);
if(cljs.core.not_EQ_.call(null,old_state,new_state)){
cljs.core.async.put_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(chs),new_state);

return new_state;
} else {
return null;
}
});
/**
 * Experimental, undocumented. Allows a core.async channel to be provided
 *   instead of a cb-fn. The channel will receive values of form
 *   [<event-id>.cb <reply>].
 */
taoensso.sente.cb_chan_as_fn = (function taoensso$sente$cb_chan_as_fn(_QMARK_cb,ev){
if(((_QMARK_cb == null)) || (cljs.core.ifn_QMARK_.call(null,_QMARK_cb))){
return _QMARK_cb;
} else {
taoensso.encore.hcond.call(null,false,"taoensso.sente",null,(new cljs.core.Delay((function (){
return _QMARK_cb;
}),null)),new cljs.core.Symbol(null,"?cb","?cb",-1346810436,null),taoensso.encore.chan_QMARK_,new cljs.core.Symbol("enc","chan?","enc/chan?",1377166,null));


taoensso.sente.assert_event.call(null,ev);

var vec__28112 = ev;
var ev_id = cljs.core.nth.call(null,vec__28112,(0),null);
var _ = cljs.core.nth.call(null,vec__28112,(1),null);
var cb_ch = _QMARK_cb;
return ((function (vec__28112,ev_id,_,cb_ch){
return (function (reply){
return cljs.core.async.put_BANG_.call(null,cb_ch,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.call(null,[cljs.core.str(taoensso.encore.fq_name.call(null,ev_id)),cljs.core.str(".cb")].join('')),reply], null));
});
;})(vec__28112,ev_id,_,cb_ch))
}
});
taoensso.sente.receive_buffered_evs_BANG_ = (function taoensso$sente$receive_buffered_evs_BANG_(chs,clj){
taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/tmp/form-init5145320441605965266.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["receive-buffered-evs!: %s",clj], null);
}),null)),null);

var buffered_evs = taoensso.encore.hcond.call(null,false,"taoensso.sente",704,(new cljs.core.Delay((function (){
return clj;
}),null)),new cljs.core.Symbol(null,"clj","clj",980036099,null),cljs.core.vector_QMARK_,new cljs.core.Symbol(null,"vector?","vector?",-61367869,null));
var seq__28117 = cljs.core.seq.call(null,buffered_evs);
var chunk__28118 = null;
var count__28119 = (0);
var i__28120 = (0);
while(true){
if((i__28120 < count__28119)){
var ev = cljs.core._nth.call(null,chunk__28118,i__28120);
taoensso.sente.assert_event.call(null,ev);

cljs.core.async.put_BANG_.call(null,new cljs.core.Keyword(null,"<server","<server",-2135373537).cljs$core$IFn$_invoke$arity$1(chs),ev);

var G__28121 = seq__28117;
var G__28122 = chunk__28118;
var G__28123 = count__28119;
var G__28124 = (i__28120 + (1));
seq__28117 = G__28121;
chunk__28118 = G__28122;
count__28119 = G__28123;
i__28120 = G__28124;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__28117);
if(temp__4657__auto__){
var seq__28117__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__28117__$1)){
var c__6852__auto__ = cljs.core.chunk_first.call(null,seq__28117__$1);
var G__28125 = cljs.core.chunk_rest.call(null,seq__28117__$1);
var G__28126 = c__6852__auto__;
var G__28127 = cljs.core.count.call(null,c__6852__auto__);
var G__28128 = (0);
seq__28117 = G__28125;
chunk__28118 = G__28126;
count__28119 = G__28127;
i__28120 = G__28128;
continue;
} else {
var ev = cljs.core.first.call(null,seq__28117__$1);
taoensso.sente.assert_event.call(null,ev);

cljs.core.async.put_BANG_.call(null,new cljs.core.Keyword(null,"<server","<server",-2135373537).cljs$core$IFn$_invoke$arity$1(chs),ev);

var G__28129 = cljs.core.next.call(null,seq__28117__$1);
var G__28130 = null;
var G__28131 = (0);
var G__28132 = (0);
seq__28117 = G__28129;
chunk__28118 = G__28130;
count__28119 = G__28131;
i__28120 = G__28132;
continue;
}
} else {
return null;
}
}
break;
}
});
taoensso.sente.handle_when_handshake_BANG_ = (function taoensso$sente$handle_when_handshake_BANG_(chsk,chs,clj){
var handshake_QMARK_ = (cljs.core.vector_QMARK_.call(null,clj)) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,clj),new cljs.core.Keyword("chsk","handshake","chsk/handshake",64910686)));
taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/tmp/form-init5145320441605965266.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),(new cljs.core.Delay(((function (handshake_QMARK_){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["handle-when-handshake (%s): %s",((handshake_QMARK_)?new cljs.core.Keyword(null,"handshake","handshake",68079331):new cljs.core.Keyword(null,"non-handshake","non-handshake",576986062)),clj], null);
});})(handshake_QMARK_))
,null)),null);

if(handshake_QMARK_){
var vec__28135 = clj;
var _ = cljs.core.nth.call(null,vec__28135,(0),null);
var vec__28136 = cljs.core.nth.call(null,vec__28135,(1),null);
var _QMARK_uid = cljs.core.nth.call(null,vec__28136,(0),null);
var _QMARK_csrf_token = cljs.core.nth.call(null,vec__28136,(1),null);
var _QMARK_handshake_data = cljs.core.nth.call(null,vec__28136,(2),null);
var handshake_ev = vec__28135;
if(clojure.string.blank_QMARK_.call(null,_QMARK_csrf_token)){
taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente","/tmp/form-init5145320441605965266.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),(new cljs.core.Delay(((function (vec__28135,_,vec__28136,_QMARK_uid,_QMARK_csrf_token,_QMARK_handshake_data,handshake_ev,handshake_QMARK_){
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["SECURITY WARNING: no CSRF token available for use by Sente"], null);
});})(vec__28135,_,vec__28136,_QMARK_uid,_QMARK_csrf_token,_QMARK_handshake_data,handshake_ev,handshake_QMARK_))
,null)),null);
} else {
}

taoensso.sente.merge_GT_chsk_state_BANG_.call(null,chsk,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"open?","open?",1238443125),true,new cljs.core.Keyword(null,"uid","uid",-1447769400),_QMARK_uid,new cljs.core.Keyword(null,"csrf-token","csrf-token",-1872302856),_QMARK_csrf_token], null));

taoensso.sente.assert_event.call(null,handshake_ev);

cljs.core.async.put_BANG_.call(null,new cljs.core.Keyword(null,"internal","internal",-854870097).cljs$core$IFn$_invoke$arity$1(chs),handshake_ev);

return new cljs.core.Keyword(null,"handled","handled",1889700151);
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {taoensso.sente.IChSocket}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
taoensso.sente.ChWebSocket = (function (client_id,chs,params,packer,url,state_,cbs_waiting_,socket_,kalive_ms,kalive_timer_,kalive_due_QMARK__,backoff_ms_fn,active_retry_id_,retry_count_,__meta,__extmap,__hash){
this.client_id = client_id;
this.chs = chs;
this.params = params;
this.packer = packer;
this.url = url;
this.state_ = state_;
this.cbs_waiting_ = cbs_waiting_;
this.socket_ = socket_;
this.kalive_ms = kalive_ms;
this.kalive_timer_ = kalive_timer_;
this.kalive_due_QMARK__ = kalive_due_QMARK__;
this.backoff_ms_fn = backoff_ms_fn;
this.active_retry_id_ = active_retry_id_;
this.retry_count_ = retry_count_;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
taoensso.sente.ChWebSocket.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__6663__auto__,k__6664__auto__){
var self__ = this;
var this__6663__auto____$1 = this;
return cljs.core._lookup.call(null,this__6663__auto____$1,k__6664__auto__,null);
});

taoensso.sente.ChWebSocket.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__6665__auto__,k28138,else__6666__auto__){
var self__ = this;
var this__6665__auto____$1 = this;
var G__28140 = (((k28138 instanceof cljs.core.Keyword))?k28138.fqn:null);
switch (G__28140) {
case "client-id":
return self__.client_id;

break;
case "kalive-ms":
return self__.kalive_ms;

break;
case "packer":
return self__.packer;

break;
case "chs":
return self__.chs;

break;
case "params":
return self__.params;

break;
case "retry-count_":
return self__.retry_count_;

break;
case "backoff-ms-fn":
return self__.backoff_ms_fn;

break;
case "socket_":
return self__.socket_;

break;
case "url":
return self__.url;

break;
case "active-retry-id_":
return self__.active_retry_id_;

break;
case "kalive-due?_":
return self__.kalive_due_QMARK__;

break;
case "cbs-waiting_":
return self__.cbs_waiting_;

break;
case "kalive-timer_":
return self__.kalive_timer_;

break;
case "state_":
return self__.state_;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k28138,else__6666__auto__);

}
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__6677__auto__,writer__6678__auto__,opts__6679__auto__){
var self__ = this;
var this__6677__auto____$1 = this;
var pr_pair__6680__auto__ = ((function (this__6677__auto____$1){
return (function (keyval__6681__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__6678__auto__,cljs.core.pr_writer,""," ","",opts__6679__auto__,keyval__6681__auto__);
});})(this__6677__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__6678__auto__,pr_pair__6680__auto__,"#taoensso.sente.ChWebSocket{",", ","}",opts__6679__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"client-id","client-id",-464622140),self__.client_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"chs","chs",376886120),self__.chs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"params","params",710516235),self__.params],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"packer","packer",66077544),self__.packer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"url","url",276297046),self__.url],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state_","state_",957667102),self__.state_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"cbs-waiting_","cbs-waiting_",-1519029061),self__.cbs_waiting_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"socket_","socket_",-361048908),self__.socket_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"kalive-ms","kalive-ms",210734021),self__.kalive_ms],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"kalive-timer_","kalive-timer_",1558413149),self__.kalive_timer_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"kalive-due?_","kalive-due?_",39438072),self__.kalive_due_QMARK__],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),self__.backoff_ms_fn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),self__.active_retry_id_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"retry-count_","retry-count_",20238093),self__.retry_count_],null))], null),self__.__extmap));
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IIterable$ = true;

taoensso.sente.ChWebSocket.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__28137){
var self__ = this;
var G__28137__$1 = this;
return (new cljs.core.RecordIter((0),G__28137__$1,14,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"client-id","client-id",-464622140),new cljs.core.Keyword(null,"chs","chs",376886120),new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword(null,"packer","packer",66077544),new cljs.core.Keyword(null,"url","url",276297046),new cljs.core.Keyword(null,"state_","state_",957667102),new cljs.core.Keyword(null,"cbs-waiting_","cbs-waiting_",-1519029061),new cljs.core.Keyword(null,"socket_","socket_",-361048908),new cljs.core.Keyword(null,"kalive-ms","kalive-ms",210734021),new cljs.core.Keyword(null,"kalive-timer_","kalive-timer_",1558413149),new cljs.core.Keyword(null,"kalive-due?_","kalive-due?_",39438072),new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),new cljs.core.Keyword(null,"retry-count_","retry-count_",20238093)], null),cljs.core._iterator.call(null,self__.__extmap)));
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__6661__auto__){
var self__ = this;
var this__6661__auto____$1 = this;
return self__.__meta;
});

taoensso.sente.ChWebSocket.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__6657__auto__){
var self__ = this;
var this__6657__auto____$1 = this;
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.cbs_waiting_,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.backoff_ms_fn,self__.active_retry_id_,self__.retry_count_,self__.__meta,self__.__extmap,self__.__hash));
});

taoensso.sente.ChWebSocket.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__6667__auto__){
var self__ = this;
var this__6667__auto____$1 = this;
return (14 + cljs.core.count.call(null,self__.__extmap));
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__6658__auto__){
var self__ = this;
var this__6658__auto____$1 = this;
var h__6484__auto__ = self__.__hash;
if(!((h__6484__auto__ == null))){
return h__6484__auto__;
} else {
var h__6484__auto____$1 = cljs.core.hash_imap.call(null,this__6658__auto____$1);
self__.__hash = h__6484__auto____$1;

return h__6484__auto____$1;
}
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__6659__auto__,other__6660__auto__){
var self__ = this;
var this__6659__auto____$1 = this;
if(cljs.core.truth_((function (){var and__6037__auto__ = other__6660__auto__;
if(cljs.core.truth_(and__6037__auto__)){
var and__6037__auto____$1 = (this__6659__auto____$1.constructor === other__6660__auto__.constructor);
if(and__6037__auto____$1){
return cljs.core.equiv_map.call(null,this__6659__auto____$1,other__6660__auto__);
} else {
return and__6037__auto____$1;
}
} else {
return and__6037__auto__;
}
})())){
return true;
} else {
return false;
}
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__6672__auto__,k__6673__auto__){
var self__ = this;
var this__6672__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [new cljs.core.Keyword(null,"client-id","client-id",-464622140),null,new cljs.core.Keyword(null,"kalive-ms","kalive-ms",210734021),null,new cljs.core.Keyword(null,"packer","packer",66077544),null,new cljs.core.Keyword(null,"chs","chs",376886120),null,new cljs.core.Keyword(null,"params","params",710516235),null,new cljs.core.Keyword(null,"retry-count_","retry-count_",20238093),null,new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),null,new cljs.core.Keyword(null,"socket_","socket_",-361048908),null,new cljs.core.Keyword(null,"url","url",276297046),null,new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),null,new cljs.core.Keyword(null,"kalive-due?_","kalive-due?_",39438072),null,new cljs.core.Keyword(null,"cbs-waiting_","cbs-waiting_",-1519029061),null,new cljs.core.Keyword(null,"kalive-timer_","kalive-timer_",1558413149),null,new cljs.core.Keyword(null,"state_","state_",957667102),null], null), null),k__6673__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__6672__auto____$1),self__.__meta),k__6673__auto__);
} else {
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.cbs_waiting_,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.backoff_ms_fn,self__.active_retry_id_,self__.retry_count_,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__6673__auto__)),null));
}
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__6670__auto__,k__6671__auto__,G__28137){
var self__ = this;
var this__6670__auto____$1 = this;
var pred__28141 = cljs.core.keyword_identical_QMARK_;
var expr__28142 = k__6671__auto__;
if(cljs.core.truth_(pred__28141.call(null,new cljs.core.Keyword(null,"client-id","client-id",-464622140),expr__28142))){
return (new taoensso.sente.ChWebSocket(G__28137,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.cbs_waiting_,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.backoff_ms_fn,self__.active_retry_id_,self__.retry_count_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28141.call(null,new cljs.core.Keyword(null,"chs","chs",376886120),expr__28142))){
return (new taoensso.sente.ChWebSocket(self__.client_id,G__28137,self__.params,self__.packer,self__.url,self__.state_,self__.cbs_waiting_,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.backoff_ms_fn,self__.active_retry_id_,self__.retry_count_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28141.call(null,new cljs.core.Keyword(null,"params","params",710516235),expr__28142))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,G__28137,self__.packer,self__.url,self__.state_,self__.cbs_waiting_,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.backoff_ms_fn,self__.active_retry_id_,self__.retry_count_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28141.call(null,new cljs.core.Keyword(null,"packer","packer",66077544),expr__28142))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,G__28137,self__.url,self__.state_,self__.cbs_waiting_,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.backoff_ms_fn,self__.active_retry_id_,self__.retry_count_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28141.call(null,new cljs.core.Keyword(null,"url","url",276297046),expr__28142))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,G__28137,self__.state_,self__.cbs_waiting_,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.backoff_ms_fn,self__.active_retry_id_,self__.retry_count_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28141.call(null,new cljs.core.Keyword(null,"state_","state_",957667102),expr__28142))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,G__28137,self__.cbs_waiting_,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.backoff_ms_fn,self__.active_retry_id_,self__.retry_count_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28141.call(null,new cljs.core.Keyword(null,"cbs-waiting_","cbs-waiting_",-1519029061),expr__28142))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,G__28137,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.backoff_ms_fn,self__.active_retry_id_,self__.retry_count_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28141.call(null,new cljs.core.Keyword(null,"socket_","socket_",-361048908),expr__28142))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.cbs_waiting_,G__28137,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.backoff_ms_fn,self__.active_retry_id_,self__.retry_count_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28141.call(null,new cljs.core.Keyword(null,"kalive-ms","kalive-ms",210734021),expr__28142))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.cbs_waiting_,self__.socket_,G__28137,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.backoff_ms_fn,self__.active_retry_id_,self__.retry_count_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28141.call(null,new cljs.core.Keyword(null,"kalive-timer_","kalive-timer_",1558413149),expr__28142))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.cbs_waiting_,self__.socket_,self__.kalive_ms,G__28137,self__.kalive_due_QMARK__,self__.backoff_ms_fn,self__.active_retry_id_,self__.retry_count_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28141.call(null,new cljs.core.Keyword(null,"kalive-due?_","kalive-due?_",39438072),expr__28142))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.cbs_waiting_,self__.socket_,self__.kalive_ms,self__.kalive_timer_,G__28137,self__.backoff_ms_fn,self__.active_retry_id_,self__.retry_count_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28141.call(null,new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),expr__28142))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.cbs_waiting_,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,G__28137,self__.active_retry_id_,self__.retry_count_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28141.call(null,new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),expr__28142))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.cbs_waiting_,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.backoff_ms_fn,G__28137,self__.retry_count_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28141.call(null,new cljs.core.Keyword(null,"retry-count_","retry-count_",20238093),expr__28142))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.cbs_waiting_,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.backoff_ms_fn,self__.active_retry_id_,G__28137,self__.__meta,self__.__extmap,null));
} else {
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.cbs_waiting_,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.backoff_ms_fn,self__.active_retry_id_,self__.retry_count_,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__6671__auto__,G__28137),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});

taoensso.sente.ChWebSocket.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__6675__auto__){
var self__ = this;
var this__6675__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"client-id","client-id",-464622140),self__.client_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"chs","chs",376886120),self__.chs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"params","params",710516235),self__.params],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"packer","packer",66077544),self__.packer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"url","url",276297046),self__.url],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state_","state_",957667102),self__.state_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"cbs-waiting_","cbs-waiting_",-1519029061),self__.cbs_waiting_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"socket_","socket_",-361048908),self__.socket_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"kalive-ms","kalive-ms",210734021),self__.kalive_ms],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"kalive-timer_","kalive-timer_",1558413149),self__.kalive_timer_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"kalive-due?_","kalive-due?_",39438072),self__.kalive_due_QMARK__],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),self__.backoff_ms_fn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),self__.active_retry_id_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"retry-count_","retry-count_",20238093),self__.retry_count_],null))], null),self__.__extmap));
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__6662__auto__,G__28137){
var self__ = this;
var this__6662__auto____$1 = this;
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.cbs_waiting_,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.backoff_ms_fn,self__.active_retry_id_,self__.retry_count_,G__28137,self__.__extmap,self__.__hash));
});

taoensso.sente.ChWebSocket.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__6668__auto__,entry__6669__auto__){
var self__ = this;
var this__6668__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__6669__auto__)){
return cljs.core._assoc.call(null,this__6668__auto____$1,cljs.core._nth.call(null,entry__6669__auto__,(0)),cljs.core._nth.call(null,entry__6669__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__6668__auto____$1,entry__6669__auto__);
}
});

taoensso.sente.ChWebSocket.prototype.taoensso$sente$IChSocket$ = true;

taoensso.sente.ChWebSocket.prototype.taoensso$sente$IChSocket$_chsk_send_BANG_$arity$3 = (function (chsk,ev,p__28144){
var self__ = this;
var map__28145 = p__28144;
var map__28145__$1 = ((((!((map__28145 == null)))?((((map__28145.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28145.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28145):map__28145);
var opts = map__28145__$1;
var _QMARK_timeout_ms = cljs.core.get.call(null,map__28145__$1,new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406));
var _QMARK_cb = cljs.core.get.call(null,map__28145__$1,new cljs.core.Keyword(null,"cb","cb",589947841));
var flush_QMARK_ = cljs.core.get.call(null,map__28145__$1,new cljs.core.Keyword(null,"flush?","flush?",-108887231));
var chsk__$1 = this;
taoensso.sente.assert_send_args.call(null,ev,_QMARK_timeout_ms,_QMARK_cb);

var _QMARK_cb_fn = taoensso.sente.cb_chan_as_fn.call(null,_QMARK_cb,ev);
if(cljs.core.not.call(null,new cljs.core.Keyword(null,"open?","open?",1238443125).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,self__.state_)))){
taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente","/tmp/form-init5145320441605965266.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),(new cljs.core.Delay(((function (_QMARK_cb_fn,chsk__$1,map__28145,map__28145__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_){
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Chsk send against closed chsk."], null);
});})(_QMARK_cb_fn,chsk__$1,map__28145,map__28145__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_))
,null)),null);

if(cljs.core.truth_(_QMARK_cb_fn)){
return _QMARK_cb_fn.call(null,new cljs.core.Keyword("chsk","closed","chsk/closed",-922855264));
} else {
return null;
}
} else {
var _QMARK_cb_uuid = (cljs.core.truth_(_QMARK_cb_fn)?taoensso.encore.uuid_str.call(null,(6)):null);
var ppstr = taoensso.sente.pack.call(null,self__.packer,cljs.core.meta.call(null,ev),ev,_QMARK_cb_uuid);
var temp__4657__auto___28179 = _QMARK_cb_uuid;
if(cljs.core.truth_(temp__4657__auto___28179)){
var cb_uuid_28180 = temp__4657__auto___28179;
taoensso.encore.reset_in_BANG_.call(null,self__.cbs_waiting_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cb_uuid_28180], null),taoensso.encore.hcond.call(null,false,"taoensso.sente",758,(new cljs.core.Delay(((function (cb_uuid_28180,temp__4657__auto___28179,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__28145,map__28145__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_){
return (function (){
return _QMARK_cb_fn;
});})(cb_uuid_28180,temp__4657__auto___28179,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__28145,map__28145__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_))
,null)),new cljs.core.Symbol(null,"?cb-fn","?cb-fn",-1734331361,null),taoensso.encore.nnil_QMARK_,new cljs.core.Symbol("taoensso.encore","nnil?","taoensso.encore/nnil?",-1813154343,null)));

var temp__4657__auto___28181__$1 = _QMARK_timeout_ms;
if(cljs.core.truth_(temp__4657__auto___28181__$1)){
var timeout_ms_28182 = temp__4657__auto___28181__$1;
var c__14368__auto___28183 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto___28183,timeout_ms_28182,temp__4657__auto___28181__$1,cb_uuid_28180,temp__4657__auto___28179,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__28145,map__28145__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto___28183,timeout_ms_28182,temp__4657__auto___28181__$1,cb_uuid_28180,temp__4657__auto___28179,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__28145,map__28145__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_){
return (function (state_28157){
var state_val_28158 = (state_28157[(1)]);
if((state_val_28158 === (1))){
var inst_28147 = cljs.core.async.timeout.call(null,timeout_ms_28182);
var state_28157__$1 = state_28157;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28157__$1,(2),inst_28147);
} else {
if((state_val_28158 === (2))){
var inst_28150 = (state_28157[(7)]);
var inst_28149 = (state_28157[(2)]);
var inst_28150__$1 = taoensso.sente.pull_unused_cb_fn_BANG_.call(null,self__.cbs_waiting_,_QMARK_cb_uuid);
var state_28157__$1 = (function (){var statearr_28159 = state_28157;
(statearr_28159[(7)] = inst_28150__$1);

(statearr_28159[(8)] = inst_28149);

return statearr_28159;
})();
if(cljs.core.truth_(inst_28150__$1)){
var statearr_28160_28184 = state_28157__$1;
(statearr_28160_28184[(1)] = (3));

} else {
var statearr_28161_28185 = state_28157__$1;
(statearr_28161_28185[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28158 === (3))){
var inst_28150 = (state_28157[(7)]);
var inst_28152 = inst_28150.call(null,new cljs.core.Keyword("chsk","timeout","chsk/timeout",-319776489));
var state_28157__$1 = state_28157;
var statearr_28162_28186 = state_28157__$1;
(statearr_28162_28186[(2)] = inst_28152);

(statearr_28162_28186[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28158 === (4))){
var state_28157__$1 = state_28157;
var statearr_28163_28187 = state_28157__$1;
(statearr_28163_28187[(2)] = null);

(statearr_28163_28187[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28158 === (5))){
var inst_28155 = (state_28157[(2)]);
var state_28157__$1 = state_28157;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28157__$1,inst_28155);
} else {
return null;
}
}
}
}
}
});})(c__14368__auto___28183,timeout_ms_28182,temp__4657__auto___28181__$1,cb_uuid_28180,temp__4657__auto___28179,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__28145,map__28145__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_))
;
return ((function (switch__14236__auto__,c__14368__auto___28183,timeout_ms_28182,temp__4657__auto___28181__$1,cb_uuid_28180,temp__4657__auto___28179,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__28145,map__28145__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_){
return (function() {
var taoensso$sente$state_machine__14237__auto__ = null;
var taoensso$sente$state_machine__14237__auto____0 = (function (){
var statearr_28167 = [null,null,null,null,null,null,null,null,null];
(statearr_28167[(0)] = taoensso$sente$state_machine__14237__auto__);

(statearr_28167[(1)] = (1));

return statearr_28167;
});
var taoensso$sente$state_machine__14237__auto____1 = (function (state_28157){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_28157);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e28168){if((e28168 instanceof Object)){
var ex__14240__auto__ = e28168;
var statearr_28169_28188 = state_28157;
(statearr_28169_28188[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28157);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28168;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28189 = state_28157;
state_28157 = G__28189;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
taoensso$sente$state_machine__14237__auto__ = function(state_28157){
switch(arguments.length){
case 0:
return taoensso$sente$state_machine__14237__auto____0.call(this);
case 1:
return taoensso$sente$state_machine__14237__auto____1.call(this,state_28157);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
taoensso$sente$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = taoensso$sente$state_machine__14237__auto____0;
taoensso$sente$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = taoensso$sente$state_machine__14237__auto____1;
return taoensso$sente$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto___28183,timeout_ms_28182,temp__4657__auto___28181__$1,cb_uuid_28180,temp__4657__auto___28179,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__28145,map__28145__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_))
})();
var state__14370__auto__ = (function (){var statearr_28170 = f__14369__auto__.call(null);
(statearr_28170[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto___28183);

return statearr_28170;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto___28183,timeout_ms_28182,temp__4657__auto___28181__$1,cb_uuid_28180,temp__4657__auto___28179,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__28145,map__28145__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_))
);

} else {
}
} else {
}

try{cljs.core.deref.call(null,self__.socket_).send(ppstr);

cljs.core.reset_BANG_.call(null,self__.kalive_due_QMARK__,false);

return new cljs.core.Keyword(null,"apparent-success","apparent-success",242592222);
}catch (e28171){if((e28171 instanceof Error)){
var e = e28171;
taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"error","error",-978969032),"taoensso.sente","/tmp/form-init5145320441605965266.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),(new cljs.core.Delay(((function (e,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__28145,map__28145__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [e,"Chsk send error"], null);
});})(e,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__28145,map__28145__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_))
,null)),null);

var temp__4657__auto___28190 = _QMARK_cb_uuid;
if(cljs.core.truth_(temp__4657__auto___28190)){
var cb_uuid_28191 = temp__4657__auto___28190;
var cb_fn_STAR__28192 = (function (){var or__6049__auto__ = taoensso.sente.pull_unused_cb_fn_BANG_.call(null,self__.cbs_waiting_,cb_uuid_28191);
if(cljs.core.truth_(or__6049__auto__)){
return or__6049__auto__;
} else {
return taoensso.encore.hcond.call(null,false,"taoensso.sente",772,(new cljs.core.Delay(((function (or__6049__auto__,cb_uuid_28191,temp__4657__auto___28190,e,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__28145,map__28145__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_){
return (function (){
return _QMARK_cb_fn;
});})(or__6049__auto__,cb_uuid_28191,temp__4657__auto___28190,e,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__28145,map__28145__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_))
,null)),new cljs.core.Symbol(null,"?cb-fn","?cb-fn",-1734331361,null),taoensso.encore.nnil_QMARK_,new cljs.core.Symbol("taoensso.encore","nnil?","taoensso.encore/nnil?",-1813154343,null));
}
})();
cb_fn_STAR__28192.call(null,new cljs.core.Keyword("chsk","error","chsk/error",-984175439));
} else {
}

return false;
} else {
throw e28171;

}
}}
});

taoensso.sente.ChWebSocket.prototype.taoensso$sente$IChSocket$chsk_destroy_BANG_$arity$1 = (function (chsk){
var self__ = this;
var chsk__$1 = this;
return taoensso.sente.chsk_disconnect_BANG_.call(null,chsk__$1);
});

taoensso.sente.ChWebSocket.prototype.taoensso$sente$IChSocket$chsk_disconnect_BANG_$arity$1 = (function (chsk){
var self__ = this;
var chsk__$1 = this;
cljs.core.reset_BANG_.call(null,self__.active_retry_id_,"disconnected");

taoensso.sente.merge_GT_chsk_state_BANG_.call(null,chsk__$1,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"open?","open?",1238443125),false], null));

var temp__4657__auto__ = cljs.core.deref.call(null,self__.socket_);
if(cljs.core.truth_(temp__4657__auto__)){
var s = temp__4657__auto__;
return s.close((1000),"CLOSE_NORMAL");
} else {
return null;
}
});

taoensso.sente.ChWebSocket.prototype.taoensso$sente$IChSocket$chsk_reconnect_BANG_$arity$1 = (function (chsk){
var self__ = this;
var chsk__$1 = this;
cljs.core.reset_BANG_.call(null,self__.active_retry_id_,"reconnecting");

taoensso.sente.merge_GT_chsk_state_BANG_.call(null,chsk__$1,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"open?","open?",1238443125),false,new cljs.core.Keyword(null,"requested-reconnect-pending?","requested-reconnect-pending?",-299841116),true], null));

var temp__4657__auto___28193 = cljs.core.deref.call(null,self__.socket_);
if(cljs.core.truth_(temp__4657__auto___28193)){
var s_28194 = temp__4657__auto___28193;
s_28194.close((3000),"SENTE_RECONNECT");
} else {
}

return taoensso.sente._chsk_connect_BANG_.call(null,chsk__$1);
});

taoensso.sente.ChWebSocket.prototype.taoensso$sente$IChSocket$_chsk_connect_BANG_$arity$1 = (function (chsk){
var self__ = this;
var chsk__$1 = this;
var temp__4657__auto__ = (function (){var or__6049__auto__ = taoensso.encore.oget.call(null,window,"WebSocket");
if(cljs.core.truth_(or__6049__auto__)){
return or__6049__auto__;
} else {
return taoensso.encore.oget.call(null,window,"MozWebSocket");
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var WebSocket = temp__4657__auto__;
var retry_id = taoensso.encore.uuid_str.call(null);
var connect_fn = ((function (retry_id,WebSocket,temp__4657__auto__,chsk__$1){
return (function taoensso$sente$connect_fn(){
var retry_fn = ((function (retry_id,WebSocket,temp__4657__auto__,chsk__$1){
return (function (){
if(cljs.core._EQ_.call(null,cljs.core.deref.call(null,self__.active_retry_id_),retry_id)){
var retry_count_STAR_ = cljs.core.swap_BANG_.call(null,self__.retry_count_,cljs.core.inc);
var backoff_ms = self__.backoff_ms_fn.call(null,retry_count_STAR_);
window.clearInterval(cljs.core.deref.call(null,self__.kalive_timer_));

taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente","/tmp/form-init5145320441605965266.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),(new cljs.core.Delay(((function (retry_count_STAR_,backoff_ms,retry_id,WebSocket,temp__4657__auto__,chsk__$1){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Chsk is closed: will try reconnect (%s)",retry_count_STAR_], null);
});})(retry_count_STAR_,backoff_ms,retry_id,WebSocket,temp__4657__auto__,chsk__$1))
,null)),null);

return window.setTimeout(taoensso$sente$connect_fn,backoff_ms);
} else {
return null;
}
});})(retry_id,WebSocket,temp__4657__auto__,chsk__$1))
;
var _QMARK_socket = (function (){try{return (new WebSocket(taoensso.encore.merge_url_with_query_string.call(null,self__.url,cljs.core.merge.call(null,self__.params,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"client-id","client-id",-464622140),self__.client_id], null)))));
}catch (e28175){if((e28175 instanceof Error)){
var e = e28175;
taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"error","error",-978969032),"taoensso.sente","/tmp/form-init5145320441605965266.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),(new cljs.core.Delay(((function (e,retry_fn,retry_id,WebSocket,temp__4657__auto__,chsk__$1){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [e,"WebSocket js/Error"], null);
});})(e,retry_fn,retry_id,WebSocket,temp__4657__auto__,chsk__$1))
,null)),null);

return null;
} else {
throw e28175;

}
}})();
if(cljs.core.not.call(null,_QMARK_socket)){
return retry_fn.call(null);
} else {
return cljs.core.reset_BANG_.call(null,self__.socket_,(function (){var G__28176 = _QMARK_socket;
(G__28176["onerror"] = ((function (G__28176,retry_fn,_QMARK_socket,retry_id,WebSocket,temp__4657__auto__,chsk__$1){
return (function (ws_ev){
return taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"error","error",-978969032),"taoensso.sente","/tmp/form-init5145320441605965266.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),(new cljs.core.Delay(((function (G__28176,retry_fn,_QMARK_socket,retry_id,WebSocket,temp__4657__auto__,chsk__$1){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["WebSocket error: %s",ws_ev], null);
});})(G__28176,retry_fn,_QMARK_socket,retry_id,WebSocket,temp__4657__auto__,chsk__$1))
,null)),null);
});})(G__28176,retry_fn,_QMARK_socket,retry_id,WebSocket,temp__4657__auto__,chsk__$1))
);

(G__28176["onmessage"] = ((function (G__28176,retry_fn,_QMARK_socket,retry_id,WebSocket,temp__4657__auto__,chsk__$1){
return (function (ws_ev){
var ppstr = taoensso.encore.oget.call(null,ws_ev,"data");
var vec__28177 = taoensso.sente.unpack.call(null,self__.packer,ppstr);
var clj = cljs.core.nth.call(null,vec__28177,(0),null);
var _QMARK_cb_uuid = cljs.core.nth.call(null,vec__28177,(1),null);
var or__6049__auto__ = (function (){var and__6037__auto__ = taoensso.sente.handle_when_handshake_BANG_.call(null,chsk__$1,self__.chs,clj);
if(cljs.core.truth_(and__6037__auto__)){
return cljs.core.reset_BANG_.call(null,self__.retry_count_,(0));
} else {
return and__6037__auto__;
}
})();
if(cljs.core.truth_(or__6049__auto__)){
return or__6049__auto__;
} else {
var temp__4655__auto__ = _QMARK_cb_uuid;
if(cljs.core.truth_(temp__4655__auto__)){
var cb_uuid = temp__4655__auto__;
var temp__4655__auto____$1 = taoensso.sente.pull_unused_cb_fn_BANG_.call(null,self__.cbs_waiting_,cb_uuid);
if(cljs.core.truth_(temp__4655__auto____$1)){
var cb_fn = temp__4655__auto____$1;
return cb_fn.call(null,clj);
} else {
return taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente","/tmp/form-init5145320441605965266.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),(new cljs.core.Delay(((function (temp__4655__auto____$1,cb_uuid,temp__4655__auto__,or__6049__auto__,ppstr,vec__28177,clj,_QMARK_cb_uuid,G__28176,retry_fn,_QMARK_socket,retry_id,WebSocket,temp__4657__auto__,chsk__$1){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Cb reply w/o local cb-fn: %s",clj], null);
});})(temp__4655__auto____$1,cb_uuid,temp__4655__auto__,or__6049__auto__,ppstr,vec__28177,clj,_QMARK_cb_uuid,G__28176,retry_fn,_QMARK_socket,retry_id,WebSocket,temp__4657__auto__,chsk__$1))
,null)),null);
}
} else {
var buffered_evs = clj;
return taoensso.sente.receive_buffered_evs_BANG_.call(null,self__.chs,buffered_evs);
}
}
});})(G__28176,retry_fn,_QMARK_socket,retry_id,WebSocket,temp__4657__auto__,chsk__$1))
);

(G__28176["onopen"] = ((function (G__28176,retry_fn,_QMARK_socket,retry_id,WebSocket,temp__4657__auto__,chsk__$1){
return (function (_ws_ev){
return cljs.core.reset_BANG_.call(null,self__.kalive_timer_,window.setInterval(((function (G__28176,retry_fn,_QMARK_socket,retry_id,WebSocket,temp__4657__auto__,chsk__$1){
return (function (){
if(cljs.core.truth_(cljs.core.deref.call(null,self__.kalive_due_QMARK__))){
taoensso.sente.chsk_send_BANG_.call(null,chsk__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("chsk","ws-ping","chsk/ws-ping",191675304)], null));
} else {
}

return cljs.core.reset_BANG_.call(null,self__.kalive_due_QMARK__,true);
});})(G__28176,retry_fn,_QMARK_socket,retry_id,WebSocket,temp__4657__auto__,chsk__$1))
,self__.kalive_ms));
});})(G__28176,retry_fn,_QMARK_socket,retry_id,WebSocket,temp__4657__auto__,chsk__$1))
);

(G__28176["onclose"] = ((function (G__28176,retry_fn,_QMARK_socket,retry_id,WebSocket,temp__4657__auto__,chsk__$1){
return (function (_ws_ev){
taoensso.sente.merge_GT_chsk_state_BANG_.call(null,chsk__$1,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"open?","open?",1238443125),false], null));

return retry_fn.call(null);
});})(G__28176,retry_fn,_QMARK_socket,retry_id,WebSocket,temp__4657__auto__,chsk__$1))
);

return G__28176;
})());
}
});})(retry_id,WebSocket,temp__4657__auto__,chsk__$1))
;
cljs.core.reset_BANG_.call(null,self__.active_retry_id_,retry_id);

cljs.core.reset_BANG_.call(null,self__.retry_count_,(0));

connect_fn.call(null);

return chsk__$1;
} else {
return null;
}
});

taoensso.sente.ChWebSocket.getBasis = (function (){
return new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"client-id","client-id",1175909387,null),new cljs.core.Symbol(null,"chs","chs",2017417647,null),new cljs.core.Symbol(null,"params","params",-1943919534,null),new cljs.core.Symbol(null,"packer","packer",1706609071,null),new cljs.core.Symbol(null,"url","url",1916828573,null),new cljs.core.Symbol(null,"state_","state_",-1696768667,null),new cljs.core.Symbol(null,"cbs-waiting_","cbs-waiting_",121502466,null),new cljs.core.Symbol(null,"socket_","socket_",1279482619,null),new cljs.core.Symbol(null,"kalive-ms","kalive-ms",1851265548,null),new cljs.core.Symbol(null,"kalive-timer_","kalive-timer_",-1096022620,null),new cljs.core.Symbol(null,"kalive-due?_","kalive-due?_",1679969599,null),new cljs.core.Symbol(null,"backoff-ms-fn","backoff-ms-fn",-1881539814,null),new cljs.core.Symbol(null,"active-retry-id_","active-retry-id_",1468292413,null),new cljs.core.Symbol(null,"retry-count_","retry-count_",1660769620,null)], null);
});

taoensso.sente.ChWebSocket.cljs$lang$type = true;

taoensso.sente.ChWebSocket.cljs$lang$ctorPrSeq = (function (this__6697__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"taoensso.sente/ChWebSocket");
});

taoensso.sente.ChWebSocket.cljs$lang$ctorPrWriter = (function (this__6697__auto__,writer__6698__auto__){
return cljs.core._write.call(null,writer__6698__auto__,"taoensso.sente/ChWebSocket");
});

taoensso.sente.__GT_ChWebSocket = (function taoensso$sente$__GT_ChWebSocket(client_id,chs,params,packer,url,state_,cbs_waiting_,socket_,kalive_ms,kalive_timer_,kalive_due_QMARK__,backoff_ms_fn,active_retry_id_,retry_count_){
return (new taoensso.sente.ChWebSocket(client_id,chs,params,packer,url,state_,cbs_waiting_,socket_,kalive_ms,kalive_timer_,kalive_due_QMARK__,backoff_ms_fn,active_retry_id_,retry_count_,null,null,null));
});

taoensso.sente.map__GT_ChWebSocket = (function taoensso$sente$map__GT_ChWebSocket(G__28139){
return (new taoensso.sente.ChWebSocket(new cljs.core.Keyword(null,"client-id","client-id",-464622140).cljs$core$IFn$_invoke$arity$1(G__28139),new cljs.core.Keyword(null,"chs","chs",376886120).cljs$core$IFn$_invoke$arity$1(G__28139),new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(G__28139),new cljs.core.Keyword(null,"packer","packer",66077544).cljs$core$IFn$_invoke$arity$1(G__28139),new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(G__28139),new cljs.core.Keyword(null,"state_","state_",957667102).cljs$core$IFn$_invoke$arity$1(G__28139),new cljs.core.Keyword(null,"cbs-waiting_","cbs-waiting_",-1519029061).cljs$core$IFn$_invoke$arity$1(G__28139),new cljs.core.Keyword(null,"socket_","socket_",-361048908).cljs$core$IFn$_invoke$arity$1(G__28139),new cljs.core.Keyword(null,"kalive-ms","kalive-ms",210734021).cljs$core$IFn$_invoke$arity$1(G__28139),new cljs.core.Keyword(null,"kalive-timer_","kalive-timer_",1558413149).cljs$core$IFn$_invoke$arity$1(G__28139),new cljs.core.Keyword(null,"kalive-due?_","kalive-due?_",39438072).cljs$core$IFn$_invoke$arity$1(G__28139),new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955).cljs$core$IFn$_invoke$arity$1(G__28139),new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114).cljs$core$IFn$_invoke$arity$1(G__28139),new cljs.core.Keyword(null,"retry-count_","retry-count_",20238093).cljs$core$IFn$_invoke$arity$1(G__28139),null,cljs.core.dissoc.call(null,G__28139,new cljs.core.Keyword(null,"client-id","client-id",-464622140),new cljs.core.Keyword(null,"chs","chs",376886120),new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword(null,"packer","packer",66077544),new cljs.core.Keyword(null,"url","url",276297046),new cljs.core.Keyword(null,"state_","state_",957667102),new cljs.core.Keyword(null,"cbs-waiting_","cbs-waiting_",-1519029061),new cljs.core.Keyword(null,"socket_","socket_",-361048908),new cljs.core.Keyword(null,"kalive-ms","kalive-ms",210734021),new cljs.core.Keyword(null,"kalive-timer_","kalive-timer_",1558413149),new cljs.core.Keyword(null,"kalive-due?_","kalive-due?_",39438072),new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),new cljs.core.Keyword(null,"retry-count_","retry-count_",20238093)),null));
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {taoensso.sente.IChSocket}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
taoensso.sente.ChAjaxSocket = (function (client_id,chs,params,packer,url,state_,timeout_ms,ajax_opts,curr_xhr_,active_retry_id_,backoff_ms_fn,__meta,__extmap,__hash){
this.client_id = client_id;
this.chs = chs;
this.params = params;
this.packer = packer;
this.url = url;
this.state_ = state_;
this.timeout_ms = timeout_ms;
this.ajax_opts = ajax_opts;
this.curr_xhr_ = curr_xhr_;
this.active_retry_id_ = active_retry_id_;
this.backoff_ms_fn = backoff_ms_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
taoensso.sente.ChAjaxSocket.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__6663__auto__,k__6664__auto__){
var self__ = this;
var this__6663__auto____$1 = this;
return cljs.core._lookup.call(null,this__6663__auto____$1,k__6664__auto__,null);
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__6665__auto__,k28196,else__6666__auto__){
var self__ = this;
var this__6665__auto____$1 = this;
var G__28198 = (((k28196 instanceof cljs.core.Keyword))?k28196.fqn:null);
switch (G__28198) {
case "curr-xhr_":
return self__.curr_xhr_;

break;
case "client-id":
return self__.client_id;

break;
case "packer":
return self__.packer;

break;
case "chs":
return self__.chs;

break;
case "params":
return self__.params;

break;
case "backoff-ms-fn":
return self__.backoff_ms_fn;

break;
case "url":
return self__.url;

break;
case "active-retry-id_":
return self__.active_retry_id_;

break;
case "ajax-opts":
return self__.ajax_opts;

break;
case "timeout-ms":
return self__.timeout_ms;

break;
case "state_":
return self__.state_;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k28196,else__6666__auto__);

}
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__6677__auto__,writer__6678__auto__,opts__6679__auto__){
var self__ = this;
var this__6677__auto____$1 = this;
var pr_pair__6680__auto__ = ((function (this__6677__auto____$1){
return (function (keyval__6681__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__6678__auto__,cljs.core.pr_writer,""," ","",opts__6679__auto__,keyval__6681__auto__);
});})(this__6677__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__6678__auto__,pr_pair__6680__auto__,"#taoensso.sente.ChAjaxSocket{",", ","}",opts__6679__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"client-id","client-id",-464622140),self__.client_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"chs","chs",376886120),self__.chs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"params","params",710516235),self__.params],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"packer","packer",66077544),self__.packer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"url","url",276297046),self__.url],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state_","state_",957667102),self__.state_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406),self__.timeout_ms],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"ajax-opts","ajax-opts",-518239109),self__.ajax_opts],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"curr-xhr_","curr-xhr_",-1318773696),self__.curr_xhr_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),self__.active_retry_id_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),self__.backoff_ms_fn],null))], null),self__.__extmap));
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IIterable$ = true;

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__28195){
var self__ = this;
var G__28195__$1 = this;
return (new cljs.core.RecordIter((0),G__28195__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"client-id","client-id",-464622140),new cljs.core.Keyword(null,"chs","chs",376886120),new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword(null,"packer","packer",66077544),new cljs.core.Keyword(null,"url","url",276297046),new cljs.core.Keyword(null,"state_","state_",957667102),new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406),new cljs.core.Keyword(null,"ajax-opts","ajax-opts",-518239109),new cljs.core.Keyword(null,"curr-xhr_","curr-xhr_",-1318773696),new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955)], null),cljs.core._iterator.call(null,self__.__extmap)));
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__6661__auto__){
var self__ = this;
var this__6661__auto____$1 = this;
return self__.__meta;
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__6657__auto__){
var self__ = this;
var this__6657__auto____$1 = this;
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.active_retry_id_,self__.backoff_ms_fn,self__.__meta,self__.__extmap,self__.__hash));
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__6667__auto__){
var self__ = this;
var this__6667__auto____$1 = this;
return (11 + cljs.core.count.call(null,self__.__extmap));
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__6658__auto__){
var self__ = this;
var this__6658__auto____$1 = this;
var h__6484__auto__ = self__.__hash;
if(!((h__6484__auto__ == null))){
return h__6484__auto__;
} else {
var h__6484__auto____$1 = cljs.core.hash_imap.call(null,this__6658__auto____$1);
self__.__hash = h__6484__auto____$1;

return h__6484__auto____$1;
}
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__6659__auto__,other__6660__auto__){
var self__ = this;
var this__6659__auto____$1 = this;
if(cljs.core.truth_((function (){var and__6037__auto__ = other__6660__auto__;
if(cljs.core.truth_(and__6037__auto__)){
var and__6037__auto____$1 = (this__6659__auto____$1.constructor === other__6660__auto__.constructor);
if(and__6037__auto____$1){
return cljs.core.equiv_map.call(null,this__6659__auto____$1,other__6660__auto__);
} else {
return and__6037__auto____$1;
}
} else {
return and__6037__auto__;
}
})())){
return true;
} else {
return false;
}
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__6672__auto__,k__6673__auto__){
var self__ = this;
var this__6672__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Keyword(null,"curr-xhr_","curr-xhr_",-1318773696),null,new cljs.core.Keyword(null,"client-id","client-id",-464622140),null,new cljs.core.Keyword(null,"packer","packer",66077544),null,new cljs.core.Keyword(null,"chs","chs",376886120),null,new cljs.core.Keyword(null,"params","params",710516235),null,new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),null,new cljs.core.Keyword(null,"url","url",276297046),null,new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),null,new cljs.core.Keyword(null,"ajax-opts","ajax-opts",-518239109),null,new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406),null,new cljs.core.Keyword(null,"state_","state_",957667102),null], null), null),k__6673__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__6672__auto____$1),self__.__meta),k__6673__auto__);
} else {
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.active_retry_id_,self__.backoff_ms_fn,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__6673__auto__)),null));
}
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__6670__auto__,k__6671__auto__,G__28195){
var self__ = this;
var this__6670__auto____$1 = this;
var pred__28199 = cljs.core.keyword_identical_QMARK_;
var expr__28200 = k__6671__auto__;
if(cljs.core.truth_(pred__28199.call(null,new cljs.core.Keyword(null,"client-id","client-id",-464622140),expr__28200))){
return (new taoensso.sente.ChAjaxSocket(G__28195,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.active_retry_id_,self__.backoff_ms_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28199.call(null,new cljs.core.Keyword(null,"chs","chs",376886120),expr__28200))){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,G__28195,self__.params,self__.packer,self__.url,self__.state_,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.active_retry_id_,self__.backoff_ms_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28199.call(null,new cljs.core.Keyword(null,"params","params",710516235),expr__28200))){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,G__28195,self__.packer,self__.url,self__.state_,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.active_retry_id_,self__.backoff_ms_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28199.call(null,new cljs.core.Keyword(null,"packer","packer",66077544),expr__28200))){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,G__28195,self__.url,self__.state_,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.active_retry_id_,self__.backoff_ms_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28199.call(null,new cljs.core.Keyword(null,"url","url",276297046),expr__28200))){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,self__.packer,G__28195,self__.state_,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.active_retry_id_,self__.backoff_ms_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28199.call(null,new cljs.core.Keyword(null,"state_","state_",957667102),expr__28200))){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,G__28195,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.active_retry_id_,self__.backoff_ms_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28199.call(null,new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406),expr__28200))){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,G__28195,self__.ajax_opts,self__.curr_xhr_,self__.active_retry_id_,self__.backoff_ms_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28199.call(null,new cljs.core.Keyword(null,"ajax-opts","ajax-opts",-518239109),expr__28200))){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.timeout_ms,G__28195,self__.curr_xhr_,self__.active_retry_id_,self__.backoff_ms_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28199.call(null,new cljs.core.Keyword(null,"curr-xhr_","curr-xhr_",-1318773696),expr__28200))){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.timeout_ms,self__.ajax_opts,G__28195,self__.active_retry_id_,self__.backoff_ms_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28199.call(null,new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),expr__28200))){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,G__28195,self__.backoff_ms_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28199.call(null,new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),expr__28200))){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.active_retry_id_,G__28195,self__.__meta,self__.__extmap,null));
} else {
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.active_retry_id_,self__.backoff_ms_fn,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__6671__auto__,G__28195),null));
}
}
}
}
}
}
}
}
}
}
}
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__6675__auto__){
var self__ = this;
var this__6675__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"client-id","client-id",-464622140),self__.client_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"chs","chs",376886120),self__.chs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"params","params",710516235),self__.params],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"packer","packer",66077544),self__.packer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"url","url",276297046),self__.url],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state_","state_",957667102),self__.state_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406),self__.timeout_ms],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"ajax-opts","ajax-opts",-518239109),self__.ajax_opts],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"curr-xhr_","curr-xhr_",-1318773696),self__.curr_xhr_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),self__.active_retry_id_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),self__.backoff_ms_fn],null))], null),self__.__extmap));
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__6662__auto__,G__28195){
var self__ = this;
var this__6662__auto____$1 = this;
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.active_retry_id_,self__.backoff_ms_fn,G__28195,self__.__extmap,self__.__hash));
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__6668__auto__,entry__6669__auto__){
var self__ = this;
var this__6668__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__6669__auto__)){
return cljs.core._assoc.call(null,this__6668__auto____$1,cljs.core._nth.call(null,entry__6669__auto__,(0)),cljs.core._nth.call(null,entry__6669__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__6668__auto____$1,entry__6669__auto__);
}
});

taoensso.sente.ChAjaxSocket.prototype.taoensso$sente$IChSocket$ = true;

taoensso.sente.ChAjaxSocket.prototype.taoensso$sente$IChSocket$_chsk_send_BANG_$arity$3 = (function (chsk,ev,p__28202){
var self__ = this;
var map__28203 = p__28202;
var map__28203__$1 = ((((!((map__28203 == null)))?((((map__28203.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28203.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28203):map__28203);
var opts = map__28203__$1;
var _QMARK_timeout_ms = cljs.core.get.call(null,map__28203__$1,new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406));
var _QMARK_cb = cljs.core.get.call(null,map__28203__$1,new cljs.core.Keyword(null,"cb","cb",589947841));
var flush_QMARK_ = cljs.core.get.call(null,map__28203__$1,new cljs.core.Keyword(null,"flush?","flush?",-108887231));
var chsk__$1 = this;
taoensso.sente.assert_send_args.call(null,ev,_QMARK_timeout_ms,_QMARK_cb);

var _QMARK_cb_fn = taoensso.sente.cb_chan_as_fn.call(null,_QMARK_cb,ev);
if(cljs.core.not.call(null,new cljs.core.Keyword(null,"open?","open?",1238443125).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,self__.state_)))){
taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente","/tmp/form-init5145320441605965266.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),(new cljs.core.Delay(((function (_QMARK_cb_fn,chsk__$1,map__28203,map__28203__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_){
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Chsk send against closed chsk."], null);
});})(_QMARK_cb_fn,chsk__$1,map__28203,map__28203__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_))
,null)),null);

if(cljs.core.truth_(_QMARK_cb_fn)){
return _QMARK_cb_fn.call(null,new cljs.core.Keyword("chsk","closed","chsk/closed",-922855264));
} else {
return null;
}
} else {
var csrf_token = new cljs.core.Keyword(null,"csrf-token","csrf-token",-1872302856).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,self__.state_));
taoensso.sente.ajax_lite.call(null,self__.url,cljs.core.merge.call(null,self__.ajax_opts,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406),_QMARK_timeout_ms,new cljs.core.Keyword(null,"resp-type","resp-type",1050675962),new cljs.core.Keyword(null,"text","text",-1790561697),new cljs.core.Keyword(null,"headers","headers",-835030129),cljs.core.merge.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(self__.ajax_opts),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"X-CSRF-Token","X-CSRF-Token",1562992453),csrf_token], null)),new cljs.core.Keyword(null,"params","params",710516235),(function (){var ppstr = taoensso.sente.pack.call(null,self__.packer,cljs.core.meta.call(null,ev),ev,(cljs.core.truth_(_QMARK_cb_fn)?new cljs.core.Keyword(null,"ajax-cb","ajax-cb",-807060321):null));
return cljs.core.merge.call(null,self__.params,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"_","_",1453416199),taoensso.encore.now_udt.call(null),new cljs.core.Keyword(null,"csrf-token","csrf-token",-1872302856),csrf_token,new cljs.core.Keyword(null,"client-id","client-id",-464622140),self__.client_id,new cljs.core.Keyword(null,"ppstr","ppstr",1557495252),ppstr], null));
})()], null)),((function (csrf_token,_QMARK_cb_fn,chsk__$1,map__28203,map__28203__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_){
return (function taoensso$sente$ajax_cb(p__28205){
var map__28209 = p__28205;
var map__28209__$1 = ((((!((map__28209 == null)))?((((map__28209.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28209.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28209):map__28209);
var _QMARK_error = cljs.core.get.call(null,map__28209__$1,new cljs.core.Keyword(null,"?error","?error",1070752222));
var _QMARK_content = cljs.core.get.call(null,map__28209__$1,new cljs.core.Keyword(null,"?content","?content",1697782054));
if(cljs.core.truth_(_QMARK_error)){
if(cljs.core._EQ_.call(null,_QMARK_error,new cljs.core.Keyword(null,"timeout","timeout",-318625318))){
if(cljs.core.truth_(_QMARK_cb_fn)){
return _QMARK_cb_fn.call(null,new cljs.core.Keyword("chsk","timeout","chsk/timeout",-319776489));
} else {
return null;
}
} else {
taoensso.sente.merge_GT_chsk_state_BANG_.call(null,chsk__$1,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"open?","open?",1238443125),false], null));

if(cljs.core.truth_(_QMARK_cb_fn)){
return _QMARK_cb_fn.call(null,new cljs.core.Keyword("chsk","error","chsk/error",-984175439));
} else {
return null;
}
}
} else {
var content = _QMARK_content;
var resp_ppstr = content;
var vec__28211 = taoensso.sente.unpack.call(null,self__.packer,resp_ppstr);
var resp_clj = cljs.core.nth.call(null,vec__28211,(0),null);
var _ = cljs.core.nth.call(null,vec__28211,(1),null);
if(cljs.core.truth_(_QMARK_cb_fn)){
_QMARK_cb_fn.call(null,resp_clj);
} else {
if(cljs.core.not_EQ_.call(null,resp_clj,new cljs.core.Keyword("chsk","dummy-cb-200","chsk/dummy-cb-200",-1663130337))){
taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente","/tmp/form-init5145320441605965266.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),(new cljs.core.Delay(((function (content,resp_ppstr,vec__28211,resp_clj,_,map__28209,map__28209__$1,_QMARK_error,_QMARK_content,csrf_token,_QMARK_cb_fn,chsk__$1,map__28203,map__28203__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Cb reply w/o local cb-fn: %s",resp_clj], null);
});})(content,resp_ppstr,vec__28211,resp_clj,_,map__28209,map__28209__$1,_QMARK_error,_QMARK_content,csrf_token,_QMARK_cb_fn,chsk__$1,map__28203,map__28203__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_))
,null)),null);
} else {
}
}

return taoensso.sente.merge_GT_chsk_state_BANG_.call(null,chsk__$1,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"open?","open?",1238443125),true], null));
}
});})(csrf_token,_QMARK_cb_fn,chsk__$1,map__28203,map__28203__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_))
);

return new cljs.core.Keyword(null,"apparent-success","apparent-success",242592222);
}
});

taoensso.sente.ChAjaxSocket.prototype.taoensso$sente$IChSocket$chsk_destroy_BANG_$arity$1 = (function (chsk){
var self__ = this;
var chsk__$1 = this;
return taoensso.sente.chsk_disconnect_BANG_.call(null,chsk__$1);
});

taoensso.sente.ChAjaxSocket.prototype.taoensso$sente$IChSocket$chsk_disconnect_BANG_$arity$1 = (function (chsk){
var self__ = this;
var chsk__$1 = this;
cljs.core.reset_BANG_.call(null,self__.active_retry_id_,"disconnected");

taoensso.sente.merge_GT_chsk_state_BANG_.call(null,chsk__$1,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"open?","open?",1238443125),false], null));

var temp__4657__auto__ = cljs.core.deref.call(null,self__.curr_xhr_);
if(cljs.core.truth_(temp__4657__auto__)){
var x = temp__4657__auto__;
return x.abort();
} else {
return null;
}
});

taoensso.sente.ChAjaxSocket.prototype.taoensso$sente$IChSocket$chsk_reconnect_BANG_$arity$1 = (function (chsk){
var self__ = this;
var chsk__$1 = this;
cljs.core.reset_BANG_.call(null,self__.active_retry_id_,"reconnecting");

taoensso.sente.merge_GT_chsk_state_BANG_.call(null,chsk__$1,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"open?","open?",1238443125),false,new cljs.core.Keyword(null,"requested-reconnect-pending?","requested-reconnect-pending?",-299841116),true], null));

var temp__4657__auto___28227 = cljs.core.deref.call(null,self__.curr_xhr_);
if(cljs.core.truth_(temp__4657__auto___28227)){
var x_28228 = temp__4657__auto___28227;
x_28228.abort();
} else {
}

return taoensso.sente._chsk_connect_BANG_.call(null,chsk__$1);
});

taoensso.sente.ChAjaxSocket.prototype.taoensso$sente$IChSocket$_chsk_connect_BANG_$arity$1 = (function (chsk){
var self__ = this;
var chsk__$1 = this;
var retry_id = taoensso.encore.uuid_str.call(null);
var poll_fn = ((function (retry_id,chsk__$1){
return (function taoensso$sente$poll_fn(retry_count){
taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/tmp/form-init5145320441605965266.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),(new cljs.core.Delay(((function (retry_id,chsk__$1){
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["async-poll-for-update!"], null);
});})(retry_id,chsk__$1))
,null)),null);

var retry_fn = ((function (retry_id,chsk__$1){
return (function (){
if(cljs.core._EQ_.call(null,cljs.core.deref.call(null,self__.active_retry_id_),retry_id)){
var retry_count_STAR_ = (retry_count + (1));
var backoff_ms = self__.backoff_ms_fn.call(null,retry_count_STAR_);
taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente","/tmp/form-init5145320441605965266.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),(new cljs.core.Delay(((function (retry_count_STAR_,backoff_ms,retry_id,chsk__$1){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Chsk is closed: will try reconnect (%s)",retry_count_STAR_], null);
});})(retry_count_STAR_,backoff_ms,retry_id,chsk__$1))
,null)),null);

return window.setTimeout(((function (retry_count_STAR_,backoff_ms,retry_id,chsk__$1){
return (function (){
return taoensso$sente$poll_fn.call(null,retry_count_STAR_);
});})(retry_count_STAR_,backoff_ms,retry_id,chsk__$1))
,backoff_ms);
} else {
return null;
}
});})(retry_id,chsk__$1))
;
return cljs.core.reset_BANG_.call(null,self__.curr_xhr_,taoensso.sente.ajax_lite.call(null,self__.url,cljs.core.merge.call(null,self__.ajax_opts,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"get","get",1683182755),new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406),self__.timeout_ms,new cljs.core.Keyword(null,"resp-type","resp-type",1050675962),new cljs.core.Keyword(null,"text","text",-1790561697),new cljs.core.Keyword(null,"params","params",710516235),cljs.core.merge.call(null,self__.params,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"_","_",1453416199),taoensso.encore.now_udt.call(null),new cljs.core.Keyword(null,"client-id","client-id",-464622140),self__.client_id], null),(cljs.core.truth_(new cljs.core.Keyword(null,"open?","open?",1238443125).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,self__.state_)))?null:new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"handshake?","handshake?",-423743093),true], null)))], null)),((function (retry_fn,retry_id,chsk__$1){
return (function taoensso$sente$poll_fn_$_ajax_cb(p__28219){
var map__28223 = p__28219;
var map__28223__$1 = ((((!((map__28223 == null)))?((((map__28223.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28223.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28223):map__28223);
var _QMARK_error = cljs.core.get.call(null,map__28223__$1,new cljs.core.Keyword(null,"?error","?error",1070752222));
var _QMARK_content = cljs.core.get.call(null,map__28223__$1,new cljs.core.Keyword(null,"?content","?content",1697782054));
if(cljs.core.truth_(_QMARK_error)){
if(cljs.core._EQ_.call(null,_QMARK_error,new cljs.core.Keyword(null,"timeout","timeout",-318625318))){
return taoensso$sente$poll_fn.call(null,(0));
} else {
taoensso.sente.merge_GT_chsk_state_BANG_.call(null,chsk__$1,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"open?","open?",1238443125),false], null));

return retry_fn.call(null);

}
} else {
var content = _QMARK_content;
var ppstr = content;
var vec__28225 = taoensso.sente.unpack.call(null,self__.packer,ppstr);
var clj = cljs.core.nth.call(null,vec__28225,(0),null);
var _ = cljs.core.nth.call(null,vec__28225,(1),null);
var or__6049__auto___28229 = taoensso.sente.handle_when_handshake_BANG_.call(null,chsk__$1,self__.chs,clj);
if(cljs.core.truth_(or__6049__auto___28229)){
} else {
var buffered_evs_28230 = clj;
taoensso.sente.receive_buffered_evs_BANG_.call(null,self__.chs,buffered_evs_28230);

taoensso.sente.merge_GT_chsk_state_BANG_.call(null,chsk__$1,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"open?","open?",1238443125),true], null));
}

return taoensso$sente$poll_fn.call(null,(0));
}
});})(retry_fn,retry_id,chsk__$1))
));
});})(retry_id,chsk__$1))
;
cljs.core.reset_BANG_.call(null,self__.active_retry_id_,retry_id);

poll_fn.call(null,(0));

return chsk__$1;
});

taoensso.sente.ChAjaxSocket.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"client-id","client-id",1175909387,null),new cljs.core.Symbol(null,"chs","chs",2017417647,null),new cljs.core.Symbol(null,"params","params",-1943919534,null),new cljs.core.Symbol(null,"packer","packer",1706609071,null),new cljs.core.Symbol(null,"url","url",1916828573,null),new cljs.core.Symbol(null,"state_","state_",-1696768667,null),new cljs.core.Symbol(null,"timeout-ms","timeout-ms",-1900214363,null),new cljs.core.Symbol(null,"ajax-opts","ajax-opts",1122292418,null),new cljs.core.Symbol(null,"curr-xhr_","curr-xhr_",321757831,null),new cljs.core.Symbol(null,"active-retry-id_","active-retry-id_",1468292413,null),new cljs.core.Symbol(null,"backoff-ms-fn","backoff-ms-fn",-1881539814,null)], null);
});

taoensso.sente.ChAjaxSocket.cljs$lang$type = true;

taoensso.sente.ChAjaxSocket.cljs$lang$ctorPrSeq = (function (this__6697__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"taoensso.sente/ChAjaxSocket");
});

taoensso.sente.ChAjaxSocket.cljs$lang$ctorPrWriter = (function (this__6697__auto__,writer__6698__auto__){
return cljs.core._write.call(null,writer__6698__auto__,"taoensso.sente/ChAjaxSocket");
});

taoensso.sente.__GT_ChAjaxSocket = (function taoensso$sente$__GT_ChAjaxSocket(client_id,chs,params,packer,url,state_,timeout_ms,ajax_opts,curr_xhr_,active_retry_id_,backoff_ms_fn){
return (new taoensso.sente.ChAjaxSocket(client_id,chs,params,packer,url,state_,timeout_ms,ajax_opts,curr_xhr_,active_retry_id_,backoff_ms_fn,null,null,null));
});

taoensso.sente.map__GT_ChAjaxSocket = (function taoensso$sente$map__GT_ChAjaxSocket(G__28197){
return (new taoensso.sente.ChAjaxSocket(new cljs.core.Keyword(null,"client-id","client-id",-464622140).cljs$core$IFn$_invoke$arity$1(G__28197),new cljs.core.Keyword(null,"chs","chs",376886120).cljs$core$IFn$_invoke$arity$1(G__28197),new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(G__28197),new cljs.core.Keyword(null,"packer","packer",66077544).cljs$core$IFn$_invoke$arity$1(G__28197),new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(G__28197),new cljs.core.Keyword(null,"state_","state_",957667102).cljs$core$IFn$_invoke$arity$1(G__28197),new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406).cljs$core$IFn$_invoke$arity$1(G__28197),new cljs.core.Keyword(null,"ajax-opts","ajax-opts",-518239109).cljs$core$IFn$_invoke$arity$1(G__28197),new cljs.core.Keyword(null,"curr-xhr_","curr-xhr_",-1318773696).cljs$core$IFn$_invoke$arity$1(G__28197),new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114).cljs$core$IFn$_invoke$arity$1(G__28197),new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955).cljs$core$IFn$_invoke$arity$1(G__28197),null,cljs.core.dissoc.call(null,G__28197,new cljs.core.Keyword(null,"client-id","client-id",-464622140),new cljs.core.Keyword(null,"chs","chs",376886120),new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword(null,"packer","packer",66077544),new cljs.core.Keyword(null,"url","url",276297046),new cljs.core.Keyword(null,"state_","state_",957667102),new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406),new cljs.core.Keyword(null,"ajax-opts","ajax-opts",-518239109),new cljs.core.Keyword(null,"curr-xhr_","curr-xhr_",-1318773696),new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955)),null));
});

taoensso.sente.get_chsk_url = (function taoensso$sente$get_chsk_url(protocol,chsk_host,chsk_path,type){
var protocol__$1 = (function (){var G__28232 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__28232) {
case "ajax":
return protocol;

break;
case "ws":
if(cljs.core._EQ_.call(null,protocol,"https:")){
return "wss:";
} else {
return "ws:";
}

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}
})();
return [cljs.core.str(protocol__$1),cljs.core.str("//"),cljs.core.str(taoensso.encore.path.call(null,chsk_host,chsk_path))].join('');
});
/**
 * Returns a map with keys:
 *  :ch-recv ; core.async channel to receive `event-msg`s (internal or from clients).
 *           ; May `put!` (inject) arbitrary `event`s to this channel.
 *  :send-fn ; (fn [event & [?timeout-ms ?cb-fn]]) for client>server send.
 *  :state   ; Watchable, read-only (atom {:type _ :open? _ :uid _ :csrf-token _}).
 *  :chsk    ; IChSocket implementer. You can usu. ignore this.
 * 
 *   Common options:
 *  :type           ; e/o #{:auto :ws :ajax}. You'll usually want the default (:auto)
 *  :host           ; Server host (defaults to current page's host)
 *  :params         ; Map of any params to incl. in chsk Ring requests (handy for
 *                  ; application-level auth, etc.)
 *  :ws-kalive-ms   ; Ping to keep a WebSocket conn alive if no activity w/in given
 *                  ; number of milliseconds
 *  :lp-timeout-ms  ; Ping to keep a long-polling (Ajax) conn alive '' [1]
 *  :packer         ; :edn (default), or an IPacker implementation (experimental)
 *  :ajax-opts      ; Base opts map provided to `taoensso.encore/ajax-lite`
 *  :wrap-recv-evs? ; Should events from server be wrapped in [:chsk/recv _]?
 * 
 *   [1] If you're using Immutant and override the default :lp-timeout-ms, you'll
 *    need to provide the same timeout value to
 *    `taoensso.sente.server-adapters.immutant/make-immutant-adapter` and use
 *    the result of that function as the web server adapter to your server-side
 *    `make-channel-socket-server!`.
 */
taoensso.sente.make_channel_socket_client_BANG_ = (function taoensso$sente$make_channel_socket_client_BANG_(var_args){
var args__7114__auto__ = [];
var len__7107__auto___28244 = arguments.length;
var i__7108__auto___28245 = (0);
while(true){
if((i__7108__auto___28245 < len__7107__auto___28244)){
args__7114__auto__.push((arguments[i__7108__auto___28245]));

var G__28246 = (i__7108__auto___28245 + (1));
i__7108__auto___28245 = G__28246;
continue;
} else {
}
break;
}

var argseq__7115__auto__ = ((((1) < args__7114__auto__.length))?(new cljs.core.IndexedSeq(args__7114__auto__.slice((1)),(0))):null);
return taoensso.sente.make_channel_socket_client_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7115__auto__);
});

taoensso.sente.make_channel_socket_client_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (path,p__28237){
var vec__28238 = p__28237;
var map__28239 = cljs.core.nth.call(null,vec__28238,(0),null);
var map__28239__$1 = ((((!((map__28239 == null)))?((((map__28239.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28239.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28239):map__28239);
var opts = map__28239__$1;
var ajax_opts = cljs.core.get.call(null,map__28239__$1,new cljs.core.Keyword(null,"ajax-opts","ajax-opts",-518239109));
var ws_kalive_ms = cljs.core.get.call(null,map__28239__$1,new cljs.core.Keyword(null,"ws-kalive-ms","ws-kalive-ms",1442179968),(25000));
var lp_timeout_ms = cljs.core.get.call(null,map__28239__$1,new cljs.core.Keyword(null,"lp-timeout-ms","lp-timeout-ms",-1451963133),(25000));
var client_id = cljs.core.get.call(null,map__28239__$1,new cljs.core.Keyword(null,"client-id","client-id",-464622140),(function (){var or__6049__auto__ = new cljs.core.Keyword(null,"client-uuid","client-uuid",-1717531965).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__6049__auto__)){
return or__6049__auto__;
} else {
return taoensso.encore.uuid_str.call(null);
}
})());
var packer = cljs.core.get.call(null,map__28239__$1,new cljs.core.Keyword(null,"packer","packer",66077544),new cljs.core.Keyword(null,"edn","edn",1317840885));
var params = cljs.core.get.call(null,map__28239__$1,new cljs.core.Keyword(null,"params","params",710516235));
var type = cljs.core.get.call(null,map__28239__$1,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"auto","auto",-566279492));
var host = cljs.core.get.call(null,map__28239__$1,new cljs.core.Keyword(null,"host","host",-1558485167));
var recv_buf_or_n = cljs.core.get.call(null,map__28239__$1,new cljs.core.Keyword(null,"recv-buf-or-n","recv-buf-or-n",1363950355),cljs.core.async.sliding_buffer.call(null,(2048)));
var backoff_ms_fn = cljs.core.get.call(null,map__28239__$1,new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),taoensso.encore.exp_backoff);
var wrap_recv_evs_QMARK_ = cljs.core.get.call(null,map__28239__$1,new cljs.core.Keyword(null,"wrap-recv-evs?","wrap-recv-evs?",-1996694153),true);
var _deprecated_more_opts = cljs.core.nth.call(null,vec__28238,(1),null);
if((function (){
taoensso.encore.hcond.call(null,false,"taoensso.sente",null,(new cljs.core.Delay(((function (vec__28238,map__28239,map__28239__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts){
return (function (){
return type;
});})(vec__28238,map__28239,map__28239__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts))
,null)),new cljs.core.Symbol(null,"type","type",-1480165421,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"in","in",-1531184865),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"ws","ws",86841443),null,new cljs.core.Keyword(null,"ajax","ajax",814345549),null,new cljs.core.Keyword(null,"auto","auto",-566279492),null], null), null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"in","in",-1531184865),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"ws","ws",86841443),null,new cljs.core.Keyword(null,"ajax","ajax",814345549),null,new cljs.core.Keyword(null,"auto","auto",-566279492),null], null), null)], null));

return true;
})()
){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"have?","have?",-1685305646,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"in","in",-1531184865),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"ws","ws",86841443),null,new cljs.core.Keyword(null,"ajax","ajax",814345549),null,new cljs.core.Keyword(null,"auto","auto",-566279492),null], null), null)], null),new cljs.core.Symbol(null,"type","type",-1480165421,null))))].join('')));
}

if((function (){
taoensso.encore.hcond.call(null,false,"taoensso.sente",null,(new cljs.core.Delay(((function (vec__28238,map__28239,map__28239__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts){
return (function (){
return client_id;
});})(vec__28238,map__28239,map__28239__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts))
,null)),new cljs.core.Symbol(null,"client-id","client-id",1175909387,null),taoensso.encore.nblank_str_QMARK_,new cljs.core.Symbol("enc","nblank-str?","enc/nblank-str?",19952870,null));

return true;
})()
){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"have?","have?",-1685305646,null),new cljs.core.Symbol("enc","nblank-str?","enc/nblank-str?",19952870,null),new cljs.core.Symbol(null,"client-id","client-id",1175909387,null))))].join('')));
}

if(!((_deprecated_more_opts == null))){
taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente","/tmp/form-init5145320441605965266.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),(new cljs.core.Delay(((function (vec__28238,map__28239,map__28239__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts){
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["`make-channel-socket-client!` fn signature CHANGED with Sente v0.10.0."], null);
});})(vec__28238,map__28239,map__28239__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts))
,null)),null);
} else {
}

if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"lp-timeout","lp-timeout",1149461302))){
taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente","/tmp/form-init5145320441605965266.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),(new cljs.core.Delay(((function (vec__28238,map__28239,map__28239__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts){
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [":lp-timeout opt has CHANGED; please use :lp-timout-ms."], null);
});})(vec__28238,map__28239,map__28239__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts))
,null)),null);
} else {
}

var packer__$1 = taoensso.sente.interfaces.coerce_packer.call(null,packer);
var win_location = taoensso.encore.get_window_location.call(null);
var win_protocol = new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(win_location);
var host__$1 = (function (){var or__6049__auto__ = host;
if(cljs.core.truth_(or__6049__auto__)){
return or__6049__auto__;
} else {
return new cljs.core.Keyword(null,"host","host",-1558485167).cljs$core$IFn$_invoke$arity$1(win_location);
}
})();
var path__$1 = (function (){var or__6049__auto__ = path;
if(cljs.core.truth_(or__6049__auto__)){
return or__6049__auto__;
} else {
return new cljs.core.Keyword(null,"pathname","pathname",-1420497528).cljs$core$IFn$_invoke$arity$1(win_location);
}
})();
var private_chs = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"state","state",-1988618099),cljs.core.async.chan.call(null,cljs.core.async.sliding_buffer.call(null,(10))),new cljs.core.Keyword(null,"internal","internal",-854870097),cljs.core.async.chan.call(null,cljs.core.async.sliding_buffer.call(null,(10))),new cljs.core.Keyword(null,"<server","<server",-2135373537),cljs.core.async.chan.call(null,recv_buf_or_n)], null);
var ever_opened_QMARK__ = cljs.core.atom.call(null,false);
var state_STAR_ = ((function (packer__$1,win_location,win_protocol,host__$1,path__$1,private_chs,ever_opened_QMARK__,vec__28238,map__28239,map__28239__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts){
return (function (state){
if(cljs.core.truth_((function (){var or__6049__auto__ = cljs.core.not.call(null,new cljs.core.Keyword(null,"open?","open?",1238443125).cljs$core$IFn$_invoke$arity$1(state));
if(or__6049__auto__){
return or__6049__auto__;
} else {
return cljs.core.deref.call(null,ever_opened_QMARK__);
}
})())){
return state;
} else {
cljs.core.reset_BANG_.call(null,ever_opened_QMARK__,true);

return cljs.core.assoc.call(null,state,new cljs.core.Keyword(null,"first-open?","first-open?",396686530),true);
}
});})(packer__$1,win_location,win_protocol,host__$1,path__$1,private_chs,ever_opened_QMARK__,vec__28238,map__28239,map__28239__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts))
;
var public_ch_recv = cljs.core.async.merge.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"internal","internal",-854870097).cljs$core$IFn$_invoke$arity$1(private_chs),cljs.core.async.map_LT_.call(null,((function (packer__$1,win_location,win_protocol,host__$1,path__$1,private_chs,ever_opened_QMARK__,state_STAR_,vec__28238,map__28239,map__28239__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts){
return (function (state){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("chsk","state","chsk/state",-1991397620),state_STAR_.call(null,state)], null);
});})(packer__$1,win_location,win_protocol,host__$1,path__$1,private_chs,ever_opened_QMARK__,state_STAR_,vec__28238,map__28239,map__28239__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts))
,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(private_chs)),(function (){var _LT_server_ch = new cljs.core.Keyword(null,"<server","<server",-2135373537).cljs$core$IFn$_invoke$arity$1(private_chs);
if(cljs.core.truth_(wrap_recv_evs_QMARK_)){
return cljs.core.async.map_LT_.call(null,((function (_LT_server_ch,packer__$1,win_location,win_protocol,host__$1,path__$1,private_chs,ever_opened_QMARK__,state_STAR_,vec__28238,map__28239,map__28239__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts){
return (function (ev){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("chsk","recv","chsk/recv",561097091),ev], null);
});})(_LT_server_ch,packer__$1,win_location,win_protocol,host__$1,path__$1,private_chs,ever_opened_QMARK__,state_STAR_,vec__28238,map__28239,map__28239__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts))
,_LT_server_ch);
} else {
return cljs.core.async.map_LT_.call(null,((function (_LT_server_ch,packer__$1,win_location,win_protocol,host__$1,path__$1,private_chs,ever_opened_QMARK__,state_STAR_,vec__28238,map__28239,map__28239__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts){
return (function (ev){
var vec__28241 = ev;
var id = cljs.core.nth.call(null,vec__28241,(0),null);
var _QMARK_data = cljs.core.nth.call(null,vec__28241,(1),null);
taoensso.encore.hcond.call(null,false,"taoensso.sente",null,(new cljs.core.Delay(((function (vec__28241,id,_QMARK_data,_LT_server_ch,packer__$1,win_location,win_protocol,host__$1,path__$1,private_chs,ever_opened_QMARK__,state_STAR_,vec__28238,map__28239,map__28239__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts){
return (function (){
return cljs.core.namespace.call(null,id);
});})(vec__28241,id,_QMARK_data,_LT_server_ch,packer__$1,win_location,win_protocol,host__$1,path__$1,private_chs,ever_opened_QMARK__,state_STAR_,vec__28238,map__28239,map__28239__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts))
,null)),cljs.core.list(new cljs.core.Symbol(null,"namespace","namespace",1263021155,null),new cljs.core.Symbol(null,"id","id",252129435,null)),((function (vec__28241,id,_QMARK_data,_LT_server_ch,packer__$1,win_location,win_protocol,host__$1,path__$1,private_chs,ever_opened_QMARK__,state_STAR_,vec__28238,map__28239,map__28239__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts){
return (function (p1__28234_SHARP_){
return cljs.core.not_EQ_.call(null,p1__28234_SHARP_,"chsk");
});})(vec__28241,id,_QMARK_data,_LT_server_ch,packer__$1,win_location,win_protocol,host__$1,path__$1,private_chs,ever_opened_QMARK__,state_STAR_,vec__28238,map__28239,map__28239__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts))
,cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__28234#","p1__28234#",-1850324238,null)], null),cljs.core.list(new cljs.core.Symbol(null,"not=","not=",1466536204,null),new cljs.core.Symbol(null,"p1__28234#","p1__28234#",-1850324238,null),"chsk")));


return ev;
});})(_LT_server_ch,packer__$1,win_location,win_protocol,host__$1,path__$1,private_chs,ever_opened_QMARK__,state_STAR_,vec__28238,map__28239,map__28239__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts))
,_LT_server_ch);
}
})()], null));
var chsk = (function (){var or__6049__auto__ = (function (){var and__6037__auto__ = cljs.core.not_EQ_.call(null,type,new cljs.core.Keyword(null,"ajax","ajax",814345549));
if(and__6037__auto__){
return taoensso.sente._chsk_connect_BANG_.call(null,taoensso.sente.map__GT_ChWebSocket.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"client-id","client-id",-464622140),new cljs.core.Keyword(null,"kalive-ms","kalive-ms",210734021),new cljs.core.Keyword(null,"packer","packer",66077544),new cljs.core.Keyword(null,"chs","chs",376886120),new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword(null,"retry-count_","retry-count_",20238093),new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),new cljs.core.Keyword(null,"socket_","socket_",-361048908),new cljs.core.Keyword(null,"url","url",276297046),new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),new cljs.core.Keyword(null,"kalive-due?_","kalive-due?_",39438072),new cljs.core.Keyword(null,"cbs-waiting_","cbs-waiting_",-1519029061),new cljs.core.Keyword(null,"kalive-timer_","kalive-timer_",1558413149),new cljs.core.Keyword(null,"state_","state_",957667102)],[client_id,ws_kalive_ms,packer__$1,private_chs,params,cljs.core.atom.call(null,(0)),backoff_ms_fn,cljs.core.atom.call(null,null),(function (){var temp__4655__auto__ = new cljs.core.Keyword(null,"chsk-url-fn","chsk-url-fn",1968894294).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__4655__auto__)){
var f = temp__4655__auto__;
return f.call(null,path__$1,win_location,new cljs.core.Keyword(null,"ws","ws",86841443));
} else {
return taoensso.sente.get_chsk_url.call(null,win_protocol,host__$1,path__$1,new cljs.core.Keyword(null,"ws","ws",86841443));
}
})(),cljs.core.atom.call(null,"pending"),cljs.core.atom.call(null,true),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY),cljs.core.atom.call(null,null),cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"open?","open?",1238443125),false], null))])));
} else {
return and__6037__auto__;
}
})();
if(cljs.core.truth_(or__6049__auto__)){
return or__6049__auto__;
} else {
var and__6037__auto__ = cljs.core.not_EQ_.call(null,type,new cljs.core.Keyword(null,"ws","ws",86841443));
if(and__6037__auto__){
return taoensso.sente._chsk_connect_BANG_.call(null,taoensso.sente.map__GT_ChAjaxSocket.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"curr-xhr_","curr-xhr_",-1318773696),new cljs.core.Keyword(null,"client-id","client-id",-464622140),new cljs.core.Keyword(null,"packer","packer",66077544),new cljs.core.Keyword(null,"chs","chs",376886120),new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),new cljs.core.Keyword(null,"url","url",276297046),new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),new cljs.core.Keyword(null,"ajax-opts","ajax-opts",-518239109),new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406),new cljs.core.Keyword(null,"state_","state_",957667102)],[cljs.core.atom.call(null,null),client_id,packer__$1,private_chs,params,backoff_ms_fn,(function (){var temp__4655__auto__ = new cljs.core.Keyword(null,"chsk-url-fn","chsk-url-fn",1968894294).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__4655__auto__)){
var f = temp__4655__auto__;
return f.call(null,path__$1,win_location,new cljs.core.Keyword(null,"ajax","ajax",814345549));
} else {
return taoensso.sente.get_chsk_url.call(null,win_protocol,host__$1,path__$1,new cljs.core.Keyword(null,"ajax","ajax",814345549));
}
})(),cljs.core.atom.call(null,"pending"),ajax_opts,lp_timeout_ms,cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"ajax","ajax",814345549),new cljs.core.Keyword(null,"open?","open?",1238443125),false], null))])));
} else {
return and__6037__auto__;
}
}
})();
var _ = (cljs.core.truth_(chsk)?null:(function(){throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("Failed to create channel socket"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"chsk","chsk",776828446,null)))].join('')))})());
var send_fn = cljs.core.partial.call(null,taoensso.sente.chsk_send_BANG_,chsk);
var public_ch_recv__$1 = cljs.core.async.map_LT_.call(null,((function (packer__$1,win_location,win_protocol,host__$1,path__$1,private_chs,ever_opened_QMARK__,state_STAR_,public_ch_recv,chsk,_,send_fn,vec__28238,map__28239,map__28239__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts){
return (function taoensso$sente$ev__GT_ev_msg(ev){
var vec__28243 = taoensso.sente.as_event.call(null,ev);
var ev_id = cljs.core.nth.call(null,vec__28243,(0),null);
var ev__QMARK_data = cljs.core.nth.call(null,vec__28243,(1),null);
var ev__$1 = vec__28243;
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861),public_ch_recv,new cljs.core.Keyword(null,"send-fn","send-fn",351002041),send_fn,new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"state_","state_",957667102).cljs$core$IFn$_invoke$arity$1(chsk),new cljs.core.Keyword(null,"event","event",301435442),ev__$1,new cljs.core.Keyword(null,"id","id",-1388402092),ev_id,new cljs.core.Keyword(null,"?data","?data",-9471433),ev__QMARK_data], null);
});})(packer__$1,win_location,win_protocol,host__$1,path__$1,private_chs,ever_opened_QMARK__,state_STAR_,public_ch_recv,chsk,_,send_fn,vec__28238,map__28239,map__28239__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts))
,public_ch_recv);
if(cljs.core.truth_(chsk)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"chsk","chsk",-863703081),chsk,new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861),public_ch_recv__$1,new cljs.core.Keyword(null,"send-fn","send-fn",351002041),send_fn,new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"state_","state_",957667102).cljs$core$IFn$_invoke$arity$1(chsk)], null);
} else {
return null;
}
});

taoensso.sente.make_channel_socket_client_BANG_.cljs$lang$maxFixedArity = (1);

taoensso.sente.make_channel_socket_client_BANG_.cljs$lang$applyTo = (function (seq28235){
var G__28236 = cljs.core.first.call(null,seq28235);
var seq28235__$1 = cljs.core.next.call(null,seq28235);
return taoensso.sente.make_channel_socket_client_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__28236,seq28235__$1);
});
taoensso.sente._start_chsk_router_BANG_ = (function taoensso$sente$_start_chsk_router_BANG_(server_QMARK_,ch_recv,event_msg_handler,opts){
var map__28421 = opts;
var map__28421__$1 = ((((!((map__28421 == null)))?((((map__28421.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28421.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28421):map__28421);
var trace_evs_QMARK_ = cljs.core.get.call(null,map__28421__$1,new cljs.core.Keyword(null,"trace-evs?","trace-evs?",1502453512));
var error_handler = cljs.core.get.call(null,map__28421__$1,new cljs.core.Keyword(null,"error-handler","error-handler",-484945776));
var ch_ctrl = cljs.core.async.chan.call(null);
var c__14368__auto___28595 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14368__auto___28595,map__28421,map__28421__$1,trace_evs_QMARK_,error_handler,ch_ctrl){
return (function (){
var f__14369__auto__ = (function (){var switch__14236__auto__ = ((function (c__14368__auto___28595,map__28421,map__28421__$1,trace_evs_QMARK_,error_handler,ch_ctrl){
return (function (state_28534){
var state_val_28535 = (state_28534[(1)]);
if((state_val_28535 === (7))){
var inst_28530 = (state_28534[(2)]);
var state_28534__$1 = state_28534;
var statearr_28536_28596 = state_28534__$1;
(statearr_28536_28596[(2)] = inst_28530);

(statearr_28536_28596[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28535 === (20))){
var inst_28429 = (state_28534[(7)]);
var inst_28432 = (state_28534[(8)]);
var inst_28457 = (state_28534[(9)]);
var inst_28456 = (state_28534[(10)]);
var inst_28430 = (state_28534[(11)]);
var inst_28431 = (state_28534[(12)]);
var inst_28467 = (function (){var vec__28424 = inst_28429;
var v = inst_28430;
var p = inst_28431;
var stop_QMARK_ = inst_28432;
var map__28435 = inst_28456;
var event_msg = inst_28456;
var event = inst_28457;
return ((function (vec__28424,v,p,stop_QMARK_,map__28435,event_msg,event,inst_28429,inst_28432,inst_28457,inst_28456,inst_28430,inst_28431,state_val_28535,c__14368__auto___28595,map__28421,map__28421__$1,trace_evs_QMARK_,error_handler,ch_ctrl){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Pre-handler event: %s",event], null);
});
;})(vec__28424,v,p,stop_QMARK_,map__28435,event_msg,event,inst_28429,inst_28432,inst_28457,inst_28456,inst_28430,inst_28431,state_val_28535,c__14368__auto___28595,map__28421,map__28421__$1,trace_evs_QMARK_,error_handler,ch_ctrl))
})();
var inst_28468 = (new cljs.core.Delay(inst_28467,null));
var inst_28469 = taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/tmp/form-init5145320441605965266.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),inst_28468,null);
var state_28534__$1 = state_28534;
var statearr_28537_28597 = state_28534__$1;
(statearr_28537_28597[(2)] = inst_28469);

(statearr_28537_28597[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28535 === (27))){
var state_28534__$1 = state_28534;
var statearr_28538_28598 = state_28534__$1;
(statearr_28538_28598[(2)] = null);

(statearr_28538_28598[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28535 === (1))){
var state_28534__$1 = state_28534;
var statearr_28539_28599 = state_28534__$1;
(statearr_28539_28599[(2)] = null);

(statearr_28539_28599[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28535 === (24))){
var inst_28429 = (state_28534[(7)]);
var inst_28432 = (state_28534[(8)]);
var inst_28457 = (state_28534[(9)]);
var inst_28456 = (state_28534[(10)]);
var inst_28430 = (state_28534[(11)]);
var inst_28431 = (state_28534[(12)]);
var inst_28480 = (function (){var vec__28424 = inst_28429;
var v = inst_28430;
var p = inst_28431;
var stop_QMARK_ = inst_28432;
var map__28435 = inst_28456;
var event_msg = inst_28456;
var event = inst_28457;
return ((function (vec__28424,v,p,stop_QMARK_,map__28435,event_msg,event,inst_28429,inst_28432,inst_28457,inst_28456,inst_28430,inst_28431,state_val_28535,c__14368__auto___28595,map__28421,map__28421__$1,trace_evs_QMARK_,error_handler,ch_ctrl){
return (function (){
return event_msg;
});
;})(vec__28424,v,p,stop_QMARK_,map__28435,event_msg,event,inst_28429,inst_28432,inst_28457,inst_28456,inst_28430,inst_28431,state_val_28535,c__14368__auto___28595,map__28421,map__28421__$1,trace_evs_QMARK_,error_handler,ch_ctrl))
})();
var inst_28481 = (new cljs.core.Delay(inst_28480,null));
var inst_28482 = new cljs.core.Symbol(null,"event-msg","event-msg",-509558413,null);
var inst_28483 = new cljs.core.Symbol(null,"client-event-msg?","client-event-msg?",-1506206275,null);
var inst_28484 = taoensso.encore.hcond.call(null,true,"taoensso.sente",null,inst_28481,inst_28482,taoensso.sente.client_event_msg_QMARK_,inst_28483);
var state_28534__$1 = state_28534;
var statearr_28540_28600 = state_28534__$1;
(statearr_28540_28600[(2)] = inst_28484);

(statearr_28540_28600[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28535 === (4))){
var inst_28429 = (state_28534[(7)]);
var inst_28432 = (state_28534[(8)]);
var inst_28431 = (state_28534[(12)]);
var inst_28429__$1 = (state_28534[(2)]);
var inst_28430 = cljs.core.nth.call(null,inst_28429__$1,(0),null);
var inst_28431__$1 = cljs.core.nth.call(null,inst_28429__$1,(1),null);
var inst_28432__$1 = taoensso.encore.kw_identical_QMARK_.call(null,inst_28431__$1,ch_ctrl);
var state_28534__$1 = (function (){var statearr_28541 = state_28534;
(statearr_28541[(7)] = inst_28429__$1);

(statearr_28541[(8)] = inst_28432__$1);

(statearr_28541[(11)] = inst_28430);

(statearr_28541[(12)] = inst_28431__$1);

return statearr_28541;
})();
if(cljs.core.truth_(inst_28432__$1)){
var statearr_28542_28601 = state_28534__$1;
(statearr_28542_28601[(1)] = (5));

} else {
var statearr_28543_28602 = state_28534__$1;
(statearr_28543_28602[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28535 === (15))){
var inst_28430 = (state_28534[(11)]);
var state_28534__$1 = state_28534;
var statearr_28544_28603 = state_28534__$1;
(statearr_28544_28603[(2)] = inst_28430);

(statearr_28544_28603[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28535 === (21))){
var state_28534__$1 = state_28534;
var statearr_28545_28604 = state_28534__$1;
(statearr_28545_28604[(2)] = null);

(statearr_28545_28604[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28535 === (31))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_28534,(30),Error,null,(29));
var inst_28503 = cljs.core.PersistentVector.EMPTY_NODE;
var state_28534__$1 = (function (){var statearr_28546 = state_28534;
(statearr_28546[(13)] = inst_28503);

return statearr_28546;
})();
if(cljs.core.truth_(error_handler)){
var statearr_28547_28605 = state_28534__$1;
(statearr_28547_28605[(1)] = (32));

} else {
var statearr_28548_28606 = state_28534__$1;
(statearr_28548_28606[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28535 === (32))){
var inst_28493 = (state_28534[(14)]);
var inst_28456 = (state_28534[(10)]);
var inst_28505 = error_handler.call(null,inst_28493,inst_28456);
var state_28534__$1 = state_28534;
var statearr_28549_28607 = state_28534__$1;
(statearr_28549_28607[(2)] = inst_28505);

(statearr_28549_28607[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28535 === (33))){
var inst_28493 = (state_28534[(14)]);
var inst_28429 = (state_28534[(7)]);
var inst_28432 = (state_28534[(8)]);
var inst_28457 = (state_28534[(9)]);
var inst_28491 = (state_28534[(15)]);
var inst_28456 = (state_28534[(10)]);
var inst_28492 = (state_28534[(16)]);
var inst_28430 = (state_28534[(11)]);
var inst_28431 = (state_28534[(12)]);
var inst_28507 = (function (){var p = inst_28431;
var _QMARK_error = inst_28493;
var v = inst_28430;
var temp__4655__auto__ = error_handler;
var _ = inst_28492;
var vec__28424 = inst_28429;
var event_msg = inst_28456;
var e = inst_28493;
var temp__4657__auto__ = inst_28493;
var event = inst_28457;
var vec__28436 = inst_28491;
var stop_QMARK_ = inst_28432;
var map__28435 = inst_28456;
return ((function (p,_QMARK_error,v,temp__4655__auto__,_,vec__28424,event_msg,e,temp__4657__auto__,event,vec__28436,stop_QMARK_,map__28435,inst_28493,inst_28429,inst_28432,inst_28457,inst_28491,inst_28456,inst_28492,inst_28430,inst_28431,state_val_28535,c__14368__auto___28595,map__28421,map__28421__$1,trace_evs_QMARK_,error_handler,ch_ctrl){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [e,"Chsk router `event-msg-handler` error: %s",event], null);
});
;})(p,_QMARK_error,v,temp__4655__auto__,_,vec__28424,event_msg,e,temp__4657__auto__,event,vec__28436,stop_QMARK_,map__28435,inst_28493,inst_28429,inst_28432,inst_28457,inst_28491,inst_28456,inst_28492,inst_28430,inst_28431,state_val_28535,c__14368__auto___28595,map__28421,map__28421__$1,trace_evs_QMARK_,error_handler,ch_ctrl))
})();
var inst_28508 = (new cljs.core.Delay(inst_28507,null));
var inst_28509 = taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"error","error",-978969032),"taoensso.sente","/tmp/form-init5145320441605965266.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),inst_28508,null);
var state_28534__$1 = state_28534;
var statearr_28550_28608 = state_28534__$1;
(statearr_28550_28608[(2)] = inst_28509);

(statearr_28550_28608[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28535 === (13))){
var inst_28448 = (state_28534[(2)]);
var state_28534__$1 = state_28534;
var statearr_28551_28609 = state_28534__$1;
(statearr_28551_28609[(2)] = inst_28448);

(statearr_28551_28609[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28535 === (22))){
var inst_28472 = (state_28534[(2)]);
var state_28534__$1 = (function (){var statearr_28552 = state_28534;
(statearr_28552[(17)] = inst_28472);

return statearr_28552;
})();
if(cljs.core.truth_(server_QMARK_)){
var statearr_28553_28610 = state_28534__$1;
(statearr_28553_28610[(1)] = (23));

} else {
var statearr_28554_28611 = state_28534__$1;
(statearr_28554_28611[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28535 === (36))){
var state_28534__$1 = state_28534;
var statearr_28555_28612 = state_28534__$1;
(statearr_28555_28612[(2)] = null);

(statearr_28555_28612[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28535 === (29))){
var inst_28515 = (state_28534[(18)]);
var inst_28517 = (state_28534[(19)]);
var inst_28515__$1 = (state_28534[(2)]);
var inst_28516 = cljs.core.nth.call(null,inst_28515__$1,(0),null);
var inst_28517__$1 = cljs.core.nth.call(null,inst_28515__$1,(1),null);
var state_28534__$1 = (function (){var statearr_28556 = state_28534;
(statearr_28556[(18)] = inst_28515__$1);

(statearr_28556[(19)] = inst_28517__$1);

(statearr_28556[(20)] = inst_28516);

return statearr_28556;
})();
if(cljs.core.truth_(inst_28517__$1)){
var statearr_28557_28613 = state_28534__$1;
(statearr_28557_28613[(1)] = (35));

} else {
var statearr_28558_28614 = state_28534__$1;
(statearr_28558_28614[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28535 === (6))){
var inst_28430 = (state_28534[(11)]);
var inst_28438 = (inst_28430 == null);
var inst_28439 = cljs.core.not.call(null,inst_28438);
var state_28534__$1 = state_28534;
if(inst_28439){
var statearr_28559_28615 = state_28534__$1;
(statearr_28559_28615[(1)] = (8));

} else {
var statearr_28560_28616 = state_28534__$1;
(statearr_28560_28616[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28535 === (28))){
var inst_28527 = (state_28534[(2)]);
var state_28534__$1 = (function (){var statearr_28561 = state_28534;
(statearr_28561[(21)] = inst_28527);

return statearr_28561;
})();
var statearr_28562_28617 = state_28534__$1;
(statearr_28562_28617[(2)] = null);

(statearr_28562_28617[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28535 === (25))){
var inst_28465 = (state_28534[(22)]);
var inst_28486 = (state_28534[(2)]);
var inst_28487 = event_msg_handler.call(null,inst_28486);
var inst_28488 = [inst_28487];
var inst_28489 = (new cljs.core.PersistentVector(null,1,(5),inst_28465,inst_28488,null));
var state_28534__$1 = state_28534;
var statearr_28563_28618 = state_28534__$1;
(statearr_28563_28618[(2)] = inst_28489);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28534__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28535 === (34))){
var inst_28503 = (state_28534[(13)]);
var inst_28511 = (state_28534[(2)]);
var inst_28512 = [inst_28511];
var inst_28513 = (new cljs.core.PersistentVector(null,1,(5),inst_28503,inst_28512,null));
var state_28534__$1 = state_28534;
var statearr_28564_28619 = state_28534__$1;
(statearr_28564_28619[(2)] = inst_28513);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28534__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28535 === (17))){
var inst_28493 = (state_28534[(14)]);
var inst_28491 = (state_28534[(15)]);
var inst_28491__$1 = (state_28534[(2)]);
var inst_28492 = cljs.core.nth.call(null,inst_28491__$1,(0),null);
var inst_28493__$1 = cljs.core.nth.call(null,inst_28491__$1,(1),null);
var state_28534__$1 = (function (){var statearr_28565 = state_28534;
(statearr_28565[(14)] = inst_28493__$1);

(statearr_28565[(15)] = inst_28491__$1);

(statearr_28565[(16)] = inst_28492);

return statearr_28565;
})();
if(cljs.core.truth_(inst_28493__$1)){
var statearr_28566_28620 = state_28534__$1;
(statearr_28566_28620[(1)] = (26));

} else {
var statearr_28567_28621 = state_28534__$1;
(statearr_28567_28621[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28535 === (3))){
var inst_28532 = (state_28534[(2)]);
var state_28534__$1 = state_28534;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28534__$1,inst_28532);
} else {
if((state_val_28535 === (12))){
var state_28534__$1 = state_28534;
var statearr_28568_28622 = state_28534__$1;
(statearr_28568_28622[(2)] = false);

(statearr_28568_28622[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28535 === (2))){
var inst_28425 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28426 = [ch_recv,ch_ctrl];
var inst_28427 = (new cljs.core.PersistentVector(null,2,(5),inst_28425,inst_28426,null));
var state_28534__$1 = state_28534;
return cljs.core.async.ioc_alts_BANG_.call(null,state_28534__$1,(4),inst_28427);
} else {
if((state_val_28535 === (23))){
var inst_28429 = (state_28534[(7)]);
var inst_28432 = (state_28534[(8)]);
var inst_28457 = (state_28534[(9)]);
var inst_28456 = (state_28534[(10)]);
var inst_28430 = (state_28534[(11)]);
var inst_28431 = (state_28534[(12)]);
var inst_28474 = (function (){var vec__28424 = inst_28429;
var v = inst_28430;
var p = inst_28431;
var stop_QMARK_ = inst_28432;
var map__28435 = inst_28456;
var event_msg = inst_28456;
var event = inst_28457;
return ((function (vec__28424,v,p,stop_QMARK_,map__28435,event_msg,event,inst_28429,inst_28432,inst_28457,inst_28456,inst_28430,inst_28431,state_val_28535,c__14368__auto___28595,map__28421,map__28421__$1,trace_evs_QMARK_,error_handler,ch_ctrl){
return (function (){
return event_msg;
});
;})(vec__28424,v,p,stop_QMARK_,map__28435,event_msg,event,inst_28429,inst_28432,inst_28457,inst_28456,inst_28430,inst_28431,state_val_28535,c__14368__auto___28595,map__28421,map__28421__$1,trace_evs_QMARK_,error_handler,ch_ctrl))
})();
var inst_28475 = (new cljs.core.Delay(inst_28474,null));
var inst_28476 = new cljs.core.Symbol(null,"event-msg","event-msg",-509558413,null);
var inst_28477 = new cljs.core.Symbol(null,"server-event-msg?","server-event-msg?",-1249957951,null);
var inst_28478 = taoensso.encore.hcond.call(null,true,"taoensso.sente",null,inst_28475,inst_28476,taoensso.sente.server_event_msg_QMARK_,inst_28477);
var state_28534__$1 = state_28534;
var statearr_28569_28623 = state_28534__$1;
(statearr_28569_28623[(2)] = inst_28478);

(statearr_28569_28623[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28535 === (35))){
var inst_28493 = (state_28534[(14)]);
var inst_28429 = (state_28534[(7)]);
var inst_28432 = (state_28534[(8)]);
var inst_28457 = (state_28534[(9)]);
var inst_28491 = (state_28534[(15)]);
var inst_28456 = (state_28534[(10)]);
var inst_28515 = (state_28534[(18)]);
var inst_28517 = (state_28534[(19)]);
var inst_28516 = (state_28534[(20)]);
var inst_28430 = (state_28534[(11)]);
var inst_28431 = (state_28534[(12)]);
var inst_28519 = (function (){var p = inst_28431;
var _QMARK_error = inst_28493;
var v = inst_28430;
var _ = inst_28516;
var vec__28424 = inst_28429;
var e2 = inst_28517;
var _QMARK_error2 = inst_28517;
var event_msg = inst_28456;
var e = inst_28493;
var temp__4657__auto__ = inst_28517;
var event = inst_28457;
var vec__28436 = inst_28491;
var stop_QMARK_ = inst_28432;
var vec__28495 = inst_28515;
var map__28435 = inst_28456;
return ((function (p,_QMARK_error,v,_,vec__28424,e2,_QMARK_error2,event_msg,e,temp__4657__auto__,event,vec__28436,stop_QMARK_,vec__28495,map__28435,inst_28493,inst_28429,inst_28432,inst_28457,inst_28491,inst_28456,inst_28515,inst_28517,inst_28516,inst_28430,inst_28431,state_val_28535,c__14368__auto___28595,map__28421,map__28421__$1,trace_evs_QMARK_,error_handler,ch_ctrl){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [e2,"Chsk router `error-handler` error: %s",event], null);
});
;})(p,_QMARK_error,v,_,vec__28424,e2,_QMARK_error2,event_msg,e,temp__4657__auto__,event,vec__28436,stop_QMARK_,vec__28495,map__28435,inst_28493,inst_28429,inst_28432,inst_28457,inst_28491,inst_28456,inst_28515,inst_28517,inst_28516,inst_28430,inst_28431,state_val_28535,c__14368__auto___28595,map__28421,map__28421__$1,trace_evs_QMARK_,error_handler,ch_ctrl))
})();
var inst_28520 = (new cljs.core.Delay(inst_28519,null));
var inst_28521 = taoensso.timbre.log1_fn.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"error","error",-978969032),"taoensso.sente","/tmp/form-init5145320441605965266.clj",null,new cljs.core.Keyword(null,"f","f",-1597136552),inst_28520,null);
var state_28534__$1 = state_28534;
var statearr_28570_28624 = state_28534__$1;
(statearr_28570_28624[(2)] = inst_28521);

(statearr_28570_28624[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28535 === (19))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_28534,(18),Error,null,(17));
var inst_28465 = cljs.core.PersistentVector.EMPTY_NODE;
var state_28534__$1 = (function (){var statearr_28571 = state_28534;
(statearr_28571[(22)] = inst_28465);

return statearr_28571;
})();
if(cljs.core.truth_(trace_evs_QMARK_)){
var statearr_28572_28625 = state_28534__$1;
(statearr_28572_28625[(1)] = (20));

} else {
var statearr_28573_28626 = state_28534__$1;
(statearr_28573_28626[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28535 === (11))){
var state_28534__$1 = state_28534;
var statearr_28574_28627 = state_28534__$1;
(statearr_28574_28627[(2)] = true);

(statearr_28574_28627[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28535 === (9))){
var state_28534__$1 = state_28534;
var statearr_28575_28628 = state_28534__$1;
(statearr_28575_28628[(2)] = false);

(statearr_28575_28628[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28535 === (5))){
var state_28534__$1 = state_28534;
var statearr_28576_28629 = state_28534__$1;
(statearr_28576_28629[(2)] = null);

(statearr_28576_28629[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28535 === (14))){
var inst_28430 = (state_28534[(11)]);
var inst_28453 = cljs.core.apply.call(null,cljs.core.hash_map,inst_28430);
var state_28534__$1 = state_28534;
var statearr_28577_28630 = state_28534__$1;
(statearr_28577_28630[(2)] = inst_28453);

(statearr_28577_28630[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28535 === (26))){
var state_28534__$1 = state_28534;
var statearr_28578_28631 = state_28534__$1;
(statearr_28578_28631[(2)] = null);

(statearr_28578_28631[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28535 === (16))){
var inst_28456 = (state_28534[(10)]);
var inst_28456__$1 = (state_28534[(2)]);
var inst_28457 = cljs.core.get.call(null,inst_28456__$1,new cljs.core.Keyword(null,"event","event",301435442));
var state_28534__$1 = (function (){var statearr_28579 = state_28534;
(statearr_28579[(9)] = inst_28457);

(statearr_28579[(10)] = inst_28456__$1);

return statearr_28579;
})();
var statearr_28580_28632 = state_28534__$1;
(statearr_28580_28632[(2)] = null);

(statearr_28580_28632[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28535 === (30))){
var inst_28496 = (state_28534[(2)]);
var inst_28497 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28498 = [null,inst_28496];
var inst_28499 = (new cljs.core.PersistentVector(null,2,(5),inst_28497,inst_28498,null));
var state_28534__$1 = state_28534;
var statearr_28581_28633 = state_28534__$1;
(statearr_28581_28633[(2)] = inst_28499);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28534__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28535 === (10))){
var inst_28451 = (state_28534[(2)]);
var state_28534__$1 = state_28534;
if(cljs.core.truth_(inst_28451)){
var statearr_28582_28634 = state_28534__$1;
(statearr_28582_28634[(1)] = (14));

} else {
var statearr_28583_28635 = state_28534__$1;
(statearr_28583_28635[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28535 === (18))){
var inst_28458 = (state_28534[(2)]);
var inst_28459 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28460 = [null,inst_28458];
var inst_28461 = (new cljs.core.PersistentVector(null,2,(5),inst_28459,inst_28460,null));
var state_28534__$1 = state_28534;
var statearr_28584_28636 = state_28534__$1;
(statearr_28584_28636[(2)] = inst_28461);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28534__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28535 === (37))){
var inst_28524 = (state_28534[(2)]);
var state_28534__$1 = state_28534;
var statearr_28585_28637 = state_28534__$1;
(statearr_28585_28637[(2)] = inst_28524);

(statearr_28585_28637[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28535 === (8))){
var inst_28430 = (state_28534[(11)]);
var inst_28441 = inst_28430.cljs$lang$protocol_mask$partition0$;
var inst_28442 = (inst_28441 & (64));
var inst_28443 = inst_28430.cljs$core$ISeq$;
var inst_28444 = (inst_28442) || (inst_28443);
var state_28534__$1 = state_28534;
if(cljs.core.truth_(inst_28444)){
var statearr_28586_28638 = state_28534__$1;
(statearr_28586_28638[(1)] = (11));

} else {
var statearr_28587_28639 = state_28534__$1;
(statearr_28587_28639[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14368__auto___28595,map__28421,map__28421__$1,trace_evs_QMARK_,error_handler,ch_ctrl))
;
return ((function (switch__14236__auto__,c__14368__auto___28595,map__28421,map__28421__$1,trace_evs_QMARK_,error_handler,ch_ctrl){
return (function() {
var taoensso$sente$_start_chsk_router_BANG__$_state_machine__14237__auto__ = null;
var taoensso$sente$_start_chsk_router_BANG__$_state_machine__14237__auto____0 = (function (){
var statearr_28591 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28591[(0)] = taoensso$sente$_start_chsk_router_BANG__$_state_machine__14237__auto__);

(statearr_28591[(1)] = (1));

return statearr_28591;
});
var taoensso$sente$_start_chsk_router_BANG__$_state_machine__14237__auto____1 = (function (state_28534){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_28534);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e28592){if((e28592 instanceof Object)){
var ex__14240__auto__ = e28592;
var statearr_28593_28640 = state_28534;
(statearr_28593_28640[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28534);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28592;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28641 = state_28534;
state_28534 = G__28641;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
taoensso$sente$_start_chsk_router_BANG__$_state_machine__14237__auto__ = function(state_28534){
switch(arguments.length){
case 0:
return taoensso$sente$_start_chsk_router_BANG__$_state_machine__14237__auto____0.call(this);
case 1:
return taoensso$sente$_start_chsk_router_BANG__$_state_machine__14237__auto____1.call(this,state_28534);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
taoensso$sente$_start_chsk_router_BANG__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = taoensso$sente$_start_chsk_router_BANG__$_state_machine__14237__auto____0;
taoensso$sente$_start_chsk_router_BANG__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = taoensso$sente$_start_chsk_router_BANG__$_state_machine__14237__auto____1;
return taoensso$sente$_start_chsk_router_BANG__$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14368__auto___28595,map__28421,map__28421__$1,trace_evs_QMARK_,error_handler,ch_ctrl))
})();
var state__14370__auto__ = (function (){var statearr_28594 = f__14369__auto__.call(null);
(statearr_28594[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14368__auto___28595);

return statearr_28594;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14370__auto__);
});})(c__14368__auto___28595,map__28421,map__28421__$1,trace_evs_QMARK_,error_handler,ch_ctrl))
);


return ((function (map__28421,map__28421__$1,trace_evs_QMARK_,error_handler,ch_ctrl){
return (function taoensso$sente$_start_chsk_router_BANG__$_stop_BANG_(){
return cljs.core.async.close_BANG_.call(null,ch_ctrl);
});
;})(map__28421,map__28421__$1,trace_evs_QMARK_,error_handler,ch_ctrl))
});
/**
 * Creates a go-loop to call `(event-msg-handler <server-event-msg>)` and
 *   returns a `(fn stop! [])`. Catches & logs errors.
 * 
 *   Advanced users may instead prefer to write their own loop against `ch-recv`.
 */
taoensso.sente.start_server_chsk_router_BANG_ = (function taoensso$sente$start_server_chsk_router_BANG_(var_args){
var args__7114__auto__ = [];
var len__7107__auto___28649 = arguments.length;
var i__7108__auto___28650 = (0);
while(true){
if((i__7108__auto___28650 < len__7107__auto___28649)){
args__7114__auto__.push((arguments[i__7108__auto___28650]));

var G__28651 = (i__7108__auto___28650 + (1));
i__7108__auto___28650 = G__28651;
continue;
} else {
}
break;
}

var argseq__7115__auto__ = ((((2) < args__7114__auto__.length))?(new cljs.core.IndexedSeq(args__7114__auto__.slice((2)),(0))):null);
return taoensso.sente.start_server_chsk_router_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7115__auto__);
});

taoensso.sente.start_server_chsk_router_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ch_recv,event_msg_handler,p__28645){
var vec__28646 = p__28645;
var map__28647 = cljs.core.nth.call(null,vec__28646,(0),null);
var map__28647__$1 = ((((!((map__28647 == null)))?((((map__28647.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28647.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28647):map__28647);
var opts = map__28647__$1;
var trace_evs_QMARK_ = cljs.core.get.call(null,map__28647__$1,new cljs.core.Keyword(null,"trace-evs?","trace-evs?",1502453512));
var error_handler = cljs.core.get.call(null,map__28647__$1,new cljs.core.Keyword(null,"error-handler","error-handler",-484945776));
return taoensso.sente._start_chsk_router_BANG_.call(null,new cljs.core.Keyword(null,"server","server",1499190120),ch_recv,event_msg_handler,opts);
});

taoensso.sente.start_server_chsk_router_BANG_.cljs$lang$maxFixedArity = (2);

taoensso.sente.start_server_chsk_router_BANG_.cljs$lang$applyTo = (function (seq28642){
var G__28643 = cljs.core.first.call(null,seq28642);
var seq28642__$1 = cljs.core.next.call(null,seq28642);
var G__28644 = cljs.core.first.call(null,seq28642__$1);
var seq28642__$2 = cljs.core.next.call(null,seq28642__$1);
return taoensso.sente.start_server_chsk_router_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__28643,G__28644,seq28642__$2);
});
/**
 * Creates a go-loop to call `(event-msg-handler <client-event-msg>)` and
 *   returns a `(fn stop! [])`. Catches & logs errors.
 * 
 *   Advanced users may instead prefer to write their own loop against `ch-recv`.
 */
taoensso.sente.start_client_chsk_router_BANG_ = (function taoensso$sente$start_client_chsk_router_BANG_(var_args){
var args__7114__auto__ = [];
var len__7107__auto___28659 = arguments.length;
var i__7108__auto___28660 = (0);
while(true){
if((i__7108__auto___28660 < len__7107__auto___28659)){
args__7114__auto__.push((arguments[i__7108__auto___28660]));

var G__28661 = (i__7108__auto___28660 + (1));
i__7108__auto___28660 = G__28661;
continue;
} else {
}
break;
}

var argseq__7115__auto__ = ((((2) < args__7114__auto__.length))?(new cljs.core.IndexedSeq(args__7114__auto__.slice((2)),(0))):null);
return taoensso.sente.start_client_chsk_router_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7115__auto__);
});

taoensso.sente.start_client_chsk_router_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ch_recv,event_msg_handler,p__28655){
var vec__28656 = p__28655;
var map__28657 = cljs.core.nth.call(null,vec__28656,(0),null);
var map__28657__$1 = ((((!((map__28657 == null)))?((((map__28657.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28657.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28657):map__28657);
var opts = map__28657__$1;
var trace_evs_QMARK_ = cljs.core.get.call(null,map__28657__$1,new cljs.core.Keyword(null,"trace-evs?","trace-evs?",1502453512));
var error_handler = cljs.core.get.call(null,map__28657__$1,new cljs.core.Keyword(null,"error-handler","error-handler",-484945776));
return taoensso.sente._start_chsk_router_BANG_.call(null,cljs.core.not.call(null,new cljs.core.Keyword(null,"server","server",1499190120)),ch_recv,event_msg_handler,opts);
});

taoensso.sente.start_client_chsk_router_BANG_.cljs$lang$maxFixedArity = (2);

taoensso.sente.start_client_chsk_router_BANG_.cljs$lang$applyTo = (function (seq28652){
var G__28653 = cljs.core.first.call(null,seq28652);
var seq28652__$1 = cljs.core.next.call(null,seq28652);
var G__28654 = cljs.core.first.call(null,seq28652__$1);
var seq28652__$2 = cljs.core.next.call(null,seq28652__$1);
return taoensso.sente.start_client_chsk_router_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__28653,G__28654,seq28652__$2);
});
/**
 * Alias for `make-channel-socket-client!`
 */
taoensso.sente.make_channel_socket_BANG_ = (function taoensso$sente$make_channel_socket_BANG_(var_args){
var args__7114__auto__ = [];
var len__7107__auto___28663 = arguments.length;
var i__7108__auto___28664 = (0);
while(true){
if((i__7108__auto___28664 < len__7107__auto___28663)){
args__7114__auto__.push((arguments[i__7108__auto___28664]));

var G__28665 = (i__7108__auto___28664 + (1));
i__7108__auto___28664 = G__28665;
continue;
} else {
}
break;
}

var argseq__7115__auto__ = ((((0) < args__7114__auto__.length))?(new cljs.core.IndexedSeq(args__7114__auto__.slice((0)),(0))):null);
return taoensso.sente.make_channel_socket_BANG_.cljs$core$IFn$_invoke$arity$variadic(argseq__7115__auto__);
});

taoensso.sente.make_channel_socket_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.call(null,taoensso.sente.make_channel_socket_client_BANG_,args);
});

taoensso.sente.make_channel_socket_BANG_.cljs$lang$maxFixedArity = (0);

taoensso.sente.make_channel_socket_BANG_.cljs$lang$applyTo = (function (seq28662){
return taoensso.sente.make_channel_socket_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28662));
});
/**
 * Alias for `start-client-chsk-router!`
 */
taoensso.sente.start_chsk_router_BANG_ = (function taoensso$sente$start_chsk_router_BANG_(var_args){
var args__7114__auto__ = [];
var len__7107__auto___28667 = arguments.length;
var i__7108__auto___28668 = (0);
while(true){
if((i__7108__auto___28668 < len__7107__auto___28667)){
args__7114__auto__.push((arguments[i__7108__auto___28668]));

var G__28669 = (i__7108__auto___28668 + (1));
i__7108__auto___28668 = G__28669;
continue;
} else {
}
break;
}

var argseq__7115__auto__ = ((((0) < args__7114__auto__.length))?(new cljs.core.IndexedSeq(args__7114__auto__.slice((0)),(0))):null);
return taoensso.sente.start_chsk_router_BANG_.cljs$core$IFn$_invoke$arity$variadic(argseq__7115__auto__);
});

taoensso.sente.start_chsk_router_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.call(null,taoensso.sente.start_client_chsk_router_BANG_,args);
});

taoensso.sente.start_chsk_router_BANG_.cljs$lang$maxFixedArity = (0);

taoensso.sente.start_chsk_router_BANG_.cljs$lang$applyTo = (function (seq28666){
return taoensso.sente.start_chsk_router_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28666));
});
/**
 * DEPRECATED: Please use `start-chsk-router!` instead.
 */
taoensso.sente.start_chsk_router_loop_BANG_ = (function taoensso$sente$start_chsk_router_loop_BANG_(event_handler,ch_recv){
return taoensso.sente.start_client_chsk_router_BANG_.call(null,ch_recv,(function (ev_msg){
return event_handler.call(null,new cljs.core.Keyword(null,"event","event",301435442).cljs$core$IFn$_invoke$arity$1(ev_msg),new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861).cljs$core$IFn$_invoke$arity$1(ev_msg));
}));
});
/**
 * DEPRECATED. Please use `timbre/set-level!` instead.
 */
taoensso.sente.set_logging_level_BANG_ = (function taoensso$sente$set_logging_level_BANG_(level){
return taoensso.timbre.set_level_BANG_.call(null,level);
});
/**
 * DEPRECATED: Please use `ajax-lite` instead.
 */
taoensso.sente.ajax_call = taoensso.encore.ajax_lite;
/**
 * DEPRECATED
 */
taoensso.sente.default_chsk_url_fn = (function taoensso$sente$default_chsk_url_fn(path,p__28670,websocket_QMARK_){
var map__28673 = p__28670;
var map__28673__$1 = ((((!((map__28673 == null)))?((((map__28673.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28673.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28673):map__28673);
var location = map__28673__$1;
var adjusted_protocol = cljs.core.get.call(null,map__28673__$1,new cljs.core.Keyword(null,"adjusted-protocol","adjusted-protocol",37431492));
var host = cljs.core.get.call(null,map__28673__$1,new cljs.core.Keyword(null,"host","host",-1558485167));
var pathname = cljs.core.get.call(null,map__28673__$1,new cljs.core.Keyword(null,"pathname","pathname",-1420497528));
return [cljs.core.str(adjusted_protocol),cljs.core.str("//"),cljs.core.str(host),cljs.core.str((function (){var or__6049__auto__ = path;
if(cljs.core.truth_(or__6049__auto__)){
return or__6049__auto__;
} else {
return pathname;
}
})())].join('');
});

//# sourceMappingURL=sente.js.map?rel=1472741874460