// Compiled by ClojureScript 1.7.228 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args14413 = [];
var len__7107__auto___14419 = arguments.length;
var i__7108__auto___14420 = (0);
while(true){
if((i__7108__auto___14420 < len__7107__auto___14419)){
args14413.push((arguments[i__7108__auto___14420]));

var G__14421 = (i__7108__auto___14420 + (1));
i__7108__auto___14420 = G__14421;
continue;
} else {
}
break;
}

var G__14415 = args14413.length;
switch (G__14415) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14413.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async14416 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14416 = (function (f,blockable,meta14417){
this.f = f;
this.blockable = blockable;
this.meta14417 = meta14417;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14416.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14418,meta14417__$1){
var self__ = this;
var _14418__$1 = this;
return (new cljs.core.async.t_cljs$core$async14416(self__.f,self__.blockable,meta14417__$1));
});

cljs.core.async.t_cljs$core$async14416.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14418){
var self__ = this;
var _14418__$1 = this;
return self__.meta14417;
});

cljs.core.async.t_cljs$core$async14416.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async14416.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async14416.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async14416.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async14416.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta14417","meta14417",934874346,null)], null);
});

cljs.core.async.t_cljs$core$async14416.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14416.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14416";

cljs.core.async.t_cljs$core$async14416.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async14416");
});

cljs.core.async.__GT_t_cljs$core$async14416 = (function cljs$core$async$__GT_t_cljs$core$async14416(f__$1,blockable__$1,meta14417){
return (new cljs.core.async.t_cljs$core$async14416(f__$1,blockable__$1,meta14417));
});

}

return (new cljs.core.async.t_cljs$core$async14416(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args14435 = [];
var len__7107__auto___14442 = arguments.length;
var i__7108__auto___14443 = (0);
while(true){
if((i__7108__auto___14443 < len__7107__auto___14442)){
args14435.push((arguments[i__7108__auto___14443]));

var G__14444 = (i__7108__auto___14443 + (1));
i__7108__auto___14443 = G__14444;
continue;
} else {
}
break;
}

var G__14437 = args14435.length;
switch (G__14437) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14435.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args14450 = [];
var len__7107__auto___14454 = arguments.length;
var i__7108__auto___14455 = (0);
while(true){
if((i__7108__auto___14455 < len__7107__auto___14454)){
args14450.push((arguments[i__7108__auto___14455]));

var G__14456 = (i__7108__auto___14455 + (1));
i__7108__auto___14455 = G__14456;
continue;
} else {
}
break;
}

var G__14452 = args14450.length;
switch (G__14452) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14450.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args14461 = [];
var len__7107__auto___14469 = arguments.length;
var i__7108__auto___14470 = (0);
while(true){
if((i__7108__auto___14470 < len__7107__auto___14469)){
args14461.push((arguments[i__7108__auto___14470]));

var G__14473 = (i__7108__auto___14470 + (1));
i__7108__auto___14470 = G__14473;
continue;
} else {
}
break;
}

var G__14464 = args14461.length;
switch (G__14464) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14461.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_14475 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_14475);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_14475,ret){
return (function (){
return fn1.call(null,val_14475);
});})(val_14475,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args14479 = [];
var len__7107__auto___14484 = arguments.length;
var i__7108__auto___14485 = (0);
while(true){
if((i__7108__auto___14485 < len__7107__auto___14484)){
args14479.push((arguments[i__7108__auto___14485]));

var G__14488 = (i__7108__auto___14485 + (1));
i__7108__auto___14485 = G__14488;
continue;
} else {
}
break;
}

var G__14481 = args14479.length;
switch (G__14481) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14479.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__6952__auto___14498 = n;
var x_14499 = (0);
while(true){
if((x_14499 < n__6952__auto___14498)){
(a[x_14499] = (0));

var G__14500 = (x_14499 + (1));
x_14499 = G__14500;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__14501 = (i + (1));
i = G__14501;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async14506 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14506 = (function (alt_flag,flag,meta14507){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta14507 = meta14507;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14506.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_14508,meta14507__$1){
var self__ = this;
var _14508__$1 = this;
return (new cljs.core.async.t_cljs$core$async14506(self__.alt_flag,self__.flag,meta14507__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async14506.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_14508){
var self__ = this;
var _14508__$1 = this;
return self__.meta14507;
});})(flag))
;

cljs.core.async.t_cljs$core$async14506.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async14506.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async14506.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async14506.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async14506.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta14507","meta14507",-708852072,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async14506.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14506.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14506";

cljs.core.async.t_cljs$core$async14506.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async14506");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async14506 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async14506(alt_flag__$1,flag__$1,meta14507){
return (new cljs.core.async.t_cljs$core$async14506(alt_flag__$1,flag__$1,meta14507));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async14506(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async14512 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14512 = (function (alt_handler,flag,cb,meta14513){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta14513 = meta14513;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14512.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14514,meta14513__$1){
var self__ = this;
var _14514__$1 = this;
return (new cljs.core.async.t_cljs$core$async14512(self__.alt_handler,self__.flag,self__.cb,meta14513__$1));
});

cljs.core.async.t_cljs$core$async14512.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14514){
var self__ = this;
var _14514__$1 = this;
return self__.meta14513;
});

cljs.core.async.t_cljs$core$async14512.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async14512.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async14512.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async14512.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async14512.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta14513","meta14513",-446486442,null)], null);
});

cljs.core.async.t_cljs$core$async14512.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14512.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14512";

cljs.core.async.t_cljs$core$async14512.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async14512");
});

cljs.core.async.__GT_t_cljs$core$async14512 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async14512(alt_handler__$1,flag__$1,cb__$1,meta14513){
return (new cljs.core.async.t_cljs$core$async14512(alt_handler__$1,flag__$1,cb__$1,meta14513));
});

}

return (new cljs.core.async.t_cljs$core$async14512(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__14519_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__14519_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__14520_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__14520_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__6049__auto__ = wport;
if(cljs.core.truth_(or__6049__auto__)){
return or__6049__auto__;
} else {
return port;
}
})()], null));
} else {
var G__14527 = (i + (1));
i = G__14527;
continue;
}
} else {
return null;
}
break;
}
})();
var or__6049__auto__ = ret;
if(cljs.core.truth_(or__6049__auto__)){
return or__6049__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__6037__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__6037__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__6037__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__7114__auto__ = [];
var len__7107__auto___14535 = arguments.length;
var i__7108__auto___14536 = (0);
while(true){
if((i__7108__auto___14536 < len__7107__auto___14535)){
args__7114__auto__.push((arguments[i__7108__auto___14536]));

var G__14537 = (i__7108__auto___14536 + (1));
i__7108__auto___14536 = G__14537;
continue;
} else {
}
break;
}

var argseq__7115__auto__ = ((((1) < args__7114__auto__.length))?(new cljs.core.IndexedSeq(args__7114__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7115__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__14532){
var map__14533 = p__14532;
var map__14533__$1 = ((((!((map__14533 == null)))?((((map__14533.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14533.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14533):map__14533);
var opts = map__14533__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq14530){
var G__14531 = cljs.core.first.call(null,seq14530);
var seq14530__$1 = cljs.core.next.call(null,seq14530);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__14531,seq14530__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args14538 = [];
var len__7107__auto___14595 = arguments.length;
var i__7108__auto___14596 = (0);
while(true){
if((i__7108__auto___14596 < len__7107__auto___14595)){
args14538.push((arguments[i__7108__auto___14596]));

var G__14597 = (i__7108__auto___14596 + (1));
i__7108__auto___14596 = G__14597;
continue;
} else {
}
break;
}

var G__14540 = args14538.length;
switch (G__14540) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14538.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__14355__auto___14601 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14355__auto___14601){
return (function (){
var f__14356__auto__ = (function (){var switch__14236__auto__ = ((function (c__14355__auto___14601){
return (function (state_14565){
var state_val_14566 = (state_14565[(1)]);
if((state_val_14566 === (7))){
var inst_14560 = (state_14565[(2)]);
var state_14565__$1 = state_14565;
var statearr_14571_14602 = state_14565__$1;
(statearr_14571_14602[(2)] = inst_14560);

(statearr_14571_14602[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14566 === (1))){
var state_14565__$1 = state_14565;
var statearr_14573_14603 = state_14565__$1;
(statearr_14573_14603[(2)] = null);

(statearr_14573_14603[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14566 === (4))){
var inst_14543 = (state_14565[(7)]);
var inst_14543__$1 = (state_14565[(2)]);
var inst_14544 = (inst_14543__$1 == null);
var state_14565__$1 = (function (){var statearr_14575 = state_14565;
(statearr_14575[(7)] = inst_14543__$1);

return statearr_14575;
})();
if(cljs.core.truth_(inst_14544)){
var statearr_14576_14604 = state_14565__$1;
(statearr_14576_14604[(1)] = (5));

} else {
var statearr_14577_14605 = state_14565__$1;
(statearr_14577_14605[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14566 === (13))){
var state_14565__$1 = state_14565;
var statearr_14578_14607 = state_14565__$1;
(statearr_14578_14607[(2)] = null);

(statearr_14578_14607[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14566 === (6))){
var inst_14543 = (state_14565[(7)]);
var state_14565__$1 = state_14565;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14565__$1,(11),to,inst_14543);
} else {
if((state_val_14566 === (3))){
var inst_14562 = (state_14565[(2)]);
var state_14565__$1 = state_14565;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14565__$1,inst_14562);
} else {
if((state_val_14566 === (12))){
var state_14565__$1 = state_14565;
var statearr_14579_14610 = state_14565__$1;
(statearr_14579_14610[(2)] = null);

(statearr_14579_14610[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14566 === (2))){
var state_14565__$1 = state_14565;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14565__$1,(4),from);
} else {
if((state_val_14566 === (11))){
var inst_14553 = (state_14565[(2)]);
var state_14565__$1 = state_14565;
if(cljs.core.truth_(inst_14553)){
var statearr_14580_14611 = state_14565__$1;
(statearr_14580_14611[(1)] = (12));

} else {
var statearr_14581_14612 = state_14565__$1;
(statearr_14581_14612[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14566 === (9))){
var state_14565__$1 = state_14565;
var statearr_14582_14613 = state_14565__$1;
(statearr_14582_14613[(2)] = null);

(statearr_14582_14613[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14566 === (5))){
var state_14565__$1 = state_14565;
if(cljs.core.truth_(close_QMARK_)){
var statearr_14583_14616 = state_14565__$1;
(statearr_14583_14616[(1)] = (8));

} else {
var statearr_14584_14619 = state_14565__$1;
(statearr_14584_14619[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14566 === (14))){
var inst_14558 = (state_14565[(2)]);
var state_14565__$1 = state_14565;
var statearr_14585_14620 = state_14565__$1;
(statearr_14585_14620[(2)] = inst_14558);

(statearr_14585_14620[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14566 === (10))){
var inst_14550 = (state_14565[(2)]);
var state_14565__$1 = state_14565;
var statearr_14586_14621 = state_14565__$1;
(statearr_14586_14621[(2)] = inst_14550);

(statearr_14586_14621[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14566 === (8))){
var inst_14547 = cljs.core.async.close_BANG_.call(null,to);
var state_14565__$1 = state_14565;
var statearr_14587_14626 = state_14565__$1;
(statearr_14587_14626[(2)] = inst_14547);

(statearr_14587_14626[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14355__auto___14601))
;
return ((function (switch__14236__auto__,c__14355__auto___14601){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_14591 = [null,null,null,null,null,null,null,null];
(statearr_14591[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_14591[(1)] = (1));

return statearr_14591;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_14565){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14565);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e14592){if((e14592 instanceof Object)){
var ex__14240__auto__ = e14592;
var statearr_14593_14631 = state_14565;
(statearr_14593_14631[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14565);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14592;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14634 = state_14565;
state_14565 = G__14634;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_14565){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_14565);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14355__auto___14601))
})();
var state__14357__auto__ = (function (){var statearr_14594 = f__14356__auto__.call(null);
(statearr_14594[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14355__auto___14601);

return statearr_14594;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14357__auto__);
});})(c__14355__auto___14601))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__14841){
var vec__14842 = p__14841;
var v = cljs.core.nth.call(null,vec__14842,(0),null);
var p = cljs.core.nth.call(null,vec__14842,(1),null);
var job = vec__14842;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__14355__auto___15025 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14355__auto___15025,res,vec__14842,v,p,job,jobs,results){
return (function (){
var f__14356__auto__ = (function (){var switch__14236__auto__ = ((function (c__14355__auto___15025,res,vec__14842,v,p,job,jobs,results){
return (function (state_14847){
var state_val_14848 = (state_14847[(1)]);
if((state_val_14848 === (1))){
var state_14847__$1 = state_14847;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14847__$1,(2),res,v);
} else {
if((state_val_14848 === (2))){
var inst_14844 = (state_14847[(2)]);
var inst_14845 = cljs.core.async.close_BANG_.call(null,res);
var state_14847__$1 = (function (){var statearr_14850 = state_14847;
(statearr_14850[(7)] = inst_14844);

return statearr_14850;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14847__$1,inst_14845);
} else {
return null;
}
}
});})(c__14355__auto___15025,res,vec__14842,v,p,job,jobs,results))
;
return ((function (switch__14236__auto__,c__14355__auto___15025,res,vec__14842,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_14854 = [null,null,null,null,null,null,null,null];
(statearr_14854[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__);

(statearr_14854[(1)] = (1));

return statearr_14854;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1 = (function (state_14847){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14847);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e14855){if((e14855 instanceof Object)){
var ex__14240__auto__ = e14855;
var statearr_14856_15028 = state_14847;
(statearr_14856_15028[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14847);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14855;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15029 = state_14847;
state_14847 = G__15029;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = function(state_14847){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1.call(this,state_14847);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14355__auto___15025,res,vec__14842,v,p,job,jobs,results))
})();
var state__14357__auto__ = (function (){var statearr_14857 = f__14356__auto__.call(null);
(statearr_14857[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14355__auto___15025);

return statearr_14857;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14357__auto__);
});})(c__14355__auto___15025,res,vec__14842,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__14858){
var vec__14859 = p__14858;
var v = cljs.core.nth.call(null,vec__14859,(0),null);
var p = cljs.core.nth.call(null,vec__14859,(1),null);
var job = vec__14859;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__6952__auto___15030 = n;
var __15031 = (0);
while(true){
if((__15031 < n__6952__auto___15030)){
var G__14860_15032 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__14860_15032) {
case "compute":
var c__14355__auto___15034 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__15031,c__14355__auto___15034,G__14860_15032,n__6952__auto___15030,jobs,results,process,async){
return (function (){
var f__14356__auto__ = (function (){var switch__14236__auto__ = ((function (__15031,c__14355__auto___15034,G__14860_15032,n__6952__auto___15030,jobs,results,process,async){
return (function (state_14873){
var state_val_14874 = (state_14873[(1)]);
if((state_val_14874 === (1))){
var state_14873__$1 = state_14873;
var statearr_14875_15035 = state_14873__$1;
(statearr_14875_15035[(2)] = null);

(statearr_14875_15035[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14874 === (2))){
var state_14873__$1 = state_14873;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14873__$1,(4),jobs);
} else {
if((state_val_14874 === (3))){
var inst_14871 = (state_14873[(2)]);
var state_14873__$1 = state_14873;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14873__$1,inst_14871);
} else {
if((state_val_14874 === (4))){
var inst_14863 = (state_14873[(2)]);
var inst_14864 = process.call(null,inst_14863);
var state_14873__$1 = state_14873;
if(cljs.core.truth_(inst_14864)){
var statearr_14876_15036 = state_14873__$1;
(statearr_14876_15036[(1)] = (5));

} else {
var statearr_14877_15037 = state_14873__$1;
(statearr_14877_15037[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14874 === (5))){
var state_14873__$1 = state_14873;
var statearr_14878_15039 = state_14873__$1;
(statearr_14878_15039[(2)] = null);

(statearr_14878_15039[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14874 === (6))){
var state_14873__$1 = state_14873;
var statearr_14879_15040 = state_14873__$1;
(statearr_14879_15040[(2)] = null);

(statearr_14879_15040[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14874 === (7))){
var inst_14869 = (state_14873[(2)]);
var state_14873__$1 = state_14873;
var statearr_14880_15042 = state_14873__$1;
(statearr_14880_15042[(2)] = inst_14869);

(statearr_14880_15042[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__15031,c__14355__auto___15034,G__14860_15032,n__6952__auto___15030,jobs,results,process,async))
;
return ((function (__15031,switch__14236__auto__,c__14355__auto___15034,G__14860_15032,n__6952__auto___15030,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_14884 = [null,null,null,null,null,null,null];
(statearr_14884[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__);

(statearr_14884[(1)] = (1));

return statearr_14884;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1 = (function (state_14873){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14873);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e14885){if((e14885 instanceof Object)){
var ex__14240__auto__ = e14885;
var statearr_14886_15043 = state_14873;
(statearr_14886_15043[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14873);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14885;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15044 = state_14873;
state_14873 = G__15044;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = function(state_14873){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1.call(this,state_14873);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__;
})()
;})(__15031,switch__14236__auto__,c__14355__auto___15034,G__14860_15032,n__6952__auto___15030,jobs,results,process,async))
})();
var state__14357__auto__ = (function (){var statearr_14887 = f__14356__auto__.call(null);
(statearr_14887[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14355__auto___15034);

return statearr_14887;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14357__auto__);
});})(__15031,c__14355__auto___15034,G__14860_15032,n__6952__auto___15030,jobs,results,process,async))
);


break;
case "async":
var c__14355__auto___15045 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__15031,c__14355__auto___15045,G__14860_15032,n__6952__auto___15030,jobs,results,process,async){
return (function (){
var f__14356__auto__ = (function (){var switch__14236__auto__ = ((function (__15031,c__14355__auto___15045,G__14860_15032,n__6952__auto___15030,jobs,results,process,async){
return (function (state_14900){
var state_val_14901 = (state_14900[(1)]);
if((state_val_14901 === (1))){
var state_14900__$1 = state_14900;
var statearr_14902_15046 = state_14900__$1;
(statearr_14902_15046[(2)] = null);

(statearr_14902_15046[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14901 === (2))){
var state_14900__$1 = state_14900;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14900__$1,(4),jobs);
} else {
if((state_val_14901 === (3))){
var inst_14898 = (state_14900[(2)]);
var state_14900__$1 = state_14900;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14900__$1,inst_14898);
} else {
if((state_val_14901 === (4))){
var inst_14890 = (state_14900[(2)]);
var inst_14891 = async.call(null,inst_14890);
var state_14900__$1 = state_14900;
if(cljs.core.truth_(inst_14891)){
var statearr_14903_15047 = state_14900__$1;
(statearr_14903_15047[(1)] = (5));

} else {
var statearr_14904_15048 = state_14900__$1;
(statearr_14904_15048[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14901 === (5))){
var state_14900__$1 = state_14900;
var statearr_14905_15053 = state_14900__$1;
(statearr_14905_15053[(2)] = null);

(statearr_14905_15053[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14901 === (6))){
var state_14900__$1 = state_14900;
var statearr_14906_15056 = state_14900__$1;
(statearr_14906_15056[(2)] = null);

(statearr_14906_15056[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14901 === (7))){
var inst_14896 = (state_14900[(2)]);
var state_14900__$1 = state_14900;
var statearr_14907_15057 = state_14900__$1;
(statearr_14907_15057[(2)] = inst_14896);

(statearr_14907_15057[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__15031,c__14355__auto___15045,G__14860_15032,n__6952__auto___15030,jobs,results,process,async))
;
return ((function (__15031,switch__14236__auto__,c__14355__auto___15045,G__14860_15032,n__6952__auto___15030,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_14911 = [null,null,null,null,null,null,null];
(statearr_14911[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__);

(statearr_14911[(1)] = (1));

return statearr_14911;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1 = (function (state_14900){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14900);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e14912){if((e14912 instanceof Object)){
var ex__14240__auto__ = e14912;
var statearr_14913_15062 = state_14900;
(statearr_14913_15062[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14900);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14912;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15063 = state_14900;
state_14900 = G__15063;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = function(state_14900){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1.call(this,state_14900);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__;
})()
;})(__15031,switch__14236__auto__,c__14355__auto___15045,G__14860_15032,n__6952__auto___15030,jobs,results,process,async))
})();
var state__14357__auto__ = (function (){var statearr_14914 = f__14356__auto__.call(null);
(statearr_14914[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14355__auto___15045);

return statearr_14914;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14357__auto__);
});})(__15031,c__14355__auto___15045,G__14860_15032,n__6952__auto___15030,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__15064 = (__15031 + (1));
__15031 = G__15064;
continue;
} else {
}
break;
}

var c__14355__auto___15065 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14355__auto___15065,jobs,results,process,async){
return (function (){
var f__14356__auto__ = (function (){var switch__14236__auto__ = ((function (c__14355__auto___15065,jobs,results,process,async){
return (function (state_14936){
var state_val_14937 = (state_14936[(1)]);
if((state_val_14937 === (1))){
var state_14936__$1 = state_14936;
var statearr_14938_15066 = state_14936__$1;
(statearr_14938_15066[(2)] = null);

(statearr_14938_15066[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (2))){
var state_14936__$1 = state_14936;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14936__$1,(4),from);
} else {
if((state_val_14937 === (3))){
var inst_14934 = (state_14936[(2)]);
var state_14936__$1 = state_14936;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14936__$1,inst_14934);
} else {
if((state_val_14937 === (4))){
var inst_14917 = (state_14936[(7)]);
var inst_14917__$1 = (state_14936[(2)]);
var inst_14918 = (inst_14917__$1 == null);
var state_14936__$1 = (function (){var statearr_14939 = state_14936;
(statearr_14939[(7)] = inst_14917__$1);

return statearr_14939;
})();
if(inst_14918){
var statearr_14940_15067 = state_14936__$1;
(statearr_14940_15067[(1)] = (5));

} else {
var statearr_14941_15068 = state_14936__$1;
(statearr_14941_15068[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (5))){
var inst_14920 = cljs.core.async.close_BANG_.call(null,jobs);
var state_14936__$1 = state_14936;
var statearr_14942_15069 = state_14936__$1;
(statearr_14942_15069[(2)] = inst_14920);

(statearr_14942_15069[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (6))){
var inst_14917 = (state_14936[(7)]);
var inst_14922 = (state_14936[(8)]);
var inst_14922__$1 = cljs.core.async.chan.call(null,(1));
var inst_14923 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14924 = [inst_14917,inst_14922__$1];
var inst_14925 = (new cljs.core.PersistentVector(null,2,(5),inst_14923,inst_14924,null));
var state_14936__$1 = (function (){var statearr_14943 = state_14936;
(statearr_14943[(8)] = inst_14922__$1);

return statearr_14943;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14936__$1,(8),jobs,inst_14925);
} else {
if((state_val_14937 === (7))){
var inst_14932 = (state_14936[(2)]);
var state_14936__$1 = state_14936;
var statearr_14944_15070 = state_14936__$1;
(statearr_14944_15070[(2)] = inst_14932);

(statearr_14944_15070[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (8))){
var inst_14922 = (state_14936[(8)]);
var inst_14927 = (state_14936[(2)]);
var state_14936__$1 = (function (){var statearr_14945 = state_14936;
(statearr_14945[(9)] = inst_14927);

return statearr_14945;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14936__$1,(9),results,inst_14922);
} else {
if((state_val_14937 === (9))){
var inst_14929 = (state_14936[(2)]);
var state_14936__$1 = (function (){var statearr_14946 = state_14936;
(statearr_14946[(10)] = inst_14929);

return statearr_14946;
})();
var statearr_14947_15071 = state_14936__$1;
(statearr_14947_15071[(2)] = null);

(statearr_14947_15071[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__14355__auto___15065,jobs,results,process,async))
;
return ((function (switch__14236__auto__,c__14355__auto___15065,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_14951 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14951[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__);

(statearr_14951[(1)] = (1));

return statearr_14951;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1 = (function (state_14936){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14936);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e14952){if((e14952 instanceof Object)){
var ex__14240__auto__ = e14952;
var statearr_14953_15074 = state_14936;
(statearr_14953_15074[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14936);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14952;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15075 = state_14936;
state_14936 = G__15075;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = function(state_14936){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1.call(this,state_14936);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14355__auto___15065,jobs,results,process,async))
})();
var state__14357__auto__ = (function (){var statearr_14954 = f__14356__auto__.call(null);
(statearr_14954[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14355__auto___15065);

return statearr_14954;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14357__auto__);
});})(c__14355__auto___15065,jobs,results,process,async))
);


var c__14355__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14355__auto__,jobs,results,process,async){
return (function (){
var f__14356__auto__ = (function (){var switch__14236__auto__ = ((function (c__14355__auto__,jobs,results,process,async){
return (function (state_14992){
var state_val_14993 = (state_14992[(1)]);
if((state_val_14993 === (7))){
var inst_14988 = (state_14992[(2)]);
var state_14992__$1 = state_14992;
var statearr_14994_15078 = state_14992__$1;
(statearr_14994_15078[(2)] = inst_14988);

(statearr_14994_15078[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (20))){
var state_14992__$1 = state_14992;
var statearr_14995_15080 = state_14992__$1;
(statearr_14995_15080[(2)] = null);

(statearr_14995_15080[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (1))){
var state_14992__$1 = state_14992;
var statearr_14996_15081 = state_14992__$1;
(statearr_14996_15081[(2)] = null);

(statearr_14996_15081[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (4))){
var inst_14957 = (state_14992[(7)]);
var inst_14957__$1 = (state_14992[(2)]);
var inst_14958 = (inst_14957__$1 == null);
var state_14992__$1 = (function (){var statearr_14997 = state_14992;
(statearr_14997[(7)] = inst_14957__$1);

return statearr_14997;
})();
if(cljs.core.truth_(inst_14958)){
var statearr_14998_15083 = state_14992__$1;
(statearr_14998_15083[(1)] = (5));

} else {
var statearr_14999_15084 = state_14992__$1;
(statearr_14999_15084[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (15))){
var inst_14970 = (state_14992[(8)]);
var state_14992__$1 = state_14992;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14992__$1,(18),to,inst_14970);
} else {
if((state_val_14993 === (21))){
var inst_14983 = (state_14992[(2)]);
var state_14992__$1 = state_14992;
var statearr_15000_15085 = state_14992__$1;
(statearr_15000_15085[(2)] = inst_14983);

(statearr_15000_15085[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (13))){
var inst_14985 = (state_14992[(2)]);
var state_14992__$1 = (function (){var statearr_15001 = state_14992;
(statearr_15001[(9)] = inst_14985);

return statearr_15001;
})();
var statearr_15002_15086 = state_14992__$1;
(statearr_15002_15086[(2)] = null);

(statearr_15002_15086[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (6))){
var inst_14957 = (state_14992[(7)]);
var state_14992__$1 = state_14992;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14992__$1,(11),inst_14957);
} else {
if((state_val_14993 === (17))){
var inst_14978 = (state_14992[(2)]);
var state_14992__$1 = state_14992;
if(cljs.core.truth_(inst_14978)){
var statearr_15003_15087 = state_14992__$1;
(statearr_15003_15087[(1)] = (19));

} else {
var statearr_15004_15088 = state_14992__$1;
(statearr_15004_15088[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (3))){
var inst_14990 = (state_14992[(2)]);
var state_14992__$1 = state_14992;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14992__$1,inst_14990);
} else {
if((state_val_14993 === (12))){
var inst_14967 = (state_14992[(10)]);
var state_14992__$1 = state_14992;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14992__$1,(14),inst_14967);
} else {
if((state_val_14993 === (2))){
var state_14992__$1 = state_14992;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14992__$1,(4),results);
} else {
if((state_val_14993 === (19))){
var state_14992__$1 = state_14992;
var statearr_15005_15092 = state_14992__$1;
(statearr_15005_15092[(2)] = null);

(statearr_15005_15092[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (11))){
var inst_14967 = (state_14992[(2)]);
var state_14992__$1 = (function (){var statearr_15006 = state_14992;
(statearr_15006[(10)] = inst_14967);

return statearr_15006;
})();
var statearr_15007_15093 = state_14992__$1;
(statearr_15007_15093[(2)] = null);

(statearr_15007_15093[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (9))){
var state_14992__$1 = state_14992;
var statearr_15008_15094 = state_14992__$1;
(statearr_15008_15094[(2)] = null);

(statearr_15008_15094[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (5))){
var state_14992__$1 = state_14992;
if(cljs.core.truth_(close_QMARK_)){
var statearr_15009_15095 = state_14992__$1;
(statearr_15009_15095[(1)] = (8));

} else {
var statearr_15010_15096 = state_14992__$1;
(statearr_15010_15096[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (14))){
var inst_14972 = (state_14992[(11)]);
var inst_14970 = (state_14992[(8)]);
var inst_14970__$1 = (state_14992[(2)]);
var inst_14971 = (inst_14970__$1 == null);
var inst_14972__$1 = cljs.core.not.call(null,inst_14971);
var state_14992__$1 = (function (){var statearr_15011 = state_14992;
(statearr_15011[(11)] = inst_14972__$1);

(statearr_15011[(8)] = inst_14970__$1);

return statearr_15011;
})();
if(inst_14972__$1){
var statearr_15012_15098 = state_14992__$1;
(statearr_15012_15098[(1)] = (15));

} else {
var statearr_15013_15099 = state_14992__$1;
(statearr_15013_15099[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (16))){
var inst_14972 = (state_14992[(11)]);
var state_14992__$1 = state_14992;
var statearr_15014_15100 = state_14992__$1;
(statearr_15014_15100[(2)] = inst_14972);

(statearr_15014_15100[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (10))){
var inst_14964 = (state_14992[(2)]);
var state_14992__$1 = state_14992;
var statearr_15015_15101 = state_14992__$1;
(statearr_15015_15101[(2)] = inst_14964);

(statearr_15015_15101[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (18))){
var inst_14975 = (state_14992[(2)]);
var state_14992__$1 = state_14992;
var statearr_15016_15102 = state_14992__$1;
(statearr_15016_15102[(2)] = inst_14975);

(statearr_15016_15102[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (8))){
var inst_14961 = cljs.core.async.close_BANG_.call(null,to);
var state_14992__$1 = state_14992;
var statearr_15017_15103 = state_14992__$1;
(statearr_15017_15103[(2)] = inst_14961);

(statearr_15017_15103[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14355__auto__,jobs,results,process,async))
;
return ((function (switch__14236__auto__,c__14355__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_15021 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15021[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__);

(statearr_15021[(1)] = (1));

return statearr_15021;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1 = (function (state_14992){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14992);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e15022){if((e15022 instanceof Object)){
var ex__14240__auto__ = e15022;
var statearr_15023_15104 = state_14992;
(statearr_15023_15104[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14992);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15022;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15105 = state_14992;
state_14992 = G__15105;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = function(state_14992){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1.call(this,state_14992);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14355__auto__,jobs,results,process,async))
})();
var state__14357__auto__ = (function (){var statearr_15024 = f__14356__auto__.call(null);
(statearr_15024[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14355__auto__);

return statearr_15024;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14357__auto__);
});})(c__14355__auto__,jobs,results,process,async))
);

return c__14355__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args15106 = [];
var len__7107__auto___15109 = arguments.length;
var i__7108__auto___15110 = (0);
while(true){
if((i__7108__auto___15110 < len__7107__auto___15109)){
args15106.push((arguments[i__7108__auto___15110]));

var G__15111 = (i__7108__auto___15110 + (1));
i__7108__auto___15110 = G__15111;
continue;
} else {
}
break;
}

var G__15108 = args15106.length;
switch (G__15108) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15106.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args15113 = [];
var len__7107__auto___15116 = arguments.length;
var i__7108__auto___15117 = (0);
while(true){
if((i__7108__auto___15117 < len__7107__auto___15116)){
args15113.push((arguments[i__7108__auto___15117]));

var G__15118 = (i__7108__auto___15117 + (1));
i__7108__auto___15117 = G__15118;
continue;
} else {
}
break;
}

var G__15115 = args15113.length;
switch (G__15115) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15113.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args15120 = [];
var len__7107__auto___15202 = arguments.length;
var i__7108__auto___15203 = (0);
while(true){
if((i__7108__auto___15203 < len__7107__auto___15202)){
args15120.push((arguments[i__7108__auto___15203]));

var G__15204 = (i__7108__auto___15203 + (1));
i__7108__auto___15203 = G__15204;
continue;
} else {
}
break;
}

var G__15130 = args15120.length;
switch (G__15130) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15120.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__14355__auto___15206 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14355__auto___15206,tc,fc){
return (function (){
var f__14356__auto__ = (function (){var switch__14236__auto__ = ((function (c__14355__auto___15206,tc,fc){
return (function (state_15165){
var state_val_15166 = (state_15165[(1)]);
if((state_val_15166 === (7))){
var inst_15157 = (state_15165[(2)]);
var state_15165__$1 = state_15165;
var statearr_15168_15209 = state_15165__$1;
(statearr_15168_15209[(2)] = inst_15157);

(statearr_15168_15209[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15166 === (1))){
var state_15165__$1 = state_15165;
var statearr_15170_15210 = state_15165__$1;
(statearr_15170_15210[(2)] = null);

(statearr_15170_15210[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15166 === (4))){
var inst_15133 = (state_15165[(7)]);
var inst_15133__$1 = (state_15165[(2)]);
var inst_15134 = (inst_15133__$1 == null);
var state_15165__$1 = (function (){var statearr_15176 = state_15165;
(statearr_15176[(7)] = inst_15133__$1);

return statearr_15176;
})();
if(cljs.core.truth_(inst_15134)){
var statearr_15177_15212 = state_15165__$1;
(statearr_15177_15212[(1)] = (5));

} else {
var statearr_15178_15213 = state_15165__$1;
(statearr_15178_15213[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15166 === (13))){
var state_15165__$1 = state_15165;
var statearr_15180_15215 = state_15165__$1;
(statearr_15180_15215[(2)] = null);

(statearr_15180_15215[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15166 === (6))){
var inst_15133 = (state_15165[(7)]);
var inst_15144 = p.call(null,inst_15133);
var state_15165__$1 = state_15165;
if(cljs.core.truth_(inst_15144)){
var statearr_15185_15216 = state_15165__$1;
(statearr_15185_15216[(1)] = (9));

} else {
var statearr_15186_15217 = state_15165__$1;
(statearr_15186_15217[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15166 === (3))){
var inst_15159 = (state_15165[(2)]);
var state_15165__$1 = state_15165;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15165__$1,inst_15159);
} else {
if((state_val_15166 === (12))){
var state_15165__$1 = state_15165;
var statearr_15187_15218 = state_15165__$1;
(statearr_15187_15218[(2)] = null);

(statearr_15187_15218[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15166 === (2))){
var state_15165__$1 = state_15165;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15165__$1,(4),ch);
} else {
if((state_val_15166 === (11))){
var inst_15133 = (state_15165[(7)]);
var inst_15148 = (state_15165[(2)]);
var state_15165__$1 = state_15165;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15165__$1,(8),inst_15148,inst_15133);
} else {
if((state_val_15166 === (9))){
var state_15165__$1 = state_15165;
var statearr_15188_15219 = state_15165__$1;
(statearr_15188_15219[(2)] = tc);

(statearr_15188_15219[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15166 === (5))){
var inst_15140 = cljs.core.async.close_BANG_.call(null,tc);
var inst_15141 = cljs.core.async.close_BANG_.call(null,fc);
var state_15165__$1 = (function (){var statearr_15189 = state_15165;
(statearr_15189[(8)] = inst_15140);

return statearr_15189;
})();
var statearr_15190_15220 = state_15165__$1;
(statearr_15190_15220[(2)] = inst_15141);

(statearr_15190_15220[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15166 === (14))){
var inst_15155 = (state_15165[(2)]);
var state_15165__$1 = state_15165;
var statearr_15191_15221 = state_15165__$1;
(statearr_15191_15221[(2)] = inst_15155);

(statearr_15191_15221[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15166 === (10))){
var state_15165__$1 = state_15165;
var statearr_15192_15222 = state_15165__$1;
(statearr_15192_15222[(2)] = fc);

(statearr_15192_15222[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15166 === (8))){
var inst_15150 = (state_15165[(2)]);
var state_15165__$1 = state_15165;
if(cljs.core.truth_(inst_15150)){
var statearr_15193_15226 = state_15165__$1;
(statearr_15193_15226[(1)] = (12));

} else {
var statearr_15194_15227 = state_15165__$1;
(statearr_15194_15227[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14355__auto___15206,tc,fc))
;
return ((function (switch__14236__auto__,c__14355__auto___15206,tc,fc){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_15198 = [null,null,null,null,null,null,null,null,null];
(statearr_15198[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_15198[(1)] = (1));

return statearr_15198;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_15165){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_15165);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e15199){if((e15199 instanceof Object)){
var ex__14240__auto__ = e15199;
var statearr_15200_15229 = state_15165;
(statearr_15200_15229[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15165);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15199;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15230 = state_15165;
state_15165 = G__15230;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_15165){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_15165);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14355__auto___15206,tc,fc))
})();
var state__14357__auto__ = (function (){var statearr_15201 = f__14356__auto__.call(null);
(statearr_15201[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14355__auto___15206);

return statearr_15201;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14357__auto__);
});})(c__14355__auto___15206,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__14355__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14355__auto__){
return (function (){
var f__14356__auto__ = (function (){var switch__14236__auto__ = ((function (c__14355__auto__){
return (function (state_15298){
var state_val_15299 = (state_15298[(1)]);
if((state_val_15299 === (7))){
var inst_15294 = (state_15298[(2)]);
var state_15298__$1 = state_15298;
var statearr_15300_15321 = state_15298__$1;
(statearr_15300_15321[(2)] = inst_15294);

(statearr_15300_15321[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15299 === (1))){
var inst_15278 = init;
var state_15298__$1 = (function (){var statearr_15301 = state_15298;
(statearr_15301[(7)] = inst_15278);

return statearr_15301;
})();
var statearr_15302_15322 = state_15298__$1;
(statearr_15302_15322[(2)] = null);

(statearr_15302_15322[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15299 === (4))){
var inst_15281 = (state_15298[(8)]);
var inst_15281__$1 = (state_15298[(2)]);
var inst_15282 = (inst_15281__$1 == null);
var state_15298__$1 = (function (){var statearr_15303 = state_15298;
(statearr_15303[(8)] = inst_15281__$1);

return statearr_15303;
})();
if(cljs.core.truth_(inst_15282)){
var statearr_15304_15323 = state_15298__$1;
(statearr_15304_15323[(1)] = (5));

} else {
var statearr_15305_15324 = state_15298__$1;
(statearr_15305_15324[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15299 === (6))){
var inst_15285 = (state_15298[(9)]);
var inst_15281 = (state_15298[(8)]);
var inst_15278 = (state_15298[(7)]);
var inst_15285__$1 = f.call(null,inst_15278,inst_15281);
var inst_15286 = cljs.core.reduced_QMARK_.call(null,inst_15285__$1);
var state_15298__$1 = (function (){var statearr_15306 = state_15298;
(statearr_15306[(9)] = inst_15285__$1);

return statearr_15306;
})();
if(inst_15286){
var statearr_15307_15325 = state_15298__$1;
(statearr_15307_15325[(1)] = (8));

} else {
var statearr_15308_15326 = state_15298__$1;
(statearr_15308_15326[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15299 === (3))){
var inst_15296 = (state_15298[(2)]);
var state_15298__$1 = state_15298;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15298__$1,inst_15296);
} else {
if((state_val_15299 === (2))){
var state_15298__$1 = state_15298;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15298__$1,(4),ch);
} else {
if((state_val_15299 === (9))){
var inst_15285 = (state_15298[(9)]);
var inst_15278 = inst_15285;
var state_15298__$1 = (function (){var statearr_15309 = state_15298;
(statearr_15309[(7)] = inst_15278);

return statearr_15309;
})();
var statearr_15310_15327 = state_15298__$1;
(statearr_15310_15327[(2)] = null);

(statearr_15310_15327[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15299 === (5))){
var inst_15278 = (state_15298[(7)]);
var state_15298__$1 = state_15298;
var statearr_15311_15328 = state_15298__$1;
(statearr_15311_15328[(2)] = inst_15278);

(statearr_15311_15328[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15299 === (10))){
var inst_15292 = (state_15298[(2)]);
var state_15298__$1 = state_15298;
var statearr_15312_15329 = state_15298__$1;
(statearr_15312_15329[(2)] = inst_15292);

(statearr_15312_15329[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15299 === (8))){
var inst_15285 = (state_15298[(9)]);
var inst_15288 = cljs.core.deref.call(null,inst_15285);
var state_15298__$1 = state_15298;
var statearr_15313_15330 = state_15298__$1;
(statearr_15313_15330[(2)] = inst_15288);

(statearr_15313_15330[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__14355__auto__))
;
return ((function (switch__14236__auto__,c__14355__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__14237__auto__ = null;
var cljs$core$async$reduce_$_state_machine__14237__auto____0 = (function (){
var statearr_15317 = [null,null,null,null,null,null,null,null,null,null];
(statearr_15317[(0)] = cljs$core$async$reduce_$_state_machine__14237__auto__);

(statearr_15317[(1)] = (1));

return statearr_15317;
});
var cljs$core$async$reduce_$_state_machine__14237__auto____1 = (function (state_15298){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_15298);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e15318){if((e15318 instanceof Object)){
var ex__14240__auto__ = e15318;
var statearr_15319_15331 = state_15298;
(statearr_15319_15331[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15298);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15318;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15332 = state_15298;
state_15298 = G__15332;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__14237__auto__ = function(state_15298){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__14237__auto____1.call(this,state_15298);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__14237__auto____0;
cljs$core$async$reduce_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__14237__auto____1;
return cljs$core$async$reduce_$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14355__auto__))
})();
var state__14357__auto__ = (function (){var statearr_15320 = f__14356__auto__.call(null);
(statearr_15320[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14355__auto__);

return statearr_15320;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14357__auto__);
});})(c__14355__auto__))
);

return c__14355__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args15333 = [];
var len__7107__auto___15392 = arguments.length;
var i__7108__auto___15393 = (0);
while(true){
if((i__7108__auto___15393 < len__7107__auto___15392)){
args15333.push((arguments[i__7108__auto___15393]));

var G__15394 = (i__7108__auto___15393 + (1));
i__7108__auto___15393 = G__15394;
continue;
} else {
}
break;
}

var G__15336 = args15333.length;
switch (G__15336) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15333.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__14355__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14355__auto__){
return (function (){
var f__14356__auto__ = (function (){var switch__14236__auto__ = ((function (c__14355__auto__){
return (function (state_15363){
var state_val_15364 = (state_15363[(1)]);
if((state_val_15364 === (7))){
var inst_15345 = (state_15363[(2)]);
var state_15363__$1 = state_15363;
var statearr_15365_15396 = state_15363__$1;
(statearr_15365_15396[(2)] = inst_15345);

(statearr_15365_15396[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15364 === (1))){
var inst_15338 = cljs.core.seq.call(null,coll);
var inst_15339 = inst_15338;
var state_15363__$1 = (function (){var statearr_15366 = state_15363;
(statearr_15366[(7)] = inst_15339);

return statearr_15366;
})();
var statearr_15367_15397 = state_15363__$1;
(statearr_15367_15397[(2)] = null);

(statearr_15367_15397[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15364 === (4))){
var inst_15339 = (state_15363[(7)]);
var inst_15343 = cljs.core.first.call(null,inst_15339);
var state_15363__$1 = state_15363;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15363__$1,(7),ch,inst_15343);
} else {
if((state_val_15364 === (13))){
var inst_15357 = (state_15363[(2)]);
var state_15363__$1 = state_15363;
var statearr_15369_15398 = state_15363__$1;
(statearr_15369_15398[(2)] = inst_15357);

(statearr_15369_15398[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15364 === (6))){
var inst_15348 = (state_15363[(2)]);
var state_15363__$1 = state_15363;
if(cljs.core.truth_(inst_15348)){
var statearr_15371_15399 = state_15363__$1;
(statearr_15371_15399[(1)] = (8));

} else {
var statearr_15372_15400 = state_15363__$1;
(statearr_15372_15400[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15364 === (3))){
var inst_15361 = (state_15363[(2)]);
var state_15363__$1 = state_15363;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15363__$1,inst_15361);
} else {
if((state_val_15364 === (12))){
var state_15363__$1 = state_15363;
var statearr_15374_15401 = state_15363__$1;
(statearr_15374_15401[(2)] = null);

(statearr_15374_15401[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15364 === (2))){
var inst_15339 = (state_15363[(7)]);
var state_15363__$1 = state_15363;
if(cljs.core.truth_(inst_15339)){
var statearr_15376_15402 = state_15363__$1;
(statearr_15376_15402[(1)] = (4));

} else {
var statearr_15377_15403 = state_15363__$1;
(statearr_15377_15403[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15364 === (11))){
var inst_15354 = cljs.core.async.close_BANG_.call(null,ch);
var state_15363__$1 = state_15363;
var statearr_15378_15408 = state_15363__$1;
(statearr_15378_15408[(2)] = inst_15354);

(statearr_15378_15408[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15364 === (9))){
var state_15363__$1 = state_15363;
if(cljs.core.truth_(close_QMARK_)){
var statearr_15379_15410 = state_15363__$1;
(statearr_15379_15410[(1)] = (11));

} else {
var statearr_15380_15411 = state_15363__$1;
(statearr_15380_15411[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15364 === (5))){
var inst_15339 = (state_15363[(7)]);
var state_15363__$1 = state_15363;
var statearr_15381_15413 = state_15363__$1;
(statearr_15381_15413[(2)] = inst_15339);

(statearr_15381_15413[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15364 === (10))){
var inst_15359 = (state_15363[(2)]);
var state_15363__$1 = state_15363;
var statearr_15382_15414 = state_15363__$1;
(statearr_15382_15414[(2)] = inst_15359);

(statearr_15382_15414[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15364 === (8))){
var inst_15339 = (state_15363[(7)]);
var inst_15350 = cljs.core.next.call(null,inst_15339);
var inst_15339__$1 = inst_15350;
var state_15363__$1 = (function (){var statearr_15383 = state_15363;
(statearr_15383[(7)] = inst_15339__$1);

return statearr_15383;
})();
var statearr_15384_15415 = state_15363__$1;
(statearr_15384_15415[(2)] = null);

(statearr_15384_15415[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14355__auto__))
;
return ((function (switch__14236__auto__,c__14355__auto__){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_15388 = [null,null,null,null,null,null,null,null];
(statearr_15388[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_15388[(1)] = (1));

return statearr_15388;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_15363){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_15363);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e15389){if((e15389 instanceof Object)){
var ex__14240__auto__ = e15389;
var statearr_15390_15419 = state_15363;
(statearr_15390_15419[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15363);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15389;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15420 = state_15363;
state_15363 = G__15420;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_15363){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_15363);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14355__auto__))
})();
var state__14357__auto__ = (function (){var statearr_15391 = f__14356__auto__.call(null);
(statearr_15391[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14355__auto__);

return statearr_15391;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14357__auto__);
});})(c__14355__auto__))
);

return c__14355__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__6704__auto__ = (((_ == null))?null:_);
var m__6705__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,_);
} else {
var m__6705__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__6705__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,ch);
} else {
var m__6705__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m);
} else {
var m__6705__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async15652 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15652 = (function (mult,ch,cs,meta15653){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta15653 = meta15653;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async15652.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_15654,meta15653__$1){
var self__ = this;
var _15654__$1 = this;
return (new cljs.core.async.t_cljs$core$async15652(self__.mult,self__.ch,self__.cs,meta15653__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async15652.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_15654){
var self__ = this;
var _15654__$1 = this;
return self__.meta15653;
});})(cs))
;

cljs.core.async.t_cljs$core$async15652.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async15652.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async15652.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async15652.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async15652.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async15652.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async15652.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta15653","meta15653",2039469362,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async15652.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async15652.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15652";

cljs.core.async.t_cljs$core$async15652.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async15652");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async15652 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async15652(mult__$1,ch__$1,cs__$1,meta15653){
return (new cljs.core.async.t_cljs$core$async15652(mult__$1,ch__$1,cs__$1,meta15653));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async15652(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__14355__auto___15891 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14355__auto___15891,cs,m,dchan,dctr,done){
return (function (){
var f__14356__auto__ = (function (){var switch__14236__auto__ = ((function (c__14355__auto___15891,cs,m,dchan,dctr,done){
return (function (state_15792){
var state_val_15793 = (state_15792[(1)]);
if((state_val_15793 === (7))){
var inst_15788 = (state_15792[(2)]);
var state_15792__$1 = state_15792;
var statearr_15794_15892 = state_15792__$1;
(statearr_15794_15892[(2)] = inst_15788);

(statearr_15794_15892[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (20))){
var inst_15690 = (state_15792[(7)]);
var inst_15700 = cljs.core.first.call(null,inst_15690);
var inst_15701 = cljs.core.nth.call(null,inst_15700,(0),null);
var inst_15702 = cljs.core.nth.call(null,inst_15700,(1),null);
var state_15792__$1 = (function (){var statearr_15795 = state_15792;
(statearr_15795[(8)] = inst_15701);

return statearr_15795;
})();
if(cljs.core.truth_(inst_15702)){
var statearr_15796_15893 = state_15792__$1;
(statearr_15796_15893[(1)] = (22));

} else {
var statearr_15797_15894 = state_15792__$1;
(statearr_15797_15894[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (27))){
var inst_15733 = (state_15792[(9)]);
var inst_15661 = (state_15792[(10)]);
var inst_15735 = (state_15792[(11)]);
var inst_15740 = (state_15792[(12)]);
var inst_15740__$1 = cljs.core._nth.call(null,inst_15733,inst_15735);
var inst_15741 = cljs.core.async.put_BANG_.call(null,inst_15740__$1,inst_15661,done);
var state_15792__$1 = (function (){var statearr_15799 = state_15792;
(statearr_15799[(12)] = inst_15740__$1);

return statearr_15799;
})();
if(cljs.core.truth_(inst_15741)){
var statearr_15800_15895 = state_15792__$1;
(statearr_15800_15895[(1)] = (30));

} else {
var statearr_15801_15896 = state_15792__$1;
(statearr_15801_15896[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (1))){
var state_15792__$1 = state_15792;
var statearr_15802_15897 = state_15792__$1;
(statearr_15802_15897[(2)] = null);

(statearr_15802_15897[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (24))){
var inst_15690 = (state_15792[(7)]);
var inst_15707 = (state_15792[(2)]);
var inst_15708 = cljs.core.next.call(null,inst_15690);
var inst_15670 = inst_15708;
var inst_15671 = null;
var inst_15672 = (0);
var inst_15673 = (0);
var state_15792__$1 = (function (){var statearr_15803 = state_15792;
(statearr_15803[(13)] = inst_15671);

(statearr_15803[(14)] = inst_15707);

(statearr_15803[(15)] = inst_15673);

(statearr_15803[(16)] = inst_15670);

(statearr_15803[(17)] = inst_15672);

return statearr_15803;
})();
var statearr_15804_15898 = state_15792__$1;
(statearr_15804_15898[(2)] = null);

(statearr_15804_15898[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (39))){
var state_15792__$1 = state_15792;
var statearr_15808_15899 = state_15792__$1;
(statearr_15808_15899[(2)] = null);

(statearr_15808_15899[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (4))){
var inst_15661 = (state_15792[(10)]);
var inst_15661__$1 = (state_15792[(2)]);
var inst_15662 = (inst_15661__$1 == null);
var state_15792__$1 = (function (){var statearr_15809 = state_15792;
(statearr_15809[(10)] = inst_15661__$1);

return statearr_15809;
})();
if(cljs.core.truth_(inst_15662)){
var statearr_15810_15900 = state_15792__$1;
(statearr_15810_15900[(1)] = (5));

} else {
var statearr_15811_15901 = state_15792__$1;
(statearr_15811_15901[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (15))){
var inst_15671 = (state_15792[(13)]);
var inst_15673 = (state_15792[(15)]);
var inst_15670 = (state_15792[(16)]);
var inst_15672 = (state_15792[(17)]);
var inst_15686 = (state_15792[(2)]);
var inst_15687 = (inst_15673 + (1));
var tmp15805 = inst_15671;
var tmp15806 = inst_15670;
var tmp15807 = inst_15672;
var inst_15670__$1 = tmp15806;
var inst_15671__$1 = tmp15805;
var inst_15672__$1 = tmp15807;
var inst_15673__$1 = inst_15687;
var state_15792__$1 = (function (){var statearr_15812 = state_15792;
(statearr_15812[(13)] = inst_15671__$1);

(statearr_15812[(15)] = inst_15673__$1);

(statearr_15812[(16)] = inst_15670__$1);

(statearr_15812[(18)] = inst_15686);

(statearr_15812[(17)] = inst_15672__$1);

return statearr_15812;
})();
var statearr_15813_15902 = state_15792__$1;
(statearr_15813_15902[(2)] = null);

(statearr_15813_15902[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (21))){
var inst_15711 = (state_15792[(2)]);
var state_15792__$1 = state_15792;
var statearr_15817_15907 = state_15792__$1;
(statearr_15817_15907[(2)] = inst_15711);

(statearr_15817_15907[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (31))){
var inst_15740 = (state_15792[(12)]);
var inst_15744 = done.call(null,null);
var inst_15745 = cljs.core.async.untap_STAR_.call(null,m,inst_15740);
var state_15792__$1 = (function (){var statearr_15818 = state_15792;
(statearr_15818[(19)] = inst_15744);

return statearr_15818;
})();
var statearr_15819_15909 = state_15792__$1;
(statearr_15819_15909[(2)] = inst_15745);

(statearr_15819_15909[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (32))){
var inst_15734 = (state_15792[(20)]);
var inst_15733 = (state_15792[(9)]);
var inst_15732 = (state_15792[(21)]);
var inst_15735 = (state_15792[(11)]);
var inst_15747 = (state_15792[(2)]);
var inst_15748 = (inst_15735 + (1));
var tmp15814 = inst_15734;
var tmp15815 = inst_15733;
var tmp15816 = inst_15732;
var inst_15732__$1 = tmp15816;
var inst_15733__$1 = tmp15815;
var inst_15734__$1 = tmp15814;
var inst_15735__$1 = inst_15748;
var state_15792__$1 = (function (){var statearr_15820 = state_15792;
(statearr_15820[(20)] = inst_15734__$1);

(statearr_15820[(9)] = inst_15733__$1);

(statearr_15820[(21)] = inst_15732__$1);

(statearr_15820[(11)] = inst_15735__$1);

(statearr_15820[(22)] = inst_15747);

return statearr_15820;
})();
var statearr_15821_15911 = state_15792__$1;
(statearr_15821_15911[(2)] = null);

(statearr_15821_15911[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (40))){
var inst_15760 = (state_15792[(23)]);
var inst_15764 = done.call(null,null);
var inst_15765 = cljs.core.async.untap_STAR_.call(null,m,inst_15760);
var state_15792__$1 = (function (){var statearr_15822 = state_15792;
(statearr_15822[(24)] = inst_15764);

return statearr_15822;
})();
var statearr_15823_15915 = state_15792__$1;
(statearr_15823_15915[(2)] = inst_15765);

(statearr_15823_15915[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (33))){
var inst_15751 = (state_15792[(25)]);
var inst_15753 = cljs.core.chunked_seq_QMARK_.call(null,inst_15751);
var state_15792__$1 = state_15792;
if(inst_15753){
var statearr_15824_15916 = state_15792__$1;
(statearr_15824_15916[(1)] = (36));

} else {
var statearr_15825_15917 = state_15792__$1;
(statearr_15825_15917[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (13))){
var inst_15680 = (state_15792[(26)]);
var inst_15683 = cljs.core.async.close_BANG_.call(null,inst_15680);
var state_15792__$1 = state_15792;
var statearr_15826_15918 = state_15792__$1;
(statearr_15826_15918[(2)] = inst_15683);

(statearr_15826_15918[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (22))){
var inst_15701 = (state_15792[(8)]);
var inst_15704 = cljs.core.async.close_BANG_.call(null,inst_15701);
var state_15792__$1 = state_15792;
var statearr_15827_15919 = state_15792__$1;
(statearr_15827_15919[(2)] = inst_15704);

(statearr_15827_15919[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (36))){
var inst_15751 = (state_15792[(25)]);
var inst_15755 = cljs.core.chunk_first.call(null,inst_15751);
var inst_15756 = cljs.core.chunk_rest.call(null,inst_15751);
var inst_15757 = cljs.core.count.call(null,inst_15755);
var inst_15732 = inst_15756;
var inst_15733 = inst_15755;
var inst_15734 = inst_15757;
var inst_15735 = (0);
var state_15792__$1 = (function (){var statearr_15828 = state_15792;
(statearr_15828[(20)] = inst_15734);

(statearr_15828[(9)] = inst_15733);

(statearr_15828[(21)] = inst_15732);

(statearr_15828[(11)] = inst_15735);

return statearr_15828;
})();
var statearr_15829_15921 = state_15792__$1;
(statearr_15829_15921[(2)] = null);

(statearr_15829_15921[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (41))){
var inst_15751 = (state_15792[(25)]);
var inst_15767 = (state_15792[(2)]);
var inst_15768 = cljs.core.next.call(null,inst_15751);
var inst_15732 = inst_15768;
var inst_15733 = null;
var inst_15734 = (0);
var inst_15735 = (0);
var state_15792__$1 = (function (){var statearr_15830 = state_15792;
(statearr_15830[(20)] = inst_15734);

(statearr_15830[(9)] = inst_15733);

(statearr_15830[(21)] = inst_15732);

(statearr_15830[(11)] = inst_15735);

(statearr_15830[(27)] = inst_15767);

return statearr_15830;
})();
var statearr_15831_15922 = state_15792__$1;
(statearr_15831_15922[(2)] = null);

(statearr_15831_15922[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (43))){
var state_15792__$1 = state_15792;
var statearr_15832_15923 = state_15792__$1;
(statearr_15832_15923[(2)] = null);

(statearr_15832_15923[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (29))){
var inst_15776 = (state_15792[(2)]);
var state_15792__$1 = state_15792;
var statearr_15833_15924 = state_15792__$1;
(statearr_15833_15924[(2)] = inst_15776);

(statearr_15833_15924[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (44))){
var inst_15785 = (state_15792[(2)]);
var state_15792__$1 = (function (){var statearr_15834 = state_15792;
(statearr_15834[(28)] = inst_15785);

return statearr_15834;
})();
var statearr_15835_15925 = state_15792__$1;
(statearr_15835_15925[(2)] = null);

(statearr_15835_15925[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (6))){
var inst_15721 = (state_15792[(29)]);
var inst_15720 = cljs.core.deref.call(null,cs);
var inst_15721__$1 = cljs.core.keys.call(null,inst_15720);
var inst_15722 = cljs.core.count.call(null,inst_15721__$1);
var inst_15723 = cljs.core.reset_BANG_.call(null,dctr,inst_15722);
var inst_15728 = cljs.core.seq.call(null,inst_15721__$1);
var inst_15732 = inst_15728;
var inst_15733 = null;
var inst_15734 = (0);
var inst_15735 = (0);
var state_15792__$1 = (function (){var statearr_15836 = state_15792;
(statearr_15836[(29)] = inst_15721__$1);

(statearr_15836[(30)] = inst_15723);

(statearr_15836[(20)] = inst_15734);

(statearr_15836[(9)] = inst_15733);

(statearr_15836[(21)] = inst_15732);

(statearr_15836[(11)] = inst_15735);

return statearr_15836;
})();
var statearr_15837_15926 = state_15792__$1;
(statearr_15837_15926[(2)] = null);

(statearr_15837_15926[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (28))){
var inst_15732 = (state_15792[(21)]);
var inst_15751 = (state_15792[(25)]);
var inst_15751__$1 = cljs.core.seq.call(null,inst_15732);
var state_15792__$1 = (function (){var statearr_15838 = state_15792;
(statearr_15838[(25)] = inst_15751__$1);

return statearr_15838;
})();
if(inst_15751__$1){
var statearr_15839_15927 = state_15792__$1;
(statearr_15839_15927[(1)] = (33));

} else {
var statearr_15840_15928 = state_15792__$1;
(statearr_15840_15928[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (25))){
var inst_15734 = (state_15792[(20)]);
var inst_15735 = (state_15792[(11)]);
var inst_15737 = (inst_15735 < inst_15734);
var inst_15738 = inst_15737;
var state_15792__$1 = state_15792;
if(cljs.core.truth_(inst_15738)){
var statearr_15841_15929 = state_15792__$1;
(statearr_15841_15929[(1)] = (27));

} else {
var statearr_15842_15930 = state_15792__$1;
(statearr_15842_15930[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (34))){
var state_15792__$1 = state_15792;
var statearr_15843_15931 = state_15792__$1;
(statearr_15843_15931[(2)] = null);

(statearr_15843_15931[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (17))){
var state_15792__$1 = state_15792;
var statearr_15844_15932 = state_15792__$1;
(statearr_15844_15932[(2)] = null);

(statearr_15844_15932[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (3))){
var inst_15790 = (state_15792[(2)]);
var state_15792__$1 = state_15792;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15792__$1,inst_15790);
} else {
if((state_val_15793 === (12))){
var inst_15716 = (state_15792[(2)]);
var state_15792__$1 = state_15792;
var statearr_15845_15933 = state_15792__$1;
(statearr_15845_15933[(2)] = inst_15716);

(statearr_15845_15933[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (2))){
var state_15792__$1 = state_15792;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15792__$1,(4),ch);
} else {
if((state_val_15793 === (23))){
var state_15792__$1 = state_15792;
var statearr_15846_15934 = state_15792__$1;
(statearr_15846_15934[(2)] = null);

(statearr_15846_15934[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (35))){
var inst_15774 = (state_15792[(2)]);
var state_15792__$1 = state_15792;
var statearr_15847_15936 = state_15792__$1;
(statearr_15847_15936[(2)] = inst_15774);

(statearr_15847_15936[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (19))){
var inst_15690 = (state_15792[(7)]);
var inst_15694 = cljs.core.chunk_first.call(null,inst_15690);
var inst_15695 = cljs.core.chunk_rest.call(null,inst_15690);
var inst_15696 = cljs.core.count.call(null,inst_15694);
var inst_15670 = inst_15695;
var inst_15671 = inst_15694;
var inst_15672 = inst_15696;
var inst_15673 = (0);
var state_15792__$1 = (function (){var statearr_15848 = state_15792;
(statearr_15848[(13)] = inst_15671);

(statearr_15848[(15)] = inst_15673);

(statearr_15848[(16)] = inst_15670);

(statearr_15848[(17)] = inst_15672);

return statearr_15848;
})();
var statearr_15849_15943 = state_15792__$1;
(statearr_15849_15943[(2)] = null);

(statearr_15849_15943[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (11))){
var inst_15670 = (state_15792[(16)]);
var inst_15690 = (state_15792[(7)]);
var inst_15690__$1 = cljs.core.seq.call(null,inst_15670);
var state_15792__$1 = (function (){var statearr_15850 = state_15792;
(statearr_15850[(7)] = inst_15690__$1);

return statearr_15850;
})();
if(inst_15690__$1){
var statearr_15851_15948 = state_15792__$1;
(statearr_15851_15948[(1)] = (16));

} else {
var statearr_15852_15949 = state_15792__$1;
(statearr_15852_15949[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (9))){
var inst_15718 = (state_15792[(2)]);
var state_15792__$1 = state_15792;
var statearr_15853_15951 = state_15792__$1;
(statearr_15853_15951[(2)] = inst_15718);

(statearr_15853_15951[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (5))){
var inst_15668 = cljs.core.deref.call(null,cs);
var inst_15669 = cljs.core.seq.call(null,inst_15668);
var inst_15670 = inst_15669;
var inst_15671 = null;
var inst_15672 = (0);
var inst_15673 = (0);
var state_15792__$1 = (function (){var statearr_15854 = state_15792;
(statearr_15854[(13)] = inst_15671);

(statearr_15854[(15)] = inst_15673);

(statearr_15854[(16)] = inst_15670);

(statearr_15854[(17)] = inst_15672);

return statearr_15854;
})();
var statearr_15855_15953 = state_15792__$1;
(statearr_15855_15953[(2)] = null);

(statearr_15855_15953[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (14))){
var state_15792__$1 = state_15792;
var statearr_15856_15954 = state_15792__$1;
(statearr_15856_15954[(2)] = null);

(statearr_15856_15954[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (45))){
var inst_15782 = (state_15792[(2)]);
var state_15792__$1 = state_15792;
var statearr_15857_15958 = state_15792__$1;
(statearr_15857_15958[(2)] = inst_15782);

(statearr_15857_15958[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (26))){
var inst_15721 = (state_15792[(29)]);
var inst_15778 = (state_15792[(2)]);
var inst_15779 = cljs.core.seq.call(null,inst_15721);
var state_15792__$1 = (function (){var statearr_15858 = state_15792;
(statearr_15858[(31)] = inst_15778);

return statearr_15858;
})();
if(inst_15779){
var statearr_15859_15959 = state_15792__$1;
(statearr_15859_15959[(1)] = (42));

} else {
var statearr_15860_15960 = state_15792__$1;
(statearr_15860_15960[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (16))){
var inst_15690 = (state_15792[(7)]);
var inst_15692 = cljs.core.chunked_seq_QMARK_.call(null,inst_15690);
var state_15792__$1 = state_15792;
if(inst_15692){
var statearr_15861_15961 = state_15792__$1;
(statearr_15861_15961[(1)] = (19));

} else {
var statearr_15862_15962 = state_15792__$1;
(statearr_15862_15962[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (38))){
var inst_15771 = (state_15792[(2)]);
var state_15792__$1 = state_15792;
var statearr_15863_15964 = state_15792__$1;
(statearr_15863_15964[(2)] = inst_15771);

(statearr_15863_15964[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (30))){
var state_15792__$1 = state_15792;
var statearr_15864_15965 = state_15792__$1;
(statearr_15864_15965[(2)] = null);

(statearr_15864_15965[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (10))){
var inst_15671 = (state_15792[(13)]);
var inst_15673 = (state_15792[(15)]);
var inst_15679 = cljs.core._nth.call(null,inst_15671,inst_15673);
var inst_15680 = cljs.core.nth.call(null,inst_15679,(0),null);
var inst_15681 = cljs.core.nth.call(null,inst_15679,(1),null);
var state_15792__$1 = (function (){var statearr_15865 = state_15792;
(statearr_15865[(26)] = inst_15680);

return statearr_15865;
})();
if(cljs.core.truth_(inst_15681)){
var statearr_15866_15966 = state_15792__$1;
(statearr_15866_15966[(1)] = (13));

} else {
var statearr_15867_15967 = state_15792__$1;
(statearr_15867_15967[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (18))){
var inst_15714 = (state_15792[(2)]);
var state_15792__$1 = state_15792;
var statearr_15868_15968 = state_15792__$1;
(statearr_15868_15968[(2)] = inst_15714);

(statearr_15868_15968[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (42))){
var state_15792__$1 = state_15792;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15792__$1,(45),dchan);
} else {
if((state_val_15793 === (37))){
var inst_15661 = (state_15792[(10)]);
var inst_15751 = (state_15792[(25)]);
var inst_15760 = (state_15792[(23)]);
var inst_15760__$1 = cljs.core.first.call(null,inst_15751);
var inst_15761 = cljs.core.async.put_BANG_.call(null,inst_15760__$1,inst_15661,done);
var state_15792__$1 = (function (){var statearr_15873 = state_15792;
(statearr_15873[(23)] = inst_15760__$1);

return statearr_15873;
})();
if(cljs.core.truth_(inst_15761)){
var statearr_15874_15969 = state_15792__$1;
(statearr_15874_15969[(1)] = (39));

} else {
var statearr_15875_15970 = state_15792__$1;
(statearr_15875_15970[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (8))){
var inst_15673 = (state_15792[(15)]);
var inst_15672 = (state_15792[(17)]);
var inst_15675 = (inst_15673 < inst_15672);
var inst_15676 = inst_15675;
var state_15792__$1 = state_15792;
if(cljs.core.truth_(inst_15676)){
var statearr_15877_15971 = state_15792__$1;
(statearr_15877_15971[(1)] = (10));

} else {
var statearr_15878_15972 = state_15792__$1;
(statearr_15878_15972[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14355__auto___15891,cs,m,dchan,dctr,done))
;
return ((function (switch__14236__auto__,c__14355__auto___15891,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__14237__auto__ = null;
var cljs$core$async$mult_$_state_machine__14237__auto____0 = (function (){
var statearr_15883 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15883[(0)] = cljs$core$async$mult_$_state_machine__14237__auto__);

(statearr_15883[(1)] = (1));

return statearr_15883;
});
var cljs$core$async$mult_$_state_machine__14237__auto____1 = (function (state_15792){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_15792);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e15884){if((e15884 instanceof Object)){
var ex__14240__auto__ = e15884;
var statearr_15885_15973 = state_15792;
(statearr_15885_15973[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15792);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15884;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15974 = state_15792;
state_15792 = G__15974;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__14237__auto__ = function(state_15792){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__14237__auto____1.call(this,state_15792);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__14237__auto____0;
cljs$core$async$mult_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__14237__auto____1;
return cljs$core$async$mult_$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14355__auto___15891,cs,m,dchan,dctr,done))
})();
var state__14357__auto__ = (function (){var statearr_15886 = f__14356__auto__.call(null);
(statearr_15886[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14355__auto___15891);

return statearr_15886;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14357__auto__);
});})(c__14355__auto___15891,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args15975 = [];
var len__7107__auto___15978 = arguments.length;
var i__7108__auto___15979 = (0);
while(true){
if((i__7108__auto___15979 < len__7107__auto___15978)){
args15975.push((arguments[i__7108__auto___15979]));

var G__15980 = (i__7108__auto___15979 + (1));
i__7108__auto___15979 = G__15980;
continue;
} else {
}
break;
}

var G__15977 = args15975.length;
switch (G__15977) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15975.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,ch);
} else {
var m__6705__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,ch);
} else {
var m__6705__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m);
} else {
var m__6705__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,state_map);
} else {
var m__6705__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,mode);
} else {
var m__6705__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__7114__auto__ = [];
var len__7107__auto___16005 = arguments.length;
var i__7108__auto___16006 = (0);
while(true){
if((i__7108__auto___16006 < len__7107__auto___16005)){
args__7114__auto__.push((arguments[i__7108__auto___16006]));

var G__16007 = (i__7108__auto___16006 + (1));
i__7108__auto___16006 = G__16007;
continue;
} else {
}
break;
}

var argseq__7115__auto__ = ((((3) < args__7114__auto__.length))?(new cljs.core.IndexedSeq(args__7114__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7115__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__15999){
var map__16000 = p__15999;
var map__16000__$1 = ((((!((map__16000 == null)))?((((map__16000.cljs$lang$protocol_mask$partition0$ & (64))) || (map__16000.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16000):map__16000);
var opts = map__16000__$1;
var statearr_16002_16008 = state;
(statearr_16002_16008[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__16000,map__16000__$1,opts){
return (function (val){
var statearr_16003_16009 = state;
(statearr_16003_16009[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__16000,map__16000__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_16004_16010 = state;
(statearr_16004_16010[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq15995){
var G__15996 = cljs.core.first.call(null,seq15995);
var seq15995__$1 = cljs.core.next.call(null,seq15995);
var G__15997 = cljs.core.first.call(null,seq15995__$1);
var seq15995__$2 = cljs.core.next.call(null,seq15995__$1);
var G__15998 = cljs.core.first.call(null,seq15995__$2);
var seq15995__$3 = cljs.core.next.call(null,seq15995__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__15996,G__15997,G__15998,seq15995__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async16193 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16193 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta16194){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta16194 = meta16194;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16193.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_16195,meta16194__$1){
var self__ = this;
var _16195__$1 = this;
return (new cljs.core.async.t_cljs$core$async16193(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta16194__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16193.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_16195){
var self__ = this;
var _16195__$1 = this;
return self__.meta16194;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16193.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async16193.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16193.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async16193.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16193.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16193.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16193.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16193.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16193.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta16194","meta16194",280876592,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16193.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16193.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16193";

cljs.core.async.t_cljs$core$async16193.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16193");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async16193 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async16193(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta16194){
return (new cljs.core.async.t_cljs$core$async16193(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta16194));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async16193(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__14355__auto___16378 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14355__auto___16378,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__14356__auto__ = (function (){var switch__14236__auto__ = ((function (c__14355__auto___16378,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_16298){
var state_val_16302 = (state_16298[(1)]);
if((state_val_16302 === (7))){
var inst_16216 = (state_16298[(2)]);
var state_16298__$1 = state_16298;
var statearr_16303_16379 = state_16298__$1;
(statearr_16303_16379[(2)] = inst_16216);

(statearr_16303_16379[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16302 === (20))){
var inst_16228 = (state_16298[(7)]);
var state_16298__$1 = state_16298;
var statearr_16304_16380 = state_16298__$1;
(statearr_16304_16380[(2)] = inst_16228);

(statearr_16304_16380[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16302 === (27))){
var state_16298__$1 = state_16298;
var statearr_16306_16381 = state_16298__$1;
(statearr_16306_16381[(2)] = null);

(statearr_16306_16381[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16302 === (1))){
var inst_16204 = (state_16298[(8)]);
var inst_16204__$1 = calc_state.call(null);
var inst_16206 = (inst_16204__$1 == null);
var inst_16207 = cljs.core.not.call(null,inst_16206);
var state_16298__$1 = (function (){var statearr_16307 = state_16298;
(statearr_16307[(8)] = inst_16204__$1);

return statearr_16307;
})();
if(inst_16207){
var statearr_16308_16382 = state_16298__$1;
(statearr_16308_16382[(1)] = (2));

} else {
var statearr_16309_16383 = state_16298__$1;
(statearr_16309_16383[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16302 === (24))){
var inst_16272 = (state_16298[(9)]);
var inst_16258 = (state_16298[(10)]);
var inst_16251 = (state_16298[(11)]);
var inst_16272__$1 = inst_16251.call(null,inst_16258);
var state_16298__$1 = (function (){var statearr_16310 = state_16298;
(statearr_16310[(9)] = inst_16272__$1);

return statearr_16310;
})();
if(cljs.core.truth_(inst_16272__$1)){
var statearr_16311_16384 = state_16298__$1;
(statearr_16311_16384[(1)] = (29));

} else {
var statearr_16312_16385 = state_16298__$1;
(statearr_16312_16385[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16302 === (4))){
var inst_16219 = (state_16298[(2)]);
var state_16298__$1 = state_16298;
if(cljs.core.truth_(inst_16219)){
var statearr_16313_16386 = state_16298__$1;
(statearr_16313_16386[(1)] = (8));

} else {
var statearr_16314_16387 = state_16298__$1;
(statearr_16314_16387[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16302 === (15))){
var inst_16245 = (state_16298[(2)]);
var state_16298__$1 = state_16298;
if(cljs.core.truth_(inst_16245)){
var statearr_16315_16388 = state_16298__$1;
(statearr_16315_16388[(1)] = (19));

} else {
var statearr_16316_16389 = state_16298__$1;
(statearr_16316_16389[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16302 === (21))){
var inst_16250 = (state_16298[(12)]);
var inst_16250__$1 = (state_16298[(2)]);
var inst_16251 = cljs.core.get.call(null,inst_16250__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_16252 = cljs.core.get.call(null,inst_16250__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_16253 = cljs.core.get.call(null,inst_16250__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_16298__$1 = (function (){var statearr_16317 = state_16298;
(statearr_16317[(13)] = inst_16252);

(statearr_16317[(11)] = inst_16251);

(statearr_16317[(12)] = inst_16250__$1);

return statearr_16317;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_16298__$1,(22),inst_16253);
} else {
if((state_val_16302 === (31))){
var inst_16280 = (state_16298[(2)]);
var state_16298__$1 = state_16298;
if(cljs.core.truth_(inst_16280)){
var statearr_16321_16390 = state_16298__$1;
(statearr_16321_16390[(1)] = (32));

} else {
var statearr_16322_16391 = state_16298__$1;
(statearr_16322_16391[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16302 === (32))){
var inst_16257 = (state_16298[(14)]);
var state_16298__$1 = state_16298;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16298__$1,(35),out,inst_16257);
} else {
if((state_val_16302 === (33))){
var inst_16250 = (state_16298[(12)]);
var inst_16228 = inst_16250;
var state_16298__$1 = (function (){var statearr_16323 = state_16298;
(statearr_16323[(7)] = inst_16228);

return statearr_16323;
})();
var statearr_16324_16395 = state_16298__$1;
(statearr_16324_16395[(2)] = null);

(statearr_16324_16395[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16302 === (13))){
var inst_16228 = (state_16298[(7)]);
var inst_16235 = inst_16228.cljs$lang$protocol_mask$partition0$;
var inst_16236 = (inst_16235 & (64));
var inst_16237 = inst_16228.cljs$core$ISeq$;
var inst_16238 = (inst_16236) || (inst_16237);
var state_16298__$1 = state_16298;
if(cljs.core.truth_(inst_16238)){
var statearr_16325_16397 = state_16298__$1;
(statearr_16325_16397[(1)] = (16));

} else {
var statearr_16326_16399 = state_16298__$1;
(statearr_16326_16399[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16302 === (22))){
var inst_16257 = (state_16298[(14)]);
var inst_16258 = (state_16298[(10)]);
var inst_16256 = (state_16298[(2)]);
var inst_16257__$1 = cljs.core.nth.call(null,inst_16256,(0),null);
var inst_16258__$1 = cljs.core.nth.call(null,inst_16256,(1),null);
var inst_16259 = (inst_16257__$1 == null);
var inst_16260 = cljs.core._EQ_.call(null,inst_16258__$1,change);
var inst_16261 = (inst_16259) || (inst_16260);
var state_16298__$1 = (function (){var statearr_16327 = state_16298;
(statearr_16327[(14)] = inst_16257__$1);

(statearr_16327[(10)] = inst_16258__$1);

return statearr_16327;
})();
if(cljs.core.truth_(inst_16261)){
var statearr_16328_16400 = state_16298__$1;
(statearr_16328_16400[(1)] = (23));

} else {
var statearr_16329_16401 = state_16298__$1;
(statearr_16329_16401[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16302 === (36))){
var inst_16250 = (state_16298[(12)]);
var inst_16228 = inst_16250;
var state_16298__$1 = (function (){var statearr_16330 = state_16298;
(statearr_16330[(7)] = inst_16228);

return statearr_16330;
})();
var statearr_16331_16405 = state_16298__$1;
(statearr_16331_16405[(2)] = null);

(statearr_16331_16405[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16302 === (29))){
var inst_16272 = (state_16298[(9)]);
var state_16298__$1 = state_16298;
var statearr_16332_16410 = state_16298__$1;
(statearr_16332_16410[(2)] = inst_16272);

(statearr_16332_16410[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16302 === (6))){
var state_16298__$1 = state_16298;
var statearr_16333_16411 = state_16298__$1;
(statearr_16333_16411[(2)] = false);

(statearr_16333_16411[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16302 === (28))){
var inst_16268 = (state_16298[(2)]);
var inst_16269 = calc_state.call(null);
var inst_16228 = inst_16269;
var state_16298__$1 = (function (){var statearr_16334 = state_16298;
(statearr_16334[(7)] = inst_16228);

(statearr_16334[(15)] = inst_16268);

return statearr_16334;
})();
var statearr_16335_16412 = state_16298__$1;
(statearr_16335_16412[(2)] = null);

(statearr_16335_16412[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16302 === (25))){
var inst_16294 = (state_16298[(2)]);
var state_16298__$1 = state_16298;
var statearr_16336_16413 = state_16298__$1;
(statearr_16336_16413[(2)] = inst_16294);

(statearr_16336_16413[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16302 === (34))){
var inst_16292 = (state_16298[(2)]);
var state_16298__$1 = state_16298;
var statearr_16337_16414 = state_16298__$1;
(statearr_16337_16414[(2)] = inst_16292);

(statearr_16337_16414[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16302 === (17))){
var state_16298__$1 = state_16298;
var statearr_16338_16415 = state_16298__$1;
(statearr_16338_16415[(2)] = false);

(statearr_16338_16415[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16302 === (3))){
var state_16298__$1 = state_16298;
var statearr_16339_16416 = state_16298__$1;
(statearr_16339_16416[(2)] = false);

(statearr_16339_16416[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16302 === (12))){
var inst_16296 = (state_16298[(2)]);
var state_16298__$1 = state_16298;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16298__$1,inst_16296);
} else {
if((state_val_16302 === (2))){
var inst_16204 = (state_16298[(8)]);
var inst_16209 = inst_16204.cljs$lang$protocol_mask$partition0$;
var inst_16210 = (inst_16209 & (64));
var inst_16211 = inst_16204.cljs$core$ISeq$;
var inst_16212 = (inst_16210) || (inst_16211);
var state_16298__$1 = state_16298;
if(cljs.core.truth_(inst_16212)){
var statearr_16340_16418 = state_16298__$1;
(statearr_16340_16418[(1)] = (5));

} else {
var statearr_16342_16419 = state_16298__$1;
(statearr_16342_16419[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16302 === (23))){
var inst_16257 = (state_16298[(14)]);
var inst_16263 = (inst_16257 == null);
var state_16298__$1 = state_16298;
if(cljs.core.truth_(inst_16263)){
var statearr_16343_16420 = state_16298__$1;
(statearr_16343_16420[(1)] = (26));

} else {
var statearr_16344_16421 = state_16298__$1;
(statearr_16344_16421[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16302 === (35))){
var inst_16283 = (state_16298[(2)]);
var state_16298__$1 = state_16298;
if(cljs.core.truth_(inst_16283)){
var statearr_16345_16422 = state_16298__$1;
(statearr_16345_16422[(1)] = (36));

} else {
var statearr_16346_16423 = state_16298__$1;
(statearr_16346_16423[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16302 === (19))){
var inst_16228 = (state_16298[(7)]);
var inst_16247 = cljs.core.apply.call(null,cljs.core.hash_map,inst_16228);
var state_16298__$1 = state_16298;
var statearr_16347_16424 = state_16298__$1;
(statearr_16347_16424[(2)] = inst_16247);

(statearr_16347_16424[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16302 === (11))){
var inst_16228 = (state_16298[(7)]);
var inst_16232 = (inst_16228 == null);
var inst_16233 = cljs.core.not.call(null,inst_16232);
var state_16298__$1 = state_16298;
if(inst_16233){
var statearr_16348_16425 = state_16298__$1;
(statearr_16348_16425[(1)] = (13));

} else {
var statearr_16349_16426 = state_16298__$1;
(statearr_16349_16426[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16302 === (9))){
var inst_16204 = (state_16298[(8)]);
var state_16298__$1 = state_16298;
var statearr_16350_16427 = state_16298__$1;
(statearr_16350_16427[(2)] = inst_16204);

(statearr_16350_16427[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16302 === (5))){
var state_16298__$1 = state_16298;
var statearr_16351_16428 = state_16298__$1;
(statearr_16351_16428[(2)] = true);

(statearr_16351_16428[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16302 === (14))){
var state_16298__$1 = state_16298;
var statearr_16352_16429 = state_16298__$1;
(statearr_16352_16429[(2)] = false);

(statearr_16352_16429[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16302 === (26))){
var inst_16258 = (state_16298[(10)]);
var inst_16265 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_16258);
var state_16298__$1 = state_16298;
var statearr_16353_16430 = state_16298__$1;
(statearr_16353_16430[(2)] = inst_16265);

(statearr_16353_16430[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16302 === (16))){
var state_16298__$1 = state_16298;
var statearr_16354_16431 = state_16298__$1;
(statearr_16354_16431[(2)] = true);

(statearr_16354_16431[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16302 === (38))){
var inst_16288 = (state_16298[(2)]);
var state_16298__$1 = state_16298;
var statearr_16355_16432 = state_16298__$1;
(statearr_16355_16432[(2)] = inst_16288);

(statearr_16355_16432[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16302 === (30))){
var inst_16258 = (state_16298[(10)]);
var inst_16252 = (state_16298[(13)]);
var inst_16251 = (state_16298[(11)]);
var inst_16275 = cljs.core.empty_QMARK_.call(null,inst_16251);
var inst_16276 = inst_16252.call(null,inst_16258);
var inst_16277 = cljs.core.not.call(null,inst_16276);
var inst_16278 = (inst_16275) && (inst_16277);
var state_16298__$1 = state_16298;
var statearr_16356_16434 = state_16298__$1;
(statearr_16356_16434[(2)] = inst_16278);

(statearr_16356_16434[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16302 === (10))){
var inst_16204 = (state_16298[(8)]);
var inst_16224 = (state_16298[(2)]);
var inst_16225 = cljs.core.get.call(null,inst_16224,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_16226 = cljs.core.get.call(null,inst_16224,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_16227 = cljs.core.get.call(null,inst_16224,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_16228 = inst_16204;
var state_16298__$1 = (function (){var statearr_16357 = state_16298;
(statearr_16357[(16)] = inst_16227);

(statearr_16357[(17)] = inst_16225);

(statearr_16357[(7)] = inst_16228);

(statearr_16357[(18)] = inst_16226);

return statearr_16357;
})();
var statearr_16358_16436 = state_16298__$1;
(statearr_16358_16436[(2)] = null);

(statearr_16358_16436[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16302 === (18))){
var inst_16242 = (state_16298[(2)]);
var state_16298__$1 = state_16298;
var statearr_16359_16437 = state_16298__$1;
(statearr_16359_16437[(2)] = inst_16242);

(statearr_16359_16437[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16302 === (37))){
var state_16298__$1 = state_16298;
var statearr_16360_16441 = state_16298__$1;
(statearr_16360_16441[(2)] = null);

(statearr_16360_16441[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16302 === (8))){
var inst_16204 = (state_16298[(8)]);
var inst_16221 = cljs.core.apply.call(null,cljs.core.hash_map,inst_16204);
var state_16298__$1 = state_16298;
var statearr_16361_16442 = state_16298__$1;
(statearr_16361_16442[(2)] = inst_16221);

(statearr_16361_16442[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14355__auto___16378,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__14236__auto__,c__14355__auto___16378,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__14237__auto__ = null;
var cljs$core$async$mix_$_state_machine__14237__auto____0 = (function (){
var statearr_16365 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16365[(0)] = cljs$core$async$mix_$_state_machine__14237__auto__);

(statearr_16365[(1)] = (1));

return statearr_16365;
});
var cljs$core$async$mix_$_state_machine__14237__auto____1 = (function (state_16298){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_16298);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e16366){if((e16366 instanceof Object)){
var ex__14240__auto__ = e16366;
var statearr_16367_16448 = state_16298;
(statearr_16367_16448[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16298);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16366;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16449 = state_16298;
state_16298 = G__16449;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__14237__auto__ = function(state_16298){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__14237__auto____1.call(this,state_16298);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__14237__auto____0;
cljs$core$async$mix_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__14237__auto____1;
return cljs$core$async$mix_$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14355__auto___16378,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__14357__auto__ = (function (){var statearr_16368 = f__14356__auto__.call(null);
(statearr_16368[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14355__auto___16378);

return statearr_16368;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14357__auto__);
});})(c__14355__auto___16378,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__6704__auto__ = (((p == null))?null:p);
var m__6705__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__6705__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__6704__auto__ = (((p == null))?null:p);
var m__6705__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,p,v,ch);
} else {
var m__6705__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args16464 = [];
var len__7107__auto___16467 = arguments.length;
var i__7108__auto___16468 = (0);
while(true){
if((i__7108__auto___16468 < len__7107__auto___16467)){
args16464.push((arguments[i__7108__auto___16468]));

var G__16469 = (i__7108__auto___16468 + (1));
i__7108__auto___16468 = G__16469;
continue;
} else {
}
break;
}

var G__16466 = args16464.length;
switch (G__16466) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16464.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__6704__auto__ = (((p == null))?null:p);
var m__6705__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,p);
} else {
var m__6705__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__6704__auto__ = (((p == null))?null:p);
var m__6705__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,p,v);
} else {
var m__6705__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args16472 = [];
var len__7107__auto___16604 = arguments.length;
var i__7108__auto___16605 = (0);
while(true){
if((i__7108__auto___16605 < len__7107__auto___16604)){
args16472.push((arguments[i__7108__auto___16605]));

var G__16607 = (i__7108__auto___16605 + (1));
i__7108__auto___16605 = G__16607;
continue;
} else {
}
break;
}

var G__16474 = args16472.length;
switch (G__16474) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16472.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__6049__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__6049__auto__)){
return or__6049__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__6049__auto__,mults){
return (function (p1__16471_SHARP_){
if(cljs.core.truth_(p1__16471_SHARP_.call(null,topic))){
return p1__16471_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__16471_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__6049__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async16475 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16475 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta16476){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta16476 = meta16476;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16475.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_16477,meta16476__$1){
var self__ = this;
var _16477__$1 = this;
return (new cljs.core.async.t_cljs$core$async16475(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta16476__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16475.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_16477){
var self__ = this;
var _16477__$1 = this;
return self__.meta16476;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16475.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async16475.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16475.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async16475.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16475.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16475.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16475.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16475.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta16476","meta16476",-1432060876,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16475.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16475.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16475";

cljs.core.async.t_cljs$core$async16475.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16475");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async16475 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async16475(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta16476){
return (new cljs.core.async.t_cljs$core$async16475(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta16476));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async16475(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__14355__auto___16615 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14355__auto___16615,mults,ensure_mult,p){
return (function (){
var f__14356__auto__ = (function (){var switch__14236__auto__ = ((function (c__14355__auto___16615,mults,ensure_mult,p){
return (function (state_16550){
var state_val_16551 = (state_16550[(1)]);
if((state_val_16551 === (7))){
var inst_16546 = (state_16550[(2)]);
var state_16550__$1 = state_16550;
var statearr_16552_16616 = state_16550__$1;
(statearr_16552_16616[(2)] = inst_16546);

(statearr_16552_16616[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16551 === (20))){
var state_16550__$1 = state_16550;
var statearr_16553_16617 = state_16550__$1;
(statearr_16553_16617[(2)] = null);

(statearr_16553_16617[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16551 === (1))){
var state_16550__$1 = state_16550;
var statearr_16554_16622 = state_16550__$1;
(statearr_16554_16622[(2)] = null);

(statearr_16554_16622[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16551 === (24))){
var inst_16529 = (state_16550[(7)]);
var inst_16538 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_16529);
var state_16550__$1 = state_16550;
var statearr_16555_16623 = state_16550__$1;
(statearr_16555_16623[(2)] = inst_16538);

(statearr_16555_16623[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16551 === (4))){
var inst_16481 = (state_16550[(8)]);
var inst_16481__$1 = (state_16550[(2)]);
var inst_16482 = (inst_16481__$1 == null);
var state_16550__$1 = (function (){var statearr_16556 = state_16550;
(statearr_16556[(8)] = inst_16481__$1);

return statearr_16556;
})();
if(cljs.core.truth_(inst_16482)){
var statearr_16557_16626 = state_16550__$1;
(statearr_16557_16626[(1)] = (5));

} else {
var statearr_16558_16629 = state_16550__$1;
(statearr_16558_16629[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16551 === (15))){
var inst_16523 = (state_16550[(2)]);
var state_16550__$1 = state_16550;
var statearr_16559_16630 = state_16550__$1;
(statearr_16559_16630[(2)] = inst_16523);

(statearr_16559_16630[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16551 === (21))){
var inst_16543 = (state_16550[(2)]);
var state_16550__$1 = (function (){var statearr_16560 = state_16550;
(statearr_16560[(9)] = inst_16543);

return statearr_16560;
})();
var statearr_16561_16635 = state_16550__$1;
(statearr_16561_16635[(2)] = null);

(statearr_16561_16635[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16551 === (13))){
var inst_16505 = (state_16550[(10)]);
var inst_16507 = cljs.core.chunked_seq_QMARK_.call(null,inst_16505);
var state_16550__$1 = state_16550;
if(inst_16507){
var statearr_16562_16636 = state_16550__$1;
(statearr_16562_16636[(1)] = (16));

} else {
var statearr_16563_16637 = state_16550__$1;
(statearr_16563_16637[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16551 === (22))){
var inst_16535 = (state_16550[(2)]);
var state_16550__$1 = state_16550;
if(cljs.core.truth_(inst_16535)){
var statearr_16564_16638 = state_16550__$1;
(statearr_16564_16638[(1)] = (23));

} else {
var statearr_16565_16639 = state_16550__$1;
(statearr_16565_16639[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16551 === (6))){
var inst_16529 = (state_16550[(7)]);
var inst_16481 = (state_16550[(8)]);
var inst_16531 = (state_16550[(11)]);
var inst_16529__$1 = topic_fn.call(null,inst_16481);
var inst_16530 = cljs.core.deref.call(null,mults);
var inst_16531__$1 = cljs.core.get.call(null,inst_16530,inst_16529__$1);
var state_16550__$1 = (function (){var statearr_16566 = state_16550;
(statearr_16566[(7)] = inst_16529__$1);

(statearr_16566[(11)] = inst_16531__$1);

return statearr_16566;
})();
if(cljs.core.truth_(inst_16531__$1)){
var statearr_16567_16641 = state_16550__$1;
(statearr_16567_16641[(1)] = (19));

} else {
var statearr_16568_16642 = state_16550__$1;
(statearr_16568_16642[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16551 === (25))){
var inst_16540 = (state_16550[(2)]);
var state_16550__$1 = state_16550;
var statearr_16569_16643 = state_16550__$1;
(statearr_16569_16643[(2)] = inst_16540);

(statearr_16569_16643[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16551 === (17))){
var inst_16505 = (state_16550[(10)]);
var inst_16514 = cljs.core.first.call(null,inst_16505);
var inst_16515 = cljs.core.async.muxch_STAR_.call(null,inst_16514);
var inst_16516 = cljs.core.async.close_BANG_.call(null,inst_16515);
var inst_16517 = cljs.core.next.call(null,inst_16505);
var inst_16491 = inst_16517;
var inst_16492 = null;
var inst_16493 = (0);
var inst_16494 = (0);
var state_16550__$1 = (function (){var statearr_16570 = state_16550;
(statearr_16570[(12)] = inst_16492);

(statearr_16570[(13)] = inst_16494);

(statearr_16570[(14)] = inst_16491);

(statearr_16570[(15)] = inst_16493);

(statearr_16570[(16)] = inst_16516);

return statearr_16570;
})();
var statearr_16571_16648 = state_16550__$1;
(statearr_16571_16648[(2)] = null);

(statearr_16571_16648[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16551 === (3))){
var inst_16548 = (state_16550[(2)]);
var state_16550__$1 = state_16550;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16550__$1,inst_16548);
} else {
if((state_val_16551 === (12))){
var inst_16525 = (state_16550[(2)]);
var state_16550__$1 = state_16550;
var statearr_16572_16650 = state_16550__$1;
(statearr_16572_16650[(2)] = inst_16525);

(statearr_16572_16650[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16551 === (2))){
var state_16550__$1 = state_16550;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16550__$1,(4),ch);
} else {
if((state_val_16551 === (23))){
var state_16550__$1 = state_16550;
var statearr_16574_16651 = state_16550__$1;
(statearr_16574_16651[(2)] = null);

(statearr_16574_16651[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16551 === (19))){
var inst_16481 = (state_16550[(8)]);
var inst_16531 = (state_16550[(11)]);
var inst_16533 = cljs.core.async.muxch_STAR_.call(null,inst_16531);
var state_16550__$1 = state_16550;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16550__$1,(22),inst_16533,inst_16481);
} else {
if((state_val_16551 === (11))){
var inst_16491 = (state_16550[(14)]);
var inst_16505 = (state_16550[(10)]);
var inst_16505__$1 = cljs.core.seq.call(null,inst_16491);
var state_16550__$1 = (function (){var statearr_16575 = state_16550;
(statearr_16575[(10)] = inst_16505__$1);

return statearr_16575;
})();
if(inst_16505__$1){
var statearr_16576_16655 = state_16550__$1;
(statearr_16576_16655[(1)] = (13));

} else {
var statearr_16577_16656 = state_16550__$1;
(statearr_16577_16656[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16551 === (9))){
var inst_16527 = (state_16550[(2)]);
var state_16550__$1 = state_16550;
var statearr_16578_16661 = state_16550__$1;
(statearr_16578_16661[(2)] = inst_16527);

(statearr_16578_16661[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16551 === (5))){
var inst_16488 = cljs.core.deref.call(null,mults);
var inst_16489 = cljs.core.vals.call(null,inst_16488);
var inst_16490 = cljs.core.seq.call(null,inst_16489);
var inst_16491 = inst_16490;
var inst_16492 = null;
var inst_16493 = (0);
var inst_16494 = (0);
var state_16550__$1 = (function (){var statearr_16579 = state_16550;
(statearr_16579[(12)] = inst_16492);

(statearr_16579[(13)] = inst_16494);

(statearr_16579[(14)] = inst_16491);

(statearr_16579[(15)] = inst_16493);

return statearr_16579;
})();
var statearr_16580_16662 = state_16550__$1;
(statearr_16580_16662[(2)] = null);

(statearr_16580_16662[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16551 === (14))){
var state_16550__$1 = state_16550;
var statearr_16584_16663 = state_16550__$1;
(statearr_16584_16663[(2)] = null);

(statearr_16584_16663[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16551 === (16))){
var inst_16505 = (state_16550[(10)]);
var inst_16509 = cljs.core.chunk_first.call(null,inst_16505);
var inst_16510 = cljs.core.chunk_rest.call(null,inst_16505);
var inst_16511 = cljs.core.count.call(null,inst_16509);
var inst_16491 = inst_16510;
var inst_16492 = inst_16509;
var inst_16493 = inst_16511;
var inst_16494 = (0);
var state_16550__$1 = (function (){var statearr_16585 = state_16550;
(statearr_16585[(12)] = inst_16492);

(statearr_16585[(13)] = inst_16494);

(statearr_16585[(14)] = inst_16491);

(statearr_16585[(15)] = inst_16493);

return statearr_16585;
})();
var statearr_16586_16664 = state_16550__$1;
(statearr_16586_16664[(2)] = null);

(statearr_16586_16664[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16551 === (10))){
var inst_16492 = (state_16550[(12)]);
var inst_16494 = (state_16550[(13)]);
var inst_16491 = (state_16550[(14)]);
var inst_16493 = (state_16550[(15)]);
var inst_16499 = cljs.core._nth.call(null,inst_16492,inst_16494);
var inst_16500 = cljs.core.async.muxch_STAR_.call(null,inst_16499);
var inst_16501 = cljs.core.async.close_BANG_.call(null,inst_16500);
var inst_16502 = (inst_16494 + (1));
var tmp16581 = inst_16492;
var tmp16582 = inst_16491;
var tmp16583 = inst_16493;
var inst_16491__$1 = tmp16582;
var inst_16492__$1 = tmp16581;
var inst_16493__$1 = tmp16583;
var inst_16494__$1 = inst_16502;
var state_16550__$1 = (function (){var statearr_16587 = state_16550;
(statearr_16587[(12)] = inst_16492__$1);

(statearr_16587[(13)] = inst_16494__$1);

(statearr_16587[(14)] = inst_16491__$1);

(statearr_16587[(17)] = inst_16501);

(statearr_16587[(15)] = inst_16493__$1);

return statearr_16587;
})();
var statearr_16588_16666 = state_16550__$1;
(statearr_16588_16666[(2)] = null);

(statearr_16588_16666[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16551 === (18))){
var inst_16520 = (state_16550[(2)]);
var state_16550__$1 = state_16550;
var statearr_16589_16667 = state_16550__$1;
(statearr_16589_16667[(2)] = inst_16520);

(statearr_16589_16667[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16551 === (8))){
var inst_16494 = (state_16550[(13)]);
var inst_16493 = (state_16550[(15)]);
var inst_16496 = (inst_16494 < inst_16493);
var inst_16497 = inst_16496;
var state_16550__$1 = state_16550;
if(cljs.core.truth_(inst_16497)){
var statearr_16590_16668 = state_16550__$1;
(statearr_16590_16668[(1)] = (10));

} else {
var statearr_16591_16669 = state_16550__$1;
(statearr_16591_16669[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14355__auto___16615,mults,ensure_mult,p))
;
return ((function (switch__14236__auto__,c__14355__auto___16615,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_16595 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16595[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_16595[(1)] = (1));

return statearr_16595;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_16550){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_16550);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e16596){if((e16596 instanceof Object)){
var ex__14240__auto__ = e16596;
var statearr_16597_16670 = state_16550;
(statearr_16597_16670[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16550);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16596;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16671 = state_16550;
state_16550 = G__16671;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_16550){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_16550);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14355__auto___16615,mults,ensure_mult,p))
})();
var state__14357__auto__ = (function (){var statearr_16598 = f__14356__auto__.call(null);
(statearr_16598[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14355__auto___16615);

return statearr_16598;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14357__auto__);
});})(c__14355__auto___16615,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args16672 = [];
var len__7107__auto___16675 = arguments.length;
var i__7108__auto___16676 = (0);
while(true){
if((i__7108__auto___16676 < len__7107__auto___16675)){
args16672.push((arguments[i__7108__auto___16676]));

var G__16677 = (i__7108__auto___16676 + (1));
i__7108__auto___16676 = G__16677;
continue;
} else {
}
break;
}

var G__16674 = args16672.length;
switch (G__16674) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16672.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args16680 = [];
var len__7107__auto___16683 = arguments.length;
var i__7108__auto___16684 = (0);
while(true){
if((i__7108__auto___16684 < len__7107__auto___16683)){
args16680.push((arguments[i__7108__auto___16684]));

var G__16685 = (i__7108__auto___16684 + (1));
i__7108__auto___16684 = G__16685;
continue;
} else {
}
break;
}

var G__16682 = args16680.length;
switch (G__16682) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16680.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args16688 = [];
var len__7107__auto___16770 = arguments.length;
var i__7108__auto___16771 = (0);
while(true){
if((i__7108__auto___16771 < len__7107__auto___16770)){
args16688.push((arguments[i__7108__auto___16771]));

var G__16772 = (i__7108__auto___16771 + (1));
i__7108__auto___16771 = G__16772;
continue;
} else {
}
break;
}

var G__16693 = args16688.length;
switch (G__16693) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16688.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__14355__auto___16775 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14355__auto___16775,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__14356__auto__ = (function (){var switch__14236__auto__ = ((function (c__14355__auto___16775,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_16736){
var state_val_16737 = (state_16736[(1)]);
if((state_val_16737 === (7))){
var state_16736__$1 = state_16736;
var statearr_16739_16776 = state_16736__$1;
(statearr_16739_16776[(2)] = null);

(statearr_16739_16776[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16737 === (1))){
var state_16736__$1 = state_16736;
var statearr_16740_16777 = state_16736__$1;
(statearr_16740_16777[(2)] = null);

(statearr_16740_16777[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16737 === (4))){
var inst_16696 = (state_16736[(7)]);
var inst_16698 = (inst_16696 < cnt);
var state_16736__$1 = state_16736;
if(cljs.core.truth_(inst_16698)){
var statearr_16741_16778 = state_16736__$1;
(statearr_16741_16778[(1)] = (6));

} else {
var statearr_16742_16779 = state_16736__$1;
(statearr_16742_16779[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16737 === (15))){
var inst_16732 = (state_16736[(2)]);
var state_16736__$1 = state_16736;
var statearr_16743_16780 = state_16736__$1;
(statearr_16743_16780[(2)] = inst_16732);

(statearr_16743_16780[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16737 === (13))){
var inst_16725 = cljs.core.async.close_BANG_.call(null,out);
var state_16736__$1 = state_16736;
var statearr_16744_16781 = state_16736__$1;
(statearr_16744_16781[(2)] = inst_16725);

(statearr_16744_16781[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16737 === (6))){
var state_16736__$1 = state_16736;
var statearr_16745_16782 = state_16736__$1;
(statearr_16745_16782[(2)] = null);

(statearr_16745_16782[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16737 === (3))){
var inst_16734 = (state_16736[(2)]);
var state_16736__$1 = state_16736;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16736__$1,inst_16734);
} else {
if((state_val_16737 === (12))){
var inst_16722 = (state_16736[(8)]);
var inst_16722__$1 = (state_16736[(2)]);
var inst_16723 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_16722__$1);
var state_16736__$1 = (function (){var statearr_16746 = state_16736;
(statearr_16746[(8)] = inst_16722__$1);

return statearr_16746;
})();
if(cljs.core.truth_(inst_16723)){
var statearr_16747_16783 = state_16736__$1;
(statearr_16747_16783[(1)] = (13));

} else {
var statearr_16748_16784 = state_16736__$1;
(statearr_16748_16784[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16737 === (2))){
var inst_16695 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_16696 = (0);
var state_16736__$1 = (function (){var statearr_16749 = state_16736;
(statearr_16749[(7)] = inst_16696);

(statearr_16749[(9)] = inst_16695);

return statearr_16749;
})();
var statearr_16753_16785 = state_16736__$1;
(statearr_16753_16785[(2)] = null);

(statearr_16753_16785[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16737 === (11))){
var inst_16696 = (state_16736[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_16736,(10),Object,null,(9));
var inst_16709 = chs__$1.call(null,inst_16696);
var inst_16710 = done.call(null,inst_16696);
var inst_16711 = cljs.core.async.take_BANG_.call(null,inst_16709,inst_16710);
var state_16736__$1 = state_16736;
var statearr_16754_16786 = state_16736__$1;
(statearr_16754_16786[(2)] = inst_16711);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16736__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16737 === (9))){
var inst_16696 = (state_16736[(7)]);
var inst_16713 = (state_16736[(2)]);
var inst_16714 = (inst_16696 + (1));
var inst_16696__$1 = inst_16714;
var state_16736__$1 = (function (){var statearr_16755 = state_16736;
(statearr_16755[(7)] = inst_16696__$1);

(statearr_16755[(10)] = inst_16713);

return statearr_16755;
})();
var statearr_16756_16787 = state_16736__$1;
(statearr_16756_16787[(2)] = null);

(statearr_16756_16787[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16737 === (5))){
var inst_16720 = (state_16736[(2)]);
var state_16736__$1 = (function (){var statearr_16757 = state_16736;
(statearr_16757[(11)] = inst_16720);

return statearr_16757;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16736__$1,(12),dchan);
} else {
if((state_val_16737 === (14))){
var inst_16722 = (state_16736[(8)]);
var inst_16727 = cljs.core.apply.call(null,f,inst_16722);
var state_16736__$1 = state_16736;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16736__$1,(16),out,inst_16727);
} else {
if((state_val_16737 === (16))){
var inst_16729 = (state_16736[(2)]);
var state_16736__$1 = (function (){var statearr_16758 = state_16736;
(statearr_16758[(12)] = inst_16729);

return statearr_16758;
})();
var statearr_16759_16791 = state_16736__$1;
(statearr_16759_16791[(2)] = null);

(statearr_16759_16791[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16737 === (10))){
var inst_16703 = (state_16736[(2)]);
var inst_16704 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_16736__$1 = (function (){var statearr_16760 = state_16736;
(statearr_16760[(13)] = inst_16703);

return statearr_16760;
})();
var statearr_16761_16795 = state_16736__$1;
(statearr_16761_16795[(2)] = inst_16704);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16736__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16737 === (8))){
var inst_16718 = (state_16736[(2)]);
var state_16736__$1 = state_16736;
var statearr_16762_16797 = state_16736__$1;
(statearr_16762_16797[(2)] = inst_16718);

(statearr_16762_16797[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14355__auto___16775,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__14236__auto__,c__14355__auto___16775,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_16766 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16766[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_16766[(1)] = (1));

return statearr_16766;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_16736){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_16736);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e16767){if((e16767 instanceof Object)){
var ex__14240__auto__ = e16767;
var statearr_16768_16802 = state_16736;
(statearr_16768_16802[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16736);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16767;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16803 = state_16736;
state_16736 = G__16803;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_16736){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_16736);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14355__auto___16775,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__14357__auto__ = (function (){var statearr_16769 = f__14356__auto__.call(null);
(statearr_16769[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14355__auto___16775);

return statearr_16769;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14357__auto__);
});})(c__14355__auto___16775,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args16806 = [];
var len__7107__auto___16866 = arguments.length;
var i__7108__auto___16867 = (0);
while(true){
if((i__7108__auto___16867 < len__7107__auto___16866)){
args16806.push((arguments[i__7108__auto___16867]));

var G__16868 = (i__7108__auto___16867 + (1));
i__7108__auto___16867 = G__16868;
continue;
} else {
}
break;
}

var G__16808 = args16806.length;
switch (G__16808) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16806.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14355__auto___16870 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14355__auto___16870,out){
return (function (){
var f__14356__auto__ = (function (){var switch__14236__auto__ = ((function (c__14355__auto___16870,out){
return (function (state_16841){
var state_val_16842 = (state_16841[(1)]);
if((state_val_16842 === (7))){
var inst_16817 = (state_16841[(7)]);
var inst_16818 = (state_16841[(8)]);
var inst_16817__$1 = (state_16841[(2)]);
var inst_16818__$1 = cljs.core.nth.call(null,inst_16817__$1,(0),null);
var inst_16819 = cljs.core.nth.call(null,inst_16817__$1,(1),null);
var inst_16820 = (inst_16818__$1 == null);
var state_16841__$1 = (function (){var statearr_16843 = state_16841;
(statearr_16843[(7)] = inst_16817__$1);

(statearr_16843[(8)] = inst_16818__$1);

(statearr_16843[(9)] = inst_16819);

return statearr_16843;
})();
if(cljs.core.truth_(inst_16820)){
var statearr_16844_16871 = state_16841__$1;
(statearr_16844_16871[(1)] = (8));

} else {
var statearr_16845_16872 = state_16841__$1;
(statearr_16845_16872[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16842 === (1))){
var inst_16809 = cljs.core.vec.call(null,chs);
var inst_16810 = inst_16809;
var state_16841__$1 = (function (){var statearr_16846 = state_16841;
(statearr_16846[(10)] = inst_16810);

return statearr_16846;
})();
var statearr_16847_16873 = state_16841__$1;
(statearr_16847_16873[(2)] = null);

(statearr_16847_16873[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16842 === (4))){
var inst_16810 = (state_16841[(10)]);
var state_16841__$1 = state_16841;
return cljs.core.async.ioc_alts_BANG_.call(null,state_16841__$1,(7),inst_16810);
} else {
if((state_val_16842 === (6))){
var inst_16834 = (state_16841[(2)]);
var state_16841__$1 = state_16841;
var statearr_16848_16874 = state_16841__$1;
(statearr_16848_16874[(2)] = inst_16834);

(statearr_16848_16874[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16842 === (3))){
var inst_16836 = (state_16841[(2)]);
var state_16841__$1 = state_16841;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16841__$1,inst_16836);
} else {
if((state_val_16842 === (2))){
var inst_16810 = (state_16841[(10)]);
var inst_16812 = cljs.core.count.call(null,inst_16810);
var inst_16813 = (inst_16812 > (0));
var state_16841__$1 = state_16841;
if(cljs.core.truth_(inst_16813)){
var statearr_16850_16875 = state_16841__$1;
(statearr_16850_16875[(1)] = (4));

} else {
var statearr_16851_16876 = state_16841__$1;
(statearr_16851_16876[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16842 === (11))){
var inst_16810 = (state_16841[(10)]);
var inst_16827 = (state_16841[(2)]);
var tmp16849 = inst_16810;
var inst_16810__$1 = tmp16849;
var state_16841__$1 = (function (){var statearr_16852 = state_16841;
(statearr_16852[(11)] = inst_16827);

(statearr_16852[(10)] = inst_16810__$1);

return statearr_16852;
})();
var statearr_16853_16877 = state_16841__$1;
(statearr_16853_16877[(2)] = null);

(statearr_16853_16877[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16842 === (9))){
var inst_16818 = (state_16841[(8)]);
var state_16841__$1 = state_16841;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16841__$1,(11),out,inst_16818);
} else {
if((state_val_16842 === (5))){
var inst_16832 = cljs.core.async.close_BANG_.call(null,out);
var state_16841__$1 = state_16841;
var statearr_16855_16878 = state_16841__$1;
(statearr_16855_16878[(2)] = inst_16832);

(statearr_16855_16878[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16842 === (10))){
var inst_16830 = (state_16841[(2)]);
var state_16841__$1 = state_16841;
var statearr_16856_16879 = state_16841__$1;
(statearr_16856_16879[(2)] = inst_16830);

(statearr_16856_16879[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16842 === (8))){
var inst_16817 = (state_16841[(7)]);
var inst_16818 = (state_16841[(8)]);
var inst_16819 = (state_16841[(9)]);
var inst_16810 = (state_16841[(10)]);
var inst_16822 = (function (){var cs = inst_16810;
var vec__16815 = inst_16817;
var v = inst_16818;
var c = inst_16819;
return ((function (cs,vec__16815,v,c,inst_16817,inst_16818,inst_16819,inst_16810,state_val_16842,c__14355__auto___16870,out){
return (function (p1__16805_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__16805_SHARP_);
});
;})(cs,vec__16815,v,c,inst_16817,inst_16818,inst_16819,inst_16810,state_val_16842,c__14355__auto___16870,out))
})();
var inst_16823 = cljs.core.filterv.call(null,inst_16822,inst_16810);
var inst_16810__$1 = inst_16823;
var state_16841__$1 = (function (){var statearr_16857 = state_16841;
(statearr_16857[(10)] = inst_16810__$1);

return statearr_16857;
})();
var statearr_16858_16881 = state_16841__$1;
(statearr_16858_16881[(2)] = null);

(statearr_16858_16881[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__14355__auto___16870,out))
;
return ((function (switch__14236__auto__,c__14355__auto___16870,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_16862 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16862[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_16862[(1)] = (1));

return statearr_16862;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_16841){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_16841);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e16863){if((e16863 instanceof Object)){
var ex__14240__auto__ = e16863;
var statearr_16864_16885 = state_16841;
(statearr_16864_16885[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16841);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16863;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16886 = state_16841;
state_16841 = G__16886;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_16841){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_16841);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14355__auto___16870,out))
})();
var state__14357__auto__ = (function (){var statearr_16865 = f__14356__auto__.call(null);
(statearr_16865[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14355__auto___16870);

return statearr_16865;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14357__auto__);
});})(c__14355__auto___16870,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args16891 = [];
var len__7107__auto___16947 = arguments.length;
var i__7108__auto___16948 = (0);
while(true){
if((i__7108__auto___16948 < len__7107__auto___16947)){
args16891.push((arguments[i__7108__auto___16948]));

var G__16949 = (i__7108__auto___16948 + (1));
i__7108__auto___16948 = G__16949;
continue;
} else {
}
break;
}

var G__16893 = args16891.length;
switch (G__16893) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16891.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14355__auto___16951 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14355__auto___16951,out){
return (function (){
var f__14356__auto__ = (function (){var switch__14236__auto__ = ((function (c__14355__auto___16951,out){
return (function (state_16920){
var state_val_16921 = (state_16920[(1)]);
if((state_val_16921 === (7))){
var inst_16901 = (state_16920[(7)]);
var inst_16901__$1 = (state_16920[(2)]);
var inst_16902 = (inst_16901__$1 == null);
var inst_16903 = cljs.core.not.call(null,inst_16902);
var state_16920__$1 = (function (){var statearr_16922 = state_16920;
(statearr_16922[(7)] = inst_16901__$1);

return statearr_16922;
})();
if(inst_16903){
var statearr_16923_16953 = state_16920__$1;
(statearr_16923_16953[(1)] = (8));

} else {
var statearr_16924_16954 = state_16920__$1;
(statearr_16924_16954[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16921 === (1))){
var inst_16894 = (0);
var state_16920__$1 = (function (){var statearr_16925 = state_16920;
(statearr_16925[(8)] = inst_16894);

return statearr_16925;
})();
var statearr_16926_16955 = state_16920__$1;
(statearr_16926_16955[(2)] = null);

(statearr_16926_16955[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16921 === (4))){
var state_16920__$1 = state_16920;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16920__$1,(7),ch);
} else {
if((state_val_16921 === (6))){
var inst_16914 = (state_16920[(2)]);
var state_16920__$1 = state_16920;
var statearr_16928_16956 = state_16920__$1;
(statearr_16928_16956[(2)] = inst_16914);

(statearr_16928_16956[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16921 === (3))){
var inst_16916 = (state_16920[(2)]);
var inst_16917 = cljs.core.async.close_BANG_.call(null,out);
var state_16920__$1 = (function (){var statearr_16929 = state_16920;
(statearr_16929[(9)] = inst_16916);

return statearr_16929;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16920__$1,inst_16917);
} else {
if((state_val_16921 === (2))){
var inst_16894 = (state_16920[(8)]);
var inst_16898 = (inst_16894 < n);
var state_16920__$1 = state_16920;
if(cljs.core.truth_(inst_16898)){
var statearr_16930_16957 = state_16920__$1;
(statearr_16930_16957[(1)] = (4));

} else {
var statearr_16931_16958 = state_16920__$1;
(statearr_16931_16958[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16921 === (11))){
var inst_16894 = (state_16920[(8)]);
var inst_16906 = (state_16920[(2)]);
var inst_16907 = (inst_16894 + (1));
var inst_16894__$1 = inst_16907;
var state_16920__$1 = (function (){var statearr_16932 = state_16920;
(statearr_16932[(8)] = inst_16894__$1);

(statearr_16932[(10)] = inst_16906);

return statearr_16932;
})();
var statearr_16933_16959 = state_16920__$1;
(statearr_16933_16959[(2)] = null);

(statearr_16933_16959[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16921 === (9))){
var state_16920__$1 = state_16920;
var statearr_16934_16960 = state_16920__$1;
(statearr_16934_16960[(2)] = null);

(statearr_16934_16960[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16921 === (5))){
var state_16920__$1 = state_16920;
var statearr_16935_16961 = state_16920__$1;
(statearr_16935_16961[(2)] = null);

(statearr_16935_16961[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16921 === (10))){
var inst_16911 = (state_16920[(2)]);
var state_16920__$1 = state_16920;
var statearr_16936_16962 = state_16920__$1;
(statearr_16936_16962[(2)] = inst_16911);

(statearr_16936_16962[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16921 === (8))){
var inst_16901 = (state_16920[(7)]);
var state_16920__$1 = state_16920;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16920__$1,(11),out,inst_16901);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__14355__auto___16951,out))
;
return ((function (switch__14236__auto__,c__14355__auto___16951,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_16943 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_16943[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_16943[(1)] = (1));

return statearr_16943;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_16920){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_16920);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e16944){if((e16944 instanceof Object)){
var ex__14240__auto__ = e16944;
var statearr_16945_16963 = state_16920;
(statearr_16945_16963[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16920);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16944;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16964 = state_16920;
state_16920 = G__16964;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_16920){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_16920);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14355__auto___16951,out))
})();
var state__14357__auto__ = (function (){var statearr_16946 = f__14356__auto__.call(null);
(statearr_16946[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14355__auto___16951);

return statearr_16946;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14357__auto__);
});})(c__14355__auto___16951,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async16979 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16979 = (function (map_LT_,f,ch,meta16980){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta16980 = meta16980;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16979.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16981,meta16980__$1){
var self__ = this;
var _16981__$1 = this;
return (new cljs.core.async.t_cljs$core$async16979(self__.map_LT_,self__.f,self__.ch,meta16980__$1));
});

cljs.core.async.t_cljs$core$async16979.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16981){
var self__ = this;
var _16981__$1 = this;
return self__.meta16980;
});

cljs.core.async.t_cljs$core$async16979.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async16979.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async16979.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async16979.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async16979.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async16983 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16983 = (function (map_LT_,f,ch,meta16980,_,fn1,meta16984){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta16980 = meta16980;
this._ = _;
this.fn1 = fn1;
this.meta16984 = meta16984;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16983.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_16985,meta16984__$1){
var self__ = this;
var _16985__$1 = this;
return (new cljs.core.async.t_cljs$core$async16983(self__.map_LT_,self__.f,self__.ch,self__.meta16980,self__._,self__.fn1,meta16984__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async16983.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_16985){
var self__ = this;
var _16985__$1 = this;
return self__.meta16984;
});})(___$1))
;

cljs.core.async.t_cljs$core$async16983.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async16983.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async16983.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async16983.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__16965_SHARP_){
return f1.call(null,(((p1__16965_SHARP_ == null))?null:self__.f.call(null,p1__16965_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async16983.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16980","meta16980",1332802124,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async16979","cljs.core.async/t_cljs$core$async16979",1094971376,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta16984","meta16984",395734319,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async16983.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16983.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16983";

cljs.core.async.t_cljs$core$async16983.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16983");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async16983 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async16983(map_LT___$1,f__$1,ch__$1,meta16980__$1,___$2,fn1__$1,meta16984){
return (new cljs.core.async.t_cljs$core$async16983(map_LT___$1,f__$1,ch__$1,meta16980__$1,___$2,fn1__$1,meta16984));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async16983(self__.map_LT_,self__.f,self__.ch,self__.meta16980,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__6037__auto__ = ret;
if(cljs.core.truth_(and__6037__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__6037__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async16979.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async16979.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async16979.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16980","meta16980",1332802124,null)], null);
});

cljs.core.async.t_cljs$core$async16979.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16979.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16979";

cljs.core.async.t_cljs$core$async16979.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16979");
});

cljs.core.async.__GT_t_cljs$core$async16979 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async16979(map_LT___$1,f__$1,ch__$1,meta16980){
return (new cljs.core.async.t_cljs$core$async16979(map_LT___$1,f__$1,ch__$1,meta16980));
});

}

return (new cljs.core.async.t_cljs$core$async16979(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async16993 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16993 = (function (map_GT_,f,ch,meta16994){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta16994 = meta16994;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16993.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16995,meta16994__$1){
var self__ = this;
var _16995__$1 = this;
return (new cljs.core.async.t_cljs$core$async16993(self__.map_GT_,self__.f,self__.ch,meta16994__$1));
});

cljs.core.async.t_cljs$core$async16993.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16995){
var self__ = this;
var _16995__$1 = this;
return self__.meta16994;
});

cljs.core.async.t_cljs$core$async16993.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async16993.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async16993.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async16993.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async16993.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async16993.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async16993.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16994","meta16994",-1938814879,null)], null);
});

cljs.core.async.t_cljs$core$async16993.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16993.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16993";

cljs.core.async.t_cljs$core$async16993.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16993");
});

cljs.core.async.__GT_t_cljs$core$async16993 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async16993(map_GT___$1,f__$1,ch__$1,meta16994){
return (new cljs.core.async.t_cljs$core$async16993(map_GT___$1,f__$1,ch__$1,meta16994));
});

}

return (new cljs.core.async.t_cljs$core$async16993(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async17007 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17007 = (function (filter_GT_,p,ch,meta17008){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta17008 = meta17008;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17007.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17009,meta17008__$1){
var self__ = this;
var _17009__$1 = this;
return (new cljs.core.async.t_cljs$core$async17007(self__.filter_GT_,self__.p,self__.ch,meta17008__$1));
});

cljs.core.async.t_cljs$core$async17007.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17009){
var self__ = this;
var _17009__$1 = this;
return self__.meta17008;
});

cljs.core.async.t_cljs$core$async17007.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async17007.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async17007.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async17007.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async17007.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async17007.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async17007.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async17007.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta17008","meta17008",-1536455316,null)], null);
});

cljs.core.async.t_cljs$core$async17007.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17007.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17007";

cljs.core.async.t_cljs$core$async17007.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async17007");
});

cljs.core.async.__GT_t_cljs$core$async17007 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async17007(filter_GT___$1,p__$1,ch__$1,meta17008){
return (new cljs.core.async.t_cljs$core$async17007(filter_GT___$1,p__$1,ch__$1,meta17008));
});

}

return (new cljs.core.async.t_cljs$core$async17007(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args17010 = [];
var len__7107__auto___17061 = arguments.length;
var i__7108__auto___17062 = (0);
while(true){
if((i__7108__auto___17062 < len__7107__auto___17061)){
args17010.push((arguments[i__7108__auto___17062]));

var G__17063 = (i__7108__auto___17062 + (1));
i__7108__auto___17062 = G__17063;
continue;
} else {
}
break;
}

var G__17012 = args17010.length;
switch (G__17012) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17010.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14355__auto___17066 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14355__auto___17066,out){
return (function (){
var f__14356__auto__ = (function (){var switch__14236__auto__ = ((function (c__14355__auto___17066,out){
return (function (state_17033){
var state_val_17034 = (state_17033[(1)]);
if((state_val_17034 === (7))){
var inst_17029 = (state_17033[(2)]);
var state_17033__$1 = state_17033;
var statearr_17037_17067 = state_17033__$1;
(statearr_17037_17067[(2)] = inst_17029);

(statearr_17037_17067[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17034 === (1))){
var state_17033__$1 = state_17033;
var statearr_17038_17068 = state_17033__$1;
(statearr_17038_17068[(2)] = null);

(statearr_17038_17068[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17034 === (4))){
var inst_17015 = (state_17033[(7)]);
var inst_17015__$1 = (state_17033[(2)]);
var inst_17016 = (inst_17015__$1 == null);
var state_17033__$1 = (function (){var statearr_17040 = state_17033;
(statearr_17040[(7)] = inst_17015__$1);

return statearr_17040;
})();
if(cljs.core.truth_(inst_17016)){
var statearr_17041_17069 = state_17033__$1;
(statearr_17041_17069[(1)] = (5));

} else {
var statearr_17042_17070 = state_17033__$1;
(statearr_17042_17070[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17034 === (6))){
var inst_17015 = (state_17033[(7)]);
var inst_17020 = p.call(null,inst_17015);
var state_17033__$1 = state_17033;
if(cljs.core.truth_(inst_17020)){
var statearr_17043_17071 = state_17033__$1;
(statearr_17043_17071[(1)] = (8));

} else {
var statearr_17044_17072 = state_17033__$1;
(statearr_17044_17072[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17034 === (3))){
var inst_17031 = (state_17033[(2)]);
var state_17033__$1 = state_17033;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17033__$1,inst_17031);
} else {
if((state_val_17034 === (2))){
var state_17033__$1 = state_17033;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17033__$1,(4),ch);
} else {
if((state_val_17034 === (11))){
var inst_17023 = (state_17033[(2)]);
var state_17033__$1 = state_17033;
var statearr_17045_17073 = state_17033__$1;
(statearr_17045_17073[(2)] = inst_17023);

(statearr_17045_17073[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17034 === (9))){
var state_17033__$1 = state_17033;
var statearr_17047_17074 = state_17033__$1;
(statearr_17047_17074[(2)] = null);

(statearr_17047_17074[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17034 === (5))){
var inst_17018 = cljs.core.async.close_BANG_.call(null,out);
var state_17033__$1 = state_17033;
var statearr_17048_17075 = state_17033__$1;
(statearr_17048_17075[(2)] = inst_17018);

(statearr_17048_17075[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17034 === (10))){
var inst_17026 = (state_17033[(2)]);
var state_17033__$1 = (function (){var statearr_17049 = state_17033;
(statearr_17049[(8)] = inst_17026);

return statearr_17049;
})();
var statearr_17050_17076 = state_17033__$1;
(statearr_17050_17076[(2)] = null);

(statearr_17050_17076[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17034 === (8))){
var inst_17015 = (state_17033[(7)]);
var state_17033__$1 = state_17033;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17033__$1,(11),out,inst_17015);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__14355__auto___17066,out))
;
return ((function (switch__14236__auto__,c__14355__auto___17066,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_17054 = [null,null,null,null,null,null,null,null,null];
(statearr_17054[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_17054[(1)] = (1));

return statearr_17054;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_17033){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_17033);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e17055){if((e17055 instanceof Object)){
var ex__14240__auto__ = e17055;
var statearr_17056_17077 = state_17033;
(statearr_17056_17077[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17033);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17055;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17078 = state_17033;
state_17033 = G__17078;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_17033){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_17033);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14355__auto___17066,out))
})();
var state__14357__auto__ = (function (){var statearr_17057 = f__14356__auto__.call(null);
(statearr_17057[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14355__auto___17066);

return statearr_17057;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14357__auto__);
});})(c__14355__auto___17066,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args17079 = [];
var len__7107__auto___17086 = arguments.length;
var i__7108__auto___17087 = (0);
while(true){
if((i__7108__auto___17087 < len__7107__auto___17086)){
args17079.push((arguments[i__7108__auto___17087]));

var G__17088 = (i__7108__auto___17087 + (1));
i__7108__auto___17087 = G__17088;
continue;
} else {
}
break;
}

var G__17084 = args17079.length;
switch (G__17084) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17079.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__14355__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14355__auto__){
return (function (){
var f__14356__auto__ = (function (){var switch__14236__auto__ = ((function (c__14355__auto__){
return (function (state_17263){
var state_val_17264 = (state_17263[(1)]);
if((state_val_17264 === (7))){
var inst_17259 = (state_17263[(2)]);
var state_17263__$1 = state_17263;
var statearr_17265_17306 = state_17263__$1;
(statearr_17265_17306[(2)] = inst_17259);

(statearr_17265_17306[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17264 === (20))){
var inst_17229 = (state_17263[(7)]);
var inst_17240 = (state_17263[(2)]);
var inst_17241 = cljs.core.next.call(null,inst_17229);
var inst_17215 = inst_17241;
var inst_17216 = null;
var inst_17217 = (0);
var inst_17218 = (0);
var state_17263__$1 = (function (){var statearr_17266 = state_17263;
(statearr_17266[(8)] = inst_17218);

(statearr_17266[(9)] = inst_17215);

(statearr_17266[(10)] = inst_17217);

(statearr_17266[(11)] = inst_17240);

(statearr_17266[(12)] = inst_17216);

return statearr_17266;
})();
var statearr_17267_17307 = state_17263__$1;
(statearr_17267_17307[(2)] = null);

(statearr_17267_17307[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17264 === (1))){
var state_17263__$1 = state_17263;
var statearr_17268_17308 = state_17263__$1;
(statearr_17268_17308[(2)] = null);

(statearr_17268_17308[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17264 === (4))){
var inst_17204 = (state_17263[(13)]);
var inst_17204__$1 = (state_17263[(2)]);
var inst_17205 = (inst_17204__$1 == null);
var state_17263__$1 = (function (){var statearr_17269 = state_17263;
(statearr_17269[(13)] = inst_17204__$1);

return statearr_17269;
})();
if(cljs.core.truth_(inst_17205)){
var statearr_17270_17309 = state_17263__$1;
(statearr_17270_17309[(1)] = (5));

} else {
var statearr_17271_17311 = state_17263__$1;
(statearr_17271_17311[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17264 === (15))){
var state_17263__$1 = state_17263;
var statearr_17275_17312 = state_17263__$1;
(statearr_17275_17312[(2)] = null);

(statearr_17275_17312[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17264 === (21))){
var state_17263__$1 = state_17263;
var statearr_17276_17317 = state_17263__$1;
(statearr_17276_17317[(2)] = null);

(statearr_17276_17317[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17264 === (13))){
var inst_17218 = (state_17263[(8)]);
var inst_17215 = (state_17263[(9)]);
var inst_17217 = (state_17263[(10)]);
var inst_17216 = (state_17263[(12)]);
var inst_17225 = (state_17263[(2)]);
var inst_17226 = (inst_17218 + (1));
var tmp17272 = inst_17215;
var tmp17273 = inst_17217;
var tmp17274 = inst_17216;
var inst_17215__$1 = tmp17272;
var inst_17216__$1 = tmp17274;
var inst_17217__$1 = tmp17273;
var inst_17218__$1 = inst_17226;
var state_17263__$1 = (function (){var statearr_17277 = state_17263;
(statearr_17277[(8)] = inst_17218__$1);

(statearr_17277[(14)] = inst_17225);

(statearr_17277[(9)] = inst_17215__$1);

(statearr_17277[(10)] = inst_17217__$1);

(statearr_17277[(12)] = inst_17216__$1);

return statearr_17277;
})();
var statearr_17278_17322 = state_17263__$1;
(statearr_17278_17322[(2)] = null);

(statearr_17278_17322[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17264 === (22))){
var state_17263__$1 = state_17263;
var statearr_17279_17323 = state_17263__$1;
(statearr_17279_17323[(2)] = null);

(statearr_17279_17323[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17264 === (6))){
var inst_17204 = (state_17263[(13)]);
var inst_17213 = f.call(null,inst_17204);
var inst_17214 = cljs.core.seq.call(null,inst_17213);
var inst_17215 = inst_17214;
var inst_17216 = null;
var inst_17217 = (0);
var inst_17218 = (0);
var state_17263__$1 = (function (){var statearr_17280 = state_17263;
(statearr_17280[(8)] = inst_17218);

(statearr_17280[(9)] = inst_17215);

(statearr_17280[(10)] = inst_17217);

(statearr_17280[(12)] = inst_17216);

return statearr_17280;
})();
var statearr_17281_17329 = state_17263__$1;
(statearr_17281_17329[(2)] = null);

(statearr_17281_17329[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17264 === (17))){
var inst_17229 = (state_17263[(7)]);
var inst_17233 = cljs.core.chunk_first.call(null,inst_17229);
var inst_17234 = cljs.core.chunk_rest.call(null,inst_17229);
var inst_17235 = cljs.core.count.call(null,inst_17233);
var inst_17215 = inst_17234;
var inst_17216 = inst_17233;
var inst_17217 = inst_17235;
var inst_17218 = (0);
var state_17263__$1 = (function (){var statearr_17282 = state_17263;
(statearr_17282[(8)] = inst_17218);

(statearr_17282[(9)] = inst_17215);

(statearr_17282[(10)] = inst_17217);

(statearr_17282[(12)] = inst_17216);

return statearr_17282;
})();
var statearr_17283_17332 = state_17263__$1;
(statearr_17283_17332[(2)] = null);

(statearr_17283_17332[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17264 === (3))){
var inst_17261 = (state_17263[(2)]);
var state_17263__$1 = state_17263;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17263__$1,inst_17261);
} else {
if((state_val_17264 === (12))){
var inst_17249 = (state_17263[(2)]);
var state_17263__$1 = state_17263;
var statearr_17284_17334 = state_17263__$1;
(statearr_17284_17334[(2)] = inst_17249);

(statearr_17284_17334[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17264 === (2))){
var state_17263__$1 = state_17263;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17263__$1,(4),in$);
} else {
if((state_val_17264 === (23))){
var inst_17257 = (state_17263[(2)]);
var state_17263__$1 = state_17263;
var statearr_17285_17336 = state_17263__$1;
(statearr_17285_17336[(2)] = inst_17257);

(statearr_17285_17336[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17264 === (19))){
var inst_17244 = (state_17263[(2)]);
var state_17263__$1 = state_17263;
var statearr_17286_17337 = state_17263__$1;
(statearr_17286_17337[(2)] = inst_17244);

(statearr_17286_17337[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17264 === (11))){
var inst_17229 = (state_17263[(7)]);
var inst_17215 = (state_17263[(9)]);
var inst_17229__$1 = cljs.core.seq.call(null,inst_17215);
var state_17263__$1 = (function (){var statearr_17287 = state_17263;
(statearr_17287[(7)] = inst_17229__$1);

return statearr_17287;
})();
if(inst_17229__$1){
var statearr_17288_17338 = state_17263__$1;
(statearr_17288_17338[(1)] = (14));

} else {
var statearr_17289_17339 = state_17263__$1;
(statearr_17289_17339[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17264 === (9))){
var inst_17251 = (state_17263[(2)]);
var inst_17252 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_17263__$1 = (function (){var statearr_17290 = state_17263;
(statearr_17290[(15)] = inst_17251);

return statearr_17290;
})();
if(cljs.core.truth_(inst_17252)){
var statearr_17291_17340 = state_17263__$1;
(statearr_17291_17340[(1)] = (21));

} else {
var statearr_17292_17341 = state_17263__$1;
(statearr_17292_17341[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17264 === (5))){
var inst_17207 = cljs.core.async.close_BANG_.call(null,out);
var state_17263__$1 = state_17263;
var statearr_17293_17342 = state_17263__$1;
(statearr_17293_17342[(2)] = inst_17207);

(statearr_17293_17342[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17264 === (14))){
var inst_17229 = (state_17263[(7)]);
var inst_17231 = cljs.core.chunked_seq_QMARK_.call(null,inst_17229);
var state_17263__$1 = state_17263;
if(inst_17231){
var statearr_17294_17344 = state_17263__$1;
(statearr_17294_17344[(1)] = (17));

} else {
var statearr_17295_17345 = state_17263__$1;
(statearr_17295_17345[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17264 === (16))){
var inst_17247 = (state_17263[(2)]);
var state_17263__$1 = state_17263;
var statearr_17296_17346 = state_17263__$1;
(statearr_17296_17346[(2)] = inst_17247);

(statearr_17296_17346[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17264 === (10))){
var inst_17218 = (state_17263[(8)]);
var inst_17216 = (state_17263[(12)]);
var inst_17223 = cljs.core._nth.call(null,inst_17216,inst_17218);
var state_17263__$1 = state_17263;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17263__$1,(13),out,inst_17223);
} else {
if((state_val_17264 === (18))){
var inst_17229 = (state_17263[(7)]);
var inst_17238 = cljs.core.first.call(null,inst_17229);
var state_17263__$1 = state_17263;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17263__$1,(20),out,inst_17238);
} else {
if((state_val_17264 === (8))){
var inst_17218 = (state_17263[(8)]);
var inst_17217 = (state_17263[(10)]);
var inst_17220 = (inst_17218 < inst_17217);
var inst_17221 = inst_17220;
var state_17263__$1 = state_17263;
if(cljs.core.truth_(inst_17221)){
var statearr_17297_17347 = state_17263__$1;
(statearr_17297_17347[(1)] = (10));

} else {
var statearr_17298_17348 = state_17263__$1;
(statearr_17298_17348[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14355__auto__))
;
return ((function (switch__14236__auto__,c__14355__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_17302 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17302[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__);

(statearr_17302[(1)] = (1));

return statearr_17302;
});
var cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____1 = (function (state_17263){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_17263);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e17303){if((e17303 instanceof Object)){
var ex__14240__auto__ = e17303;
var statearr_17304_17356 = state_17263;
(statearr_17304_17356[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17263);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17303;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17362 = state_17263;
state_17263 = G__17362;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__ = function(state_17263){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____1.call(this,state_17263);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14355__auto__))
})();
var state__14357__auto__ = (function (){var statearr_17305 = f__14356__auto__.call(null);
(statearr_17305[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14355__auto__);

return statearr_17305;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14357__auto__);
});})(c__14355__auto__))
);

return c__14355__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args17365 = [];
var len__7107__auto___17370 = arguments.length;
var i__7108__auto___17371 = (0);
while(true){
if((i__7108__auto___17371 < len__7107__auto___17370)){
args17365.push((arguments[i__7108__auto___17371]));

var G__17372 = (i__7108__auto___17371 + (1));
i__7108__auto___17371 = G__17372;
continue;
} else {
}
break;
}

var G__17369 = args17365.length;
switch (G__17369) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17365.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args17375 = [];
var len__7107__auto___17379 = arguments.length;
var i__7108__auto___17380 = (0);
while(true){
if((i__7108__auto___17380 < len__7107__auto___17379)){
args17375.push((arguments[i__7108__auto___17380]));

var G__17381 = (i__7108__auto___17380 + (1));
i__7108__auto___17380 = G__17381;
continue;
} else {
}
break;
}

var G__17377 = args17375.length;
switch (G__17377) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17375.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args17389 = [];
var len__7107__auto___17451 = arguments.length;
var i__7108__auto___17452 = (0);
while(true){
if((i__7108__auto___17452 < len__7107__auto___17451)){
args17389.push((arguments[i__7108__auto___17452]));

var G__17453 = (i__7108__auto___17452 + (1));
i__7108__auto___17452 = G__17453;
continue;
} else {
}
break;
}

var G__17397 = args17389.length;
switch (G__17397) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17389.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14355__auto___17455 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14355__auto___17455,out){
return (function (){
var f__14356__auto__ = (function (){var switch__14236__auto__ = ((function (c__14355__auto___17455,out){
return (function (state_17423){
var state_val_17424 = (state_17423[(1)]);
if((state_val_17424 === (7))){
var inst_17418 = (state_17423[(2)]);
var state_17423__$1 = state_17423;
var statearr_17426_17456 = state_17423__$1;
(statearr_17426_17456[(2)] = inst_17418);

(statearr_17426_17456[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17424 === (1))){
var inst_17399 = null;
var state_17423__$1 = (function (){var statearr_17427 = state_17423;
(statearr_17427[(7)] = inst_17399);

return statearr_17427;
})();
var statearr_17429_17457 = state_17423__$1;
(statearr_17429_17457[(2)] = null);

(statearr_17429_17457[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17424 === (4))){
var inst_17402 = (state_17423[(8)]);
var inst_17402__$1 = (state_17423[(2)]);
var inst_17404 = (inst_17402__$1 == null);
var inst_17405 = cljs.core.not.call(null,inst_17404);
var state_17423__$1 = (function (){var statearr_17430 = state_17423;
(statearr_17430[(8)] = inst_17402__$1);

return statearr_17430;
})();
if(inst_17405){
var statearr_17431_17462 = state_17423__$1;
(statearr_17431_17462[(1)] = (5));

} else {
var statearr_17432_17463 = state_17423__$1;
(statearr_17432_17463[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17424 === (6))){
var state_17423__$1 = state_17423;
var statearr_17433_17464 = state_17423__$1;
(statearr_17433_17464[(2)] = null);

(statearr_17433_17464[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17424 === (3))){
var inst_17420 = (state_17423[(2)]);
var inst_17421 = cljs.core.async.close_BANG_.call(null,out);
var state_17423__$1 = (function (){var statearr_17434 = state_17423;
(statearr_17434[(9)] = inst_17420);

return statearr_17434;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17423__$1,inst_17421);
} else {
if((state_val_17424 === (2))){
var state_17423__$1 = state_17423;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17423__$1,(4),ch);
} else {
if((state_val_17424 === (11))){
var inst_17402 = (state_17423[(8)]);
var inst_17412 = (state_17423[(2)]);
var inst_17399 = inst_17402;
var state_17423__$1 = (function (){var statearr_17435 = state_17423;
(statearr_17435[(10)] = inst_17412);

(statearr_17435[(7)] = inst_17399);

return statearr_17435;
})();
var statearr_17436_17468 = state_17423__$1;
(statearr_17436_17468[(2)] = null);

(statearr_17436_17468[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17424 === (9))){
var inst_17402 = (state_17423[(8)]);
var state_17423__$1 = state_17423;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17423__$1,(11),out,inst_17402);
} else {
if((state_val_17424 === (5))){
var inst_17402 = (state_17423[(8)]);
var inst_17399 = (state_17423[(7)]);
var inst_17407 = cljs.core._EQ_.call(null,inst_17402,inst_17399);
var state_17423__$1 = state_17423;
if(inst_17407){
var statearr_17438_17469 = state_17423__$1;
(statearr_17438_17469[(1)] = (8));

} else {
var statearr_17439_17470 = state_17423__$1;
(statearr_17439_17470[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17424 === (10))){
var inst_17415 = (state_17423[(2)]);
var state_17423__$1 = state_17423;
var statearr_17440_17471 = state_17423__$1;
(statearr_17440_17471[(2)] = inst_17415);

(statearr_17440_17471[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17424 === (8))){
var inst_17399 = (state_17423[(7)]);
var tmp17437 = inst_17399;
var inst_17399__$1 = tmp17437;
var state_17423__$1 = (function (){var statearr_17441 = state_17423;
(statearr_17441[(7)] = inst_17399__$1);

return statearr_17441;
})();
var statearr_17442_17473 = state_17423__$1;
(statearr_17442_17473[(2)] = null);

(statearr_17442_17473[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__14355__auto___17455,out))
;
return ((function (switch__14236__auto__,c__14355__auto___17455,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_17447 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17447[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_17447[(1)] = (1));

return statearr_17447;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_17423){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_17423);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e17448){if((e17448 instanceof Object)){
var ex__14240__auto__ = e17448;
var statearr_17449_17474 = state_17423;
(statearr_17449_17474[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17423);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17448;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17475 = state_17423;
state_17423 = G__17475;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_17423){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_17423);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14355__auto___17455,out))
})();
var state__14357__auto__ = (function (){var statearr_17450 = f__14356__auto__.call(null);
(statearr_17450[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14355__auto___17455);

return statearr_17450;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14357__auto__);
});})(c__14355__auto___17455,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args17476 = [];
var len__7107__auto___17550 = arguments.length;
var i__7108__auto___17551 = (0);
while(true){
if((i__7108__auto___17551 < len__7107__auto___17550)){
args17476.push((arguments[i__7108__auto___17551]));

var G__17552 = (i__7108__auto___17551 + (1));
i__7108__auto___17551 = G__17552;
continue;
} else {
}
break;
}

var G__17478 = args17476.length;
switch (G__17478) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17476.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14355__auto___17557 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14355__auto___17557,out){
return (function (){
var f__14356__auto__ = (function (){var switch__14236__auto__ = ((function (c__14355__auto___17557,out){
return (function (state_17516){
var state_val_17517 = (state_17516[(1)]);
if((state_val_17517 === (7))){
var inst_17512 = (state_17516[(2)]);
var state_17516__$1 = state_17516;
var statearr_17518_17558 = state_17516__$1;
(statearr_17518_17558[(2)] = inst_17512);

(statearr_17518_17558[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17517 === (1))){
var inst_17479 = (new Array(n));
var inst_17480 = inst_17479;
var inst_17481 = (0);
var state_17516__$1 = (function (){var statearr_17519 = state_17516;
(statearr_17519[(7)] = inst_17481);

(statearr_17519[(8)] = inst_17480);

return statearr_17519;
})();
var statearr_17520_17560 = state_17516__$1;
(statearr_17520_17560[(2)] = null);

(statearr_17520_17560[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17517 === (4))){
var inst_17484 = (state_17516[(9)]);
var inst_17484__$1 = (state_17516[(2)]);
var inst_17485 = (inst_17484__$1 == null);
var inst_17486 = cljs.core.not.call(null,inst_17485);
var state_17516__$1 = (function (){var statearr_17521 = state_17516;
(statearr_17521[(9)] = inst_17484__$1);

return statearr_17521;
})();
if(inst_17486){
var statearr_17522_17561 = state_17516__$1;
(statearr_17522_17561[(1)] = (5));

} else {
var statearr_17523_17562 = state_17516__$1;
(statearr_17523_17562[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17517 === (15))){
var inst_17506 = (state_17516[(2)]);
var state_17516__$1 = state_17516;
var statearr_17524_17563 = state_17516__$1;
(statearr_17524_17563[(2)] = inst_17506);

(statearr_17524_17563[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17517 === (13))){
var state_17516__$1 = state_17516;
var statearr_17525_17564 = state_17516__$1;
(statearr_17525_17564[(2)] = null);

(statearr_17525_17564[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17517 === (6))){
var inst_17481 = (state_17516[(7)]);
var inst_17502 = (inst_17481 > (0));
var state_17516__$1 = state_17516;
if(cljs.core.truth_(inst_17502)){
var statearr_17526_17565 = state_17516__$1;
(statearr_17526_17565[(1)] = (12));

} else {
var statearr_17527_17566 = state_17516__$1;
(statearr_17527_17566[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17517 === (3))){
var inst_17514 = (state_17516[(2)]);
var state_17516__$1 = state_17516;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17516__$1,inst_17514);
} else {
if((state_val_17517 === (12))){
var inst_17480 = (state_17516[(8)]);
var inst_17504 = cljs.core.vec.call(null,inst_17480);
var state_17516__$1 = state_17516;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17516__$1,(15),out,inst_17504);
} else {
if((state_val_17517 === (2))){
var state_17516__$1 = state_17516;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17516__$1,(4),ch);
} else {
if((state_val_17517 === (11))){
var inst_17496 = (state_17516[(2)]);
var inst_17497 = (new Array(n));
var inst_17480 = inst_17497;
var inst_17481 = (0);
var state_17516__$1 = (function (){var statearr_17528 = state_17516;
(statearr_17528[(7)] = inst_17481);

(statearr_17528[(8)] = inst_17480);

(statearr_17528[(10)] = inst_17496);

return statearr_17528;
})();
var statearr_17529_17567 = state_17516__$1;
(statearr_17529_17567[(2)] = null);

(statearr_17529_17567[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17517 === (9))){
var inst_17480 = (state_17516[(8)]);
var inst_17494 = cljs.core.vec.call(null,inst_17480);
var state_17516__$1 = state_17516;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17516__$1,(11),out,inst_17494);
} else {
if((state_val_17517 === (5))){
var inst_17481 = (state_17516[(7)]);
var inst_17484 = (state_17516[(9)]);
var inst_17480 = (state_17516[(8)]);
var inst_17489 = (state_17516[(11)]);
var inst_17488 = (inst_17480[inst_17481] = inst_17484);
var inst_17489__$1 = (inst_17481 + (1));
var inst_17490 = (inst_17489__$1 < n);
var state_17516__$1 = (function (){var statearr_17530 = state_17516;
(statearr_17530[(12)] = inst_17488);

(statearr_17530[(11)] = inst_17489__$1);

return statearr_17530;
})();
if(cljs.core.truth_(inst_17490)){
var statearr_17531_17568 = state_17516__$1;
(statearr_17531_17568[(1)] = (8));

} else {
var statearr_17532_17569 = state_17516__$1;
(statearr_17532_17569[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17517 === (14))){
var inst_17509 = (state_17516[(2)]);
var inst_17510 = cljs.core.async.close_BANG_.call(null,out);
var state_17516__$1 = (function (){var statearr_17534 = state_17516;
(statearr_17534[(13)] = inst_17509);

return statearr_17534;
})();
var statearr_17535_17570 = state_17516__$1;
(statearr_17535_17570[(2)] = inst_17510);

(statearr_17535_17570[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17517 === (10))){
var inst_17500 = (state_17516[(2)]);
var state_17516__$1 = state_17516;
var statearr_17538_17571 = state_17516__$1;
(statearr_17538_17571[(2)] = inst_17500);

(statearr_17538_17571[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17517 === (8))){
var inst_17480 = (state_17516[(8)]);
var inst_17489 = (state_17516[(11)]);
var tmp17533 = inst_17480;
var inst_17480__$1 = tmp17533;
var inst_17481 = inst_17489;
var state_17516__$1 = (function (){var statearr_17539 = state_17516;
(statearr_17539[(7)] = inst_17481);

(statearr_17539[(8)] = inst_17480__$1);

return statearr_17539;
})();
var statearr_17541_17572 = state_17516__$1;
(statearr_17541_17572[(2)] = null);

(statearr_17541_17572[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14355__auto___17557,out))
;
return ((function (switch__14236__auto__,c__14355__auto___17557,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_17546 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17546[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_17546[(1)] = (1));

return statearr_17546;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_17516){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_17516);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e17547){if((e17547 instanceof Object)){
var ex__14240__auto__ = e17547;
var statearr_17548_17573 = state_17516;
(statearr_17548_17573[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17516);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17547;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17574 = state_17516;
state_17516 = G__17574;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_17516){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_17516);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14355__auto___17557,out))
})();
var state__14357__auto__ = (function (){var statearr_17549 = f__14356__auto__.call(null);
(statearr_17549[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14355__auto___17557);

return statearr_17549;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14357__auto__);
});})(c__14355__auto___17557,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args17578 = [];
var len__7107__auto___17657 = arguments.length;
var i__7108__auto___17658 = (0);
while(true){
if((i__7108__auto___17658 < len__7107__auto___17657)){
args17578.push((arguments[i__7108__auto___17658]));

var G__17664 = (i__7108__auto___17658 + (1));
i__7108__auto___17658 = G__17664;
continue;
} else {
}
break;
}

var G__17582 = args17578.length;
switch (G__17582) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17578.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14355__auto___17666 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14355__auto___17666,out){
return (function (){
var f__14356__auto__ = (function (){var switch__14236__auto__ = ((function (c__14355__auto___17666,out){
return (function (state_17626){
var state_val_17627 = (state_17626[(1)]);
if((state_val_17627 === (7))){
var inst_17622 = (state_17626[(2)]);
var state_17626__$1 = state_17626;
var statearr_17628_17667 = state_17626__$1;
(statearr_17628_17667[(2)] = inst_17622);

(statearr_17628_17667[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17627 === (1))){
var inst_17585 = [];
var inst_17586 = inst_17585;
var inst_17587 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_17626__$1 = (function (){var statearr_17629 = state_17626;
(statearr_17629[(7)] = inst_17586);

(statearr_17629[(8)] = inst_17587);

return statearr_17629;
})();
var statearr_17630_17668 = state_17626__$1;
(statearr_17630_17668[(2)] = null);

(statearr_17630_17668[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17627 === (4))){
var inst_17590 = (state_17626[(9)]);
var inst_17590__$1 = (state_17626[(2)]);
var inst_17591 = (inst_17590__$1 == null);
var inst_17592 = cljs.core.not.call(null,inst_17591);
var state_17626__$1 = (function (){var statearr_17631 = state_17626;
(statearr_17631[(9)] = inst_17590__$1);

return statearr_17631;
})();
if(inst_17592){
var statearr_17632_17674 = state_17626__$1;
(statearr_17632_17674[(1)] = (5));

} else {
var statearr_17633_17675 = state_17626__$1;
(statearr_17633_17675[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17627 === (15))){
var inst_17616 = (state_17626[(2)]);
var state_17626__$1 = state_17626;
var statearr_17634_17676 = state_17626__$1;
(statearr_17634_17676[(2)] = inst_17616);

(statearr_17634_17676[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17627 === (13))){
var state_17626__$1 = state_17626;
var statearr_17635_17677 = state_17626__$1;
(statearr_17635_17677[(2)] = null);

(statearr_17635_17677[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17627 === (6))){
var inst_17586 = (state_17626[(7)]);
var inst_17611 = inst_17586.length;
var inst_17612 = (inst_17611 > (0));
var state_17626__$1 = state_17626;
if(cljs.core.truth_(inst_17612)){
var statearr_17636_17678 = state_17626__$1;
(statearr_17636_17678[(1)] = (12));

} else {
var statearr_17637_17679 = state_17626__$1;
(statearr_17637_17679[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17627 === (3))){
var inst_17624 = (state_17626[(2)]);
var state_17626__$1 = state_17626;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17626__$1,inst_17624);
} else {
if((state_val_17627 === (12))){
var inst_17586 = (state_17626[(7)]);
var inst_17614 = cljs.core.vec.call(null,inst_17586);
var state_17626__$1 = state_17626;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17626__$1,(15),out,inst_17614);
} else {
if((state_val_17627 === (2))){
var state_17626__$1 = state_17626;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17626__$1,(4),ch);
} else {
if((state_val_17627 === (11))){
var inst_17594 = (state_17626[(10)]);
var inst_17590 = (state_17626[(9)]);
var inst_17604 = (state_17626[(2)]);
var inst_17605 = [];
var inst_17606 = inst_17605.push(inst_17590);
var inst_17586 = inst_17605;
var inst_17587 = inst_17594;
var state_17626__$1 = (function (){var statearr_17638 = state_17626;
(statearr_17638[(11)] = inst_17604);

(statearr_17638[(7)] = inst_17586);

(statearr_17638[(8)] = inst_17587);

(statearr_17638[(12)] = inst_17606);

return statearr_17638;
})();
var statearr_17639_17680 = state_17626__$1;
(statearr_17639_17680[(2)] = null);

(statearr_17639_17680[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17627 === (9))){
var inst_17586 = (state_17626[(7)]);
var inst_17602 = cljs.core.vec.call(null,inst_17586);
var state_17626__$1 = state_17626;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17626__$1,(11),out,inst_17602);
} else {
if((state_val_17627 === (5))){
var inst_17594 = (state_17626[(10)]);
var inst_17587 = (state_17626[(8)]);
var inst_17590 = (state_17626[(9)]);
var inst_17594__$1 = f.call(null,inst_17590);
var inst_17595 = cljs.core._EQ_.call(null,inst_17594__$1,inst_17587);
var inst_17596 = cljs.core.keyword_identical_QMARK_.call(null,inst_17587,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_17597 = (inst_17595) || (inst_17596);
var state_17626__$1 = (function (){var statearr_17640 = state_17626;
(statearr_17640[(10)] = inst_17594__$1);

return statearr_17640;
})();
if(cljs.core.truth_(inst_17597)){
var statearr_17641_17681 = state_17626__$1;
(statearr_17641_17681[(1)] = (8));

} else {
var statearr_17642_17682 = state_17626__$1;
(statearr_17642_17682[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17627 === (14))){
var inst_17619 = (state_17626[(2)]);
var inst_17620 = cljs.core.async.close_BANG_.call(null,out);
var state_17626__$1 = (function (){var statearr_17644 = state_17626;
(statearr_17644[(13)] = inst_17619);

return statearr_17644;
})();
var statearr_17645_17684 = state_17626__$1;
(statearr_17645_17684[(2)] = inst_17620);

(statearr_17645_17684[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17627 === (10))){
var inst_17609 = (state_17626[(2)]);
var state_17626__$1 = state_17626;
var statearr_17646_17685 = state_17626__$1;
(statearr_17646_17685[(2)] = inst_17609);

(statearr_17646_17685[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17627 === (8))){
var inst_17586 = (state_17626[(7)]);
var inst_17594 = (state_17626[(10)]);
var inst_17590 = (state_17626[(9)]);
var inst_17599 = inst_17586.push(inst_17590);
var tmp17643 = inst_17586;
var inst_17586__$1 = tmp17643;
var inst_17587 = inst_17594;
var state_17626__$1 = (function (){var statearr_17647 = state_17626;
(statearr_17647[(7)] = inst_17586__$1);

(statearr_17647[(8)] = inst_17587);

(statearr_17647[(14)] = inst_17599);

return statearr_17647;
})();
var statearr_17648_17686 = state_17626__$1;
(statearr_17648_17686[(2)] = null);

(statearr_17648_17686[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14355__auto___17666,out))
;
return ((function (switch__14236__auto__,c__14355__auto___17666,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_17652 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17652[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_17652[(1)] = (1));

return statearr_17652;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_17626){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_17626);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e17653){if((e17653 instanceof Object)){
var ex__14240__auto__ = e17653;
var statearr_17654_17687 = state_17626;
(statearr_17654_17687[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17626);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17653;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17688 = state_17626;
state_17626 = G__17688;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_17626){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_17626);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14355__auto___17666,out))
})();
var state__14357__auto__ = (function (){var statearr_17655 = f__14356__auto__.call(null);
(statearr_17655[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14355__auto___17666);

return statearr_17655;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14357__auto__);
});})(c__14355__auto___17666,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map?rel=1472745563812