// Compiled by ClojureScript 1.7.228 {}
goog.provide('cubanostack.rest');
goog.require('cljs.core');
goog.require('cubanostack.components.bus');
goog.require('cljs.core.async');
goog.require('cljs_http.client');
goog.require('cubanostack.local_storage');
goog.require('com.stuartsierra.component');
goog.require('cubanostack.components.state');

/**
 * @interface
 */
cubanostack.rest.Rest = function(){};

cubanostack.rest.find_all = (function cubanostack$rest$find_all(this$){
if((!((this$ == null))) && (!((this$.cubanostack$rest$Rest$find_all$arity$1 == null)))){
return this$.cubanostack$rest$Rest$find_all$arity$1(this$);
} else {
var x__6704__auto__ = (((this$ == null))?null:this$);
var m__6705__auto__ = (cubanostack.rest.find_all[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,this$);
} else {
var m__6705__auto____$1 = (cubanostack.rest.find_all["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"Rest.find-all",this$);
}
}
}
});

cubanostack.rest.create_BANG_ = (function cubanostack$rest$create_BANG_(this$,item){
if((!((this$ == null))) && (!((this$.cubanostack$rest$Rest$create_BANG_$arity$2 == null)))){
return this$.cubanostack$rest$Rest$create_BANG_$arity$2(this$,item);
} else {
var x__6704__auto__ = (((this$ == null))?null:this$);
var m__6705__auto__ = (cubanostack.rest.create_BANG_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,this$,item);
} else {
var m__6705__auto____$1 = (cubanostack.rest.create_BANG_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,this$,item);
} else {
throw cljs.core.missing_protocol.call(null,"Rest.create!",this$);
}
}
}
});

cubanostack.rest.get_one = (function cubanostack$rest$get_one(this$,id){
if((!((this$ == null))) && (!((this$.cubanostack$rest$Rest$get_one$arity$2 == null)))){
return this$.cubanostack$rest$Rest$get_one$arity$2(this$,id);
} else {
var x__6704__auto__ = (((this$ == null))?null:this$);
var m__6705__auto__ = (cubanostack.rest.get_one[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,this$,id);
} else {
var m__6705__auto____$1 = (cubanostack.rest.get_one["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,this$,id);
} else {
throw cljs.core.missing_protocol.call(null,"Rest.get-one",this$);
}
}
}
});

cubanostack.rest.delete_BANG_ = (function cubanostack$rest$delete_BANG_(this$,id){
if((!((this$ == null))) && (!((this$.cubanostack$rest$Rest$delete_BANG_$arity$2 == null)))){
return this$.cubanostack$rest$Rest$delete_BANG_$arity$2(this$,id);
} else {
var x__6704__auto__ = (((this$ == null))?null:this$);
var m__6705__auto__ = (cubanostack.rest.delete_BANG_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,this$,id);
} else {
var m__6705__auto____$1 = (cubanostack.rest.delete_BANG_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,this$,id);
} else {
throw cljs.core.missing_protocol.call(null,"Rest.delete!",this$);
}
}
}
});

cubanostack.rest.replace_BANG_ = (function cubanostack$rest$replace_BANG_(this$,id,entity){
if((!((this$ == null))) && (!((this$.cubanostack$rest$Rest$replace_BANG_$arity$3 == null)))){
return this$.cubanostack$rest$Rest$replace_BANG_$arity$3(this$,id,entity);
} else {
var x__6704__auto__ = (((this$ == null))?null:this$);
var m__6705__auto__ = (cubanostack.rest.replace_BANG_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,this$,id,entity);
} else {
var m__6705__auto____$1 = (cubanostack.rest.replace_BANG_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,this$,id,entity);
} else {
throw cljs.core.missing_protocol.call(null,"Rest.replace!",this$);
}
}
}
});

cubanostack.rest.patch_BANG_ = (function cubanostack$rest$patch_BANG_(this$,id,entity){
if((!((this$ == null))) && (!((this$.cubanostack$rest$Rest$patch_BANG_$arity$3 == null)))){
return this$.cubanostack$rest$Rest$patch_BANG_$arity$3(this$,id,entity);
} else {
var x__6704__auto__ = (((this$ == null))?null:this$);
var m__6705__auto__ = (cubanostack.rest.patch_BANG_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,this$,id,entity);
} else {
var m__6705__auto____$1 = (cubanostack.rest.patch_BANG_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,this$,id,entity);
} else {
throw cljs.core.missing_protocol.call(null,"Rest.patch!",this$);
}
}
}
});

cubanostack.rest.make_url = (function cubanostack$rest$make_url(var_args){
var args25604 = [];
var len__7107__auto___25610 = arguments.length;
var i__7108__auto___25611 = (0);
while(true){
if((i__7108__auto___25611 < len__7107__auto___25610)){
args25604.push((arguments[i__7108__auto___25611]));

var G__25612 = (i__7108__auto___25611 + (1));
i__7108__auto___25611 = G__25612;
continue;
} else {
}
break;
}

var G__25606 = args25604.length;
switch (G__25606) {
case 1:
return cubanostack.rest.make_url.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cubanostack.rest.make_url.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25604.length)].join('')));

}
});

cubanostack.rest.make_url.cljs$core$IFn$_invoke$arity$1 = (function (Rest){
return cubanostack.rest.make_url.call(null,Rest,null);
});

cubanostack.rest.make_url.cljs$core$IFn$_invoke$arity$2 = (function (p__25607,sub_url){
var map__25608 = p__25607;
var map__25608__$1 = ((((!((map__25608 == null)))?((((map__25608.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25608.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25608):map__25608);
var protocol = cljs.core.get.call(null,map__25608__$1,new cljs.core.Keyword(null,"protocol","protocol",652470118));
var hostname = cljs.core.get.call(null,map__25608__$1,new cljs.core.Keyword(null,"hostname","hostname",2105669933));
var port = cljs.core.get.call(null,map__25608__$1,new cljs.core.Keyword(null,"port","port",1534937262));
var url = cljs.core.get.call(null,map__25608__$1,new cljs.core.Keyword(null,"url","url",276297046));
return [cljs.core.str(protocol),cljs.core.str("//"),cljs.core.str(hostname),cljs.core.str((cljs.core.truth_(port)?":":null)),cljs.core.str(port),cljs.core.str("/"),cljs.core.str(url),cljs.core.str(sub_url)].join('');
});

cubanostack.rest.make_url.cljs$lang$maxFixedArity = 2;
cubanostack.rest._ask_for_auth = (function cubanostack$rest$_ask_for_auth(status,Bus){
var G__25626_25628 = Bus;
cubanostack.components.bus.send_BANG_.call(null,G__25626_25628,new cljs.core.Keyword("notification","add","notification/add",-797397960),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"content","content",15833224),(function (){var G__25627 = status;
switch (G__25627) {
case (401):
return "Server is asking for authentication!";

break;
case (403):
return "No enough permission!";

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(status)].join('')));

}
})()], null));

cubanostack.components.bus.send_BANG_.call(null,G__25626_25628,new cljs.core.Keyword(null,"route!","route!",-1286958144),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"handler","handler",-195596612),new cljs.core.Keyword("user","login","user/login",51503538)], null));


return null;
});
cubanostack.rest._request = (function cubanostack$rest$_request(var_args){
var args25633 = [];
var len__7107__auto___25726 = arguments.length;
var i__7108__auto___25727 = (0);
while(true){
if((i__7108__auto___25727 < len__7107__auto___25726)){
args25633.push((arguments[i__7108__auto___25727]));

var G__25731 = (i__7108__auto___25727 + (1));
i__7108__auto___25727 = G__25731;
continue;
} else {
}
break;
}

var G__25635 = args25633.length;
switch (G__25635) {
case 3:
return cubanostack.rest._request.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cubanostack.rest._request.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25633.length)].join('')));

}
});

cubanostack.rest._request.cljs$core$IFn$_invoke$arity$3 = (function (url,Bus,State){
return cubanostack.rest._request.call(null,url,Bus,State,null);
});

cubanostack.rest._request.cljs$core$IFn$_invoke$arity$4 = (function (url,Bus,State,req){
var c__14355__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14355__auto__){
return (function (){
var f__14356__auto__ = (function (){var switch__14236__auto__ = ((function (c__14355__auto__){
return (function (state_25681){
var state_val_25682 = (state_25681[(1)]);
if((state_val_25682 === (7))){
var state_25681__$1 = state_25681;
var statearr_25683_25737 = state_25681__$1;
(statearr_25683_25737[(2)] = false);

(statearr_25683_25737[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25682 === (1))){
var inst_25637 = cubanostack.local_storage.get_item_from_local_storage.call(null,new cljs.core.Keyword(null,"current-user","current-user",-868792091));
var inst_25638 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(inst_25637);
var inst_25639 = [new cljs.core.Keyword(null,"oauth-token","oauth-token",311415191)];
var inst_25640 = [inst_25638];
var inst_25641 = cljs.core.PersistentHashMap.fromArrays(inst_25639,inst_25640);
var inst_25642 = [new cljs.core.Keyword(null,"url","url",276297046)];
var inst_25643 = [url];
var inst_25644 = cljs.core.PersistentHashMap.fromArrays(inst_25642,inst_25643);
var inst_25645 = cljs.core.merge.call(null,inst_25641,req,inst_25644);
var inst_25646 = cljs_http.client.request.call(null,inst_25645);
var state_25681__$1 = state_25681;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25681__$1,(2),inst_25646);
} else {
if((state_val_25682 === (4))){
var state_25681__$1 = state_25681;
var statearr_25684_25779 = state_25681__$1;
(statearr_25684_25779[(2)] = false);

(statearr_25684_25779[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25682 === (15))){
var inst_25669 = (state_25681[(7)]);
var inst_25673 = cubanostack.rest._ask_for_auth.call(null,inst_25669,Bus);
var state_25681__$1 = state_25681;
var statearr_25685_25782 = state_25681__$1;
(statearr_25685_25782[(2)] = inst_25673);

(statearr_25685_25782[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25682 === (13))){
var inst_25670 = (state_25681[(8)]);
var state_25681__$1 = state_25681;
var statearr_25686_25814 = state_25681__$1;
(statearr_25686_25814[(2)] = inst_25670);

(statearr_25686_25814[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25682 === (6))){
var state_25681__$1 = state_25681;
var statearr_25687_25818 = state_25681__$1;
(statearr_25687_25818[(2)] = true);

(statearr_25687_25818[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25682 === (17))){
var state_25681__$1 = state_25681;
var statearr_25688_25829 = state_25681__$1;
(statearr_25688_25829[(2)] = null);

(statearr_25688_25829[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25682 === (3))){
var inst_25648 = (state_25681[(9)]);
var inst_25653 = inst_25648.cljs$lang$protocol_mask$partition0$;
var inst_25654 = (inst_25653 & (64));
var inst_25655 = inst_25648.cljs$core$ISeq$;
var inst_25656 = (inst_25654) || (inst_25655);
var state_25681__$1 = state_25681;
if(cljs.core.truth_(inst_25656)){
var statearr_25689_25837 = state_25681__$1;
(statearr_25689_25837[(1)] = (6));

} else {
var statearr_25690_25839 = state_25681__$1;
(statearr_25690_25839[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25682 === (12))){
var inst_25679 = (state_25681[(2)]);
var state_25681__$1 = state_25681;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25681__$1,inst_25679);
} else {
if((state_val_25682 === (2))){
var inst_25648 = (state_25681[(9)]);
var inst_25648__$1 = (state_25681[(2)]);
var inst_25650 = (inst_25648__$1 == null);
var inst_25651 = cljs.core.not.call(null,inst_25650);
var state_25681__$1 = (function (){var statearr_25693 = state_25681;
(statearr_25693[(9)] = inst_25648__$1);

return statearr_25693;
})();
if(inst_25651){
var statearr_25694_25842 = state_25681__$1;
(statearr_25694_25842[(1)] = (3));

} else {
var statearr_25695_25843 = state_25681__$1;
(statearr_25695_25843[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25682 === (11))){
var inst_25669 = (state_25681[(7)]);
var inst_25668 = (state_25681[(2)]);
var inst_25669__$1 = cljs.core.get.call(null,inst_25668,new cljs.core.Keyword(null,"status","status",-1997798413));
var inst_25670 = cljs.core.get.call(null,inst_25668,new cljs.core.Keyword(null,"body","body",-2049205669));
var state_25681__$1 = (function (){var statearr_25698 = state_25681;
(statearr_25698[(7)] = inst_25669__$1);

(statearr_25698[(8)] = inst_25670);

return statearr_25698;
})();
var G__25699_25844 = inst_25669__$1;
switch (G__25699_25844) {
case (200):
var statearr_25700_25846 = state_25681__$1;
(statearr_25700_25846[(1)] = (13));


break;
case (201):
var statearr_25701_25851 = state_25681__$1;
(statearr_25701_25851[(1)] = (14));


break;
case (401):
var statearr_25702_25852 = state_25681__$1;
(statearr_25702_25852[(1)] = (15));


break;
case (403):
var statearr_25703_25853 = state_25681__$1;
(statearr_25703_25853[(1)] = (16));


break;
default:
var statearr_25704_25856 = state_25681__$1;
(statearr_25704_25856[(1)] = (17));



}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25682 === (9))){
var inst_25648 = (state_25681[(9)]);
var inst_25665 = cljs.core.apply.call(null,cljs.core.hash_map,inst_25648);
var state_25681__$1 = state_25681;
var statearr_25705_25863 = state_25681__$1;
(statearr_25705_25863[(2)] = inst_25665);

(statearr_25705_25863[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25682 === (5))){
var inst_25663 = (state_25681[(2)]);
var state_25681__$1 = state_25681;
if(cljs.core.truth_(inst_25663)){
var statearr_25706_25864 = state_25681__$1;
(statearr_25706_25864[(1)] = (9));

} else {
var statearr_25707_25868 = state_25681__$1;
(statearr_25707_25868[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25682 === (14))){
var inst_25670 = (state_25681[(8)]);
var state_25681__$1 = state_25681;
var statearr_25708_25872 = state_25681__$1;
(statearr_25708_25872[(2)] = inst_25670);

(statearr_25708_25872[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25682 === (16))){
var inst_25669 = (state_25681[(7)]);
var inst_25675 = cubanostack.rest._ask_for_auth.call(null,inst_25669,Bus);
var state_25681__$1 = state_25681;
var statearr_25709_25874 = state_25681__$1;
(statearr_25709_25874[(2)] = inst_25675);

(statearr_25709_25874[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25682 === (10))){
var inst_25648 = (state_25681[(9)]);
var state_25681__$1 = state_25681;
var statearr_25710_25879 = state_25681__$1;
(statearr_25710_25879[(2)] = inst_25648);

(statearr_25710_25879[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25682 === (8))){
var inst_25660 = (state_25681[(2)]);
var state_25681__$1 = state_25681;
var statearr_25711_25880 = state_25681__$1;
(statearr_25711_25880[(2)] = inst_25660);

(statearr_25711_25880[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14355__auto__))
;
return ((function (switch__14236__auto__,c__14355__auto__){
return (function() {
var cubanostack$rest$state_machine__14237__auto__ = null;
var cubanostack$rest$state_machine__14237__auto____0 = (function (){
var statearr_25720 = [null,null,null,null,null,null,null,null,null,null];
(statearr_25720[(0)] = cubanostack$rest$state_machine__14237__auto__);

(statearr_25720[(1)] = (1));

return statearr_25720;
});
var cubanostack$rest$state_machine__14237__auto____1 = (function (state_25681){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_25681);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e25721){if((e25721 instanceof Object)){
var ex__14240__auto__ = e25721;
var statearr_25722_25885 = state_25681;
(statearr_25722_25885[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25681);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25721;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25887 = state_25681;
state_25681 = G__25887;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cubanostack$rest$state_machine__14237__auto__ = function(state_25681){
switch(arguments.length){
case 0:
return cubanostack$rest$state_machine__14237__auto____0.call(this);
case 1:
return cubanostack$rest$state_machine__14237__auto____1.call(this,state_25681);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cubanostack$rest$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cubanostack$rest$state_machine__14237__auto____0;
cubanostack$rest$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cubanostack$rest$state_machine__14237__auto____1;
return cubanostack$rest$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14355__auto__))
})();
var state__14357__auto__ = (function (){var statearr_25724 = f__14356__auto__.call(null);
(statearr_25724[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14355__auto__);

return statearr_25724;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14357__auto__);
});})(c__14355__auto__))
);

return c__14355__auto__;
});

cubanostack.rest._request.cljs$lang$maxFixedArity = 4;

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cubanostack.rest.Rest}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {com.stuartsierra.component.Lifecycle}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cubanostack.rest.Rest_STAR_ = (function (url,protocol,hostname,port,Bus,State,__meta,__extmap,__hash){
this.url = url;
this.protocol = protocol;
this.hostname = hostname;
this.port = port;
this.Bus = Bus;
this.State = State;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cubanostack.rest.Rest_STAR_.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__6663__auto__,k__6664__auto__){
var self__ = this;
var this__6663__auto____$1 = this;
return cljs.core._lookup.call(null,this__6663__auto____$1,k__6664__auto__,null);
});

cubanostack.rest.Rest_STAR_.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__6665__auto__,k25891,else__6666__auto__){
var self__ = this;
var this__6665__auto____$1 = this;
var G__25897 = (((k25891 instanceof cljs.core.Keyword))?k25891.fqn:null);
switch (G__25897) {
case "url":
return self__.url;

break;
case "protocol":
return self__.protocol;

break;
case "hostname":
return self__.hostname;

break;
case "port":
return self__.port;

break;
case "Bus":
return self__.Bus;

break;
case "State":
return self__.State;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k25891,else__6666__auto__);

}
});

cubanostack.rest.Rest_STAR_.prototype.com$stuartsierra$component$Lifecycle$ = true;

cubanostack.rest.Rest_STAR_.prototype.com$stuartsierra$component$Lifecycle$start$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cubanostack.rest.Rest_STAR_.prototype.com$stuartsierra$component$Lifecycle$stop$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cubanostack.rest.Rest_STAR_.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__6677__auto__,writer__6678__auto__,opts__6679__auto__){
var self__ = this;
var this__6677__auto____$1 = this;
var pr_pair__6680__auto__ = ((function (this__6677__auto____$1){
return (function (keyval__6681__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__6678__auto__,cljs.core.pr_writer,""," ","",opts__6679__auto__,keyval__6681__auto__);
});})(this__6677__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__6678__auto__,pr_pair__6680__auto__,"#cubanostack.rest.Rest*{",", ","}",opts__6679__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"url","url",276297046),self__.url],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"protocol","protocol",652470118),self__.protocol],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"hostname","hostname",2105669933),self__.hostname],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"port","port",1534937262),self__.port],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"Bus","Bus",-129151867),self__.Bus],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"State","State",-152966343),self__.State],null))], null),self__.__extmap));
});

cubanostack.rest.Rest_STAR_.prototype.cljs$core$IIterable$ = true;

cubanostack.rest.Rest_STAR_.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__25890){
var self__ = this;
var G__25890__$1 = this;
return (new cljs.core.RecordIter((0),G__25890__$1,6,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"url","url",276297046),new cljs.core.Keyword(null,"protocol","protocol",652470118),new cljs.core.Keyword(null,"hostname","hostname",2105669933),new cljs.core.Keyword(null,"port","port",1534937262),new cljs.core.Keyword(null,"Bus","Bus",-129151867),new cljs.core.Keyword(null,"State","State",-152966343)], null),cljs.core._iterator.call(null,self__.__extmap)));
});

cubanostack.rest.Rest_STAR_.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__6661__auto__){
var self__ = this;
var this__6661__auto____$1 = this;
return self__.__meta;
});

cubanostack.rest.Rest_STAR_.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__6657__auto__){
var self__ = this;
var this__6657__auto____$1 = this;
return (new cubanostack.rest.Rest_STAR_(self__.url,self__.protocol,self__.hostname,self__.port,self__.Bus,self__.State,self__.__meta,self__.__extmap,self__.__hash));
});

cubanostack.rest.Rest_STAR_.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__6667__auto__){
var self__ = this;
var this__6667__auto____$1 = this;
return (6 + cljs.core.count.call(null,self__.__extmap));
});

cubanostack.rest.Rest_STAR_.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__6658__auto__){
var self__ = this;
var this__6658__auto____$1 = this;
var h__6484__auto__ = self__.__hash;
if(!((h__6484__auto__ == null))){
return h__6484__auto__;
} else {
var h__6484__auto____$1 = cljs.core.hash_imap.call(null,this__6658__auto____$1);
self__.__hash = h__6484__auto____$1;

return h__6484__auto____$1;
}
});

cubanostack.rest.Rest_STAR_.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__6659__auto__,other__6660__auto__){
var self__ = this;
var this__6659__auto____$1 = this;
if(cljs.core.truth_((function (){var and__6037__auto__ = other__6660__auto__;
if(cljs.core.truth_(and__6037__auto__)){
var and__6037__auto____$1 = (this__6659__auto____$1.constructor === other__6660__auto__.constructor);
if(and__6037__auto____$1){
return cljs.core.equiv_map.call(null,this__6659__auto____$1,other__6660__auto__);
} else {
return and__6037__auto____$1;
}
} else {
return and__6037__auto__;
}
})())){
return true;
} else {
return false;
}
});

cubanostack.rest.Rest_STAR_.prototype.cubanostack$rest$Rest$ = true;

cubanostack.rest.Rest_STAR_.prototype.cubanostack$rest$Rest$find_all$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cubanostack.rest._request.call(null,cubanostack.rest.make_url.call(null,this$__$1),self__.Bus,self__.State);
});

cubanostack.rest.Rest_STAR_.prototype.cubanostack$rest$Rest$create_BANG_$arity$2 = (function (this$,entity){
var self__ = this;
var this$__$1 = this;
return cubanostack.rest._request.call(null,cubanostack.rest.make_url.call(null,this$__$1),self__.Bus,self__.State,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"json-params","json-params",-1112693596),entity], null));
});

cubanostack.rest.Rest_STAR_.prototype.cubanostack$rest$Rest$get_one$arity$2 = (function (this$,id){
var self__ = this;
var this$__$1 = this;
return cubanostack.rest._request.call(null,cubanostack.rest.make_url.call(null,this$__$1,id),self__.Bus,self__.State);
});

cubanostack.rest.Rest_STAR_.prototype.cubanostack$rest$Rest$delete_BANG_$arity$2 = (function (this$,id){
var self__ = this;
var this$__$1 = this;
return cubanostack.rest._request.call(null,cubanostack.rest.make_url.call(null,this$__$1,id),self__.Bus,self__.State,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"delete","delete",-1768633620)], null));
});

cubanostack.rest.Rest_STAR_.prototype.cubanostack$rest$Rest$replace_BANG_$arity$3 = (function (this$,id,entity){
var self__ = this;
var this$__$1 = this;
return cubanostack.rest._request.call(null,cubanostack.rest.make_url.call(null,this$__$1,id),self__.Bus,self__.State,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"put","put",1299772570),new cljs.core.Keyword(null,"json-params","json-params",-1112693596),entity], null));
});

cubanostack.rest.Rest_STAR_.prototype.cubanostack$rest$Rest$patch_BANG_$arity$3 = (function (this$,id,entity){
var self__ = this;
var this$__$1 = this;
return cubanostack.rest._request.call(null,cubanostack.rest.make_url.call(null,this$__$1,id),self__.Bus,self__.State,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"patch","patch",380775109),new cljs.core.Keyword(null,"json-params","json-params",-1112693596),entity], null));
});

cubanostack.rest.Rest_STAR_.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__6672__auto__,k__6673__auto__){
var self__ = this;
var this__6672__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"Bus","Bus",-129151867),null,new cljs.core.Keyword(null,"protocol","protocol",652470118),null,new cljs.core.Keyword(null,"hostname","hostname",2105669933),null,new cljs.core.Keyword(null,"port","port",1534937262),null,new cljs.core.Keyword(null,"url","url",276297046),null,new cljs.core.Keyword(null,"State","State",-152966343),null], null), null),k__6673__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__6672__auto____$1),self__.__meta),k__6673__auto__);
} else {
return (new cubanostack.rest.Rest_STAR_(self__.url,self__.protocol,self__.hostname,self__.port,self__.Bus,self__.State,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__6673__auto__)),null));
}
});

cubanostack.rest.Rest_STAR_.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__6670__auto__,k__6671__auto__,G__25890){
var self__ = this;
var this__6670__auto____$1 = this;
var pred__25899 = cljs.core.keyword_identical_QMARK_;
var expr__25900 = k__6671__auto__;
if(cljs.core.truth_(pred__25899.call(null,new cljs.core.Keyword(null,"url","url",276297046),expr__25900))){
return (new cubanostack.rest.Rest_STAR_(G__25890,self__.protocol,self__.hostname,self__.port,self__.Bus,self__.State,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__25899.call(null,new cljs.core.Keyword(null,"protocol","protocol",652470118),expr__25900))){
return (new cubanostack.rest.Rest_STAR_(self__.url,G__25890,self__.hostname,self__.port,self__.Bus,self__.State,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__25899.call(null,new cljs.core.Keyword(null,"hostname","hostname",2105669933),expr__25900))){
return (new cubanostack.rest.Rest_STAR_(self__.url,self__.protocol,G__25890,self__.port,self__.Bus,self__.State,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__25899.call(null,new cljs.core.Keyword(null,"port","port",1534937262),expr__25900))){
return (new cubanostack.rest.Rest_STAR_(self__.url,self__.protocol,self__.hostname,G__25890,self__.Bus,self__.State,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__25899.call(null,new cljs.core.Keyword(null,"Bus","Bus",-129151867),expr__25900))){
return (new cubanostack.rest.Rest_STAR_(self__.url,self__.protocol,self__.hostname,self__.port,G__25890,self__.State,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__25899.call(null,new cljs.core.Keyword(null,"State","State",-152966343),expr__25900))){
return (new cubanostack.rest.Rest_STAR_(self__.url,self__.protocol,self__.hostname,self__.port,self__.Bus,G__25890,self__.__meta,self__.__extmap,null));
} else {
return (new cubanostack.rest.Rest_STAR_(self__.url,self__.protocol,self__.hostname,self__.port,self__.Bus,self__.State,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__6671__auto__,G__25890),null));
}
}
}
}
}
}
});

cubanostack.rest.Rest_STAR_.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__6675__auto__){
var self__ = this;
var this__6675__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"url","url",276297046),self__.url],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"protocol","protocol",652470118),self__.protocol],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"hostname","hostname",2105669933),self__.hostname],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"port","port",1534937262),self__.port],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"Bus","Bus",-129151867),self__.Bus],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"State","State",-152966343),self__.State],null))], null),self__.__extmap));
});

cubanostack.rest.Rest_STAR_.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__6662__auto__,G__25890){
var self__ = this;
var this__6662__auto____$1 = this;
return (new cubanostack.rest.Rest_STAR_(self__.url,self__.protocol,self__.hostname,self__.port,self__.Bus,self__.State,G__25890,self__.__extmap,self__.__hash));
});

cubanostack.rest.Rest_STAR_.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__6668__auto__,entry__6669__auto__){
var self__ = this;
var this__6668__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__6669__auto__)){
return cljs.core._assoc.call(null,this__6668__auto____$1,cljs.core._nth.call(null,entry__6669__auto__,(0)),cljs.core._nth.call(null,entry__6669__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__6668__auto____$1,entry__6669__auto__);
}
});

cubanostack.rest.Rest_STAR_.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"url","url",1916828573,null),new cljs.core.Symbol(null,"protocol","protocol",-2001965651,null),new cljs.core.Symbol(null,"hostname","hostname",-548765836,null),new cljs.core.Symbol(null,"port","port",-1119498507,null),new cljs.core.Symbol(null,"Bus","Bus",1511379660,null),new cljs.core.Symbol(null,"State","State",1487565184,null)], null);
});

cubanostack.rest.Rest_STAR_.cljs$lang$type = true;

cubanostack.rest.Rest_STAR_.cljs$lang$ctorPrSeq = (function (this__6697__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"cubanostack.rest/Rest*");
});

cubanostack.rest.Rest_STAR_.cljs$lang$ctorPrWriter = (function (this__6697__auto__,writer__6698__auto__){
return cljs.core._write.call(null,writer__6698__auto__,"cubanostack.rest/Rest*");
});

cubanostack.rest.__GT_Rest_STAR_ = (function cubanostack$rest$__GT_Rest_STAR_(url,protocol,hostname,port,Bus,State){
return (new cubanostack.rest.Rest_STAR_(url,protocol,hostname,port,Bus,State,null,null,null));
});

cubanostack.rest.map__GT_Rest_STAR_ = (function cubanostack$rest$map__GT_Rest_STAR_(G__25892){
return (new cubanostack.rest.Rest_STAR_(new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(G__25892),new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(G__25892),new cljs.core.Keyword(null,"hostname","hostname",2105669933).cljs$core$IFn$_invoke$arity$1(G__25892),new cljs.core.Keyword(null,"port","port",1534937262).cljs$core$IFn$_invoke$arity$1(G__25892),new cljs.core.Keyword(null,"Bus","Bus",-129151867).cljs$core$IFn$_invoke$arity$1(G__25892),new cljs.core.Keyword(null,"State","State",-152966343).cljs$core$IFn$_invoke$arity$1(G__25892),null,cljs.core.dissoc.call(null,G__25892,new cljs.core.Keyword(null,"url","url",276297046),new cljs.core.Keyword(null,"protocol","protocol",652470118),new cljs.core.Keyword(null,"hostname","hostname",2105669933),new cljs.core.Keyword(null,"port","port",1534937262),new cljs.core.Keyword(null,"Bus","Bus",-129151867),new cljs.core.Keyword(null,"State","State",-152966343)),null));
});

cubanostack.rest.new_rest = (function cubanostack$rest$new_rest(params){
return cubanostack.rest.map__GT_Rest_STAR_.call(null,cljs.core.merge.call(null,(function (){var location = (window["location"]);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"protocol","protocol",652470118),(location["protocol"]),new cljs.core.Keyword(null,"port","port",1534937262),(function (){var port = (location["port"]);
if(cljs.core._EQ_.call(null,"",port)){
return null;
} else {
return port;
}
})(),new cljs.core.Keyword(null,"hostname","hostname",2105669933),(location["hostname"])], null);
})(),params));
});

//# sourceMappingURL=rest.js.map?rel=1472745569166