// Compiled by ClojureScript 1.7.228 {}
goog.provide('cubanostack.wrapper.core');
goog.require('cljs.core');

/**
 * A protocol to easily/modularly extends functionnalities using wrappers.
 * 
 *   Usage:
 *   (deftype TimeCommandWrapper
 * Wrapper
 * (before [this payload]
 *  (merge payload
 *         {::start-time (System/nanoTime)}))
 * 
 * (after [this response payload]
 *  (assoc response
 *         :elapsed (- (System/nanoTime)
 *                     (::start-time payload)))))
 * 
 *   (def wrapped-command [cmd]
 *  (wrap-with cmd
 *    (TimeCommandWrapper.)))
 * @interface
 */
cubanostack.wrapper.core.Wrapper = function(){};

/**
 * The before method will be called before delegating to wrapped handlers.
 *  It returns the [optionnaly instrumentized] payload.
 */
cubanostack.wrapper.core.before = (function cubanostack$wrapper$core$before(this$,payload){
if((!((this$ == null))) && (!((this$.cubanostack$wrapper$core$Wrapper$before$arity$2 == null)))){
return this$.cubanostack$wrapper$core$Wrapper$before$arity$2(this$,payload);
} else {
var x__6704__auto__ = (((this$ == null))?null:this$);
var m__6705__auto__ = (cubanostack.wrapper.core.before[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,this$,payload);
} else {
var m__6705__auto____$1 = (cubanostack.wrapper.core.before["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,this$,payload);
} else {
throw cljs.core.missing_protocol.call(null,"Wrapper.before",this$);
}
}
}
});

/**
 * The after medthod is called after delegating to wrapped handlers.
 *  It returns the [optionnaly instrumentized] response.
 *  The payload parameter is the payload as instrumentized by this Wrapper
 *  (can be useful for keeping track of 'local vars').
 */
cubanostack.wrapper.core.after = (function cubanostack$wrapper$core$after(this$,response,payload){
if((!((this$ == null))) && (!((this$.cubanostack$wrapper$core$Wrapper$after$arity$3 == null)))){
return this$.cubanostack$wrapper$core$Wrapper$after$arity$3(this$,response,payload);
} else {
var x__6704__auto__ = (((this$ == null))?null:this$);
var m__6705__auto__ = (cubanostack.wrapper.core.after[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,this$,response,payload);
} else {
var m__6705__auto____$1 = (cubanostack.wrapper.core.after["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,this$,response,payload);
} else {
throw cljs.core.missing_protocol.call(null,"Wrapper.after",this$);
}
}
}
});

/**
 * Wraps a function around some wrappers/decorators.
 *   Each of the all-decorators must instanciate the Wrapper protocol.
 * 
 *   Usage:
 * 
 *   (defn command [param]
 *  [..])
 * 
 *   (def wrapped-command
 *  (wrap-with command
 *    (Wrapper1.)
 *    (Wrapper2. :with :args)
 *    [..]))
 * 
 *   (wrapped-command :arg)
 */
cubanostack.wrapper.core.wrap_with = (function cubanostack$wrapper$core$wrap_with(var_args){
var args__7114__auto__ = [];
var len__7107__auto___10182 = arguments.length;
var i__7108__auto___10183 = (0);
while(true){
if((i__7108__auto___10183 < len__7107__auto___10182)){
args__7114__auto__.push((arguments[i__7108__auto___10183]));

var G__10186 = (i__7108__auto___10183 + (1));
i__7108__auto___10183 = G__10186;
continue;
} else {
}
break;
}

var argseq__7115__auto__ = ((((1) < args__7114__auto__.length))?(new cljs.core.IndexedSeq(args__7114__auto__.slice((1)),(0))):null);
return cubanostack.wrapper.core.wrap_with.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7115__auto__);
});

cubanostack.wrapper.core.wrap_with.cljs$core$IFn$_invoke$arity$variadic = (function (handler,all_decorators){
return cljs.core.reduce.call(null,(function (handler__$1,wrapper){
return (function (payload){
try{var instrumentized_payload = cubanostack.wrapper.core.before.call(null,wrapper,payload);
return cubanostack.wrapper.core.after.call(null,wrapper,handler__$1.call(null,instrumentized_payload),instrumentized_payload);
}catch (e10179){var map__10180 = e10179;
var map__10180__$1 = ((((!((map__10180 == null)))?((((map__10180.cljs$lang$protocol_mask$partition0$ & (64))) || (map__10180.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__10180):map__10180);
var body = cljs.core.get.call(null,map__10180__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
return cubanostack.wrapper.core.after.call(null,wrapper,body,null);
}});
}),handler,all_decorators);
});

cubanostack.wrapper.core.wrap_with.cljs$lang$maxFixedArity = (1);

cubanostack.wrapper.core.wrap_with.cljs$lang$applyTo = (function (seq10172){
var G__10173 = cljs.core.first.call(null,seq10172);
var seq10172__$1 = cljs.core.next.call(null,seq10172);
return cubanostack.wrapper.core.wrap_with.cljs$core$IFn$_invoke$arity$variadic(G__10173,seq10172__$1);
});
cubanostack.wrapper.core.handler = (function cubanostack$wrapper$core$handler(f){
if(typeof cubanostack.wrapper.core.t_cubanostack$wrapper$core10223 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cubanostack.wrapper.core.Wrapper}
 * @implements {cljs.core.IWithMeta}
*/
cubanostack.wrapper.core.t_cubanostack$wrapper$core10223 = (function (handler,f,meta10224){
this.handler = handler;
this.f = f;
this.meta10224 = meta10224;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cubanostack.wrapper.core.t_cubanostack$wrapper$core10223.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_10225,meta10224__$1){
var self__ = this;
var _10225__$1 = this;
return (new cubanostack.wrapper.core.t_cubanostack$wrapper$core10223(self__.handler,self__.f,meta10224__$1));
});

cubanostack.wrapper.core.t_cubanostack$wrapper$core10223.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_10225){
var self__ = this;
var _10225__$1 = this;
return self__.meta10224;
});

cubanostack.wrapper.core.t_cubanostack$wrapper$core10223.prototype.cubanostack$wrapper$core$Wrapper$ = true;

cubanostack.wrapper.core.t_cubanostack$wrapper$core10223.prototype.cubanostack$wrapper$core$Wrapper$before$arity$2 = (function (this$,payload){
var self__ = this;
var this$__$1 = this;
var result = self__.f.call(null,payload);
if(cljs.core.truth_(result)){
throw new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"body","body",-2049205669),result], null);
} else {
return payload;
}
});

cubanostack.wrapper.core.t_cubanostack$wrapper$core10223.prototype.cubanostack$wrapper$core$Wrapper$after$arity$3 = (function (this$,response,payload){
var self__ = this;
var this$__$1 = this;
return response;
});

cubanostack.wrapper.core.t_cubanostack$wrapper$core10223.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"handler","handler",1444934915,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null)))], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"meta10224","meta10224",808126219,null)], null);
});

cubanostack.wrapper.core.t_cubanostack$wrapper$core10223.cljs$lang$type = true;

cubanostack.wrapper.core.t_cubanostack$wrapper$core10223.cljs$lang$ctorStr = "cubanostack.wrapper.core/t_cubanostack$wrapper$core10223";

cubanostack.wrapper.core.t_cubanostack$wrapper$core10223.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cubanostack.wrapper.core/t_cubanostack$wrapper$core10223");
});

cubanostack.wrapper.core.__GT_t_cubanostack$wrapper$core10223 = (function cubanostack$wrapper$core$handler_$___GT_t_cubanostack$wrapper$core10223(handler__$1,f__$1,meta10224){
return (new cubanostack.wrapper.core.t_cubanostack$wrapper$core10223(handler__$1,f__$1,meta10224));
});

}

return (new cubanostack.wrapper.core.t_cubanostack$wrapper$core10223(cubanostack$wrapper$core$handler,f,cljs.core.PersistentArrayMap.EMPTY));
});

//# sourceMappingURL=core.js.map?rel=1472745555472