// Compiled by ClojureScript 1.7.228 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args14423 = [];
var len__7107__auto___14433 = arguments.length;
var i__7108__auto___14434 = (0);
while(true){
if((i__7108__auto___14434 < len__7107__auto___14433)){
args14423.push((arguments[i__7108__auto___14434]));

var G__14435 = (i__7108__auto___14434 + (1));
i__7108__auto___14434 = G__14435;
continue;
} else {
}
break;
}

var G__14425 = args14423.length;
switch (G__14425) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14423.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async14426 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14426 = (function (f,blockable,meta14427){
this.f = f;
this.blockable = blockable;
this.meta14427 = meta14427;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14426.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14428,meta14427__$1){
var self__ = this;
var _14428__$1 = this;
return (new cljs.core.async.t_cljs$core$async14426(self__.f,self__.blockable,meta14427__$1));
});

cljs.core.async.t_cljs$core$async14426.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14428){
var self__ = this;
var _14428__$1 = this;
return self__.meta14427;
});

cljs.core.async.t_cljs$core$async14426.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async14426.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async14426.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async14426.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async14426.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta14427","meta14427",-969928677,null)], null);
});

cljs.core.async.t_cljs$core$async14426.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14426.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14426";

cljs.core.async.t_cljs$core$async14426.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async14426");
});

cljs.core.async.__GT_t_cljs$core$async14426 = (function cljs$core$async$__GT_t_cljs$core$async14426(f__$1,blockable__$1,meta14427){
return (new cljs.core.async.t_cljs$core$async14426(f__$1,blockable__$1,meta14427));
});

}

return (new cljs.core.async.t_cljs$core$async14426(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args14450 = [];
var len__7107__auto___14457 = arguments.length;
var i__7108__auto___14459 = (0);
while(true){
if((i__7108__auto___14459 < len__7107__auto___14457)){
args14450.push((arguments[i__7108__auto___14459]));

var G__14461 = (i__7108__auto___14459 + (1));
i__7108__auto___14459 = G__14461;
continue;
} else {
}
break;
}

var G__14456 = args14450.length;
switch (G__14456) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14450.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args14464 = [];
var len__7107__auto___14472 = arguments.length;
var i__7108__auto___14473 = (0);
while(true){
if((i__7108__auto___14473 < len__7107__auto___14472)){
args14464.push((arguments[i__7108__auto___14473]));

var G__14474 = (i__7108__auto___14473 + (1));
i__7108__auto___14473 = G__14474;
continue;
} else {
}
break;
}

var G__14470 = args14464.length;
switch (G__14470) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14464.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args14477 = [];
var len__7107__auto___14486 = arguments.length;
var i__7108__auto___14487 = (0);
while(true){
if((i__7108__auto___14487 < len__7107__auto___14486)){
args14477.push((arguments[i__7108__auto___14487]));

var G__14488 = (i__7108__auto___14487 + (1));
i__7108__auto___14487 = G__14488;
continue;
} else {
}
break;
}

var G__14482 = args14477.length;
switch (G__14482) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14477.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_14490 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_14490);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_14490,ret){
return (function (){
return fn1.call(null,val_14490);
});})(val_14490,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args14492 = [];
var len__7107__auto___14495 = arguments.length;
var i__7108__auto___14496 = (0);
while(true){
if((i__7108__auto___14496 < len__7107__auto___14495)){
args14492.push((arguments[i__7108__auto___14496]));

var G__14497 = (i__7108__auto___14496 + (1));
i__7108__auto___14496 = G__14497;
continue;
} else {
}
break;
}

var G__14494 = args14492.length;
switch (G__14494) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14492.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__6952__auto___14499 = n;
var x_14500 = (0);
while(true){
if((x_14500 < n__6952__auto___14499)){
(a[x_14500] = (0));

var G__14503 = (x_14500 + (1));
x_14500 = G__14503;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__14505 = (i + (1));
i = G__14505;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async14512 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14512 = (function (alt_flag,flag,meta14513){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta14513 = meta14513;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14512.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_14514,meta14513__$1){
var self__ = this;
var _14514__$1 = this;
return (new cljs.core.async.t_cljs$core$async14512(self__.alt_flag,self__.flag,meta14513__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async14512.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_14514){
var self__ = this;
var _14514__$1 = this;
return self__.meta14513;
});})(flag))
;

cljs.core.async.t_cljs$core$async14512.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async14512.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async14512.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async14512.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async14512.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta14513","meta14513",-446486442,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async14512.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14512.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14512";

cljs.core.async.t_cljs$core$async14512.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async14512");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async14512 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async14512(alt_flag__$1,flag__$1,meta14513){
return (new cljs.core.async.t_cljs$core$async14512(alt_flag__$1,flag__$1,meta14513));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async14512(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async14524 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14524 = (function (alt_handler,flag,cb,meta14525){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta14525 = meta14525;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14524.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14526,meta14525__$1){
var self__ = this;
var _14526__$1 = this;
return (new cljs.core.async.t_cljs$core$async14524(self__.alt_handler,self__.flag,self__.cb,meta14525__$1));
});

cljs.core.async.t_cljs$core$async14524.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14526){
var self__ = this;
var _14526__$1 = this;
return self__.meta14525;
});

cljs.core.async.t_cljs$core$async14524.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async14524.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async14524.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async14524.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async14524.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta14525","meta14525",581736544,null)], null);
});

cljs.core.async.t_cljs$core$async14524.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14524.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14524";

cljs.core.async.t_cljs$core$async14524.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async14524");
});

cljs.core.async.__GT_t_cljs$core$async14524 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async14524(alt_handler__$1,flag__$1,cb__$1,meta14525){
return (new cljs.core.async.t_cljs$core$async14524(alt_handler__$1,flag__$1,cb__$1,meta14525));
});

}

return (new cljs.core.async.t_cljs$core$async14524(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__14527_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__14527_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__14528_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__14528_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__6049__auto__ = wport;
if(cljs.core.truth_(or__6049__auto__)){
return or__6049__auto__;
} else {
return port;
}
})()], null));
} else {
var G__14531 = (i + (1));
i = G__14531;
continue;
}
} else {
return null;
}
break;
}
})();
var or__6049__auto__ = ret;
if(cljs.core.truth_(or__6049__auto__)){
return or__6049__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__6037__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__6037__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__6037__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__7114__auto__ = [];
var len__7107__auto___14542 = arguments.length;
var i__7108__auto___14543 = (0);
while(true){
if((i__7108__auto___14543 < len__7107__auto___14542)){
args__7114__auto__.push((arguments[i__7108__auto___14543]));

var G__14544 = (i__7108__auto___14543 + (1));
i__7108__auto___14543 = G__14544;
continue;
} else {
}
break;
}

var argseq__7115__auto__ = ((((1) < args__7114__auto__.length))?(new cljs.core.IndexedSeq(args__7114__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7115__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__14539){
var map__14540 = p__14539;
var map__14540__$1 = ((((!((map__14540 == null)))?((((map__14540.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14540.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14540):map__14540);
var opts = map__14540__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq14536){
var G__14537 = cljs.core.first.call(null,seq14536);
var seq14536__$1 = cljs.core.next.call(null,seq14536);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__14537,seq14536__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args14545 = [];
var len__7107__auto___14618 = arguments.length;
var i__7108__auto___14619 = (0);
while(true){
if((i__7108__auto___14619 < len__7107__auto___14618)){
args14545.push((arguments[i__7108__auto___14619]));

var G__14620 = (i__7108__auto___14619 + (1));
i__7108__auto___14619 = G__14620;
continue;
} else {
}
break;
}

var G__14549 = args14545.length;
switch (G__14549) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14545.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__14378__auto___14624 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14378__auto___14624){
return (function (){
var f__14379__auto__ = (function (){var switch__14236__auto__ = ((function (c__14378__auto___14624){
return (function (state_14584){
var state_val_14585 = (state_14584[(1)]);
if((state_val_14585 === (7))){
var inst_14576 = (state_14584[(2)]);
var state_14584__$1 = state_14584;
var statearr_14590_14625 = state_14584__$1;
(statearr_14590_14625[(2)] = inst_14576);

(statearr_14590_14625[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14585 === (1))){
var state_14584__$1 = state_14584;
var statearr_14591_14629 = state_14584__$1;
(statearr_14591_14629[(2)] = null);

(statearr_14591_14629[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14585 === (4))){
var inst_14555 = (state_14584[(7)]);
var inst_14555__$1 = (state_14584[(2)]);
var inst_14556 = (inst_14555__$1 == null);
var state_14584__$1 = (function (){var statearr_14594 = state_14584;
(statearr_14594[(7)] = inst_14555__$1);

return statearr_14594;
})();
if(cljs.core.truth_(inst_14556)){
var statearr_14595_14630 = state_14584__$1;
(statearr_14595_14630[(1)] = (5));

} else {
var statearr_14596_14631 = state_14584__$1;
(statearr_14596_14631[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14585 === (13))){
var state_14584__$1 = state_14584;
var statearr_14598_14632 = state_14584__$1;
(statearr_14598_14632[(2)] = null);

(statearr_14598_14632[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14585 === (6))){
var inst_14555 = (state_14584[(7)]);
var state_14584__$1 = state_14584;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14584__$1,(11),to,inst_14555);
} else {
if((state_val_14585 === (3))){
var inst_14578 = (state_14584[(2)]);
var state_14584__$1 = state_14584;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14584__$1,inst_14578);
} else {
if((state_val_14585 === (12))){
var state_14584__$1 = state_14584;
var statearr_14599_14633 = state_14584__$1;
(statearr_14599_14633[(2)] = null);

(statearr_14599_14633[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14585 === (2))){
var state_14584__$1 = state_14584;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14584__$1,(4),from);
} else {
if((state_val_14585 === (11))){
var inst_14569 = (state_14584[(2)]);
var state_14584__$1 = state_14584;
if(cljs.core.truth_(inst_14569)){
var statearr_14600_14637 = state_14584__$1;
(statearr_14600_14637[(1)] = (12));

} else {
var statearr_14601_14638 = state_14584__$1;
(statearr_14601_14638[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14585 === (9))){
var state_14584__$1 = state_14584;
var statearr_14602_14641 = state_14584__$1;
(statearr_14602_14641[(2)] = null);

(statearr_14602_14641[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14585 === (5))){
var state_14584__$1 = state_14584;
if(cljs.core.truth_(close_QMARK_)){
var statearr_14603_14642 = state_14584__$1;
(statearr_14603_14642[(1)] = (8));

} else {
var statearr_14604_14643 = state_14584__$1;
(statearr_14604_14643[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14585 === (14))){
var inst_14574 = (state_14584[(2)]);
var state_14584__$1 = state_14584;
var statearr_14605_14644 = state_14584__$1;
(statearr_14605_14644[(2)] = inst_14574);

(statearr_14605_14644[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14585 === (10))){
var inst_14564 = (state_14584[(2)]);
var state_14584__$1 = state_14584;
var statearr_14607_14645 = state_14584__$1;
(statearr_14607_14645[(2)] = inst_14564);

(statearr_14607_14645[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14585 === (8))){
var inst_14559 = cljs.core.async.close_BANG_.call(null,to);
var state_14584__$1 = state_14584;
var statearr_14609_14646 = state_14584__$1;
(statearr_14609_14646[(2)] = inst_14559);

(statearr_14609_14646[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14378__auto___14624))
;
return ((function (switch__14236__auto__,c__14378__auto___14624){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_14613 = [null,null,null,null,null,null,null,null];
(statearr_14613[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_14613[(1)] = (1));

return statearr_14613;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_14584){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14584);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e14614){if((e14614 instanceof Object)){
var ex__14240__auto__ = e14614;
var statearr_14615_14649 = state_14584;
(statearr_14615_14649[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14584);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14614;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14650 = state_14584;
state_14584 = G__14650;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_14584){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_14584);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14378__auto___14624))
})();
var state__14380__auto__ = (function (){var statearr_14617 = f__14379__auto__.call(null);
(statearr_14617[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14378__auto___14624);

return statearr_14617;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14380__auto__);
});})(c__14378__auto___14624))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__14842){
var vec__14843 = p__14842;
var v = cljs.core.nth.call(null,vec__14843,(0),null);
var p = cljs.core.nth.call(null,vec__14843,(1),null);
var job = vec__14843;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__14378__auto___15027 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14378__auto___15027,res,vec__14843,v,p,job,jobs,results){
return (function (){
var f__14379__auto__ = (function (){var switch__14236__auto__ = ((function (c__14378__auto___15027,res,vec__14843,v,p,job,jobs,results){
return (function (state_14848){
var state_val_14849 = (state_14848[(1)]);
if((state_val_14849 === (1))){
var state_14848__$1 = state_14848;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14848__$1,(2),res,v);
} else {
if((state_val_14849 === (2))){
var inst_14845 = (state_14848[(2)]);
var inst_14846 = cljs.core.async.close_BANG_.call(null,res);
var state_14848__$1 = (function (){var statearr_14850 = state_14848;
(statearr_14850[(7)] = inst_14845);

return statearr_14850;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14848__$1,inst_14846);
} else {
return null;
}
}
});})(c__14378__auto___15027,res,vec__14843,v,p,job,jobs,results))
;
return ((function (switch__14236__auto__,c__14378__auto___15027,res,vec__14843,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_14854 = [null,null,null,null,null,null,null,null];
(statearr_14854[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__);

(statearr_14854[(1)] = (1));

return statearr_14854;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1 = (function (state_14848){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14848);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e14855){if((e14855 instanceof Object)){
var ex__14240__auto__ = e14855;
var statearr_14856_15028 = state_14848;
(statearr_14856_15028[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14848);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14855;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15029 = state_14848;
state_14848 = G__15029;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = function(state_14848){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1.call(this,state_14848);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14378__auto___15027,res,vec__14843,v,p,job,jobs,results))
})();
var state__14380__auto__ = (function (){var statearr_14857 = f__14379__auto__.call(null);
(statearr_14857[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14378__auto___15027);

return statearr_14857;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14380__auto__);
});})(c__14378__auto___15027,res,vec__14843,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__14858){
var vec__14859 = p__14858;
var v = cljs.core.nth.call(null,vec__14859,(0),null);
var p = cljs.core.nth.call(null,vec__14859,(1),null);
var job = vec__14859;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__6952__auto___15032 = n;
var __15033 = (0);
while(true){
if((__15033 < n__6952__auto___15032)){
var G__14860_15034 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__14860_15034) {
case "compute":
var c__14378__auto___15036 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__15033,c__14378__auto___15036,G__14860_15034,n__6952__auto___15032,jobs,results,process,async){
return (function (){
var f__14379__auto__ = (function (){var switch__14236__auto__ = ((function (__15033,c__14378__auto___15036,G__14860_15034,n__6952__auto___15032,jobs,results,process,async){
return (function (state_14873){
var state_val_14874 = (state_14873[(1)]);
if((state_val_14874 === (1))){
var state_14873__$1 = state_14873;
var statearr_14875_15037 = state_14873__$1;
(statearr_14875_15037[(2)] = null);

(statearr_14875_15037[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14874 === (2))){
var state_14873__$1 = state_14873;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14873__$1,(4),jobs);
} else {
if((state_val_14874 === (3))){
var inst_14871 = (state_14873[(2)]);
var state_14873__$1 = state_14873;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14873__$1,inst_14871);
} else {
if((state_val_14874 === (4))){
var inst_14863 = (state_14873[(2)]);
var inst_14864 = process.call(null,inst_14863);
var state_14873__$1 = state_14873;
if(cljs.core.truth_(inst_14864)){
var statearr_14876_15038 = state_14873__$1;
(statearr_14876_15038[(1)] = (5));

} else {
var statearr_14877_15039 = state_14873__$1;
(statearr_14877_15039[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14874 === (5))){
var state_14873__$1 = state_14873;
var statearr_14878_15040 = state_14873__$1;
(statearr_14878_15040[(2)] = null);

(statearr_14878_15040[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14874 === (6))){
var state_14873__$1 = state_14873;
var statearr_14879_15041 = state_14873__$1;
(statearr_14879_15041[(2)] = null);

(statearr_14879_15041[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14874 === (7))){
var inst_14869 = (state_14873[(2)]);
var state_14873__$1 = state_14873;
var statearr_14880_15047 = state_14873__$1;
(statearr_14880_15047[(2)] = inst_14869);

(statearr_14880_15047[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__15033,c__14378__auto___15036,G__14860_15034,n__6952__auto___15032,jobs,results,process,async))
;
return ((function (__15033,switch__14236__auto__,c__14378__auto___15036,G__14860_15034,n__6952__auto___15032,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_14884 = [null,null,null,null,null,null,null];
(statearr_14884[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__);

(statearr_14884[(1)] = (1));

return statearr_14884;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1 = (function (state_14873){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14873);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e14885){if((e14885 instanceof Object)){
var ex__14240__auto__ = e14885;
var statearr_14886_15053 = state_14873;
(statearr_14886_15053[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14873);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14885;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15054 = state_14873;
state_14873 = G__15054;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = function(state_14873){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1.call(this,state_14873);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__;
})()
;})(__15033,switch__14236__auto__,c__14378__auto___15036,G__14860_15034,n__6952__auto___15032,jobs,results,process,async))
})();
var state__14380__auto__ = (function (){var statearr_14887 = f__14379__auto__.call(null);
(statearr_14887[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14378__auto___15036);

return statearr_14887;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14380__auto__);
});})(__15033,c__14378__auto___15036,G__14860_15034,n__6952__auto___15032,jobs,results,process,async))
);


break;
case "async":
var c__14378__auto___15055 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__15033,c__14378__auto___15055,G__14860_15034,n__6952__auto___15032,jobs,results,process,async){
return (function (){
var f__14379__auto__ = (function (){var switch__14236__auto__ = ((function (__15033,c__14378__auto___15055,G__14860_15034,n__6952__auto___15032,jobs,results,process,async){
return (function (state_14900){
var state_val_14901 = (state_14900[(1)]);
if((state_val_14901 === (1))){
var state_14900__$1 = state_14900;
var statearr_14902_15056 = state_14900__$1;
(statearr_14902_15056[(2)] = null);

(statearr_14902_15056[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14901 === (2))){
var state_14900__$1 = state_14900;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14900__$1,(4),jobs);
} else {
if((state_val_14901 === (3))){
var inst_14898 = (state_14900[(2)]);
var state_14900__$1 = state_14900;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14900__$1,inst_14898);
} else {
if((state_val_14901 === (4))){
var inst_14890 = (state_14900[(2)]);
var inst_14891 = async.call(null,inst_14890);
var state_14900__$1 = state_14900;
if(cljs.core.truth_(inst_14891)){
var statearr_14903_15057 = state_14900__$1;
(statearr_14903_15057[(1)] = (5));

} else {
var statearr_14904_15058 = state_14900__$1;
(statearr_14904_15058[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14901 === (5))){
var state_14900__$1 = state_14900;
var statearr_14905_15059 = state_14900__$1;
(statearr_14905_15059[(2)] = null);

(statearr_14905_15059[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14901 === (6))){
var state_14900__$1 = state_14900;
var statearr_14906_15060 = state_14900__$1;
(statearr_14906_15060[(2)] = null);

(statearr_14906_15060[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14901 === (7))){
var inst_14896 = (state_14900[(2)]);
var state_14900__$1 = state_14900;
var statearr_14907_15061 = state_14900__$1;
(statearr_14907_15061[(2)] = inst_14896);

(statearr_14907_15061[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__15033,c__14378__auto___15055,G__14860_15034,n__6952__auto___15032,jobs,results,process,async))
;
return ((function (__15033,switch__14236__auto__,c__14378__auto___15055,G__14860_15034,n__6952__auto___15032,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_14911 = [null,null,null,null,null,null,null];
(statearr_14911[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__);

(statearr_14911[(1)] = (1));

return statearr_14911;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1 = (function (state_14900){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14900);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e14912){if((e14912 instanceof Object)){
var ex__14240__auto__ = e14912;
var statearr_14913_15062 = state_14900;
(statearr_14913_15062[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14900);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14912;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15063 = state_14900;
state_14900 = G__15063;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = function(state_14900){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1.call(this,state_14900);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__;
})()
;})(__15033,switch__14236__auto__,c__14378__auto___15055,G__14860_15034,n__6952__auto___15032,jobs,results,process,async))
})();
var state__14380__auto__ = (function (){var statearr_14914 = f__14379__auto__.call(null);
(statearr_14914[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14378__auto___15055);

return statearr_14914;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14380__auto__);
});})(__15033,c__14378__auto___15055,G__14860_15034,n__6952__auto___15032,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__15064 = (__15033 + (1));
__15033 = G__15064;
continue;
} else {
}
break;
}

var c__14378__auto___15065 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14378__auto___15065,jobs,results,process,async){
return (function (){
var f__14379__auto__ = (function (){var switch__14236__auto__ = ((function (c__14378__auto___15065,jobs,results,process,async){
return (function (state_14936){
var state_val_14937 = (state_14936[(1)]);
if((state_val_14937 === (1))){
var state_14936__$1 = state_14936;
var statearr_14938_15066 = state_14936__$1;
(statearr_14938_15066[(2)] = null);

(statearr_14938_15066[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (2))){
var state_14936__$1 = state_14936;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14936__$1,(4),from);
} else {
if((state_val_14937 === (3))){
var inst_14934 = (state_14936[(2)]);
var state_14936__$1 = state_14936;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14936__$1,inst_14934);
} else {
if((state_val_14937 === (4))){
var inst_14917 = (state_14936[(7)]);
var inst_14917__$1 = (state_14936[(2)]);
var inst_14918 = (inst_14917__$1 == null);
var state_14936__$1 = (function (){var statearr_14939 = state_14936;
(statearr_14939[(7)] = inst_14917__$1);

return statearr_14939;
})();
if(cljs.core.truth_(inst_14918)){
var statearr_14940_15069 = state_14936__$1;
(statearr_14940_15069[(1)] = (5));

} else {
var statearr_14941_15070 = state_14936__$1;
(statearr_14941_15070[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (5))){
var inst_14920 = cljs.core.async.close_BANG_.call(null,jobs);
var state_14936__$1 = state_14936;
var statearr_14942_15071 = state_14936__$1;
(statearr_14942_15071[(2)] = inst_14920);

(statearr_14942_15071[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (6))){
var inst_14917 = (state_14936[(7)]);
var inst_14922 = (state_14936[(8)]);
var inst_14922__$1 = cljs.core.async.chan.call(null,(1));
var inst_14923 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14924 = [inst_14917,inst_14922__$1];
var inst_14925 = (new cljs.core.PersistentVector(null,2,(5),inst_14923,inst_14924,null));
var state_14936__$1 = (function (){var statearr_14943 = state_14936;
(statearr_14943[(8)] = inst_14922__$1);

return statearr_14943;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14936__$1,(8),jobs,inst_14925);
} else {
if((state_val_14937 === (7))){
var inst_14932 = (state_14936[(2)]);
var state_14936__$1 = state_14936;
var statearr_14944_15075 = state_14936__$1;
(statearr_14944_15075[(2)] = inst_14932);

(statearr_14944_15075[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14937 === (8))){
var inst_14922 = (state_14936[(8)]);
var inst_14927 = (state_14936[(2)]);
var state_14936__$1 = (function (){var statearr_14945 = state_14936;
(statearr_14945[(9)] = inst_14927);

return statearr_14945;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14936__$1,(9),results,inst_14922);
} else {
if((state_val_14937 === (9))){
var inst_14929 = (state_14936[(2)]);
var state_14936__$1 = (function (){var statearr_14946 = state_14936;
(statearr_14946[(10)] = inst_14929);

return statearr_14946;
})();
var statearr_14947_15077 = state_14936__$1;
(statearr_14947_15077[(2)] = null);

(statearr_14947_15077[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__14378__auto___15065,jobs,results,process,async))
;
return ((function (switch__14236__auto__,c__14378__auto___15065,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_14951 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14951[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__);

(statearr_14951[(1)] = (1));

return statearr_14951;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1 = (function (state_14936){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14936);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e14952){if((e14952 instanceof Object)){
var ex__14240__auto__ = e14952;
var statearr_14953_15078 = state_14936;
(statearr_14953_15078[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14936);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14952;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15079 = state_14936;
state_14936 = G__15079;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = function(state_14936){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1.call(this,state_14936);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14378__auto___15065,jobs,results,process,async))
})();
var state__14380__auto__ = (function (){var statearr_14954 = f__14379__auto__.call(null);
(statearr_14954[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14378__auto___15065);

return statearr_14954;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14380__auto__);
});})(c__14378__auto___15065,jobs,results,process,async))
);


var c__14378__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14378__auto__,jobs,results,process,async){
return (function (){
var f__14379__auto__ = (function (){var switch__14236__auto__ = ((function (c__14378__auto__,jobs,results,process,async){
return (function (state_14992){
var state_val_14993 = (state_14992[(1)]);
if((state_val_14993 === (7))){
var inst_14988 = (state_14992[(2)]);
var state_14992__$1 = state_14992;
var statearr_14994_15080 = state_14992__$1;
(statearr_14994_15080[(2)] = inst_14988);

(statearr_14994_15080[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (20))){
var state_14992__$1 = state_14992;
var statearr_14995_15081 = state_14992__$1;
(statearr_14995_15081[(2)] = null);

(statearr_14995_15081[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (1))){
var state_14992__$1 = state_14992;
var statearr_14996_15082 = state_14992__$1;
(statearr_14996_15082[(2)] = null);

(statearr_14996_15082[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (4))){
var inst_14957 = (state_14992[(7)]);
var inst_14957__$1 = (state_14992[(2)]);
var inst_14958 = (inst_14957__$1 == null);
var state_14992__$1 = (function (){var statearr_14997 = state_14992;
(statearr_14997[(7)] = inst_14957__$1);

return statearr_14997;
})();
if(cljs.core.truth_(inst_14958)){
var statearr_14998_15086 = state_14992__$1;
(statearr_14998_15086[(1)] = (5));

} else {
var statearr_14999_15087 = state_14992__$1;
(statearr_14999_15087[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (15))){
var inst_14970 = (state_14992[(8)]);
var state_14992__$1 = state_14992;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14992__$1,(18),to,inst_14970);
} else {
if((state_val_14993 === (21))){
var inst_14983 = (state_14992[(2)]);
var state_14992__$1 = state_14992;
var statearr_15000_15088 = state_14992__$1;
(statearr_15000_15088[(2)] = inst_14983);

(statearr_15000_15088[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (13))){
var inst_14985 = (state_14992[(2)]);
var state_14992__$1 = (function (){var statearr_15001 = state_14992;
(statearr_15001[(9)] = inst_14985);

return statearr_15001;
})();
var statearr_15002_15089 = state_14992__$1;
(statearr_15002_15089[(2)] = null);

(statearr_15002_15089[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (6))){
var inst_14957 = (state_14992[(7)]);
var state_14992__$1 = state_14992;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14992__$1,(11),inst_14957);
} else {
if((state_val_14993 === (17))){
var inst_14978 = (state_14992[(2)]);
var state_14992__$1 = state_14992;
if(cljs.core.truth_(inst_14978)){
var statearr_15003_15090 = state_14992__$1;
(statearr_15003_15090[(1)] = (19));

} else {
var statearr_15004_15092 = state_14992__$1;
(statearr_15004_15092[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (3))){
var inst_14990 = (state_14992[(2)]);
var state_14992__$1 = state_14992;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14992__$1,inst_14990);
} else {
if((state_val_14993 === (12))){
var inst_14967 = (state_14992[(10)]);
var state_14992__$1 = state_14992;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14992__$1,(14),inst_14967);
} else {
if((state_val_14993 === (2))){
var state_14992__$1 = state_14992;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14992__$1,(4),results);
} else {
if((state_val_14993 === (19))){
var state_14992__$1 = state_14992;
var statearr_15005_15093 = state_14992__$1;
(statearr_15005_15093[(2)] = null);

(statearr_15005_15093[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (11))){
var inst_14967 = (state_14992[(2)]);
var state_14992__$1 = (function (){var statearr_15006 = state_14992;
(statearr_15006[(10)] = inst_14967);

return statearr_15006;
})();
var statearr_15007_15094 = state_14992__$1;
(statearr_15007_15094[(2)] = null);

(statearr_15007_15094[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (9))){
var state_14992__$1 = state_14992;
var statearr_15008_15095 = state_14992__$1;
(statearr_15008_15095[(2)] = null);

(statearr_15008_15095[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (5))){
var state_14992__$1 = state_14992;
if(cljs.core.truth_(close_QMARK_)){
var statearr_15009_15096 = state_14992__$1;
(statearr_15009_15096[(1)] = (8));

} else {
var statearr_15010_15097 = state_14992__$1;
(statearr_15010_15097[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (14))){
var inst_14972 = (state_14992[(11)]);
var inst_14970 = (state_14992[(8)]);
var inst_14970__$1 = (state_14992[(2)]);
var inst_14971 = (inst_14970__$1 == null);
var inst_14972__$1 = cljs.core.not.call(null,inst_14971);
var state_14992__$1 = (function (){var statearr_15011 = state_14992;
(statearr_15011[(11)] = inst_14972__$1);

(statearr_15011[(8)] = inst_14970__$1);

return statearr_15011;
})();
if(inst_14972__$1){
var statearr_15012_15098 = state_14992__$1;
(statearr_15012_15098[(1)] = (15));

} else {
var statearr_15013_15099 = state_14992__$1;
(statearr_15013_15099[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (16))){
var inst_14972 = (state_14992[(11)]);
var state_14992__$1 = state_14992;
var statearr_15014_15100 = state_14992__$1;
(statearr_15014_15100[(2)] = inst_14972);

(statearr_15014_15100[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (10))){
var inst_14964 = (state_14992[(2)]);
var state_14992__$1 = state_14992;
var statearr_15015_15101 = state_14992__$1;
(statearr_15015_15101[(2)] = inst_14964);

(statearr_15015_15101[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (18))){
var inst_14975 = (state_14992[(2)]);
var state_14992__$1 = state_14992;
var statearr_15016_15102 = state_14992__$1;
(statearr_15016_15102[(2)] = inst_14975);

(statearr_15016_15102[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14993 === (8))){
var inst_14961 = cljs.core.async.close_BANG_.call(null,to);
var state_14992__$1 = state_14992;
var statearr_15017_15103 = state_14992__$1;
(statearr_15017_15103[(2)] = inst_14961);

(statearr_15017_15103[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14378__auto__,jobs,results,process,async))
;
return ((function (switch__14236__auto__,c__14378__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_15021 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15021[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__);

(statearr_15021[(1)] = (1));

return statearr_15021;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1 = (function (state_14992){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14992);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e15022){if((e15022 instanceof Object)){
var ex__14240__auto__ = e15022;
var statearr_15023_15104 = state_14992;
(statearr_15023_15104[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14992);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15022;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15105 = state_14992;
state_14992 = G__15105;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = function(state_14992){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1.call(this,state_14992);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14378__auto__,jobs,results,process,async))
})();
var state__14380__auto__ = (function (){var statearr_15024 = f__14379__auto__.call(null);
(statearr_15024[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14378__auto__);

return statearr_15024;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14380__auto__);
});})(c__14378__auto__,jobs,results,process,async))
);

return c__14378__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args15106 = [];
var len__7107__auto___15109 = arguments.length;
var i__7108__auto___15110 = (0);
while(true){
if((i__7108__auto___15110 < len__7107__auto___15109)){
args15106.push((arguments[i__7108__auto___15110]));

var G__15111 = (i__7108__auto___15110 + (1));
i__7108__auto___15110 = G__15111;
continue;
} else {
}
break;
}

var G__15108 = args15106.length;
switch (G__15108) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15106.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args15113 = [];
var len__7107__auto___15116 = arguments.length;
var i__7108__auto___15117 = (0);
while(true){
if((i__7108__auto___15117 < len__7107__auto___15116)){
args15113.push((arguments[i__7108__auto___15117]));

var G__15118 = (i__7108__auto___15117 + (1));
i__7108__auto___15117 = G__15118;
continue;
} else {
}
break;
}

var G__15115 = args15113.length;
switch (G__15115) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15113.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args15124 = [];
var len__7107__auto___15202 = arguments.length;
var i__7108__auto___15203 = (0);
while(true){
if((i__7108__auto___15203 < len__7107__auto___15202)){
args15124.push((arguments[i__7108__auto___15203]));

var G__15204 = (i__7108__auto___15203 + (1));
i__7108__auto___15203 = G__15204;
continue;
} else {
}
break;
}

var G__15130 = args15124.length;
switch (G__15130) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15124.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__14378__auto___15206 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14378__auto___15206,tc,fc){
return (function (){
var f__14379__auto__ = (function (){var switch__14236__auto__ = ((function (c__14378__auto___15206,tc,fc){
return (function (state_15160){
var state_val_15161 = (state_15160[(1)]);
if((state_val_15161 === (7))){
var inst_15156 = (state_15160[(2)]);
var state_15160__$1 = state_15160;
var statearr_15162_15207 = state_15160__$1;
(statearr_15162_15207[(2)] = inst_15156);

(statearr_15162_15207[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15161 === (1))){
var state_15160__$1 = state_15160;
var statearr_15163_15208 = state_15160__$1;
(statearr_15163_15208[(2)] = null);

(statearr_15163_15208[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15161 === (4))){
var inst_15137 = (state_15160[(7)]);
var inst_15137__$1 = (state_15160[(2)]);
var inst_15138 = (inst_15137__$1 == null);
var state_15160__$1 = (function (){var statearr_15164 = state_15160;
(statearr_15164[(7)] = inst_15137__$1);

return statearr_15164;
})();
if(cljs.core.truth_(inst_15138)){
var statearr_15165_15209 = state_15160__$1;
(statearr_15165_15209[(1)] = (5));

} else {
var statearr_15166_15210 = state_15160__$1;
(statearr_15166_15210[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15161 === (13))){
var state_15160__$1 = state_15160;
var statearr_15167_15211 = state_15160__$1;
(statearr_15167_15211[(2)] = null);

(statearr_15167_15211[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15161 === (6))){
var inst_15137 = (state_15160[(7)]);
var inst_15143 = p.call(null,inst_15137);
var state_15160__$1 = state_15160;
if(cljs.core.truth_(inst_15143)){
var statearr_15168_15212 = state_15160__$1;
(statearr_15168_15212[(1)] = (9));

} else {
var statearr_15169_15213 = state_15160__$1;
(statearr_15169_15213[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15161 === (3))){
var inst_15158 = (state_15160[(2)]);
var state_15160__$1 = state_15160;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15160__$1,inst_15158);
} else {
if((state_val_15161 === (12))){
var state_15160__$1 = state_15160;
var statearr_15170_15214 = state_15160__$1;
(statearr_15170_15214[(2)] = null);

(statearr_15170_15214[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15161 === (2))){
var state_15160__$1 = state_15160;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15160__$1,(4),ch);
} else {
if((state_val_15161 === (11))){
var inst_15137 = (state_15160[(7)]);
var inst_15147 = (state_15160[(2)]);
var state_15160__$1 = state_15160;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15160__$1,(8),inst_15147,inst_15137);
} else {
if((state_val_15161 === (9))){
var state_15160__$1 = state_15160;
var statearr_15171_15217 = state_15160__$1;
(statearr_15171_15217[(2)] = tc);

(statearr_15171_15217[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15161 === (5))){
var inst_15140 = cljs.core.async.close_BANG_.call(null,tc);
var inst_15141 = cljs.core.async.close_BANG_.call(null,fc);
var state_15160__$1 = (function (){var statearr_15172 = state_15160;
(statearr_15172[(8)] = inst_15140);

return statearr_15172;
})();
var statearr_15173_15219 = state_15160__$1;
(statearr_15173_15219[(2)] = inst_15141);

(statearr_15173_15219[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15161 === (14))){
var inst_15154 = (state_15160[(2)]);
var state_15160__$1 = state_15160;
var statearr_15175_15221 = state_15160__$1;
(statearr_15175_15221[(2)] = inst_15154);

(statearr_15175_15221[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15161 === (10))){
var state_15160__$1 = state_15160;
var statearr_15180_15222 = state_15160__$1;
(statearr_15180_15222[(2)] = fc);

(statearr_15180_15222[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15161 === (8))){
var inst_15149 = (state_15160[(2)]);
var state_15160__$1 = state_15160;
if(cljs.core.truth_(inst_15149)){
var statearr_15181_15223 = state_15160__$1;
(statearr_15181_15223[(1)] = (12));

} else {
var statearr_15182_15224 = state_15160__$1;
(statearr_15182_15224[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14378__auto___15206,tc,fc))
;
return ((function (switch__14236__auto__,c__14378__auto___15206,tc,fc){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_15193 = [null,null,null,null,null,null,null,null,null];
(statearr_15193[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_15193[(1)] = (1));

return statearr_15193;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_15160){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_15160);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e15194){if((e15194 instanceof Object)){
var ex__14240__auto__ = e15194;
var statearr_15195_15225 = state_15160;
(statearr_15195_15225[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15160);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15194;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15226 = state_15160;
state_15160 = G__15226;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_15160){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_15160);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14378__auto___15206,tc,fc))
})();
var state__14380__auto__ = (function (){var statearr_15201 = f__14379__auto__.call(null);
(statearr_15201[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14378__auto___15206);

return statearr_15201;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14380__auto__);
});})(c__14378__auto___15206,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__14378__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14378__auto__){
return (function (){
var f__14379__auto__ = (function (){var switch__14236__auto__ = ((function (c__14378__auto__){
return (function (state_15294){
var state_val_15295 = (state_15294[(1)]);
if((state_val_15295 === (7))){
var inst_15290 = (state_15294[(2)]);
var state_15294__$1 = state_15294;
var statearr_15296_15321 = state_15294__$1;
(statearr_15296_15321[(2)] = inst_15290);

(statearr_15296_15321[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15295 === (1))){
var inst_15274 = init;
var state_15294__$1 = (function (){var statearr_15297 = state_15294;
(statearr_15297[(7)] = inst_15274);

return statearr_15297;
})();
var statearr_15298_15322 = state_15294__$1;
(statearr_15298_15322[(2)] = null);

(statearr_15298_15322[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15295 === (4))){
var inst_15277 = (state_15294[(8)]);
var inst_15277__$1 = (state_15294[(2)]);
var inst_15278 = (inst_15277__$1 == null);
var state_15294__$1 = (function (){var statearr_15302 = state_15294;
(statearr_15302[(8)] = inst_15277__$1);

return statearr_15302;
})();
if(cljs.core.truth_(inst_15278)){
var statearr_15303_15323 = state_15294__$1;
(statearr_15303_15323[(1)] = (5));

} else {
var statearr_15304_15324 = state_15294__$1;
(statearr_15304_15324[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15295 === (6))){
var inst_15277 = (state_15294[(8)]);
var inst_15281 = (state_15294[(9)]);
var inst_15274 = (state_15294[(7)]);
var inst_15281__$1 = f.call(null,inst_15274,inst_15277);
var inst_15282 = cljs.core.reduced_QMARK_.call(null,inst_15281__$1);
var state_15294__$1 = (function (){var statearr_15305 = state_15294;
(statearr_15305[(9)] = inst_15281__$1);

return statearr_15305;
})();
if(inst_15282){
var statearr_15306_15325 = state_15294__$1;
(statearr_15306_15325[(1)] = (8));

} else {
var statearr_15307_15326 = state_15294__$1;
(statearr_15307_15326[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15295 === (3))){
var inst_15292 = (state_15294[(2)]);
var state_15294__$1 = state_15294;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15294__$1,inst_15292);
} else {
if((state_val_15295 === (2))){
var state_15294__$1 = state_15294;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15294__$1,(4),ch);
} else {
if((state_val_15295 === (9))){
var inst_15281 = (state_15294[(9)]);
var inst_15274 = inst_15281;
var state_15294__$1 = (function (){var statearr_15308 = state_15294;
(statearr_15308[(7)] = inst_15274);

return statearr_15308;
})();
var statearr_15309_15327 = state_15294__$1;
(statearr_15309_15327[(2)] = null);

(statearr_15309_15327[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15295 === (5))){
var inst_15274 = (state_15294[(7)]);
var state_15294__$1 = state_15294;
var statearr_15310_15328 = state_15294__$1;
(statearr_15310_15328[(2)] = inst_15274);

(statearr_15310_15328[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15295 === (10))){
var inst_15288 = (state_15294[(2)]);
var state_15294__$1 = state_15294;
var statearr_15311_15329 = state_15294__$1;
(statearr_15311_15329[(2)] = inst_15288);

(statearr_15311_15329[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15295 === (8))){
var inst_15281 = (state_15294[(9)]);
var inst_15284 = cljs.core.deref.call(null,inst_15281);
var state_15294__$1 = state_15294;
var statearr_15312_15330 = state_15294__$1;
(statearr_15312_15330[(2)] = inst_15284);

(statearr_15312_15330[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__14378__auto__))
;
return ((function (switch__14236__auto__,c__14378__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__14237__auto__ = null;
var cljs$core$async$reduce_$_state_machine__14237__auto____0 = (function (){
var statearr_15316 = [null,null,null,null,null,null,null,null,null,null];
(statearr_15316[(0)] = cljs$core$async$reduce_$_state_machine__14237__auto__);

(statearr_15316[(1)] = (1));

return statearr_15316;
});
var cljs$core$async$reduce_$_state_machine__14237__auto____1 = (function (state_15294){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_15294);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e15317){if((e15317 instanceof Object)){
var ex__14240__auto__ = e15317;
var statearr_15318_15331 = state_15294;
(statearr_15318_15331[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15294);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15317;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15332 = state_15294;
state_15294 = G__15332;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__14237__auto__ = function(state_15294){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__14237__auto____1.call(this,state_15294);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__14237__auto____0;
cljs$core$async$reduce_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__14237__auto____1;
return cljs$core$async$reduce_$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14378__auto__))
})();
var state__14380__auto__ = (function (){var statearr_15319 = f__14379__auto__.call(null);
(statearr_15319[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14378__auto__);

return statearr_15319;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14380__auto__);
});})(c__14378__auto__))
);

return c__14378__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args15333 = [];
var len__7107__auto___15385 = arguments.length;
var i__7108__auto___15386 = (0);
while(true){
if((i__7108__auto___15386 < len__7107__auto___15385)){
args15333.push((arguments[i__7108__auto___15386]));

var G__15387 = (i__7108__auto___15386 + (1));
i__7108__auto___15386 = G__15387;
continue;
} else {
}
break;
}

var G__15335 = args15333.length;
switch (G__15335) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15333.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__14378__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14378__auto__){
return (function (){
var f__14379__auto__ = (function (){var switch__14236__auto__ = ((function (c__14378__auto__){
return (function (state_15360){
var state_val_15361 = (state_15360[(1)]);
if((state_val_15361 === (7))){
var inst_15342 = (state_15360[(2)]);
var state_15360__$1 = state_15360;
var statearr_15362_15391 = state_15360__$1;
(statearr_15362_15391[(2)] = inst_15342);

(statearr_15362_15391[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15361 === (1))){
var inst_15336 = cljs.core.seq.call(null,coll);
var inst_15337 = inst_15336;
var state_15360__$1 = (function (){var statearr_15363 = state_15360;
(statearr_15363[(7)] = inst_15337);

return statearr_15363;
})();
var statearr_15364_15393 = state_15360__$1;
(statearr_15364_15393[(2)] = null);

(statearr_15364_15393[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15361 === (4))){
var inst_15337 = (state_15360[(7)]);
var inst_15340 = cljs.core.first.call(null,inst_15337);
var state_15360__$1 = state_15360;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15360__$1,(7),ch,inst_15340);
} else {
if((state_val_15361 === (13))){
var inst_15354 = (state_15360[(2)]);
var state_15360__$1 = state_15360;
var statearr_15365_15398 = state_15360__$1;
(statearr_15365_15398[(2)] = inst_15354);

(statearr_15365_15398[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15361 === (6))){
var inst_15345 = (state_15360[(2)]);
var state_15360__$1 = state_15360;
if(cljs.core.truth_(inst_15345)){
var statearr_15366_15399 = state_15360__$1;
(statearr_15366_15399[(1)] = (8));

} else {
var statearr_15367_15400 = state_15360__$1;
(statearr_15367_15400[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15361 === (3))){
var inst_15358 = (state_15360[(2)]);
var state_15360__$1 = state_15360;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15360__$1,inst_15358);
} else {
if((state_val_15361 === (12))){
var state_15360__$1 = state_15360;
var statearr_15368_15401 = state_15360__$1;
(statearr_15368_15401[(2)] = null);

(statearr_15368_15401[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15361 === (2))){
var inst_15337 = (state_15360[(7)]);
var state_15360__$1 = state_15360;
if(cljs.core.truth_(inst_15337)){
var statearr_15369_15402 = state_15360__$1;
(statearr_15369_15402[(1)] = (4));

} else {
var statearr_15370_15403 = state_15360__$1;
(statearr_15370_15403[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15361 === (11))){
var inst_15351 = cljs.core.async.close_BANG_.call(null,ch);
var state_15360__$1 = state_15360;
var statearr_15371_15404 = state_15360__$1;
(statearr_15371_15404[(2)] = inst_15351);

(statearr_15371_15404[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15361 === (9))){
var state_15360__$1 = state_15360;
if(cljs.core.truth_(close_QMARK_)){
var statearr_15372_15405 = state_15360__$1;
(statearr_15372_15405[(1)] = (11));

} else {
var statearr_15373_15406 = state_15360__$1;
(statearr_15373_15406[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15361 === (5))){
var inst_15337 = (state_15360[(7)]);
var state_15360__$1 = state_15360;
var statearr_15374_15407 = state_15360__$1;
(statearr_15374_15407[(2)] = inst_15337);

(statearr_15374_15407[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15361 === (10))){
var inst_15356 = (state_15360[(2)]);
var state_15360__$1 = state_15360;
var statearr_15375_15408 = state_15360__$1;
(statearr_15375_15408[(2)] = inst_15356);

(statearr_15375_15408[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15361 === (8))){
var inst_15337 = (state_15360[(7)]);
var inst_15347 = cljs.core.next.call(null,inst_15337);
var inst_15337__$1 = inst_15347;
var state_15360__$1 = (function (){var statearr_15376 = state_15360;
(statearr_15376[(7)] = inst_15337__$1);

return statearr_15376;
})();
var statearr_15377_15409 = state_15360__$1;
(statearr_15377_15409[(2)] = null);

(statearr_15377_15409[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14378__auto__))
;
return ((function (switch__14236__auto__,c__14378__auto__){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_15381 = [null,null,null,null,null,null,null,null];
(statearr_15381[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_15381[(1)] = (1));

return statearr_15381;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_15360){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_15360);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e15382){if((e15382 instanceof Object)){
var ex__14240__auto__ = e15382;
var statearr_15383_15410 = state_15360;
(statearr_15383_15410[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15360);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15382;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15411 = state_15360;
state_15360 = G__15411;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_15360){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_15360);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14378__auto__))
})();
var state__14380__auto__ = (function (){var statearr_15384 = f__14379__auto__.call(null);
(statearr_15384[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14378__auto__);

return statearr_15384;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14380__auto__);
});})(c__14378__auto__))
);

return c__14378__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__6704__auto__ = (((_ == null))?null:_);
var m__6705__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,_);
} else {
var m__6705__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__6705__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,ch);
} else {
var m__6705__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m);
} else {
var m__6705__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async15645 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15645 = (function (mult,ch,cs,meta15646){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta15646 = meta15646;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async15645.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_15647,meta15646__$1){
var self__ = this;
var _15647__$1 = this;
return (new cljs.core.async.t_cljs$core$async15645(self__.mult,self__.ch,self__.cs,meta15646__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async15645.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_15647){
var self__ = this;
var _15647__$1 = this;
return self__.meta15646;
});})(cs))
;

cljs.core.async.t_cljs$core$async15645.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async15645.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async15645.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async15645.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async15645.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async15645.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async15645.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta15646","meta15646",-1559815913,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async15645.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async15645.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15645";

cljs.core.async.t_cljs$core$async15645.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async15645");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async15645 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async15645(mult__$1,ch__$1,cs__$1,meta15646){
return (new cljs.core.async.t_cljs$core$async15645(mult__$1,ch__$1,cs__$1,meta15646));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async15645(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__14378__auto___15880 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14378__auto___15880,cs,m,dchan,dctr,done){
return (function (){
var f__14379__auto__ = (function (){var switch__14236__auto__ = ((function (c__14378__auto___15880,cs,m,dchan,dctr,done){
return (function (state_15778){
var state_val_15779 = (state_15778[(1)]);
if((state_val_15779 === (7))){
var inst_15774 = (state_15778[(2)]);
var state_15778__$1 = state_15778;
var statearr_15780_15881 = state_15778__$1;
(statearr_15780_15881[(2)] = inst_15774);

(statearr_15780_15881[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15779 === (20))){
var inst_15679 = (state_15778[(7)]);
var inst_15689 = cljs.core.first.call(null,inst_15679);
var inst_15690 = cljs.core.nth.call(null,inst_15689,(0),null);
var inst_15691 = cljs.core.nth.call(null,inst_15689,(1),null);
var state_15778__$1 = (function (){var statearr_15781 = state_15778;
(statearr_15781[(8)] = inst_15690);

return statearr_15781;
})();
if(cljs.core.truth_(inst_15691)){
var statearr_15782_15883 = state_15778__$1;
(statearr_15782_15883[(1)] = (22));

} else {
var statearr_15783_15884 = state_15778__$1;
(statearr_15783_15884[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15779 === (27))){
var inst_15721 = (state_15778[(9)]);
var inst_15719 = (state_15778[(10)]);
var inst_15726 = (state_15778[(11)]);
var inst_15650 = (state_15778[(12)]);
var inst_15726__$1 = cljs.core._nth.call(null,inst_15719,inst_15721);
var inst_15727 = cljs.core.async.put_BANG_.call(null,inst_15726__$1,inst_15650,done);
var state_15778__$1 = (function (){var statearr_15784 = state_15778;
(statearr_15784[(11)] = inst_15726__$1);

return statearr_15784;
})();
if(cljs.core.truth_(inst_15727)){
var statearr_15785_15885 = state_15778__$1;
(statearr_15785_15885[(1)] = (30));

} else {
var statearr_15786_15886 = state_15778__$1;
(statearr_15786_15886[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15779 === (1))){
var state_15778__$1 = state_15778;
var statearr_15787_15887 = state_15778__$1;
(statearr_15787_15887[(2)] = null);

(statearr_15787_15887[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15779 === (24))){
var inst_15679 = (state_15778[(7)]);
var inst_15696 = (state_15778[(2)]);
var inst_15697 = cljs.core.next.call(null,inst_15679);
var inst_15659 = inst_15697;
var inst_15660 = null;
var inst_15661 = (0);
var inst_15662 = (0);
var state_15778__$1 = (function (){var statearr_15788 = state_15778;
(statearr_15788[(13)] = inst_15662);

(statearr_15788[(14)] = inst_15660);

(statearr_15788[(15)] = inst_15659);

(statearr_15788[(16)] = inst_15661);

(statearr_15788[(17)] = inst_15696);

return statearr_15788;
})();
var statearr_15789_15888 = state_15778__$1;
(statearr_15789_15888[(2)] = null);

(statearr_15789_15888[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15779 === (39))){
var state_15778__$1 = state_15778;
var statearr_15793_15889 = state_15778__$1;
(statearr_15793_15889[(2)] = null);

(statearr_15793_15889[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15779 === (4))){
var inst_15650 = (state_15778[(12)]);
var inst_15650__$1 = (state_15778[(2)]);
var inst_15651 = (inst_15650__$1 == null);
var state_15778__$1 = (function (){var statearr_15794 = state_15778;
(statearr_15794[(12)] = inst_15650__$1);

return statearr_15794;
})();
if(cljs.core.truth_(inst_15651)){
var statearr_15795_15890 = state_15778__$1;
(statearr_15795_15890[(1)] = (5));

} else {
var statearr_15796_15891 = state_15778__$1;
(statearr_15796_15891[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15779 === (15))){
var inst_15662 = (state_15778[(13)]);
var inst_15660 = (state_15778[(14)]);
var inst_15659 = (state_15778[(15)]);
var inst_15661 = (state_15778[(16)]);
var inst_15675 = (state_15778[(2)]);
var inst_15676 = (inst_15662 + (1));
var tmp15790 = inst_15660;
var tmp15791 = inst_15659;
var tmp15792 = inst_15661;
var inst_15659__$1 = tmp15791;
var inst_15660__$1 = tmp15790;
var inst_15661__$1 = tmp15792;
var inst_15662__$1 = inst_15676;
var state_15778__$1 = (function (){var statearr_15797 = state_15778;
(statearr_15797[(13)] = inst_15662__$1);

(statearr_15797[(14)] = inst_15660__$1);

(statearr_15797[(18)] = inst_15675);

(statearr_15797[(15)] = inst_15659__$1);

(statearr_15797[(16)] = inst_15661__$1);

return statearr_15797;
})();
var statearr_15798_15892 = state_15778__$1;
(statearr_15798_15892[(2)] = null);

(statearr_15798_15892[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15779 === (21))){
var inst_15700 = (state_15778[(2)]);
var state_15778__$1 = state_15778;
var statearr_15802_15893 = state_15778__$1;
(statearr_15802_15893[(2)] = inst_15700);

(statearr_15802_15893[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15779 === (31))){
var inst_15726 = (state_15778[(11)]);
var inst_15730 = done.call(null,null);
var inst_15731 = cljs.core.async.untap_STAR_.call(null,m,inst_15726);
var state_15778__$1 = (function (){var statearr_15803 = state_15778;
(statearr_15803[(19)] = inst_15730);

return statearr_15803;
})();
var statearr_15804_15894 = state_15778__$1;
(statearr_15804_15894[(2)] = inst_15731);

(statearr_15804_15894[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15779 === (32))){
var inst_15721 = (state_15778[(9)]);
var inst_15719 = (state_15778[(10)]);
var inst_15720 = (state_15778[(20)]);
var inst_15718 = (state_15778[(21)]);
var inst_15733 = (state_15778[(2)]);
var inst_15734 = (inst_15721 + (1));
var tmp15799 = inst_15719;
var tmp15800 = inst_15720;
var tmp15801 = inst_15718;
var inst_15718__$1 = tmp15801;
var inst_15719__$1 = tmp15799;
var inst_15720__$1 = tmp15800;
var inst_15721__$1 = inst_15734;
var state_15778__$1 = (function (){var statearr_15805 = state_15778;
(statearr_15805[(9)] = inst_15721__$1);

(statearr_15805[(10)] = inst_15719__$1);

(statearr_15805[(22)] = inst_15733);

(statearr_15805[(20)] = inst_15720__$1);

(statearr_15805[(21)] = inst_15718__$1);

return statearr_15805;
})();
var statearr_15806_15900 = state_15778__$1;
(statearr_15806_15900[(2)] = null);

(statearr_15806_15900[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15779 === (40))){
var inst_15746 = (state_15778[(23)]);
var inst_15750 = done.call(null,null);
var inst_15751 = cljs.core.async.untap_STAR_.call(null,m,inst_15746);
var state_15778__$1 = (function (){var statearr_15807 = state_15778;
(statearr_15807[(24)] = inst_15750);

return statearr_15807;
})();
var statearr_15808_15902 = state_15778__$1;
(statearr_15808_15902[(2)] = inst_15751);

(statearr_15808_15902[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15779 === (33))){
var inst_15737 = (state_15778[(25)]);
var inst_15739 = cljs.core.chunked_seq_QMARK_.call(null,inst_15737);
var state_15778__$1 = state_15778;
if(inst_15739){
var statearr_15809_15903 = state_15778__$1;
(statearr_15809_15903[(1)] = (36));

} else {
var statearr_15810_15904 = state_15778__$1;
(statearr_15810_15904[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15779 === (13))){
var inst_15669 = (state_15778[(26)]);
var inst_15672 = cljs.core.async.close_BANG_.call(null,inst_15669);
var state_15778__$1 = state_15778;
var statearr_15811_15905 = state_15778__$1;
(statearr_15811_15905[(2)] = inst_15672);

(statearr_15811_15905[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15779 === (22))){
var inst_15690 = (state_15778[(8)]);
var inst_15693 = cljs.core.async.close_BANG_.call(null,inst_15690);
var state_15778__$1 = state_15778;
var statearr_15812_15909 = state_15778__$1;
(statearr_15812_15909[(2)] = inst_15693);

(statearr_15812_15909[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15779 === (36))){
var inst_15737 = (state_15778[(25)]);
var inst_15741 = cljs.core.chunk_first.call(null,inst_15737);
var inst_15742 = cljs.core.chunk_rest.call(null,inst_15737);
var inst_15743 = cljs.core.count.call(null,inst_15741);
var inst_15718 = inst_15742;
var inst_15719 = inst_15741;
var inst_15720 = inst_15743;
var inst_15721 = (0);
var state_15778__$1 = (function (){var statearr_15813 = state_15778;
(statearr_15813[(9)] = inst_15721);

(statearr_15813[(10)] = inst_15719);

(statearr_15813[(20)] = inst_15720);

(statearr_15813[(21)] = inst_15718);

return statearr_15813;
})();
var statearr_15815_15910 = state_15778__$1;
(statearr_15815_15910[(2)] = null);

(statearr_15815_15910[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15779 === (41))){
var inst_15737 = (state_15778[(25)]);
var inst_15753 = (state_15778[(2)]);
var inst_15754 = cljs.core.next.call(null,inst_15737);
var inst_15718 = inst_15754;
var inst_15719 = null;
var inst_15720 = (0);
var inst_15721 = (0);
var state_15778__$1 = (function (){var statearr_15817 = state_15778;
(statearr_15817[(9)] = inst_15721);

(statearr_15817[(10)] = inst_15719);

(statearr_15817[(27)] = inst_15753);

(statearr_15817[(20)] = inst_15720);

(statearr_15817[(21)] = inst_15718);

return statearr_15817;
})();
var statearr_15818_15912 = state_15778__$1;
(statearr_15818_15912[(2)] = null);

(statearr_15818_15912[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15779 === (43))){
var state_15778__$1 = state_15778;
var statearr_15819_15913 = state_15778__$1;
(statearr_15819_15913[(2)] = null);

(statearr_15819_15913[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15779 === (29))){
var inst_15762 = (state_15778[(2)]);
var state_15778__$1 = state_15778;
var statearr_15820_15914 = state_15778__$1;
(statearr_15820_15914[(2)] = inst_15762);

(statearr_15820_15914[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15779 === (44))){
var inst_15771 = (state_15778[(2)]);
var state_15778__$1 = (function (){var statearr_15821 = state_15778;
(statearr_15821[(28)] = inst_15771);

return statearr_15821;
})();
var statearr_15822_15915 = state_15778__$1;
(statearr_15822_15915[(2)] = null);

(statearr_15822_15915[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15779 === (6))){
var inst_15710 = (state_15778[(29)]);
var inst_15709 = cljs.core.deref.call(null,cs);
var inst_15710__$1 = cljs.core.keys.call(null,inst_15709);
var inst_15711 = cljs.core.count.call(null,inst_15710__$1);
var inst_15712 = cljs.core.reset_BANG_.call(null,dctr,inst_15711);
var inst_15717 = cljs.core.seq.call(null,inst_15710__$1);
var inst_15718 = inst_15717;
var inst_15719 = null;
var inst_15720 = (0);
var inst_15721 = (0);
var state_15778__$1 = (function (){var statearr_15823 = state_15778;
(statearr_15823[(9)] = inst_15721);

(statearr_15823[(10)] = inst_15719);

(statearr_15823[(20)] = inst_15720);

(statearr_15823[(21)] = inst_15718);

(statearr_15823[(29)] = inst_15710__$1);

(statearr_15823[(30)] = inst_15712);

return statearr_15823;
})();
var statearr_15824_15916 = state_15778__$1;
(statearr_15824_15916[(2)] = null);

(statearr_15824_15916[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15779 === (28))){
var inst_15737 = (state_15778[(25)]);
var inst_15718 = (state_15778[(21)]);
var inst_15737__$1 = cljs.core.seq.call(null,inst_15718);
var state_15778__$1 = (function (){var statearr_15825 = state_15778;
(statearr_15825[(25)] = inst_15737__$1);

return statearr_15825;
})();
if(inst_15737__$1){
var statearr_15826_15917 = state_15778__$1;
(statearr_15826_15917[(1)] = (33));

} else {
var statearr_15828_15918 = state_15778__$1;
(statearr_15828_15918[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15779 === (25))){
var inst_15721 = (state_15778[(9)]);
var inst_15720 = (state_15778[(20)]);
var inst_15723 = (inst_15721 < inst_15720);
var inst_15724 = inst_15723;
var state_15778__$1 = state_15778;
if(cljs.core.truth_(inst_15724)){
var statearr_15830_15919 = state_15778__$1;
(statearr_15830_15919[(1)] = (27));

} else {
var statearr_15831_15920 = state_15778__$1;
(statearr_15831_15920[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15779 === (34))){
var state_15778__$1 = state_15778;
var statearr_15832_15921 = state_15778__$1;
(statearr_15832_15921[(2)] = null);

(statearr_15832_15921[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15779 === (17))){
var state_15778__$1 = state_15778;
var statearr_15833_15922 = state_15778__$1;
(statearr_15833_15922[(2)] = null);

(statearr_15833_15922[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15779 === (3))){
var inst_15776 = (state_15778[(2)]);
var state_15778__$1 = state_15778;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15778__$1,inst_15776);
} else {
if((state_val_15779 === (12))){
var inst_15705 = (state_15778[(2)]);
var state_15778__$1 = state_15778;
var statearr_15834_15923 = state_15778__$1;
(statearr_15834_15923[(2)] = inst_15705);

(statearr_15834_15923[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15779 === (2))){
var state_15778__$1 = state_15778;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15778__$1,(4),ch);
} else {
if((state_val_15779 === (23))){
var state_15778__$1 = state_15778;
var statearr_15835_15924 = state_15778__$1;
(statearr_15835_15924[(2)] = null);

(statearr_15835_15924[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15779 === (35))){
var inst_15760 = (state_15778[(2)]);
var state_15778__$1 = state_15778;
var statearr_15836_15925 = state_15778__$1;
(statearr_15836_15925[(2)] = inst_15760);

(statearr_15836_15925[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15779 === (19))){
var inst_15679 = (state_15778[(7)]);
var inst_15683 = cljs.core.chunk_first.call(null,inst_15679);
var inst_15684 = cljs.core.chunk_rest.call(null,inst_15679);
var inst_15685 = cljs.core.count.call(null,inst_15683);
var inst_15659 = inst_15684;
var inst_15660 = inst_15683;
var inst_15661 = inst_15685;
var inst_15662 = (0);
var state_15778__$1 = (function (){var statearr_15837 = state_15778;
(statearr_15837[(13)] = inst_15662);

(statearr_15837[(14)] = inst_15660);

(statearr_15837[(15)] = inst_15659);

(statearr_15837[(16)] = inst_15661);

return statearr_15837;
})();
var statearr_15838_15926 = state_15778__$1;
(statearr_15838_15926[(2)] = null);

(statearr_15838_15926[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15779 === (11))){
var inst_15659 = (state_15778[(15)]);
var inst_15679 = (state_15778[(7)]);
var inst_15679__$1 = cljs.core.seq.call(null,inst_15659);
var state_15778__$1 = (function (){var statearr_15839 = state_15778;
(statearr_15839[(7)] = inst_15679__$1);

return statearr_15839;
})();
if(inst_15679__$1){
var statearr_15840_15932 = state_15778__$1;
(statearr_15840_15932[(1)] = (16));

} else {
var statearr_15841_15933 = state_15778__$1;
(statearr_15841_15933[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15779 === (9))){
var inst_15707 = (state_15778[(2)]);
var state_15778__$1 = state_15778;
var statearr_15842_15934 = state_15778__$1;
(statearr_15842_15934[(2)] = inst_15707);

(statearr_15842_15934[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15779 === (5))){
var inst_15657 = cljs.core.deref.call(null,cs);
var inst_15658 = cljs.core.seq.call(null,inst_15657);
var inst_15659 = inst_15658;
var inst_15660 = null;
var inst_15661 = (0);
var inst_15662 = (0);
var state_15778__$1 = (function (){var statearr_15843 = state_15778;
(statearr_15843[(13)] = inst_15662);

(statearr_15843[(14)] = inst_15660);

(statearr_15843[(15)] = inst_15659);

(statearr_15843[(16)] = inst_15661);

return statearr_15843;
})();
var statearr_15844_15936 = state_15778__$1;
(statearr_15844_15936[(2)] = null);

(statearr_15844_15936[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15779 === (14))){
var state_15778__$1 = state_15778;
var statearr_15845_15937 = state_15778__$1;
(statearr_15845_15937[(2)] = null);

(statearr_15845_15937[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15779 === (45))){
var inst_15768 = (state_15778[(2)]);
var state_15778__$1 = state_15778;
var statearr_15846_15938 = state_15778__$1;
(statearr_15846_15938[(2)] = inst_15768);

(statearr_15846_15938[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15779 === (26))){
var inst_15710 = (state_15778[(29)]);
var inst_15764 = (state_15778[(2)]);
var inst_15765 = cljs.core.seq.call(null,inst_15710);
var state_15778__$1 = (function (){var statearr_15847 = state_15778;
(statearr_15847[(31)] = inst_15764);

return statearr_15847;
})();
if(inst_15765){
var statearr_15848_15942 = state_15778__$1;
(statearr_15848_15942[(1)] = (42));

} else {
var statearr_15849_15943 = state_15778__$1;
(statearr_15849_15943[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15779 === (16))){
var inst_15679 = (state_15778[(7)]);
var inst_15681 = cljs.core.chunked_seq_QMARK_.call(null,inst_15679);
var state_15778__$1 = state_15778;
if(inst_15681){
var statearr_15850_15944 = state_15778__$1;
(statearr_15850_15944[(1)] = (19));

} else {
var statearr_15851_15945 = state_15778__$1;
(statearr_15851_15945[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15779 === (38))){
var inst_15757 = (state_15778[(2)]);
var state_15778__$1 = state_15778;
var statearr_15852_15946 = state_15778__$1;
(statearr_15852_15946[(2)] = inst_15757);

(statearr_15852_15946[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15779 === (30))){
var state_15778__$1 = state_15778;
var statearr_15853_15947 = state_15778__$1;
(statearr_15853_15947[(2)] = null);

(statearr_15853_15947[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15779 === (10))){
var inst_15662 = (state_15778[(13)]);
var inst_15660 = (state_15778[(14)]);
var inst_15668 = cljs.core._nth.call(null,inst_15660,inst_15662);
var inst_15669 = cljs.core.nth.call(null,inst_15668,(0),null);
var inst_15670 = cljs.core.nth.call(null,inst_15668,(1),null);
var state_15778__$1 = (function (){var statearr_15857 = state_15778;
(statearr_15857[(26)] = inst_15669);

return statearr_15857;
})();
if(cljs.core.truth_(inst_15670)){
var statearr_15858_15949 = state_15778__$1;
(statearr_15858_15949[(1)] = (13));

} else {
var statearr_15859_15950 = state_15778__$1;
(statearr_15859_15950[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15779 === (18))){
var inst_15703 = (state_15778[(2)]);
var state_15778__$1 = state_15778;
var statearr_15860_15951 = state_15778__$1;
(statearr_15860_15951[(2)] = inst_15703);

(statearr_15860_15951[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15779 === (42))){
var state_15778__$1 = state_15778;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15778__$1,(45),dchan);
} else {
if((state_val_15779 === (37))){
var inst_15737 = (state_15778[(25)]);
var inst_15746 = (state_15778[(23)]);
var inst_15650 = (state_15778[(12)]);
var inst_15746__$1 = cljs.core.first.call(null,inst_15737);
var inst_15747 = cljs.core.async.put_BANG_.call(null,inst_15746__$1,inst_15650,done);
var state_15778__$1 = (function (){var statearr_15861 = state_15778;
(statearr_15861[(23)] = inst_15746__$1);

return statearr_15861;
})();
if(cljs.core.truth_(inst_15747)){
var statearr_15862_15952 = state_15778__$1;
(statearr_15862_15952[(1)] = (39));

} else {
var statearr_15863_15953 = state_15778__$1;
(statearr_15863_15953[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15779 === (8))){
var inst_15662 = (state_15778[(13)]);
var inst_15661 = (state_15778[(16)]);
var inst_15664 = (inst_15662 < inst_15661);
var inst_15665 = inst_15664;
var state_15778__$1 = state_15778;
if(cljs.core.truth_(inst_15665)){
var statearr_15864_15954 = state_15778__$1;
(statearr_15864_15954[(1)] = (10));

} else {
var statearr_15865_15955 = state_15778__$1;
(statearr_15865_15955[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14378__auto___15880,cs,m,dchan,dctr,done))
;
return ((function (switch__14236__auto__,c__14378__auto___15880,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__14237__auto__ = null;
var cljs$core$async$mult_$_state_machine__14237__auto____0 = (function (){
var statearr_15869 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15869[(0)] = cljs$core$async$mult_$_state_machine__14237__auto__);

(statearr_15869[(1)] = (1));

return statearr_15869;
});
var cljs$core$async$mult_$_state_machine__14237__auto____1 = (function (state_15778){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_15778);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e15870){if((e15870 instanceof Object)){
var ex__14240__auto__ = e15870;
var statearr_15871_15956 = state_15778;
(statearr_15871_15956[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15778);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15870;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15957 = state_15778;
state_15778 = G__15957;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__14237__auto__ = function(state_15778){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__14237__auto____1.call(this,state_15778);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__14237__auto____0;
cljs$core$async$mult_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__14237__auto____1;
return cljs$core$async$mult_$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14378__auto___15880,cs,m,dchan,dctr,done))
})();
var state__14380__auto__ = (function (){var statearr_15872 = f__14379__auto__.call(null);
(statearr_15872[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14378__auto___15880);

return statearr_15872;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14380__auto__);
});})(c__14378__auto___15880,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args15958 = [];
var len__7107__auto___15961 = arguments.length;
var i__7108__auto___15962 = (0);
while(true){
if((i__7108__auto___15962 < len__7107__auto___15961)){
args15958.push((arguments[i__7108__auto___15962]));

var G__15963 = (i__7108__auto___15962 + (1));
i__7108__auto___15962 = G__15963;
continue;
} else {
}
break;
}

var G__15960 = args15958.length;
switch (G__15960) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15958.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,ch);
} else {
var m__6705__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,ch);
} else {
var m__6705__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m);
} else {
var m__6705__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,state_map);
} else {
var m__6705__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,mode);
} else {
var m__6705__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__7114__auto__ = [];
var len__7107__auto___15992 = arguments.length;
var i__7108__auto___15993 = (0);
while(true){
if((i__7108__auto___15993 < len__7107__auto___15992)){
args__7114__auto__.push((arguments[i__7108__auto___15993]));

var G__15994 = (i__7108__auto___15993 + (1));
i__7108__auto___15993 = G__15994;
continue;
} else {
}
break;
}

var argseq__7115__auto__ = ((((3) < args__7114__auto__.length))?(new cljs.core.IndexedSeq(args__7114__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7115__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__15986){
var map__15987 = p__15986;
var map__15987__$1 = ((((!((map__15987 == null)))?((((map__15987.cljs$lang$protocol_mask$partition0$ & (64))) || (map__15987.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__15987):map__15987);
var opts = map__15987__$1;
var statearr_15989_15995 = state;
(statearr_15989_15995[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__15987,map__15987__$1,opts){
return (function (val){
var statearr_15990_15996 = state;
(statearr_15990_15996[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__15987,map__15987__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_15991_15997 = state;
(statearr_15991_15997[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq15982){
var G__15983 = cljs.core.first.call(null,seq15982);
var seq15982__$1 = cljs.core.next.call(null,seq15982);
var G__15984 = cljs.core.first.call(null,seq15982__$1);
var seq15982__$2 = cljs.core.next.call(null,seq15982__$1);
var G__15985 = cljs.core.first.call(null,seq15982__$2);
var seq15982__$3 = cljs.core.next.call(null,seq15982__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__15983,G__15984,G__15985,seq15982__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async16170 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16170 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta16171){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta16171 = meta16171;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16170.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_16172,meta16171__$1){
var self__ = this;
var _16172__$1 = this;
return (new cljs.core.async.t_cljs$core$async16170(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta16171__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16170.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_16172){
var self__ = this;
var _16172__$1 = this;
return self__.meta16171;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16170.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async16170.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16170.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async16170.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16170.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16170.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16170.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16170.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16170.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta16171","meta16171",-821726449,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16170.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16170.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16170";

cljs.core.async.t_cljs$core$async16170.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16170");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async16170 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async16170(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta16171){
return (new cljs.core.async.t_cljs$core$async16170(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta16171));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async16170(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__14378__auto___16354 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14378__auto___16354,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__14379__auto__ = (function (){var switch__14236__auto__ = ((function (c__14378__auto___16354,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_16273){
var state_val_16274 = (state_16273[(1)]);
if((state_val_16274 === (7))){
var inst_16188 = (state_16273[(2)]);
var state_16273__$1 = state_16273;
var statearr_16275_16355 = state_16273__$1;
(statearr_16275_16355[(2)] = inst_16188);

(statearr_16275_16355[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16274 === (20))){
var inst_16200 = (state_16273[(7)]);
var state_16273__$1 = state_16273;
var statearr_16276_16356 = state_16273__$1;
(statearr_16276_16356[(2)] = inst_16200);

(statearr_16276_16356[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16274 === (27))){
var state_16273__$1 = state_16273;
var statearr_16277_16357 = state_16273__$1;
(statearr_16277_16357[(2)] = null);

(statearr_16277_16357[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16274 === (1))){
var inst_16176 = (state_16273[(8)]);
var inst_16176__$1 = calc_state.call(null);
var inst_16178 = (inst_16176__$1 == null);
var inst_16179 = cljs.core.not.call(null,inst_16178);
var state_16273__$1 = (function (){var statearr_16278 = state_16273;
(statearr_16278[(8)] = inst_16176__$1);

return statearr_16278;
})();
if(inst_16179){
var statearr_16279_16358 = state_16273__$1;
(statearr_16279_16358[(1)] = (2));

} else {
var statearr_16280_16359 = state_16273__$1;
(statearr_16280_16359[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16274 === (24))){
var inst_16223 = (state_16273[(9)]);
var inst_16244 = (state_16273[(10)]);
var inst_16230 = (state_16273[(11)]);
var inst_16244__$1 = inst_16223.call(null,inst_16230);
var state_16273__$1 = (function (){var statearr_16281 = state_16273;
(statearr_16281[(10)] = inst_16244__$1);

return statearr_16281;
})();
if(cljs.core.truth_(inst_16244__$1)){
var statearr_16282_16360 = state_16273__$1;
(statearr_16282_16360[(1)] = (29));

} else {
var statearr_16283_16363 = state_16273__$1;
(statearr_16283_16363[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16274 === (4))){
var inst_16191 = (state_16273[(2)]);
var state_16273__$1 = state_16273;
if(cljs.core.truth_(inst_16191)){
var statearr_16284_16364 = state_16273__$1;
(statearr_16284_16364[(1)] = (8));

} else {
var statearr_16285_16365 = state_16273__$1;
(statearr_16285_16365[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16274 === (15))){
var inst_16217 = (state_16273[(2)]);
var state_16273__$1 = state_16273;
if(cljs.core.truth_(inst_16217)){
var statearr_16286_16366 = state_16273__$1;
(statearr_16286_16366[(1)] = (19));

} else {
var statearr_16287_16367 = state_16273__$1;
(statearr_16287_16367[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16274 === (21))){
var inst_16222 = (state_16273[(12)]);
var inst_16222__$1 = (state_16273[(2)]);
var inst_16223 = cljs.core.get.call(null,inst_16222__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_16224 = cljs.core.get.call(null,inst_16222__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_16225 = cljs.core.get.call(null,inst_16222__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_16273__$1 = (function (){var statearr_16288 = state_16273;
(statearr_16288[(12)] = inst_16222__$1);

(statearr_16288[(9)] = inst_16223);

(statearr_16288[(13)] = inst_16224);

return statearr_16288;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_16273__$1,(22),inst_16225);
} else {
if((state_val_16274 === (31))){
var inst_16255 = (state_16273[(2)]);
var state_16273__$1 = state_16273;
if(cljs.core.truth_(inst_16255)){
var statearr_16289_16368 = state_16273__$1;
(statearr_16289_16368[(1)] = (32));

} else {
var statearr_16290_16369 = state_16273__$1;
(statearr_16290_16369[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16274 === (32))){
var inst_16229 = (state_16273[(14)]);
var state_16273__$1 = state_16273;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16273__$1,(35),out,inst_16229);
} else {
if((state_val_16274 === (33))){
var inst_16222 = (state_16273[(12)]);
var inst_16200 = inst_16222;
var state_16273__$1 = (function (){var statearr_16291 = state_16273;
(statearr_16291[(7)] = inst_16200);

return statearr_16291;
})();
var statearr_16292_16375 = state_16273__$1;
(statearr_16292_16375[(2)] = null);

(statearr_16292_16375[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16274 === (13))){
var inst_16200 = (state_16273[(7)]);
var inst_16207 = inst_16200.cljs$lang$protocol_mask$partition0$;
var inst_16208 = (inst_16207 & (64));
var inst_16209 = inst_16200.cljs$core$ISeq$;
var inst_16210 = (inst_16208) || (inst_16209);
var state_16273__$1 = state_16273;
if(cljs.core.truth_(inst_16210)){
var statearr_16294_16376 = state_16273__$1;
(statearr_16294_16376[(1)] = (16));

} else {
var statearr_16295_16377 = state_16273__$1;
(statearr_16295_16377[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16274 === (22))){
var inst_16229 = (state_16273[(14)]);
var inst_16230 = (state_16273[(11)]);
var inst_16228 = (state_16273[(2)]);
var inst_16229__$1 = cljs.core.nth.call(null,inst_16228,(0),null);
var inst_16230__$1 = cljs.core.nth.call(null,inst_16228,(1),null);
var inst_16231 = (inst_16229__$1 == null);
var inst_16232 = cljs.core._EQ_.call(null,inst_16230__$1,change);
var inst_16233 = (inst_16231) || (inst_16232);
var state_16273__$1 = (function (){var statearr_16296 = state_16273;
(statearr_16296[(14)] = inst_16229__$1);

(statearr_16296[(11)] = inst_16230__$1);

return statearr_16296;
})();
if(cljs.core.truth_(inst_16233)){
var statearr_16297_16378 = state_16273__$1;
(statearr_16297_16378[(1)] = (23));

} else {
var statearr_16298_16379 = state_16273__$1;
(statearr_16298_16379[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16274 === (36))){
var inst_16222 = (state_16273[(12)]);
var inst_16200 = inst_16222;
var state_16273__$1 = (function (){var statearr_16299 = state_16273;
(statearr_16299[(7)] = inst_16200);

return statearr_16299;
})();
var statearr_16300_16380 = state_16273__$1;
(statearr_16300_16380[(2)] = null);

(statearr_16300_16380[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16274 === (29))){
var inst_16244 = (state_16273[(10)]);
var state_16273__$1 = state_16273;
var statearr_16301_16381 = state_16273__$1;
(statearr_16301_16381[(2)] = inst_16244);

(statearr_16301_16381[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16274 === (6))){
var state_16273__$1 = state_16273;
var statearr_16302_16384 = state_16273__$1;
(statearr_16302_16384[(2)] = false);

(statearr_16302_16384[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16274 === (28))){
var inst_16240 = (state_16273[(2)]);
var inst_16241 = calc_state.call(null);
var inst_16200 = inst_16241;
var state_16273__$1 = (function (){var statearr_16303 = state_16273;
(statearr_16303[(7)] = inst_16200);

(statearr_16303[(15)] = inst_16240);

return statearr_16303;
})();
var statearr_16304_16387 = state_16273__$1;
(statearr_16304_16387[(2)] = null);

(statearr_16304_16387[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16274 === (25))){
var inst_16269 = (state_16273[(2)]);
var state_16273__$1 = state_16273;
var statearr_16305_16388 = state_16273__$1;
(statearr_16305_16388[(2)] = inst_16269);

(statearr_16305_16388[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16274 === (34))){
var inst_16267 = (state_16273[(2)]);
var state_16273__$1 = state_16273;
var statearr_16306_16389 = state_16273__$1;
(statearr_16306_16389[(2)] = inst_16267);

(statearr_16306_16389[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16274 === (17))){
var state_16273__$1 = state_16273;
var statearr_16307_16390 = state_16273__$1;
(statearr_16307_16390[(2)] = false);

(statearr_16307_16390[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16274 === (3))){
var state_16273__$1 = state_16273;
var statearr_16308_16394 = state_16273__$1;
(statearr_16308_16394[(2)] = false);

(statearr_16308_16394[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16274 === (12))){
var inst_16271 = (state_16273[(2)]);
var state_16273__$1 = state_16273;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16273__$1,inst_16271);
} else {
if((state_val_16274 === (2))){
var inst_16176 = (state_16273[(8)]);
var inst_16181 = inst_16176.cljs$lang$protocol_mask$partition0$;
var inst_16182 = (inst_16181 & (64));
var inst_16183 = inst_16176.cljs$core$ISeq$;
var inst_16184 = (inst_16182) || (inst_16183);
var state_16273__$1 = state_16273;
if(cljs.core.truth_(inst_16184)){
var statearr_16309_16395 = state_16273__$1;
(statearr_16309_16395[(1)] = (5));

} else {
var statearr_16310_16396 = state_16273__$1;
(statearr_16310_16396[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16274 === (23))){
var inst_16229 = (state_16273[(14)]);
var inst_16235 = (inst_16229 == null);
var state_16273__$1 = state_16273;
if(cljs.core.truth_(inst_16235)){
var statearr_16311_16397 = state_16273__$1;
(statearr_16311_16397[(1)] = (26));

} else {
var statearr_16312_16398 = state_16273__$1;
(statearr_16312_16398[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16274 === (35))){
var inst_16258 = (state_16273[(2)]);
var state_16273__$1 = state_16273;
if(cljs.core.truth_(inst_16258)){
var statearr_16313_16400 = state_16273__$1;
(statearr_16313_16400[(1)] = (36));

} else {
var statearr_16314_16401 = state_16273__$1;
(statearr_16314_16401[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16274 === (19))){
var inst_16200 = (state_16273[(7)]);
var inst_16219 = cljs.core.apply.call(null,cljs.core.hash_map,inst_16200);
var state_16273__$1 = state_16273;
var statearr_16315_16402 = state_16273__$1;
(statearr_16315_16402[(2)] = inst_16219);

(statearr_16315_16402[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16274 === (11))){
var inst_16200 = (state_16273[(7)]);
var inst_16204 = (inst_16200 == null);
var inst_16205 = cljs.core.not.call(null,inst_16204);
var state_16273__$1 = state_16273;
if(inst_16205){
var statearr_16316_16403 = state_16273__$1;
(statearr_16316_16403[(1)] = (13));

} else {
var statearr_16317_16404 = state_16273__$1;
(statearr_16317_16404[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16274 === (9))){
var inst_16176 = (state_16273[(8)]);
var state_16273__$1 = state_16273;
var statearr_16318_16405 = state_16273__$1;
(statearr_16318_16405[(2)] = inst_16176);

(statearr_16318_16405[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16274 === (5))){
var state_16273__$1 = state_16273;
var statearr_16319_16406 = state_16273__$1;
(statearr_16319_16406[(2)] = true);

(statearr_16319_16406[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16274 === (14))){
var state_16273__$1 = state_16273;
var statearr_16320_16407 = state_16273__$1;
(statearr_16320_16407[(2)] = false);

(statearr_16320_16407[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16274 === (26))){
var inst_16230 = (state_16273[(11)]);
var inst_16237 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_16230);
var state_16273__$1 = state_16273;
var statearr_16321_16408 = state_16273__$1;
(statearr_16321_16408[(2)] = inst_16237);

(statearr_16321_16408[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16274 === (16))){
var state_16273__$1 = state_16273;
var statearr_16322_16409 = state_16273__$1;
(statearr_16322_16409[(2)] = true);

(statearr_16322_16409[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16274 === (38))){
var inst_16263 = (state_16273[(2)]);
var state_16273__$1 = state_16273;
var statearr_16323_16410 = state_16273__$1;
(statearr_16323_16410[(2)] = inst_16263);

(statearr_16323_16410[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16274 === (30))){
var inst_16223 = (state_16273[(9)]);
var inst_16230 = (state_16273[(11)]);
var inst_16224 = (state_16273[(13)]);
var inst_16250 = cljs.core.empty_QMARK_.call(null,inst_16223);
var inst_16251 = inst_16224.call(null,inst_16230);
var inst_16252 = cljs.core.not.call(null,inst_16251);
var inst_16253 = (inst_16250) && (inst_16252);
var state_16273__$1 = state_16273;
var statearr_16324_16411 = state_16273__$1;
(statearr_16324_16411[(2)] = inst_16253);

(statearr_16324_16411[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16274 === (10))){
var inst_16176 = (state_16273[(8)]);
var inst_16196 = (state_16273[(2)]);
var inst_16197 = cljs.core.get.call(null,inst_16196,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_16198 = cljs.core.get.call(null,inst_16196,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_16199 = cljs.core.get.call(null,inst_16196,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_16200 = inst_16176;
var state_16273__$1 = (function (){var statearr_16325 = state_16273;
(statearr_16325[(7)] = inst_16200);

(statearr_16325[(16)] = inst_16199);

(statearr_16325[(17)] = inst_16197);

(statearr_16325[(18)] = inst_16198);

return statearr_16325;
})();
var statearr_16326_16412 = state_16273__$1;
(statearr_16326_16412[(2)] = null);

(statearr_16326_16412[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16274 === (18))){
var inst_16214 = (state_16273[(2)]);
var state_16273__$1 = state_16273;
var statearr_16327_16413 = state_16273__$1;
(statearr_16327_16413[(2)] = inst_16214);

(statearr_16327_16413[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16274 === (37))){
var state_16273__$1 = state_16273;
var statearr_16328_16414 = state_16273__$1;
(statearr_16328_16414[(2)] = null);

(statearr_16328_16414[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16274 === (8))){
var inst_16176 = (state_16273[(8)]);
var inst_16193 = cljs.core.apply.call(null,cljs.core.hash_map,inst_16176);
var state_16273__$1 = state_16273;
var statearr_16329_16415 = state_16273__$1;
(statearr_16329_16415[(2)] = inst_16193);

(statearr_16329_16415[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14378__auto___16354,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__14236__auto__,c__14378__auto___16354,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__14237__auto__ = null;
var cljs$core$async$mix_$_state_machine__14237__auto____0 = (function (){
var statearr_16333 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16333[(0)] = cljs$core$async$mix_$_state_machine__14237__auto__);

(statearr_16333[(1)] = (1));

return statearr_16333;
});
var cljs$core$async$mix_$_state_machine__14237__auto____1 = (function (state_16273){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_16273);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e16334){if((e16334 instanceof Object)){
var ex__14240__auto__ = e16334;
var statearr_16335_16416 = state_16273;
(statearr_16335_16416[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16273);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16334;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16420 = state_16273;
state_16273 = G__16420;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__14237__auto__ = function(state_16273){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__14237__auto____1.call(this,state_16273);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__14237__auto____0;
cljs$core$async$mix_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__14237__auto____1;
return cljs$core$async$mix_$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14378__auto___16354,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__14380__auto__ = (function (){var statearr_16336 = f__14379__auto__.call(null);
(statearr_16336[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14378__auto___16354);

return statearr_16336;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14380__auto__);
});})(c__14378__auto___16354,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__6704__auto__ = (((p == null))?null:p);
var m__6705__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__6705__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__6704__auto__ = (((p == null))?null:p);
var m__6705__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,p,v,ch);
} else {
var m__6705__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args16423 = [];
var len__7107__auto___16430 = arguments.length;
var i__7108__auto___16431 = (0);
while(true){
if((i__7108__auto___16431 < len__7107__auto___16430)){
args16423.push((arguments[i__7108__auto___16431]));

var G__16432 = (i__7108__auto___16431 + (1));
i__7108__auto___16431 = G__16432;
continue;
} else {
}
break;
}

var G__16428 = args16423.length;
switch (G__16428) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16423.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__6704__auto__ = (((p == null))?null:p);
var m__6705__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,p);
} else {
var m__6705__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__6704__auto__ = (((p == null))?null:p);
var m__6705__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,p,v);
} else {
var m__6705__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args16439 = [];
var len__7107__auto___16573 = arguments.length;
var i__7108__auto___16574 = (0);
while(true){
if((i__7108__auto___16574 < len__7107__auto___16573)){
args16439.push((arguments[i__7108__auto___16574]));

var G__16575 = (i__7108__auto___16574 + (1));
i__7108__auto___16574 = G__16575;
continue;
} else {
}
break;
}

var G__16441 = args16439.length;
switch (G__16441) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16439.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__6049__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__6049__auto__)){
return or__6049__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__6049__auto__,mults){
return (function (p1__16438_SHARP_){
if(cljs.core.truth_(p1__16438_SHARP_.call(null,topic))){
return p1__16438_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__16438_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__6049__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async16442 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16442 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta16443){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta16443 = meta16443;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16442.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_16444,meta16443__$1){
var self__ = this;
var _16444__$1 = this;
return (new cljs.core.async.t_cljs$core$async16442(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta16443__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16442.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_16444){
var self__ = this;
var _16444__$1 = this;
return self__.meta16443;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16442.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async16442.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16442.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async16442.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16442.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16442.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16442.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16442.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta16443","meta16443",-1659473467,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16442.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16442.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16442";

cljs.core.async.t_cljs$core$async16442.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16442");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async16442 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async16442(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta16443){
return (new cljs.core.async.t_cljs$core$async16442(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta16443));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async16442(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__14378__auto___16586 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14378__auto___16586,mults,ensure_mult,p){
return (function (){
var f__14379__auto__ = (function (){var switch__14236__auto__ = ((function (c__14378__auto___16586,mults,ensure_mult,p){
return (function (state_16524){
var state_val_16525 = (state_16524[(1)]);
if((state_val_16525 === (7))){
var inst_16516 = (state_16524[(2)]);
var state_16524__$1 = state_16524;
var statearr_16526_16588 = state_16524__$1;
(statearr_16526_16588[(2)] = inst_16516);

(statearr_16526_16588[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (20))){
var state_16524__$1 = state_16524;
var statearr_16527_16589 = state_16524__$1;
(statearr_16527_16589[(2)] = null);

(statearr_16527_16589[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (1))){
var state_16524__$1 = state_16524;
var statearr_16528_16590 = state_16524__$1;
(statearr_16528_16590[(2)] = null);

(statearr_16528_16590[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (24))){
var inst_16499 = (state_16524[(7)]);
var inst_16508 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_16499);
var state_16524__$1 = state_16524;
var statearr_16529_16591 = state_16524__$1;
(statearr_16529_16591[(2)] = inst_16508);

(statearr_16529_16591[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (4))){
var inst_16448 = (state_16524[(8)]);
var inst_16448__$1 = (state_16524[(2)]);
var inst_16449 = (inst_16448__$1 == null);
var state_16524__$1 = (function (){var statearr_16530 = state_16524;
(statearr_16530[(8)] = inst_16448__$1);

return statearr_16530;
})();
if(cljs.core.truth_(inst_16449)){
var statearr_16531_16595 = state_16524__$1;
(statearr_16531_16595[(1)] = (5));

} else {
var statearr_16532_16596 = state_16524__$1;
(statearr_16532_16596[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (15))){
var inst_16493 = (state_16524[(2)]);
var state_16524__$1 = state_16524;
var statearr_16533_16597 = state_16524__$1;
(statearr_16533_16597[(2)] = inst_16493);

(statearr_16533_16597[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (21))){
var inst_16513 = (state_16524[(2)]);
var state_16524__$1 = (function (){var statearr_16534 = state_16524;
(statearr_16534[(9)] = inst_16513);

return statearr_16534;
})();
var statearr_16535_16602 = state_16524__$1;
(statearr_16535_16602[(2)] = null);

(statearr_16535_16602[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (13))){
var inst_16475 = (state_16524[(10)]);
var inst_16477 = cljs.core.chunked_seq_QMARK_.call(null,inst_16475);
var state_16524__$1 = state_16524;
if(inst_16477){
var statearr_16536_16605 = state_16524__$1;
(statearr_16536_16605[(1)] = (16));

} else {
var statearr_16537_16606 = state_16524__$1;
(statearr_16537_16606[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (22))){
var inst_16505 = (state_16524[(2)]);
var state_16524__$1 = state_16524;
if(cljs.core.truth_(inst_16505)){
var statearr_16538_16608 = state_16524__$1;
(statearr_16538_16608[(1)] = (23));

} else {
var statearr_16539_16609 = state_16524__$1;
(statearr_16539_16609[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (6))){
var inst_16501 = (state_16524[(11)]);
var inst_16448 = (state_16524[(8)]);
var inst_16499 = (state_16524[(7)]);
var inst_16499__$1 = topic_fn.call(null,inst_16448);
var inst_16500 = cljs.core.deref.call(null,mults);
var inst_16501__$1 = cljs.core.get.call(null,inst_16500,inst_16499__$1);
var state_16524__$1 = (function (){var statearr_16540 = state_16524;
(statearr_16540[(11)] = inst_16501__$1);

(statearr_16540[(7)] = inst_16499__$1);

return statearr_16540;
})();
if(cljs.core.truth_(inst_16501__$1)){
var statearr_16541_16613 = state_16524__$1;
(statearr_16541_16613[(1)] = (19));

} else {
var statearr_16542_16614 = state_16524__$1;
(statearr_16542_16614[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (25))){
var inst_16510 = (state_16524[(2)]);
var state_16524__$1 = state_16524;
var statearr_16543_16615 = state_16524__$1;
(statearr_16543_16615[(2)] = inst_16510);

(statearr_16543_16615[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (17))){
var inst_16475 = (state_16524[(10)]);
var inst_16484 = cljs.core.first.call(null,inst_16475);
var inst_16485 = cljs.core.async.muxch_STAR_.call(null,inst_16484);
var inst_16486 = cljs.core.async.close_BANG_.call(null,inst_16485);
var inst_16487 = cljs.core.next.call(null,inst_16475);
var inst_16458 = inst_16487;
var inst_16459 = null;
var inst_16460 = (0);
var inst_16461 = (0);
var state_16524__$1 = (function (){var statearr_16544 = state_16524;
(statearr_16544[(12)] = inst_16461);

(statearr_16544[(13)] = inst_16460);

(statearr_16544[(14)] = inst_16458);

(statearr_16544[(15)] = inst_16486);

(statearr_16544[(16)] = inst_16459);

return statearr_16544;
})();
var statearr_16545_16617 = state_16524__$1;
(statearr_16545_16617[(2)] = null);

(statearr_16545_16617[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (3))){
var inst_16518 = (state_16524[(2)]);
var state_16524__$1 = state_16524;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16524__$1,inst_16518);
} else {
if((state_val_16525 === (12))){
var inst_16495 = (state_16524[(2)]);
var state_16524__$1 = state_16524;
var statearr_16546_16618 = state_16524__$1;
(statearr_16546_16618[(2)] = inst_16495);

(statearr_16546_16618[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (2))){
var state_16524__$1 = state_16524;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16524__$1,(4),ch);
} else {
if((state_val_16525 === (23))){
var state_16524__$1 = state_16524;
var statearr_16547_16619 = state_16524__$1;
(statearr_16547_16619[(2)] = null);

(statearr_16547_16619[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (19))){
var inst_16501 = (state_16524[(11)]);
var inst_16448 = (state_16524[(8)]);
var inst_16503 = cljs.core.async.muxch_STAR_.call(null,inst_16501);
var state_16524__$1 = state_16524;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16524__$1,(22),inst_16503,inst_16448);
} else {
if((state_val_16525 === (11))){
var inst_16475 = (state_16524[(10)]);
var inst_16458 = (state_16524[(14)]);
var inst_16475__$1 = cljs.core.seq.call(null,inst_16458);
var state_16524__$1 = (function (){var statearr_16548 = state_16524;
(statearr_16548[(10)] = inst_16475__$1);

return statearr_16548;
})();
if(inst_16475__$1){
var statearr_16549_16620 = state_16524__$1;
(statearr_16549_16620[(1)] = (13));

} else {
var statearr_16550_16621 = state_16524__$1;
(statearr_16550_16621[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (9))){
var inst_16497 = (state_16524[(2)]);
var state_16524__$1 = state_16524;
var statearr_16551_16622 = state_16524__$1;
(statearr_16551_16622[(2)] = inst_16497);

(statearr_16551_16622[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (5))){
var inst_16455 = cljs.core.deref.call(null,mults);
var inst_16456 = cljs.core.vals.call(null,inst_16455);
var inst_16457 = cljs.core.seq.call(null,inst_16456);
var inst_16458 = inst_16457;
var inst_16459 = null;
var inst_16460 = (0);
var inst_16461 = (0);
var state_16524__$1 = (function (){var statearr_16552 = state_16524;
(statearr_16552[(12)] = inst_16461);

(statearr_16552[(13)] = inst_16460);

(statearr_16552[(14)] = inst_16458);

(statearr_16552[(16)] = inst_16459);

return statearr_16552;
})();
var statearr_16553_16623 = state_16524__$1;
(statearr_16553_16623[(2)] = null);

(statearr_16553_16623[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (14))){
var state_16524__$1 = state_16524;
var statearr_16558_16624 = state_16524__$1;
(statearr_16558_16624[(2)] = null);

(statearr_16558_16624[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (16))){
var inst_16475 = (state_16524[(10)]);
var inst_16479 = cljs.core.chunk_first.call(null,inst_16475);
var inst_16480 = cljs.core.chunk_rest.call(null,inst_16475);
var inst_16481 = cljs.core.count.call(null,inst_16479);
var inst_16458 = inst_16480;
var inst_16459 = inst_16479;
var inst_16460 = inst_16481;
var inst_16461 = (0);
var state_16524__$1 = (function (){var statearr_16559 = state_16524;
(statearr_16559[(12)] = inst_16461);

(statearr_16559[(13)] = inst_16460);

(statearr_16559[(14)] = inst_16458);

(statearr_16559[(16)] = inst_16459);

return statearr_16559;
})();
var statearr_16560_16625 = state_16524__$1;
(statearr_16560_16625[(2)] = null);

(statearr_16560_16625[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (10))){
var inst_16461 = (state_16524[(12)]);
var inst_16460 = (state_16524[(13)]);
var inst_16458 = (state_16524[(14)]);
var inst_16459 = (state_16524[(16)]);
var inst_16466 = cljs.core._nth.call(null,inst_16459,inst_16461);
var inst_16467 = cljs.core.async.muxch_STAR_.call(null,inst_16466);
var inst_16468 = cljs.core.async.close_BANG_.call(null,inst_16467);
var inst_16469 = (inst_16461 + (1));
var tmp16554 = inst_16460;
var tmp16555 = inst_16458;
var tmp16556 = inst_16459;
var inst_16458__$1 = tmp16555;
var inst_16459__$1 = tmp16556;
var inst_16460__$1 = tmp16554;
var inst_16461__$1 = inst_16469;
var state_16524__$1 = (function (){var statearr_16561 = state_16524;
(statearr_16561[(12)] = inst_16461__$1);

(statearr_16561[(13)] = inst_16460__$1);

(statearr_16561[(14)] = inst_16458__$1);

(statearr_16561[(16)] = inst_16459__$1);

(statearr_16561[(17)] = inst_16468);

return statearr_16561;
})();
var statearr_16562_16626 = state_16524__$1;
(statearr_16562_16626[(2)] = null);

(statearr_16562_16626[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (18))){
var inst_16490 = (state_16524[(2)]);
var state_16524__$1 = state_16524;
var statearr_16563_16628 = state_16524__$1;
(statearr_16563_16628[(2)] = inst_16490);

(statearr_16563_16628[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16525 === (8))){
var inst_16461 = (state_16524[(12)]);
var inst_16460 = (state_16524[(13)]);
var inst_16463 = (inst_16461 < inst_16460);
var inst_16464 = inst_16463;
var state_16524__$1 = state_16524;
if(cljs.core.truth_(inst_16464)){
var statearr_16564_16629 = state_16524__$1;
(statearr_16564_16629[(1)] = (10));

} else {
var statearr_16565_16630 = state_16524__$1;
(statearr_16565_16630[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14378__auto___16586,mults,ensure_mult,p))
;
return ((function (switch__14236__auto__,c__14378__auto___16586,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_16569 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16569[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_16569[(1)] = (1));

return statearr_16569;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_16524){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_16524);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e16570){if((e16570 instanceof Object)){
var ex__14240__auto__ = e16570;
var statearr_16571_16631 = state_16524;
(statearr_16571_16631[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16524);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16570;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16632 = state_16524;
state_16524 = G__16632;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_16524){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_16524);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14378__auto___16586,mults,ensure_mult,p))
})();
var state__14380__auto__ = (function (){var statearr_16572 = f__14379__auto__.call(null);
(statearr_16572[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14378__auto___16586);

return statearr_16572;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14380__auto__);
});})(c__14378__auto___16586,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args16633 = [];
var len__7107__auto___16637 = arguments.length;
var i__7108__auto___16638 = (0);
while(true){
if((i__7108__auto___16638 < len__7107__auto___16637)){
args16633.push((arguments[i__7108__auto___16638]));

var G__16639 = (i__7108__auto___16638 + (1));
i__7108__auto___16638 = G__16639;
continue;
} else {
}
break;
}

var G__16636 = args16633.length;
switch (G__16636) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16633.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args16649 = [];
var len__7107__auto___16655 = arguments.length;
var i__7108__auto___16656 = (0);
while(true){
if((i__7108__auto___16656 < len__7107__auto___16655)){
args16649.push((arguments[i__7108__auto___16656]));

var G__16657 = (i__7108__auto___16656 + (1));
i__7108__auto___16656 = G__16657;
continue;
} else {
}
break;
}

var G__16653 = args16649.length;
switch (G__16653) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16649.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args16659 = [];
var len__7107__auto___16743 = arguments.length;
var i__7108__auto___16744 = (0);
while(true){
if((i__7108__auto___16744 < len__7107__auto___16743)){
args16659.push((arguments[i__7108__auto___16744]));

var G__16745 = (i__7108__auto___16744 + (1));
i__7108__auto___16744 = G__16745;
continue;
} else {
}
break;
}

var G__16662 = args16659.length;
switch (G__16662) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16659.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__14378__auto___16748 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14378__auto___16748,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__14379__auto__ = (function (){var switch__14236__auto__ = ((function (c__14378__auto___16748,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_16701){
var state_val_16702 = (state_16701[(1)]);
if((state_val_16702 === (7))){
var state_16701__$1 = state_16701;
var statearr_16703_16754 = state_16701__$1;
(statearr_16703_16754[(2)] = null);

(statearr_16703_16754[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16702 === (1))){
var state_16701__$1 = state_16701;
var statearr_16704_16755 = state_16701__$1;
(statearr_16704_16755[(2)] = null);

(statearr_16704_16755[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16702 === (4))){
var inst_16665 = (state_16701[(7)]);
var inst_16667 = (inst_16665 < cnt);
var state_16701__$1 = state_16701;
if(cljs.core.truth_(inst_16667)){
var statearr_16705_16756 = state_16701__$1;
(statearr_16705_16756[(1)] = (6));

} else {
var statearr_16706_16757 = state_16701__$1;
(statearr_16706_16757[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16702 === (15))){
var inst_16697 = (state_16701[(2)]);
var state_16701__$1 = state_16701;
var statearr_16707_16758 = state_16701__$1;
(statearr_16707_16758[(2)] = inst_16697);

(statearr_16707_16758[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16702 === (13))){
var inst_16690 = cljs.core.async.close_BANG_.call(null,out);
var state_16701__$1 = state_16701;
var statearr_16708_16762 = state_16701__$1;
(statearr_16708_16762[(2)] = inst_16690);

(statearr_16708_16762[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16702 === (6))){
var state_16701__$1 = state_16701;
var statearr_16709_16763 = state_16701__$1;
(statearr_16709_16763[(2)] = null);

(statearr_16709_16763[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16702 === (3))){
var inst_16699 = (state_16701[(2)]);
var state_16701__$1 = state_16701;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16701__$1,inst_16699);
} else {
if((state_val_16702 === (12))){
var inst_16687 = (state_16701[(8)]);
var inst_16687__$1 = (state_16701[(2)]);
var inst_16688 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_16687__$1);
var state_16701__$1 = (function (){var statearr_16718 = state_16701;
(statearr_16718[(8)] = inst_16687__$1);

return statearr_16718;
})();
if(cljs.core.truth_(inst_16688)){
var statearr_16719_16768 = state_16701__$1;
(statearr_16719_16768[(1)] = (13));

} else {
var statearr_16720_16769 = state_16701__$1;
(statearr_16720_16769[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16702 === (2))){
var inst_16664 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_16665 = (0);
var state_16701__$1 = (function (){var statearr_16723 = state_16701;
(statearr_16723[(7)] = inst_16665);

(statearr_16723[(9)] = inst_16664);

return statearr_16723;
})();
var statearr_16724_16770 = state_16701__$1;
(statearr_16724_16770[(2)] = null);

(statearr_16724_16770[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16702 === (11))){
var inst_16665 = (state_16701[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_16701,(10),Object,null,(9));
var inst_16674 = chs__$1.call(null,inst_16665);
var inst_16675 = done.call(null,inst_16665);
var inst_16676 = cljs.core.async.take_BANG_.call(null,inst_16674,inst_16675);
var state_16701__$1 = state_16701;
var statearr_16726_16772 = state_16701__$1;
(statearr_16726_16772[(2)] = inst_16676);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16701__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16702 === (9))){
var inst_16665 = (state_16701[(7)]);
var inst_16678 = (state_16701[(2)]);
var inst_16679 = (inst_16665 + (1));
var inst_16665__$1 = inst_16679;
var state_16701__$1 = (function (){var statearr_16728 = state_16701;
(statearr_16728[(7)] = inst_16665__$1);

(statearr_16728[(10)] = inst_16678);

return statearr_16728;
})();
var statearr_16729_16773 = state_16701__$1;
(statearr_16729_16773[(2)] = null);

(statearr_16729_16773[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16702 === (5))){
var inst_16685 = (state_16701[(2)]);
var state_16701__$1 = (function (){var statearr_16730 = state_16701;
(statearr_16730[(11)] = inst_16685);

return statearr_16730;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16701__$1,(12),dchan);
} else {
if((state_val_16702 === (14))){
var inst_16687 = (state_16701[(8)]);
var inst_16692 = cljs.core.apply.call(null,f,inst_16687);
var state_16701__$1 = state_16701;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16701__$1,(16),out,inst_16692);
} else {
if((state_val_16702 === (16))){
var inst_16694 = (state_16701[(2)]);
var state_16701__$1 = (function (){var statearr_16731 = state_16701;
(statearr_16731[(12)] = inst_16694);

return statearr_16731;
})();
var statearr_16732_16774 = state_16701__$1;
(statearr_16732_16774[(2)] = null);

(statearr_16732_16774[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16702 === (10))){
var inst_16669 = (state_16701[(2)]);
var inst_16670 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_16701__$1 = (function (){var statearr_16733 = state_16701;
(statearr_16733[(13)] = inst_16669);

return statearr_16733;
})();
var statearr_16734_16775 = state_16701__$1;
(statearr_16734_16775[(2)] = inst_16670);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16701__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16702 === (8))){
var inst_16683 = (state_16701[(2)]);
var state_16701__$1 = state_16701;
var statearr_16735_16776 = state_16701__$1;
(statearr_16735_16776[(2)] = inst_16683);

(statearr_16735_16776[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14378__auto___16748,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__14236__auto__,c__14378__auto___16748,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_16739 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16739[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_16739[(1)] = (1));

return statearr_16739;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_16701){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_16701);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e16740){if((e16740 instanceof Object)){
var ex__14240__auto__ = e16740;
var statearr_16741_16777 = state_16701;
(statearr_16741_16777[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16701);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16740;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16778 = state_16701;
state_16701 = G__16778;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_16701){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_16701);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14378__auto___16748,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__14380__auto__ = (function (){var statearr_16742 = f__14379__auto__.call(null);
(statearr_16742[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14378__auto___16748);

return statearr_16742;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14380__auto__);
});})(c__14378__auto___16748,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args16780 = [];
var len__7107__auto___16846 = arguments.length;
var i__7108__auto___16847 = (0);
while(true){
if((i__7108__auto___16847 < len__7107__auto___16846)){
args16780.push((arguments[i__7108__auto___16847]));

var G__16848 = (i__7108__auto___16847 + (1));
i__7108__auto___16847 = G__16848;
continue;
} else {
}
break;
}

var G__16782 = args16780.length;
switch (G__16782) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16780.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14378__auto___16853 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14378__auto___16853,out){
return (function (){
var f__14379__auto__ = (function (){var switch__14236__auto__ = ((function (c__14378__auto___16853,out){
return (function (state_16813){
var state_val_16814 = (state_16813[(1)]);
if((state_val_16814 === (7))){
var inst_16793 = (state_16813[(7)]);
var inst_16792 = (state_16813[(8)]);
var inst_16792__$1 = (state_16813[(2)]);
var inst_16793__$1 = cljs.core.nth.call(null,inst_16792__$1,(0),null);
var inst_16794 = cljs.core.nth.call(null,inst_16792__$1,(1),null);
var inst_16795 = (inst_16793__$1 == null);
var state_16813__$1 = (function (){var statearr_16815 = state_16813;
(statearr_16815[(7)] = inst_16793__$1);

(statearr_16815[(8)] = inst_16792__$1);

(statearr_16815[(9)] = inst_16794);

return statearr_16815;
})();
if(cljs.core.truth_(inst_16795)){
var statearr_16816_16854 = state_16813__$1;
(statearr_16816_16854[(1)] = (8));

} else {
var statearr_16817_16855 = state_16813__$1;
(statearr_16817_16855[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16814 === (1))){
var inst_16783 = cljs.core.vec.call(null,chs);
var inst_16784 = inst_16783;
var state_16813__$1 = (function (){var statearr_16818 = state_16813;
(statearr_16818[(10)] = inst_16784);

return statearr_16818;
})();
var statearr_16819_16857 = state_16813__$1;
(statearr_16819_16857[(2)] = null);

(statearr_16819_16857[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16814 === (4))){
var inst_16784 = (state_16813[(10)]);
var state_16813__$1 = state_16813;
return cljs.core.async.ioc_alts_BANG_.call(null,state_16813__$1,(7),inst_16784);
} else {
if((state_val_16814 === (6))){
var inst_16809 = (state_16813[(2)]);
var state_16813__$1 = state_16813;
var statearr_16821_16858 = state_16813__$1;
(statearr_16821_16858[(2)] = inst_16809);

(statearr_16821_16858[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16814 === (3))){
var inst_16811 = (state_16813[(2)]);
var state_16813__$1 = state_16813;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16813__$1,inst_16811);
} else {
if((state_val_16814 === (2))){
var inst_16784 = (state_16813[(10)]);
var inst_16786 = cljs.core.count.call(null,inst_16784);
var inst_16787 = (inst_16786 > (0));
var state_16813__$1 = state_16813;
if(cljs.core.truth_(inst_16787)){
var statearr_16823_16859 = state_16813__$1;
(statearr_16823_16859[(1)] = (4));

} else {
var statearr_16824_16860 = state_16813__$1;
(statearr_16824_16860[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16814 === (11))){
var inst_16784 = (state_16813[(10)]);
var inst_16802 = (state_16813[(2)]);
var tmp16822 = inst_16784;
var inst_16784__$1 = tmp16822;
var state_16813__$1 = (function (){var statearr_16827 = state_16813;
(statearr_16827[(11)] = inst_16802);

(statearr_16827[(10)] = inst_16784__$1);

return statearr_16827;
})();
var statearr_16828_16861 = state_16813__$1;
(statearr_16828_16861[(2)] = null);

(statearr_16828_16861[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16814 === (9))){
var inst_16793 = (state_16813[(7)]);
var state_16813__$1 = state_16813;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16813__$1,(11),out,inst_16793);
} else {
if((state_val_16814 === (5))){
var inst_16807 = cljs.core.async.close_BANG_.call(null,out);
var state_16813__$1 = state_16813;
var statearr_16834_16862 = state_16813__$1;
(statearr_16834_16862[(2)] = inst_16807);

(statearr_16834_16862[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16814 === (10))){
var inst_16805 = (state_16813[(2)]);
var state_16813__$1 = state_16813;
var statearr_16835_16863 = state_16813__$1;
(statearr_16835_16863[(2)] = inst_16805);

(statearr_16835_16863[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16814 === (8))){
var inst_16793 = (state_16813[(7)]);
var inst_16792 = (state_16813[(8)]);
var inst_16794 = (state_16813[(9)]);
var inst_16784 = (state_16813[(10)]);
var inst_16797 = (function (){var cs = inst_16784;
var vec__16790 = inst_16792;
var v = inst_16793;
var c = inst_16794;
return ((function (cs,vec__16790,v,c,inst_16793,inst_16792,inst_16794,inst_16784,state_val_16814,c__14378__auto___16853,out){
return (function (p1__16779_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__16779_SHARP_);
});
;})(cs,vec__16790,v,c,inst_16793,inst_16792,inst_16794,inst_16784,state_val_16814,c__14378__auto___16853,out))
})();
var inst_16798 = cljs.core.filterv.call(null,inst_16797,inst_16784);
var inst_16784__$1 = inst_16798;
var state_16813__$1 = (function (){var statearr_16836 = state_16813;
(statearr_16836[(10)] = inst_16784__$1);

return statearr_16836;
})();
var statearr_16837_16864 = state_16813__$1;
(statearr_16837_16864[(2)] = null);

(statearr_16837_16864[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__14378__auto___16853,out))
;
return ((function (switch__14236__auto__,c__14378__auto___16853,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_16842 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16842[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_16842[(1)] = (1));

return statearr_16842;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_16813){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_16813);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e16843){if((e16843 instanceof Object)){
var ex__14240__auto__ = e16843;
var statearr_16844_16865 = state_16813;
(statearr_16844_16865[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16813);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16843;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16866 = state_16813;
state_16813 = G__16866;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_16813){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_16813);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14378__auto___16853,out))
})();
var state__14380__auto__ = (function (){var statearr_16845 = f__14379__auto__.call(null);
(statearr_16845[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14378__auto___16853);

return statearr_16845;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14380__auto__);
});})(c__14378__auto___16853,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args16867 = [];
var len__7107__auto___16926 = arguments.length;
var i__7108__auto___16927 = (0);
while(true){
if((i__7108__auto___16927 < len__7107__auto___16926)){
args16867.push((arguments[i__7108__auto___16927]));

var G__16929 = (i__7108__auto___16927 + (1));
i__7108__auto___16927 = G__16929;
continue;
} else {
}
break;
}

var G__16870 = args16867.length;
switch (G__16870) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16867.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14378__auto___16932 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14378__auto___16932,out){
return (function (){
var f__14379__auto__ = (function (){var switch__14236__auto__ = ((function (c__14378__auto___16932,out){
return (function (state_16895){
var state_val_16896 = (state_16895[(1)]);
if((state_val_16896 === (7))){
var inst_16877 = (state_16895[(7)]);
var inst_16877__$1 = (state_16895[(2)]);
var inst_16878 = (inst_16877__$1 == null);
var inst_16879 = cljs.core.not.call(null,inst_16878);
var state_16895__$1 = (function (){var statearr_16897 = state_16895;
(statearr_16897[(7)] = inst_16877__$1);

return statearr_16897;
})();
if(inst_16879){
var statearr_16898_16936 = state_16895__$1;
(statearr_16898_16936[(1)] = (8));

} else {
var statearr_16900_16937 = state_16895__$1;
(statearr_16900_16937[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16896 === (1))){
var inst_16872 = (0);
var state_16895__$1 = (function (){var statearr_16901 = state_16895;
(statearr_16901[(8)] = inst_16872);

return statearr_16901;
})();
var statearr_16902_16938 = state_16895__$1;
(statearr_16902_16938[(2)] = null);

(statearr_16902_16938[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16896 === (4))){
var state_16895__$1 = state_16895;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16895__$1,(7),ch);
} else {
if((state_val_16896 === (6))){
var inst_16890 = (state_16895[(2)]);
var state_16895__$1 = state_16895;
var statearr_16903_16939 = state_16895__$1;
(statearr_16903_16939[(2)] = inst_16890);

(statearr_16903_16939[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16896 === (3))){
var inst_16892 = (state_16895[(2)]);
var inst_16893 = cljs.core.async.close_BANG_.call(null,out);
var state_16895__$1 = (function (){var statearr_16904 = state_16895;
(statearr_16904[(9)] = inst_16892);

return statearr_16904;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16895__$1,inst_16893);
} else {
if((state_val_16896 === (2))){
var inst_16872 = (state_16895[(8)]);
var inst_16874 = (inst_16872 < n);
var state_16895__$1 = state_16895;
if(cljs.core.truth_(inst_16874)){
var statearr_16907_16941 = state_16895__$1;
(statearr_16907_16941[(1)] = (4));

} else {
var statearr_16908_16942 = state_16895__$1;
(statearr_16908_16942[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16896 === (11))){
var inst_16872 = (state_16895[(8)]);
var inst_16882 = (state_16895[(2)]);
var inst_16883 = (inst_16872 + (1));
var inst_16872__$1 = inst_16883;
var state_16895__$1 = (function (){var statearr_16909 = state_16895;
(statearr_16909[(8)] = inst_16872__$1);

(statearr_16909[(10)] = inst_16882);

return statearr_16909;
})();
var statearr_16911_16943 = state_16895__$1;
(statearr_16911_16943[(2)] = null);

(statearr_16911_16943[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16896 === (9))){
var state_16895__$1 = state_16895;
var statearr_16912_16944 = state_16895__$1;
(statearr_16912_16944[(2)] = null);

(statearr_16912_16944[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16896 === (5))){
var state_16895__$1 = state_16895;
var statearr_16914_16945 = state_16895__$1;
(statearr_16914_16945[(2)] = null);

(statearr_16914_16945[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16896 === (10))){
var inst_16887 = (state_16895[(2)]);
var state_16895__$1 = state_16895;
var statearr_16915_16946 = state_16895__$1;
(statearr_16915_16946[(2)] = inst_16887);

(statearr_16915_16946[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16896 === (8))){
var inst_16877 = (state_16895[(7)]);
var state_16895__$1 = state_16895;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16895__$1,(11),out,inst_16877);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__14378__auto___16932,out))
;
return ((function (switch__14236__auto__,c__14378__auto___16932,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_16919 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_16919[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_16919[(1)] = (1));

return statearr_16919;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_16895){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_16895);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e16920){if((e16920 instanceof Object)){
var ex__14240__auto__ = e16920;
var statearr_16921_16947 = state_16895;
(statearr_16921_16947[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16895);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16920;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16948 = state_16895;
state_16895 = G__16948;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_16895){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_16895);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14378__auto___16932,out))
})();
var state__14380__auto__ = (function (){var statearr_16922 = f__14379__auto__.call(null);
(statearr_16922[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14378__auto___16932);

return statearr_16922;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14380__auto__);
});})(c__14378__auto___16932,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async16956 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16956 = (function (map_LT_,f,ch,meta16957){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta16957 = meta16957;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16956.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16958,meta16957__$1){
var self__ = this;
var _16958__$1 = this;
return (new cljs.core.async.t_cljs$core$async16956(self__.map_LT_,self__.f,self__.ch,meta16957__$1));
});

cljs.core.async.t_cljs$core$async16956.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16958){
var self__ = this;
var _16958__$1 = this;
return self__.meta16957;
});

cljs.core.async.t_cljs$core$async16956.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async16956.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async16956.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async16956.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async16956.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async16959 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16959 = (function (map_LT_,f,ch,meta16957,_,fn1,meta16960){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta16957 = meta16957;
this._ = _;
this.fn1 = fn1;
this.meta16960 = meta16960;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16959.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_16961,meta16960__$1){
var self__ = this;
var _16961__$1 = this;
return (new cljs.core.async.t_cljs$core$async16959(self__.map_LT_,self__.f,self__.ch,self__.meta16957,self__._,self__.fn1,meta16960__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async16959.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_16961){
var self__ = this;
var _16961__$1 = this;
return self__.meta16960;
});})(___$1))
;

cljs.core.async.t_cljs$core$async16959.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async16959.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async16959.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async16959.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__16949_SHARP_){
return f1.call(null,(((p1__16949_SHARP_ == null))?null:self__.f.call(null,p1__16949_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async16959.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16957","meta16957",-222906959,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async16956","cljs.core.async/t_cljs$core$async16956",-778949895,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta16960","meta16960",-1924152610,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async16959.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16959.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16959";

cljs.core.async.t_cljs$core$async16959.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16959");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async16959 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async16959(map_LT___$1,f__$1,ch__$1,meta16957__$1,___$2,fn1__$1,meta16960){
return (new cljs.core.async.t_cljs$core$async16959(map_LT___$1,f__$1,ch__$1,meta16957__$1,___$2,fn1__$1,meta16960));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async16959(self__.map_LT_,self__.f,self__.ch,self__.meta16957,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__6037__auto__ = ret;
if(cljs.core.truth_(and__6037__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__6037__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async16956.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async16956.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async16956.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16957","meta16957",-222906959,null)], null);
});

cljs.core.async.t_cljs$core$async16956.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16956.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16956";

cljs.core.async.t_cljs$core$async16956.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16956");
});

cljs.core.async.__GT_t_cljs$core$async16956 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async16956(map_LT___$1,f__$1,ch__$1,meta16957){
return (new cljs.core.async.t_cljs$core$async16956(map_LT___$1,f__$1,ch__$1,meta16957));
});

}

return (new cljs.core.async.t_cljs$core$async16956(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async16980 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16980 = (function (map_GT_,f,ch,meta16981){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta16981 = meta16981;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16980.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16982,meta16981__$1){
var self__ = this;
var _16982__$1 = this;
return (new cljs.core.async.t_cljs$core$async16980(self__.map_GT_,self__.f,self__.ch,meta16981__$1));
});

cljs.core.async.t_cljs$core$async16980.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16982){
var self__ = this;
var _16982__$1 = this;
return self__.meta16981;
});

cljs.core.async.t_cljs$core$async16980.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async16980.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async16980.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async16980.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async16980.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async16980.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async16980.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16981","meta16981",953201123,null)], null);
});

cljs.core.async.t_cljs$core$async16980.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16980.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16980";

cljs.core.async.t_cljs$core$async16980.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16980");
});

cljs.core.async.__GT_t_cljs$core$async16980 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async16980(map_GT___$1,f__$1,ch__$1,meta16981){
return (new cljs.core.async.t_cljs$core$async16980(map_GT___$1,f__$1,ch__$1,meta16981));
});

}

return (new cljs.core.async.t_cljs$core$async16980(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async16987 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16987 = (function (filter_GT_,p,ch,meta16988){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta16988 = meta16988;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16987.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16989,meta16988__$1){
var self__ = this;
var _16989__$1 = this;
return (new cljs.core.async.t_cljs$core$async16987(self__.filter_GT_,self__.p,self__.ch,meta16988__$1));
});

cljs.core.async.t_cljs$core$async16987.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16989){
var self__ = this;
var _16989__$1 = this;
return self__.meta16988;
});

cljs.core.async.t_cljs$core$async16987.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async16987.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async16987.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async16987.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async16987.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async16987.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async16987.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async16987.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16988","meta16988",1905632198,null)], null);
});

cljs.core.async.t_cljs$core$async16987.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16987.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16987";

cljs.core.async.t_cljs$core$async16987.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16987");
});

cljs.core.async.__GT_t_cljs$core$async16987 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async16987(filter_GT___$1,p__$1,ch__$1,meta16988){
return (new cljs.core.async.t_cljs$core$async16987(filter_GT___$1,p__$1,ch__$1,meta16988));
});

}

return (new cljs.core.async.t_cljs$core$async16987(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args16990 = [];
var len__7107__auto___17042 = arguments.length;
var i__7108__auto___17043 = (0);
while(true){
if((i__7108__auto___17043 < len__7107__auto___17042)){
args16990.push((arguments[i__7108__auto___17043]));

var G__17044 = (i__7108__auto___17043 + (1));
i__7108__auto___17043 = G__17044;
continue;
} else {
}
break;
}

var G__16992 = args16990.length;
switch (G__16992) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16990.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14378__auto___17049 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14378__auto___17049,out){
return (function (){
var f__14379__auto__ = (function (){var switch__14236__auto__ = ((function (c__14378__auto___17049,out){
return (function (state_17015){
var state_val_17016 = (state_17015[(1)]);
if((state_val_17016 === (7))){
var inst_17011 = (state_17015[(2)]);
var state_17015__$1 = state_17015;
var statearr_17017_17050 = state_17015__$1;
(statearr_17017_17050[(2)] = inst_17011);

(statearr_17017_17050[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17016 === (1))){
var state_17015__$1 = state_17015;
var statearr_17018_17051 = state_17015__$1;
(statearr_17018_17051[(2)] = null);

(statearr_17018_17051[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17016 === (4))){
var inst_16996 = (state_17015[(7)]);
var inst_16996__$1 = (state_17015[(2)]);
var inst_16997 = (inst_16996__$1 == null);
var state_17015__$1 = (function (){var statearr_17019 = state_17015;
(statearr_17019[(7)] = inst_16996__$1);

return statearr_17019;
})();
if(cljs.core.truth_(inst_16997)){
var statearr_17020_17052 = state_17015__$1;
(statearr_17020_17052[(1)] = (5));

} else {
var statearr_17021_17053 = state_17015__$1;
(statearr_17021_17053[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17016 === (6))){
var inst_16996 = (state_17015[(7)]);
var inst_17001 = p.call(null,inst_16996);
var state_17015__$1 = state_17015;
if(cljs.core.truth_(inst_17001)){
var statearr_17022_17054 = state_17015__$1;
(statearr_17022_17054[(1)] = (8));

} else {
var statearr_17023_17056 = state_17015__$1;
(statearr_17023_17056[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17016 === (3))){
var inst_17013 = (state_17015[(2)]);
var state_17015__$1 = state_17015;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17015__$1,inst_17013);
} else {
if((state_val_17016 === (2))){
var state_17015__$1 = state_17015;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17015__$1,(4),ch);
} else {
if((state_val_17016 === (11))){
var inst_17005 = (state_17015[(2)]);
var state_17015__$1 = state_17015;
var statearr_17025_17057 = state_17015__$1;
(statearr_17025_17057[(2)] = inst_17005);

(statearr_17025_17057[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17016 === (9))){
var state_17015__$1 = state_17015;
var statearr_17027_17058 = state_17015__$1;
(statearr_17027_17058[(2)] = null);

(statearr_17027_17058[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17016 === (5))){
var inst_16999 = cljs.core.async.close_BANG_.call(null,out);
var state_17015__$1 = state_17015;
var statearr_17028_17059 = state_17015__$1;
(statearr_17028_17059[(2)] = inst_16999);

(statearr_17028_17059[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17016 === (10))){
var inst_17008 = (state_17015[(2)]);
var state_17015__$1 = (function (){var statearr_17029 = state_17015;
(statearr_17029[(8)] = inst_17008);

return statearr_17029;
})();
var statearr_17030_17060 = state_17015__$1;
(statearr_17030_17060[(2)] = null);

(statearr_17030_17060[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17016 === (8))){
var inst_16996 = (state_17015[(7)]);
var state_17015__$1 = state_17015;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17015__$1,(11),out,inst_16996);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__14378__auto___17049,out))
;
return ((function (switch__14236__auto__,c__14378__auto___17049,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_17037 = [null,null,null,null,null,null,null,null,null];
(statearr_17037[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_17037[(1)] = (1));

return statearr_17037;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_17015){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_17015);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e17038){if((e17038 instanceof Object)){
var ex__14240__auto__ = e17038;
var statearr_17039_17061 = state_17015;
(statearr_17039_17061[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17015);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17038;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17062 = state_17015;
state_17015 = G__17062;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_17015){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_17015);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14378__auto___17049,out))
})();
var state__14380__auto__ = (function (){var statearr_17041 = f__14379__auto__.call(null);
(statearr_17041[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14378__auto___17049);

return statearr_17041;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14380__auto__);
});})(c__14378__auto___17049,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args17063 = [];
var len__7107__auto___17066 = arguments.length;
var i__7108__auto___17067 = (0);
while(true){
if((i__7108__auto___17067 < len__7107__auto___17066)){
args17063.push((arguments[i__7108__auto___17067]));

var G__17068 = (i__7108__auto___17067 + (1));
i__7108__auto___17067 = G__17068;
continue;
} else {
}
break;
}

var G__17065 = args17063.length;
switch (G__17065) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17063.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__14378__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14378__auto__){
return (function (){
var f__14379__auto__ = (function (){var switch__14236__auto__ = ((function (c__14378__auto__){
return (function (state_17243){
var state_val_17244 = (state_17243[(1)]);
if((state_val_17244 === (7))){
var inst_17239 = (state_17243[(2)]);
var state_17243__$1 = state_17243;
var statearr_17245_17290 = state_17243__$1;
(statearr_17245_17290[(2)] = inst_17239);

(statearr_17245_17290[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17244 === (20))){
var inst_17209 = (state_17243[(7)]);
var inst_17220 = (state_17243[(2)]);
var inst_17221 = cljs.core.next.call(null,inst_17209);
var inst_17195 = inst_17221;
var inst_17196 = null;
var inst_17197 = (0);
var inst_17198 = (0);
var state_17243__$1 = (function (){var statearr_17246 = state_17243;
(statearr_17246[(8)] = inst_17197);

(statearr_17246[(9)] = inst_17196);

(statearr_17246[(10)] = inst_17198);

(statearr_17246[(11)] = inst_17195);

(statearr_17246[(12)] = inst_17220);

return statearr_17246;
})();
var statearr_17247_17294 = state_17243__$1;
(statearr_17247_17294[(2)] = null);

(statearr_17247_17294[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17244 === (1))){
var state_17243__$1 = state_17243;
var statearr_17248_17295 = state_17243__$1;
(statearr_17248_17295[(2)] = null);

(statearr_17248_17295[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17244 === (4))){
var inst_17184 = (state_17243[(13)]);
var inst_17184__$1 = (state_17243[(2)]);
var inst_17185 = (inst_17184__$1 == null);
var state_17243__$1 = (function (){var statearr_17249 = state_17243;
(statearr_17249[(13)] = inst_17184__$1);

return statearr_17249;
})();
if(cljs.core.truth_(inst_17185)){
var statearr_17250_17297 = state_17243__$1;
(statearr_17250_17297[(1)] = (5));

} else {
var statearr_17251_17298 = state_17243__$1;
(statearr_17251_17298[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17244 === (15))){
var state_17243__$1 = state_17243;
var statearr_17255_17299 = state_17243__$1;
(statearr_17255_17299[(2)] = null);

(statearr_17255_17299[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17244 === (21))){
var state_17243__$1 = state_17243;
var statearr_17256_17300 = state_17243__$1;
(statearr_17256_17300[(2)] = null);

(statearr_17256_17300[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17244 === (13))){
var inst_17197 = (state_17243[(8)]);
var inst_17196 = (state_17243[(9)]);
var inst_17198 = (state_17243[(10)]);
var inst_17195 = (state_17243[(11)]);
var inst_17205 = (state_17243[(2)]);
var inst_17206 = (inst_17198 + (1));
var tmp17252 = inst_17197;
var tmp17253 = inst_17196;
var tmp17254 = inst_17195;
var inst_17195__$1 = tmp17254;
var inst_17196__$1 = tmp17253;
var inst_17197__$1 = tmp17252;
var inst_17198__$1 = inst_17206;
var state_17243__$1 = (function (){var statearr_17257 = state_17243;
(statearr_17257[(8)] = inst_17197__$1);

(statearr_17257[(9)] = inst_17196__$1);

(statearr_17257[(10)] = inst_17198__$1);

(statearr_17257[(11)] = inst_17195__$1);

(statearr_17257[(14)] = inst_17205);

return statearr_17257;
})();
var statearr_17258_17301 = state_17243__$1;
(statearr_17258_17301[(2)] = null);

(statearr_17258_17301[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17244 === (22))){
var state_17243__$1 = state_17243;
var statearr_17259_17302 = state_17243__$1;
(statearr_17259_17302[(2)] = null);

(statearr_17259_17302[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17244 === (6))){
var inst_17184 = (state_17243[(13)]);
var inst_17193 = f.call(null,inst_17184);
var inst_17194 = cljs.core.seq.call(null,inst_17193);
var inst_17195 = inst_17194;
var inst_17196 = null;
var inst_17197 = (0);
var inst_17198 = (0);
var state_17243__$1 = (function (){var statearr_17260 = state_17243;
(statearr_17260[(8)] = inst_17197);

(statearr_17260[(9)] = inst_17196);

(statearr_17260[(10)] = inst_17198);

(statearr_17260[(11)] = inst_17195);

return statearr_17260;
})();
var statearr_17261_17303 = state_17243__$1;
(statearr_17261_17303[(2)] = null);

(statearr_17261_17303[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17244 === (17))){
var inst_17209 = (state_17243[(7)]);
var inst_17213 = cljs.core.chunk_first.call(null,inst_17209);
var inst_17214 = cljs.core.chunk_rest.call(null,inst_17209);
var inst_17215 = cljs.core.count.call(null,inst_17213);
var inst_17195 = inst_17214;
var inst_17196 = inst_17213;
var inst_17197 = inst_17215;
var inst_17198 = (0);
var state_17243__$1 = (function (){var statearr_17262 = state_17243;
(statearr_17262[(8)] = inst_17197);

(statearr_17262[(9)] = inst_17196);

(statearr_17262[(10)] = inst_17198);

(statearr_17262[(11)] = inst_17195);

return statearr_17262;
})();
var statearr_17263_17304 = state_17243__$1;
(statearr_17263_17304[(2)] = null);

(statearr_17263_17304[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17244 === (3))){
var inst_17241 = (state_17243[(2)]);
var state_17243__$1 = state_17243;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17243__$1,inst_17241);
} else {
if((state_val_17244 === (12))){
var inst_17229 = (state_17243[(2)]);
var state_17243__$1 = state_17243;
var statearr_17264_17305 = state_17243__$1;
(statearr_17264_17305[(2)] = inst_17229);

(statearr_17264_17305[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17244 === (2))){
var state_17243__$1 = state_17243;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17243__$1,(4),in$);
} else {
if((state_val_17244 === (23))){
var inst_17237 = (state_17243[(2)]);
var state_17243__$1 = state_17243;
var statearr_17265_17306 = state_17243__$1;
(statearr_17265_17306[(2)] = inst_17237);

(statearr_17265_17306[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17244 === (19))){
var inst_17224 = (state_17243[(2)]);
var state_17243__$1 = state_17243;
var statearr_17266_17307 = state_17243__$1;
(statearr_17266_17307[(2)] = inst_17224);

(statearr_17266_17307[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17244 === (11))){
var inst_17209 = (state_17243[(7)]);
var inst_17195 = (state_17243[(11)]);
var inst_17209__$1 = cljs.core.seq.call(null,inst_17195);
var state_17243__$1 = (function (){var statearr_17267 = state_17243;
(statearr_17267[(7)] = inst_17209__$1);

return statearr_17267;
})();
if(inst_17209__$1){
var statearr_17268_17308 = state_17243__$1;
(statearr_17268_17308[(1)] = (14));

} else {
var statearr_17269_17309 = state_17243__$1;
(statearr_17269_17309[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17244 === (9))){
var inst_17231 = (state_17243[(2)]);
var inst_17232 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_17243__$1 = (function (){var statearr_17270 = state_17243;
(statearr_17270[(15)] = inst_17231);

return statearr_17270;
})();
if(cljs.core.truth_(inst_17232)){
var statearr_17271_17313 = state_17243__$1;
(statearr_17271_17313[(1)] = (21));

} else {
var statearr_17272_17314 = state_17243__$1;
(statearr_17272_17314[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17244 === (5))){
var inst_17187 = cljs.core.async.close_BANG_.call(null,out);
var state_17243__$1 = state_17243;
var statearr_17273_17316 = state_17243__$1;
(statearr_17273_17316[(2)] = inst_17187);

(statearr_17273_17316[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17244 === (14))){
var inst_17209 = (state_17243[(7)]);
var inst_17211 = cljs.core.chunked_seq_QMARK_.call(null,inst_17209);
var state_17243__$1 = state_17243;
if(inst_17211){
var statearr_17274_17317 = state_17243__$1;
(statearr_17274_17317[(1)] = (17));

} else {
var statearr_17275_17318 = state_17243__$1;
(statearr_17275_17318[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17244 === (16))){
var inst_17227 = (state_17243[(2)]);
var state_17243__$1 = state_17243;
var statearr_17276_17322 = state_17243__$1;
(statearr_17276_17322[(2)] = inst_17227);

(statearr_17276_17322[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17244 === (10))){
var inst_17196 = (state_17243[(9)]);
var inst_17198 = (state_17243[(10)]);
var inst_17203 = cljs.core._nth.call(null,inst_17196,inst_17198);
var state_17243__$1 = state_17243;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17243__$1,(13),out,inst_17203);
} else {
if((state_val_17244 === (18))){
var inst_17209 = (state_17243[(7)]);
var inst_17218 = cljs.core.first.call(null,inst_17209);
var state_17243__$1 = state_17243;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17243__$1,(20),out,inst_17218);
} else {
if((state_val_17244 === (8))){
var inst_17197 = (state_17243[(8)]);
var inst_17198 = (state_17243[(10)]);
var inst_17200 = (inst_17198 < inst_17197);
var inst_17201 = inst_17200;
var state_17243__$1 = state_17243;
if(cljs.core.truth_(inst_17201)){
var statearr_17279_17327 = state_17243__$1;
(statearr_17279_17327[(1)] = (10));

} else {
var statearr_17280_17329 = state_17243__$1;
(statearr_17280_17329[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14378__auto__))
;
return ((function (switch__14236__auto__,c__14378__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_17286 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17286[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__);

(statearr_17286[(1)] = (1));

return statearr_17286;
});
var cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____1 = (function (state_17243){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_17243);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e17287){if((e17287 instanceof Object)){
var ex__14240__auto__ = e17287;
var statearr_17288_17330 = state_17243;
(statearr_17288_17330[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17243);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17287;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17331 = state_17243;
state_17243 = G__17331;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__ = function(state_17243){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____1.call(this,state_17243);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14378__auto__))
})();
var state__14380__auto__ = (function (){var statearr_17289 = f__14379__auto__.call(null);
(statearr_17289[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14378__auto__);

return statearr_17289;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14380__auto__);
});})(c__14378__auto__))
);

return c__14378__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args17332 = [];
var len__7107__auto___17335 = arguments.length;
var i__7108__auto___17336 = (0);
while(true){
if((i__7108__auto___17336 < len__7107__auto___17335)){
args17332.push((arguments[i__7108__auto___17336]));

var G__17337 = (i__7108__auto___17336 + (1));
i__7108__auto___17336 = G__17337;
continue;
} else {
}
break;
}

var G__17334 = args17332.length;
switch (G__17334) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17332.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args17339 = [];
var len__7107__auto___17342 = arguments.length;
var i__7108__auto___17343 = (0);
while(true){
if((i__7108__auto___17343 < len__7107__auto___17342)){
args17339.push((arguments[i__7108__auto___17343]));

var G__17344 = (i__7108__auto___17343 + (1));
i__7108__auto___17343 = G__17344;
continue;
} else {
}
break;
}

var G__17341 = args17339.length;
switch (G__17341) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17339.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args17346 = [];
var len__7107__auto___17398 = arguments.length;
var i__7108__auto___17399 = (0);
while(true){
if((i__7108__auto___17399 < len__7107__auto___17398)){
args17346.push((arguments[i__7108__auto___17399]));

var G__17400 = (i__7108__auto___17399 + (1));
i__7108__auto___17399 = G__17400;
continue;
} else {
}
break;
}

var G__17348 = args17346.length;
switch (G__17348) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17346.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14378__auto___17407 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14378__auto___17407,out){
return (function (){
var f__14379__auto__ = (function (){var switch__14236__auto__ = ((function (c__14378__auto___17407,out){
return (function (state_17372){
var state_val_17373 = (state_17372[(1)]);
if((state_val_17373 === (7))){
var inst_17367 = (state_17372[(2)]);
var state_17372__$1 = state_17372;
var statearr_17374_17409 = state_17372__$1;
(statearr_17374_17409[(2)] = inst_17367);

(statearr_17374_17409[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17373 === (1))){
var inst_17349 = null;
var state_17372__$1 = (function (){var statearr_17375 = state_17372;
(statearr_17375[(7)] = inst_17349);

return statearr_17375;
})();
var statearr_17376_17411 = state_17372__$1;
(statearr_17376_17411[(2)] = null);

(statearr_17376_17411[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17373 === (4))){
var inst_17352 = (state_17372[(8)]);
var inst_17352__$1 = (state_17372[(2)]);
var inst_17353 = (inst_17352__$1 == null);
var inst_17354 = cljs.core.not.call(null,inst_17353);
var state_17372__$1 = (function (){var statearr_17377 = state_17372;
(statearr_17377[(8)] = inst_17352__$1);

return statearr_17377;
})();
if(inst_17354){
var statearr_17378_17413 = state_17372__$1;
(statearr_17378_17413[(1)] = (5));

} else {
var statearr_17379_17414 = state_17372__$1;
(statearr_17379_17414[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17373 === (6))){
var state_17372__$1 = state_17372;
var statearr_17380_17415 = state_17372__$1;
(statearr_17380_17415[(2)] = null);

(statearr_17380_17415[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17373 === (3))){
var inst_17369 = (state_17372[(2)]);
var inst_17370 = cljs.core.async.close_BANG_.call(null,out);
var state_17372__$1 = (function (){var statearr_17381 = state_17372;
(statearr_17381[(9)] = inst_17369);

return statearr_17381;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17372__$1,inst_17370);
} else {
if((state_val_17373 === (2))){
var state_17372__$1 = state_17372;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17372__$1,(4),ch);
} else {
if((state_val_17373 === (11))){
var inst_17352 = (state_17372[(8)]);
var inst_17361 = (state_17372[(2)]);
var inst_17349 = inst_17352;
var state_17372__$1 = (function (){var statearr_17382 = state_17372;
(statearr_17382[(7)] = inst_17349);

(statearr_17382[(10)] = inst_17361);

return statearr_17382;
})();
var statearr_17383_17422 = state_17372__$1;
(statearr_17383_17422[(2)] = null);

(statearr_17383_17422[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17373 === (9))){
var inst_17352 = (state_17372[(8)]);
var state_17372__$1 = state_17372;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17372__$1,(11),out,inst_17352);
} else {
if((state_val_17373 === (5))){
var inst_17349 = (state_17372[(7)]);
var inst_17352 = (state_17372[(8)]);
var inst_17356 = cljs.core._EQ_.call(null,inst_17352,inst_17349);
var state_17372__$1 = state_17372;
if(inst_17356){
var statearr_17385_17425 = state_17372__$1;
(statearr_17385_17425[(1)] = (8));

} else {
var statearr_17386_17427 = state_17372__$1;
(statearr_17386_17427[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17373 === (10))){
var inst_17364 = (state_17372[(2)]);
var state_17372__$1 = state_17372;
var statearr_17387_17428 = state_17372__$1;
(statearr_17387_17428[(2)] = inst_17364);

(statearr_17387_17428[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17373 === (8))){
var inst_17349 = (state_17372[(7)]);
var tmp17384 = inst_17349;
var inst_17349__$1 = tmp17384;
var state_17372__$1 = (function (){var statearr_17388 = state_17372;
(statearr_17388[(7)] = inst_17349__$1);

return statearr_17388;
})();
var statearr_17389_17429 = state_17372__$1;
(statearr_17389_17429[(2)] = null);

(statearr_17389_17429[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__14378__auto___17407,out))
;
return ((function (switch__14236__auto__,c__14378__auto___17407,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_17393 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17393[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_17393[(1)] = (1));

return statearr_17393;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_17372){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_17372);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e17394){if((e17394 instanceof Object)){
var ex__14240__auto__ = e17394;
var statearr_17395_17430 = state_17372;
(statearr_17395_17430[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17372);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17394;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17431 = state_17372;
state_17372 = G__17431;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_17372){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_17372);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14378__auto___17407,out))
})();
var state__14380__auto__ = (function (){var statearr_17396 = f__14379__auto__.call(null);
(statearr_17396[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14378__auto___17407);

return statearr_17396;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14380__auto__);
});})(c__14378__auto___17407,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args17433 = [];
var len__7107__auto___17519 = arguments.length;
var i__7108__auto___17520 = (0);
while(true){
if((i__7108__auto___17520 < len__7107__auto___17519)){
args17433.push((arguments[i__7108__auto___17520]));

var G__17522 = (i__7108__auto___17520 + (1));
i__7108__auto___17520 = G__17522;
continue;
} else {
}
break;
}

var G__17435 = args17433.length;
switch (G__17435) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17433.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14378__auto___17524 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14378__auto___17524,out){
return (function (){
var f__14379__auto__ = (function (){var switch__14236__auto__ = ((function (c__14378__auto___17524,out){
return (function (state_17473){
var state_val_17474 = (state_17473[(1)]);
if((state_val_17474 === (7))){
var inst_17469 = (state_17473[(2)]);
var state_17473__$1 = state_17473;
var statearr_17475_17526 = state_17473__$1;
(statearr_17475_17526[(2)] = inst_17469);

(statearr_17475_17526[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17474 === (1))){
var inst_17436 = (new Array(n));
var inst_17437 = inst_17436;
var inst_17438 = (0);
var state_17473__$1 = (function (){var statearr_17476 = state_17473;
(statearr_17476[(7)] = inst_17438);

(statearr_17476[(8)] = inst_17437);

return statearr_17476;
})();
var statearr_17481_17527 = state_17473__$1;
(statearr_17481_17527[(2)] = null);

(statearr_17481_17527[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17474 === (4))){
var inst_17441 = (state_17473[(9)]);
var inst_17441__$1 = (state_17473[(2)]);
var inst_17442 = (inst_17441__$1 == null);
var inst_17443 = cljs.core.not.call(null,inst_17442);
var state_17473__$1 = (function (){var statearr_17482 = state_17473;
(statearr_17482[(9)] = inst_17441__$1);

return statearr_17482;
})();
if(inst_17443){
var statearr_17483_17534 = state_17473__$1;
(statearr_17483_17534[(1)] = (5));

} else {
var statearr_17484_17535 = state_17473__$1;
(statearr_17484_17535[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17474 === (15))){
var inst_17463 = (state_17473[(2)]);
var state_17473__$1 = state_17473;
var statearr_17486_17537 = state_17473__$1;
(statearr_17486_17537[(2)] = inst_17463);

(statearr_17486_17537[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17474 === (13))){
var state_17473__$1 = state_17473;
var statearr_17489_17539 = state_17473__$1;
(statearr_17489_17539[(2)] = null);

(statearr_17489_17539[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17474 === (6))){
var inst_17438 = (state_17473[(7)]);
var inst_17459 = (inst_17438 > (0));
var state_17473__$1 = state_17473;
if(cljs.core.truth_(inst_17459)){
var statearr_17490_17545 = state_17473__$1;
(statearr_17490_17545[(1)] = (12));

} else {
var statearr_17492_17546 = state_17473__$1;
(statearr_17492_17546[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17474 === (3))){
var inst_17471 = (state_17473[(2)]);
var state_17473__$1 = state_17473;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17473__$1,inst_17471);
} else {
if((state_val_17474 === (12))){
var inst_17437 = (state_17473[(8)]);
var inst_17461 = cljs.core.vec.call(null,inst_17437);
var state_17473__$1 = state_17473;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17473__$1,(15),out,inst_17461);
} else {
if((state_val_17474 === (2))){
var state_17473__$1 = state_17473;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17473__$1,(4),ch);
} else {
if((state_val_17474 === (11))){
var inst_17453 = (state_17473[(2)]);
var inst_17454 = (new Array(n));
var inst_17437 = inst_17454;
var inst_17438 = (0);
var state_17473__$1 = (function (){var statearr_17500 = state_17473;
(statearr_17500[(10)] = inst_17453);

(statearr_17500[(7)] = inst_17438);

(statearr_17500[(8)] = inst_17437);

return statearr_17500;
})();
var statearr_17501_17550 = state_17473__$1;
(statearr_17501_17550[(2)] = null);

(statearr_17501_17550[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17474 === (9))){
var inst_17437 = (state_17473[(8)]);
var inst_17451 = cljs.core.vec.call(null,inst_17437);
var state_17473__$1 = state_17473;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17473__$1,(11),out,inst_17451);
} else {
if((state_val_17474 === (5))){
var inst_17446 = (state_17473[(11)]);
var inst_17438 = (state_17473[(7)]);
var inst_17437 = (state_17473[(8)]);
var inst_17441 = (state_17473[(9)]);
var inst_17445 = (inst_17437[inst_17438] = inst_17441);
var inst_17446__$1 = (inst_17438 + (1));
var inst_17447 = (inst_17446__$1 < n);
var state_17473__$1 = (function (){var statearr_17503 = state_17473;
(statearr_17503[(11)] = inst_17446__$1);

(statearr_17503[(12)] = inst_17445);

return statearr_17503;
})();
if(cljs.core.truth_(inst_17447)){
var statearr_17504_17552 = state_17473__$1;
(statearr_17504_17552[(1)] = (8));

} else {
var statearr_17505_17553 = state_17473__$1;
(statearr_17505_17553[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17474 === (14))){
var inst_17466 = (state_17473[(2)]);
var inst_17467 = cljs.core.async.close_BANG_.call(null,out);
var state_17473__$1 = (function (){var statearr_17507 = state_17473;
(statearr_17507[(13)] = inst_17466);

return statearr_17507;
})();
var statearr_17508_17554 = state_17473__$1;
(statearr_17508_17554[(2)] = inst_17467);

(statearr_17508_17554[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17474 === (10))){
var inst_17457 = (state_17473[(2)]);
var state_17473__$1 = state_17473;
var statearr_17509_17555 = state_17473__$1;
(statearr_17509_17555[(2)] = inst_17457);

(statearr_17509_17555[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17474 === (8))){
var inst_17446 = (state_17473[(11)]);
var inst_17437 = (state_17473[(8)]);
var tmp17506 = inst_17437;
var inst_17437__$1 = tmp17506;
var inst_17438 = inst_17446;
var state_17473__$1 = (function (){var statearr_17510 = state_17473;
(statearr_17510[(7)] = inst_17438);

(statearr_17510[(8)] = inst_17437__$1);

return statearr_17510;
})();
var statearr_17511_17556 = state_17473__$1;
(statearr_17511_17556[(2)] = null);

(statearr_17511_17556[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14378__auto___17524,out))
;
return ((function (switch__14236__auto__,c__14378__auto___17524,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_17515 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17515[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_17515[(1)] = (1));

return statearr_17515;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_17473){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_17473);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e17516){if((e17516 instanceof Object)){
var ex__14240__auto__ = e17516;
var statearr_17517_17557 = state_17473;
(statearr_17517_17557[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17473);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17516;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17558 = state_17473;
state_17473 = G__17558;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_17473){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_17473);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14378__auto___17524,out))
})();
var state__14380__auto__ = (function (){var statearr_17518 = f__14379__auto__.call(null);
(statearr_17518[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14378__auto___17524);

return statearr_17518;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14380__auto__);
});})(c__14378__auto___17524,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args17559 = [];
var len__7107__auto___17640 = arguments.length;
var i__7108__auto___17641 = (0);
while(true){
if((i__7108__auto___17641 < len__7107__auto___17640)){
args17559.push((arguments[i__7108__auto___17641]));

var G__17642 = (i__7108__auto___17641 + (1));
i__7108__auto___17641 = G__17642;
continue;
} else {
}
break;
}

var G__17561 = args17559.length;
switch (G__17561) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17559.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14378__auto___17644 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14378__auto___17644,out){
return (function (){
var f__14379__auto__ = (function (){var switch__14236__auto__ = ((function (c__14378__auto___17644,out){
return (function (state_17607){
var state_val_17608 = (state_17607[(1)]);
if((state_val_17608 === (7))){
var inst_17602 = (state_17607[(2)]);
var state_17607__$1 = state_17607;
var statearr_17609_17646 = state_17607__$1;
(statearr_17609_17646[(2)] = inst_17602);

(statearr_17609_17646[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17608 === (1))){
var inst_17564 = [];
var inst_17566 = inst_17564;
var inst_17567 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_17607__$1 = (function (){var statearr_17610 = state_17607;
(statearr_17610[(7)] = inst_17567);

(statearr_17610[(8)] = inst_17566);

return statearr_17610;
})();
var statearr_17611_17647 = state_17607__$1;
(statearr_17611_17647[(2)] = null);

(statearr_17611_17647[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17608 === (4))){
var inst_17570 = (state_17607[(9)]);
var inst_17570__$1 = (state_17607[(2)]);
var inst_17571 = (inst_17570__$1 == null);
var inst_17572 = cljs.core.not.call(null,inst_17571);
var state_17607__$1 = (function (){var statearr_17612 = state_17607;
(statearr_17612[(9)] = inst_17570__$1);

return statearr_17612;
})();
if(inst_17572){
var statearr_17613_17648 = state_17607__$1;
(statearr_17613_17648[(1)] = (5));

} else {
var statearr_17614_17649 = state_17607__$1;
(statearr_17614_17649[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17608 === (15))){
var inst_17596 = (state_17607[(2)]);
var state_17607__$1 = state_17607;
var statearr_17615_17650 = state_17607__$1;
(statearr_17615_17650[(2)] = inst_17596);

(statearr_17615_17650[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17608 === (13))){
var state_17607__$1 = state_17607;
var statearr_17616_17651 = state_17607__$1;
(statearr_17616_17651[(2)] = null);

(statearr_17616_17651[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17608 === (6))){
var inst_17566 = (state_17607[(8)]);
var inst_17591 = inst_17566.length;
var inst_17592 = (inst_17591 > (0));
var state_17607__$1 = state_17607;
if(cljs.core.truth_(inst_17592)){
var statearr_17617_17652 = state_17607__$1;
(statearr_17617_17652[(1)] = (12));

} else {
var statearr_17618_17653 = state_17607__$1;
(statearr_17618_17653[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17608 === (3))){
var inst_17604 = (state_17607[(2)]);
var state_17607__$1 = state_17607;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17607__$1,inst_17604);
} else {
if((state_val_17608 === (12))){
var inst_17566 = (state_17607[(8)]);
var inst_17594 = cljs.core.vec.call(null,inst_17566);
var state_17607__$1 = state_17607;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17607__$1,(15),out,inst_17594);
} else {
if((state_val_17608 === (2))){
var state_17607__$1 = state_17607;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17607__$1,(4),ch);
} else {
if((state_val_17608 === (11))){
var inst_17570 = (state_17607[(9)]);
var inst_17574 = (state_17607[(10)]);
var inst_17584 = (state_17607[(2)]);
var inst_17585 = [];
var inst_17586 = inst_17585.push(inst_17570);
var inst_17566 = inst_17585;
var inst_17567 = inst_17574;
var state_17607__$1 = (function (){var statearr_17619 = state_17607;
(statearr_17619[(11)] = inst_17584);

(statearr_17619[(12)] = inst_17586);

(statearr_17619[(7)] = inst_17567);

(statearr_17619[(8)] = inst_17566);

return statearr_17619;
})();
var statearr_17620_17654 = state_17607__$1;
(statearr_17620_17654[(2)] = null);

(statearr_17620_17654[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17608 === (9))){
var inst_17566 = (state_17607[(8)]);
var inst_17582 = cljs.core.vec.call(null,inst_17566);
var state_17607__$1 = state_17607;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17607__$1,(11),out,inst_17582);
} else {
if((state_val_17608 === (5))){
var inst_17570 = (state_17607[(9)]);
var inst_17567 = (state_17607[(7)]);
var inst_17574 = (state_17607[(10)]);
var inst_17574__$1 = f.call(null,inst_17570);
var inst_17575 = cljs.core._EQ_.call(null,inst_17574__$1,inst_17567);
var inst_17576 = cljs.core.keyword_identical_QMARK_.call(null,inst_17567,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_17577 = (inst_17575) || (inst_17576);
var state_17607__$1 = (function (){var statearr_17624 = state_17607;
(statearr_17624[(10)] = inst_17574__$1);

return statearr_17624;
})();
if(cljs.core.truth_(inst_17577)){
var statearr_17625_17655 = state_17607__$1;
(statearr_17625_17655[(1)] = (8));

} else {
var statearr_17626_17656 = state_17607__$1;
(statearr_17626_17656[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17608 === (14))){
var inst_17599 = (state_17607[(2)]);
var inst_17600 = cljs.core.async.close_BANG_.call(null,out);
var state_17607__$1 = (function (){var statearr_17628 = state_17607;
(statearr_17628[(13)] = inst_17599);

return statearr_17628;
})();
var statearr_17629_17657 = state_17607__$1;
(statearr_17629_17657[(2)] = inst_17600);

(statearr_17629_17657[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17608 === (10))){
var inst_17589 = (state_17607[(2)]);
var state_17607__$1 = state_17607;
var statearr_17630_17658 = state_17607__$1;
(statearr_17630_17658[(2)] = inst_17589);

(statearr_17630_17658[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17608 === (8))){
var inst_17570 = (state_17607[(9)]);
var inst_17574 = (state_17607[(10)]);
var inst_17566 = (state_17607[(8)]);
var inst_17579 = inst_17566.push(inst_17570);
var tmp17627 = inst_17566;
var inst_17566__$1 = tmp17627;
var inst_17567 = inst_17574;
var state_17607__$1 = (function (){var statearr_17631 = state_17607;
(statearr_17631[(7)] = inst_17567);

(statearr_17631[(14)] = inst_17579);

(statearr_17631[(8)] = inst_17566__$1);

return statearr_17631;
})();
var statearr_17632_17662 = state_17607__$1;
(statearr_17632_17662[(2)] = null);

(statearr_17632_17662[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14378__auto___17644,out))
;
return ((function (switch__14236__auto__,c__14378__auto___17644,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_17636 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17636[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_17636[(1)] = (1));

return statearr_17636;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_17607){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_17607);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e17637){if((e17637 instanceof Object)){
var ex__14240__auto__ = e17637;
var statearr_17638_17664 = state_17607;
(statearr_17638_17664[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17607);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17637;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17665 = state_17607;
state_17607 = G__17665;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_17607){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_17607);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14378__auto___17644,out))
})();
var state__14380__auto__ = (function (){var statearr_17639 = f__14379__auto__.call(null);
(statearr_17639[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14378__auto___17644);

return statearr_17639;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14380__auto__);
});})(c__14378__auto___17644,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map?rel=1472801976450