// Compiled by ClojureScript 1.7.228 {}
goog.provide('cublono_quiescent.interpreter');
goog.require('cljs.core');
goog.require('cublono.normalize');
goog.require('cublono.util');
goog.require('quiescent.dom');
goog.require('clojure.string');
goog.require('quiescent.factory');

/**
 * @interface
 */
cublono_quiescent.interpreter.Interpretable = function(){};

/**
 * Interpret a Clojure data structure as a Queiscient structure
 */
cublono_quiescent.interpreter.interpret = (function cublono_quiescent$interpreter$interpret(this$){
if((!((this$ == null))) && (!((this$.cublono_quiescent$interpreter$Interpretable$interpret$arity$1 == null)))){
return this$.cublono_quiescent$interpreter$Interpretable$interpret$arity$1(this$);
} else {
var x__6704__auto__ = (((this$ == null))?null:this$);
var m__6705__auto__ = (cublono_quiescent.interpreter.interpret[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,this$);
} else {
var m__6705__auto____$1 = (cublono_quiescent.interpreter.interpret["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"Interpretable.interpret",this$);
}
}
}
});

cublono_quiescent.interpreter.tag__GT_component = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"thead","thead",-291875296),new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.Keyword(null,"del","del",574975584),new cljs.core.Keyword(null,"fieldset","fieldset",-1949770816),new cljs.core.Keyword(null,"mask","mask",-585748447),new cljs.core.Keyword(null,"q","q",689001697),new cljs.core.Keyword(null,"figure","figure",-561394079),new cljs.core.Keyword(null,"aside","aside",1414397537),new cljs.core.Keyword(null,"figcaption","figcaption",-1790122047),new cljs.core.Keyword(null,"video","video",156888130),new cljs.core.Keyword(null,"address","address",559499426),new cljs.core.Keyword(null,"caption","caption",-855383902),new cljs.core.Keyword(null,"bdi","bdi",-1323025886),new cljs.core.Keyword(null,"rp","rp",2006698083),new cljs.core.Keyword(null,"hr","hr",1377740067),new cljs.core.Keyword(null,"dd","dd",-1340437629),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"tbody","tbody",-80678300),new cljs.core.Keyword(null,"table","table",-564943036),new cljs.core.Keyword(null,"ul","ul",-1349521403),new cljs.core.Keyword(null,"pre","pre",2118456869),new cljs.core.Keyword(null,"sup","sup",-2039492346),new cljs.core.Keyword(null,"script","script",-1304443801),new cljs.core.Keyword(null,"big","big",903550151),new cljs.core.Keyword(null,"button","button",1456579943),new cljs.core.Keyword(null,"dfn","dfn",241908167),new cljs.core.Keyword(null,"sub","sub",-2093760025),new cljs.core.Keyword(null,"mark","mark",-373816345),new cljs.core.Keyword(null,"wbr","wbr",228661800),new cljs.core.Keyword(null,"strong","strong",269529000),new cljs.core.Keyword(null,"td","td",1479933353),new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.Keyword(null,"dt","dt",-368444759),new cljs.core.Keyword(null,"section","section",-300141526),new cljs.core.Keyword(null,"th","th",-545608566),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.Keyword(null,"iframe","iframe",884422026),new cljs.core.Keyword(null,"tr","tr",-1424774646),new cljs.core.Keyword(null,"circle","circle",1903212362),new cljs.core.Keyword(null,"article","article",-21685045),new cljs.core.Keyword(null,"clipPath","clipPath",-934619797),new cljs.core.Keyword(null,"legend","legend",-1027192245),new cljs.core.Keyword(null,"em","em",707813035),new cljs.core.Keyword(null,"kbd","kbd",316156875),new cljs.core.Keyword(null,"abbr","abbr",2088591884),new cljs.core.Keyword(null,"source","source",-433931539),new cljs.core.Keyword(null,"output","output",-1105869043),new cljs.core.Keyword(null,"ins","ins",-1021983570),new cljs.core.Keyword(null,"footer","footer",1606445390),new cljs.core.Keyword(null,"header","header",119441134),new cljs.core.Keyword(null,"datalist","datalist",-1235043474),new cljs.core.Keyword(null,"tfoot","tfoot",-701599890),new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"h5","h5",-1829156625),new cljs.core.Keyword(null,"canvas","canvas",-1798817489),new cljs.core.Keyword(null,"param","param",2013631823),new cljs.core.Keyword(null,"title","title",636505583),new cljs.core.Keyword(null,"small","small",2133478704),new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.Keyword(null,"summary","summary",380847952),new cljs.core.Keyword(null,"samp","samp",1506141136),new cljs.core.Keyword(null,"h4","h4",2004862993),new cljs.core.Keyword(null,"head","head",-771383919),new cljs.core.Keyword(null,"g","g",1738089905),new cljs.core.Keyword(null,"stop","stop",-2140911342),new cljs.core.Keyword(null,"ol","ol",932524051),new cljs.core.Keyword(null,"details","details",1956795411),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"var","var",-769682797),new cljs.core.Keyword(null,"tspan","tspan",-1557853197),new cljs.core.Keyword(null,"h6","h6",557293780),new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.Keyword(null,"col","col",-1959363084),new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.Keyword(null,"rt","rt",623480692),new cljs.core.Keyword(null,"colgroup","colgroup",651118645),new cljs.core.Keyword(null,"meter","meter",-187641611),new cljs.core.Keyword(null,"defs","defs",1398449717),new cljs.core.Keyword(null,"svg","svg",856789142),new cljs.core.Keyword(null,"ellipse","ellipse",1135891702),new cljs.core.Keyword(null,"code","code",1586293142),new cljs.core.Keyword(null,"bdo","bdo",-2131148202),new cljs.core.Keyword(null,"b","b",1482224470),new cljs.core.Keyword(null,"linearGradient","linearGradient",1711964727),new cljs.core.Keyword(null,"noscript","noscript",-704777289),new cljs.core.Keyword(null,"image","image",-58725096),new cljs.core.Keyword(null,"h2","h2",-372662728),new cljs.core.Keyword(null,"area","area",472007256),new cljs.core.Keyword(null,"br","br",934104792),new cljs.core.Keyword(null,"radialGradient","radialGradient",1402247193),new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.Keyword(null,"audio","audio",1819127321),new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.Keyword(null,"menuitem","menuitem",1004047353),new cljs.core.Keyword(null,"base","base",185279322),new cljs.core.Keyword(null,"h1","h1",-1896887462),new cljs.core.Keyword(null,"progress","progress",244323547),new cljs.core.Keyword(null,"main","main",-2117802661),new cljs.core.Keyword(null,"embed","embed",-1354913349),new cljs.core.Keyword(null,"h3","h3",2067611163),new cljs.core.Keyword(null,"body","body",-2049205669),new cljs.core.Keyword(null,"keygen","keygen",-571693253),new cljs.core.Keyword(null,"polyline","polyline",-1731551044),new cljs.core.Keyword(null,"cite","cite",1909439996),new cljs.core.Keyword(null,"rect","rect",-108902628),new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"nav","nav",719540477),new cljs.core.Keyword(null,"ruby","ruby",2000737661),new cljs.core.Keyword(null,"object","object",1474613949),new cljs.core.Keyword(null,"i","i",-1386841315),new cljs.core.Keyword(null,"menu","menu",352255198),new cljs.core.Keyword(null,"blockquote","blockquote",372264190),new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.Keyword(null,"dl","dl",-2140151713),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"polygon","polygon",837053759),new cljs.core.Keyword(null,"pattern","pattern",242135423),new cljs.core.Keyword(null,"html","html",-998796897),new cljs.core.Keyword(null,"text","text",-1790561697),new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.Keyword(null,"track","track",195787487),new cljs.core.Keyword(null,"data","data",-232669377),new cljs.core.Keyword(null,"u","u",-1156634785)],[quiescent.dom.thead,quiescent.dom.path,quiescent.dom.del,quiescent.dom.fieldset,quiescent.dom.mask,quiescent.dom.q,quiescent.dom.figure,quiescent.dom.aside,quiescent.dom.figcaption,quiescent.dom.video,quiescent.dom.address,quiescent.dom.caption,quiescent.dom.bdi,quiescent.dom.rp,quiescent.dom.hr,quiescent.dom.dd,quiescent.dom.meta,quiescent.dom.tbody,quiescent.dom.table,quiescent.dom.ul,quiescent.dom.pre,quiescent.dom.sup,quiescent.dom.script,quiescent.dom.big,quiescent.dom.button,quiescent.dom.dfn,quiescent.dom.sub,quiescent.dom.mark,quiescent.dom.wbr,quiescent.dom.strong,quiescent.dom.td,quiescent.dom.li,quiescent.dom.dt,quiescent.dom.section,quiescent.dom.th,quiescent.dom.time,quiescent.dom.optgroup,quiescent.dom.iframe,quiescent.dom.tr,quiescent.dom.circle,quiescent.dom.article,quiescent.dom.clipPath,quiescent.dom.legend,quiescent.dom.em,quiescent.dom.kbd,quiescent.dom.abbr,quiescent.dom.source,quiescent.dom.output,quiescent.dom.ins,quiescent.dom.footer,quiescent.dom.header,quiescent.dom.datalist,quiescent.dom.tfoot,quiescent.dom.s,quiescent.dom.h5,quiescent.dom.canvas,quiescent.dom.param,quiescent.dom.title,quiescent.dom.small,quiescent.dom.style,quiescent.dom.textarea,quiescent.dom.div,quiescent.dom.option,quiescent.dom.summary,quiescent.dom.samp,quiescent.dom.h4,quiescent.dom.head,quiescent.dom.g,quiescent.dom.stop,quiescent.dom.ol,quiescent.dom.details,quiescent.dom.line,quiescent.dom.var$,quiescent.dom.tspan,quiescent.dom.h6,quiescent.dom.link,quiescent.dom.col,quiescent.dom.label,quiescent.dom.rt,quiescent.dom.colgroup,quiescent.dom.meter,quiescent.dom.defs,quiescent.dom.svg,quiescent.dom.ellipse,quiescent.dom.code,quiescent.dom.bdo,quiescent.dom.b,quiescent.dom.linearGradient,quiescent.dom.noscript,quiescent.dom.image,quiescent.dom.h2,quiescent.dom.area,quiescent.dom.br,quiescent.dom.radialGradient,quiescent.dom.form,quiescent.dom.audio,quiescent.dom.input,quiescent.dom.menuitem,quiescent.dom.base,quiescent.dom.h1,quiescent.dom.progress,quiescent.dom.main,quiescent.dom.embed,quiescent.dom.h3,quiescent.dom.body,quiescent.dom.keygen,quiescent.dom.polyline,quiescent.dom.cite,quiescent.dom.rect,quiescent.dom.p,quiescent.dom.nav,quiescent.dom.ruby,quiescent.dom.object,quiescent.dom.i,quiescent.dom.menu,quiescent.dom.blockquote,quiescent.dom.img,quiescent.dom.a,quiescent.dom.dl,quiescent.dom.select,quiescent.dom.polygon,quiescent.dom.pattern,quiescent.dom.html,quiescent.dom.text,quiescent.dom.span,quiescent.dom.track,quiescent.dom.data,quiescent.dom.u]);
cublono_quiescent.interpreter.make_component = (function cublono_quiescent$interpreter$make_component(tag,attrs,content){
var component = (function (){var or__6049__auto__ = cljs.core.get.call(null,cublono_quiescent.interpreter.tag__GT_component,tag);
if(cljs.core.truth_(or__6049__auto__)){
return or__6049__auto__;
} else {
var path_segments = cljs.core.conj.call(null,clojure.string.split.call(null,cljs.core.namespace.call(null,tag),/\./),cljs.core.name.call(null,tag));
var item = cljs.core.reduce.call(null,((function (path_segments,or__6049__auto__){
return (function (p1__11848_SHARP_,p2__11849_SHARP_){
return (p1__11848_SHARP_[p2__11849_SHARP_]);
});})(path_segments,or__6049__auto__))
,window,path_segments);
return quiescent.factory.factory.call(null,item);
}
})();
var sub_items = cljs.core.map.call(null,cublono_quiescent.interpreter.interpret,content);
return cljs.core.apply.call(null,component,attrs,sub_items);
});
/**
 * Render an element vector as a HTML element.
 */
cublono_quiescent.interpreter.element = (function cublono_quiescent$interpreter$element(element__$1){
var vec__11856 = cublono.normalize.element.call(null,element__$1);
var tag = cljs.core.nth.call(null,vec__11856,(0),null);
var attrs = cljs.core.nth.call(null,vec__11856,(1),null);
var content = cljs.core.nth.call(null,vec__11856,(2),null);
var classes = cljs.core.set.call(null,new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(attrs));
return cublono_quiescent.interpreter.make_component.call(null,tag,((function (vec__11856,tag,attrs,content,classes){
return (function (p1__11854_SHARP_){
if(cljs.core.empty_QMARK_.call(null,classes)){
return p1__11854_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__11854_SHARP_,new cljs.core.Keyword(null,"className","className",-1983287057),clojure.string.join.call(null," ",classes));
}
});})(vec__11856,tag,attrs,content,classes))
.call(null,cljs.core.dissoc.call(null,attrs,new cljs.core.Keyword(null,"class","class",-2030961996))),content);
});
cublono_quiescent.interpreter.interpret_seq = (function cublono_quiescent$interpreter$interpret_seq(s){
return cljs.core.map.call(null,cublono_quiescent.interpreter.interpret,s);
});
cljs.core.PersistentVector.prototype.cublono_quiescent$interpreter$Interpretable$ = true;

cljs.core.PersistentVector.prototype.cublono_quiescent$interpreter$Interpretable$interpret$arity$1 = (function (this$){
var this$__$1 = this;
if(cublono.util.element_QMARK_.call(null,this$__$1)){
return cublono_quiescent.interpreter.element.call(null,this$__$1);
} else {
return cublono_quiescent.interpreter.interpret_seq.call(null,this$__$1);
}
});

cljs.core.LazySeq.prototype.cublono_quiescent$interpreter$Interpretable$ = true;

cljs.core.LazySeq.prototype.cublono_quiescent$interpreter$Interpretable$interpret$arity$1 = (function (this$){
var this$__$1 = this;
return cublono_quiescent.interpreter.interpret_seq.call(null,this$__$1);
});

(cublono_quiescent.interpreter.Interpretable["_"] = true);

(cublono_quiescent.interpreter.interpret["_"] = (function (this$){
return this$;
}));

//# sourceMappingURL=interpreter.js.map?rel=1472801971805