// Compiled by ClojureScript 1.7.228 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args14400 = [];
var len__7107__auto___14412 = arguments.length;
var i__7108__auto___14413 = (0);
while(true){
if((i__7108__auto___14413 < len__7107__auto___14412)){
args14400.push((arguments[i__7108__auto___14413]));

var G__14414 = (i__7108__auto___14413 + (1));
i__7108__auto___14413 = G__14414;
continue;
} else {
}
break;
}

var G__14402 = args14400.length;
switch (G__14402) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14400.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async14403 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14403 = (function (f,blockable,meta14404){
this.f = f;
this.blockable = blockable;
this.meta14404 = meta14404;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14403.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14405,meta14404__$1){
var self__ = this;
var _14405__$1 = this;
return (new cljs.core.async.t_cljs$core$async14403(self__.f,self__.blockable,meta14404__$1));
});

cljs.core.async.t_cljs$core$async14403.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14405){
var self__ = this;
var _14405__$1 = this;
return self__.meta14404;
});

cljs.core.async.t_cljs$core$async14403.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async14403.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async14403.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async14403.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async14403.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta14404","meta14404",-1444863794,null)], null);
});

cljs.core.async.t_cljs$core$async14403.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14403.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14403";

cljs.core.async.t_cljs$core$async14403.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async14403");
});

cljs.core.async.__GT_t_cljs$core$async14403 = (function cljs$core$async$__GT_t_cljs$core$async14403(f__$1,blockable__$1,meta14404){
return (new cljs.core.async.t_cljs$core$async14403(f__$1,blockable__$1,meta14404));
});

}

return (new cljs.core.async.t_cljs$core$async14403(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args14428 = [];
var len__7107__auto___14431 = arguments.length;
var i__7108__auto___14432 = (0);
while(true){
if((i__7108__auto___14432 < len__7107__auto___14431)){
args14428.push((arguments[i__7108__auto___14432]));

var G__14433 = (i__7108__auto___14432 + (1));
i__7108__auto___14432 = G__14433;
continue;
} else {
}
break;
}

var G__14430 = args14428.length;
switch (G__14430) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14428.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args14435 = [];
var len__7107__auto___14438 = arguments.length;
var i__7108__auto___14439 = (0);
while(true){
if((i__7108__auto___14439 < len__7107__auto___14438)){
args14435.push((arguments[i__7108__auto___14439]));

var G__14440 = (i__7108__auto___14439 + (1));
i__7108__auto___14439 = G__14440;
continue;
} else {
}
break;
}

var G__14437 = args14435.length;
switch (G__14437) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14435.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args14442 = [];
var len__7107__auto___14445 = arguments.length;
var i__7108__auto___14446 = (0);
while(true){
if((i__7108__auto___14446 < len__7107__auto___14445)){
args14442.push((arguments[i__7108__auto___14446]));

var G__14447 = (i__7108__auto___14446 + (1));
i__7108__auto___14446 = G__14447;
continue;
} else {
}
break;
}

var G__14444 = args14442.length;
switch (G__14444) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14442.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_14449 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_14449);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_14449,ret){
return (function (){
return fn1.call(null,val_14449);
});})(val_14449,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args14450 = [];
var len__7107__auto___14453 = arguments.length;
var i__7108__auto___14454 = (0);
while(true){
if((i__7108__auto___14454 < len__7107__auto___14453)){
args14450.push((arguments[i__7108__auto___14454]));

var G__14455 = (i__7108__auto___14454 + (1));
i__7108__auto___14454 = G__14455;
continue;
} else {
}
break;
}

var G__14452 = args14450.length;
switch (G__14452) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14450.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__6952__auto___14464 = n;
var x_14465 = (0);
while(true){
if((x_14465 < n__6952__auto___14464)){
(a[x_14465] = (0));

var G__14466 = (x_14465 + (1));
x_14465 = G__14466;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__14467 = (i + (1));
i = G__14467;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async14471 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14471 = (function (alt_flag,flag,meta14472){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta14472 = meta14472;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14471.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_14473,meta14472__$1){
var self__ = this;
var _14473__$1 = this;
return (new cljs.core.async.t_cljs$core$async14471(self__.alt_flag,self__.flag,meta14472__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async14471.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_14473){
var self__ = this;
var _14473__$1 = this;
return self__.meta14472;
});})(flag))
;

cljs.core.async.t_cljs$core$async14471.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async14471.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async14471.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async14471.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async14471.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta14472","meta14472",-1148373749,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async14471.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14471.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14471";

cljs.core.async.t_cljs$core$async14471.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async14471");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async14471 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async14471(alt_flag__$1,flag__$1,meta14472){
return (new cljs.core.async.t_cljs$core$async14471(alt_flag__$1,flag__$1,meta14472));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async14471(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async14485 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14485 = (function (alt_handler,flag,cb,meta14486){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta14486 = meta14486;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14485.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14487,meta14486__$1){
var self__ = this;
var _14487__$1 = this;
return (new cljs.core.async.t_cljs$core$async14485(self__.alt_handler,self__.flag,self__.cb,meta14486__$1));
});

cljs.core.async.t_cljs$core$async14485.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14487){
var self__ = this;
var _14487__$1 = this;
return self__.meta14486;
});

cljs.core.async.t_cljs$core$async14485.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async14485.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async14485.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async14485.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async14485.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta14486","meta14486",-306925763,null)], null);
});

cljs.core.async.t_cljs$core$async14485.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14485.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14485";

cljs.core.async.t_cljs$core$async14485.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async14485");
});

cljs.core.async.__GT_t_cljs$core$async14485 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async14485(alt_handler__$1,flag__$1,cb__$1,meta14486){
return (new cljs.core.async.t_cljs$core$async14485(alt_handler__$1,flag__$1,cb__$1,meta14486));
});

}

return (new cljs.core.async.t_cljs$core$async14485(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__14493_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__14493_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__14494_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__14494_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__6049__auto__ = wport;
if(cljs.core.truth_(or__6049__auto__)){
return or__6049__auto__;
} else {
return port;
}
})()], null));
} else {
var G__14506 = (i + (1));
i = G__14506;
continue;
}
} else {
return null;
}
break;
}
})();
var or__6049__auto__ = ret;
if(cljs.core.truth_(or__6049__auto__)){
return or__6049__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__6037__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__6037__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__6037__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__7114__auto__ = [];
var len__7107__auto___14519 = arguments.length;
var i__7108__auto___14520 = (0);
while(true){
if((i__7108__auto___14520 < len__7107__auto___14519)){
args__7114__auto__.push((arguments[i__7108__auto___14520]));

var G__14521 = (i__7108__auto___14520 + (1));
i__7108__auto___14520 = G__14521;
continue;
} else {
}
break;
}

var argseq__7115__auto__ = ((((1) < args__7114__auto__.length))?(new cljs.core.IndexedSeq(args__7114__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7115__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__14513){
var map__14514 = p__14513;
var map__14514__$1 = ((((!((map__14514 == null)))?((((map__14514.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14514.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14514):map__14514);
var opts = map__14514__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq14511){
var G__14512 = cljs.core.first.call(null,seq14511);
var seq14511__$1 = cljs.core.next.call(null,seq14511);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__14512,seq14511__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args14526 = [];
var len__7107__auto___14585 = arguments.length;
var i__7108__auto___14586 = (0);
while(true){
if((i__7108__auto___14586 < len__7107__auto___14585)){
args14526.push((arguments[i__7108__auto___14586]));

var G__14587 = (i__7108__auto___14586 + (1));
i__7108__auto___14586 = G__14587;
continue;
} else {
}
break;
}

var G__14528 = args14526.length;
switch (G__14528) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14526.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__14349__auto___14589 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14349__auto___14589){
return (function (){
var f__14350__auto__ = (function (){var switch__14236__auto__ = ((function (c__14349__auto___14589){
return (function (state_14552){
var state_val_14553 = (state_14552[(1)]);
if((state_val_14553 === (7))){
var inst_14548 = (state_14552[(2)]);
var state_14552__$1 = state_14552;
var statearr_14554_14590 = state_14552__$1;
(statearr_14554_14590[(2)] = inst_14548);

(statearr_14554_14590[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14553 === (1))){
var state_14552__$1 = state_14552;
var statearr_14555_14592 = state_14552__$1;
(statearr_14555_14592[(2)] = null);

(statearr_14555_14592[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14553 === (4))){
var inst_14531 = (state_14552[(7)]);
var inst_14531__$1 = (state_14552[(2)]);
var inst_14532 = (inst_14531__$1 == null);
var state_14552__$1 = (function (){var statearr_14556 = state_14552;
(statearr_14556[(7)] = inst_14531__$1);

return statearr_14556;
})();
if(cljs.core.truth_(inst_14532)){
var statearr_14557_14594 = state_14552__$1;
(statearr_14557_14594[(1)] = (5));

} else {
var statearr_14558_14595 = state_14552__$1;
(statearr_14558_14595[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14553 === (13))){
var state_14552__$1 = state_14552;
var statearr_14561_14596 = state_14552__$1;
(statearr_14561_14596[(2)] = null);

(statearr_14561_14596[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14553 === (6))){
var inst_14531 = (state_14552[(7)]);
var state_14552__$1 = state_14552;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14552__$1,(11),to,inst_14531);
} else {
if((state_val_14553 === (3))){
var inst_14550 = (state_14552[(2)]);
var state_14552__$1 = state_14552;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14552__$1,inst_14550);
} else {
if((state_val_14553 === (12))){
var state_14552__$1 = state_14552;
var statearr_14566_14598 = state_14552__$1;
(statearr_14566_14598[(2)] = null);

(statearr_14566_14598[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14553 === (2))){
var state_14552__$1 = state_14552;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14552__$1,(4),from);
} else {
if((state_val_14553 === (11))){
var inst_14541 = (state_14552[(2)]);
var state_14552__$1 = state_14552;
if(cljs.core.truth_(inst_14541)){
var statearr_14567_14599 = state_14552__$1;
(statearr_14567_14599[(1)] = (12));

} else {
var statearr_14568_14600 = state_14552__$1;
(statearr_14568_14600[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14553 === (9))){
var state_14552__$1 = state_14552;
var statearr_14569_14601 = state_14552__$1;
(statearr_14569_14601[(2)] = null);

(statearr_14569_14601[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14553 === (5))){
var state_14552__$1 = state_14552;
if(cljs.core.truth_(close_QMARK_)){
var statearr_14570_14602 = state_14552__$1;
(statearr_14570_14602[(1)] = (8));

} else {
var statearr_14571_14603 = state_14552__$1;
(statearr_14571_14603[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14553 === (14))){
var inst_14546 = (state_14552[(2)]);
var state_14552__$1 = state_14552;
var statearr_14572_14604 = state_14552__$1;
(statearr_14572_14604[(2)] = inst_14546);

(statearr_14572_14604[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14553 === (10))){
var inst_14538 = (state_14552[(2)]);
var state_14552__$1 = state_14552;
var statearr_14573_14605 = state_14552__$1;
(statearr_14573_14605[(2)] = inst_14538);

(statearr_14573_14605[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14553 === (8))){
var inst_14535 = cljs.core.async.close_BANG_.call(null,to);
var state_14552__$1 = state_14552;
var statearr_14574_14606 = state_14552__$1;
(statearr_14574_14606[(2)] = inst_14535);

(statearr_14574_14606[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14349__auto___14589))
;
return ((function (switch__14236__auto__,c__14349__auto___14589){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_14578 = [null,null,null,null,null,null,null,null];
(statearr_14578[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_14578[(1)] = (1));

return statearr_14578;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_14552){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14552);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e14579){if((e14579 instanceof Object)){
var ex__14240__auto__ = e14579;
var statearr_14580_14607 = state_14552;
(statearr_14580_14607[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14552);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14579;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14608 = state_14552;
state_14552 = G__14608;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_14552){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_14552);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14349__auto___14589))
})();
var state__14351__auto__ = (function (){var statearr_14584 = f__14350__auto__.call(null);
(statearr_14584[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14349__auto___14589);

return statearr_14584;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14351__auto__);
});})(c__14349__auto___14589))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__14804){
var vec__14805 = p__14804;
var v = cljs.core.nth.call(null,vec__14805,(0),null);
var p = cljs.core.nth.call(null,vec__14805,(1),null);
var job = vec__14805;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__14349__auto___15017 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14349__auto___15017,res,vec__14805,v,p,job,jobs,results){
return (function (){
var f__14350__auto__ = (function (){var switch__14236__auto__ = ((function (c__14349__auto___15017,res,vec__14805,v,p,job,jobs,results){
return (function (state_14814){
var state_val_14815 = (state_14814[(1)]);
if((state_val_14815 === (1))){
var state_14814__$1 = state_14814;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14814__$1,(2),res,v);
} else {
if((state_val_14815 === (2))){
var inst_14808 = (state_14814[(2)]);
var inst_14812 = cljs.core.async.close_BANG_.call(null,res);
var state_14814__$1 = (function (){var statearr_14816 = state_14814;
(statearr_14816[(7)] = inst_14808);

return statearr_14816;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14814__$1,inst_14812);
} else {
return null;
}
}
});})(c__14349__auto___15017,res,vec__14805,v,p,job,jobs,results))
;
return ((function (switch__14236__auto__,c__14349__auto___15017,res,vec__14805,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_14824 = [null,null,null,null,null,null,null,null];
(statearr_14824[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__);

(statearr_14824[(1)] = (1));

return statearr_14824;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1 = (function (state_14814){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14814);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e14825){if((e14825 instanceof Object)){
var ex__14240__auto__ = e14825;
var statearr_14827_15018 = state_14814;
(statearr_14827_15018[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14814);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14825;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15019 = state_14814;
state_14814 = G__15019;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = function(state_14814){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1.call(this,state_14814);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14349__auto___15017,res,vec__14805,v,p,job,jobs,results))
})();
var state__14351__auto__ = (function (){var statearr_14829 = f__14350__auto__.call(null);
(statearr_14829[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14349__auto___15017);

return statearr_14829;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14351__auto__);
});})(c__14349__auto___15017,res,vec__14805,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__14830){
var vec__14831 = p__14830;
var v = cljs.core.nth.call(null,vec__14831,(0),null);
var p = cljs.core.nth.call(null,vec__14831,(1),null);
var job = vec__14831;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__6952__auto___15020 = n;
var __15021 = (0);
while(true){
if((__15021 < n__6952__auto___15020)){
var G__14833_15022 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__14833_15022) {
case "compute":
var c__14349__auto___15024 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__15021,c__14349__auto___15024,G__14833_15022,n__6952__auto___15020,jobs,results,process,async){
return (function (){
var f__14350__auto__ = (function (){var switch__14236__auto__ = ((function (__15021,c__14349__auto___15024,G__14833_15022,n__6952__auto___15020,jobs,results,process,async){
return (function (state_14847){
var state_val_14848 = (state_14847[(1)]);
if((state_val_14848 === (1))){
var state_14847__$1 = state_14847;
var statearr_14849_15025 = state_14847__$1;
(statearr_14849_15025[(2)] = null);

(statearr_14849_15025[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14848 === (2))){
var state_14847__$1 = state_14847;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14847__$1,(4),jobs);
} else {
if((state_val_14848 === (3))){
var inst_14845 = (state_14847[(2)]);
var state_14847__$1 = state_14847;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14847__$1,inst_14845);
} else {
if((state_val_14848 === (4))){
var inst_14837 = (state_14847[(2)]);
var inst_14838 = process.call(null,inst_14837);
var state_14847__$1 = state_14847;
if(cljs.core.truth_(inst_14838)){
var statearr_14851_15029 = state_14847__$1;
(statearr_14851_15029[(1)] = (5));

} else {
var statearr_14852_15030 = state_14847__$1;
(statearr_14852_15030[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14848 === (5))){
var state_14847__$1 = state_14847;
var statearr_14854_15032 = state_14847__$1;
(statearr_14854_15032[(2)] = null);

(statearr_14854_15032[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14848 === (6))){
var state_14847__$1 = state_14847;
var statearr_14855_15033 = state_14847__$1;
(statearr_14855_15033[(2)] = null);

(statearr_14855_15033[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14848 === (7))){
var inst_14843 = (state_14847[(2)]);
var state_14847__$1 = state_14847;
var statearr_14856_15034 = state_14847__$1;
(statearr_14856_15034[(2)] = inst_14843);

(statearr_14856_15034[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__15021,c__14349__auto___15024,G__14833_15022,n__6952__auto___15020,jobs,results,process,async))
;
return ((function (__15021,switch__14236__auto__,c__14349__auto___15024,G__14833_15022,n__6952__auto___15020,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_14861 = [null,null,null,null,null,null,null];
(statearr_14861[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__);

(statearr_14861[(1)] = (1));

return statearr_14861;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1 = (function (state_14847){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14847);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e14862){if((e14862 instanceof Object)){
var ex__14240__auto__ = e14862;
var statearr_14863_15038 = state_14847;
(statearr_14863_15038[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14847);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14862;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15039 = state_14847;
state_14847 = G__15039;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = function(state_14847){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1.call(this,state_14847);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__;
})()
;})(__15021,switch__14236__auto__,c__14349__auto___15024,G__14833_15022,n__6952__auto___15020,jobs,results,process,async))
})();
var state__14351__auto__ = (function (){var statearr_14864 = f__14350__auto__.call(null);
(statearr_14864[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14349__auto___15024);

return statearr_14864;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14351__auto__);
});})(__15021,c__14349__auto___15024,G__14833_15022,n__6952__auto___15020,jobs,results,process,async))
);


break;
case "async":
var c__14349__auto___15040 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__15021,c__14349__auto___15040,G__14833_15022,n__6952__auto___15020,jobs,results,process,async){
return (function (){
var f__14350__auto__ = (function (){var switch__14236__auto__ = ((function (__15021,c__14349__auto___15040,G__14833_15022,n__6952__auto___15020,jobs,results,process,async){
return (function (state_14877){
var state_val_14878 = (state_14877[(1)]);
if((state_val_14878 === (1))){
var state_14877__$1 = state_14877;
var statearr_14879_15042 = state_14877__$1;
(statearr_14879_15042[(2)] = null);

(statearr_14879_15042[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14878 === (2))){
var state_14877__$1 = state_14877;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14877__$1,(4),jobs);
} else {
if((state_val_14878 === (3))){
var inst_14875 = (state_14877[(2)]);
var state_14877__$1 = state_14877;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14877__$1,inst_14875);
} else {
if((state_val_14878 === (4))){
var inst_14867 = (state_14877[(2)]);
var inst_14868 = async.call(null,inst_14867);
var state_14877__$1 = state_14877;
if(cljs.core.truth_(inst_14868)){
var statearr_14880_15043 = state_14877__$1;
(statearr_14880_15043[(1)] = (5));

} else {
var statearr_14881_15044 = state_14877__$1;
(statearr_14881_15044[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14878 === (5))){
var state_14877__$1 = state_14877;
var statearr_14882_15045 = state_14877__$1;
(statearr_14882_15045[(2)] = null);

(statearr_14882_15045[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14878 === (6))){
var state_14877__$1 = state_14877;
var statearr_14883_15046 = state_14877__$1;
(statearr_14883_15046[(2)] = null);

(statearr_14883_15046[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14878 === (7))){
var inst_14873 = (state_14877[(2)]);
var state_14877__$1 = state_14877;
var statearr_14884_15047 = state_14877__$1;
(statearr_14884_15047[(2)] = inst_14873);

(statearr_14884_15047[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__15021,c__14349__auto___15040,G__14833_15022,n__6952__auto___15020,jobs,results,process,async))
;
return ((function (__15021,switch__14236__auto__,c__14349__auto___15040,G__14833_15022,n__6952__auto___15020,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_14890 = [null,null,null,null,null,null,null];
(statearr_14890[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__);

(statearr_14890[(1)] = (1));

return statearr_14890;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1 = (function (state_14877){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14877);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e14891){if((e14891 instanceof Object)){
var ex__14240__auto__ = e14891;
var statearr_14892_15048 = state_14877;
(statearr_14892_15048[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14877);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14891;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15049 = state_14877;
state_14877 = G__15049;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = function(state_14877){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1.call(this,state_14877);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__;
})()
;})(__15021,switch__14236__auto__,c__14349__auto___15040,G__14833_15022,n__6952__auto___15020,jobs,results,process,async))
})();
var state__14351__auto__ = (function (){var statearr_14893 = f__14350__auto__.call(null);
(statearr_14893[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14349__auto___15040);

return statearr_14893;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14351__auto__);
});})(__15021,c__14349__auto___15040,G__14833_15022,n__6952__auto___15020,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__15050 = (__15021 + (1));
__15021 = G__15050;
continue;
} else {
}
break;
}

var c__14349__auto___15051 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14349__auto___15051,jobs,results,process,async){
return (function (){
var f__14350__auto__ = (function (){var switch__14236__auto__ = ((function (c__14349__auto___15051,jobs,results,process,async){
return (function (state_14916){
var state_val_14917 = (state_14916[(1)]);
if((state_val_14917 === (1))){
var state_14916__$1 = state_14916;
var statearr_14918_15052 = state_14916__$1;
(statearr_14918_15052[(2)] = null);

(statearr_14918_15052[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (2))){
var state_14916__$1 = state_14916;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14916__$1,(4),from);
} else {
if((state_val_14917 === (3))){
var inst_14914 = (state_14916[(2)]);
var state_14916__$1 = state_14916;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14916__$1,inst_14914);
} else {
if((state_val_14917 === (4))){
var inst_14897 = (state_14916[(7)]);
var inst_14897__$1 = (state_14916[(2)]);
var inst_14898 = (inst_14897__$1 == null);
var state_14916__$1 = (function (){var statearr_14919 = state_14916;
(statearr_14919[(7)] = inst_14897__$1);

return statearr_14919;
})();
if(cljs.core.truth_(inst_14898)){
var statearr_14920_15053 = state_14916__$1;
(statearr_14920_15053[(1)] = (5));

} else {
var statearr_14921_15054 = state_14916__$1;
(statearr_14921_15054[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (5))){
var inst_14900 = cljs.core.async.close_BANG_.call(null,jobs);
var state_14916__$1 = state_14916;
var statearr_14922_15055 = state_14916__$1;
(statearr_14922_15055[(2)] = inst_14900);

(statearr_14922_15055[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (6))){
var inst_14902 = (state_14916[(8)]);
var inst_14897 = (state_14916[(7)]);
var inst_14902__$1 = cljs.core.async.chan.call(null,(1));
var inst_14903 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14904 = [inst_14897,inst_14902__$1];
var inst_14905 = (new cljs.core.PersistentVector(null,2,(5),inst_14903,inst_14904,null));
var state_14916__$1 = (function (){var statearr_14925 = state_14916;
(statearr_14925[(8)] = inst_14902__$1);

return statearr_14925;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14916__$1,(8),jobs,inst_14905);
} else {
if((state_val_14917 === (7))){
var inst_14912 = (state_14916[(2)]);
var state_14916__$1 = state_14916;
var statearr_14926_15056 = state_14916__$1;
(statearr_14926_15056[(2)] = inst_14912);

(statearr_14926_15056[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (8))){
var inst_14902 = (state_14916[(8)]);
var inst_14907 = (state_14916[(2)]);
var state_14916__$1 = (function (){var statearr_14927 = state_14916;
(statearr_14927[(9)] = inst_14907);

return statearr_14927;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14916__$1,(9),results,inst_14902);
} else {
if((state_val_14917 === (9))){
var inst_14909 = (state_14916[(2)]);
var state_14916__$1 = (function (){var statearr_14928 = state_14916;
(statearr_14928[(10)] = inst_14909);

return statearr_14928;
})();
var statearr_14929_15057 = state_14916__$1;
(statearr_14929_15057[(2)] = null);

(statearr_14929_15057[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__14349__auto___15051,jobs,results,process,async))
;
return ((function (switch__14236__auto__,c__14349__auto___15051,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_14933 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14933[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__);

(statearr_14933[(1)] = (1));

return statearr_14933;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1 = (function (state_14916){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14916);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e14934){if((e14934 instanceof Object)){
var ex__14240__auto__ = e14934;
var statearr_14935_15058 = state_14916;
(statearr_14935_15058[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14916);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14934;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15059 = state_14916;
state_14916 = G__15059;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = function(state_14916){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1.call(this,state_14916);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14349__auto___15051,jobs,results,process,async))
})();
var state__14351__auto__ = (function (){var statearr_14938 = f__14350__auto__.call(null);
(statearr_14938[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14349__auto___15051);

return statearr_14938;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14351__auto__);
});})(c__14349__auto___15051,jobs,results,process,async))
);


var c__14349__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14349__auto__,jobs,results,process,async){
return (function (){
var f__14350__auto__ = (function (){var switch__14236__auto__ = ((function (c__14349__auto__,jobs,results,process,async){
return (function (state_14977){
var state_val_14978 = (state_14977[(1)]);
if((state_val_14978 === (7))){
var inst_14973 = (state_14977[(2)]);
var state_14977__$1 = state_14977;
var statearr_14979_15060 = state_14977__$1;
(statearr_14979_15060[(2)] = inst_14973);

(statearr_14979_15060[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14978 === (20))){
var state_14977__$1 = state_14977;
var statearr_14980_15061 = state_14977__$1;
(statearr_14980_15061[(2)] = null);

(statearr_14980_15061[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14978 === (1))){
var state_14977__$1 = state_14977;
var statearr_14981_15062 = state_14977__$1;
(statearr_14981_15062[(2)] = null);

(statearr_14981_15062[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14978 === (4))){
var inst_14942 = (state_14977[(7)]);
var inst_14942__$1 = (state_14977[(2)]);
var inst_14943 = (inst_14942__$1 == null);
var state_14977__$1 = (function (){var statearr_14982 = state_14977;
(statearr_14982[(7)] = inst_14942__$1);

return statearr_14982;
})();
if(cljs.core.truth_(inst_14943)){
var statearr_14983_15063 = state_14977__$1;
(statearr_14983_15063[(1)] = (5));

} else {
var statearr_14984_15064 = state_14977__$1;
(statearr_14984_15064[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14978 === (15))){
var inst_14955 = (state_14977[(8)]);
var state_14977__$1 = state_14977;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14977__$1,(18),to,inst_14955);
} else {
if((state_val_14978 === (21))){
var inst_14968 = (state_14977[(2)]);
var state_14977__$1 = state_14977;
var statearr_14988_15065 = state_14977__$1;
(statearr_14988_15065[(2)] = inst_14968);

(statearr_14988_15065[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14978 === (13))){
var inst_14970 = (state_14977[(2)]);
var state_14977__$1 = (function (){var statearr_14989 = state_14977;
(statearr_14989[(9)] = inst_14970);

return statearr_14989;
})();
var statearr_14990_15066 = state_14977__$1;
(statearr_14990_15066[(2)] = null);

(statearr_14990_15066[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14978 === (6))){
var inst_14942 = (state_14977[(7)]);
var state_14977__$1 = state_14977;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14977__$1,(11),inst_14942);
} else {
if((state_val_14978 === (17))){
var inst_14963 = (state_14977[(2)]);
var state_14977__$1 = state_14977;
if(cljs.core.truth_(inst_14963)){
var statearr_14993_15067 = state_14977__$1;
(statearr_14993_15067[(1)] = (19));

} else {
var statearr_14994_15068 = state_14977__$1;
(statearr_14994_15068[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14978 === (3))){
var inst_14975 = (state_14977[(2)]);
var state_14977__$1 = state_14977;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14977__$1,inst_14975);
} else {
if((state_val_14978 === (12))){
var inst_14952 = (state_14977[(10)]);
var state_14977__$1 = state_14977;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14977__$1,(14),inst_14952);
} else {
if((state_val_14978 === (2))){
var state_14977__$1 = state_14977;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14977__$1,(4),results);
} else {
if((state_val_14978 === (19))){
var state_14977__$1 = state_14977;
var statearr_14995_15069 = state_14977__$1;
(statearr_14995_15069[(2)] = null);

(statearr_14995_15069[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14978 === (11))){
var inst_14952 = (state_14977[(2)]);
var state_14977__$1 = (function (){var statearr_14996 = state_14977;
(statearr_14996[(10)] = inst_14952);

return statearr_14996;
})();
var statearr_14997_15070 = state_14977__$1;
(statearr_14997_15070[(2)] = null);

(statearr_14997_15070[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14978 === (9))){
var state_14977__$1 = state_14977;
var statearr_14998_15071 = state_14977__$1;
(statearr_14998_15071[(2)] = null);

(statearr_14998_15071[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14978 === (5))){
var state_14977__$1 = state_14977;
if(cljs.core.truth_(close_QMARK_)){
var statearr_14999_15072 = state_14977__$1;
(statearr_14999_15072[(1)] = (8));

} else {
var statearr_15000_15073 = state_14977__$1;
(statearr_15000_15073[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14978 === (14))){
var inst_14955 = (state_14977[(8)]);
var inst_14957 = (state_14977[(11)]);
var inst_14955__$1 = (state_14977[(2)]);
var inst_14956 = (inst_14955__$1 == null);
var inst_14957__$1 = cljs.core.not.call(null,inst_14956);
var state_14977__$1 = (function (){var statearr_15001 = state_14977;
(statearr_15001[(8)] = inst_14955__$1);

(statearr_15001[(11)] = inst_14957__$1);

return statearr_15001;
})();
if(inst_14957__$1){
var statearr_15002_15074 = state_14977__$1;
(statearr_15002_15074[(1)] = (15));

} else {
var statearr_15003_15075 = state_14977__$1;
(statearr_15003_15075[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14978 === (16))){
var inst_14957 = (state_14977[(11)]);
var state_14977__$1 = state_14977;
var statearr_15004_15076 = state_14977__$1;
(statearr_15004_15076[(2)] = inst_14957);

(statearr_15004_15076[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14978 === (10))){
var inst_14949 = (state_14977[(2)]);
var state_14977__$1 = state_14977;
var statearr_15005_15077 = state_14977__$1;
(statearr_15005_15077[(2)] = inst_14949);

(statearr_15005_15077[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14978 === (18))){
var inst_14960 = (state_14977[(2)]);
var state_14977__$1 = state_14977;
var statearr_15006_15080 = state_14977__$1;
(statearr_15006_15080[(2)] = inst_14960);

(statearr_15006_15080[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14978 === (8))){
var inst_14946 = cljs.core.async.close_BANG_.call(null,to);
var state_14977__$1 = state_14977;
var statearr_15007_15081 = state_14977__$1;
(statearr_15007_15081[(2)] = inst_14946);

(statearr_15007_15081[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14349__auto__,jobs,results,process,async))
;
return ((function (switch__14236__auto__,c__14349__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_15011 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15011[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__);

(statearr_15011[(1)] = (1));

return statearr_15011;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1 = (function (state_14977){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_14977);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e15012){if((e15012 instanceof Object)){
var ex__14240__auto__ = e15012;
var statearr_15013_15082 = state_14977;
(statearr_15013_15082[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14977);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15012;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15083 = state_14977;
state_14977 = G__15083;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__ = function(state_14977){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1.call(this,state_14977);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14349__auto__,jobs,results,process,async))
})();
var state__14351__auto__ = (function (){var statearr_15014 = f__14350__auto__.call(null);
(statearr_15014[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14349__auto__);

return statearr_15014;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14351__auto__);
});})(c__14349__auto__,jobs,results,process,async))
);

return c__14349__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args15084 = [];
var len__7107__auto___15087 = arguments.length;
var i__7108__auto___15089 = (0);
while(true){
if((i__7108__auto___15089 < len__7107__auto___15087)){
args15084.push((arguments[i__7108__auto___15089]));

var G__15090 = (i__7108__auto___15089 + (1));
i__7108__auto___15089 = G__15090;
continue;
} else {
}
break;
}

var G__15086 = args15084.length;
switch (G__15086) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15084.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args15093 = [];
var len__7107__auto___15096 = arguments.length;
var i__7108__auto___15097 = (0);
while(true){
if((i__7108__auto___15097 < len__7107__auto___15096)){
args15093.push((arguments[i__7108__auto___15097]));

var G__15098 = (i__7108__auto___15097 + (1));
i__7108__auto___15097 = G__15098;
continue;
} else {
}
break;
}

var G__15095 = args15093.length;
switch (G__15095) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15093.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args15110 = [];
var len__7107__auto___15163 = arguments.length;
var i__7108__auto___15165 = (0);
while(true){
if((i__7108__auto___15165 < len__7107__auto___15163)){
args15110.push((arguments[i__7108__auto___15165]));

var G__15167 = (i__7108__auto___15165 + (1));
i__7108__auto___15165 = G__15167;
continue;
} else {
}
break;
}

var G__15112 = args15110.length;
switch (G__15112) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15110.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__14349__auto___15169 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14349__auto___15169,tc,fc){
return (function (){
var f__14350__auto__ = (function (){var switch__14236__auto__ = ((function (c__14349__auto___15169,tc,fc){
return (function (state_15138){
var state_val_15139 = (state_15138[(1)]);
if((state_val_15139 === (7))){
var inst_15134 = (state_15138[(2)]);
var state_15138__$1 = state_15138;
var statearr_15140_15170 = state_15138__$1;
(statearr_15140_15170[(2)] = inst_15134);

(statearr_15140_15170[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15139 === (1))){
var state_15138__$1 = state_15138;
var statearr_15141_15174 = state_15138__$1;
(statearr_15141_15174[(2)] = null);

(statearr_15141_15174[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15139 === (4))){
var inst_15115 = (state_15138[(7)]);
var inst_15115__$1 = (state_15138[(2)]);
var inst_15116 = (inst_15115__$1 == null);
var state_15138__$1 = (function (){var statearr_15142 = state_15138;
(statearr_15142[(7)] = inst_15115__$1);

return statearr_15142;
})();
if(cljs.core.truth_(inst_15116)){
var statearr_15143_15176 = state_15138__$1;
(statearr_15143_15176[(1)] = (5));

} else {
var statearr_15144_15177 = state_15138__$1;
(statearr_15144_15177[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15139 === (13))){
var state_15138__$1 = state_15138;
var statearr_15145_15178 = state_15138__$1;
(statearr_15145_15178[(2)] = null);

(statearr_15145_15178[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15139 === (6))){
var inst_15115 = (state_15138[(7)]);
var inst_15121 = p.call(null,inst_15115);
var state_15138__$1 = state_15138;
if(cljs.core.truth_(inst_15121)){
var statearr_15146_15179 = state_15138__$1;
(statearr_15146_15179[(1)] = (9));

} else {
var statearr_15147_15180 = state_15138__$1;
(statearr_15147_15180[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15139 === (3))){
var inst_15136 = (state_15138[(2)]);
var state_15138__$1 = state_15138;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15138__$1,inst_15136);
} else {
if((state_val_15139 === (12))){
var state_15138__$1 = state_15138;
var statearr_15148_15181 = state_15138__$1;
(statearr_15148_15181[(2)] = null);

(statearr_15148_15181[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15139 === (2))){
var state_15138__$1 = state_15138;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15138__$1,(4),ch);
} else {
if((state_val_15139 === (11))){
var inst_15115 = (state_15138[(7)]);
var inst_15125 = (state_15138[(2)]);
var state_15138__$1 = state_15138;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15138__$1,(8),inst_15125,inst_15115);
} else {
if((state_val_15139 === (9))){
var state_15138__$1 = state_15138;
var statearr_15149_15185 = state_15138__$1;
(statearr_15149_15185[(2)] = tc);

(statearr_15149_15185[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15139 === (5))){
var inst_15118 = cljs.core.async.close_BANG_.call(null,tc);
var inst_15119 = cljs.core.async.close_BANG_.call(null,fc);
var state_15138__$1 = (function (){var statearr_15150 = state_15138;
(statearr_15150[(8)] = inst_15118);

return statearr_15150;
})();
var statearr_15151_15186 = state_15138__$1;
(statearr_15151_15186[(2)] = inst_15119);

(statearr_15151_15186[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15139 === (14))){
var inst_15132 = (state_15138[(2)]);
var state_15138__$1 = state_15138;
var statearr_15152_15187 = state_15138__$1;
(statearr_15152_15187[(2)] = inst_15132);

(statearr_15152_15187[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15139 === (10))){
var state_15138__$1 = state_15138;
var statearr_15153_15188 = state_15138__$1;
(statearr_15153_15188[(2)] = fc);

(statearr_15153_15188[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15139 === (8))){
var inst_15127 = (state_15138[(2)]);
var state_15138__$1 = state_15138;
if(cljs.core.truth_(inst_15127)){
var statearr_15154_15190 = state_15138__$1;
(statearr_15154_15190[(1)] = (12));

} else {
var statearr_15155_15191 = state_15138__$1;
(statearr_15155_15191[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14349__auto___15169,tc,fc))
;
return ((function (switch__14236__auto__,c__14349__auto___15169,tc,fc){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_15159 = [null,null,null,null,null,null,null,null,null];
(statearr_15159[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_15159[(1)] = (1));

return statearr_15159;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_15138){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_15138);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e15160){if((e15160 instanceof Object)){
var ex__14240__auto__ = e15160;
var statearr_15161_15192 = state_15138;
(statearr_15161_15192[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15138);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15160;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15193 = state_15138;
state_15138 = G__15193;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_15138){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_15138);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14349__auto___15169,tc,fc))
})();
var state__14351__auto__ = (function (){var statearr_15162 = f__14350__auto__.call(null);
(statearr_15162[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14349__auto___15169);

return statearr_15162;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14351__auto__);
});})(c__14349__auto___15169,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__14349__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14349__auto__){
return (function (){
var f__14350__auto__ = (function (){var switch__14236__auto__ = ((function (c__14349__auto__){
return (function (state_15257){
var state_val_15258 = (state_15257[(1)]);
if((state_val_15258 === (7))){
var inst_15253 = (state_15257[(2)]);
var state_15257__$1 = state_15257;
var statearr_15259_15280 = state_15257__$1;
(statearr_15259_15280[(2)] = inst_15253);

(statearr_15259_15280[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15258 === (1))){
var inst_15237 = init;
var state_15257__$1 = (function (){var statearr_15260 = state_15257;
(statearr_15260[(7)] = inst_15237);

return statearr_15260;
})();
var statearr_15261_15281 = state_15257__$1;
(statearr_15261_15281[(2)] = null);

(statearr_15261_15281[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15258 === (4))){
var inst_15240 = (state_15257[(8)]);
var inst_15240__$1 = (state_15257[(2)]);
var inst_15241 = (inst_15240__$1 == null);
var state_15257__$1 = (function (){var statearr_15262 = state_15257;
(statearr_15262[(8)] = inst_15240__$1);

return statearr_15262;
})();
if(cljs.core.truth_(inst_15241)){
var statearr_15263_15282 = state_15257__$1;
(statearr_15263_15282[(1)] = (5));

} else {
var statearr_15264_15283 = state_15257__$1;
(statearr_15264_15283[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15258 === (6))){
var inst_15244 = (state_15257[(9)]);
var inst_15237 = (state_15257[(7)]);
var inst_15240 = (state_15257[(8)]);
var inst_15244__$1 = f.call(null,inst_15237,inst_15240);
var inst_15245 = cljs.core.reduced_QMARK_.call(null,inst_15244__$1);
var state_15257__$1 = (function (){var statearr_15265 = state_15257;
(statearr_15265[(9)] = inst_15244__$1);

return statearr_15265;
})();
if(inst_15245){
var statearr_15266_15284 = state_15257__$1;
(statearr_15266_15284[(1)] = (8));

} else {
var statearr_15267_15285 = state_15257__$1;
(statearr_15267_15285[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15258 === (3))){
var inst_15255 = (state_15257[(2)]);
var state_15257__$1 = state_15257;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15257__$1,inst_15255);
} else {
if((state_val_15258 === (2))){
var state_15257__$1 = state_15257;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15257__$1,(4),ch);
} else {
if((state_val_15258 === (9))){
var inst_15244 = (state_15257[(9)]);
var inst_15237 = inst_15244;
var state_15257__$1 = (function (){var statearr_15268 = state_15257;
(statearr_15268[(7)] = inst_15237);

return statearr_15268;
})();
var statearr_15269_15286 = state_15257__$1;
(statearr_15269_15286[(2)] = null);

(statearr_15269_15286[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15258 === (5))){
var inst_15237 = (state_15257[(7)]);
var state_15257__$1 = state_15257;
var statearr_15270_15287 = state_15257__$1;
(statearr_15270_15287[(2)] = inst_15237);

(statearr_15270_15287[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15258 === (10))){
var inst_15251 = (state_15257[(2)]);
var state_15257__$1 = state_15257;
var statearr_15271_15288 = state_15257__$1;
(statearr_15271_15288[(2)] = inst_15251);

(statearr_15271_15288[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15258 === (8))){
var inst_15244 = (state_15257[(9)]);
var inst_15247 = cljs.core.deref.call(null,inst_15244);
var state_15257__$1 = state_15257;
var statearr_15272_15293 = state_15257__$1;
(statearr_15272_15293[(2)] = inst_15247);

(statearr_15272_15293[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__14349__auto__))
;
return ((function (switch__14236__auto__,c__14349__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__14237__auto__ = null;
var cljs$core$async$reduce_$_state_machine__14237__auto____0 = (function (){
var statearr_15276 = [null,null,null,null,null,null,null,null,null,null];
(statearr_15276[(0)] = cljs$core$async$reduce_$_state_machine__14237__auto__);

(statearr_15276[(1)] = (1));

return statearr_15276;
});
var cljs$core$async$reduce_$_state_machine__14237__auto____1 = (function (state_15257){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_15257);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e15277){if((e15277 instanceof Object)){
var ex__14240__auto__ = e15277;
var statearr_15278_15303 = state_15257;
(statearr_15278_15303[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15257);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15277;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15309 = state_15257;
state_15257 = G__15309;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__14237__auto__ = function(state_15257){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__14237__auto____1.call(this,state_15257);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__14237__auto____0;
cljs$core$async$reduce_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__14237__auto____1;
return cljs$core$async$reduce_$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14349__auto__))
})();
var state__14351__auto__ = (function (){var statearr_15279 = f__14350__auto__.call(null);
(statearr_15279[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14349__auto__);

return statearr_15279;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14351__auto__);
});})(c__14349__auto__))
);

return c__14349__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args15317 = [];
var len__7107__auto___15373 = arguments.length;
var i__7108__auto___15374 = (0);
while(true){
if((i__7108__auto___15374 < len__7107__auto___15373)){
args15317.push((arguments[i__7108__auto___15374]));

var G__15375 = (i__7108__auto___15374 + (1));
i__7108__auto___15374 = G__15375;
continue;
} else {
}
break;
}

var G__15323 = args15317.length;
switch (G__15323) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15317.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__14349__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14349__auto__){
return (function (){
var f__14350__auto__ = (function (){var switch__14236__auto__ = ((function (c__14349__auto__){
return (function (state_15348){
var state_val_15349 = (state_15348[(1)]);
if((state_val_15349 === (7))){
var inst_15330 = (state_15348[(2)]);
var state_15348__$1 = state_15348;
var statearr_15350_15381 = state_15348__$1;
(statearr_15350_15381[(2)] = inst_15330);

(statearr_15350_15381[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15349 === (1))){
var inst_15324 = cljs.core.seq.call(null,coll);
var inst_15325 = inst_15324;
var state_15348__$1 = (function (){var statearr_15351 = state_15348;
(statearr_15351[(7)] = inst_15325);

return statearr_15351;
})();
var statearr_15352_15382 = state_15348__$1;
(statearr_15352_15382[(2)] = null);

(statearr_15352_15382[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15349 === (4))){
var inst_15325 = (state_15348[(7)]);
var inst_15328 = cljs.core.first.call(null,inst_15325);
var state_15348__$1 = state_15348;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15348__$1,(7),ch,inst_15328);
} else {
if((state_val_15349 === (13))){
var inst_15342 = (state_15348[(2)]);
var state_15348__$1 = state_15348;
var statearr_15353_15383 = state_15348__$1;
(statearr_15353_15383[(2)] = inst_15342);

(statearr_15353_15383[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15349 === (6))){
var inst_15333 = (state_15348[(2)]);
var state_15348__$1 = state_15348;
if(cljs.core.truth_(inst_15333)){
var statearr_15354_15384 = state_15348__$1;
(statearr_15354_15384[(1)] = (8));

} else {
var statearr_15355_15385 = state_15348__$1;
(statearr_15355_15385[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15349 === (3))){
var inst_15346 = (state_15348[(2)]);
var state_15348__$1 = state_15348;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15348__$1,inst_15346);
} else {
if((state_val_15349 === (12))){
var state_15348__$1 = state_15348;
var statearr_15356_15386 = state_15348__$1;
(statearr_15356_15386[(2)] = null);

(statearr_15356_15386[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15349 === (2))){
var inst_15325 = (state_15348[(7)]);
var state_15348__$1 = state_15348;
if(cljs.core.truth_(inst_15325)){
var statearr_15357_15387 = state_15348__$1;
(statearr_15357_15387[(1)] = (4));

} else {
var statearr_15358_15388 = state_15348__$1;
(statearr_15358_15388[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15349 === (11))){
var inst_15339 = cljs.core.async.close_BANG_.call(null,ch);
var state_15348__$1 = state_15348;
var statearr_15359_15389 = state_15348__$1;
(statearr_15359_15389[(2)] = inst_15339);

(statearr_15359_15389[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15349 === (9))){
var state_15348__$1 = state_15348;
if(cljs.core.truth_(close_QMARK_)){
var statearr_15360_15392 = state_15348__$1;
(statearr_15360_15392[(1)] = (11));

} else {
var statearr_15361_15394 = state_15348__$1;
(statearr_15361_15394[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15349 === (5))){
var inst_15325 = (state_15348[(7)]);
var state_15348__$1 = state_15348;
var statearr_15362_15395 = state_15348__$1;
(statearr_15362_15395[(2)] = inst_15325);

(statearr_15362_15395[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15349 === (10))){
var inst_15344 = (state_15348[(2)]);
var state_15348__$1 = state_15348;
var statearr_15363_15397 = state_15348__$1;
(statearr_15363_15397[(2)] = inst_15344);

(statearr_15363_15397[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15349 === (8))){
var inst_15325 = (state_15348[(7)]);
var inst_15335 = cljs.core.next.call(null,inst_15325);
var inst_15325__$1 = inst_15335;
var state_15348__$1 = (function (){var statearr_15364 = state_15348;
(statearr_15364[(7)] = inst_15325__$1);

return statearr_15364;
})();
var statearr_15365_15398 = state_15348__$1;
(statearr_15365_15398[(2)] = null);

(statearr_15365_15398[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14349__auto__))
;
return ((function (switch__14236__auto__,c__14349__auto__){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_15369 = [null,null,null,null,null,null,null,null];
(statearr_15369[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_15369[(1)] = (1));

return statearr_15369;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_15348){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_15348);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e15370){if((e15370 instanceof Object)){
var ex__14240__auto__ = e15370;
var statearr_15371_15399 = state_15348;
(statearr_15371_15399[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15348);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15370;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15403 = state_15348;
state_15348 = G__15403;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_15348){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_15348);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14349__auto__))
})();
var state__14351__auto__ = (function (){var statearr_15372 = f__14350__auto__.call(null);
(statearr_15372[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14349__auto__);

return statearr_15372;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14351__auto__);
});})(c__14349__auto__))
);

return c__14349__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__6704__auto__ = (((_ == null))?null:_);
var m__6705__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,_);
} else {
var m__6705__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__6705__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,ch);
} else {
var m__6705__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m);
} else {
var m__6705__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async15633 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15633 = (function (mult,ch,cs,meta15634){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta15634 = meta15634;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async15633.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_15635,meta15634__$1){
var self__ = this;
var _15635__$1 = this;
return (new cljs.core.async.t_cljs$core$async15633(self__.mult,self__.ch,self__.cs,meta15634__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async15633.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_15635){
var self__ = this;
var _15635__$1 = this;
return self__.meta15634;
});})(cs))
;

cljs.core.async.t_cljs$core$async15633.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async15633.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async15633.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async15633.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async15633.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async15633.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async15633.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta15634","meta15634",196713894,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async15633.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async15633.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15633";

cljs.core.async.t_cljs$core$async15633.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async15633");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async15633 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async15633(mult__$1,ch__$1,cs__$1,meta15634){
return (new cljs.core.async.t_cljs$core$async15633(mult__$1,ch__$1,cs__$1,meta15634));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async15633(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__14349__auto___15864 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14349__auto___15864,cs,m,dchan,dctr,done){
return (function (){
var f__14350__auto__ = (function (){var switch__14236__auto__ = ((function (c__14349__auto___15864,cs,m,dchan,dctr,done){
return (function (state_15766){
var state_val_15767 = (state_15766[(1)]);
if((state_val_15767 === (7))){
var inst_15762 = (state_15766[(2)]);
var state_15766__$1 = state_15766;
var statearr_15768_15865 = state_15766__$1;
(statearr_15768_15865[(2)] = inst_15762);

(statearr_15768_15865[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15767 === (20))){
var inst_15667 = (state_15766[(7)]);
var inst_15677 = cljs.core.first.call(null,inst_15667);
var inst_15678 = cljs.core.nth.call(null,inst_15677,(0),null);
var inst_15679 = cljs.core.nth.call(null,inst_15677,(1),null);
var state_15766__$1 = (function (){var statearr_15769 = state_15766;
(statearr_15769[(8)] = inst_15678);

return statearr_15769;
})();
if(cljs.core.truth_(inst_15679)){
var statearr_15770_15866 = state_15766__$1;
(statearr_15770_15866[(1)] = (22));

} else {
var statearr_15771_15867 = state_15766__$1;
(statearr_15771_15867[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15767 === (27))){
var inst_15707 = (state_15766[(9)]);
var inst_15714 = (state_15766[(10)]);
var inst_15638 = (state_15766[(11)]);
var inst_15709 = (state_15766[(12)]);
var inst_15714__$1 = cljs.core._nth.call(null,inst_15707,inst_15709);
var inst_15715 = cljs.core.async.put_BANG_.call(null,inst_15714__$1,inst_15638,done);
var state_15766__$1 = (function (){var statearr_15772 = state_15766;
(statearr_15772[(10)] = inst_15714__$1);

return statearr_15772;
})();
if(cljs.core.truth_(inst_15715)){
var statearr_15773_15868 = state_15766__$1;
(statearr_15773_15868[(1)] = (30));

} else {
var statearr_15774_15869 = state_15766__$1;
(statearr_15774_15869[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15767 === (1))){
var state_15766__$1 = state_15766;
var statearr_15775_15870 = state_15766__$1;
(statearr_15775_15870[(2)] = null);

(statearr_15775_15870[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15767 === (24))){
var inst_15667 = (state_15766[(7)]);
var inst_15684 = (state_15766[(2)]);
var inst_15685 = cljs.core.next.call(null,inst_15667);
var inst_15647 = inst_15685;
var inst_15648 = null;
var inst_15649 = (0);
var inst_15650 = (0);
var state_15766__$1 = (function (){var statearr_15776 = state_15766;
(statearr_15776[(13)] = inst_15647);

(statearr_15776[(14)] = inst_15684);

(statearr_15776[(15)] = inst_15649);

(statearr_15776[(16)] = inst_15648);

(statearr_15776[(17)] = inst_15650);

return statearr_15776;
})();
var statearr_15777_15871 = state_15766__$1;
(statearr_15777_15871[(2)] = null);

(statearr_15777_15871[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15767 === (39))){
var state_15766__$1 = state_15766;
var statearr_15781_15872 = state_15766__$1;
(statearr_15781_15872[(2)] = null);

(statearr_15781_15872[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15767 === (4))){
var inst_15638 = (state_15766[(11)]);
var inst_15638__$1 = (state_15766[(2)]);
var inst_15639 = (inst_15638__$1 == null);
var state_15766__$1 = (function (){var statearr_15782 = state_15766;
(statearr_15782[(11)] = inst_15638__$1);

return statearr_15782;
})();
if(cljs.core.truth_(inst_15639)){
var statearr_15783_15873 = state_15766__$1;
(statearr_15783_15873[(1)] = (5));

} else {
var statearr_15784_15874 = state_15766__$1;
(statearr_15784_15874[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15767 === (15))){
var inst_15647 = (state_15766[(13)]);
var inst_15649 = (state_15766[(15)]);
var inst_15648 = (state_15766[(16)]);
var inst_15650 = (state_15766[(17)]);
var inst_15663 = (state_15766[(2)]);
var inst_15664 = (inst_15650 + (1));
var tmp15778 = inst_15647;
var tmp15779 = inst_15649;
var tmp15780 = inst_15648;
var inst_15647__$1 = tmp15778;
var inst_15648__$1 = tmp15780;
var inst_15649__$1 = tmp15779;
var inst_15650__$1 = inst_15664;
var state_15766__$1 = (function (){var statearr_15787 = state_15766;
(statearr_15787[(18)] = inst_15663);

(statearr_15787[(13)] = inst_15647__$1);

(statearr_15787[(15)] = inst_15649__$1);

(statearr_15787[(16)] = inst_15648__$1);

(statearr_15787[(17)] = inst_15650__$1);

return statearr_15787;
})();
var statearr_15790_15875 = state_15766__$1;
(statearr_15790_15875[(2)] = null);

(statearr_15790_15875[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15767 === (21))){
var inst_15688 = (state_15766[(2)]);
var state_15766__$1 = state_15766;
var statearr_15795_15878 = state_15766__$1;
(statearr_15795_15878[(2)] = inst_15688);

(statearr_15795_15878[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15767 === (31))){
var inst_15714 = (state_15766[(10)]);
var inst_15718 = done.call(null,null);
var inst_15719 = cljs.core.async.untap_STAR_.call(null,m,inst_15714);
var state_15766__$1 = (function (){var statearr_15796 = state_15766;
(statearr_15796[(19)] = inst_15718);

return statearr_15796;
})();
var statearr_15797_15879 = state_15766__$1;
(statearr_15797_15879[(2)] = inst_15719);

(statearr_15797_15879[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15767 === (32))){
var inst_15707 = (state_15766[(9)]);
var inst_15708 = (state_15766[(20)]);
var inst_15706 = (state_15766[(21)]);
var inst_15709 = (state_15766[(12)]);
var inst_15721 = (state_15766[(2)]);
var inst_15722 = (inst_15709 + (1));
var tmp15791 = inst_15707;
var tmp15792 = inst_15708;
var tmp15793 = inst_15706;
var inst_15706__$1 = tmp15793;
var inst_15707__$1 = tmp15791;
var inst_15708__$1 = tmp15792;
var inst_15709__$1 = inst_15722;
var state_15766__$1 = (function (){var statearr_15798 = state_15766;
(statearr_15798[(22)] = inst_15721);

(statearr_15798[(9)] = inst_15707__$1);

(statearr_15798[(20)] = inst_15708__$1);

(statearr_15798[(21)] = inst_15706__$1);

(statearr_15798[(12)] = inst_15709__$1);

return statearr_15798;
})();
var statearr_15800_15880 = state_15766__$1;
(statearr_15800_15880[(2)] = null);

(statearr_15800_15880[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15767 === (40))){
var inst_15734 = (state_15766[(23)]);
var inst_15738 = done.call(null,null);
var inst_15739 = cljs.core.async.untap_STAR_.call(null,m,inst_15734);
var state_15766__$1 = (function (){var statearr_15801 = state_15766;
(statearr_15801[(24)] = inst_15738);

return statearr_15801;
})();
var statearr_15802_15881 = state_15766__$1;
(statearr_15802_15881[(2)] = inst_15739);

(statearr_15802_15881[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15767 === (33))){
var inst_15725 = (state_15766[(25)]);
var inst_15727 = cljs.core.chunked_seq_QMARK_.call(null,inst_15725);
var state_15766__$1 = state_15766;
if(inst_15727){
var statearr_15803_15882 = state_15766__$1;
(statearr_15803_15882[(1)] = (36));

} else {
var statearr_15804_15883 = state_15766__$1;
(statearr_15804_15883[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15767 === (13))){
var inst_15657 = (state_15766[(26)]);
var inst_15660 = cljs.core.async.close_BANG_.call(null,inst_15657);
var state_15766__$1 = state_15766;
var statearr_15805_15884 = state_15766__$1;
(statearr_15805_15884[(2)] = inst_15660);

(statearr_15805_15884[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15767 === (22))){
var inst_15678 = (state_15766[(8)]);
var inst_15681 = cljs.core.async.close_BANG_.call(null,inst_15678);
var state_15766__$1 = state_15766;
var statearr_15806_15885 = state_15766__$1;
(statearr_15806_15885[(2)] = inst_15681);

(statearr_15806_15885[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15767 === (36))){
var inst_15725 = (state_15766[(25)]);
var inst_15729 = cljs.core.chunk_first.call(null,inst_15725);
var inst_15730 = cljs.core.chunk_rest.call(null,inst_15725);
var inst_15731 = cljs.core.count.call(null,inst_15729);
var inst_15706 = inst_15730;
var inst_15707 = inst_15729;
var inst_15708 = inst_15731;
var inst_15709 = (0);
var state_15766__$1 = (function (){var statearr_15807 = state_15766;
(statearr_15807[(9)] = inst_15707);

(statearr_15807[(20)] = inst_15708);

(statearr_15807[(21)] = inst_15706);

(statearr_15807[(12)] = inst_15709);

return statearr_15807;
})();
var statearr_15808_15886 = state_15766__$1;
(statearr_15808_15886[(2)] = null);

(statearr_15808_15886[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15767 === (41))){
var inst_15725 = (state_15766[(25)]);
var inst_15741 = (state_15766[(2)]);
var inst_15742 = cljs.core.next.call(null,inst_15725);
var inst_15706 = inst_15742;
var inst_15707 = null;
var inst_15708 = (0);
var inst_15709 = (0);
var state_15766__$1 = (function (){var statearr_15809 = state_15766;
(statearr_15809[(9)] = inst_15707);

(statearr_15809[(20)] = inst_15708);

(statearr_15809[(27)] = inst_15741);

(statearr_15809[(21)] = inst_15706);

(statearr_15809[(12)] = inst_15709);

return statearr_15809;
})();
var statearr_15810_15887 = state_15766__$1;
(statearr_15810_15887[(2)] = null);

(statearr_15810_15887[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15767 === (43))){
var state_15766__$1 = state_15766;
var statearr_15811_15889 = state_15766__$1;
(statearr_15811_15889[(2)] = null);

(statearr_15811_15889[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15767 === (29))){
var inst_15750 = (state_15766[(2)]);
var state_15766__$1 = state_15766;
var statearr_15812_15891 = state_15766__$1;
(statearr_15812_15891[(2)] = inst_15750);

(statearr_15812_15891[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15767 === (44))){
var inst_15759 = (state_15766[(2)]);
var state_15766__$1 = (function (){var statearr_15813 = state_15766;
(statearr_15813[(28)] = inst_15759);

return statearr_15813;
})();
var statearr_15814_15892 = state_15766__$1;
(statearr_15814_15892[(2)] = null);

(statearr_15814_15892[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15767 === (6))){
var inst_15698 = (state_15766[(29)]);
var inst_15697 = cljs.core.deref.call(null,cs);
var inst_15698__$1 = cljs.core.keys.call(null,inst_15697);
var inst_15699 = cljs.core.count.call(null,inst_15698__$1);
var inst_15700 = cljs.core.reset_BANG_.call(null,dctr,inst_15699);
var inst_15705 = cljs.core.seq.call(null,inst_15698__$1);
var inst_15706 = inst_15705;
var inst_15707 = null;
var inst_15708 = (0);
var inst_15709 = (0);
var state_15766__$1 = (function (){var statearr_15818 = state_15766;
(statearr_15818[(9)] = inst_15707);

(statearr_15818[(30)] = inst_15700);

(statearr_15818[(20)] = inst_15708);

(statearr_15818[(21)] = inst_15706);

(statearr_15818[(12)] = inst_15709);

(statearr_15818[(29)] = inst_15698__$1);

return statearr_15818;
})();
var statearr_15819_15895 = state_15766__$1;
(statearr_15819_15895[(2)] = null);

(statearr_15819_15895[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15767 === (28))){
var inst_15725 = (state_15766[(25)]);
var inst_15706 = (state_15766[(21)]);
var inst_15725__$1 = cljs.core.seq.call(null,inst_15706);
var state_15766__$1 = (function (){var statearr_15820 = state_15766;
(statearr_15820[(25)] = inst_15725__$1);

return statearr_15820;
})();
if(inst_15725__$1){
var statearr_15821_15896 = state_15766__$1;
(statearr_15821_15896[(1)] = (33));

} else {
var statearr_15822_15897 = state_15766__$1;
(statearr_15822_15897[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15767 === (25))){
var inst_15708 = (state_15766[(20)]);
var inst_15709 = (state_15766[(12)]);
var inst_15711 = (inst_15709 < inst_15708);
var inst_15712 = inst_15711;
var state_15766__$1 = state_15766;
if(cljs.core.truth_(inst_15712)){
var statearr_15823_15901 = state_15766__$1;
(statearr_15823_15901[(1)] = (27));

} else {
var statearr_15824_15902 = state_15766__$1;
(statearr_15824_15902[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15767 === (34))){
var state_15766__$1 = state_15766;
var statearr_15825_15903 = state_15766__$1;
(statearr_15825_15903[(2)] = null);

(statearr_15825_15903[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15767 === (17))){
var state_15766__$1 = state_15766;
var statearr_15826_15904 = state_15766__$1;
(statearr_15826_15904[(2)] = null);

(statearr_15826_15904[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15767 === (3))){
var inst_15764 = (state_15766[(2)]);
var state_15766__$1 = state_15766;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15766__$1,inst_15764);
} else {
if((state_val_15767 === (12))){
var inst_15693 = (state_15766[(2)]);
var state_15766__$1 = state_15766;
var statearr_15827_15905 = state_15766__$1;
(statearr_15827_15905[(2)] = inst_15693);

(statearr_15827_15905[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15767 === (2))){
var state_15766__$1 = state_15766;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15766__$1,(4),ch);
} else {
if((state_val_15767 === (23))){
var state_15766__$1 = state_15766;
var statearr_15828_15906 = state_15766__$1;
(statearr_15828_15906[(2)] = null);

(statearr_15828_15906[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15767 === (35))){
var inst_15748 = (state_15766[(2)]);
var state_15766__$1 = state_15766;
var statearr_15829_15909 = state_15766__$1;
(statearr_15829_15909[(2)] = inst_15748);

(statearr_15829_15909[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15767 === (19))){
var inst_15667 = (state_15766[(7)]);
var inst_15671 = cljs.core.chunk_first.call(null,inst_15667);
var inst_15672 = cljs.core.chunk_rest.call(null,inst_15667);
var inst_15673 = cljs.core.count.call(null,inst_15671);
var inst_15647 = inst_15672;
var inst_15648 = inst_15671;
var inst_15649 = inst_15673;
var inst_15650 = (0);
var state_15766__$1 = (function (){var statearr_15830 = state_15766;
(statearr_15830[(13)] = inst_15647);

(statearr_15830[(15)] = inst_15649);

(statearr_15830[(16)] = inst_15648);

(statearr_15830[(17)] = inst_15650);

return statearr_15830;
})();
var statearr_15831_15912 = state_15766__$1;
(statearr_15831_15912[(2)] = null);

(statearr_15831_15912[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15767 === (11))){
var inst_15647 = (state_15766[(13)]);
var inst_15667 = (state_15766[(7)]);
var inst_15667__$1 = cljs.core.seq.call(null,inst_15647);
var state_15766__$1 = (function (){var statearr_15832 = state_15766;
(statearr_15832[(7)] = inst_15667__$1);

return statearr_15832;
})();
if(inst_15667__$1){
var statearr_15833_15913 = state_15766__$1;
(statearr_15833_15913[(1)] = (16));

} else {
var statearr_15834_15914 = state_15766__$1;
(statearr_15834_15914[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15767 === (9))){
var inst_15695 = (state_15766[(2)]);
var state_15766__$1 = state_15766;
var statearr_15836_15918 = state_15766__$1;
(statearr_15836_15918[(2)] = inst_15695);

(statearr_15836_15918[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15767 === (5))){
var inst_15645 = cljs.core.deref.call(null,cs);
var inst_15646 = cljs.core.seq.call(null,inst_15645);
var inst_15647 = inst_15646;
var inst_15648 = null;
var inst_15649 = (0);
var inst_15650 = (0);
var state_15766__$1 = (function (){var statearr_15837 = state_15766;
(statearr_15837[(13)] = inst_15647);

(statearr_15837[(15)] = inst_15649);

(statearr_15837[(16)] = inst_15648);

(statearr_15837[(17)] = inst_15650);

return statearr_15837;
})();
var statearr_15838_15919 = state_15766__$1;
(statearr_15838_15919[(2)] = null);

(statearr_15838_15919[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15767 === (14))){
var state_15766__$1 = state_15766;
var statearr_15839_15920 = state_15766__$1;
(statearr_15839_15920[(2)] = null);

(statearr_15839_15920[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15767 === (45))){
var inst_15756 = (state_15766[(2)]);
var state_15766__$1 = state_15766;
var statearr_15840_15921 = state_15766__$1;
(statearr_15840_15921[(2)] = inst_15756);

(statearr_15840_15921[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15767 === (26))){
var inst_15698 = (state_15766[(29)]);
var inst_15752 = (state_15766[(2)]);
var inst_15753 = cljs.core.seq.call(null,inst_15698);
var state_15766__$1 = (function (){var statearr_15841 = state_15766;
(statearr_15841[(31)] = inst_15752);

return statearr_15841;
})();
if(inst_15753){
var statearr_15842_15923 = state_15766__$1;
(statearr_15842_15923[(1)] = (42));

} else {
var statearr_15843_15924 = state_15766__$1;
(statearr_15843_15924[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15767 === (16))){
var inst_15667 = (state_15766[(7)]);
var inst_15669 = cljs.core.chunked_seq_QMARK_.call(null,inst_15667);
var state_15766__$1 = state_15766;
if(inst_15669){
var statearr_15844_15925 = state_15766__$1;
(statearr_15844_15925[(1)] = (19));

} else {
var statearr_15845_15926 = state_15766__$1;
(statearr_15845_15926[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15767 === (38))){
var inst_15745 = (state_15766[(2)]);
var state_15766__$1 = state_15766;
var statearr_15846_15927 = state_15766__$1;
(statearr_15846_15927[(2)] = inst_15745);

(statearr_15846_15927[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15767 === (30))){
var state_15766__$1 = state_15766;
var statearr_15847_15928 = state_15766__$1;
(statearr_15847_15928[(2)] = null);

(statearr_15847_15928[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15767 === (10))){
var inst_15648 = (state_15766[(16)]);
var inst_15650 = (state_15766[(17)]);
var inst_15656 = cljs.core._nth.call(null,inst_15648,inst_15650);
var inst_15657 = cljs.core.nth.call(null,inst_15656,(0),null);
var inst_15658 = cljs.core.nth.call(null,inst_15656,(1),null);
var state_15766__$1 = (function (){var statearr_15848 = state_15766;
(statearr_15848[(26)] = inst_15657);

return statearr_15848;
})();
if(cljs.core.truth_(inst_15658)){
var statearr_15849_15929 = state_15766__$1;
(statearr_15849_15929[(1)] = (13));

} else {
var statearr_15850_15930 = state_15766__$1;
(statearr_15850_15930[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15767 === (18))){
var inst_15691 = (state_15766[(2)]);
var state_15766__$1 = state_15766;
var statearr_15851_15931 = state_15766__$1;
(statearr_15851_15931[(2)] = inst_15691);

(statearr_15851_15931[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15767 === (42))){
var state_15766__$1 = state_15766;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15766__$1,(45),dchan);
} else {
if((state_val_15767 === (37))){
var inst_15725 = (state_15766[(25)]);
var inst_15734 = (state_15766[(23)]);
var inst_15638 = (state_15766[(11)]);
var inst_15734__$1 = cljs.core.first.call(null,inst_15725);
var inst_15735 = cljs.core.async.put_BANG_.call(null,inst_15734__$1,inst_15638,done);
var state_15766__$1 = (function (){var statearr_15852 = state_15766;
(statearr_15852[(23)] = inst_15734__$1);

return statearr_15852;
})();
if(cljs.core.truth_(inst_15735)){
var statearr_15853_15932 = state_15766__$1;
(statearr_15853_15932[(1)] = (39));

} else {
var statearr_15854_15933 = state_15766__$1;
(statearr_15854_15933[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15767 === (8))){
var inst_15649 = (state_15766[(15)]);
var inst_15650 = (state_15766[(17)]);
var inst_15652 = (inst_15650 < inst_15649);
var inst_15653 = inst_15652;
var state_15766__$1 = state_15766;
if(cljs.core.truth_(inst_15653)){
var statearr_15855_15934 = state_15766__$1;
(statearr_15855_15934[(1)] = (10));

} else {
var statearr_15856_15935 = state_15766__$1;
(statearr_15856_15935[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14349__auto___15864,cs,m,dchan,dctr,done))
;
return ((function (switch__14236__auto__,c__14349__auto___15864,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__14237__auto__ = null;
var cljs$core$async$mult_$_state_machine__14237__auto____0 = (function (){
var statearr_15860 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15860[(0)] = cljs$core$async$mult_$_state_machine__14237__auto__);

(statearr_15860[(1)] = (1));

return statearr_15860;
});
var cljs$core$async$mult_$_state_machine__14237__auto____1 = (function (state_15766){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_15766);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e15861){if((e15861 instanceof Object)){
var ex__14240__auto__ = e15861;
var statearr_15862_15936 = state_15766;
(statearr_15862_15936[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15766);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15861;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15937 = state_15766;
state_15766 = G__15937;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__14237__auto__ = function(state_15766){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__14237__auto____1.call(this,state_15766);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__14237__auto____0;
cljs$core$async$mult_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__14237__auto____1;
return cljs$core$async$mult_$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14349__auto___15864,cs,m,dchan,dctr,done))
})();
var state__14351__auto__ = (function (){var statearr_15863 = f__14350__auto__.call(null);
(statearr_15863[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14349__auto___15864);

return statearr_15863;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14351__auto__);
});})(c__14349__auto___15864,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args15943 = [];
var len__7107__auto___15947 = arguments.length;
var i__7108__auto___15948 = (0);
while(true){
if((i__7108__auto___15948 < len__7107__auto___15947)){
args15943.push((arguments[i__7108__auto___15948]));

var G__15949 = (i__7108__auto___15948 + (1));
i__7108__auto___15948 = G__15949;
continue;
} else {
}
break;
}

var G__15946 = args15943.length;
switch (G__15946) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15943.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,ch);
} else {
var m__6705__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,ch);
} else {
var m__6705__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m);
} else {
var m__6705__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,state_map);
} else {
var m__6705__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__6704__auto__ = (((m == null))?null:m);
var m__6705__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,m,mode);
} else {
var m__6705__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__7114__auto__ = [];
var len__7107__auto___15971 = arguments.length;
var i__7108__auto___15972 = (0);
while(true){
if((i__7108__auto___15972 < len__7107__auto___15971)){
args__7114__auto__.push((arguments[i__7108__auto___15972]));

var G__15973 = (i__7108__auto___15972 + (1));
i__7108__auto___15972 = G__15973;
continue;
} else {
}
break;
}

var argseq__7115__auto__ = ((((3) < args__7114__auto__.length))?(new cljs.core.IndexedSeq(args__7114__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7115__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__15963){
var map__15964 = p__15963;
var map__15964__$1 = ((((!((map__15964 == null)))?((((map__15964.cljs$lang$protocol_mask$partition0$ & (64))) || (map__15964.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__15964):map__15964);
var opts = map__15964__$1;
var statearr_15967_15974 = state;
(statearr_15967_15974[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__15964,map__15964__$1,opts){
return (function (val){
var statearr_15968_15978 = state;
(statearr_15968_15978[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__15964,map__15964__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_15969_15979 = state;
(statearr_15969_15979[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq15955){
var G__15956 = cljs.core.first.call(null,seq15955);
var seq15955__$1 = cljs.core.next.call(null,seq15955);
var G__15957 = cljs.core.first.call(null,seq15955__$1);
var seq15955__$2 = cljs.core.next.call(null,seq15955__$1);
var G__15958 = cljs.core.first.call(null,seq15955__$2);
var seq15955__$3 = cljs.core.next.call(null,seq15955__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__15956,G__15957,G__15958,seq15955__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async16160 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16160 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta16161){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta16161 = meta16161;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16160.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_16162,meta16161__$1){
var self__ = this;
var _16162__$1 = this;
return (new cljs.core.async.t_cljs$core$async16160(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta16161__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16160.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_16162){
var self__ = this;
var _16162__$1 = this;
return self__.meta16161;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16160.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async16160.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16160.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async16160.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16160.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16160.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16160.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16160.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16160.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta16161","meta16161",738012688,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16160.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16160.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16160";

cljs.core.async.t_cljs$core$async16160.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16160");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async16160 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async16160(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta16161){
return (new cljs.core.async.t_cljs$core$async16160(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta16161));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async16160(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__14349__auto___16337 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14349__auto___16337,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__14350__auto__ = (function (){var switch__14236__auto__ = ((function (c__14349__auto___16337,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_16261){
var state_val_16262 = (state_16261[(1)]);
if((state_val_16262 === (7))){
var inst_16179 = (state_16261[(2)]);
var state_16261__$1 = state_16261;
var statearr_16263_16338 = state_16261__$1;
(statearr_16263_16338[(2)] = inst_16179);

(statearr_16263_16338[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (20))){
var inst_16191 = (state_16261[(7)]);
var state_16261__$1 = state_16261;
var statearr_16264_16339 = state_16261__$1;
(statearr_16264_16339[(2)] = inst_16191);

(statearr_16264_16339[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (27))){
var state_16261__$1 = state_16261;
var statearr_16265_16340 = state_16261__$1;
(statearr_16265_16340[(2)] = null);

(statearr_16265_16340[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (1))){
var inst_16167 = (state_16261[(8)]);
var inst_16167__$1 = calc_state.call(null);
var inst_16169 = (inst_16167__$1 == null);
var inst_16170 = cljs.core.not.call(null,inst_16169);
var state_16261__$1 = (function (){var statearr_16266 = state_16261;
(statearr_16266[(8)] = inst_16167__$1);

return statearr_16266;
})();
if(inst_16170){
var statearr_16267_16341 = state_16261__$1;
(statearr_16267_16341[(1)] = (2));

} else {
var statearr_16268_16342 = state_16261__$1;
(statearr_16268_16342[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (24))){
var inst_16221 = (state_16261[(9)]);
var inst_16214 = (state_16261[(10)]);
var inst_16235 = (state_16261[(11)]);
var inst_16235__$1 = inst_16214.call(null,inst_16221);
var state_16261__$1 = (function (){var statearr_16269 = state_16261;
(statearr_16269[(11)] = inst_16235__$1);

return statearr_16269;
})();
if(cljs.core.truth_(inst_16235__$1)){
var statearr_16270_16345 = state_16261__$1;
(statearr_16270_16345[(1)] = (29));

} else {
var statearr_16271_16347 = state_16261__$1;
(statearr_16271_16347[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (4))){
var inst_16182 = (state_16261[(2)]);
var state_16261__$1 = state_16261;
if(cljs.core.truth_(inst_16182)){
var statearr_16272_16348 = state_16261__$1;
(statearr_16272_16348[(1)] = (8));

} else {
var statearr_16273_16349 = state_16261__$1;
(statearr_16273_16349[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (15))){
var inst_16208 = (state_16261[(2)]);
var state_16261__$1 = state_16261;
if(cljs.core.truth_(inst_16208)){
var statearr_16274_16353 = state_16261__$1;
(statearr_16274_16353[(1)] = (19));

} else {
var statearr_16275_16355 = state_16261__$1;
(statearr_16275_16355[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (21))){
var inst_16213 = (state_16261[(12)]);
var inst_16213__$1 = (state_16261[(2)]);
var inst_16214 = cljs.core.get.call(null,inst_16213__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_16215 = cljs.core.get.call(null,inst_16213__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_16216 = cljs.core.get.call(null,inst_16213__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_16261__$1 = (function (){var statearr_16276 = state_16261;
(statearr_16276[(13)] = inst_16215);

(statearr_16276[(12)] = inst_16213__$1);

(statearr_16276[(10)] = inst_16214);

return statearr_16276;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_16261__$1,(22),inst_16216);
} else {
if((state_val_16262 === (31))){
var inst_16243 = (state_16261[(2)]);
var state_16261__$1 = state_16261;
if(cljs.core.truth_(inst_16243)){
var statearr_16277_16356 = state_16261__$1;
(statearr_16277_16356[(1)] = (32));

} else {
var statearr_16278_16358 = state_16261__$1;
(statearr_16278_16358[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (32))){
var inst_16220 = (state_16261[(14)]);
var state_16261__$1 = state_16261;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16261__$1,(35),out,inst_16220);
} else {
if((state_val_16262 === (33))){
var inst_16213 = (state_16261[(12)]);
var inst_16191 = inst_16213;
var state_16261__$1 = (function (){var statearr_16279 = state_16261;
(statearr_16279[(7)] = inst_16191);

return statearr_16279;
})();
var statearr_16280_16363 = state_16261__$1;
(statearr_16280_16363[(2)] = null);

(statearr_16280_16363[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (13))){
var inst_16191 = (state_16261[(7)]);
var inst_16198 = inst_16191.cljs$lang$protocol_mask$partition0$;
var inst_16199 = (inst_16198 & (64));
var inst_16200 = inst_16191.cljs$core$ISeq$;
var inst_16201 = (inst_16199) || (inst_16200);
var state_16261__$1 = state_16261;
if(cljs.core.truth_(inst_16201)){
var statearr_16281_16365 = state_16261__$1;
(statearr_16281_16365[(1)] = (16));

} else {
var statearr_16282_16366 = state_16261__$1;
(statearr_16282_16366[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (22))){
var inst_16221 = (state_16261[(9)]);
var inst_16220 = (state_16261[(14)]);
var inst_16219 = (state_16261[(2)]);
var inst_16220__$1 = cljs.core.nth.call(null,inst_16219,(0),null);
var inst_16221__$1 = cljs.core.nth.call(null,inst_16219,(1),null);
var inst_16222 = (inst_16220__$1 == null);
var inst_16223 = cljs.core._EQ_.call(null,inst_16221__$1,change);
var inst_16224 = (inst_16222) || (inst_16223);
var state_16261__$1 = (function (){var statearr_16283 = state_16261;
(statearr_16283[(9)] = inst_16221__$1);

(statearr_16283[(14)] = inst_16220__$1);

return statearr_16283;
})();
if(cljs.core.truth_(inst_16224)){
var statearr_16284_16370 = state_16261__$1;
(statearr_16284_16370[(1)] = (23));

} else {
var statearr_16285_16371 = state_16261__$1;
(statearr_16285_16371[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (36))){
var inst_16213 = (state_16261[(12)]);
var inst_16191 = inst_16213;
var state_16261__$1 = (function (){var statearr_16286 = state_16261;
(statearr_16286[(7)] = inst_16191);

return statearr_16286;
})();
var statearr_16287_16372 = state_16261__$1;
(statearr_16287_16372[(2)] = null);

(statearr_16287_16372[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (29))){
var inst_16235 = (state_16261[(11)]);
var state_16261__$1 = state_16261;
var statearr_16288_16373 = state_16261__$1;
(statearr_16288_16373[(2)] = inst_16235);

(statearr_16288_16373[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (6))){
var state_16261__$1 = state_16261;
var statearr_16289_16374 = state_16261__$1;
(statearr_16289_16374[(2)] = false);

(statearr_16289_16374[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (28))){
var inst_16231 = (state_16261[(2)]);
var inst_16232 = calc_state.call(null);
var inst_16191 = inst_16232;
var state_16261__$1 = (function (){var statearr_16290 = state_16261;
(statearr_16290[(7)] = inst_16191);

(statearr_16290[(15)] = inst_16231);

return statearr_16290;
})();
var statearr_16291_16376 = state_16261__$1;
(statearr_16291_16376[(2)] = null);

(statearr_16291_16376[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (25))){
var inst_16257 = (state_16261[(2)]);
var state_16261__$1 = state_16261;
var statearr_16292_16377 = state_16261__$1;
(statearr_16292_16377[(2)] = inst_16257);

(statearr_16292_16377[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (34))){
var inst_16255 = (state_16261[(2)]);
var state_16261__$1 = state_16261;
var statearr_16293_16378 = state_16261__$1;
(statearr_16293_16378[(2)] = inst_16255);

(statearr_16293_16378[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (17))){
var state_16261__$1 = state_16261;
var statearr_16294_16379 = state_16261__$1;
(statearr_16294_16379[(2)] = false);

(statearr_16294_16379[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (3))){
var state_16261__$1 = state_16261;
var statearr_16295_16380 = state_16261__$1;
(statearr_16295_16380[(2)] = false);

(statearr_16295_16380[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (12))){
var inst_16259 = (state_16261[(2)]);
var state_16261__$1 = state_16261;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16261__$1,inst_16259);
} else {
if((state_val_16262 === (2))){
var inst_16167 = (state_16261[(8)]);
var inst_16172 = inst_16167.cljs$lang$protocol_mask$partition0$;
var inst_16173 = (inst_16172 & (64));
var inst_16174 = inst_16167.cljs$core$ISeq$;
var inst_16175 = (inst_16173) || (inst_16174);
var state_16261__$1 = state_16261;
if(cljs.core.truth_(inst_16175)){
var statearr_16296_16381 = state_16261__$1;
(statearr_16296_16381[(1)] = (5));

} else {
var statearr_16297_16382 = state_16261__$1;
(statearr_16297_16382[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (23))){
var inst_16220 = (state_16261[(14)]);
var inst_16226 = (inst_16220 == null);
var state_16261__$1 = state_16261;
if(cljs.core.truth_(inst_16226)){
var statearr_16298_16383 = state_16261__$1;
(statearr_16298_16383[(1)] = (26));

} else {
var statearr_16299_16384 = state_16261__$1;
(statearr_16299_16384[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (35))){
var inst_16246 = (state_16261[(2)]);
var state_16261__$1 = state_16261;
if(cljs.core.truth_(inst_16246)){
var statearr_16300_16385 = state_16261__$1;
(statearr_16300_16385[(1)] = (36));

} else {
var statearr_16301_16386 = state_16261__$1;
(statearr_16301_16386[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (19))){
var inst_16191 = (state_16261[(7)]);
var inst_16210 = cljs.core.apply.call(null,cljs.core.hash_map,inst_16191);
var state_16261__$1 = state_16261;
var statearr_16302_16387 = state_16261__$1;
(statearr_16302_16387[(2)] = inst_16210);

(statearr_16302_16387[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (11))){
var inst_16191 = (state_16261[(7)]);
var inst_16195 = (inst_16191 == null);
var inst_16196 = cljs.core.not.call(null,inst_16195);
var state_16261__$1 = state_16261;
if(inst_16196){
var statearr_16303_16388 = state_16261__$1;
(statearr_16303_16388[(1)] = (13));

} else {
var statearr_16304_16389 = state_16261__$1;
(statearr_16304_16389[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (9))){
var inst_16167 = (state_16261[(8)]);
var state_16261__$1 = state_16261;
var statearr_16305_16390 = state_16261__$1;
(statearr_16305_16390[(2)] = inst_16167);

(statearr_16305_16390[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (5))){
var state_16261__$1 = state_16261;
var statearr_16306_16391 = state_16261__$1;
(statearr_16306_16391[(2)] = true);

(statearr_16306_16391[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (14))){
var state_16261__$1 = state_16261;
var statearr_16307_16392 = state_16261__$1;
(statearr_16307_16392[(2)] = false);

(statearr_16307_16392[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (26))){
var inst_16221 = (state_16261[(9)]);
var inst_16228 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_16221);
var state_16261__$1 = state_16261;
var statearr_16308_16393 = state_16261__$1;
(statearr_16308_16393[(2)] = inst_16228);

(statearr_16308_16393[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (16))){
var state_16261__$1 = state_16261;
var statearr_16309_16394 = state_16261__$1;
(statearr_16309_16394[(2)] = true);

(statearr_16309_16394[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (38))){
var inst_16251 = (state_16261[(2)]);
var state_16261__$1 = state_16261;
var statearr_16311_16395 = state_16261__$1;
(statearr_16311_16395[(2)] = inst_16251);

(statearr_16311_16395[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (30))){
var inst_16215 = (state_16261[(13)]);
var inst_16221 = (state_16261[(9)]);
var inst_16214 = (state_16261[(10)]);
var inst_16238 = cljs.core.empty_QMARK_.call(null,inst_16214);
var inst_16239 = inst_16215.call(null,inst_16221);
var inst_16240 = cljs.core.not.call(null,inst_16239);
var inst_16241 = (inst_16238) && (inst_16240);
var state_16261__$1 = state_16261;
var statearr_16312_16396 = state_16261__$1;
(statearr_16312_16396[(2)] = inst_16241);

(statearr_16312_16396[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (10))){
var inst_16167 = (state_16261[(8)]);
var inst_16187 = (state_16261[(2)]);
var inst_16188 = cljs.core.get.call(null,inst_16187,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_16189 = cljs.core.get.call(null,inst_16187,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_16190 = cljs.core.get.call(null,inst_16187,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_16191 = inst_16167;
var state_16261__$1 = (function (){var statearr_16313 = state_16261;
(statearr_16313[(16)] = inst_16188);

(statearr_16313[(17)] = inst_16190);

(statearr_16313[(7)] = inst_16191);

(statearr_16313[(18)] = inst_16189);

return statearr_16313;
})();
var statearr_16314_16399 = state_16261__$1;
(statearr_16314_16399[(2)] = null);

(statearr_16314_16399[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (18))){
var inst_16205 = (state_16261[(2)]);
var state_16261__$1 = state_16261;
var statearr_16315_16400 = state_16261__$1;
(statearr_16315_16400[(2)] = inst_16205);

(statearr_16315_16400[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (37))){
var state_16261__$1 = state_16261;
var statearr_16316_16401 = state_16261__$1;
(statearr_16316_16401[(2)] = null);

(statearr_16316_16401[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16262 === (8))){
var inst_16167 = (state_16261[(8)]);
var inst_16184 = cljs.core.apply.call(null,cljs.core.hash_map,inst_16167);
var state_16261__$1 = state_16261;
var statearr_16319_16402 = state_16261__$1;
(statearr_16319_16402[(2)] = inst_16184);

(statearr_16319_16402[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14349__auto___16337,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__14236__auto__,c__14349__auto___16337,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__14237__auto__ = null;
var cljs$core$async$mix_$_state_machine__14237__auto____0 = (function (){
var statearr_16324 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16324[(0)] = cljs$core$async$mix_$_state_machine__14237__auto__);

(statearr_16324[(1)] = (1));

return statearr_16324;
});
var cljs$core$async$mix_$_state_machine__14237__auto____1 = (function (state_16261){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_16261);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e16325){if((e16325 instanceof Object)){
var ex__14240__auto__ = e16325;
var statearr_16326_16408 = state_16261;
(statearr_16326_16408[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16261);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16325;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16409 = state_16261;
state_16261 = G__16409;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__14237__auto__ = function(state_16261){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__14237__auto____1.call(this,state_16261);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__14237__auto____0;
cljs$core$async$mix_$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__14237__auto____1;
return cljs$core$async$mix_$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14349__auto___16337,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__14351__auto__ = (function (){var statearr_16327 = f__14350__auto__.call(null);
(statearr_16327[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14349__auto___16337);

return statearr_16327;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14351__auto__);
});})(c__14349__auto___16337,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__6704__auto__ = (((p == null))?null:p);
var m__6705__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__6705__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__6704__auto__ = (((p == null))?null:p);
var m__6705__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,p,v,ch);
} else {
var m__6705__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args16414 = [];
var len__7107__auto___16421 = arguments.length;
var i__7108__auto___16422 = (0);
while(true){
if((i__7108__auto___16422 < len__7107__auto___16421)){
args16414.push((arguments[i__7108__auto___16422]));

var G__16423 = (i__7108__auto___16422 + (1));
i__7108__auto___16422 = G__16423;
continue;
} else {
}
break;
}

var G__16419 = args16414.length;
switch (G__16419) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16414.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__6704__auto__ = (((p == null))?null:p);
var m__6705__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,p);
} else {
var m__6705__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__6704__auto__ = (((p == null))?null:p);
var m__6705__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,p,v);
} else {
var m__6705__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args16426 = [];
var len__7107__auto___16560 = arguments.length;
var i__7108__auto___16561 = (0);
while(true){
if((i__7108__auto___16561 < len__7107__auto___16560)){
args16426.push((arguments[i__7108__auto___16561]));

var G__16562 = (i__7108__auto___16561 + (1));
i__7108__auto___16561 = G__16562;
continue;
} else {
}
break;
}

var G__16428 = args16426.length;
switch (G__16428) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16426.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__6049__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__6049__auto__)){
return or__6049__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__6049__auto__,mults){
return (function (p1__16425_SHARP_){
if(cljs.core.truth_(p1__16425_SHARP_.call(null,topic))){
return p1__16425_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__16425_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__6049__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async16429 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16429 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta16430){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta16430 = meta16430;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16429.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_16431,meta16430__$1){
var self__ = this;
var _16431__$1 = this;
return (new cljs.core.async.t_cljs$core$async16429(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta16430__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16429.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_16431){
var self__ = this;
var _16431__$1 = this;
return self__.meta16430;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16429.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async16429.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16429.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async16429.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16429.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16429.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16429.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16429.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta16430","meta16430",-431687179,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16429.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16429.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16429";

cljs.core.async.t_cljs$core$async16429.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16429");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async16429 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async16429(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta16430){
return (new cljs.core.async.t_cljs$core$async16429(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta16430));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async16429(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__14349__auto___16568 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14349__auto___16568,mults,ensure_mult,p){
return (function (){
var f__14350__auto__ = (function (){var switch__14236__auto__ = ((function (c__14349__auto___16568,mults,ensure_mult,p){
return (function (state_16507){
var state_val_16508 = (state_16507[(1)]);
if((state_val_16508 === (7))){
var inst_16502 = (state_16507[(2)]);
var state_16507__$1 = state_16507;
var statearr_16509_16570 = state_16507__$1;
(statearr_16509_16570[(2)] = inst_16502);

(statearr_16509_16570[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16508 === (20))){
var state_16507__$1 = state_16507;
var statearr_16510_16571 = state_16507__$1;
(statearr_16510_16571[(2)] = null);

(statearr_16510_16571[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16508 === (1))){
var state_16507__$1 = state_16507;
var statearr_16512_16572 = state_16507__$1;
(statearr_16512_16572[(2)] = null);

(statearr_16512_16572[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16508 === (24))){
var inst_16483 = (state_16507[(7)]);
var inst_16494 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_16483);
var state_16507__$1 = state_16507;
var statearr_16513_16576 = state_16507__$1;
(statearr_16513_16576[(2)] = inst_16494);

(statearr_16513_16576[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16508 === (4))){
var inst_16434 = (state_16507[(8)]);
var inst_16434__$1 = (state_16507[(2)]);
var inst_16435 = (inst_16434__$1 == null);
var state_16507__$1 = (function (){var statearr_16514 = state_16507;
(statearr_16514[(8)] = inst_16434__$1);

return statearr_16514;
})();
if(cljs.core.truth_(inst_16435)){
var statearr_16515_16581 = state_16507__$1;
(statearr_16515_16581[(1)] = (5));

} else {
var statearr_16516_16582 = state_16507__$1;
(statearr_16516_16582[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16508 === (15))){
var inst_16476 = (state_16507[(2)]);
var state_16507__$1 = state_16507;
var statearr_16517_16583 = state_16507__$1;
(statearr_16517_16583[(2)] = inst_16476);

(statearr_16517_16583[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16508 === (21))){
var inst_16499 = (state_16507[(2)]);
var state_16507__$1 = (function (){var statearr_16518 = state_16507;
(statearr_16518[(9)] = inst_16499);

return statearr_16518;
})();
var statearr_16519_16584 = state_16507__$1;
(statearr_16519_16584[(2)] = null);

(statearr_16519_16584[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16508 === (13))){
var inst_16458 = (state_16507[(10)]);
var inst_16460 = cljs.core.chunked_seq_QMARK_.call(null,inst_16458);
var state_16507__$1 = state_16507;
if(inst_16460){
var statearr_16520_16585 = state_16507__$1;
(statearr_16520_16585[(1)] = (16));

} else {
var statearr_16521_16586 = state_16507__$1;
(statearr_16521_16586[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16508 === (22))){
var inst_16491 = (state_16507[(2)]);
var state_16507__$1 = state_16507;
if(cljs.core.truth_(inst_16491)){
var statearr_16522_16588 = state_16507__$1;
(statearr_16522_16588[(1)] = (23));

} else {
var statearr_16523_16589 = state_16507__$1;
(statearr_16523_16589[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16508 === (6))){
var inst_16485 = (state_16507[(11)]);
var inst_16483 = (state_16507[(7)]);
var inst_16434 = (state_16507[(8)]);
var inst_16483__$1 = topic_fn.call(null,inst_16434);
var inst_16484 = cljs.core.deref.call(null,mults);
var inst_16485__$1 = cljs.core.get.call(null,inst_16484,inst_16483__$1);
var state_16507__$1 = (function (){var statearr_16524 = state_16507;
(statearr_16524[(11)] = inst_16485__$1);

(statearr_16524[(7)] = inst_16483__$1);

return statearr_16524;
})();
if(cljs.core.truth_(inst_16485__$1)){
var statearr_16528_16590 = state_16507__$1;
(statearr_16528_16590[(1)] = (19));

} else {
var statearr_16529_16591 = state_16507__$1;
(statearr_16529_16591[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16508 === (25))){
var inst_16496 = (state_16507[(2)]);
var state_16507__$1 = state_16507;
var statearr_16530_16592 = state_16507__$1;
(statearr_16530_16592[(2)] = inst_16496);

(statearr_16530_16592[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16508 === (17))){
var inst_16458 = (state_16507[(10)]);
var inst_16467 = cljs.core.first.call(null,inst_16458);
var inst_16468 = cljs.core.async.muxch_STAR_.call(null,inst_16467);
var inst_16469 = cljs.core.async.close_BANG_.call(null,inst_16468);
var inst_16470 = cljs.core.next.call(null,inst_16458);
var inst_16444 = inst_16470;
var inst_16445 = null;
var inst_16446 = (0);
var inst_16447 = (0);
var state_16507__$1 = (function (){var statearr_16531 = state_16507;
(statearr_16531[(12)] = inst_16469);

(statearr_16531[(13)] = inst_16446);

(statearr_16531[(14)] = inst_16445);

(statearr_16531[(15)] = inst_16447);

(statearr_16531[(16)] = inst_16444);

return statearr_16531;
})();
var statearr_16532_16593 = state_16507__$1;
(statearr_16532_16593[(2)] = null);

(statearr_16532_16593[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16508 === (3))){
var inst_16504 = (state_16507[(2)]);
var state_16507__$1 = state_16507;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16507__$1,inst_16504);
} else {
if((state_val_16508 === (12))){
var inst_16478 = (state_16507[(2)]);
var state_16507__$1 = state_16507;
var statearr_16533_16594 = state_16507__$1;
(statearr_16533_16594[(2)] = inst_16478);

(statearr_16533_16594[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16508 === (2))){
var state_16507__$1 = state_16507;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16507__$1,(4),ch);
} else {
if((state_val_16508 === (23))){
var state_16507__$1 = state_16507;
var statearr_16534_16595 = state_16507__$1;
(statearr_16534_16595[(2)] = null);

(statearr_16534_16595[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16508 === (19))){
var inst_16485 = (state_16507[(11)]);
var inst_16434 = (state_16507[(8)]);
var inst_16489 = cljs.core.async.muxch_STAR_.call(null,inst_16485);
var state_16507__$1 = state_16507;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16507__$1,(22),inst_16489,inst_16434);
} else {
if((state_val_16508 === (11))){
var inst_16458 = (state_16507[(10)]);
var inst_16444 = (state_16507[(16)]);
var inst_16458__$1 = cljs.core.seq.call(null,inst_16444);
var state_16507__$1 = (function (){var statearr_16535 = state_16507;
(statearr_16535[(10)] = inst_16458__$1);

return statearr_16535;
})();
if(inst_16458__$1){
var statearr_16536_16596 = state_16507__$1;
(statearr_16536_16596[(1)] = (13));

} else {
var statearr_16537_16597 = state_16507__$1;
(statearr_16537_16597[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16508 === (9))){
var inst_16481 = (state_16507[(2)]);
var state_16507__$1 = state_16507;
var statearr_16538_16598 = state_16507__$1;
(statearr_16538_16598[(2)] = inst_16481);

(statearr_16538_16598[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16508 === (5))){
var inst_16441 = cljs.core.deref.call(null,mults);
var inst_16442 = cljs.core.vals.call(null,inst_16441);
var inst_16443 = cljs.core.seq.call(null,inst_16442);
var inst_16444 = inst_16443;
var inst_16445 = null;
var inst_16446 = (0);
var inst_16447 = (0);
var state_16507__$1 = (function (){var statearr_16539 = state_16507;
(statearr_16539[(13)] = inst_16446);

(statearr_16539[(14)] = inst_16445);

(statearr_16539[(15)] = inst_16447);

(statearr_16539[(16)] = inst_16444);

return statearr_16539;
})();
var statearr_16540_16600 = state_16507__$1;
(statearr_16540_16600[(2)] = null);

(statearr_16540_16600[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16508 === (14))){
var state_16507__$1 = state_16507;
var statearr_16544_16601 = state_16507__$1;
(statearr_16544_16601[(2)] = null);

(statearr_16544_16601[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16508 === (16))){
var inst_16458 = (state_16507[(10)]);
var inst_16462 = cljs.core.chunk_first.call(null,inst_16458);
var inst_16463 = cljs.core.chunk_rest.call(null,inst_16458);
var inst_16464 = cljs.core.count.call(null,inst_16462);
var inst_16444 = inst_16463;
var inst_16445 = inst_16462;
var inst_16446 = inst_16464;
var inst_16447 = (0);
var state_16507__$1 = (function (){var statearr_16545 = state_16507;
(statearr_16545[(13)] = inst_16446);

(statearr_16545[(14)] = inst_16445);

(statearr_16545[(15)] = inst_16447);

(statearr_16545[(16)] = inst_16444);

return statearr_16545;
})();
var statearr_16547_16602 = state_16507__$1;
(statearr_16547_16602[(2)] = null);

(statearr_16547_16602[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16508 === (10))){
var inst_16446 = (state_16507[(13)]);
var inst_16445 = (state_16507[(14)]);
var inst_16447 = (state_16507[(15)]);
var inst_16444 = (state_16507[(16)]);
var inst_16452 = cljs.core._nth.call(null,inst_16445,inst_16447);
var inst_16453 = cljs.core.async.muxch_STAR_.call(null,inst_16452);
var inst_16454 = cljs.core.async.close_BANG_.call(null,inst_16453);
var inst_16455 = (inst_16447 + (1));
var tmp16541 = inst_16446;
var tmp16542 = inst_16445;
var tmp16543 = inst_16444;
var inst_16444__$1 = tmp16543;
var inst_16445__$1 = tmp16542;
var inst_16446__$1 = tmp16541;
var inst_16447__$1 = inst_16455;
var state_16507__$1 = (function (){var statearr_16548 = state_16507;
(statearr_16548[(13)] = inst_16446__$1);

(statearr_16548[(17)] = inst_16454);

(statearr_16548[(14)] = inst_16445__$1);

(statearr_16548[(15)] = inst_16447__$1);

(statearr_16548[(16)] = inst_16444__$1);

return statearr_16548;
})();
var statearr_16549_16607 = state_16507__$1;
(statearr_16549_16607[(2)] = null);

(statearr_16549_16607[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16508 === (18))){
var inst_16473 = (state_16507[(2)]);
var state_16507__$1 = state_16507;
var statearr_16550_16611 = state_16507__$1;
(statearr_16550_16611[(2)] = inst_16473);

(statearr_16550_16611[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16508 === (8))){
var inst_16446 = (state_16507[(13)]);
var inst_16447 = (state_16507[(15)]);
var inst_16449 = (inst_16447 < inst_16446);
var inst_16450 = inst_16449;
var state_16507__$1 = state_16507;
if(cljs.core.truth_(inst_16450)){
var statearr_16551_16614 = state_16507__$1;
(statearr_16551_16614[(1)] = (10));

} else {
var statearr_16552_16615 = state_16507__$1;
(statearr_16552_16615[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14349__auto___16568,mults,ensure_mult,p))
;
return ((function (switch__14236__auto__,c__14349__auto___16568,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_16556 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16556[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_16556[(1)] = (1));

return statearr_16556;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_16507){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_16507);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e16557){if((e16557 instanceof Object)){
var ex__14240__auto__ = e16557;
var statearr_16558_16619 = state_16507;
(statearr_16558_16619[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16507);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16557;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16624 = state_16507;
state_16507 = G__16624;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_16507){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_16507);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14349__auto___16568,mults,ensure_mult,p))
})();
var state__14351__auto__ = (function (){var statearr_16559 = f__14350__auto__.call(null);
(statearr_16559[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14349__auto___16568);

return statearr_16559;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14351__auto__);
});})(c__14349__auto___16568,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args16629 = [];
var len__7107__auto___16634 = arguments.length;
var i__7108__auto___16635 = (0);
while(true){
if((i__7108__auto___16635 < len__7107__auto___16634)){
args16629.push((arguments[i__7108__auto___16635]));

var G__16636 = (i__7108__auto___16635 + (1));
i__7108__auto___16635 = G__16636;
continue;
} else {
}
break;
}

var G__16633 = args16629.length;
switch (G__16633) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16629.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args16639 = [];
var len__7107__auto___16642 = arguments.length;
var i__7108__auto___16643 = (0);
while(true){
if((i__7108__auto___16643 < len__7107__auto___16642)){
args16639.push((arguments[i__7108__auto___16643]));

var G__16644 = (i__7108__auto___16643 + (1));
i__7108__auto___16643 = G__16644;
continue;
} else {
}
break;
}

var G__16641 = args16639.length;
switch (G__16641) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16639.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args16646 = [];
var len__7107__auto___16717 = arguments.length;
var i__7108__auto___16718 = (0);
while(true){
if((i__7108__auto___16718 < len__7107__auto___16717)){
args16646.push((arguments[i__7108__auto___16718]));

var G__16719 = (i__7108__auto___16718 + (1));
i__7108__auto___16718 = G__16719;
continue;
} else {
}
break;
}

var G__16648 = args16646.length;
switch (G__16648) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16646.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__14349__auto___16722 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14349__auto___16722,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__14350__auto__ = (function (){var switch__14236__auto__ = ((function (c__14349__auto___16722,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_16687){
var state_val_16688 = (state_16687[(1)]);
if((state_val_16688 === (7))){
var state_16687__$1 = state_16687;
var statearr_16689_16723 = state_16687__$1;
(statearr_16689_16723[(2)] = null);

(statearr_16689_16723[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16688 === (1))){
var state_16687__$1 = state_16687;
var statearr_16690_16724 = state_16687__$1;
(statearr_16690_16724[(2)] = null);

(statearr_16690_16724[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16688 === (4))){
var inst_16651 = (state_16687[(7)]);
var inst_16653 = (inst_16651 < cnt);
var state_16687__$1 = state_16687;
if(cljs.core.truth_(inst_16653)){
var statearr_16691_16726 = state_16687__$1;
(statearr_16691_16726[(1)] = (6));

} else {
var statearr_16692_16727 = state_16687__$1;
(statearr_16692_16727[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16688 === (15))){
var inst_16683 = (state_16687[(2)]);
var state_16687__$1 = state_16687;
var statearr_16693_16728 = state_16687__$1;
(statearr_16693_16728[(2)] = inst_16683);

(statearr_16693_16728[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16688 === (13))){
var inst_16676 = cljs.core.async.close_BANG_.call(null,out);
var state_16687__$1 = state_16687;
var statearr_16694_16733 = state_16687__$1;
(statearr_16694_16733[(2)] = inst_16676);

(statearr_16694_16733[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16688 === (6))){
var state_16687__$1 = state_16687;
var statearr_16695_16736 = state_16687__$1;
(statearr_16695_16736[(2)] = null);

(statearr_16695_16736[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16688 === (3))){
var inst_16685 = (state_16687[(2)]);
var state_16687__$1 = state_16687;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16687__$1,inst_16685);
} else {
if((state_val_16688 === (12))){
var inst_16673 = (state_16687[(8)]);
var inst_16673__$1 = (state_16687[(2)]);
var inst_16674 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_16673__$1);
var state_16687__$1 = (function (){var statearr_16696 = state_16687;
(statearr_16696[(8)] = inst_16673__$1);

return statearr_16696;
})();
if(cljs.core.truth_(inst_16674)){
var statearr_16697_16742 = state_16687__$1;
(statearr_16697_16742[(1)] = (13));

} else {
var statearr_16698_16743 = state_16687__$1;
(statearr_16698_16743[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16688 === (2))){
var inst_16650 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_16651 = (0);
var state_16687__$1 = (function (){var statearr_16699 = state_16687;
(statearr_16699[(9)] = inst_16650);

(statearr_16699[(7)] = inst_16651);

return statearr_16699;
})();
var statearr_16700_16744 = state_16687__$1;
(statearr_16700_16744[(2)] = null);

(statearr_16700_16744[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16688 === (11))){
var inst_16651 = (state_16687[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_16687,(10),Object,null,(9));
var inst_16660 = chs__$1.call(null,inst_16651);
var inst_16661 = done.call(null,inst_16651);
var inst_16662 = cljs.core.async.take_BANG_.call(null,inst_16660,inst_16661);
var state_16687__$1 = state_16687;
var statearr_16701_16746 = state_16687__$1;
(statearr_16701_16746[(2)] = inst_16662);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16687__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16688 === (9))){
var inst_16651 = (state_16687[(7)]);
var inst_16664 = (state_16687[(2)]);
var inst_16665 = (inst_16651 + (1));
var inst_16651__$1 = inst_16665;
var state_16687__$1 = (function (){var statearr_16702 = state_16687;
(statearr_16702[(7)] = inst_16651__$1);

(statearr_16702[(10)] = inst_16664);

return statearr_16702;
})();
var statearr_16703_16747 = state_16687__$1;
(statearr_16703_16747[(2)] = null);

(statearr_16703_16747[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16688 === (5))){
var inst_16671 = (state_16687[(2)]);
var state_16687__$1 = (function (){var statearr_16704 = state_16687;
(statearr_16704[(11)] = inst_16671);

return statearr_16704;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16687__$1,(12),dchan);
} else {
if((state_val_16688 === (14))){
var inst_16673 = (state_16687[(8)]);
var inst_16678 = cljs.core.apply.call(null,f,inst_16673);
var state_16687__$1 = state_16687;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16687__$1,(16),out,inst_16678);
} else {
if((state_val_16688 === (16))){
var inst_16680 = (state_16687[(2)]);
var state_16687__$1 = (function (){var statearr_16705 = state_16687;
(statearr_16705[(12)] = inst_16680);

return statearr_16705;
})();
var statearr_16706_16748 = state_16687__$1;
(statearr_16706_16748[(2)] = null);

(statearr_16706_16748[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16688 === (10))){
var inst_16655 = (state_16687[(2)]);
var inst_16656 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_16687__$1 = (function (){var statearr_16707 = state_16687;
(statearr_16707[(13)] = inst_16655);

return statearr_16707;
})();
var statearr_16708_16755 = state_16687__$1;
(statearr_16708_16755[(2)] = inst_16656);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16687__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16688 === (8))){
var inst_16669 = (state_16687[(2)]);
var state_16687__$1 = state_16687;
var statearr_16709_16758 = state_16687__$1;
(statearr_16709_16758[(2)] = inst_16669);

(statearr_16709_16758[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14349__auto___16722,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__14236__auto__,c__14349__auto___16722,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_16713 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16713[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_16713[(1)] = (1));

return statearr_16713;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_16687){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_16687);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e16714){if((e16714 instanceof Object)){
var ex__14240__auto__ = e16714;
var statearr_16715_16763 = state_16687;
(statearr_16715_16763[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16687);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16714;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16764 = state_16687;
state_16687 = G__16764;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_16687){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_16687);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14349__auto___16722,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__14351__auto__ = (function (){var statearr_16716 = f__14350__auto__.call(null);
(statearr_16716[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14349__auto___16722);

return statearr_16716;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14351__auto__);
});})(c__14349__auto___16722,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args16767 = [];
var len__7107__auto___16835 = arguments.length;
var i__7108__auto___16836 = (0);
while(true){
if((i__7108__auto___16836 < len__7107__auto___16835)){
args16767.push((arguments[i__7108__auto___16836]));

var G__16837 = (i__7108__auto___16836 + (1));
i__7108__auto___16836 = G__16837;
continue;
} else {
}
break;
}

var G__16769 = args16767.length;
switch (G__16769) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16767.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14349__auto___16840 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14349__auto___16840,out){
return (function (){
var f__14350__auto__ = (function (){var switch__14236__auto__ = ((function (c__14349__auto___16840,out){
return (function (state_16804){
var state_val_16805 = (state_16804[(1)]);
if((state_val_16805 === (7))){
var inst_16783 = (state_16804[(7)]);
var inst_16782 = (state_16804[(8)]);
var inst_16782__$1 = (state_16804[(2)]);
var inst_16783__$1 = cljs.core.nth.call(null,inst_16782__$1,(0),null);
var inst_16784 = cljs.core.nth.call(null,inst_16782__$1,(1),null);
var inst_16785 = (inst_16783__$1 == null);
var state_16804__$1 = (function (){var statearr_16806 = state_16804;
(statearr_16806[(7)] = inst_16783__$1);

(statearr_16806[(8)] = inst_16782__$1);

(statearr_16806[(9)] = inst_16784);

return statearr_16806;
})();
if(cljs.core.truth_(inst_16785)){
var statearr_16807_16841 = state_16804__$1;
(statearr_16807_16841[(1)] = (8));

} else {
var statearr_16808_16842 = state_16804__$1;
(statearr_16808_16842[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16805 === (1))){
var inst_16774 = cljs.core.vec.call(null,chs);
var inst_16775 = inst_16774;
var state_16804__$1 = (function (){var statearr_16809 = state_16804;
(statearr_16809[(10)] = inst_16775);

return statearr_16809;
})();
var statearr_16810_16843 = state_16804__$1;
(statearr_16810_16843[(2)] = null);

(statearr_16810_16843[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16805 === (4))){
var inst_16775 = (state_16804[(10)]);
var state_16804__$1 = state_16804;
return cljs.core.async.ioc_alts_BANG_.call(null,state_16804__$1,(7),inst_16775);
} else {
if((state_val_16805 === (6))){
var inst_16799 = (state_16804[(2)]);
var state_16804__$1 = state_16804;
var statearr_16811_16844 = state_16804__$1;
(statearr_16811_16844[(2)] = inst_16799);

(statearr_16811_16844[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16805 === (3))){
var inst_16801 = (state_16804[(2)]);
var state_16804__$1 = state_16804;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16804__$1,inst_16801);
} else {
if((state_val_16805 === (2))){
var inst_16775 = (state_16804[(10)]);
var inst_16777 = cljs.core.count.call(null,inst_16775);
var inst_16778 = (inst_16777 > (0));
var state_16804__$1 = state_16804;
if(cljs.core.truth_(inst_16778)){
var statearr_16813_16845 = state_16804__$1;
(statearr_16813_16845[(1)] = (4));

} else {
var statearr_16814_16846 = state_16804__$1;
(statearr_16814_16846[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16805 === (11))){
var inst_16775 = (state_16804[(10)]);
var inst_16792 = (state_16804[(2)]);
var tmp16812 = inst_16775;
var inst_16775__$1 = tmp16812;
var state_16804__$1 = (function (){var statearr_16815 = state_16804;
(statearr_16815[(11)] = inst_16792);

(statearr_16815[(10)] = inst_16775__$1);

return statearr_16815;
})();
var statearr_16819_16847 = state_16804__$1;
(statearr_16819_16847[(2)] = null);

(statearr_16819_16847[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16805 === (9))){
var inst_16783 = (state_16804[(7)]);
var state_16804__$1 = state_16804;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16804__$1,(11),out,inst_16783);
} else {
if((state_val_16805 === (5))){
var inst_16797 = cljs.core.async.close_BANG_.call(null,out);
var state_16804__$1 = state_16804;
var statearr_16824_16848 = state_16804__$1;
(statearr_16824_16848[(2)] = inst_16797);

(statearr_16824_16848[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16805 === (10))){
var inst_16795 = (state_16804[(2)]);
var state_16804__$1 = state_16804;
var statearr_16825_16849 = state_16804__$1;
(statearr_16825_16849[(2)] = inst_16795);

(statearr_16825_16849[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16805 === (8))){
var inst_16783 = (state_16804[(7)]);
var inst_16782 = (state_16804[(8)]);
var inst_16775 = (state_16804[(10)]);
var inst_16784 = (state_16804[(9)]);
var inst_16787 = (function (){var cs = inst_16775;
var vec__16780 = inst_16782;
var v = inst_16783;
var c = inst_16784;
return ((function (cs,vec__16780,v,c,inst_16783,inst_16782,inst_16775,inst_16784,state_val_16805,c__14349__auto___16840,out){
return (function (p1__16766_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__16766_SHARP_);
});
;})(cs,vec__16780,v,c,inst_16783,inst_16782,inst_16775,inst_16784,state_val_16805,c__14349__auto___16840,out))
})();
var inst_16788 = cljs.core.filterv.call(null,inst_16787,inst_16775);
var inst_16775__$1 = inst_16788;
var state_16804__$1 = (function (){var statearr_16826 = state_16804;
(statearr_16826[(10)] = inst_16775__$1);

return statearr_16826;
})();
var statearr_16827_16850 = state_16804__$1;
(statearr_16827_16850[(2)] = null);

(statearr_16827_16850[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__14349__auto___16840,out))
;
return ((function (switch__14236__auto__,c__14349__auto___16840,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_16831 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16831[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_16831[(1)] = (1));

return statearr_16831;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_16804){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_16804);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e16832){if((e16832 instanceof Object)){
var ex__14240__auto__ = e16832;
var statearr_16833_16852 = state_16804;
(statearr_16833_16852[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16804);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16832;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16853 = state_16804;
state_16804 = G__16853;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_16804){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_16804);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14349__auto___16840,out))
})();
var state__14351__auto__ = (function (){var statearr_16834 = f__14350__auto__.call(null);
(statearr_16834[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14349__auto___16840);

return statearr_16834;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14351__auto__);
});})(c__14349__auto___16840,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args16854 = [];
var len__7107__auto___16911 = arguments.length;
var i__7108__auto___16912 = (0);
while(true){
if((i__7108__auto___16912 < len__7107__auto___16911)){
args16854.push((arguments[i__7108__auto___16912]));

var G__16913 = (i__7108__auto___16912 + (1));
i__7108__auto___16912 = G__16913;
continue;
} else {
}
break;
}

var G__16857 = args16854.length;
switch (G__16857) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16854.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14349__auto___16916 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14349__auto___16916,out){
return (function (){
var f__14350__auto__ = (function (){var switch__14236__auto__ = ((function (c__14349__auto___16916,out){
return (function (state_16881){
var state_val_16882 = (state_16881[(1)]);
if((state_val_16882 === (7))){
var inst_16863 = (state_16881[(7)]);
var inst_16863__$1 = (state_16881[(2)]);
var inst_16864 = (inst_16863__$1 == null);
var inst_16865 = cljs.core.not.call(null,inst_16864);
var state_16881__$1 = (function (){var statearr_16885 = state_16881;
(statearr_16885[(7)] = inst_16863__$1);

return statearr_16885;
})();
if(inst_16865){
var statearr_16886_16917 = state_16881__$1;
(statearr_16886_16917[(1)] = (8));

} else {
var statearr_16887_16918 = state_16881__$1;
(statearr_16887_16918[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16882 === (1))){
var inst_16858 = (0);
var state_16881__$1 = (function (){var statearr_16888 = state_16881;
(statearr_16888[(8)] = inst_16858);

return statearr_16888;
})();
var statearr_16889_16922 = state_16881__$1;
(statearr_16889_16922[(2)] = null);

(statearr_16889_16922[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16882 === (4))){
var state_16881__$1 = state_16881;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16881__$1,(7),ch);
} else {
if((state_val_16882 === (6))){
var inst_16876 = (state_16881[(2)]);
var state_16881__$1 = state_16881;
var statearr_16891_16923 = state_16881__$1;
(statearr_16891_16923[(2)] = inst_16876);

(statearr_16891_16923[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16882 === (3))){
var inst_16878 = (state_16881[(2)]);
var inst_16879 = cljs.core.async.close_BANG_.call(null,out);
var state_16881__$1 = (function (){var statearr_16892 = state_16881;
(statearr_16892[(9)] = inst_16878);

return statearr_16892;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16881__$1,inst_16879);
} else {
if((state_val_16882 === (2))){
var inst_16858 = (state_16881[(8)]);
var inst_16860 = (inst_16858 < n);
var state_16881__$1 = state_16881;
if(cljs.core.truth_(inst_16860)){
var statearr_16893_16924 = state_16881__$1;
(statearr_16893_16924[(1)] = (4));

} else {
var statearr_16894_16925 = state_16881__$1;
(statearr_16894_16925[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16882 === (11))){
var inst_16858 = (state_16881[(8)]);
var inst_16868 = (state_16881[(2)]);
var inst_16869 = (inst_16858 + (1));
var inst_16858__$1 = inst_16869;
var state_16881__$1 = (function (){var statearr_16895 = state_16881;
(statearr_16895[(8)] = inst_16858__$1);

(statearr_16895[(10)] = inst_16868);

return statearr_16895;
})();
var statearr_16896_16926 = state_16881__$1;
(statearr_16896_16926[(2)] = null);

(statearr_16896_16926[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16882 === (9))){
var state_16881__$1 = state_16881;
var statearr_16897_16927 = state_16881__$1;
(statearr_16897_16927[(2)] = null);

(statearr_16897_16927[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16882 === (5))){
var state_16881__$1 = state_16881;
var statearr_16898_16928 = state_16881__$1;
(statearr_16898_16928[(2)] = null);

(statearr_16898_16928[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16882 === (10))){
var inst_16873 = (state_16881[(2)]);
var state_16881__$1 = state_16881;
var statearr_16899_16929 = state_16881__$1;
(statearr_16899_16929[(2)] = inst_16873);

(statearr_16899_16929[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16882 === (8))){
var inst_16863 = (state_16881[(7)]);
var state_16881__$1 = state_16881;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16881__$1,(11),out,inst_16863);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__14349__auto___16916,out))
;
return ((function (switch__14236__auto__,c__14349__auto___16916,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_16903 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_16903[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_16903[(1)] = (1));

return statearr_16903;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_16881){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_16881);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e16904){if((e16904 instanceof Object)){
var ex__14240__auto__ = e16904;
var statearr_16906_16931 = state_16881;
(statearr_16906_16931[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16881);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16904;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16932 = state_16881;
state_16881 = G__16932;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_16881){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_16881);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14349__auto___16916,out))
})();
var state__14351__auto__ = (function (){var statearr_16909 = f__14350__auto__.call(null);
(statearr_16909[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14349__auto___16916);

return statearr_16909;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14351__auto__);
});})(c__14349__auto___16916,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async16940 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16940 = (function (map_LT_,f,ch,meta16941){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta16941 = meta16941;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16940.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16942,meta16941__$1){
var self__ = this;
var _16942__$1 = this;
return (new cljs.core.async.t_cljs$core$async16940(self__.map_LT_,self__.f,self__.ch,meta16941__$1));
});

cljs.core.async.t_cljs$core$async16940.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16942){
var self__ = this;
var _16942__$1 = this;
return self__.meta16941;
});

cljs.core.async.t_cljs$core$async16940.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async16940.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async16940.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async16940.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async16940.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async16943 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16943 = (function (map_LT_,f,ch,meta16941,_,fn1,meta16944){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta16941 = meta16941;
this._ = _;
this.fn1 = fn1;
this.meta16944 = meta16944;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16943.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_16945,meta16944__$1){
var self__ = this;
var _16945__$1 = this;
return (new cljs.core.async.t_cljs$core$async16943(self__.map_LT_,self__.f,self__.ch,self__.meta16941,self__._,self__.fn1,meta16944__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async16943.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_16945){
var self__ = this;
var _16945__$1 = this;
return self__.meta16944;
});})(___$1))
;

cljs.core.async.t_cljs$core$async16943.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async16943.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async16943.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async16943.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__16933_SHARP_){
return f1.call(null,(((p1__16933_SHARP_ == null))?null:self__.f.call(null,p1__16933_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async16943.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16941","meta16941",-2048223030,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async16940","cljs.core.async/t_cljs$core$async16940",-1723088336,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta16944","meta16944",-1304509607,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async16943.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16943.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16943";

cljs.core.async.t_cljs$core$async16943.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16943");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async16943 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async16943(map_LT___$1,f__$1,ch__$1,meta16941__$1,___$2,fn1__$1,meta16944){
return (new cljs.core.async.t_cljs$core$async16943(map_LT___$1,f__$1,ch__$1,meta16941__$1,___$2,fn1__$1,meta16944));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async16943(self__.map_LT_,self__.f,self__.ch,self__.meta16941,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__6037__auto__ = ret;
if(cljs.core.truth_(and__6037__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__6037__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async16940.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async16940.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async16940.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16941","meta16941",-2048223030,null)], null);
});

cljs.core.async.t_cljs$core$async16940.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16940.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16940";

cljs.core.async.t_cljs$core$async16940.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16940");
});

cljs.core.async.__GT_t_cljs$core$async16940 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async16940(map_LT___$1,f__$1,ch__$1,meta16941){
return (new cljs.core.async.t_cljs$core$async16940(map_LT___$1,f__$1,ch__$1,meta16941));
});

}

return (new cljs.core.async.t_cljs$core$async16940(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async16961 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16961 = (function (map_GT_,f,ch,meta16962){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta16962 = meta16962;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16961.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16963,meta16962__$1){
var self__ = this;
var _16963__$1 = this;
return (new cljs.core.async.t_cljs$core$async16961(self__.map_GT_,self__.f,self__.ch,meta16962__$1));
});

cljs.core.async.t_cljs$core$async16961.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16963){
var self__ = this;
var _16963__$1 = this;
return self__.meta16962;
});

cljs.core.async.t_cljs$core$async16961.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async16961.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async16961.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async16961.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async16961.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async16961.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async16961.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16962","meta16962",-106075389,null)], null);
});

cljs.core.async.t_cljs$core$async16961.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16961.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16961";

cljs.core.async.t_cljs$core$async16961.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16961");
});

cljs.core.async.__GT_t_cljs$core$async16961 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async16961(map_GT___$1,f__$1,ch__$1,meta16962){
return (new cljs.core.async.t_cljs$core$async16961(map_GT___$1,f__$1,ch__$1,meta16962));
});

}

return (new cljs.core.async.t_cljs$core$async16961(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async16970 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16970 = (function (filter_GT_,p,ch,meta16971){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta16971 = meta16971;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16970.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16972,meta16971__$1){
var self__ = this;
var _16972__$1 = this;
return (new cljs.core.async.t_cljs$core$async16970(self__.filter_GT_,self__.p,self__.ch,meta16971__$1));
});

cljs.core.async.t_cljs$core$async16970.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16972){
var self__ = this;
var _16972__$1 = this;
return self__.meta16971;
});

cljs.core.async.t_cljs$core$async16970.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async16970.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async16970.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async16970.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async16970.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async16970.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async16970.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async16970.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16971","meta16971",-2113666499,null)], null);
});

cljs.core.async.t_cljs$core$async16970.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16970.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16970";

cljs.core.async.t_cljs$core$async16970.cljs$lang$ctorPrWriter = (function (this__6647__auto__,writer__6648__auto__,opt__6649__auto__){
return cljs.core._write.call(null,writer__6648__auto__,"cljs.core.async/t_cljs$core$async16970");
});

cljs.core.async.__GT_t_cljs$core$async16970 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async16970(filter_GT___$1,p__$1,ch__$1,meta16971){
return (new cljs.core.async.t_cljs$core$async16970(filter_GT___$1,p__$1,ch__$1,meta16971));
});

}

return (new cljs.core.async.t_cljs$core$async16970(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args16974 = [];
var len__7107__auto___17018 = arguments.length;
var i__7108__auto___17019 = (0);
while(true){
if((i__7108__auto___17019 < len__7107__auto___17018)){
args16974.push((arguments[i__7108__auto___17019]));

var G__17020 = (i__7108__auto___17019 + (1));
i__7108__auto___17019 = G__17020;
continue;
} else {
}
break;
}

var G__16976 = args16974.length;
switch (G__16976) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16974.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14349__auto___17022 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14349__auto___17022,out){
return (function (){
var f__14350__auto__ = (function (){var switch__14236__auto__ = ((function (c__14349__auto___17022,out){
return (function (state_16997){
var state_val_16998 = (state_16997[(1)]);
if((state_val_16998 === (7))){
var inst_16993 = (state_16997[(2)]);
var state_16997__$1 = state_16997;
var statearr_16999_17023 = state_16997__$1;
(statearr_16999_17023[(2)] = inst_16993);

(statearr_16999_17023[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16998 === (1))){
var state_16997__$1 = state_16997;
var statearr_17000_17024 = state_16997__$1;
(statearr_17000_17024[(2)] = null);

(statearr_17000_17024[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16998 === (4))){
var inst_16979 = (state_16997[(7)]);
var inst_16979__$1 = (state_16997[(2)]);
var inst_16980 = (inst_16979__$1 == null);
var state_16997__$1 = (function (){var statearr_17001 = state_16997;
(statearr_17001[(7)] = inst_16979__$1);

return statearr_17001;
})();
if(cljs.core.truth_(inst_16980)){
var statearr_17002_17025 = state_16997__$1;
(statearr_17002_17025[(1)] = (5));

} else {
var statearr_17003_17026 = state_16997__$1;
(statearr_17003_17026[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16998 === (6))){
var inst_16979 = (state_16997[(7)]);
var inst_16984 = p.call(null,inst_16979);
var state_16997__$1 = state_16997;
if(cljs.core.truth_(inst_16984)){
var statearr_17004_17027 = state_16997__$1;
(statearr_17004_17027[(1)] = (8));

} else {
var statearr_17005_17028 = state_16997__$1;
(statearr_17005_17028[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16998 === (3))){
var inst_16995 = (state_16997[(2)]);
var state_16997__$1 = state_16997;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16997__$1,inst_16995);
} else {
if((state_val_16998 === (2))){
var state_16997__$1 = state_16997;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16997__$1,(4),ch);
} else {
if((state_val_16998 === (11))){
var inst_16987 = (state_16997[(2)]);
var state_16997__$1 = state_16997;
var statearr_17006_17029 = state_16997__$1;
(statearr_17006_17029[(2)] = inst_16987);

(statearr_17006_17029[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16998 === (9))){
var state_16997__$1 = state_16997;
var statearr_17007_17030 = state_16997__$1;
(statearr_17007_17030[(2)] = null);

(statearr_17007_17030[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16998 === (5))){
var inst_16982 = cljs.core.async.close_BANG_.call(null,out);
var state_16997__$1 = state_16997;
var statearr_17008_17032 = state_16997__$1;
(statearr_17008_17032[(2)] = inst_16982);

(statearr_17008_17032[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16998 === (10))){
var inst_16990 = (state_16997[(2)]);
var state_16997__$1 = (function (){var statearr_17009 = state_16997;
(statearr_17009[(8)] = inst_16990);

return statearr_17009;
})();
var statearr_17010_17033 = state_16997__$1;
(statearr_17010_17033[(2)] = null);

(statearr_17010_17033[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16998 === (8))){
var inst_16979 = (state_16997[(7)]);
var state_16997__$1 = state_16997;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16997__$1,(11),out,inst_16979);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__14349__auto___17022,out))
;
return ((function (switch__14236__auto__,c__14349__auto___17022,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_17014 = [null,null,null,null,null,null,null,null,null];
(statearr_17014[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_17014[(1)] = (1));

return statearr_17014;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_16997){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_16997);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e17015){if((e17015 instanceof Object)){
var ex__14240__auto__ = e17015;
var statearr_17016_17037 = state_16997;
(statearr_17016_17037[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16997);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17015;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17038 = state_16997;
state_16997 = G__17038;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_16997){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_16997);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14349__auto___17022,out))
})();
var state__14351__auto__ = (function (){var statearr_17017 = f__14350__auto__.call(null);
(statearr_17017[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14349__auto___17022);

return statearr_17017;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14351__auto__);
});})(c__14349__auto___17022,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args17043 = [];
var len__7107__auto___17049 = arguments.length;
var i__7108__auto___17050 = (0);
while(true){
if((i__7108__auto___17050 < len__7107__auto___17049)){
args17043.push((arguments[i__7108__auto___17050]));

var G__17052 = (i__7108__auto___17050 + (1));
i__7108__auto___17050 = G__17052;
continue;
} else {
}
break;
}

var G__17045 = args17043.length;
switch (G__17045) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17043.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__14349__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14349__auto__){
return (function (){
var f__14350__auto__ = (function (){var switch__14236__auto__ = ((function (c__14349__auto__){
return (function (state_17223){
var state_val_17224 = (state_17223[(1)]);
if((state_val_17224 === (7))){
var inst_17219 = (state_17223[(2)]);
var state_17223__$1 = state_17223;
var statearr_17225_17268 = state_17223__$1;
(statearr_17225_17268[(2)] = inst_17219);

(statearr_17225_17268[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17224 === (20))){
var inst_17189 = (state_17223[(7)]);
var inst_17200 = (state_17223[(2)]);
var inst_17201 = cljs.core.next.call(null,inst_17189);
var inst_17175 = inst_17201;
var inst_17176 = null;
var inst_17177 = (0);
var inst_17178 = (0);
var state_17223__$1 = (function (){var statearr_17226 = state_17223;
(statearr_17226[(8)] = inst_17175);

(statearr_17226[(9)] = inst_17176);

(statearr_17226[(10)] = inst_17200);

(statearr_17226[(11)] = inst_17177);

(statearr_17226[(12)] = inst_17178);

return statearr_17226;
})();
var statearr_17227_17271 = state_17223__$1;
(statearr_17227_17271[(2)] = null);

(statearr_17227_17271[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17224 === (1))){
var state_17223__$1 = state_17223;
var statearr_17228_17272 = state_17223__$1;
(statearr_17228_17272[(2)] = null);

(statearr_17228_17272[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17224 === (4))){
var inst_17164 = (state_17223[(13)]);
var inst_17164__$1 = (state_17223[(2)]);
var inst_17165 = (inst_17164__$1 == null);
var state_17223__$1 = (function (){var statearr_17229 = state_17223;
(statearr_17229[(13)] = inst_17164__$1);

return statearr_17229;
})();
if(cljs.core.truth_(inst_17165)){
var statearr_17230_17276 = state_17223__$1;
(statearr_17230_17276[(1)] = (5));

} else {
var statearr_17231_17277 = state_17223__$1;
(statearr_17231_17277[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17224 === (15))){
var state_17223__$1 = state_17223;
var statearr_17235_17279 = state_17223__$1;
(statearr_17235_17279[(2)] = null);

(statearr_17235_17279[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17224 === (21))){
var state_17223__$1 = state_17223;
var statearr_17236_17280 = state_17223__$1;
(statearr_17236_17280[(2)] = null);

(statearr_17236_17280[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17224 === (13))){
var inst_17175 = (state_17223[(8)]);
var inst_17176 = (state_17223[(9)]);
var inst_17177 = (state_17223[(11)]);
var inst_17178 = (state_17223[(12)]);
var inst_17185 = (state_17223[(2)]);
var inst_17186 = (inst_17178 + (1));
var tmp17232 = inst_17175;
var tmp17233 = inst_17176;
var tmp17234 = inst_17177;
var inst_17175__$1 = tmp17232;
var inst_17176__$1 = tmp17233;
var inst_17177__$1 = tmp17234;
var inst_17178__$1 = inst_17186;
var state_17223__$1 = (function (){var statearr_17237 = state_17223;
(statearr_17237[(8)] = inst_17175__$1);

(statearr_17237[(14)] = inst_17185);

(statearr_17237[(9)] = inst_17176__$1);

(statearr_17237[(11)] = inst_17177__$1);

(statearr_17237[(12)] = inst_17178__$1);

return statearr_17237;
})();
var statearr_17238_17284 = state_17223__$1;
(statearr_17238_17284[(2)] = null);

(statearr_17238_17284[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17224 === (22))){
var state_17223__$1 = state_17223;
var statearr_17239_17285 = state_17223__$1;
(statearr_17239_17285[(2)] = null);

(statearr_17239_17285[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17224 === (6))){
var inst_17164 = (state_17223[(13)]);
var inst_17173 = f.call(null,inst_17164);
var inst_17174 = cljs.core.seq.call(null,inst_17173);
var inst_17175 = inst_17174;
var inst_17176 = null;
var inst_17177 = (0);
var inst_17178 = (0);
var state_17223__$1 = (function (){var statearr_17240 = state_17223;
(statearr_17240[(8)] = inst_17175);

(statearr_17240[(9)] = inst_17176);

(statearr_17240[(11)] = inst_17177);

(statearr_17240[(12)] = inst_17178);

return statearr_17240;
})();
var statearr_17241_17286 = state_17223__$1;
(statearr_17241_17286[(2)] = null);

(statearr_17241_17286[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17224 === (17))){
var inst_17189 = (state_17223[(7)]);
var inst_17193 = cljs.core.chunk_first.call(null,inst_17189);
var inst_17194 = cljs.core.chunk_rest.call(null,inst_17189);
var inst_17195 = cljs.core.count.call(null,inst_17193);
var inst_17175 = inst_17194;
var inst_17176 = inst_17193;
var inst_17177 = inst_17195;
var inst_17178 = (0);
var state_17223__$1 = (function (){var statearr_17242 = state_17223;
(statearr_17242[(8)] = inst_17175);

(statearr_17242[(9)] = inst_17176);

(statearr_17242[(11)] = inst_17177);

(statearr_17242[(12)] = inst_17178);

return statearr_17242;
})();
var statearr_17243_17287 = state_17223__$1;
(statearr_17243_17287[(2)] = null);

(statearr_17243_17287[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17224 === (3))){
var inst_17221 = (state_17223[(2)]);
var state_17223__$1 = state_17223;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17223__$1,inst_17221);
} else {
if((state_val_17224 === (12))){
var inst_17209 = (state_17223[(2)]);
var state_17223__$1 = state_17223;
var statearr_17244_17289 = state_17223__$1;
(statearr_17244_17289[(2)] = inst_17209);

(statearr_17244_17289[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17224 === (2))){
var state_17223__$1 = state_17223;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17223__$1,(4),in$);
} else {
if((state_val_17224 === (23))){
var inst_17217 = (state_17223[(2)]);
var state_17223__$1 = state_17223;
var statearr_17245_17290 = state_17223__$1;
(statearr_17245_17290[(2)] = inst_17217);

(statearr_17245_17290[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17224 === (19))){
var inst_17204 = (state_17223[(2)]);
var state_17223__$1 = state_17223;
var statearr_17246_17291 = state_17223__$1;
(statearr_17246_17291[(2)] = inst_17204);

(statearr_17246_17291[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17224 === (11))){
var inst_17175 = (state_17223[(8)]);
var inst_17189 = (state_17223[(7)]);
var inst_17189__$1 = cljs.core.seq.call(null,inst_17175);
var state_17223__$1 = (function (){var statearr_17247 = state_17223;
(statearr_17247[(7)] = inst_17189__$1);

return statearr_17247;
})();
if(inst_17189__$1){
var statearr_17248_17292 = state_17223__$1;
(statearr_17248_17292[(1)] = (14));

} else {
var statearr_17249_17293 = state_17223__$1;
(statearr_17249_17293[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17224 === (9))){
var inst_17211 = (state_17223[(2)]);
var inst_17212 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_17223__$1 = (function (){var statearr_17250 = state_17223;
(statearr_17250[(15)] = inst_17211);

return statearr_17250;
})();
if(cljs.core.truth_(inst_17212)){
var statearr_17251_17294 = state_17223__$1;
(statearr_17251_17294[(1)] = (21));

} else {
var statearr_17252_17295 = state_17223__$1;
(statearr_17252_17295[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17224 === (5))){
var inst_17167 = cljs.core.async.close_BANG_.call(null,out);
var state_17223__$1 = state_17223;
var statearr_17253_17296 = state_17223__$1;
(statearr_17253_17296[(2)] = inst_17167);

(statearr_17253_17296[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17224 === (14))){
var inst_17189 = (state_17223[(7)]);
var inst_17191 = cljs.core.chunked_seq_QMARK_.call(null,inst_17189);
var state_17223__$1 = state_17223;
if(inst_17191){
var statearr_17254_17297 = state_17223__$1;
(statearr_17254_17297[(1)] = (17));

} else {
var statearr_17255_17298 = state_17223__$1;
(statearr_17255_17298[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17224 === (16))){
var inst_17207 = (state_17223[(2)]);
var state_17223__$1 = state_17223;
var statearr_17256_17299 = state_17223__$1;
(statearr_17256_17299[(2)] = inst_17207);

(statearr_17256_17299[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17224 === (10))){
var inst_17176 = (state_17223[(9)]);
var inst_17178 = (state_17223[(12)]);
var inst_17183 = cljs.core._nth.call(null,inst_17176,inst_17178);
var state_17223__$1 = state_17223;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17223__$1,(13),out,inst_17183);
} else {
if((state_val_17224 === (18))){
var inst_17189 = (state_17223[(7)]);
var inst_17198 = cljs.core.first.call(null,inst_17189);
var state_17223__$1 = state_17223;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17223__$1,(20),out,inst_17198);
} else {
if((state_val_17224 === (8))){
var inst_17177 = (state_17223[(11)]);
var inst_17178 = (state_17223[(12)]);
var inst_17180 = (inst_17178 < inst_17177);
var inst_17181 = inst_17180;
var state_17223__$1 = state_17223;
if(cljs.core.truth_(inst_17181)){
var statearr_17257_17300 = state_17223__$1;
(statearr_17257_17300[(1)] = (10));

} else {
var statearr_17258_17301 = state_17223__$1;
(statearr_17258_17301[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14349__auto__))
;
return ((function (switch__14236__auto__,c__14349__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____0 = (function (){
var statearr_17262 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17262[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__);

(statearr_17262[(1)] = (1));

return statearr_17262;
});
var cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____1 = (function (state_17223){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_17223);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e17263){if((e17263 instanceof Object)){
var ex__14240__auto__ = e17263;
var statearr_17264_17302 = state_17223;
(statearr_17264_17302[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17223);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17263;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17303 = state_17223;
state_17223 = G__17303;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__ = function(state_17223){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____1.call(this,state_17223);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__14237__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14349__auto__))
})();
var state__14351__auto__ = (function (){var statearr_17265 = f__14350__auto__.call(null);
(statearr_17265[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14349__auto__);

return statearr_17265;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14351__auto__);
});})(c__14349__auto__))
);

return c__14349__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args17304 = [];
var len__7107__auto___17311 = arguments.length;
var i__7108__auto___17312 = (0);
while(true){
if((i__7108__auto___17312 < len__7107__auto___17311)){
args17304.push((arguments[i__7108__auto___17312]));

var G__17313 = (i__7108__auto___17312 + (1));
i__7108__auto___17312 = G__17313;
continue;
} else {
}
break;
}

var G__17309 = args17304.length;
switch (G__17309) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17304.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args17318 = [];
var len__7107__auto___17322 = arguments.length;
var i__7108__auto___17323 = (0);
while(true){
if((i__7108__auto___17323 < len__7107__auto___17322)){
args17318.push((arguments[i__7108__auto___17323]));

var G__17324 = (i__7108__auto___17323 + (1));
i__7108__auto___17323 = G__17324;
continue;
} else {
}
break;
}

var G__17320 = args17318.length;
switch (G__17320) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17318.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args17326 = [];
var len__7107__auto___17384 = arguments.length;
var i__7108__auto___17385 = (0);
while(true){
if((i__7108__auto___17385 < len__7107__auto___17384)){
args17326.push((arguments[i__7108__auto___17385]));

var G__17386 = (i__7108__auto___17385 + (1));
i__7108__auto___17385 = G__17386;
continue;
} else {
}
break;
}

var G__17328 = args17326.length;
switch (G__17328) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17326.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14349__auto___17388 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14349__auto___17388,out){
return (function (){
var f__14350__auto__ = (function (){var switch__14236__auto__ = ((function (c__14349__auto___17388,out){
return (function (state_17352){
var state_val_17353 = (state_17352[(1)]);
if((state_val_17353 === (7))){
var inst_17347 = (state_17352[(2)]);
var state_17352__$1 = state_17352;
var statearr_17354_17390 = state_17352__$1;
(statearr_17354_17390[(2)] = inst_17347);

(statearr_17354_17390[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17353 === (1))){
var inst_17329 = null;
var state_17352__$1 = (function (){var statearr_17355 = state_17352;
(statearr_17355[(7)] = inst_17329);

return statearr_17355;
})();
var statearr_17356_17391 = state_17352__$1;
(statearr_17356_17391[(2)] = null);

(statearr_17356_17391[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17353 === (4))){
var inst_17332 = (state_17352[(8)]);
var inst_17332__$1 = (state_17352[(2)]);
var inst_17333 = (inst_17332__$1 == null);
var inst_17334 = cljs.core.not.call(null,inst_17333);
var state_17352__$1 = (function (){var statearr_17357 = state_17352;
(statearr_17357[(8)] = inst_17332__$1);

return statearr_17357;
})();
if(inst_17334){
var statearr_17358_17392 = state_17352__$1;
(statearr_17358_17392[(1)] = (5));

} else {
var statearr_17359_17393 = state_17352__$1;
(statearr_17359_17393[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17353 === (6))){
var state_17352__$1 = state_17352;
var statearr_17360_17394 = state_17352__$1;
(statearr_17360_17394[(2)] = null);

(statearr_17360_17394[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17353 === (3))){
var inst_17349 = (state_17352[(2)]);
var inst_17350 = cljs.core.async.close_BANG_.call(null,out);
var state_17352__$1 = (function (){var statearr_17361 = state_17352;
(statearr_17361[(9)] = inst_17349);

return statearr_17361;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17352__$1,inst_17350);
} else {
if((state_val_17353 === (2))){
var state_17352__$1 = state_17352;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17352__$1,(4),ch);
} else {
if((state_val_17353 === (11))){
var inst_17332 = (state_17352[(8)]);
var inst_17341 = (state_17352[(2)]);
var inst_17329 = inst_17332;
var state_17352__$1 = (function (){var statearr_17362 = state_17352;
(statearr_17362[(7)] = inst_17329);

(statearr_17362[(10)] = inst_17341);

return statearr_17362;
})();
var statearr_17363_17395 = state_17352__$1;
(statearr_17363_17395[(2)] = null);

(statearr_17363_17395[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17353 === (9))){
var inst_17332 = (state_17352[(8)]);
var state_17352__$1 = state_17352;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17352__$1,(11),out,inst_17332);
} else {
if((state_val_17353 === (5))){
var inst_17329 = (state_17352[(7)]);
var inst_17332 = (state_17352[(8)]);
var inst_17336 = cljs.core._EQ_.call(null,inst_17332,inst_17329);
var state_17352__$1 = state_17352;
if(inst_17336){
var statearr_17365_17396 = state_17352__$1;
(statearr_17365_17396[(1)] = (8));

} else {
var statearr_17366_17397 = state_17352__$1;
(statearr_17366_17397[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17353 === (10))){
var inst_17344 = (state_17352[(2)]);
var state_17352__$1 = state_17352;
var statearr_17370_17398 = state_17352__$1;
(statearr_17370_17398[(2)] = inst_17344);

(statearr_17370_17398[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17353 === (8))){
var inst_17329 = (state_17352[(7)]);
var tmp17364 = inst_17329;
var inst_17329__$1 = tmp17364;
var state_17352__$1 = (function (){var statearr_17372 = state_17352;
(statearr_17372[(7)] = inst_17329__$1);

return statearr_17372;
})();
var statearr_17373_17399 = state_17352__$1;
(statearr_17373_17399[(2)] = null);

(statearr_17373_17399[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__14349__auto___17388,out))
;
return ((function (switch__14236__auto__,c__14349__auto___17388,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_17377 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17377[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_17377[(1)] = (1));

return statearr_17377;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_17352){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_17352);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e17378){if((e17378 instanceof Object)){
var ex__14240__auto__ = e17378;
var statearr_17379_17400 = state_17352;
(statearr_17379_17400[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17352);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17378;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17403 = state_17352;
state_17352 = G__17403;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_17352){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_17352);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14349__auto___17388,out))
})();
var state__14351__auto__ = (function (){var statearr_17380 = f__14350__auto__.call(null);
(statearr_17380[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14349__auto___17388);

return statearr_17380;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14351__auto__);
});})(c__14349__auto___17388,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args17404 = [];
var len__7107__auto___17483 = arguments.length;
var i__7108__auto___17484 = (0);
while(true){
if((i__7108__auto___17484 < len__7107__auto___17483)){
args17404.push((arguments[i__7108__auto___17484]));

var G__17485 = (i__7108__auto___17484 + (1));
i__7108__auto___17484 = G__17485;
continue;
} else {
}
break;
}

var G__17407 = args17404.length;
switch (G__17407) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17404.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14349__auto___17487 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14349__auto___17487,out){
return (function (){
var f__14350__auto__ = (function (){var switch__14236__auto__ = ((function (c__14349__auto___17487,out){
return (function (state_17446){
var state_val_17447 = (state_17446[(1)]);
if((state_val_17447 === (7))){
var inst_17442 = (state_17446[(2)]);
var state_17446__$1 = state_17446;
var statearr_17448_17489 = state_17446__$1;
(statearr_17448_17489[(2)] = inst_17442);

(statearr_17448_17489[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17447 === (1))){
var inst_17409 = (new Array(n));
var inst_17410 = inst_17409;
var inst_17411 = (0);
var state_17446__$1 = (function (){var statearr_17449 = state_17446;
(statearr_17449[(7)] = inst_17410);

(statearr_17449[(8)] = inst_17411);

return statearr_17449;
})();
var statearr_17450_17490 = state_17446__$1;
(statearr_17450_17490[(2)] = null);

(statearr_17450_17490[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17447 === (4))){
var inst_17414 = (state_17446[(9)]);
var inst_17414__$1 = (state_17446[(2)]);
var inst_17415 = (inst_17414__$1 == null);
var inst_17416 = cljs.core.not.call(null,inst_17415);
var state_17446__$1 = (function (){var statearr_17451 = state_17446;
(statearr_17451[(9)] = inst_17414__$1);

return statearr_17451;
})();
if(inst_17416){
var statearr_17452_17491 = state_17446__$1;
(statearr_17452_17491[(1)] = (5));

} else {
var statearr_17453_17492 = state_17446__$1;
(statearr_17453_17492[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17447 === (15))){
var inst_17436 = (state_17446[(2)]);
var state_17446__$1 = state_17446;
var statearr_17454_17493 = state_17446__$1;
(statearr_17454_17493[(2)] = inst_17436);

(statearr_17454_17493[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17447 === (13))){
var state_17446__$1 = state_17446;
var statearr_17455_17494 = state_17446__$1;
(statearr_17455_17494[(2)] = null);

(statearr_17455_17494[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17447 === (6))){
var inst_17411 = (state_17446[(8)]);
var inst_17432 = (inst_17411 > (0));
var state_17446__$1 = state_17446;
if(cljs.core.truth_(inst_17432)){
var statearr_17456_17495 = state_17446__$1;
(statearr_17456_17495[(1)] = (12));

} else {
var statearr_17457_17496 = state_17446__$1;
(statearr_17457_17496[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17447 === (3))){
var inst_17444 = (state_17446[(2)]);
var state_17446__$1 = state_17446;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17446__$1,inst_17444);
} else {
if((state_val_17447 === (12))){
var inst_17410 = (state_17446[(7)]);
var inst_17434 = cljs.core.vec.call(null,inst_17410);
var state_17446__$1 = state_17446;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17446__$1,(15),out,inst_17434);
} else {
if((state_val_17447 === (2))){
var state_17446__$1 = state_17446;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17446__$1,(4),ch);
} else {
if((state_val_17447 === (11))){
var inst_17426 = (state_17446[(2)]);
var inst_17427 = (new Array(n));
var inst_17410 = inst_17427;
var inst_17411 = (0);
var state_17446__$1 = (function (){var statearr_17458 = state_17446;
(statearr_17458[(10)] = inst_17426);

(statearr_17458[(7)] = inst_17410);

(statearr_17458[(8)] = inst_17411);

return statearr_17458;
})();
var statearr_17459_17497 = state_17446__$1;
(statearr_17459_17497[(2)] = null);

(statearr_17459_17497[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17447 === (9))){
var inst_17410 = (state_17446[(7)]);
var inst_17424 = cljs.core.vec.call(null,inst_17410);
var state_17446__$1 = state_17446;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17446__$1,(11),out,inst_17424);
} else {
if((state_val_17447 === (5))){
var inst_17414 = (state_17446[(9)]);
var inst_17410 = (state_17446[(7)]);
var inst_17419 = (state_17446[(11)]);
var inst_17411 = (state_17446[(8)]);
var inst_17418 = (inst_17410[inst_17411] = inst_17414);
var inst_17419__$1 = (inst_17411 + (1));
var inst_17420 = (inst_17419__$1 < n);
var state_17446__$1 = (function (){var statearr_17463 = state_17446;
(statearr_17463[(12)] = inst_17418);

(statearr_17463[(11)] = inst_17419__$1);

return statearr_17463;
})();
if(cljs.core.truth_(inst_17420)){
var statearr_17464_17498 = state_17446__$1;
(statearr_17464_17498[(1)] = (8));

} else {
var statearr_17465_17499 = state_17446__$1;
(statearr_17465_17499[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17447 === (14))){
var inst_17439 = (state_17446[(2)]);
var inst_17440 = cljs.core.async.close_BANG_.call(null,out);
var state_17446__$1 = (function (){var statearr_17467 = state_17446;
(statearr_17467[(13)] = inst_17439);

return statearr_17467;
})();
var statearr_17468_17500 = state_17446__$1;
(statearr_17468_17500[(2)] = inst_17440);

(statearr_17468_17500[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17447 === (10))){
var inst_17430 = (state_17446[(2)]);
var state_17446__$1 = state_17446;
var statearr_17471_17501 = state_17446__$1;
(statearr_17471_17501[(2)] = inst_17430);

(statearr_17471_17501[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17447 === (8))){
var inst_17410 = (state_17446[(7)]);
var inst_17419 = (state_17446[(11)]);
var tmp17466 = inst_17410;
var inst_17410__$1 = tmp17466;
var inst_17411 = inst_17419;
var state_17446__$1 = (function (){var statearr_17474 = state_17446;
(statearr_17474[(7)] = inst_17410__$1);

(statearr_17474[(8)] = inst_17411);

return statearr_17474;
})();
var statearr_17475_17502 = state_17446__$1;
(statearr_17475_17502[(2)] = null);

(statearr_17475_17502[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14349__auto___17487,out))
;
return ((function (switch__14236__auto__,c__14349__auto___17487,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_17479 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17479[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_17479[(1)] = (1));

return statearr_17479;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_17446){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_17446);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e17480){if((e17480 instanceof Object)){
var ex__14240__auto__ = e17480;
var statearr_17481_17503 = state_17446;
(statearr_17481_17503[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17446);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17480;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17504 = state_17446;
state_17446 = G__17504;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_17446){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_17446);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14349__auto___17487,out))
})();
var state__14351__auto__ = (function (){var statearr_17482 = f__14350__auto__.call(null);
(statearr_17482[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14349__auto___17487);

return statearr_17482;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14351__auto__);
});})(c__14349__auto___17487,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args17505 = [];
var len__7107__auto___17587 = arguments.length;
var i__7108__auto___17588 = (0);
while(true){
if((i__7108__auto___17588 < len__7107__auto___17587)){
args17505.push((arguments[i__7108__auto___17588]));

var G__17589 = (i__7108__auto___17588 + (1));
i__7108__auto___17588 = G__17589;
continue;
} else {
}
break;
}

var G__17507 = args17505.length;
switch (G__17507) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17505.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14349__auto___17597 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14349__auto___17597,out){
return (function (){
var f__14350__auto__ = (function (){var switch__14236__auto__ = ((function (c__14349__auto___17597,out){
return (function (state_17549){
var state_val_17550 = (state_17549[(1)]);
if((state_val_17550 === (7))){
var inst_17545 = (state_17549[(2)]);
var state_17549__$1 = state_17549;
var statearr_17552_17600 = state_17549__$1;
(statearr_17552_17600[(2)] = inst_17545);

(statearr_17552_17600[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17550 === (1))){
var inst_17508 = [];
var inst_17509 = inst_17508;
var inst_17510 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_17549__$1 = (function (){var statearr_17553 = state_17549;
(statearr_17553[(7)] = inst_17510);

(statearr_17553[(8)] = inst_17509);

return statearr_17553;
})();
var statearr_17554_17602 = state_17549__$1;
(statearr_17554_17602[(2)] = null);

(statearr_17554_17602[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17550 === (4))){
var inst_17513 = (state_17549[(9)]);
var inst_17513__$1 = (state_17549[(2)]);
var inst_17514 = (inst_17513__$1 == null);
var inst_17515 = cljs.core.not.call(null,inst_17514);
var state_17549__$1 = (function (){var statearr_17555 = state_17549;
(statearr_17555[(9)] = inst_17513__$1);

return statearr_17555;
})();
if(inst_17515){
var statearr_17556_17604 = state_17549__$1;
(statearr_17556_17604[(1)] = (5));

} else {
var statearr_17557_17605 = state_17549__$1;
(statearr_17557_17605[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17550 === (15))){
var inst_17539 = (state_17549[(2)]);
var state_17549__$1 = state_17549;
var statearr_17558_17606 = state_17549__$1;
(statearr_17558_17606[(2)] = inst_17539);

(statearr_17558_17606[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17550 === (13))){
var state_17549__$1 = state_17549;
var statearr_17559_17607 = state_17549__$1;
(statearr_17559_17607[(2)] = null);

(statearr_17559_17607[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17550 === (6))){
var inst_17509 = (state_17549[(8)]);
var inst_17534 = inst_17509.length;
var inst_17535 = (inst_17534 > (0));
var state_17549__$1 = state_17549;
if(cljs.core.truth_(inst_17535)){
var statearr_17560_17608 = state_17549__$1;
(statearr_17560_17608[(1)] = (12));

} else {
var statearr_17561_17610 = state_17549__$1;
(statearr_17561_17610[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17550 === (3))){
var inst_17547 = (state_17549[(2)]);
var state_17549__$1 = state_17549;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17549__$1,inst_17547);
} else {
if((state_val_17550 === (12))){
var inst_17509 = (state_17549[(8)]);
var inst_17537 = cljs.core.vec.call(null,inst_17509);
var state_17549__$1 = state_17549;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17549__$1,(15),out,inst_17537);
} else {
if((state_val_17550 === (2))){
var state_17549__$1 = state_17549;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17549__$1,(4),ch);
} else {
if((state_val_17550 === (11))){
var inst_17517 = (state_17549[(10)]);
var inst_17513 = (state_17549[(9)]);
var inst_17527 = (state_17549[(2)]);
var inst_17528 = [];
var inst_17529 = inst_17528.push(inst_17513);
var inst_17509 = inst_17528;
var inst_17510 = inst_17517;
var state_17549__$1 = (function (){var statearr_17562 = state_17549;
(statearr_17562[(11)] = inst_17529);

(statearr_17562[(7)] = inst_17510);

(statearr_17562[(12)] = inst_17527);

(statearr_17562[(8)] = inst_17509);

return statearr_17562;
})();
var statearr_17563_17611 = state_17549__$1;
(statearr_17563_17611[(2)] = null);

(statearr_17563_17611[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17550 === (9))){
var inst_17509 = (state_17549[(8)]);
var inst_17525 = cljs.core.vec.call(null,inst_17509);
var state_17549__$1 = state_17549;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17549__$1,(11),out,inst_17525);
} else {
if((state_val_17550 === (5))){
var inst_17517 = (state_17549[(10)]);
var inst_17510 = (state_17549[(7)]);
var inst_17513 = (state_17549[(9)]);
var inst_17517__$1 = f.call(null,inst_17513);
var inst_17518 = cljs.core._EQ_.call(null,inst_17517__$1,inst_17510);
var inst_17519 = cljs.core.keyword_identical_QMARK_.call(null,inst_17510,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_17520 = (inst_17518) || (inst_17519);
var state_17549__$1 = (function (){var statearr_17564 = state_17549;
(statearr_17564[(10)] = inst_17517__$1);

return statearr_17564;
})();
if(cljs.core.truth_(inst_17520)){
var statearr_17565_17625 = state_17549__$1;
(statearr_17565_17625[(1)] = (8));

} else {
var statearr_17566_17626 = state_17549__$1;
(statearr_17566_17626[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17550 === (14))){
var inst_17542 = (state_17549[(2)]);
var inst_17543 = cljs.core.async.close_BANG_.call(null,out);
var state_17549__$1 = (function (){var statearr_17568 = state_17549;
(statearr_17568[(13)] = inst_17542);

return statearr_17568;
})();
var statearr_17569_17627 = state_17549__$1;
(statearr_17569_17627[(2)] = inst_17543);

(statearr_17569_17627[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17550 === (10))){
var inst_17532 = (state_17549[(2)]);
var state_17549__$1 = state_17549;
var statearr_17574_17628 = state_17549__$1;
(statearr_17574_17628[(2)] = inst_17532);

(statearr_17574_17628[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17550 === (8))){
var inst_17517 = (state_17549[(10)]);
var inst_17509 = (state_17549[(8)]);
var inst_17513 = (state_17549[(9)]);
var inst_17522 = inst_17509.push(inst_17513);
var tmp17567 = inst_17509;
var inst_17509__$1 = tmp17567;
var inst_17510 = inst_17517;
var state_17549__$1 = (function (){var statearr_17575 = state_17549;
(statearr_17575[(7)] = inst_17510);

(statearr_17575[(8)] = inst_17509__$1);

(statearr_17575[(14)] = inst_17522);

return statearr_17575;
})();
var statearr_17576_17632 = state_17549__$1;
(statearr_17576_17632[(2)] = null);

(statearr_17576_17632[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14349__auto___17597,out))
;
return ((function (switch__14236__auto__,c__14349__auto___17597,out){
return (function() {
var cljs$core$async$state_machine__14237__auto__ = null;
var cljs$core$async$state_machine__14237__auto____0 = (function (){
var statearr_17582 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17582[(0)] = cljs$core$async$state_machine__14237__auto__);

(statearr_17582[(1)] = (1));

return statearr_17582;
});
var cljs$core$async$state_machine__14237__auto____1 = (function (state_17549){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_17549);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e17583){if((e17583 instanceof Object)){
var ex__14240__auto__ = e17583;
var statearr_17584_17633 = state_17549;
(statearr_17584_17633[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17549);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17583;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17634 = state_17549;
state_17549 = G__17634;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cljs$core$async$state_machine__14237__auto__ = function(state_17549){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14237__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14237__auto____1.call(this,state_17549);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14237__auto____0;
cljs$core$async$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14237__auto____1;
return cljs$core$async$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14349__auto___17597,out))
})();
var state__14351__auto__ = (function (){var statearr_17585 = f__14350__auto__.call(null);
(statearr_17585[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14349__auto___17597);

return statearr_17585;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14351__auto__);
});})(c__14349__auto___17597,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map?rel=1472808712036