// Compiled by ClojureScript 1.7.228 {}
goog.provide('cubanostack.rest');
goog.require('cljs.core');
goog.require('cubanostack.components.bus');
goog.require('cljs.core.async');
goog.require('cljs_http.client');
goog.require('cubanostack.local_storage');
goog.require('com.stuartsierra.component');
goog.require('cubanostack.components.state');

/**
 * @interface
 */
cubanostack.rest.Rest = function(){};

cubanostack.rest.find_all = (function cubanostack$rest$find_all(this$){
if((!((this$ == null))) && (!((this$.cubanostack$rest$Rest$find_all$arity$1 == null)))){
return this$.cubanostack$rest$Rest$find_all$arity$1(this$);
} else {
var x__6704__auto__ = (((this$ == null))?null:this$);
var m__6705__auto__ = (cubanostack.rest.find_all[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,this$);
} else {
var m__6705__auto____$1 = (cubanostack.rest.find_all["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"Rest.find-all",this$);
}
}
}
});

cubanostack.rest.create_BANG_ = (function cubanostack$rest$create_BANG_(this$,item){
if((!((this$ == null))) && (!((this$.cubanostack$rest$Rest$create_BANG_$arity$2 == null)))){
return this$.cubanostack$rest$Rest$create_BANG_$arity$2(this$,item);
} else {
var x__6704__auto__ = (((this$ == null))?null:this$);
var m__6705__auto__ = (cubanostack.rest.create_BANG_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,this$,item);
} else {
var m__6705__auto____$1 = (cubanostack.rest.create_BANG_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,this$,item);
} else {
throw cljs.core.missing_protocol.call(null,"Rest.create!",this$);
}
}
}
});

cubanostack.rest.get_one = (function cubanostack$rest$get_one(this$,id){
if((!((this$ == null))) && (!((this$.cubanostack$rest$Rest$get_one$arity$2 == null)))){
return this$.cubanostack$rest$Rest$get_one$arity$2(this$,id);
} else {
var x__6704__auto__ = (((this$ == null))?null:this$);
var m__6705__auto__ = (cubanostack.rest.get_one[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,this$,id);
} else {
var m__6705__auto____$1 = (cubanostack.rest.get_one["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,this$,id);
} else {
throw cljs.core.missing_protocol.call(null,"Rest.get-one",this$);
}
}
}
});

cubanostack.rest.delete_BANG_ = (function cubanostack$rest$delete_BANG_(this$,id){
if((!((this$ == null))) && (!((this$.cubanostack$rest$Rest$delete_BANG_$arity$2 == null)))){
return this$.cubanostack$rest$Rest$delete_BANG_$arity$2(this$,id);
} else {
var x__6704__auto__ = (((this$ == null))?null:this$);
var m__6705__auto__ = (cubanostack.rest.delete_BANG_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,this$,id);
} else {
var m__6705__auto____$1 = (cubanostack.rest.delete_BANG_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,this$,id);
} else {
throw cljs.core.missing_protocol.call(null,"Rest.delete!",this$);
}
}
}
});

cubanostack.rest.replace_BANG_ = (function cubanostack$rest$replace_BANG_(this$,id,entity){
if((!((this$ == null))) && (!((this$.cubanostack$rest$Rest$replace_BANG_$arity$3 == null)))){
return this$.cubanostack$rest$Rest$replace_BANG_$arity$3(this$,id,entity);
} else {
var x__6704__auto__ = (((this$ == null))?null:this$);
var m__6705__auto__ = (cubanostack.rest.replace_BANG_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,this$,id,entity);
} else {
var m__6705__auto____$1 = (cubanostack.rest.replace_BANG_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,this$,id,entity);
} else {
throw cljs.core.missing_protocol.call(null,"Rest.replace!",this$);
}
}
}
});

cubanostack.rest.patch_BANG_ = (function cubanostack$rest$patch_BANG_(this$,id,entity){
if((!((this$ == null))) && (!((this$.cubanostack$rest$Rest$patch_BANG_$arity$3 == null)))){
return this$.cubanostack$rest$Rest$patch_BANG_$arity$3(this$,id,entity);
} else {
var x__6704__auto__ = (((this$ == null))?null:this$);
var m__6705__auto__ = (cubanostack.rest.patch_BANG_[goog.typeOf(x__6704__auto__)]);
if(!((m__6705__auto__ == null))){
return m__6705__auto__.call(null,this$,id,entity);
} else {
var m__6705__auto____$1 = (cubanostack.rest.patch_BANG_["_"]);
if(!((m__6705__auto____$1 == null))){
return m__6705__auto____$1.call(null,this$,id,entity);
} else {
throw cljs.core.missing_protocol.call(null,"Rest.patch!",this$);
}
}
}
});

cubanostack.rest.make_url = (function cubanostack$rest$make_url(var_args){
var args25611 = [];
var len__7107__auto___25620 = arguments.length;
var i__7108__auto___25621 = (0);
while(true){
if((i__7108__auto___25621 < len__7107__auto___25620)){
args25611.push((arguments[i__7108__auto___25621]));

var G__25625 = (i__7108__auto___25621 + (1));
i__7108__auto___25621 = G__25625;
continue;
} else {
}
break;
}

var G__25613 = args25611.length;
switch (G__25613) {
case 1:
return cubanostack.rest.make_url.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cubanostack.rest.make_url.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25611.length)].join('')));

}
});

cubanostack.rest.make_url.cljs$core$IFn$_invoke$arity$1 = (function (Rest){
return cubanostack.rest.make_url.call(null,Rest,null);
});

cubanostack.rest.make_url.cljs$core$IFn$_invoke$arity$2 = (function (p__25617,sub_url){
var map__25618 = p__25617;
var map__25618__$1 = ((((!((map__25618 == null)))?((((map__25618.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25618.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25618):map__25618);
var protocol = cljs.core.get.call(null,map__25618__$1,new cljs.core.Keyword(null,"protocol","protocol",652470118));
var hostname = cljs.core.get.call(null,map__25618__$1,new cljs.core.Keyword(null,"hostname","hostname",2105669933));
var port = cljs.core.get.call(null,map__25618__$1,new cljs.core.Keyword(null,"port","port",1534937262));
var url = cljs.core.get.call(null,map__25618__$1,new cljs.core.Keyword(null,"url","url",276297046));
return [cljs.core.str(protocol),cljs.core.str("//"),cljs.core.str(hostname),cljs.core.str((cljs.core.truth_(port)?":":null)),cljs.core.str(port),cljs.core.str("/"),cljs.core.str(url),cljs.core.str(sub_url)].join('');
});

cubanostack.rest.make_url.cljs$lang$maxFixedArity = 2;
cubanostack.rest._ask_for_auth = (function cubanostack$rest$_ask_for_auth(status,Bus){
var G__25629_25631 = Bus;
cubanostack.components.bus.send_BANG_.call(null,G__25629_25631,new cljs.core.Keyword("notification","add","notification/add",-797397960),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"content","content",15833224),(function (){var G__25630 = status;
switch (G__25630) {
case (401):
return "Server is asking for authentication!";

break;
case (403):
return "No enough permission!";

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(status)].join('')));

}
})()], null));

cubanostack.components.bus.send_BANG_.call(null,G__25629_25631,new cljs.core.Keyword(null,"route!","route!",-1286958144),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"handler","handler",-195596612),new cljs.core.Keyword("user","login","user/login",51503538)], null));


return null;
});
cubanostack.rest._request = (function cubanostack$rest$_request(var_args){
var args25633 = [];
var len__7107__auto___25736 = arguments.length;
var i__7108__auto___25737 = (0);
while(true){
if((i__7108__auto___25737 < len__7107__auto___25736)){
args25633.push((arguments[i__7108__auto___25737]));

var G__25740 = (i__7108__auto___25737 + (1));
i__7108__auto___25737 = G__25740;
continue;
} else {
}
break;
}

var G__25641 = args25633.length;
switch (G__25641) {
case 3:
return cubanostack.rest._request.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cubanostack.rest._request.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25633.length)].join('')));

}
});

cubanostack.rest._request.cljs$core$IFn$_invoke$arity$3 = (function (url,Bus,State){
return cubanostack.rest._request.call(null,url,Bus,State,null);
});

cubanostack.rest._request.cljs$core$IFn$_invoke$arity$4 = (function (url,Bus,State,req){
var c__14349__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14349__auto__){
return (function (){
var f__14350__auto__ = (function (){var switch__14236__auto__ = ((function (c__14349__auto__){
return (function (state_25693){
var state_val_25694 = (state_25693[(1)]);
if((state_val_25694 === (7))){
var state_25693__$1 = state_25693;
var statearr_25695_25745 = state_25693__$1;
(statearr_25695_25745[(2)] = false);

(statearr_25695_25745[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25694 === (1))){
var inst_25649 = cubanostack.local_storage.get_item_from_local_storage.call(null,new cljs.core.Keyword(null,"current-user","current-user",-868792091));
var inst_25650 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(inst_25649);
var inst_25651 = [new cljs.core.Keyword(null,"oauth-token","oauth-token",311415191)];
var inst_25652 = [inst_25650];
var inst_25653 = cljs.core.PersistentHashMap.fromArrays(inst_25651,inst_25652);
var inst_25654 = [new cljs.core.Keyword(null,"url","url",276297046)];
var inst_25655 = [url];
var inst_25656 = cljs.core.PersistentHashMap.fromArrays(inst_25654,inst_25655);
var inst_25657 = cljs.core.merge.call(null,inst_25653,req,inst_25656);
var inst_25658 = cljs_http.client.request.call(null,inst_25657);
var state_25693__$1 = state_25693;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25693__$1,(2),inst_25658);
} else {
if((state_val_25694 === (4))){
var state_25693__$1 = state_25693;
var statearr_25696_25754 = state_25693__$1;
(statearr_25696_25754[(2)] = false);

(statearr_25696_25754[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25694 === (15))){
var inst_25681 = (state_25693[(7)]);
var inst_25685 = cubanostack.rest._ask_for_auth.call(null,inst_25681,Bus);
var state_25693__$1 = state_25693;
var statearr_25697_25755 = state_25693__$1;
(statearr_25697_25755[(2)] = inst_25685);

(statearr_25697_25755[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25694 === (13))){
var inst_25682 = (state_25693[(8)]);
var state_25693__$1 = state_25693;
var statearr_25700_25781 = state_25693__$1;
(statearr_25700_25781[(2)] = inst_25682);

(statearr_25700_25781[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25694 === (6))){
var state_25693__$1 = state_25693;
var statearr_25701_25782 = state_25693__$1;
(statearr_25701_25782[(2)] = true);

(statearr_25701_25782[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25694 === (17))){
var state_25693__$1 = state_25693;
var statearr_25702_25783 = state_25693__$1;
(statearr_25702_25783[(2)] = null);

(statearr_25702_25783[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25694 === (3))){
var inst_25660 = (state_25693[(9)]);
var inst_25665 = inst_25660.cljs$lang$protocol_mask$partition0$;
var inst_25666 = (inst_25665 & (64));
var inst_25667 = inst_25660.cljs$core$ISeq$;
var inst_25668 = (inst_25666) || (inst_25667);
var state_25693__$1 = state_25693;
if(cljs.core.truth_(inst_25668)){
var statearr_25703_25799 = state_25693__$1;
(statearr_25703_25799[(1)] = (6));

} else {
var statearr_25704_25800 = state_25693__$1;
(statearr_25704_25800[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25694 === (12))){
var inst_25691 = (state_25693[(2)]);
var state_25693__$1 = state_25693;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25693__$1,inst_25691);
} else {
if((state_val_25694 === (2))){
var inst_25660 = (state_25693[(9)]);
var inst_25660__$1 = (state_25693[(2)]);
var inst_25662 = (inst_25660__$1 == null);
var inst_25663 = cljs.core.not.call(null,inst_25662);
var state_25693__$1 = (function (){var statearr_25705 = state_25693;
(statearr_25705[(9)] = inst_25660__$1);

return statearr_25705;
})();
if(inst_25663){
var statearr_25706_25801 = state_25693__$1;
(statearr_25706_25801[(1)] = (3));

} else {
var statearr_25707_25802 = state_25693__$1;
(statearr_25707_25802[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25694 === (11))){
var inst_25681 = (state_25693[(7)]);
var inst_25680 = (state_25693[(2)]);
var inst_25681__$1 = cljs.core.get.call(null,inst_25680,new cljs.core.Keyword(null,"status","status",-1997798413));
var inst_25682 = cljs.core.get.call(null,inst_25680,new cljs.core.Keyword(null,"body","body",-2049205669));
var state_25693__$1 = (function (){var statearr_25709 = state_25693;
(statearr_25709[(8)] = inst_25682);

(statearr_25709[(7)] = inst_25681__$1);

return statearr_25709;
})();
var G__25710_25815 = inst_25681__$1;
switch (G__25710_25815) {
case (200):
var statearr_25711_25817 = state_25693__$1;
(statearr_25711_25817[(1)] = (13));


break;
case (201):
var statearr_25712_25818 = state_25693__$1;
(statearr_25712_25818[(1)] = (14));


break;
case (401):
var statearr_25713_25819 = state_25693__$1;
(statearr_25713_25819[(1)] = (15));


break;
case (403):
var statearr_25714_25820 = state_25693__$1;
(statearr_25714_25820[(1)] = (16));


break;
default:
var statearr_25715_25821 = state_25693__$1;
(statearr_25715_25821[(1)] = (17));



}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25694 === (9))){
var inst_25660 = (state_25693[(9)]);
var inst_25677 = cljs.core.apply.call(null,cljs.core.hash_map,inst_25660);
var state_25693__$1 = state_25693;
var statearr_25716_25832 = state_25693__$1;
(statearr_25716_25832[(2)] = inst_25677);

(statearr_25716_25832[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25694 === (5))){
var inst_25675 = (state_25693[(2)]);
var state_25693__$1 = state_25693;
if(cljs.core.truth_(inst_25675)){
var statearr_25717_25833 = state_25693__$1;
(statearr_25717_25833[(1)] = (9));

} else {
var statearr_25718_25834 = state_25693__$1;
(statearr_25718_25834[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25694 === (14))){
var inst_25682 = (state_25693[(8)]);
var state_25693__$1 = state_25693;
var statearr_25719_25836 = state_25693__$1;
(statearr_25719_25836[(2)] = inst_25682);

(statearr_25719_25836[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25694 === (16))){
var inst_25681 = (state_25693[(7)]);
var inst_25687 = cubanostack.rest._ask_for_auth.call(null,inst_25681,Bus);
var state_25693__$1 = state_25693;
var statearr_25720_25837 = state_25693__$1;
(statearr_25720_25837[(2)] = inst_25687);

(statearr_25720_25837[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25694 === (10))){
var inst_25660 = (state_25693[(9)]);
var state_25693__$1 = state_25693;
var statearr_25721_25838 = state_25693__$1;
(statearr_25721_25838[(2)] = inst_25660);

(statearr_25721_25838[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25694 === (8))){
var inst_25672 = (state_25693[(2)]);
var state_25693__$1 = state_25693;
var statearr_25722_25861 = state_25693__$1;
(statearr_25722_25861[(2)] = inst_25672);

(statearr_25722_25861[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14349__auto__))
;
return ((function (switch__14236__auto__,c__14349__auto__){
return (function() {
var cubanostack$rest$state_machine__14237__auto__ = null;
var cubanostack$rest$state_machine__14237__auto____0 = (function (){
var statearr_25726 = [null,null,null,null,null,null,null,null,null,null];
(statearr_25726[(0)] = cubanostack$rest$state_machine__14237__auto__);

(statearr_25726[(1)] = (1));

return statearr_25726;
});
var cubanostack$rest$state_machine__14237__auto____1 = (function (state_25693){
while(true){
var ret_value__14238__auto__ = (function (){try{while(true){
var result__14239__auto__ = switch__14236__auto__.call(null,state_25693);
if(cljs.core.keyword_identical_QMARK_.call(null,result__14239__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__14239__auto__;
}
break;
}
}catch (e25731){if((e25731 instanceof Object)){
var ex__14240__auto__ = e25731;
var statearr_25734_25880 = state_25693;
(statearr_25734_25880[(5)] = ex__14240__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25693);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25731;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__14238__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25882 = state_25693;
state_25693 = G__25882;
continue;
} else {
return ret_value__14238__auto__;
}
break;
}
});
cubanostack$rest$state_machine__14237__auto__ = function(state_25693){
switch(arguments.length){
case 0:
return cubanostack$rest$state_machine__14237__auto____0.call(this);
case 1:
return cubanostack$rest$state_machine__14237__auto____1.call(this,state_25693);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cubanostack$rest$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$0 = cubanostack$rest$state_machine__14237__auto____0;
cubanostack$rest$state_machine__14237__auto__.cljs$core$IFn$_invoke$arity$1 = cubanostack$rest$state_machine__14237__auto____1;
return cubanostack$rest$state_machine__14237__auto__;
})()
;})(switch__14236__auto__,c__14349__auto__))
})();
var state__14351__auto__ = (function (){var statearr_25735 = f__14350__auto__.call(null);
(statearr_25735[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14349__auto__);

return statearr_25735;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14351__auto__);
});})(c__14349__auto__))
);

return c__14349__auto__;
});

cubanostack.rest._request.cljs$lang$maxFixedArity = 4;

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cubanostack.rest.Rest}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {com.stuartsierra.component.Lifecycle}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cubanostack.rest.Rest_STAR_ = (function (url,protocol,hostname,port,Bus,State,__meta,__extmap,__hash){
this.url = url;
this.protocol = protocol;
this.hostname = hostname;
this.port = port;
this.Bus = Bus;
this.State = State;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cubanostack.rest.Rest_STAR_.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__6663__auto__,k__6664__auto__){
var self__ = this;
var this__6663__auto____$1 = this;
return cljs.core._lookup.call(null,this__6663__auto____$1,k__6664__auto__,null);
});

cubanostack.rest.Rest_STAR_.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__6665__auto__,k25886,else__6666__auto__){
var self__ = this;
var this__6665__auto____$1 = this;
var G__25893 = (((k25886 instanceof cljs.core.Keyword))?k25886.fqn:null);
switch (G__25893) {
case "url":
return self__.url;

break;
case "protocol":
return self__.protocol;

break;
case "hostname":
return self__.hostname;

break;
case "port":
return self__.port;

break;
case "Bus":
return self__.Bus;

break;
case "State":
return self__.State;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k25886,else__6666__auto__);

}
});

cubanostack.rest.Rest_STAR_.prototype.com$stuartsierra$component$Lifecycle$ = true;

cubanostack.rest.Rest_STAR_.prototype.com$stuartsierra$component$Lifecycle$start$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cubanostack.rest.Rest_STAR_.prototype.com$stuartsierra$component$Lifecycle$stop$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cubanostack.rest.Rest_STAR_.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__6677__auto__,writer__6678__auto__,opts__6679__auto__){
var self__ = this;
var this__6677__auto____$1 = this;
var pr_pair__6680__auto__ = ((function (this__6677__auto____$1){
return (function (keyval__6681__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__6678__auto__,cljs.core.pr_writer,""," ","",opts__6679__auto__,keyval__6681__auto__);
});})(this__6677__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__6678__auto__,pr_pair__6680__auto__,"#cubanostack.rest.Rest*{",", ","}",opts__6679__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"url","url",276297046),self__.url],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"protocol","protocol",652470118),self__.protocol],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"hostname","hostname",2105669933),self__.hostname],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"port","port",1534937262),self__.port],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"Bus","Bus",-129151867),self__.Bus],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"State","State",-152966343),self__.State],null))], null),self__.__extmap));
});

cubanostack.rest.Rest_STAR_.prototype.cljs$core$IIterable$ = true;

cubanostack.rest.Rest_STAR_.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__25885){
var self__ = this;
var G__25885__$1 = this;
return (new cljs.core.RecordIter((0),G__25885__$1,6,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"url","url",276297046),new cljs.core.Keyword(null,"protocol","protocol",652470118),new cljs.core.Keyword(null,"hostname","hostname",2105669933),new cljs.core.Keyword(null,"port","port",1534937262),new cljs.core.Keyword(null,"Bus","Bus",-129151867),new cljs.core.Keyword(null,"State","State",-152966343)], null),cljs.core._iterator.call(null,self__.__extmap)));
});

cubanostack.rest.Rest_STAR_.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__6661__auto__){
var self__ = this;
var this__6661__auto____$1 = this;
return self__.__meta;
});

cubanostack.rest.Rest_STAR_.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__6657__auto__){
var self__ = this;
var this__6657__auto____$1 = this;
return (new cubanostack.rest.Rest_STAR_(self__.url,self__.protocol,self__.hostname,self__.port,self__.Bus,self__.State,self__.__meta,self__.__extmap,self__.__hash));
});

cubanostack.rest.Rest_STAR_.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__6667__auto__){
var self__ = this;
var this__6667__auto____$1 = this;
return (6 + cljs.core.count.call(null,self__.__extmap));
});

cubanostack.rest.Rest_STAR_.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__6658__auto__){
var self__ = this;
var this__6658__auto____$1 = this;
var h__6484__auto__ = self__.__hash;
if(!((h__6484__auto__ == null))){
return h__6484__auto__;
} else {
var h__6484__auto____$1 = cljs.core.hash_imap.call(null,this__6658__auto____$1);
self__.__hash = h__6484__auto____$1;

return h__6484__auto____$1;
}
});

cubanostack.rest.Rest_STAR_.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__6659__auto__,other__6660__auto__){
var self__ = this;
var this__6659__auto____$1 = this;
if(cljs.core.truth_((function (){var and__6037__auto__ = other__6660__auto__;
if(cljs.core.truth_(and__6037__auto__)){
var and__6037__auto____$1 = (this__6659__auto____$1.constructor === other__6660__auto__.constructor);
if(and__6037__auto____$1){
return cljs.core.equiv_map.call(null,this__6659__auto____$1,other__6660__auto__);
} else {
return and__6037__auto____$1;
}
} else {
return and__6037__auto__;
}
})())){
return true;
} else {
return false;
}
});

cubanostack.rest.Rest_STAR_.prototype.cubanostack$rest$Rest$ = true;

cubanostack.rest.Rest_STAR_.prototype.cubanostack$rest$Rest$find_all$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cubanostack.rest._request.call(null,cubanostack.rest.make_url.call(null,this$__$1),self__.Bus,self__.State);
});

cubanostack.rest.Rest_STAR_.prototype.cubanostack$rest$Rest$create_BANG_$arity$2 = (function (this$,entity){
var self__ = this;
var this$__$1 = this;
return cubanostack.rest._request.call(null,cubanostack.rest.make_url.call(null,this$__$1),self__.Bus,self__.State,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"json-params","json-params",-1112693596),entity], null));
});

cubanostack.rest.Rest_STAR_.prototype.cubanostack$rest$Rest$get_one$arity$2 = (function (this$,id){
var self__ = this;
var this$__$1 = this;
return cubanostack.rest._request.call(null,cubanostack.rest.make_url.call(null,this$__$1,id),self__.Bus,self__.State);
});

cubanostack.rest.Rest_STAR_.prototype.cubanostack$rest$Rest$delete_BANG_$arity$2 = (function (this$,id){
var self__ = this;
var this$__$1 = this;
return cubanostack.rest._request.call(null,cubanostack.rest.make_url.call(null,this$__$1,id),self__.Bus,self__.State,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"delete","delete",-1768633620)], null));
});

cubanostack.rest.Rest_STAR_.prototype.cubanostack$rest$Rest$replace_BANG_$arity$3 = (function (this$,id,entity){
var self__ = this;
var this$__$1 = this;
return cubanostack.rest._request.call(null,cubanostack.rest.make_url.call(null,this$__$1,id),self__.Bus,self__.State,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"put","put",1299772570),new cljs.core.Keyword(null,"json-params","json-params",-1112693596),entity], null));
});

cubanostack.rest.Rest_STAR_.prototype.cubanostack$rest$Rest$patch_BANG_$arity$3 = (function (this$,id,entity){
var self__ = this;
var this$__$1 = this;
return cubanostack.rest._request.call(null,cubanostack.rest.make_url.call(null,this$__$1,id),self__.Bus,self__.State,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"patch","patch",380775109),new cljs.core.Keyword(null,"json-params","json-params",-1112693596),entity], null));
});

cubanostack.rest.Rest_STAR_.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__6672__auto__,k__6673__auto__){
var self__ = this;
var this__6672__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"Bus","Bus",-129151867),null,new cljs.core.Keyword(null,"protocol","protocol",652470118),null,new cljs.core.Keyword(null,"hostname","hostname",2105669933),null,new cljs.core.Keyword(null,"port","port",1534937262),null,new cljs.core.Keyword(null,"url","url",276297046),null,new cljs.core.Keyword(null,"State","State",-152966343),null], null), null),k__6673__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__6672__auto____$1),self__.__meta),k__6673__auto__);
} else {
return (new cubanostack.rest.Rest_STAR_(self__.url,self__.protocol,self__.hostname,self__.port,self__.Bus,self__.State,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__6673__auto__)),null));
}
});

cubanostack.rest.Rest_STAR_.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__6670__auto__,k__6671__auto__,G__25885){
var self__ = this;
var this__6670__auto____$1 = this;
var pred__25897 = cljs.core.keyword_identical_QMARK_;
var expr__25898 = k__6671__auto__;
if(cljs.core.truth_(pred__25897.call(null,new cljs.core.Keyword(null,"url","url",276297046),expr__25898))){
return (new cubanostack.rest.Rest_STAR_(G__25885,self__.protocol,self__.hostname,self__.port,self__.Bus,self__.State,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__25897.call(null,new cljs.core.Keyword(null,"protocol","protocol",652470118),expr__25898))){
return (new cubanostack.rest.Rest_STAR_(self__.url,G__25885,self__.hostname,self__.port,self__.Bus,self__.State,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__25897.call(null,new cljs.core.Keyword(null,"hostname","hostname",2105669933),expr__25898))){
return (new cubanostack.rest.Rest_STAR_(self__.url,self__.protocol,G__25885,self__.port,self__.Bus,self__.State,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__25897.call(null,new cljs.core.Keyword(null,"port","port",1534937262),expr__25898))){
return (new cubanostack.rest.Rest_STAR_(self__.url,self__.protocol,self__.hostname,G__25885,self__.Bus,self__.State,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__25897.call(null,new cljs.core.Keyword(null,"Bus","Bus",-129151867),expr__25898))){
return (new cubanostack.rest.Rest_STAR_(self__.url,self__.protocol,self__.hostname,self__.port,G__25885,self__.State,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__25897.call(null,new cljs.core.Keyword(null,"State","State",-152966343),expr__25898))){
return (new cubanostack.rest.Rest_STAR_(self__.url,self__.protocol,self__.hostname,self__.port,self__.Bus,G__25885,self__.__meta,self__.__extmap,null));
} else {
return (new cubanostack.rest.Rest_STAR_(self__.url,self__.protocol,self__.hostname,self__.port,self__.Bus,self__.State,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__6671__auto__,G__25885),null));
}
}
}
}
}
}
});

cubanostack.rest.Rest_STAR_.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__6675__auto__){
var self__ = this;
var this__6675__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"url","url",276297046),self__.url],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"protocol","protocol",652470118),self__.protocol],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"hostname","hostname",2105669933),self__.hostname],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"port","port",1534937262),self__.port],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"Bus","Bus",-129151867),self__.Bus],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"State","State",-152966343),self__.State],null))], null),self__.__extmap));
});

cubanostack.rest.Rest_STAR_.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__6662__auto__,G__25885){
var self__ = this;
var this__6662__auto____$1 = this;
return (new cubanostack.rest.Rest_STAR_(self__.url,self__.protocol,self__.hostname,self__.port,self__.Bus,self__.State,G__25885,self__.__extmap,self__.__hash));
});

cubanostack.rest.Rest_STAR_.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__6668__auto__,entry__6669__auto__){
var self__ = this;
var this__6668__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__6669__auto__)){
return cljs.core._assoc.call(null,this__6668__auto____$1,cljs.core._nth.call(null,entry__6669__auto__,(0)),cljs.core._nth.call(null,entry__6669__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__6668__auto____$1,entry__6669__auto__);
}
});

cubanostack.rest.Rest_STAR_.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"url","url",1916828573,null),new cljs.core.Symbol(null,"protocol","protocol",-2001965651,null),new cljs.core.Symbol(null,"hostname","hostname",-548765836,null),new cljs.core.Symbol(null,"port","port",-1119498507,null),new cljs.core.Symbol(null,"Bus","Bus",1511379660,null),new cljs.core.Symbol(null,"State","State",1487565184,null)], null);
});

cubanostack.rest.Rest_STAR_.cljs$lang$type = true;

cubanostack.rest.Rest_STAR_.cljs$lang$ctorPrSeq = (function (this__6697__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"cubanostack.rest/Rest*");
});

cubanostack.rest.Rest_STAR_.cljs$lang$ctorPrWriter = (function (this__6697__auto__,writer__6698__auto__){
return cljs.core._write.call(null,writer__6698__auto__,"cubanostack.rest/Rest*");
});

cubanostack.rest.__GT_Rest_STAR_ = (function cubanostack$rest$__GT_Rest_STAR_(url,protocol,hostname,port,Bus,State){
return (new cubanostack.rest.Rest_STAR_(url,protocol,hostname,port,Bus,State,null,null,null));
});

cubanostack.rest.map__GT_Rest_STAR_ = (function cubanostack$rest$map__GT_Rest_STAR_(G__25889){
return (new cubanostack.rest.Rest_STAR_(new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(G__25889),new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(G__25889),new cljs.core.Keyword(null,"hostname","hostname",2105669933).cljs$core$IFn$_invoke$arity$1(G__25889),new cljs.core.Keyword(null,"port","port",1534937262).cljs$core$IFn$_invoke$arity$1(G__25889),new cljs.core.Keyword(null,"Bus","Bus",-129151867).cljs$core$IFn$_invoke$arity$1(G__25889),new cljs.core.Keyword(null,"State","State",-152966343).cljs$core$IFn$_invoke$arity$1(G__25889),null,cljs.core.dissoc.call(null,G__25889,new cljs.core.Keyword(null,"url","url",276297046),new cljs.core.Keyword(null,"protocol","protocol",652470118),new cljs.core.Keyword(null,"hostname","hostname",2105669933),new cljs.core.Keyword(null,"port","port",1534937262),new cljs.core.Keyword(null,"Bus","Bus",-129151867),new cljs.core.Keyword(null,"State","State",-152966343)),null));
});

cubanostack.rest.new_rest = (function cubanostack$rest$new_rest(params){
return cubanostack.rest.map__GT_Rest_STAR_.call(null,cljs.core.merge.call(null,(function (){var location = (window["location"]);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"protocol","protocol",652470118),(location["protocol"]),new cljs.core.Keyword(null,"port","port",1534937262),(function (){var port = (location["port"]);
if(cljs.core._EQ_.call(null,"",port)){
return null;
} else {
return port;
}
})(),new cljs.core.Keyword(null,"hostname","hostname",2105669933),(location["hostname"])], null);
})(),params));
});

//# sourceMappingURL=rest.js.map?rel=1472808720566