# sql-builder

A Clojure library designed to build sql query for the JDBC driver.

## Installation

Add the following dependency to your `project.clj` file:

```clojure
[com.curbside.sql "0.1.0-SNAPSHOT"]
```

## Usage

```clojure
(ns hello-world.core
  (:require
   [curbside.sql :refer [query select from where]]))

(query :select ["name" "age"]
       :from "users"
       :where {:id 1})
; ["SELECT name, age FROM users WHERE id = ?" 1]

(-> (select "*")
    (from "users")
    (where {:id 1}))
; ["SELECT * FROM users WHERE id = ?" 1]
```
