# Cursors

A small implementation, inspired by [Om's cursors](https://github.com/swannodette/om/wiki/Cursors). It can be used outside of Om, or any React contaxt. 

*Cursors* is still very alpha and is meant to solve a problem that I had. Please critique and make suggestions for the the TODO list.And of course PRs are always welcome.  


### Usage

Simply pull it into your project.clj file.

```
:dependencies [[cursors "0.1.0"]]
```


Then start using it in your clojurescript code.

```
(require '[cursors.core :as crs])
```

There's a few main things you can do with this library.


### Basic Changes

Basic changes will be reflected back to the path location in the core data structure.

```
(def state (atom {:a 1 :b {:c 3 :d {:e 5}}}))

(def one (cursor state [:b :c]))
(.state one)         ;; => #<Atom@9823b3: {:b {:c 3, :d {:e 5}}, :a 1}> 
(.transact one 4)    ;; => {:b {:c 4, :d {:e 5}}, :a 1} 

(def two (cursor state [:b :d]))
(.state two)                   ;; => #<Atom@9823b3: {:b {:c 4, :d {:e 5}}, :a 1}> 
(.transact two {:foo :bar})    ;; => {:b {:c 4, :d {:foo :bar}}, :a 1}  
```

### Nested Cursors 

You can also have nested cursors.

```
(def nested (cursor two [:foo]))
(.state nested)
(.path nested)              ;; => (:b :d :foo)
(.path (.parent nested))    ;; => [:b :d]
(.transact nested 111)      ;; => {:b {:c 4, :d {:foo 111}}, :a 1} 
```


And cursor state updates to reflect source changes.

```
(.state (.parent nested))    ;; => #<Atom@9823b3: {:b {:c 4, :d {:foo 111}}, :a 1}>
(.state two)                 ;; => #<Atom@9823b3: {:b {:c 4, :d {:foo 111}}, :a 1}>
```

You can use the standard clojure mechanisms to watch changes in your source atom. 

```
(add-watch state :watcher
  (fn [key atom old-state new-state]
  (prn "-- Atom Changed --")
  (prn "key: " key)
  (prn "atom: " atom)
  (prn "old-state: " old-state)
  (prn "new-state: " new-state)))
```

### TODOs
- List cursor
- Set Cursor 
- add tests (with test.check)


### License

Copyright © 2015 Interrupt Software

Distributed under the Eclipse Public License either version 1.0 or (at your option) any later version.
