(ns leiningen.new.d3-app
  (:use [leiningen.new.templates :only [renderer name-to-path ->files]]))

(def render (renderer "d3-app"))

(defn d3-app [name]
  (let [data {:name name
              :sanitized (name-to-path name)}]
    (->files data
             ["index.html" (render "index.html" data)]
             "src-clj/{{sanitized}}"
             "src-cljs/{{sanitized}}"
             ["project.clj" (render "project.clj" data)]
             ["src-cljs/{{sanitized}}/core.cljs" (render "src-cljs/d3_app/core.cljs" data)]
             "resources/public/js"
             "resources/public/css"
             ["resources/public/css/bootstrap.css" (render "resources/public/css/bootstrap.css")]
             ["resources/public/js/d3.v3.js" (render "resources/public/js/d3.v3.js")])))
