goog.provide('chord.client');
chord.client.close_event__GT_maybe_error = (function chord$client$close_event__GT_maybe_error(ev){
if(cljs.core.truth_(ev.wasClean)){
return null;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"reason","reason",-2070751759),ev.reason,new cljs.core.Keyword(null,"code","code",1586293142),ev.code], null);
}
});
chord.client.create_ws = (function chord$client$create_ws(url,opts){
if(cljs.core.truth_((((typeof require !== 'undefined'))?(function (){try{return require("ws");
}catch (e30615){var e = e30615;
return false;
}})():false))){
var ws = require("ws");
if(cljs.core.truth_(opts)){
return (new ws(url,cljs.core.clj__GT_js(opts)));
} else {
return (new ws(url));
}
} else {
return (new WebSocket(url));

}
});
/**
 * Creates websockets connection and returns a 2-sided channel when the websocket is opened.
 * Arguments:
 *  ws-url           - (required) link to websocket service
 *  opts             - (optional) map to configure reading/writing channels
 *    :read-ch       - (optional) (possibly buffered) channel to use for reading the websocket
 *    :write-ch      - (optional) (possibly buffered) channel to use for writing to the websocket
 *    :format        - (optional) data format to use on the channel, (at the moment)
 *                                either :edn (default), :json, :json-kw or :str.
 *    :ws-opts       - (optional) Other options to be passed to the websocket constructor (NodeJS only)
 *                                see https://github.com/websockets/ws/blob/master/doc/ws.md#new-websocketaddress-protocols-options
 * 
 * Usage:
 *  (:require [cljs.core.async :as a])
 * 
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437"))
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437" {:read-ch (a/chan (a/sliding-buffer 10))}))
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437" {:read-ch (a/chan (a/sliding-buffer 10))
 *                                        :write-ch (a/chan (a/dropping-buffer 10))}))
 */
chord.client.ws_ch = (function chord$client$ws_ch(var_args){
var args__4742__auto__ = [];
var len__4736__auto___30822 = arguments.length;
var i__4737__auto___30824 = (0);
while(true){
if((i__4737__auto___30824 < len__4736__auto___30822)){
args__4742__auto__.push((arguments[i__4737__auto___30824]));

var G__30825 = (i__4737__auto___30824 + (1));
i__4737__auto___30824 = G__30825;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic = (function (ws_url,p__30627){
var vec__30628 = p__30627;
var map__30632 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30628,(0),null);
var map__30632__$1 = (((((!((map__30632 == null))))?(((((map__30632.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30632.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30632):map__30632);
var opts = map__30632__$1;
var read_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30632__$1,new cljs.core.Keyword(null,"read-ch","read-ch",-38486414));
var write_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30632__$1,new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599));
var format = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30632__$1,new cljs.core.Keyword(null,"format","format",-1306924766));
var ws_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30632__$1,new cljs.core.Keyword(null,"ws-opts","ws-opts",1487801643));
var web_socket = chord.client.create_ws(ws_url,ws_opts);
var map__30637 = chord.format.wrap_format(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"read-ch","read-ch",-38486414),(function (){var or__4126__auto__ = read_ch;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
}
})(),new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599),(function (){var or__4126__auto__ = write_ch;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
}
})()], null),opts);
var map__30637__$1 = (((((!((map__30637 == null))))?(((((map__30637.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30637.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30637):map__30637);
var read_ch__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30637__$1,new cljs.core.Keyword(null,"read-ch","read-ch",-38486414));
var write_ch__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30637__$1,new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599));
var open_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var close_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
(web_socket.binaryType = "arraybuffer");

chord.channels.read_from_ws_BANG_(web_socket,read_ch__$1);

chord.channels.write_to_ws_BANG_(web_socket,write_ch__$1);

(web_socket.onopen = (function (p1__30617_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_ch,p1__30617_SHARP_);
}));

(web_socket.onclose = (function (p1__30619_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(close_ch,p1__30619_SHARP_);
}));

var ws_chan = chord.channels.bidi_ch.cljs$core$IFn$_invoke$arity$variadic(read_ch__$1,write_ch__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-close","on-close",-761178394),(function (){
return web_socket.close();
})], null)], 0));
var initial_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__28356__auto___30845 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28357__auto__ = (function (){var switch__28157__auto__ = (function (state_30724){
var state_val_30725 = (state_30724[(1)]);
if((state_val_30725 === (7))){
var inst_30719 = (state_30724[(2)]);
var state_30724__$1 = state_30724;
var statearr_30728_30849 = state_30724__$1;
(statearr_30728_30849[(2)] = inst_30719);

(statearr_30728_30849[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30725 === (20))){
var state_30724__$1 = state_30724;
var statearr_30730_30852 = state_30724__$1;
(statearr_30730_30852[(2)] = null);

(statearr_30730_30852[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30725 === (1))){
var inst_30642 = false;
var state_30724__$1 = (function (){var statearr_30732 = state_30724;
(statearr_30732[(7)] = inst_30642);

return statearr_30732;
})();
var statearr_30735_30855 = state_30724__$1;
(statearr_30735_30855[(2)] = null);

(statearr_30735_30855[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30725 === (4))){
var inst_30662 = (state_30724[(8)]);
var inst_30660 = (state_30724[(9)]);
var inst_30660__$1 = (state_30724[(2)]);
var inst_30661 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30660__$1,(0),null);
var inst_30662__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30660__$1,(1),null);
var inst_30664 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_30662__$1,open_ch);
var state_30724__$1 = (function (){var statearr_30741 = state_30724;
(statearr_30741[(10)] = inst_30661);

(statearr_30741[(8)] = inst_30662__$1);

(statearr_30741[(9)] = inst_30660__$1);

return statearr_30741;
})();
if(inst_30664){
var statearr_30742_30864 = state_30724__$1;
(statearr_30742_30864[(1)] = (5));

} else {
var statearr_30744_30865 = state_30724__$1;
(statearr_30744_30865[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30725 === (15))){
var inst_30703 = (state_30724[(2)]);
var state_30724__$1 = state_30724;
var statearr_30747_30866 = state_30724__$1;
(statearr_30747_30866[(2)] = inst_30703);

(statearr_30747_30866[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30725 === (21))){
var inst_30715 = (state_30724[(2)]);
var state_30724__$1 = state_30724;
var statearr_30750_30871 = state_30724__$1;
(statearr_30750_30871[(2)] = inst_30715);

(statearr_30750_30871[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30725 === (13))){
var state_30724__$1 = state_30724;
var statearr_30752_30875 = state_30724__$1;
(statearr_30752_30875[(2)] = null);

(statearr_30752_30875[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30725 === (6))){
var inst_30662 = (state_30724[(8)]);
var inst_30683 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_30662,close_ch);
var state_30724__$1 = state_30724;
if(inst_30683){
var statearr_30753_30876 = state_30724__$1;
(statearr_30753_30876[(1)] = (9));

} else {
var statearr_30755_30880 = state_30724__$1;
(statearr_30755_30880[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30725 === (17))){
var state_30724__$1 = state_30724;
var statearr_30757_30881 = state_30724__$1;
(statearr_30757_30881[(2)] = initial_ch);

(statearr_30757_30881[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30725 === (3))){
var inst_30721 = (state_30724[(2)]);
var state_30724__$1 = state_30724;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30724__$1,inst_30721);
} else {
if((state_val_30725 === (12))){
var inst_30642 = (state_30724[(7)]);
var state_30724__$1 = state_30724;
if(cljs.core.truth_(inst_30642)){
var statearr_30759_30885 = state_30724__$1;
(statearr_30759_30885[(1)] = (16));

} else {
var statearr_30760_30887 = state_30724__$1;
(statearr_30760_30887[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30725 === (2))){
var inst_30655 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30656 = [open_ch,close_ch];
var inst_30657 = (new cljs.core.PersistentVector(null,2,(5),inst_30655,inst_30656,null));
var state_30724__$1 = state_30724;
return cljs.core.async.ioc_alts_BANG_(state_30724__$1,(4),inst_30657);
} else {
if((state_val_30725 === (19))){
var inst_30661 = (state_30724[(10)]);
var state_30724__$1 = state_30724;
var statearr_30764_30892 = state_30724__$1;
(statearr_30764_30892[(2)] = inst_30661);

(statearr_30764_30892[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30725 === (11))){
var inst_30717 = (state_30724[(2)]);
var state_30724__$1 = state_30724;
var statearr_30767_30895 = state_30724__$1;
(statearr_30767_30895[(2)] = inst_30717);

(statearr_30767_30895[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30725 === (9))){
var inst_30691 = (state_30724[(11)]);
var inst_30660 = (state_30724[(9)]);
var inst_30689 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30660,(0),null);
var inst_30691__$1 = chord.client.close_event__GT_maybe_error(inst_30689);
var state_30724__$1 = (function (){var statearr_30771 = state_30724;
(statearr_30771[(11)] = inst_30691__$1);

return statearr_30771;
})();
if(cljs.core.truth_(inst_30691__$1)){
var statearr_30772_30900 = state_30724__$1;
(statearr_30772_30900[(1)] = (12));

} else {
var statearr_30773_30902 = state_30724__$1;
(statearr_30773_30902[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30725 === (5))){
var inst_30660 = (state_30724[(9)]);
var inst_30670 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30660,(0),null);
var inst_30671 = [new cljs.core.Keyword(null,"ws-channel","ws-channel",1643892174)];
var inst_30672 = [ws_chan];
var inst_30673 = cljs.core.PersistentHashMap.fromArrays(inst_30671,inst_30672);
var state_30724__$1 = (function (){var statearr_30778 = state_30724;
(statearr_30778[(12)] = inst_30670);

return statearr_30778;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30724__$1,(8),initial_ch,inst_30673);
} else {
if((state_val_30725 === (14))){
var inst_30706 = (state_30724[(2)]);
var inst_30707 = cljs.core.async.close_BANG_(ws_chan);
var inst_30708 = cljs.core.async.close_BANG_(initial_ch);
var state_30724__$1 = (function (){var statearr_30781 = state_30724;
(statearr_30781[(13)] = inst_30707);

(statearr_30781[(14)] = inst_30706);

return statearr_30781;
})();
var statearr_30783_30913 = state_30724__$1;
(statearr_30783_30913[(2)] = inst_30708);

(statearr_30783_30913[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30725 === (16))){
var state_30724__$1 = state_30724;
var statearr_30786_30917 = state_30724__$1;
(statearr_30786_30917[(2)] = read_ch__$1);

(statearr_30786_30917[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30725 === (10))){
var inst_30662 = (state_30724[(8)]);
var inst_30710 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_30662,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_30724__$1 = state_30724;
if(inst_30710){
var statearr_30787_30919 = state_30724__$1;
(statearr_30787_30919[(1)] = (19));

} else {
var statearr_30790_30920 = state_30724__$1;
(statearr_30790_30920[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30725 === (18))){
var inst_30691 = (state_30724[(11)]);
var inst_30697 = (state_30724[(2)]);
var inst_30699 = [new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_30700 = [inst_30691];
var inst_30701 = cljs.core.PersistentHashMap.fromArrays(inst_30699,inst_30700);
var state_30724__$1 = state_30724;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30724__$1,(15),inst_30697,inst_30701);
} else {
if((state_val_30725 === (8))){
var inst_30675 = (state_30724[(2)]);
var inst_30676 = cljs.core.async.close_BANG_(initial_ch);
var inst_30642 = true;
var state_30724__$1 = (function (){var statearr_30797 = state_30724;
(statearr_30797[(15)] = inst_30675);

(statearr_30797[(16)] = inst_30676);

(statearr_30797[(7)] = inst_30642);

return statearr_30797;
})();
var statearr_30798_30928 = state_30724__$1;
(statearr_30798_30928[(2)] = null);

(statearr_30798_30928[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var chord$client$state_machine__28158__auto__ = null;
var chord$client$state_machine__28158__auto____0 = (function (){
var statearr_30803 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30803[(0)] = chord$client$state_machine__28158__auto__);

(statearr_30803[(1)] = (1));

return statearr_30803;
});
var chord$client$state_machine__28158__auto____1 = (function (state_30724){
while(true){
var ret_value__28159__auto__ = (function (){try{while(true){
var result__28160__auto__ = switch__28157__auto__(state_30724);
if(cljs.core.keyword_identical_QMARK_(result__28160__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28160__auto__;
}
break;
}
}catch (e30804){if((e30804 instanceof Object)){
var ex__28161__auto__ = e30804;
var statearr_30806_30934 = state_30724;
(statearr_30806_30934[(5)] = ex__28161__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30724);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30804;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28159__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30936 = state_30724;
state_30724 = G__30936;
continue;
} else {
return ret_value__28159__auto__;
}
break;
}
});
chord$client$state_machine__28158__auto__ = function(state_30724){
switch(arguments.length){
case 0:
return chord$client$state_machine__28158__auto____0.call(this);
case 1:
return chord$client$state_machine__28158__auto____1.call(this,state_30724);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
chord$client$state_machine__28158__auto__.cljs$core$IFn$_invoke$arity$0 = chord$client$state_machine__28158__auto____0;
chord$client$state_machine__28158__auto__.cljs$core$IFn$_invoke$arity$1 = chord$client$state_machine__28158__auto____1;
return chord$client$state_machine__28158__auto__;
})()
})();
var state__28358__auto__ = (function (){var statearr_30813 = f__28357__auto__();
(statearr_30813[(6)] = c__28356__auto___30845);

return statearr_30813;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28358__auto__);
}));


return initial_ch;
}));

(chord.client.ws_ch.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(chord.client.ws_ch.cljs$lang$applyTo = (function (seq30624){
var G__30625 = cljs.core.first(seq30624);
var seq30624__$1 = cljs.core.next(seq30624);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30625,seq30624__$1);
}));


//# sourceMappingURL=chord.client.js.map
