goog.provide('cljs.core.async');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__28450 = arguments.length;
switch (G__28450) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async28451 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28451 = (function (f,blockable,meta28452){
this.f = f;
this.blockable = blockable;
this.meta28452 = meta28452;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async28451.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28453,meta28452__$1){
var self__ = this;
var _28453__$1 = this;
return (new cljs.core.async.t_cljs$core$async28451(self__.f,self__.blockable,meta28452__$1));
}));

(cljs.core.async.t_cljs$core$async28451.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28453){
var self__ = this;
var _28453__$1 = this;
return self__.meta28452;
}));

(cljs.core.async.t_cljs$core$async28451.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async28451.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async28451.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async28451.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async28451.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta28452","meta28452",1010342762,null)], null);
}));

(cljs.core.async.t_cljs$core$async28451.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async28451.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28451");

(cljs.core.async.t_cljs$core$async28451.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async28451");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async28451.
 */
cljs.core.async.__GT_t_cljs$core$async28451 = (function cljs$core$async$__GT_t_cljs$core$async28451(f__$1,blockable__$1,meta28452){
return (new cljs.core.async.t_cljs$core$async28451(f__$1,blockable__$1,meta28452));
});

}

return (new cljs.core.async.t_cljs$core$async28451(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__28465 = arguments.length;
switch (G__28465) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__28496 = arguments.length;
switch (G__28496) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__28499 = arguments.length;
switch (G__28499) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_30437 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_30437) : fn1.call(null,val_30437));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_30437) : fn1.call(null,val_30437));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__28513 = arguments.length;
switch (G__28513) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5718__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5718__auto__)){
var ret = temp__5718__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5718__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5718__auto__)){
var retb = temp__5718__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4613__auto___30478 = n;
var x_30479 = (0);
while(true){
if((x_30479 < n__4613__auto___30478)){
(a[x_30479] = x_30479);

var G__30484 = (x_30479 + (1));
x_30479 = G__30484;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async28541 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28541 = (function (flag,meta28542){
this.flag = flag;
this.meta28542 = meta28542;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async28541.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28543,meta28542__$1){
var self__ = this;
var _28543__$1 = this;
return (new cljs.core.async.t_cljs$core$async28541(self__.flag,meta28542__$1));
}));

(cljs.core.async.t_cljs$core$async28541.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28543){
var self__ = this;
var _28543__$1 = this;
return self__.meta28542;
}));

(cljs.core.async.t_cljs$core$async28541.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async28541.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async28541.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async28541.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async28541.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta28542","meta28542",-776563775,null)], null);
}));

(cljs.core.async.t_cljs$core$async28541.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async28541.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28541");

(cljs.core.async.t_cljs$core$async28541.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async28541");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async28541.
 */
cljs.core.async.__GT_t_cljs$core$async28541 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async28541(flag__$1,meta28542){
return (new cljs.core.async.t_cljs$core$async28541(flag__$1,meta28542));
});

}

return (new cljs.core.async.t_cljs$core$async28541(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async28580 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28580 = (function (flag,cb,meta28581){
this.flag = flag;
this.cb = cb;
this.meta28581 = meta28581;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async28580.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28582,meta28581__$1){
var self__ = this;
var _28582__$1 = this;
return (new cljs.core.async.t_cljs$core$async28580(self__.flag,self__.cb,meta28581__$1));
}));

(cljs.core.async.t_cljs$core$async28580.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28582){
var self__ = this;
var _28582__$1 = this;
return self__.meta28581;
}));

(cljs.core.async.t_cljs$core$async28580.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async28580.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async28580.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async28580.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async28580.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta28581","meta28581",1409764902,null)], null);
}));

(cljs.core.async.t_cljs$core$async28580.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async28580.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28580");

(cljs.core.async.t_cljs$core$async28580.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async28580");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async28580.
 */
cljs.core.async.__GT_t_cljs$core$async28580 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async28580(flag__$1,cb__$1,meta28581){
return (new cljs.core.async.t_cljs$core$async28580(flag__$1,cb__$1,meta28581));
});

}

return (new cljs.core.async.t_cljs$core$async28580(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__28604_SHARP_){
var G__28607 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__28604_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__28607) : fret.call(null,G__28607));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__28605_SHARP_){
var G__28608 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__28605_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__28608) : fret.call(null,G__28608));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4126__auto__ = wport;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return port;
}
})()], null));
} else {
var G__30523 = (i + (1));
i = G__30523;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4126__auto__ = ret;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5720__auto__ = (function (){var and__4115__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4115__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(temp__5720__auto__)){
var got = temp__5720__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___30528 = arguments.length;
var i__4737__auto___30529 = (0);
while(true){
if((i__4737__auto___30529 < len__4736__auto___30528)){
args__4742__auto__.push((arguments[i__4737__auto___30529]));

var G__30531 = (i__4737__auto___30529 + (1));
i__4737__auto___30529 = G__30531;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__28611){
var map__28612 = p__28611;
var map__28612__$1 = (((((!((map__28612 == null))))?(((((map__28612.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28612.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28612):map__28612);
var opts = map__28612__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq28609){
var G__28610 = cljs.core.first(seq28609);
var seq28609__$1 = cljs.core.next(seq28609);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28610,seq28609__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__28634 = arguments.length;
switch (G__28634) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__28356__auto___30560 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28357__auto__ = (function (){var switch__28157__auto__ = (function (state_28663){
var state_val_28664 = (state_28663[(1)]);
if((state_val_28664 === (7))){
var inst_28659 = (state_28663[(2)]);
var state_28663__$1 = state_28663;
var statearr_28666_30568 = state_28663__$1;
(statearr_28666_30568[(2)] = inst_28659);

(statearr_28666_30568[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28664 === (1))){
var state_28663__$1 = state_28663;
var statearr_28668_30570 = state_28663__$1;
(statearr_28668_30570[(2)] = null);

(statearr_28668_30570[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28664 === (4))){
var inst_28642 = (state_28663[(7)]);
var inst_28642__$1 = (state_28663[(2)]);
var inst_28643 = (inst_28642__$1 == null);
var state_28663__$1 = (function (){var statearr_28669 = state_28663;
(statearr_28669[(7)] = inst_28642__$1);

return statearr_28669;
})();
if(cljs.core.truth_(inst_28643)){
var statearr_28670_30575 = state_28663__$1;
(statearr_28670_30575[(1)] = (5));

} else {
var statearr_28671_30576 = state_28663__$1;
(statearr_28671_30576[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28664 === (13))){
var state_28663__$1 = state_28663;
var statearr_28672_30578 = state_28663__$1;
(statearr_28672_30578[(2)] = null);

(statearr_28672_30578[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28664 === (6))){
var inst_28642 = (state_28663[(7)]);
var state_28663__$1 = state_28663;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28663__$1,(11),to,inst_28642);
} else {
if((state_val_28664 === (3))){
var inst_28661 = (state_28663[(2)]);
var state_28663__$1 = state_28663;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28663__$1,inst_28661);
} else {
if((state_val_28664 === (12))){
var state_28663__$1 = state_28663;
var statearr_28678_30583 = state_28663__$1;
(statearr_28678_30583[(2)] = null);

(statearr_28678_30583[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28664 === (2))){
var state_28663__$1 = state_28663;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28663__$1,(4),from);
} else {
if((state_val_28664 === (11))){
var inst_28652 = (state_28663[(2)]);
var state_28663__$1 = state_28663;
if(cljs.core.truth_(inst_28652)){
var statearr_28679_30586 = state_28663__$1;
(statearr_28679_30586[(1)] = (12));

} else {
var statearr_28680_30587 = state_28663__$1;
(statearr_28680_30587[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28664 === (9))){
var state_28663__$1 = state_28663;
var statearr_28681_30588 = state_28663__$1;
(statearr_28681_30588[(2)] = null);

(statearr_28681_30588[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28664 === (5))){
var state_28663__$1 = state_28663;
if(cljs.core.truth_(close_QMARK_)){
var statearr_28682_30590 = state_28663__$1;
(statearr_28682_30590[(1)] = (8));

} else {
var statearr_28683_30591 = state_28663__$1;
(statearr_28683_30591[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28664 === (14))){
var inst_28657 = (state_28663[(2)]);
var state_28663__$1 = state_28663;
var statearr_28684_30592 = state_28663__$1;
(statearr_28684_30592[(2)] = inst_28657);

(statearr_28684_30592[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28664 === (10))){
var inst_28649 = (state_28663[(2)]);
var state_28663__$1 = state_28663;
var statearr_28685_30599 = state_28663__$1;
(statearr_28685_30599[(2)] = inst_28649);

(statearr_28685_30599[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28664 === (8))){
var inst_28646 = cljs.core.async.close_BANG_(to);
var state_28663__$1 = state_28663;
var statearr_28686_30600 = state_28663__$1;
(statearr_28686_30600[(2)] = inst_28646);

(statearr_28686_30600[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28158__auto__ = null;
var cljs$core$async$state_machine__28158__auto____0 = (function (){
var statearr_28687 = [null,null,null,null,null,null,null,null];
(statearr_28687[(0)] = cljs$core$async$state_machine__28158__auto__);

(statearr_28687[(1)] = (1));

return statearr_28687;
});
var cljs$core$async$state_machine__28158__auto____1 = (function (state_28663){
while(true){
var ret_value__28159__auto__ = (function (){try{while(true){
var result__28160__auto__ = switch__28157__auto__(state_28663);
if(cljs.core.keyword_identical_QMARK_(result__28160__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28160__auto__;
}
break;
}
}catch (e28688){if((e28688 instanceof Object)){
var ex__28161__auto__ = e28688;
var statearr_28689_30603 = state_28663;
(statearr_28689_30603[(5)] = ex__28161__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28663);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28688;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28159__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30606 = state_28663;
state_28663 = G__30606;
continue;
} else {
return ret_value__28159__auto__;
}
break;
}
});
cljs$core$async$state_machine__28158__auto__ = function(state_28663){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28158__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28158__auto____1.call(this,state_28663);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28158__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28158__auto____0;
cljs$core$async$state_machine__28158__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28158__auto____1;
return cljs$core$async$state_machine__28158__auto__;
})()
})();
var state__28358__auto__ = (function (){var statearr_28690 = f__28357__auto__();
(statearr_28690[(6)] = c__28356__auto___30560);

return statearr_28690;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28358__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__28696){
var vec__28697 = p__28696;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28697,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28697,(1),null);
var job = vec__28697;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__28356__auto___30611 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28357__auto__ = (function (){var switch__28157__auto__ = (function (state_28710){
var state_val_28711 = (state_28710[(1)]);
if((state_val_28711 === (1))){
var state_28710__$1 = state_28710;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28710__$1,(2),res,v);
} else {
if((state_val_28711 === (2))){
var inst_28707 = (state_28710[(2)]);
var inst_28708 = cljs.core.async.close_BANG_(res);
var state_28710__$1 = (function (){var statearr_28712 = state_28710;
(statearr_28712[(7)] = inst_28707);

return statearr_28712;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_28710__$1,inst_28708);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28158__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28158__auto____0 = (function (){
var statearr_28713 = [null,null,null,null,null,null,null,null];
(statearr_28713[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28158__auto__);

(statearr_28713[(1)] = (1));

return statearr_28713;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28158__auto____1 = (function (state_28710){
while(true){
var ret_value__28159__auto__ = (function (){try{while(true){
var result__28160__auto__ = switch__28157__auto__(state_28710);
if(cljs.core.keyword_identical_QMARK_(result__28160__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28160__auto__;
}
break;
}
}catch (e28714){if((e28714 instanceof Object)){
var ex__28161__auto__ = e28714;
var statearr_28715_30612 = state_28710;
(statearr_28715_30612[(5)] = ex__28161__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28710);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28714;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28159__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30614 = state_28710;
state_28710 = G__30614;
continue;
} else {
return ret_value__28159__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28158__auto__ = function(state_28710){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28158__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28158__auto____1.call(this,state_28710);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28158__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28158__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28158__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28158__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28158__auto__;
})()
})();
var state__28358__auto__ = (function (){var statearr_28716 = f__28357__auto__();
(statearr_28716[(6)] = c__28356__auto___30611);

return statearr_28716;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28358__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__28717){
var vec__28718 = p__28717;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28718,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28718,(1),null);
var job = vec__28718;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4613__auto___30616 = n;
var __30618 = (0);
while(true){
if((__30618 < n__4613__auto___30616)){
var G__28721_30620 = type;
var G__28721_30621__$1 = (((G__28721_30620 instanceof cljs.core.Keyword))?G__28721_30620.fqn:null);
switch (G__28721_30621__$1) {
case "compute":
var c__28356__auto___30623 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__30618,c__28356__auto___30623,G__28721_30620,G__28721_30621__$1,n__4613__auto___30616,jobs,results,process,async){
return (function (){
var f__28357__auto__ = (function (){var switch__28157__auto__ = ((function (__30618,c__28356__auto___30623,G__28721_30620,G__28721_30621__$1,n__4613__auto___30616,jobs,results,process,async){
return (function (state_28735){
var state_val_28736 = (state_28735[(1)]);
if((state_val_28736 === (1))){
var state_28735__$1 = state_28735;
var statearr_28738_30626 = state_28735__$1;
(statearr_28738_30626[(2)] = null);

(statearr_28738_30626[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28736 === (2))){
var state_28735__$1 = state_28735;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28735__$1,(4),jobs);
} else {
if((state_val_28736 === (3))){
var inst_28733 = (state_28735[(2)]);
var state_28735__$1 = state_28735;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28735__$1,inst_28733);
} else {
if((state_val_28736 === (4))){
var inst_28724 = (state_28735[(2)]);
var inst_28725 = process(inst_28724);
var state_28735__$1 = state_28735;
if(cljs.core.truth_(inst_28725)){
var statearr_28742_30629 = state_28735__$1;
(statearr_28742_30629[(1)] = (5));

} else {
var statearr_28744_30633 = state_28735__$1;
(statearr_28744_30633[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28736 === (5))){
var state_28735__$1 = state_28735;
var statearr_28746_30635 = state_28735__$1;
(statearr_28746_30635[(2)] = null);

(statearr_28746_30635[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28736 === (6))){
var state_28735__$1 = state_28735;
var statearr_28747_30636 = state_28735__$1;
(statearr_28747_30636[(2)] = null);

(statearr_28747_30636[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28736 === (7))){
var inst_28730 = (state_28735[(2)]);
var state_28735__$1 = state_28735;
var statearr_28749_30638 = state_28735__$1;
(statearr_28749_30638[(2)] = inst_28730);

(statearr_28749_30638[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__30618,c__28356__auto___30623,G__28721_30620,G__28721_30621__$1,n__4613__auto___30616,jobs,results,process,async))
;
return ((function (__30618,switch__28157__auto__,c__28356__auto___30623,G__28721_30620,G__28721_30621__$1,n__4613__auto___30616,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28158__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28158__auto____0 = (function (){
var statearr_28750 = [null,null,null,null,null,null,null];
(statearr_28750[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28158__auto__);

(statearr_28750[(1)] = (1));

return statearr_28750;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28158__auto____1 = (function (state_28735){
while(true){
var ret_value__28159__auto__ = (function (){try{while(true){
var result__28160__auto__ = switch__28157__auto__(state_28735);
if(cljs.core.keyword_identical_QMARK_(result__28160__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28160__auto__;
}
break;
}
}catch (e28751){if((e28751 instanceof Object)){
var ex__28161__auto__ = e28751;
var statearr_28752_30640 = state_28735;
(statearr_28752_30640[(5)] = ex__28161__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28735);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28751;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28159__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30641 = state_28735;
state_28735 = G__30641;
continue;
} else {
return ret_value__28159__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28158__auto__ = function(state_28735){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28158__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28158__auto____1.call(this,state_28735);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28158__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28158__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28158__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28158__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28158__auto__;
})()
;})(__30618,switch__28157__auto__,c__28356__auto___30623,G__28721_30620,G__28721_30621__$1,n__4613__auto___30616,jobs,results,process,async))
})();
var state__28358__auto__ = (function (){var statearr_28753 = f__28357__auto__();
(statearr_28753[(6)] = c__28356__auto___30623);

return statearr_28753;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28358__auto__);
});})(__30618,c__28356__auto___30623,G__28721_30620,G__28721_30621__$1,n__4613__auto___30616,jobs,results,process,async))
);


break;
case "async":
var c__28356__auto___30645 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__30618,c__28356__auto___30645,G__28721_30620,G__28721_30621__$1,n__4613__auto___30616,jobs,results,process,async){
return (function (){
var f__28357__auto__ = (function (){var switch__28157__auto__ = ((function (__30618,c__28356__auto___30645,G__28721_30620,G__28721_30621__$1,n__4613__auto___30616,jobs,results,process,async){
return (function (state_28769){
var state_val_28770 = (state_28769[(1)]);
if((state_val_28770 === (1))){
var state_28769__$1 = state_28769;
var statearr_28771_30651 = state_28769__$1;
(statearr_28771_30651[(2)] = null);

(statearr_28771_30651[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28770 === (2))){
var state_28769__$1 = state_28769;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28769__$1,(4),jobs);
} else {
if((state_val_28770 === (3))){
var inst_28767 = (state_28769[(2)]);
var state_28769__$1 = state_28769;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28769__$1,inst_28767);
} else {
if((state_val_28770 === (4))){
var inst_28759 = (state_28769[(2)]);
var inst_28760 = async(inst_28759);
var state_28769__$1 = state_28769;
if(cljs.core.truth_(inst_28760)){
var statearr_28773_30682 = state_28769__$1;
(statearr_28773_30682[(1)] = (5));

} else {
var statearr_28774_30685 = state_28769__$1;
(statearr_28774_30685[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28770 === (5))){
var state_28769__$1 = state_28769;
var statearr_28775_30698 = state_28769__$1;
(statearr_28775_30698[(2)] = null);

(statearr_28775_30698[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28770 === (6))){
var state_28769__$1 = state_28769;
var statearr_28776_30723 = state_28769__$1;
(statearr_28776_30723[(2)] = null);

(statearr_28776_30723[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28770 === (7))){
var inst_28765 = (state_28769[(2)]);
var state_28769__$1 = state_28769;
var statearr_28777_30727 = state_28769__$1;
(statearr_28777_30727[(2)] = inst_28765);

(statearr_28777_30727[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__30618,c__28356__auto___30645,G__28721_30620,G__28721_30621__$1,n__4613__auto___30616,jobs,results,process,async))
;
return ((function (__30618,switch__28157__auto__,c__28356__auto___30645,G__28721_30620,G__28721_30621__$1,n__4613__auto___30616,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28158__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28158__auto____0 = (function (){
var statearr_28778 = [null,null,null,null,null,null,null];
(statearr_28778[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28158__auto__);

(statearr_28778[(1)] = (1));

return statearr_28778;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28158__auto____1 = (function (state_28769){
while(true){
var ret_value__28159__auto__ = (function (){try{while(true){
var result__28160__auto__ = switch__28157__auto__(state_28769);
if(cljs.core.keyword_identical_QMARK_(result__28160__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28160__auto__;
}
break;
}
}catch (e28779){if((e28779 instanceof Object)){
var ex__28161__auto__ = e28779;
var statearr_28780_30733 = state_28769;
(statearr_28780_30733[(5)] = ex__28161__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28769);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28779;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28159__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30737 = state_28769;
state_28769 = G__30737;
continue;
} else {
return ret_value__28159__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28158__auto__ = function(state_28769){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28158__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28158__auto____1.call(this,state_28769);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28158__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28158__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28158__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28158__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28158__auto__;
})()
;})(__30618,switch__28157__auto__,c__28356__auto___30645,G__28721_30620,G__28721_30621__$1,n__4613__auto___30616,jobs,results,process,async))
})();
var state__28358__auto__ = (function (){var statearr_28784 = f__28357__auto__();
(statearr_28784[(6)] = c__28356__auto___30645);

return statearr_28784;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28358__auto__);
});})(__30618,c__28356__auto___30645,G__28721_30620,G__28721_30621__$1,n__4613__auto___30616,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__28721_30621__$1)].join('')));

}

var G__30743 = (__30618 + (1));
__30618 = G__30743;
continue;
} else {
}
break;
}

var c__28356__auto___30745 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28357__auto__ = (function (){var switch__28157__auto__ = (function (state_28806){
var state_val_28807 = (state_28806[(1)]);
if((state_val_28807 === (7))){
var inst_28802 = (state_28806[(2)]);
var state_28806__$1 = state_28806;
var statearr_28814_30748 = state_28806__$1;
(statearr_28814_30748[(2)] = inst_28802);

(statearr_28814_30748[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28807 === (1))){
var state_28806__$1 = state_28806;
var statearr_28815_30751 = state_28806__$1;
(statearr_28815_30751[(2)] = null);

(statearr_28815_30751[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28807 === (4))){
var inst_28787 = (state_28806[(7)]);
var inst_28787__$1 = (state_28806[(2)]);
var inst_28788 = (inst_28787__$1 == null);
var state_28806__$1 = (function (){var statearr_28818 = state_28806;
(statearr_28818[(7)] = inst_28787__$1);

return statearr_28818;
})();
if(cljs.core.truth_(inst_28788)){
var statearr_28819_30754 = state_28806__$1;
(statearr_28819_30754[(1)] = (5));

} else {
var statearr_28820_30756 = state_28806__$1;
(statearr_28820_30756[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28807 === (6))){
var inst_28787 = (state_28806[(7)]);
var inst_28792 = (state_28806[(8)]);
var inst_28792__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_28793 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28794 = [inst_28787,inst_28792__$1];
var inst_28795 = (new cljs.core.PersistentVector(null,2,(5),inst_28793,inst_28794,null));
var state_28806__$1 = (function (){var statearr_28825 = state_28806;
(statearr_28825[(8)] = inst_28792__$1);

return statearr_28825;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28806__$1,(8),jobs,inst_28795);
} else {
if((state_val_28807 === (3))){
var inst_28804 = (state_28806[(2)]);
var state_28806__$1 = state_28806;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28806__$1,inst_28804);
} else {
if((state_val_28807 === (2))){
var state_28806__$1 = state_28806;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28806__$1,(4),from);
} else {
if((state_val_28807 === (9))){
var inst_28799 = (state_28806[(2)]);
var state_28806__$1 = (function (){var statearr_28828 = state_28806;
(statearr_28828[(9)] = inst_28799);

return statearr_28828;
})();
var statearr_28829_30762 = state_28806__$1;
(statearr_28829_30762[(2)] = null);

(statearr_28829_30762[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28807 === (5))){
var inst_28790 = cljs.core.async.close_BANG_(jobs);
var state_28806__$1 = state_28806;
var statearr_28830_30766 = state_28806__$1;
(statearr_28830_30766[(2)] = inst_28790);

(statearr_28830_30766[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28807 === (8))){
var inst_28792 = (state_28806[(8)]);
var inst_28797 = (state_28806[(2)]);
var state_28806__$1 = (function (){var statearr_28833 = state_28806;
(statearr_28833[(10)] = inst_28797);

return statearr_28833;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28806__$1,(9),results,inst_28792);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28158__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28158__auto____0 = (function (){
var statearr_28834 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_28834[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28158__auto__);

(statearr_28834[(1)] = (1));

return statearr_28834;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28158__auto____1 = (function (state_28806){
while(true){
var ret_value__28159__auto__ = (function (){try{while(true){
var result__28160__auto__ = switch__28157__auto__(state_28806);
if(cljs.core.keyword_identical_QMARK_(result__28160__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28160__auto__;
}
break;
}
}catch (e28835){if((e28835 instanceof Object)){
var ex__28161__auto__ = e28835;
var statearr_28836_30780 = state_28806;
(statearr_28836_30780[(5)] = ex__28161__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28806);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28835;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28159__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30782 = state_28806;
state_28806 = G__30782;
continue;
} else {
return ret_value__28159__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28158__auto__ = function(state_28806){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28158__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28158__auto____1.call(this,state_28806);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28158__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28158__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28158__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28158__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28158__auto__;
})()
})();
var state__28358__auto__ = (function (){var statearr_28838 = f__28357__auto__();
(statearr_28838[(6)] = c__28356__auto___30745);

return statearr_28838;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28358__auto__);
}));


var c__28356__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28357__auto__ = (function (){var switch__28157__auto__ = (function (state_28877){
var state_val_28878 = (state_28877[(1)]);
if((state_val_28878 === (7))){
var inst_28873 = (state_28877[(2)]);
var state_28877__$1 = state_28877;
var statearr_28881_30788 = state_28877__$1;
(statearr_28881_30788[(2)] = inst_28873);

(statearr_28881_30788[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28878 === (20))){
var state_28877__$1 = state_28877;
var statearr_28882_30794 = state_28877__$1;
(statearr_28882_30794[(2)] = null);

(statearr_28882_30794[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28878 === (1))){
var state_28877__$1 = state_28877;
var statearr_28884_30796 = state_28877__$1;
(statearr_28884_30796[(2)] = null);

(statearr_28884_30796[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28878 === (4))){
var inst_28841 = (state_28877[(7)]);
var inst_28841__$1 = (state_28877[(2)]);
var inst_28842 = (inst_28841__$1 == null);
var state_28877__$1 = (function (){var statearr_28885 = state_28877;
(statearr_28885[(7)] = inst_28841__$1);

return statearr_28885;
})();
if(cljs.core.truth_(inst_28842)){
var statearr_28886_30799 = state_28877__$1;
(statearr_28886_30799[(1)] = (5));

} else {
var statearr_28887_30802 = state_28877__$1;
(statearr_28887_30802[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28878 === (15))){
var inst_28854 = (state_28877[(8)]);
var state_28877__$1 = state_28877;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28877__$1,(18),to,inst_28854);
} else {
if((state_val_28878 === (21))){
var inst_28868 = (state_28877[(2)]);
var state_28877__$1 = state_28877;
var statearr_28892_30805 = state_28877__$1;
(statearr_28892_30805[(2)] = inst_28868);

(statearr_28892_30805[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28878 === (13))){
var inst_28870 = (state_28877[(2)]);
var state_28877__$1 = (function (){var statearr_28893 = state_28877;
(statearr_28893[(9)] = inst_28870);

return statearr_28893;
})();
var statearr_28894_30811 = state_28877__$1;
(statearr_28894_30811[(2)] = null);

(statearr_28894_30811[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28878 === (6))){
var inst_28841 = (state_28877[(7)]);
var state_28877__$1 = state_28877;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28877__$1,(11),inst_28841);
} else {
if((state_val_28878 === (17))){
var inst_28863 = (state_28877[(2)]);
var state_28877__$1 = state_28877;
if(cljs.core.truth_(inst_28863)){
var statearr_28895_30814 = state_28877__$1;
(statearr_28895_30814[(1)] = (19));

} else {
var statearr_28897_30815 = state_28877__$1;
(statearr_28897_30815[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28878 === (3))){
var inst_28875 = (state_28877[(2)]);
var state_28877__$1 = state_28877;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28877__$1,inst_28875);
} else {
if((state_val_28878 === (12))){
var inst_28851 = (state_28877[(10)]);
var state_28877__$1 = state_28877;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28877__$1,(14),inst_28851);
} else {
if((state_val_28878 === (2))){
var state_28877__$1 = state_28877;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28877__$1,(4),results);
} else {
if((state_val_28878 === (19))){
var state_28877__$1 = state_28877;
var statearr_28898_30819 = state_28877__$1;
(statearr_28898_30819[(2)] = null);

(statearr_28898_30819[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28878 === (11))){
var inst_28851 = (state_28877[(2)]);
var state_28877__$1 = (function (){var statearr_28899 = state_28877;
(statearr_28899[(10)] = inst_28851);

return statearr_28899;
})();
var statearr_28900_30823 = state_28877__$1;
(statearr_28900_30823[(2)] = null);

(statearr_28900_30823[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28878 === (9))){
var state_28877__$1 = state_28877;
var statearr_28901_30828 = state_28877__$1;
(statearr_28901_30828[(2)] = null);

(statearr_28901_30828[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28878 === (5))){
var state_28877__$1 = state_28877;
if(cljs.core.truth_(close_QMARK_)){
var statearr_28902_30829 = state_28877__$1;
(statearr_28902_30829[(1)] = (8));

} else {
var statearr_28903_30830 = state_28877__$1;
(statearr_28903_30830[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28878 === (14))){
var inst_28854 = (state_28877[(8)]);
var inst_28854__$1 = (state_28877[(2)]);
var inst_28855 = (inst_28854__$1 == null);
var inst_28856 = cljs.core.not(inst_28855);
var state_28877__$1 = (function (){var statearr_28907 = state_28877;
(statearr_28907[(8)] = inst_28854__$1);

return statearr_28907;
})();
if(inst_28856){
var statearr_28911_30831 = state_28877__$1;
(statearr_28911_30831[(1)] = (15));

} else {
var statearr_28912_30833 = state_28877__$1;
(statearr_28912_30833[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28878 === (16))){
var state_28877__$1 = state_28877;
var statearr_28913_30835 = state_28877__$1;
(statearr_28913_30835[(2)] = false);

(statearr_28913_30835[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28878 === (10))){
var inst_28848 = (state_28877[(2)]);
var state_28877__$1 = state_28877;
var statearr_28914_30836 = state_28877__$1;
(statearr_28914_30836[(2)] = inst_28848);

(statearr_28914_30836[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28878 === (18))){
var inst_28860 = (state_28877[(2)]);
var state_28877__$1 = state_28877;
var statearr_28915_30837 = state_28877__$1;
(statearr_28915_30837[(2)] = inst_28860);

(statearr_28915_30837[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28878 === (8))){
var inst_28845 = cljs.core.async.close_BANG_(to);
var state_28877__$1 = state_28877;
var statearr_28917_30841 = state_28877__$1;
(statearr_28917_30841[(2)] = inst_28845);

(statearr_28917_30841[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28158__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28158__auto____0 = (function (){
var statearr_28918 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_28918[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28158__auto__);

(statearr_28918[(1)] = (1));

return statearr_28918;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28158__auto____1 = (function (state_28877){
while(true){
var ret_value__28159__auto__ = (function (){try{while(true){
var result__28160__auto__ = switch__28157__auto__(state_28877);
if(cljs.core.keyword_identical_QMARK_(result__28160__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28160__auto__;
}
break;
}
}catch (e28919){if((e28919 instanceof Object)){
var ex__28161__auto__ = e28919;
var statearr_28920_30846 = state_28877;
(statearr_28920_30846[(5)] = ex__28161__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28877);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28919;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28159__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30851 = state_28877;
state_28877 = G__30851;
continue;
} else {
return ret_value__28159__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28158__auto__ = function(state_28877){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28158__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28158__auto____1.call(this,state_28877);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28158__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28158__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28158__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28158__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28158__auto__;
})()
})();
var state__28358__auto__ = (function (){var statearr_28923 = f__28357__auto__();
(statearr_28923[(6)] = c__28356__auto__);

return statearr_28923;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28358__auto__);
}));

return c__28356__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__28929 = arguments.length;
switch (G__28929) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__28933 = arguments.length;
switch (G__28933) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__28940 = arguments.length;
switch (G__28940) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__28356__auto___30893 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28357__auto__ = (function (){var switch__28157__auto__ = (function (state_28969){
var state_val_28970 = (state_28969[(1)]);
if((state_val_28970 === (7))){
var inst_28965 = (state_28969[(2)]);
var state_28969__$1 = state_28969;
var statearr_28974_30896 = state_28969__$1;
(statearr_28974_30896[(2)] = inst_28965);

(statearr_28974_30896[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28970 === (1))){
var state_28969__$1 = state_28969;
var statearr_28975_30899 = state_28969__$1;
(statearr_28975_30899[(2)] = null);

(statearr_28975_30899[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28970 === (4))){
var inst_28946 = (state_28969[(7)]);
var inst_28946__$1 = (state_28969[(2)]);
var inst_28947 = (inst_28946__$1 == null);
var state_28969__$1 = (function (){var statearr_28985 = state_28969;
(statearr_28985[(7)] = inst_28946__$1);

return statearr_28985;
})();
if(cljs.core.truth_(inst_28947)){
var statearr_28986_30904 = state_28969__$1;
(statearr_28986_30904[(1)] = (5));

} else {
var statearr_28987_30907 = state_28969__$1;
(statearr_28987_30907[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28970 === (13))){
var state_28969__$1 = state_28969;
var statearr_28988_30910 = state_28969__$1;
(statearr_28988_30910[(2)] = null);

(statearr_28988_30910[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28970 === (6))){
var inst_28946 = (state_28969[(7)]);
var inst_28952 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_28946) : p.call(null,inst_28946));
var state_28969__$1 = state_28969;
if(cljs.core.truth_(inst_28952)){
var statearr_28989_30912 = state_28969__$1;
(statearr_28989_30912[(1)] = (9));

} else {
var statearr_28990_30914 = state_28969__$1;
(statearr_28990_30914[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28970 === (3))){
var inst_28967 = (state_28969[(2)]);
var state_28969__$1 = state_28969;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28969__$1,inst_28967);
} else {
if((state_val_28970 === (12))){
var state_28969__$1 = state_28969;
var statearr_28992_30918 = state_28969__$1;
(statearr_28992_30918[(2)] = null);

(statearr_28992_30918[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28970 === (2))){
var state_28969__$1 = state_28969;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28969__$1,(4),ch);
} else {
if((state_val_28970 === (11))){
var inst_28946 = (state_28969[(7)]);
var inst_28956 = (state_28969[(2)]);
var state_28969__$1 = state_28969;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28969__$1,(8),inst_28956,inst_28946);
} else {
if((state_val_28970 === (9))){
var state_28969__$1 = state_28969;
var statearr_29003_30925 = state_28969__$1;
(statearr_29003_30925[(2)] = tc);

(statearr_29003_30925[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28970 === (5))){
var inst_28949 = cljs.core.async.close_BANG_(tc);
var inst_28950 = cljs.core.async.close_BANG_(fc);
var state_28969__$1 = (function (){var statearr_29004 = state_28969;
(statearr_29004[(8)] = inst_28949);

return statearr_29004;
})();
var statearr_29005_30927 = state_28969__$1;
(statearr_29005_30927[(2)] = inst_28950);

(statearr_29005_30927[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28970 === (14))){
var inst_28963 = (state_28969[(2)]);
var state_28969__$1 = state_28969;
var statearr_29006_30930 = state_28969__$1;
(statearr_29006_30930[(2)] = inst_28963);

(statearr_29006_30930[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28970 === (10))){
var state_28969__$1 = state_28969;
var statearr_29007_30932 = state_28969__$1;
(statearr_29007_30932[(2)] = fc);

(statearr_29007_30932[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28970 === (8))){
var inst_28958 = (state_28969[(2)]);
var state_28969__$1 = state_28969;
if(cljs.core.truth_(inst_28958)){
var statearr_29008_30933 = state_28969__$1;
(statearr_29008_30933[(1)] = (12));

} else {
var statearr_29009_30935 = state_28969__$1;
(statearr_29009_30935[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28158__auto__ = null;
var cljs$core$async$state_machine__28158__auto____0 = (function (){
var statearr_29011 = [null,null,null,null,null,null,null,null,null];
(statearr_29011[(0)] = cljs$core$async$state_machine__28158__auto__);

(statearr_29011[(1)] = (1));

return statearr_29011;
});
var cljs$core$async$state_machine__28158__auto____1 = (function (state_28969){
while(true){
var ret_value__28159__auto__ = (function (){try{while(true){
var result__28160__auto__ = switch__28157__auto__(state_28969);
if(cljs.core.keyword_identical_QMARK_(result__28160__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28160__auto__;
}
break;
}
}catch (e29012){if((e29012 instanceof Object)){
var ex__28161__auto__ = e29012;
var statearr_29013_30937 = state_28969;
(statearr_29013_30937[(5)] = ex__28161__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28969);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29012;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28159__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30940 = state_28969;
state_28969 = G__30940;
continue;
} else {
return ret_value__28159__auto__;
}
break;
}
});
cljs$core$async$state_machine__28158__auto__ = function(state_28969){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28158__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28158__auto____1.call(this,state_28969);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28158__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28158__auto____0;
cljs$core$async$state_machine__28158__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28158__auto____1;
return cljs$core$async$state_machine__28158__auto__;
})()
})();
var state__28358__auto__ = (function (){var statearr_29017 = f__28357__auto__();
(statearr_29017[(6)] = c__28356__auto___30893);

return statearr_29017;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28358__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__28356__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28357__auto__ = (function (){var switch__28157__auto__ = (function (state_29041){
var state_val_29042 = (state_29041[(1)]);
if((state_val_29042 === (7))){
var inst_29037 = (state_29041[(2)]);
var state_29041__$1 = state_29041;
var statearr_29046_30948 = state_29041__$1;
(statearr_29046_30948[(2)] = inst_29037);

(statearr_29046_30948[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (1))){
var inst_29018 = init;
var state_29041__$1 = (function (){var statearr_29047 = state_29041;
(statearr_29047[(7)] = inst_29018);

return statearr_29047;
})();
var statearr_29051_30951 = state_29041__$1;
(statearr_29051_30951[(2)] = null);

(statearr_29051_30951[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (4))){
var inst_29021 = (state_29041[(8)]);
var inst_29021__$1 = (state_29041[(2)]);
var inst_29022 = (inst_29021__$1 == null);
var state_29041__$1 = (function (){var statearr_29052 = state_29041;
(statearr_29052[(8)] = inst_29021__$1);

return statearr_29052;
})();
if(cljs.core.truth_(inst_29022)){
var statearr_29053_30963 = state_29041__$1;
(statearr_29053_30963[(1)] = (5));

} else {
var statearr_29055_30964 = state_29041__$1;
(statearr_29055_30964[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (6))){
var inst_29018 = (state_29041[(7)]);
var inst_29021 = (state_29041[(8)]);
var inst_29025 = (state_29041[(9)]);
var inst_29025__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_29018,inst_29021) : f.call(null,inst_29018,inst_29021));
var inst_29026 = cljs.core.reduced_QMARK_(inst_29025__$1);
var state_29041__$1 = (function (){var statearr_29059 = state_29041;
(statearr_29059[(9)] = inst_29025__$1);

return statearr_29059;
})();
if(inst_29026){
var statearr_29060_30981 = state_29041__$1;
(statearr_29060_30981[(1)] = (8));

} else {
var statearr_29061_30982 = state_29041__$1;
(statearr_29061_30982[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (3))){
var inst_29039 = (state_29041[(2)]);
var state_29041__$1 = state_29041;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29041__$1,inst_29039);
} else {
if((state_val_29042 === (2))){
var state_29041__$1 = state_29041;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29041__$1,(4),ch);
} else {
if((state_val_29042 === (9))){
var inst_29025 = (state_29041[(9)]);
var inst_29018 = inst_29025;
var state_29041__$1 = (function (){var statearr_29065 = state_29041;
(statearr_29065[(7)] = inst_29018);

return statearr_29065;
})();
var statearr_29066_31001 = state_29041__$1;
(statearr_29066_31001[(2)] = null);

(statearr_29066_31001[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (5))){
var inst_29018 = (state_29041[(7)]);
var state_29041__$1 = state_29041;
var statearr_29069_31007 = state_29041__$1;
(statearr_29069_31007[(2)] = inst_29018);

(statearr_29069_31007[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (10))){
var inst_29035 = (state_29041[(2)]);
var state_29041__$1 = state_29041;
var statearr_29070_31015 = state_29041__$1;
(statearr_29070_31015[(2)] = inst_29035);

(statearr_29070_31015[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29042 === (8))){
var inst_29025 = (state_29041[(9)]);
var inst_29031 = cljs.core.deref(inst_29025);
var state_29041__$1 = state_29041;
var statearr_29071_31025 = state_29041__$1;
(statearr_29071_31025[(2)] = inst_29031);

(statearr_29071_31025[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__28158__auto__ = null;
var cljs$core$async$reduce_$_state_machine__28158__auto____0 = (function (){
var statearr_29072 = [null,null,null,null,null,null,null,null,null,null];
(statearr_29072[(0)] = cljs$core$async$reduce_$_state_machine__28158__auto__);

(statearr_29072[(1)] = (1));

return statearr_29072;
});
var cljs$core$async$reduce_$_state_machine__28158__auto____1 = (function (state_29041){
while(true){
var ret_value__28159__auto__ = (function (){try{while(true){
var result__28160__auto__ = switch__28157__auto__(state_29041);
if(cljs.core.keyword_identical_QMARK_(result__28160__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28160__auto__;
}
break;
}
}catch (e29077){if((e29077 instanceof Object)){
var ex__28161__auto__ = e29077;
var statearr_29078_31030 = state_29041;
(statearr_29078_31030[(5)] = ex__28161__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29041);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29077;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28159__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31032 = state_29041;
state_29041 = G__31032;
continue;
} else {
return ret_value__28159__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__28158__auto__ = function(state_29041){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__28158__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__28158__auto____1.call(this,state_29041);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__28158__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__28158__auto____0;
cljs$core$async$reduce_$_state_machine__28158__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__28158__auto____1;
return cljs$core$async$reduce_$_state_machine__28158__auto__;
})()
})();
var state__28358__auto__ = (function (){var statearr_29079 = f__28357__auto__();
(statearr_29079[(6)] = c__28356__auto__);

return statearr_29079;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28358__auto__);
}));

return c__28356__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__28356__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28357__auto__ = (function (){var switch__28157__auto__ = (function (state_29089){
var state_val_29090 = (state_29089[(1)]);
if((state_val_29090 === (1))){
var inst_29084 = cljs.core.async.reduce(f__$1,init,ch);
var state_29089__$1 = state_29089;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29089__$1,(2),inst_29084);
} else {
if((state_val_29090 === (2))){
var inst_29086 = (state_29089[(2)]);
var inst_29087 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_29086) : f__$1.call(null,inst_29086));
var state_29089__$1 = state_29089;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29089__$1,inst_29087);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__28158__auto__ = null;
var cljs$core$async$transduce_$_state_machine__28158__auto____0 = (function (){
var statearr_29092 = [null,null,null,null,null,null,null];
(statearr_29092[(0)] = cljs$core$async$transduce_$_state_machine__28158__auto__);

(statearr_29092[(1)] = (1));

return statearr_29092;
});
var cljs$core$async$transduce_$_state_machine__28158__auto____1 = (function (state_29089){
while(true){
var ret_value__28159__auto__ = (function (){try{while(true){
var result__28160__auto__ = switch__28157__auto__(state_29089);
if(cljs.core.keyword_identical_QMARK_(result__28160__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28160__auto__;
}
break;
}
}catch (e29095){if((e29095 instanceof Object)){
var ex__28161__auto__ = e29095;
var statearr_29097_31044 = state_29089;
(statearr_29097_31044[(5)] = ex__28161__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29089);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29095;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28159__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31045 = state_29089;
state_29089 = G__31045;
continue;
} else {
return ret_value__28159__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__28158__auto__ = function(state_29089){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__28158__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__28158__auto____1.call(this,state_29089);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__28158__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__28158__auto____0;
cljs$core$async$transduce_$_state_machine__28158__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__28158__auto____1;
return cljs$core$async$transduce_$_state_machine__28158__auto__;
})()
})();
var state__28358__auto__ = (function (){var statearr_29098 = f__28357__auto__();
(statearr_29098[(6)] = c__28356__auto__);

return statearr_29098;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28358__auto__);
}));

return c__28356__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__29107 = arguments.length;
switch (G__29107) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__28356__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28357__auto__ = (function (){var switch__28157__auto__ = (function (state_29137){
var state_val_29138 = (state_29137[(1)]);
if((state_val_29138 === (7))){
var inst_29117 = (state_29137[(2)]);
var state_29137__$1 = state_29137;
var statearr_29139_31058 = state_29137__$1;
(statearr_29139_31058[(2)] = inst_29117);

(statearr_29139_31058[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29138 === (1))){
var inst_29111 = cljs.core.seq(coll);
var inst_29112 = inst_29111;
var state_29137__$1 = (function (){var statearr_29140 = state_29137;
(statearr_29140[(7)] = inst_29112);

return statearr_29140;
})();
var statearr_29141_31063 = state_29137__$1;
(statearr_29141_31063[(2)] = null);

(statearr_29141_31063[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29138 === (4))){
var inst_29112 = (state_29137[(7)]);
var inst_29115 = cljs.core.first(inst_29112);
var state_29137__$1 = state_29137;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29137__$1,(7),ch,inst_29115);
} else {
if((state_val_29138 === (13))){
var inst_29129 = (state_29137[(2)]);
var state_29137__$1 = state_29137;
var statearr_29142_31066 = state_29137__$1;
(statearr_29142_31066[(2)] = inst_29129);

(statearr_29142_31066[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29138 === (6))){
var inst_29120 = (state_29137[(2)]);
var state_29137__$1 = state_29137;
if(cljs.core.truth_(inst_29120)){
var statearr_29143_31067 = state_29137__$1;
(statearr_29143_31067[(1)] = (8));

} else {
var statearr_29144_31068 = state_29137__$1;
(statearr_29144_31068[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29138 === (3))){
var inst_29134 = (state_29137[(2)]);
var state_29137__$1 = state_29137;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29137__$1,inst_29134);
} else {
if((state_val_29138 === (12))){
var state_29137__$1 = state_29137;
var statearr_29145_31073 = state_29137__$1;
(statearr_29145_31073[(2)] = null);

(statearr_29145_31073[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29138 === (2))){
var inst_29112 = (state_29137[(7)]);
var state_29137__$1 = state_29137;
if(cljs.core.truth_(inst_29112)){
var statearr_29146_31074 = state_29137__$1;
(statearr_29146_31074[(1)] = (4));

} else {
var statearr_29147_31075 = state_29137__$1;
(statearr_29147_31075[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29138 === (11))){
var inst_29126 = cljs.core.async.close_BANG_(ch);
var state_29137__$1 = state_29137;
var statearr_29148_31076 = state_29137__$1;
(statearr_29148_31076[(2)] = inst_29126);

(statearr_29148_31076[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29138 === (9))){
var state_29137__$1 = state_29137;
if(cljs.core.truth_(close_QMARK_)){
var statearr_29149_31077 = state_29137__$1;
(statearr_29149_31077[(1)] = (11));

} else {
var statearr_29150_31078 = state_29137__$1;
(statearr_29150_31078[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29138 === (5))){
var inst_29112 = (state_29137[(7)]);
var state_29137__$1 = state_29137;
var statearr_29153_31079 = state_29137__$1;
(statearr_29153_31079[(2)] = inst_29112);

(statearr_29153_31079[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29138 === (10))){
var inst_29132 = (state_29137[(2)]);
var state_29137__$1 = state_29137;
var statearr_29154_31080 = state_29137__$1;
(statearr_29154_31080[(2)] = inst_29132);

(statearr_29154_31080[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29138 === (8))){
var inst_29112 = (state_29137[(7)]);
var inst_29122 = cljs.core.next(inst_29112);
var inst_29112__$1 = inst_29122;
var state_29137__$1 = (function (){var statearr_29155 = state_29137;
(statearr_29155[(7)] = inst_29112__$1);

return statearr_29155;
})();
var statearr_29156_31081 = state_29137__$1;
(statearr_29156_31081[(2)] = null);

(statearr_29156_31081[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28158__auto__ = null;
var cljs$core$async$state_machine__28158__auto____0 = (function (){
var statearr_29157 = [null,null,null,null,null,null,null,null];
(statearr_29157[(0)] = cljs$core$async$state_machine__28158__auto__);

(statearr_29157[(1)] = (1));

return statearr_29157;
});
var cljs$core$async$state_machine__28158__auto____1 = (function (state_29137){
while(true){
var ret_value__28159__auto__ = (function (){try{while(true){
var result__28160__auto__ = switch__28157__auto__(state_29137);
if(cljs.core.keyword_identical_QMARK_(result__28160__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28160__auto__;
}
break;
}
}catch (e29158){if((e29158 instanceof Object)){
var ex__28161__auto__ = e29158;
var statearr_29159_31082 = state_29137;
(statearr_29159_31082[(5)] = ex__28161__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29137);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29158;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28159__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31083 = state_29137;
state_29137 = G__31083;
continue;
} else {
return ret_value__28159__auto__;
}
break;
}
});
cljs$core$async$state_machine__28158__auto__ = function(state_29137){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28158__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28158__auto____1.call(this,state_29137);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28158__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28158__auto____0;
cljs$core$async$state_machine__28158__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28158__auto____1;
return cljs$core$async$state_machine__28158__auto__;
})()
})();
var state__28358__auto__ = (function (){var statearr_29160 = f__28357__auto__();
(statearr_29160[(6)] = c__28356__auto__);

return statearr_29160;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28358__auto__);
}));

return c__28356__auto__;
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_31084 = (function (_){
var x__4428__auto__ = (((_ == null))?null:_);
var m__4429__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4429__auto__.call(null,_));
} else {
var m__4426__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4426__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_31084(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_31085 = (function (m,ch,close_QMARK_){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4429__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4426__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_31085(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_31086 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_31086(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_31090 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_31090(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async29183 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29183 = (function (ch,cs,meta29184){
this.ch = ch;
this.cs = cs;
this.meta29184 = meta29184;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async29183.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29185,meta29184__$1){
var self__ = this;
var _29185__$1 = this;
return (new cljs.core.async.t_cljs$core$async29183(self__.ch,self__.cs,meta29184__$1));
}));

(cljs.core.async.t_cljs$core$async29183.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29185){
var self__ = this;
var _29185__$1 = this;
return self__.meta29184;
}));

(cljs.core.async.t_cljs$core$async29183.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29183.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async29183.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29183.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async29183.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async29183.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async29183.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta29184","meta29184",1205971066,null)], null);
}));

(cljs.core.async.t_cljs$core$async29183.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async29183.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29183");

(cljs.core.async.t_cljs$core$async29183.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async29183");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async29183.
 */
cljs.core.async.__GT_t_cljs$core$async29183 = (function cljs$core$async$mult_$___GT_t_cljs$core$async29183(ch__$1,cs__$1,meta29184){
return (new cljs.core.async.t_cljs$core$async29183(ch__$1,cs__$1,meta29184));
});

}

return (new cljs.core.async.t_cljs$core$async29183(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__28356__auto___31119 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28357__auto__ = (function (){var switch__28157__auto__ = (function (state_29324){
var state_val_29327 = (state_29324[(1)]);
if((state_val_29327 === (7))){
var inst_29318 = (state_29324[(2)]);
var state_29324__$1 = state_29324;
var statearr_29328_31122 = state_29324__$1;
(statearr_29328_31122[(2)] = inst_29318);

(statearr_29328_31122[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29327 === (20))){
var inst_29220 = (state_29324[(7)]);
var inst_29232 = cljs.core.first(inst_29220);
var inst_29233 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29232,(0),null);
var inst_29234 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29232,(1),null);
var state_29324__$1 = (function (){var statearr_29331 = state_29324;
(statearr_29331[(8)] = inst_29233);

return statearr_29331;
})();
if(cljs.core.truth_(inst_29234)){
var statearr_29332_31123 = state_29324__$1;
(statearr_29332_31123[(1)] = (22));

} else {
var statearr_29334_31124 = state_29324__$1;
(statearr_29334_31124[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29327 === (27))){
var inst_29262 = (state_29324[(9)]);
var inst_29189 = (state_29324[(10)]);
var inst_29264 = (state_29324[(11)]);
var inst_29269 = (state_29324[(12)]);
var inst_29269__$1 = cljs.core._nth(inst_29262,inst_29264);
var inst_29270 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_29269__$1,inst_29189,done);
var state_29324__$1 = (function (){var statearr_29335 = state_29324;
(statearr_29335[(12)] = inst_29269__$1);

return statearr_29335;
})();
if(cljs.core.truth_(inst_29270)){
var statearr_29336_31128 = state_29324__$1;
(statearr_29336_31128[(1)] = (30));

} else {
var statearr_29337_31129 = state_29324__$1;
(statearr_29337_31129[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29327 === (1))){
var state_29324__$1 = state_29324;
var statearr_29338_31131 = state_29324__$1;
(statearr_29338_31131[(2)] = null);

(statearr_29338_31131[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29327 === (24))){
var inst_29220 = (state_29324[(7)]);
var inst_29239 = (state_29324[(2)]);
var inst_29240 = cljs.core.next(inst_29220);
var inst_29198 = inst_29240;
var inst_29199 = null;
var inst_29200 = (0);
var inst_29201 = (0);
var state_29324__$1 = (function (){var statearr_29339 = state_29324;
(statearr_29339[(13)] = inst_29201);

(statearr_29339[(14)] = inst_29239);

(statearr_29339[(15)] = inst_29200);

(statearr_29339[(16)] = inst_29199);

(statearr_29339[(17)] = inst_29198);

return statearr_29339;
})();
var statearr_29340_31134 = state_29324__$1;
(statearr_29340_31134[(2)] = null);

(statearr_29340_31134[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29327 === (39))){
var state_29324__$1 = state_29324;
var statearr_29344_31137 = state_29324__$1;
(statearr_29344_31137[(2)] = null);

(statearr_29344_31137[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29327 === (4))){
var inst_29189 = (state_29324[(10)]);
var inst_29189__$1 = (state_29324[(2)]);
var inst_29190 = (inst_29189__$1 == null);
var state_29324__$1 = (function (){var statearr_29347 = state_29324;
(statearr_29347[(10)] = inst_29189__$1);

return statearr_29347;
})();
if(cljs.core.truth_(inst_29190)){
var statearr_29348_31139 = state_29324__$1;
(statearr_29348_31139[(1)] = (5));

} else {
var statearr_29349_31140 = state_29324__$1;
(statearr_29349_31140[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29327 === (15))){
var inst_29201 = (state_29324[(13)]);
var inst_29200 = (state_29324[(15)]);
var inst_29199 = (state_29324[(16)]);
var inst_29198 = (state_29324[(17)]);
var inst_29216 = (state_29324[(2)]);
var inst_29217 = (inst_29201 + (1));
var tmp29341 = inst_29200;
var tmp29342 = inst_29199;
var tmp29343 = inst_29198;
var inst_29198__$1 = tmp29343;
var inst_29199__$1 = tmp29342;
var inst_29200__$1 = tmp29341;
var inst_29201__$1 = inst_29217;
var state_29324__$1 = (function (){var statearr_29350 = state_29324;
(statearr_29350[(13)] = inst_29201__$1);

(statearr_29350[(15)] = inst_29200__$1);

(statearr_29350[(16)] = inst_29199__$1);

(statearr_29350[(18)] = inst_29216);

(statearr_29350[(17)] = inst_29198__$1);

return statearr_29350;
})();
var statearr_29351_31160 = state_29324__$1;
(statearr_29351_31160[(2)] = null);

(statearr_29351_31160[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29327 === (21))){
var inst_29243 = (state_29324[(2)]);
var state_29324__$1 = state_29324;
var statearr_29355_31162 = state_29324__$1;
(statearr_29355_31162[(2)] = inst_29243);

(statearr_29355_31162[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29327 === (31))){
var inst_29269 = (state_29324[(12)]);
var inst_29273 = done(null);
var inst_29274 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_29269);
var state_29324__$1 = (function (){var statearr_29356 = state_29324;
(statearr_29356[(19)] = inst_29273);

return statearr_29356;
})();
var statearr_29357_31163 = state_29324__$1;
(statearr_29357_31163[(2)] = inst_29274);

(statearr_29357_31163[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29327 === (32))){
var inst_29262 = (state_29324[(9)]);
var inst_29263 = (state_29324[(20)]);
var inst_29264 = (state_29324[(11)]);
var inst_29261 = (state_29324[(21)]);
var inst_29276 = (state_29324[(2)]);
var inst_29277 = (inst_29264 + (1));
var tmp29352 = inst_29262;
var tmp29353 = inst_29263;
var tmp29354 = inst_29261;
var inst_29261__$1 = tmp29354;
var inst_29262__$1 = tmp29352;
var inst_29263__$1 = tmp29353;
var inst_29264__$1 = inst_29277;
var state_29324__$1 = (function (){var statearr_29358 = state_29324;
(statearr_29358[(9)] = inst_29262__$1);

(statearr_29358[(20)] = inst_29263__$1);

(statearr_29358[(11)] = inst_29264__$1);

(statearr_29358[(22)] = inst_29276);

(statearr_29358[(21)] = inst_29261__$1);

return statearr_29358;
})();
var statearr_29362_31167 = state_29324__$1;
(statearr_29362_31167[(2)] = null);

(statearr_29362_31167[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29327 === (40))){
var inst_29289 = (state_29324[(23)]);
var inst_29293 = done(null);
var inst_29294 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_29289);
var state_29324__$1 = (function (){var statearr_29366 = state_29324;
(statearr_29366[(24)] = inst_29293);

return statearr_29366;
})();
var statearr_29367_31170 = state_29324__$1;
(statearr_29367_31170[(2)] = inst_29294);

(statearr_29367_31170[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29327 === (33))){
var inst_29280 = (state_29324[(25)]);
var inst_29282 = cljs.core.chunked_seq_QMARK_(inst_29280);
var state_29324__$1 = state_29324;
if(inst_29282){
var statearr_29369_31176 = state_29324__$1;
(statearr_29369_31176[(1)] = (36));

} else {
var statearr_29370_31180 = state_29324__$1;
(statearr_29370_31180[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29327 === (13))){
var inst_29210 = (state_29324[(26)]);
var inst_29213 = cljs.core.async.close_BANG_(inst_29210);
var state_29324__$1 = state_29324;
var statearr_29372_31183 = state_29324__$1;
(statearr_29372_31183[(2)] = inst_29213);

(statearr_29372_31183[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29327 === (22))){
var inst_29233 = (state_29324[(8)]);
var inst_29236 = cljs.core.async.close_BANG_(inst_29233);
var state_29324__$1 = state_29324;
var statearr_29376_31191 = state_29324__$1;
(statearr_29376_31191[(2)] = inst_29236);

(statearr_29376_31191[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29327 === (36))){
var inst_29280 = (state_29324[(25)]);
var inst_29284 = cljs.core.chunk_first(inst_29280);
var inst_29285 = cljs.core.chunk_rest(inst_29280);
var inst_29286 = cljs.core.count(inst_29284);
var inst_29261 = inst_29285;
var inst_29262 = inst_29284;
var inst_29263 = inst_29286;
var inst_29264 = (0);
var state_29324__$1 = (function (){var statearr_29379 = state_29324;
(statearr_29379[(9)] = inst_29262);

(statearr_29379[(20)] = inst_29263);

(statearr_29379[(11)] = inst_29264);

(statearr_29379[(21)] = inst_29261);

return statearr_29379;
})();
var statearr_29380_31218 = state_29324__$1;
(statearr_29380_31218[(2)] = null);

(statearr_29380_31218[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29327 === (41))){
var inst_29280 = (state_29324[(25)]);
var inst_29296 = (state_29324[(2)]);
var inst_29297 = cljs.core.next(inst_29280);
var inst_29261 = inst_29297;
var inst_29262 = null;
var inst_29263 = (0);
var inst_29264 = (0);
var state_29324__$1 = (function (){var statearr_29384 = state_29324;
(statearr_29384[(9)] = inst_29262);

(statearr_29384[(20)] = inst_29263);

(statearr_29384[(27)] = inst_29296);

(statearr_29384[(11)] = inst_29264);

(statearr_29384[(21)] = inst_29261);

return statearr_29384;
})();
var statearr_29385_31225 = state_29324__$1;
(statearr_29385_31225[(2)] = null);

(statearr_29385_31225[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29327 === (43))){
var state_29324__$1 = state_29324;
var statearr_29386_31226 = state_29324__$1;
(statearr_29386_31226[(2)] = null);

(statearr_29386_31226[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29327 === (29))){
var inst_29305 = (state_29324[(2)]);
var state_29324__$1 = state_29324;
var statearr_29390_31227 = state_29324__$1;
(statearr_29390_31227[(2)] = inst_29305);

(statearr_29390_31227[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29327 === (44))){
var inst_29314 = (state_29324[(2)]);
var state_29324__$1 = (function (){var statearr_29391 = state_29324;
(statearr_29391[(28)] = inst_29314);

return statearr_29391;
})();
var statearr_29394_31229 = state_29324__$1;
(statearr_29394_31229[(2)] = null);

(statearr_29394_31229[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29327 === (6))){
var inst_29253 = (state_29324[(29)]);
var inst_29252 = cljs.core.deref(cs);
var inst_29253__$1 = cljs.core.keys(inst_29252);
var inst_29254 = cljs.core.count(inst_29253__$1);
var inst_29255 = cljs.core.reset_BANG_(dctr,inst_29254);
var inst_29260 = cljs.core.seq(inst_29253__$1);
var inst_29261 = inst_29260;
var inst_29262 = null;
var inst_29263 = (0);
var inst_29264 = (0);
var state_29324__$1 = (function (){var statearr_29398 = state_29324;
(statearr_29398[(9)] = inst_29262);

(statearr_29398[(20)] = inst_29263);

(statearr_29398[(11)] = inst_29264);

(statearr_29398[(30)] = inst_29255);

(statearr_29398[(29)] = inst_29253__$1);

(statearr_29398[(21)] = inst_29261);

return statearr_29398;
})();
var statearr_29402_31234 = state_29324__$1;
(statearr_29402_31234[(2)] = null);

(statearr_29402_31234[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29327 === (28))){
var inst_29280 = (state_29324[(25)]);
var inst_29261 = (state_29324[(21)]);
var inst_29280__$1 = cljs.core.seq(inst_29261);
var state_29324__$1 = (function (){var statearr_29406 = state_29324;
(statearr_29406[(25)] = inst_29280__$1);

return statearr_29406;
})();
if(inst_29280__$1){
var statearr_29407_31236 = state_29324__$1;
(statearr_29407_31236[(1)] = (33));

} else {
var statearr_29408_31237 = state_29324__$1;
(statearr_29408_31237[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29327 === (25))){
var inst_29263 = (state_29324[(20)]);
var inst_29264 = (state_29324[(11)]);
var inst_29266 = (inst_29264 < inst_29263);
var inst_29267 = inst_29266;
var state_29324__$1 = state_29324;
if(cljs.core.truth_(inst_29267)){
var statearr_29409_31242 = state_29324__$1;
(statearr_29409_31242[(1)] = (27));

} else {
var statearr_29410_31244 = state_29324__$1;
(statearr_29410_31244[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29327 === (34))){
var state_29324__$1 = state_29324;
var statearr_29411_31245 = state_29324__$1;
(statearr_29411_31245[(2)] = null);

(statearr_29411_31245[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29327 === (17))){
var state_29324__$1 = state_29324;
var statearr_29412_31247 = state_29324__$1;
(statearr_29412_31247[(2)] = null);

(statearr_29412_31247[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29327 === (3))){
var inst_29320 = (state_29324[(2)]);
var state_29324__$1 = state_29324;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29324__$1,inst_29320);
} else {
if((state_val_29327 === (12))){
var inst_29248 = (state_29324[(2)]);
var state_29324__$1 = state_29324;
var statearr_29413_31248 = state_29324__$1;
(statearr_29413_31248[(2)] = inst_29248);

(statearr_29413_31248[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29327 === (2))){
var state_29324__$1 = state_29324;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29324__$1,(4),ch);
} else {
if((state_val_29327 === (23))){
var state_29324__$1 = state_29324;
var statearr_29414_31254 = state_29324__$1;
(statearr_29414_31254[(2)] = null);

(statearr_29414_31254[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29327 === (35))){
var inst_29303 = (state_29324[(2)]);
var state_29324__$1 = state_29324;
var statearr_29416_31268 = state_29324__$1;
(statearr_29416_31268[(2)] = inst_29303);

(statearr_29416_31268[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29327 === (19))){
var inst_29220 = (state_29324[(7)]);
var inst_29224 = cljs.core.chunk_first(inst_29220);
var inst_29225 = cljs.core.chunk_rest(inst_29220);
var inst_29226 = cljs.core.count(inst_29224);
var inst_29198 = inst_29225;
var inst_29199 = inst_29224;
var inst_29200 = inst_29226;
var inst_29201 = (0);
var state_29324__$1 = (function (){var statearr_29423 = state_29324;
(statearr_29423[(13)] = inst_29201);

(statearr_29423[(15)] = inst_29200);

(statearr_29423[(16)] = inst_29199);

(statearr_29423[(17)] = inst_29198);

return statearr_29423;
})();
var statearr_29425_31271 = state_29324__$1;
(statearr_29425_31271[(2)] = null);

(statearr_29425_31271[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29327 === (11))){
var inst_29220 = (state_29324[(7)]);
var inst_29198 = (state_29324[(17)]);
var inst_29220__$1 = cljs.core.seq(inst_29198);
var state_29324__$1 = (function (){var statearr_29426 = state_29324;
(statearr_29426[(7)] = inst_29220__$1);

return statearr_29426;
})();
if(inst_29220__$1){
var statearr_29427_31272 = state_29324__$1;
(statearr_29427_31272[(1)] = (16));

} else {
var statearr_29428_31273 = state_29324__$1;
(statearr_29428_31273[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29327 === (9))){
var inst_29250 = (state_29324[(2)]);
var state_29324__$1 = state_29324;
var statearr_29434_31277 = state_29324__$1;
(statearr_29434_31277[(2)] = inst_29250);

(statearr_29434_31277[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29327 === (5))){
var inst_29196 = cljs.core.deref(cs);
var inst_29197 = cljs.core.seq(inst_29196);
var inst_29198 = inst_29197;
var inst_29199 = null;
var inst_29200 = (0);
var inst_29201 = (0);
var state_29324__$1 = (function (){var statearr_29435 = state_29324;
(statearr_29435[(13)] = inst_29201);

(statearr_29435[(15)] = inst_29200);

(statearr_29435[(16)] = inst_29199);

(statearr_29435[(17)] = inst_29198);

return statearr_29435;
})();
var statearr_29436_31282 = state_29324__$1;
(statearr_29436_31282[(2)] = null);

(statearr_29436_31282[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29327 === (14))){
var state_29324__$1 = state_29324;
var statearr_29437_31284 = state_29324__$1;
(statearr_29437_31284[(2)] = null);

(statearr_29437_31284[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29327 === (45))){
var inst_29311 = (state_29324[(2)]);
var state_29324__$1 = state_29324;
var statearr_29438_31285 = state_29324__$1;
(statearr_29438_31285[(2)] = inst_29311);

(statearr_29438_31285[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29327 === (26))){
var inst_29253 = (state_29324[(29)]);
var inst_29307 = (state_29324[(2)]);
var inst_29308 = cljs.core.seq(inst_29253);
var state_29324__$1 = (function (){var statearr_29439 = state_29324;
(statearr_29439[(31)] = inst_29307);

return statearr_29439;
})();
if(inst_29308){
var statearr_29441_31292 = state_29324__$1;
(statearr_29441_31292[(1)] = (42));

} else {
var statearr_29442_31293 = state_29324__$1;
(statearr_29442_31293[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29327 === (16))){
var inst_29220 = (state_29324[(7)]);
var inst_29222 = cljs.core.chunked_seq_QMARK_(inst_29220);
var state_29324__$1 = state_29324;
if(inst_29222){
var statearr_29449_31294 = state_29324__$1;
(statearr_29449_31294[(1)] = (19));

} else {
var statearr_29450_31296 = state_29324__$1;
(statearr_29450_31296[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29327 === (38))){
var inst_29300 = (state_29324[(2)]);
var state_29324__$1 = state_29324;
var statearr_29451_31297 = state_29324__$1;
(statearr_29451_31297[(2)] = inst_29300);

(statearr_29451_31297[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29327 === (30))){
var state_29324__$1 = state_29324;
var statearr_29452_31299 = state_29324__$1;
(statearr_29452_31299[(2)] = null);

(statearr_29452_31299[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29327 === (10))){
var inst_29201 = (state_29324[(13)]);
var inst_29199 = (state_29324[(16)]);
var inst_29209 = cljs.core._nth(inst_29199,inst_29201);
var inst_29210 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29209,(0),null);
var inst_29211 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29209,(1),null);
var state_29324__$1 = (function (){var statearr_29453 = state_29324;
(statearr_29453[(26)] = inst_29210);

return statearr_29453;
})();
if(cljs.core.truth_(inst_29211)){
var statearr_29454_31307 = state_29324__$1;
(statearr_29454_31307[(1)] = (13));

} else {
var statearr_29456_31308 = state_29324__$1;
(statearr_29456_31308[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29327 === (18))){
var inst_29246 = (state_29324[(2)]);
var state_29324__$1 = state_29324;
var statearr_29457_31312 = state_29324__$1;
(statearr_29457_31312[(2)] = inst_29246);

(statearr_29457_31312[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29327 === (42))){
var state_29324__$1 = state_29324;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29324__$1,(45),dchan);
} else {
if((state_val_29327 === (37))){
var inst_29189 = (state_29324[(10)]);
var inst_29280 = (state_29324[(25)]);
var inst_29289 = (state_29324[(23)]);
var inst_29289__$1 = cljs.core.first(inst_29280);
var inst_29290 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_29289__$1,inst_29189,done);
var state_29324__$1 = (function (){var statearr_29458 = state_29324;
(statearr_29458[(23)] = inst_29289__$1);

return statearr_29458;
})();
if(cljs.core.truth_(inst_29290)){
var statearr_29459_31345 = state_29324__$1;
(statearr_29459_31345[(1)] = (39));

} else {
var statearr_29460_31349 = state_29324__$1;
(statearr_29460_31349[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29327 === (8))){
var inst_29201 = (state_29324[(13)]);
var inst_29200 = (state_29324[(15)]);
var inst_29203 = (inst_29201 < inst_29200);
var inst_29204 = inst_29203;
var state_29324__$1 = state_29324;
if(cljs.core.truth_(inst_29204)){
var statearr_29461_31368 = state_29324__$1;
(statearr_29461_31368[(1)] = (10));

} else {
var statearr_29462_31373 = state_29324__$1;
(statearr_29462_31373[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__28158__auto__ = null;
var cljs$core$async$mult_$_state_machine__28158__auto____0 = (function (){
var statearr_29464 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29464[(0)] = cljs$core$async$mult_$_state_machine__28158__auto__);

(statearr_29464[(1)] = (1));

return statearr_29464;
});
var cljs$core$async$mult_$_state_machine__28158__auto____1 = (function (state_29324){
while(true){
var ret_value__28159__auto__ = (function (){try{while(true){
var result__28160__auto__ = switch__28157__auto__(state_29324);
if(cljs.core.keyword_identical_QMARK_(result__28160__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28160__auto__;
}
break;
}
}catch (e29468){if((e29468 instanceof Object)){
var ex__28161__auto__ = e29468;
var statearr_29469_31388 = state_29324;
(statearr_29469_31388[(5)] = ex__28161__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29324);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29468;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28159__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31389 = state_29324;
state_29324 = G__31389;
continue;
} else {
return ret_value__28159__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__28158__auto__ = function(state_29324){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__28158__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__28158__auto____1.call(this,state_29324);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__28158__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__28158__auto____0;
cljs$core$async$mult_$_state_machine__28158__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__28158__auto____1;
return cljs$core$async$mult_$_state_machine__28158__auto__;
})()
})();
var state__28358__auto__ = (function (){var statearr_29470 = f__28357__auto__();
(statearr_29470[(6)] = c__28356__auto___31119);

return statearr_29470;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28358__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__29475 = arguments.length;
switch (G__29475) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_31398 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_31398(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_31405 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_31405(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_31412 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_31412(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_31414 = (function (m,state_map){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4429__auto__.call(null,m,state_map));
} else {
var m__4426__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4426__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_31414(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_31420 = (function (m,mode){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4429__auto__.call(null,m,mode));
} else {
var m__4426__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4426__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_31420(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___31425 = arguments.length;
var i__4737__auto___31426 = (0);
while(true){
if((i__4737__auto___31426 < len__4736__auto___31425)){
args__4742__auto__.push((arguments[i__4737__auto___31426]));

var G__31428 = (i__4737__auto___31426 + (1));
i__4737__auto___31426 = G__31428;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__29499){
var map__29500 = p__29499;
var map__29500__$1 = (((((!((map__29500 == null))))?(((((map__29500.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29500.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29500):map__29500);
var opts = map__29500__$1;
var statearr_29502_31431 = state;
(statearr_29502_31431[(1)] = cont_block);


var temp__5720__auto__ = cljs.core.async.do_alts((function (val){
var statearr_29505_31433 = state;
(statearr_29505_31433[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5720__auto__)){
var cb = temp__5720__auto__;
var statearr_29506_31435 = state;
(statearr_29506_31435[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq29495){
var G__29496 = cljs.core.first(seq29495);
var seq29495__$1 = cljs.core.next(seq29495);
var G__29497 = cljs.core.first(seq29495__$1);
var seq29495__$2 = cljs.core.next(seq29495__$1);
var G__29498 = cljs.core.first(seq29495__$2);
var seq29495__$3 = cljs.core.next(seq29495__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29496,G__29497,G__29498,seq29495__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async29508 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29508 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta29509){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta29509 = meta29509;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async29508.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29510,meta29509__$1){
var self__ = this;
var _29510__$1 = this;
return (new cljs.core.async.t_cljs$core$async29508(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta29509__$1));
}));

(cljs.core.async.t_cljs$core$async29508.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29510){
var self__ = this;
var _29510__$1 = this;
return self__.meta29509;
}));

(cljs.core.async.t_cljs$core$async29508.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29508.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async29508.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29508.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async29508.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async29508.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async29508.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async29508.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async29508.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta29509","meta29509",-757926490,null)], null);
}));

(cljs.core.async.t_cljs$core$async29508.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async29508.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29508");

(cljs.core.async.t_cljs$core$async29508.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async29508");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async29508.
 */
cljs.core.async.__GT_t_cljs$core$async29508 = (function cljs$core$async$mix_$___GT_t_cljs$core$async29508(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta29509){
return (new cljs.core.async.t_cljs$core$async29508(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta29509));
});

}

return (new cljs.core.async.t_cljs$core$async29508(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__28356__auto___31470 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28357__auto__ = (function (){var switch__28157__auto__ = (function (state_29620){
var state_val_29621 = (state_29620[(1)]);
if((state_val_29621 === (7))){
var inst_29535 = (state_29620[(2)]);
var state_29620__$1 = state_29620;
var statearr_29622_31474 = state_29620__$1;
(statearr_29622_31474[(2)] = inst_29535);

(statearr_29622_31474[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29621 === (20))){
var inst_29547 = (state_29620[(7)]);
var state_29620__$1 = state_29620;
var statearr_29623_31476 = state_29620__$1;
(statearr_29623_31476[(2)] = inst_29547);

(statearr_29623_31476[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29621 === (27))){
var state_29620__$1 = state_29620;
var statearr_29624_31478 = state_29620__$1;
(statearr_29624_31478[(2)] = null);

(statearr_29624_31478[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29621 === (1))){
var inst_29522 = (state_29620[(8)]);
var inst_29522__$1 = calc_state();
var inst_29524 = (inst_29522__$1 == null);
var inst_29525 = cljs.core.not(inst_29524);
var state_29620__$1 = (function (){var statearr_29626 = state_29620;
(statearr_29626[(8)] = inst_29522__$1);

return statearr_29626;
})();
if(inst_29525){
var statearr_29628_31480 = state_29620__$1;
(statearr_29628_31480[(1)] = (2));

} else {
var statearr_29629_31481 = state_29620__$1;
(statearr_29629_31481[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29621 === (24))){
var inst_29580 = (state_29620[(9)]);
var inst_29594 = (state_29620[(10)]);
var inst_29571 = (state_29620[(11)]);
var inst_29594__$1 = (inst_29571.cljs$core$IFn$_invoke$arity$1 ? inst_29571.cljs$core$IFn$_invoke$arity$1(inst_29580) : inst_29571.call(null,inst_29580));
var state_29620__$1 = (function (){var statearr_29630 = state_29620;
(statearr_29630[(10)] = inst_29594__$1);

return statearr_29630;
})();
if(cljs.core.truth_(inst_29594__$1)){
var statearr_29631_31484 = state_29620__$1;
(statearr_29631_31484[(1)] = (29));

} else {
var statearr_29632_31486 = state_29620__$1;
(statearr_29632_31486[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29621 === (4))){
var inst_29538 = (state_29620[(2)]);
var state_29620__$1 = state_29620;
if(cljs.core.truth_(inst_29538)){
var statearr_29633_31487 = state_29620__$1;
(statearr_29633_31487[(1)] = (8));

} else {
var statearr_29634_31488 = state_29620__$1;
(statearr_29634_31488[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29621 === (15))){
var inst_29565 = (state_29620[(2)]);
var state_29620__$1 = state_29620;
if(cljs.core.truth_(inst_29565)){
var statearr_29638_31489 = state_29620__$1;
(statearr_29638_31489[(1)] = (19));

} else {
var statearr_29639_31490 = state_29620__$1;
(statearr_29639_31490[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29621 === (21))){
var inst_29570 = (state_29620[(12)]);
var inst_29570__$1 = (state_29620[(2)]);
var inst_29571 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29570__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_29572 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29570__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_29573 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29570__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_29620__$1 = (function (){var statearr_29640 = state_29620;
(statearr_29640[(13)] = inst_29572);

(statearr_29640[(12)] = inst_29570__$1);

(statearr_29640[(11)] = inst_29571);

return statearr_29640;
})();
return cljs.core.async.ioc_alts_BANG_(state_29620__$1,(22),inst_29573);
} else {
if((state_val_29621 === (31))){
var inst_29602 = (state_29620[(2)]);
var state_29620__$1 = state_29620;
if(cljs.core.truth_(inst_29602)){
var statearr_29641_31497 = state_29620__$1;
(statearr_29641_31497[(1)] = (32));

} else {
var statearr_29642_31498 = state_29620__$1;
(statearr_29642_31498[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29621 === (32))){
var inst_29579 = (state_29620[(14)]);
var state_29620__$1 = state_29620;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29620__$1,(35),out,inst_29579);
} else {
if((state_val_29621 === (33))){
var inst_29570 = (state_29620[(12)]);
var inst_29547 = inst_29570;
var state_29620__$1 = (function (){var statearr_29643 = state_29620;
(statearr_29643[(7)] = inst_29547);

return statearr_29643;
})();
var statearr_29644_31499 = state_29620__$1;
(statearr_29644_31499[(2)] = null);

(statearr_29644_31499[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29621 === (13))){
var inst_29547 = (state_29620[(7)]);
var inst_29554 = inst_29547.cljs$lang$protocol_mask$partition0$;
var inst_29555 = (inst_29554 & (64));
var inst_29556 = inst_29547.cljs$core$ISeq$;
var inst_29557 = (cljs.core.PROTOCOL_SENTINEL === inst_29556);
var inst_29558 = ((inst_29555) || (inst_29557));
var state_29620__$1 = state_29620;
if(cljs.core.truth_(inst_29558)){
var statearr_29645_31500 = state_29620__$1;
(statearr_29645_31500[(1)] = (16));

} else {
var statearr_29646_31502 = state_29620__$1;
(statearr_29646_31502[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29621 === (22))){
var inst_29580 = (state_29620[(9)]);
var inst_29579 = (state_29620[(14)]);
var inst_29578 = (state_29620[(2)]);
var inst_29579__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29578,(0),null);
var inst_29580__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29578,(1),null);
var inst_29581 = (inst_29579__$1 == null);
var inst_29582 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_29580__$1,change);
var inst_29583 = ((inst_29581) || (inst_29582));
var state_29620__$1 = (function (){var statearr_29647 = state_29620;
(statearr_29647[(9)] = inst_29580__$1);

(statearr_29647[(14)] = inst_29579__$1);

return statearr_29647;
})();
if(cljs.core.truth_(inst_29583)){
var statearr_29648_31504 = state_29620__$1;
(statearr_29648_31504[(1)] = (23));

} else {
var statearr_29649_31505 = state_29620__$1;
(statearr_29649_31505[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29621 === (36))){
var inst_29570 = (state_29620[(12)]);
var inst_29547 = inst_29570;
var state_29620__$1 = (function (){var statearr_29650 = state_29620;
(statearr_29650[(7)] = inst_29547);

return statearr_29650;
})();
var statearr_29651_31507 = state_29620__$1;
(statearr_29651_31507[(2)] = null);

(statearr_29651_31507[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29621 === (29))){
var inst_29594 = (state_29620[(10)]);
var state_29620__$1 = state_29620;
var statearr_29652_31508 = state_29620__$1;
(statearr_29652_31508[(2)] = inst_29594);

(statearr_29652_31508[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29621 === (6))){
var state_29620__$1 = state_29620;
var statearr_29654_31510 = state_29620__$1;
(statearr_29654_31510[(2)] = false);

(statearr_29654_31510[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29621 === (28))){
var inst_29590 = (state_29620[(2)]);
var inst_29591 = calc_state();
var inst_29547 = inst_29591;
var state_29620__$1 = (function (){var statearr_29655 = state_29620;
(statearr_29655[(15)] = inst_29590);

(statearr_29655[(7)] = inst_29547);

return statearr_29655;
})();
var statearr_29656_31511 = state_29620__$1;
(statearr_29656_31511[(2)] = null);

(statearr_29656_31511[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29621 === (25))){
var inst_29616 = (state_29620[(2)]);
var state_29620__$1 = state_29620;
var statearr_29657_31512 = state_29620__$1;
(statearr_29657_31512[(2)] = inst_29616);

(statearr_29657_31512[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29621 === (34))){
var inst_29614 = (state_29620[(2)]);
var state_29620__$1 = state_29620;
var statearr_29658_31513 = state_29620__$1;
(statearr_29658_31513[(2)] = inst_29614);

(statearr_29658_31513[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29621 === (17))){
var state_29620__$1 = state_29620;
var statearr_29659_31514 = state_29620__$1;
(statearr_29659_31514[(2)] = false);

(statearr_29659_31514[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29621 === (3))){
var state_29620__$1 = state_29620;
var statearr_29660_31516 = state_29620__$1;
(statearr_29660_31516[(2)] = false);

(statearr_29660_31516[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29621 === (12))){
var inst_29618 = (state_29620[(2)]);
var state_29620__$1 = state_29620;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29620__$1,inst_29618);
} else {
if((state_val_29621 === (2))){
var inst_29522 = (state_29620[(8)]);
var inst_29527 = inst_29522.cljs$lang$protocol_mask$partition0$;
var inst_29528 = (inst_29527 & (64));
var inst_29529 = inst_29522.cljs$core$ISeq$;
var inst_29530 = (cljs.core.PROTOCOL_SENTINEL === inst_29529);
var inst_29531 = ((inst_29528) || (inst_29530));
var state_29620__$1 = state_29620;
if(cljs.core.truth_(inst_29531)){
var statearr_29661_31518 = state_29620__$1;
(statearr_29661_31518[(1)] = (5));

} else {
var statearr_29662_31523 = state_29620__$1;
(statearr_29662_31523[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29621 === (23))){
var inst_29579 = (state_29620[(14)]);
var inst_29585 = (inst_29579 == null);
var state_29620__$1 = state_29620;
if(cljs.core.truth_(inst_29585)){
var statearr_29663_31531 = state_29620__$1;
(statearr_29663_31531[(1)] = (26));

} else {
var statearr_29664_31532 = state_29620__$1;
(statearr_29664_31532[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29621 === (35))){
var inst_29605 = (state_29620[(2)]);
var state_29620__$1 = state_29620;
if(cljs.core.truth_(inst_29605)){
var statearr_29665_31535 = state_29620__$1;
(statearr_29665_31535[(1)] = (36));

} else {
var statearr_29666_31536 = state_29620__$1;
(statearr_29666_31536[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29621 === (19))){
var inst_29547 = (state_29620[(7)]);
var inst_29567 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_29547);
var state_29620__$1 = state_29620;
var statearr_29667_31537 = state_29620__$1;
(statearr_29667_31537[(2)] = inst_29567);

(statearr_29667_31537[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29621 === (11))){
var inst_29547 = (state_29620[(7)]);
var inst_29551 = (inst_29547 == null);
var inst_29552 = cljs.core.not(inst_29551);
var state_29620__$1 = state_29620;
if(inst_29552){
var statearr_29668_31538 = state_29620__$1;
(statearr_29668_31538[(1)] = (13));

} else {
var statearr_29669_31539 = state_29620__$1;
(statearr_29669_31539[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29621 === (9))){
var inst_29522 = (state_29620[(8)]);
var state_29620__$1 = state_29620;
var statearr_29670_31540 = state_29620__$1;
(statearr_29670_31540[(2)] = inst_29522);

(statearr_29670_31540[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29621 === (5))){
var state_29620__$1 = state_29620;
var statearr_29671_31541 = state_29620__$1;
(statearr_29671_31541[(2)] = true);

(statearr_29671_31541[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29621 === (14))){
var state_29620__$1 = state_29620;
var statearr_29672_31543 = state_29620__$1;
(statearr_29672_31543[(2)] = false);

(statearr_29672_31543[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29621 === (26))){
var inst_29580 = (state_29620[(9)]);
var inst_29587 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_29580);
var state_29620__$1 = state_29620;
var statearr_29673_31545 = state_29620__$1;
(statearr_29673_31545[(2)] = inst_29587);

(statearr_29673_31545[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29621 === (16))){
var state_29620__$1 = state_29620;
var statearr_29674_31546 = state_29620__$1;
(statearr_29674_31546[(2)] = true);

(statearr_29674_31546[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29621 === (38))){
var inst_29610 = (state_29620[(2)]);
var state_29620__$1 = state_29620;
var statearr_29675_31548 = state_29620__$1;
(statearr_29675_31548[(2)] = inst_29610);

(statearr_29675_31548[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29621 === (30))){
var inst_29572 = (state_29620[(13)]);
var inst_29580 = (state_29620[(9)]);
var inst_29571 = (state_29620[(11)]);
var inst_29597 = cljs.core.empty_QMARK_(inst_29571);
var inst_29598 = (inst_29572.cljs$core$IFn$_invoke$arity$1 ? inst_29572.cljs$core$IFn$_invoke$arity$1(inst_29580) : inst_29572.call(null,inst_29580));
var inst_29599 = cljs.core.not(inst_29598);
var inst_29600 = ((inst_29597) && (inst_29599));
var state_29620__$1 = state_29620;
var statearr_29676_31550 = state_29620__$1;
(statearr_29676_31550[(2)] = inst_29600);

(statearr_29676_31550[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29621 === (10))){
var inst_29522 = (state_29620[(8)]);
var inst_29543 = (state_29620[(2)]);
var inst_29544 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29543,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_29545 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29543,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_29546 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29543,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_29547 = inst_29522;
var state_29620__$1 = (function (){var statearr_29677 = state_29620;
(statearr_29677[(7)] = inst_29547);

(statearr_29677[(16)] = inst_29544);

(statearr_29677[(17)] = inst_29546);

(statearr_29677[(18)] = inst_29545);

return statearr_29677;
})();
var statearr_29678_31551 = state_29620__$1;
(statearr_29678_31551[(2)] = null);

(statearr_29678_31551[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29621 === (18))){
var inst_29562 = (state_29620[(2)]);
var state_29620__$1 = state_29620;
var statearr_29683_31552 = state_29620__$1;
(statearr_29683_31552[(2)] = inst_29562);

(statearr_29683_31552[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29621 === (37))){
var state_29620__$1 = state_29620;
var statearr_29684_31553 = state_29620__$1;
(statearr_29684_31553[(2)] = null);

(statearr_29684_31553[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29621 === (8))){
var inst_29522 = (state_29620[(8)]);
var inst_29540 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_29522);
var state_29620__$1 = state_29620;
var statearr_29685_31555 = state_29620__$1;
(statearr_29685_31555[(2)] = inst_29540);

(statearr_29685_31555[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__28158__auto__ = null;
var cljs$core$async$mix_$_state_machine__28158__auto____0 = (function (){
var statearr_29686 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29686[(0)] = cljs$core$async$mix_$_state_machine__28158__auto__);

(statearr_29686[(1)] = (1));

return statearr_29686;
});
var cljs$core$async$mix_$_state_machine__28158__auto____1 = (function (state_29620){
while(true){
var ret_value__28159__auto__ = (function (){try{while(true){
var result__28160__auto__ = switch__28157__auto__(state_29620);
if(cljs.core.keyword_identical_QMARK_(result__28160__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28160__auto__;
}
break;
}
}catch (e29687){if((e29687 instanceof Object)){
var ex__28161__auto__ = e29687;
var statearr_29688_31561 = state_29620;
(statearr_29688_31561[(5)] = ex__28161__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29620);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29687;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28159__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31562 = state_29620;
state_29620 = G__31562;
continue;
} else {
return ret_value__28159__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__28158__auto__ = function(state_29620){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__28158__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__28158__auto____1.call(this,state_29620);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__28158__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__28158__auto____0;
cljs$core$async$mix_$_state_machine__28158__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__28158__auto____1;
return cljs$core$async$mix_$_state_machine__28158__auto__;
})()
})();
var state__28358__auto__ = (function (){var statearr_29689 = f__28357__auto__();
(statearr_29689[(6)] = c__28356__auto___31470);

return statearr_29689;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28358__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_31566 = (function (p,v,ch,close_QMARK_){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4429__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4426__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_31566(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_31571 = (function (p,v,ch){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4429__auto__.call(null,p,v,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4426__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_31571(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_31574 = (function() {
var G__31575 = null;
var G__31575__1 = (function (p){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4429__auto__.call(null,p));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4426__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__31575__2 = (function (p,v){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4429__auto__.call(null,p,v));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4426__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__31575 = function(p,v){
switch(arguments.length){
case 1:
return G__31575__1.call(this,p);
case 2:
return G__31575__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__31575.cljs$core$IFn$_invoke$arity$1 = G__31575__1;
G__31575.cljs$core$IFn$_invoke$arity$2 = G__31575__2;
return G__31575;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__29695 = arguments.length;
switch (G__29695) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_31574(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_31574(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__29705 = arguments.length;
switch (G__29705) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__29703_SHARP_){
if(cljs.core.truth_((p1__29703_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__29703_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__29703_SHARP_.call(null,topic)))){
return p1__29703_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__29703_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async29708 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29708 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta29709){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta29709 = meta29709;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async29708.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29710,meta29709__$1){
var self__ = this;
var _29710__$1 = this;
return (new cljs.core.async.t_cljs$core$async29708(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta29709__$1));
}));

(cljs.core.async.t_cljs$core$async29708.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29710){
var self__ = this;
var _29710__$1 = this;
return self__.meta29709;
}));

(cljs.core.async.t_cljs$core$async29708.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29708.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async29708.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29708.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async29708.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5720__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5720__auto__)){
var m = temp__5720__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async29708.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async29708.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async29708.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta29709","meta29709",1683938500,null)], null);
}));

(cljs.core.async.t_cljs$core$async29708.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async29708.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29708");

(cljs.core.async.t_cljs$core$async29708.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async29708");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async29708.
 */
cljs.core.async.__GT_t_cljs$core$async29708 = (function cljs$core$async$__GT_t_cljs$core$async29708(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta29709){
return (new cljs.core.async.t_cljs$core$async29708(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta29709));
});

}

return (new cljs.core.async.t_cljs$core$async29708(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__28356__auto___31590 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28357__auto__ = (function (){var switch__28157__auto__ = (function (state_29791){
var state_val_29792 = (state_29791[(1)]);
if((state_val_29792 === (7))){
var inst_29785 = (state_29791[(2)]);
var state_29791__$1 = state_29791;
var statearr_29797_31591 = state_29791__$1;
(statearr_29797_31591[(2)] = inst_29785);

(statearr_29797_31591[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29792 === (20))){
var state_29791__$1 = state_29791;
var statearr_29798_31593 = state_29791__$1;
(statearr_29798_31593[(2)] = null);

(statearr_29798_31593[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29792 === (1))){
var state_29791__$1 = state_29791;
var statearr_29803_31594 = state_29791__$1;
(statearr_29803_31594[(2)] = null);

(statearr_29803_31594[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29792 === (24))){
var inst_29768 = (state_29791[(7)]);
var inst_29777 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_29768);
var state_29791__$1 = state_29791;
var statearr_29804_31596 = state_29791__$1;
(statearr_29804_31596[(2)] = inst_29777);

(statearr_29804_31596[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29792 === (4))){
var inst_29719 = (state_29791[(8)]);
var inst_29719__$1 = (state_29791[(2)]);
var inst_29721 = (inst_29719__$1 == null);
var state_29791__$1 = (function (){var statearr_29806 = state_29791;
(statearr_29806[(8)] = inst_29719__$1);

return statearr_29806;
})();
if(cljs.core.truth_(inst_29721)){
var statearr_29808_31599 = state_29791__$1;
(statearr_29808_31599[(1)] = (5));

} else {
var statearr_29809_31600 = state_29791__$1;
(statearr_29809_31600[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29792 === (15))){
var inst_29762 = (state_29791[(2)]);
var state_29791__$1 = state_29791;
var statearr_29811_31601 = state_29791__$1;
(statearr_29811_31601[(2)] = inst_29762);

(statearr_29811_31601[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29792 === (21))){
var inst_29782 = (state_29791[(2)]);
var state_29791__$1 = (function (){var statearr_29812 = state_29791;
(statearr_29812[(9)] = inst_29782);

return statearr_29812;
})();
var statearr_29813_31603 = state_29791__$1;
(statearr_29813_31603[(2)] = null);

(statearr_29813_31603[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29792 === (13))){
var inst_29744 = (state_29791[(10)]);
var inst_29746 = cljs.core.chunked_seq_QMARK_(inst_29744);
var state_29791__$1 = state_29791;
if(inst_29746){
var statearr_29814_31605 = state_29791__$1;
(statearr_29814_31605[(1)] = (16));

} else {
var statearr_29815_31606 = state_29791__$1;
(statearr_29815_31606[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29792 === (22))){
var inst_29774 = (state_29791[(2)]);
var state_29791__$1 = state_29791;
if(cljs.core.truth_(inst_29774)){
var statearr_29816_31608 = state_29791__$1;
(statearr_29816_31608[(1)] = (23));

} else {
var statearr_29817_31609 = state_29791__$1;
(statearr_29817_31609[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29792 === (6))){
var inst_29719 = (state_29791[(8)]);
var inst_29768 = (state_29791[(7)]);
var inst_29770 = (state_29791[(11)]);
var inst_29768__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_29719) : topic_fn.call(null,inst_29719));
var inst_29769 = cljs.core.deref(mults);
var inst_29770__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29769,inst_29768__$1);
var state_29791__$1 = (function (){var statearr_29820 = state_29791;
(statearr_29820[(7)] = inst_29768__$1);

(statearr_29820[(11)] = inst_29770__$1);

return statearr_29820;
})();
if(cljs.core.truth_(inst_29770__$1)){
var statearr_29822_31612 = state_29791__$1;
(statearr_29822_31612[(1)] = (19));

} else {
var statearr_29827_31613 = state_29791__$1;
(statearr_29827_31613[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29792 === (25))){
var inst_29779 = (state_29791[(2)]);
var state_29791__$1 = state_29791;
var statearr_29828_31615 = state_29791__$1;
(statearr_29828_31615[(2)] = inst_29779);

(statearr_29828_31615[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29792 === (17))){
var inst_29744 = (state_29791[(10)]);
var inst_29753 = cljs.core.first(inst_29744);
var inst_29754 = cljs.core.async.muxch_STAR_(inst_29753);
var inst_29755 = cljs.core.async.close_BANG_(inst_29754);
var inst_29756 = cljs.core.next(inst_29744);
var inst_29730 = inst_29756;
var inst_29731 = null;
var inst_29732 = (0);
var inst_29733 = (0);
var state_29791__$1 = (function (){var statearr_29829 = state_29791;
(statearr_29829[(12)] = inst_29755);

(statearr_29829[(13)] = inst_29731);

(statearr_29829[(14)] = inst_29730);

(statearr_29829[(15)] = inst_29732);

(statearr_29829[(16)] = inst_29733);

return statearr_29829;
})();
var statearr_29830_31617 = state_29791__$1;
(statearr_29830_31617[(2)] = null);

(statearr_29830_31617[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29792 === (3))){
var inst_29788 = (state_29791[(2)]);
var state_29791__$1 = state_29791;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29791__$1,inst_29788);
} else {
if((state_val_29792 === (12))){
var inst_29764 = (state_29791[(2)]);
var state_29791__$1 = state_29791;
var statearr_29831_31618 = state_29791__$1;
(statearr_29831_31618[(2)] = inst_29764);

(statearr_29831_31618[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29792 === (2))){
var state_29791__$1 = state_29791;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29791__$1,(4),ch);
} else {
if((state_val_29792 === (23))){
var state_29791__$1 = state_29791;
var statearr_29832_31620 = state_29791__$1;
(statearr_29832_31620[(2)] = null);

(statearr_29832_31620[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29792 === (19))){
var inst_29719 = (state_29791[(8)]);
var inst_29770 = (state_29791[(11)]);
var inst_29772 = cljs.core.async.muxch_STAR_(inst_29770);
var state_29791__$1 = state_29791;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29791__$1,(22),inst_29772,inst_29719);
} else {
if((state_val_29792 === (11))){
var inst_29730 = (state_29791[(14)]);
var inst_29744 = (state_29791[(10)]);
var inst_29744__$1 = cljs.core.seq(inst_29730);
var state_29791__$1 = (function (){var statearr_29834 = state_29791;
(statearr_29834[(10)] = inst_29744__$1);

return statearr_29834;
})();
if(inst_29744__$1){
var statearr_29835_31622 = state_29791__$1;
(statearr_29835_31622[(1)] = (13));

} else {
var statearr_29836_31623 = state_29791__$1;
(statearr_29836_31623[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29792 === (9))){
var inst_29766 = (state_29791[(2)]);
var state_29791__$1 = state_29791;
var statearr_29837_31625 = state_29791__$1;
(statearr_29837_31625[(2)] = inst_29766);

(statearr_29837_31625[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29792 === (5))){
var inst_29727 = cljs.core.deref(mults);
var inst_29728 = cljs.core.vals(inst_29727);
var inst_29729 = cljs.core.seq(inst_29728);
var inst_29730 = inst_29729;
var inst_29731 = null;
var inst_29732 = (0);
var inst_29733 = (0);
var state_29791__$1 = (function (){var statearr_29838 = state_29791;
(statearr_29838[(13)] = inst_29731);

(statearr_29838[(14)] = inst_29730);

(statearr_29838[(15)] = inst_29732);

(statearr_29838[(16)] = inst_29733);

return statearr_29838;
})();
var statearr_29839_31626 = state_29791__$1;
(statearr_29839_31626[(2)] = null);

(statearr_29839_31626[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29792 === (14))){
var state_29791__$1 = state_29791;
var statearr_29843_31627 = state_29791__$1;
(statearr_29843_31627[(2)] = null);

(statearr_29843_31627[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29792 === (16))){
var inst_29744 = (state_29791[(10)]);
var inst_29748 = cljs.core.chunk_first(inst_29744);
var inst_29749 = cljs.core.chunk_rest(inst_29744);
var inst_29750 = cljs.core.count(inst_29748);
var inst_29730 = inst_29749;
var inst_29731 = inst_29748;
var inst_29732 = inst_29750;
var inst_29733 = (0);
var state_29791__$1 = (function (){var statearr_29844 = state_29791;
(statearr_29844[(13)] = inst_29731);

(statearr_29844[(14)] = inst_29730);

(statearr_29844[(15)] = inst_29732);

(statearr_29844[(16)] = inst_29733);

return statearr_29844;
})();
var statearr_29845_31630 = state_29791__$1;
(statearr_29845_31630[(2)] = null);

(statearr_29845_31630[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29792 === (10))){
var inst_29731 = (state_29791[(13)]);
var inst_29730 = (state_29791[(14)]);
var inst_29732 = (state_29791[(15)]);
var inst_29733 = (state_29791[(16)]);
var inst_29738 = cljs.core._nth(inst_29731,inst_29733);
var inst_29739 = cljs.core.async.muxch_STAR_(inst_29738);
var inst_29740 = cljs.core.async.close_BANG_(inst_29739);
var inst_29741 = (inst_29733 + (1));
var tmp29840 = inst_29731;
var tmp29841 = inst_29730;
var tmp29842 = inst_29732;
var inst_29730__$1 = tmp29841;
var inst_29731__$1 = tmp29840;
var inst_29732__$1 = tmp29842;
var inst_29733__$1 = inst_29741;
var state_29791__$1 = (function (){var statearr_29846 = state_29791;
(statearr_29846[(13)] = inst_29731__$1);

(statearr_29846[(14)] = inst_29730__$1);

(statearr_29846[(15)] = inst_29732__$1);

(statearr_29846[(16)] = inst_29733__$1);

(statearr_29846[(17)] = inst_29740);

return statearr_29846;
})();
var statearr_29847_31633 = state_29791__$1;
(statearr_29847_31633[(2)] = null);

(statearr_29847_31633[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29792 === (18))){
var inst_29759 = (state_29791[(2)]);
var state_29791__$1 = state_29791;
var statearr_29848_31634 = state_29791__$1;
(statearr_29848_31634[(2)] = inst_29759);

(statearr_29848_31634[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29792 === (8))){
var inst_29732 = (state_29791[(15)]);
var inst_29733 = (state_29791[(16)]);
var inst_29735 = (inst_29733 < inst_29732);
var inst_29736 = inst_29735;
var state_29791__$1 = state_29791;
if(cljs.core.truth_(inst_29736)){
var statearr_29849_31635 = state_29791__$1;
(statearr_29849_31635[(1)] = (10));

} else {
var statearr_29850_31636 = state_29791__$1;
(statearr_29850_31636[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28158__auto__ = null;
var cljs$core$async$state_machine__28158__auto____0 = (function (){
var statearr_29851 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29851[(0)] = cljs$core$async$state_machine__28158__auto__);

(statearr_29851[(1)] = (1));

return statearr_29851;
});
var cljs$core$async$state_machine__28158__auto____1 = (function (state_29791){
while(true){
var ret_value__28159__auto__ = (function (){try{while(true){
var result__28160__auto__ = switch__28157__auto__(state_29791);
if(cljs.core.keyword_identical_QMARK_(result__28160__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28160__auto__;
}
break;
}
}catch (e29852){if((e29852 instanceof Object)){
var ex__28161__auto__ = e29852;
var statearr_29853_31639 = state_29791;
(statearr_29853_31639[(5)] = ex__28161__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29791);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29852;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28159__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31640 = state_29791;
state_29791 = G__31640;
continue;
} else {
return ret_value__28159__auto__;
}
break;
}
});
cljs$core$async$state_machine__28158__auto__ = function(state_29791){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28158__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28158__auto____1.call(this,state_29791);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28158__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28158__auto____0;
cljs$core$async$state_machine__28158__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28158__auto____1;
return cljs$core$async$state_machine__28158__auto__;
})()
})();
var state__28358__auto__ = (function (){var statearr_29854 = f__28357__auto__();
(statearr_29854[(6)] = c__28356__auto___31590);

return statearr_29854;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28358__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__29856 = arguments.length;
switch (G__29856) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__29858 = arguments.length;
switch (G__29858) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__29864 = arguments.length;
switch (G__29864) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__28356__auto___31644 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28357__auto__ = (function (){var switch__28157__auto__ = (function (state_29905){
var state_val_29906 = (state_29905[(1)]);
if((state_val_29906 === (7))){
var state_29905__$1 = state_29905;
var statearr_29907_31645 = state_29905__$1;
(statearr_29907_31645[(2)] = null);

(statearr_29907_31645[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29906 === (1))){
var state_29905__$1 = state_29905;
var statearr_29908_31646 = state_29905__$1;
(statearr_29908_31646[(2)] = null);

(statearr_29908_31646[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29906 === (4))){
var inst_29868 = (state_29905[(7)]);
var inst_29870 = (inst_29868 < cnt);
var state_29905__$1 = state_29905;
if(cljs.core.truth_(inst_29870)){
var statearr_29909_31647 = state_29905__$1;
(statearr_29909_31647[(1)] = (6));

} else {
var statearr_29910_31648 = state_29905__$1;
(statearr_29910_31648[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29906 === (15))){
var inst_29901 = (state_29905[(2)]);
var state_29905__$1 = state_29905;
var statearr_29911_31649 = state_29905__$1;
(statearr_29911_31649[(2)] = inst_29901);

(statearr_29911_31649[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29906 === (13))){
var inst_29894 = cljs.core.async.close_BANG_(out);
var state_29905__$1 = state_29905;
var statearr_29912_31650 = state_29905__$1;
(statearr_29912_31650[(2)] = inst_29894);

(statearr_29912_31650[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29906 === (6))){
var state_29905__$1 = state_29905;
var statearr_29913_31651 = state_29905__$1;
(statearr_29913_31651[(2)] = null);

(statearr_29913_31651[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29906 === (3))){
var inst_29903 = (state_29905[(2)]);
var state_29905__$1 = state_29905;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29905__$1,inst_29903);
} else {
if((state_val_29906 === (12))){
var inst_29891 = (state_29905[(8)]);
var inst_29891__$1 = (state_29905[(2)]);
var inst_29892 = cljs.core.some(cljs.core.nil_QMARK_,inst_29891__$1);
var state_29905__$1 = (function (){var statearr_29914 = state_29905;
(statearr_29914[(8)] = inst_29891__$1);

return statearr_29914;
})();
if(cljs.core.truth_(inst_29892)){
var statearr_29915_31652 = state_29905__$1;
(statearr_29915_31652[(1)] = (13));

} else {
var statearr_29916_31653 = state_29905__$1;
(statearr_29916_31653[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29906 === (2))){
var inst_29867 = cljs.core.reset_BANG_(dctr,cnt);
var inst_29868 = (0);
var state_29905__$1 = (function (){var statearr_29917 = state_29905;
(statearr_29917[(9)] = inst_29867);

(statearr_29917[(7)] = inst_29868);

return statearr_29917;
})();
var statearr_29918_31654 = state_29905__$1;
(statearr_29918_31654[(2)] = null);

(statearr_29918_31654[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29906 === (11))){
var inst_29868 = (state_29905[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_29905,(10),Object,null,(9));
var inst_29878 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_29868) : chs__$1.call(null,inst_29868));
var inst_29879 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_29868) : done.call(null,inst_29868));
var inst_29880 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_29878,inst_29879);
var state_29905__$1 = state_29905;
var statearr_29919_31655 = state_29905__$1;
(statearr_29919_31655[(2)] = inst_29880);


cljs.core.async.impl.ioc_helpers.process_exception(state_29905__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29906 === (9))){
var inst_29868 = (state_29905[(7)]);
var inst_29882 = (state_29905[(2)]);
var inst_29883 = (inst_29868 + (1));
var inst_29868__$1 = inst_29883;
var state_29905__$1 = (function (){var statearr_29920 = state_29905;
(statearr_29920[(10)] = inst_29882);

(statearr_29920[(7)] = inst_29868__$1);

return statearr_29920;
})();
var statearr_29921_31656 = state_29905__$1;
(statearr_29921_31656[(2)] = null);

(statearr_29921_31656[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29906 === (5))){
var inst_29889 = (state_29905[(2)]);
var state_29905__$1 = (function (){var statearr_29922 = state_29905;
(statearr_29922[(11)] = inst_29889);

return statearr_29922;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29905__$1,(12),dchan);
} else {
if((state_val_29906 === (14))){
var inst_29891 = (state_29905[(8)]);
var inst_29896 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_29891);
var state_29905__$1 = state_29905;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29905__$1,(16),out,inst_29896);
} else {
if((state_val_29906 === (16))){
var inst_29898 = (state_29905[(2)]);
var state_29905__$1 = (function (){var statearr_29923 = state_29905;
(statearr_29923[(12)] = inst_29898);

return statearr_29923;
})();
var statearr_29924_31657 = state_29905__$1;
(statearr_29924_31657[(2)] = null);

(statearr_29924_31657[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29906 === (10))){
var inst_29872 = (state_29905[(2)]);
var inst_29873 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_29905__$1 = (function (){var statearr_29925 = state_29905;
(statearr_29925[(13)] = inst_29872);

return statearr_29925;
})();
var statearr_29926_31658 = state_29905__$1;
(statearr_29926_31658[(2)] = inst_29873);


cljs.core.async.impl.ioc_helpers.process_exception(state_29905__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29906 === (8))){
var inst_29887 = (state_29905[(2)]);
var state_29905__$1 = state_29905;
var statearr_29927_31659 = state_29905__$1;
(statearr_29927_31659[(2)] = inst_29887);

(statearr_29927_31659[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28158__auto__ = null;
var cljs$core$async$state_machine__28158__auto____0 = (function (){
var statearr_29928 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29928[(0)] = cljs$core$async$state_machine__28158__auto__);

(statearr_29928[(1)] = (1));

return statearr_29928;
});
var cljs$core$async$state_machine__28158__auto____1 = (function (state_29905){
while(true){
var ret_value__28159__auto__ = (function (){try{while(true){
var result__28160__auto__ = switch__28157__auto__(state_29905);
if(cljs.core.keyword_identical_QMARK_(result__28160__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28160__auto__;
}
break;
}
}catch (e29929){if((e29929 instanceof Object)){
var ex__28161__auto__ = e29929;
var statearr_29930_31660 = state_29905;
(statearr_29930_31660[(5)] = ex__28161__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29905);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29929;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28159__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31661 = state_29905;
state_29905 = G__31661;
continue;
} else {
return ret_value__28159__auto__;
}
break;
}
});
cljs$core$async$state_machine__28158__auto__ = function(state_29905){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28158__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28158__auto____1.call(this,state_29905);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28158__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28158__auto____0;
cljs$core$async$state_machine__28158__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28158__auto____1;
return cljs$core$async$state_machine__28158__auto__;
})()
})();
var state__28358__auto__ = (function (){var statearr_29931 = f__28357__auto__();
(statearr_29931[(6)] = c__28356__auto___31644);

return statearr_29931;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28358__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__29934 = arguments.length;
switch (G__29934) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28356__auto___31663 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28357__auto__ = (function (){var switch__28157__auto__ = (function (state_29969){
var state_val_29970 = (state_29969[(1)]);
if((state_val_29970 === (7))){
var inst_29946 = (state_29969[(7)]);
var inst_29945 = (state_29969[(8)]);
var inst_29945__$1 = (state_29969[(2)]);
var inst_29946__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29945__$1,(0),null);
var inst_29947 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29945__$1,(1),null);
var inst_29948 = (inst_29946__$1 == null);
var state_29969__$1 = (function (){var statearr_29971 = state_29969;
(statearr_29971[(7)] = inst_29946__$1);

(statearr_29971[(9)] = inst_29947);

(statearr_29971[(8)] = inst_29945__$1);

return statearr_29971;
})();
if(cljs.core.truth_(inst_29948)){
var statearr_29972_31664 = state_29969__$1;
(statearr_29972_31664[(1)] = (8));

} else {
var statearr_29973_31665 = state_29969__$1;
(statearr_29973_31665[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29970 === (1))){
var inst_29935 = cljs.core.vec(chs);
var inst_29936 = inst_29935;
var state_29969__$1 = (function (){var statearr_29974 = state_29969;
(statearr_29974[(10)] = inst_29936);

return statearr_29974;
})();
var statearr_29975_31666 = state_29969__$1;
(statearr_29975_31666[(2)] = null);

(statearr_29975_31666[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29970 === (4))){
var inst_29936 = (state_29969[(10)]);
var state_29969__$1 = state_29969;
return cljs.core.async.ioc_alts_BANG_(state_29969__$1,(7),inst_29936);
} else {
if((state_val_29970 === (6))){
var inst_29962 = (state_29969[(2)]);
var state_29969__$1 = state_29969;
var statearr_29976_31667 = state_29969__$1;
(statearr_29976_31667[(2)] = inst_29962);

(statearr_29976_31667[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29970 === (3))){
var inst_29964 = (state_29969[(2)]);
var state_29969__$1 = state_29969;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29969__$1,inst_29964);
} else {
if((state_val_29970 === (2))){
var inst_29936 = (state_29969[(10)]);
var inst_29938 = cljs.core.count(inst_29936);
var inst_29939 = (inst_29938 > (0));
var state_29969__$1 = state_29969;
if(cljs.core.truth_(inst_29939)){
var statearr_29978_31668 = state_29969__$1;
(statearr_29978_31668[(1)] = (4));

} else {
var statearr_29979_31669 = state_29969__$1;
(statearr_29979_31669[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29970 === (11))){
var inst_29936 = (state_29969[(10)]);
var inst_29955 = (state_29969[(2)]);
var tmp29977 = inst_29936;
var inst_29936__$1 = tmp29977;
var state_29969__$1 = (function (){var statearr_29980 = state_29969;
(statearr_29980[(11)] = inst_29955);

(statearr_29980[(10)] = inst_29936__$1);

return statearr_29980;
})();
var statearr_29981_31670 = state_29969__$1;
(statearr_29981_31670[(2)] = null);

(statearr_29981_31670[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29970 === (9))){
var inst_29946 = (state_29969[(7)]);
var state_29969__$1 = state_29969;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29969__$1,(11),out,inst_29946);
} else {
if((state_val_29970 === (5))){
var inst_29960 = cljs.core.async.close_BANG_(out);
var state_29969__$1 = state_29969;
var statearr_29982_31671 = state_29969__$1;
(statearr_29982_31671[(2)] = inst_29960);

(statearr_29982_31671[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29970 === (10))){
var inst_29958 = (state_29969[(2)]);
var state_29969__$1 = state_29969;
var statearr_29983_31672 = state_29969__$1;
(statearr_29983_31672[(2)] = inst_29958);

(statearr_29983_31672[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29970 === (8))){
var inst_29946 = (state_29969[(7)]);
var inst_29947 = (state_29969[(9)]);
var inst_29936 = (state_29969[(10)]);
var inst_29945 = (state_29969[(8)]);
var inst_29950 = (function (){var cs = inst_29936;
var vec__29941 = inst_29945;
var v = inst_29946;
var c = inst_29947;
return (function (p1__29932_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__29932_SHARP_);
});
})();
var inst_29951 = cljs.core.filterv(inst_29950,inst_29936);
var inst_29936__$1 = inst_29951;
var state_29969__$1 = (function (){var statearr_29986 = state_29969;
(statearr_29986[(10)] = inst_29936__$1);

return statearr_29986;
})();
var statearr_29987_31673 = state_29969__$1;
(statearr_29987_31673[(2)] = null);

(statearr_29987_31673[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28158__auto__ = null;
var cljs$core$async$state_machine__28158__auto____0 = (function (){
var statearr_29989 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29989[(0)] = cljs$core$async$state_machine__28158__auto__);

(statearr_29989[(1)] = (1));

return statearr_29989;
});
var cljs$core$async$state_machine__28158__auto____1 = (function (state_29969){
while(true){
var ret_value__28159__auto__ = (function (){try{while(true){
var result__28160__auto__ = switch__28157__auto__(state_29969);
if(cljs.core.keyword_identical_QMARK_(result__28160__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28160__auto__;
}
break;
}
}catch (e29990){if((e29990 instanceof Object)){
var ex__28161__auto__ = e29990;
var statearr_29991_31674 = state_29969;
(statearr_29991_31674[(5)] = ex__28161__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29969);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29990;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28159__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31675 = state_29969;
state_29969 = G__31675;
continue;
} else {
return ret_value__28159__auto__;
}
break;
}
});
cljs$core$async$state_machine__28158__auto__ = function(state_29969){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28158__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28158__auto____1.call(this,state_29969);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28158__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28158__auto____0;
cljs$core$async$state_machine__28158__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28158__auto____1;
return cljs$core$async$state_machine__28158__auto__;
})()
})();
var state__28358__auto__ = (function (){var statearr_29992 = f__28357__auto__();
(statearr_29992[(6)] = c__28356__auto___31663);

return statearr_29992;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28358__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__29998 = arguments.length;
switch (G__29998) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28356__auto___31677 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28357__auto__ = (function (){var switch__28157__auto__ = (function (state_30023){
var state_val_30024 = (state_30023[(1)]);
if((state_val_30024 === (7))){
var inst_30005 = (state_30023[(7)]);
var inst_30005__$1 = (state_30023[(2)]);
var inst_30006 = (inst_30005__$1 == null);
var inst_30007 = cljs.core.not(inst_30006);
var state_30023__$1 = (function (){var statearr_30025 = state_30023;
(statearr_30025[(7)] = inst_30005__$1);

return statearr_30025;
})();
if(inst_30007){
var statearr_30026_31678 = state_30023__$1;
(statearr_30026_31678[(1)] = (8));

} else {
var statearr_30027_31679 = state_30023__$1;
(statearr_30027_31679[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30024 === (1))){
var inst_30000 = (0);
var state_30023__$1 = (function (){var statearr_30028 = state_30023;
(statearr_30028[(8)] = inst_30000);

return statearr_30028;
})();
var statearr_30029_31680 = state_30023__$1;
(statearr_30029_31680[(2)] = null);

(statearr_30029_31680[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30024 === (4))){
var state_30023__$1 = state_30023;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30023__$1,(7),ch);
} else {
if((state_val_30024 === (6))){
var inst_30018 = (state_30023[(2)]);
var state_30023__$1 = state_30023;
var statearr_30030_31681 = state_30023__$1;
(statearr_30030_31681[(2)] = inst_30018);

(statearr_30030_31681[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30024 === (3))){
var inst_30020 = (state_30023[(2)]);
var inst_30021 = cljs.core.async.close_BANG_(out);
var state_30023__$1 = (function (){var statearr_30031 = state_30023;
(statearr_30031[(9)] = inst_30020);

return statearr_30031;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_30023__$1,inst_30021);
} else {
if((state_val_30024 === (2))){
var inst_30000 = (state_30023[(8)]);
var inst_30002 = (inst_30000 < n);
var state_30023__$1 = state_30023;
if(cljs.core.truth_(inst_30002)){
var statearr_30032_31682 = state_30023__$1;
(statearr_30032_31682[(1)] = (4));

} else {
var statearr_30033_31683 = state_30023__$1;
(statearr_30033_31683[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30024 === (11))){
var inst_30000 = (state_30023[(8)]);
var inst_30010 = (state_30023[(2)]);
var inst_30011 = (inst_30000 + (1));
var inst_30000__$1 = inst_30011;
var state_30023__$1 = (function (){var statearr_30034 = state_30023;
(statearr_30034[(10)] = inst_30010);

(statearr_30034[(8)] = inst_30000__$1);

return statearr_30034;
})();
var statearr_30038_31684 = state_30023__$1;
(statearr_30038_31684[(2)] = null);

(statearr_30038_31684[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30024 === (9))){
var state_30023__$1 = state_30023;
var statearr_30039_31685 = state_30023__$1;
(statearr_30039_31685[(2)] = null);

(statearr_30039_31685[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30024 === (5))){
var state_30023__$1 = state_30023;
var statearr_30041_31686 = state_30023__$1;
(statearr_30041_31686[(2)] = null);

(statearr_30041_31686[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30024 === (10))){
var inst_30015 = (state_30023[(2)]);
var state_30023__$1 = state_30023;
var statearr_30042_31687 = state_30023__$1;
(statearr_30042_31687[(2)] = inst_30015);

(statearr_30042_31687[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30024 === (8))){
var inst_30005 = (state_30023[(7)]);
var state_30023__$1 = state_30023;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30023__$1,(11),out,inst_30005);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28158__auto__ = null;
var cljs$core$async$state_machine__28158__auto____0 = (function (){
var statearr_30043 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_30043[(0)] = cljs$core$async$state_machine__28158__auto__);

(statearr_30043[(1)] = (1));

return statearr_30043;
});
var cljs$core$async$state_machine__28158__auto____1 = (function (state_30023){
while(true){
var ret_value__28159__auto__ = (function (){try{while(true){
var result__28160__auto__ = switch__28157__auto__(state_30023);
if(cljs.core.keyword_identical_QMARK_(result__28160__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28160__auto__;
}
break;
}
}catch (e30044){if((e30044 instanceof Object)){
var ex__28161__auto__ = e30044;
var statearr_30045_31688 = state_30023;
(statearr_30045_31688[(5)] = ex__28161__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30023);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30044;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28159__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31689 = state_30023;
state_30023 = G__31689;
continue;
} else {
return ret_value__28159__auto__;
}
break;
}
});
cljs$core$async$state_machine__28158__auto__ = function(state_30023){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28158__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28158__auto____1.call(this,state_30023);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28158__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28158__auto____0;
cljs$core$async$state_machine__28158__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28158__auto____1;
return cljs$core$async$state_machine__28158__auto__;
})()
})();
var state__28358__auto__ = (function (){var statearr_30046 = f__28357__auto__();
(statearr_30046[(6)] = c__28356__auto___31677);

return statearr_30046;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28358__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async30048 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30048 = (function (f,ch,meta30049){
this.f = f;
this.ch = ch;
this.meta30049 = meta30049;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30048.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30050,meta30049__$1){
var self__ = this;
var _30050__$1 = this;
return (new cljs.core.async.t_cljs$core$async30048(self__.f,self__.ch,meta30049__$1));
}));

(cljs.core.async.t_cljs$core$async30048.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30050){
var self__ = this;
var _30050__$1 = this;
return self__.meta30049;
}));

(cljs.core.async.t_cljs$core$async30048.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30048.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async30048.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async30048.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30048.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async30051 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30051 = (function (f,ch,meta30049,_,fn1,meta30052){
this.f = f;
this.ch = ch;
this.meta30049 = meta30049;
this._ = _;
this.fn1 = fn1;
this.meta30052 = meta30052;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30051.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30053,meta30052__$1){
var self__ = this;
var _30053__$1 = this;
return (new cljs.core.async.t_cljs$core$async30051(self__.f,self__.ch,self__.meta30049,self__._,self__.fn1,meta30052__$1));
}));

(cljs.core.async.t_cljs$core$async30051.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30053){
var self__ = this;
var _30053__$1 = this;
return self__.meta30052;
}));

(cljs.core.async.t_cljs$core$async30051.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30051.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async30051.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async30051.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__30047_SHARP_){
var G__30060 = (((p1__30047_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__30047_SHARP_) : self__.f.call(null,p1__30047_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__30060) : f1.call(null,G__30060));
});
}));

(cljs.core.async.t_cljs$core$async30051.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta30049","meta30049",-863276742,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async30048","cljs.core.async/t_cljs$core$async30048",503852489,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta30052","meta30052",-1377121715,null)], null);
}));

(cljs.core.async.t_cljs$core$async30051.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30051.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30051");

(cljs.core.async.t_cljs$core$async30051.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async30051");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30051.
 */
cljs.core.async.__GT_t_cljs$core$async30051 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async30051(f__$1,ch__$1,meta30049__$1,___$2,fn1__$1,meta30052){
return (new cljs.core.async.t_cljs$core$async30051(f__$1,ch__$1,meta30049__$1,___$2,fn1__$1,meta30052));
});

}

return (new cljs.core.async.t_cljs$core$async30051(self__.f,self__.ch,self__.meta30049,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4115__auto__ = ret;
if(cljs.core.truth_(and__4115__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4115__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__30061 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__30061) : self__.f.call(null,G__30061));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async30048.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30048.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async30048.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta30049","meta30049",-863276742,null)], null);
}));

(cljs.core.async.t_cljs$core$async30048.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30048.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30048");

(cljs.core.async.t_cljs$core$async30048.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async30048");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30048.
 */
cljs.core.async.__GT_t_cljs$core$async30048 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async30048(f__$1,ch__$1,meta30049){
return (new cljs.core.async.t_cljs$core$async30048(f__$1,ch__$1,meta30049));
});

}

return (new cljs.core.async.t_cljs$core$async30048(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async30062 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30062 = (function (f,ch,meta30063){
this.f = f;
this.ch = ch;
this.meta30063 = meta30063;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30062.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30064,meta30063__$1){
var self__ = this;
var _30064__$1 = this;
return (new cljs.core.async.t_cljs$core$async30062(self__.f,self__.ch,meta30063__$1));
}));

(cljs.core.async.t_cljs$core$async30062.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30064){
var self__ = this;
var _30064__$1 = this;
return self__.meta30063;
}));

(cljs.core.async.t_cljs$core$async30062.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30062.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async30062.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30062.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async30062.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30062.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async30062.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta30063","meta30063",-701195794,null)], null);
}));

(cljs.core.async.t_cljs$core$async30062.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30062.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30062");

(cljs.core.async.t_cljs$core$async30062.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async30062");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30062.
 */
cljs.core.async.__GT_t_cljs$core$async30062 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async30062(f__$1,ch__$1,meta30063){
return (new cljs.core.async.t_cljs$core$async30062(f__$1,ch__$1,meta30063));
});

}

return (new cljs.core.async.t_cljs$core$async30062(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async30065 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30065 = (function (p,ch,meta30066){
this.p = p;
this.ch = ch;
this.meta30066 = meta30066;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30065.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30067,meta30066__$1){
var self__ = this;
var _30067__$1 = this;
return (new cljs.core.async.t_cljs$core$async30065(self__.p,self__.ch,meta30066__$1));
}));

(cljs.core.async.t_cljs$core$async30065.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30067){
var self__ = this;
var _30067__$1 = this;
return self__.meta30066;
}));

(cljs.core.async.t_cljs$core$async30065.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30065.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async30065.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async30065.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30065.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async30065.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30065.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async30065.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta30066","meta30066",689604257,null)], null);
}));

(cljs.core.async.t_cljs$core$async30065.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30065.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30065");

(cljs.core.async.t_cljs$core$async30065.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async30065");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30065.
 */
cljs.core.async.__GT_t_cljs$core$async30065 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async30065(p__$1,ch__$1,meta30066){
return (new cljs.core.async.t_cljs$core$async30065(p__$1,ch__$1,meta30066));
});

}

return (new cljs.core.async.t_cljs$core$async30065(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__30070 = arguments.length;
switch (G__30070) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28356__auto___31691 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28357__auto__ = (function (){var switch__28157__auto__ = (function (state_30093){
var state_val_30094 = (state_30093[(1)]);
if((state_val_30094 === (7))){
var inst_30089 = (state_30093[(2)]);
var state_30093__$1 = state_30093;
var statearr_30095_31692 = state_30093__$1;
(statearr_30095_31692[(2)] = inst_30089);

(statearr_30095_31692[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30094 === (1))){
var state_30093__$1 = state_30093;
var statearr_30096_31693 = state_30093__$1;
(statearr_30096_31693[(2)] = null);

(statearr_30096_31693[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30094 === (4))){
var inst_30073 = (state_30093[(7)]);
var inst_30073__$1 = (state_30093[(2)]);
var inst_30074 = (inst_30073__$1 == null);
var state_30093__$1 = (function (){var statearr_30097 = state_30093;
(statearr_30097[(7)] = inst_30073__$1);

return statearr_30097;
})();
if(cljs.core.truth_(inst_30074)){
var statearr_30098_31694 = state_30093__$1;
(statearr_30098_31694[(1)] = (5));

} else {
var statearr_30099_31695 = state_30093__$1;
(statearr_30099_31695[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30094 === (6))){
var inst_30073 = (state_30093[(7)]);
var inst_30078 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_30073) : p.call(null,inst_30073));
var state_30093__$1 = state_30093;
if(cljs.core.truth_(inst_30078)){
var statearr_30100_31696 = state_30093__$1;
(statearr_30100_31696[(1)] = (8));

} else {
var statearr_30101_31697 = state_30093__$1;
(statearr_30101_31697[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30094 === (3))){
var inst_30091 = (state_30093[(2)]);
var state_30093__$1 = state_30093;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30093__$1,inst_30091);
} else {
if((state_val_30094 === (2))){
var state_30093__$1 = state_30093;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30093__$1,(4),ch);
} else {
if((state_val_30094 === (11))){
var inst_30083 = (state_30093[(2)]);
var state_30093__$1 = state_30093;
var statearr_30102_31698 = state_30093__$1;
(statearr_30102_31698[(2)] = inst_30083);

(statearr_30102_31698[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30094 === (9))){
var state_30093__$1 = state_30093;
var statearr_30103_31699 = state_30093__$1;
(statearr_30103_31699[(2)] = null);

(statearr_30103_31699[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30094 === (5))){
var inst_30076 = cljs.core.async.close_BANG_(out);
var state_30093__$1 = state_30093;
var statearr_30104_31700 = state_30093__$1;
(statearr_30104_31700[(2)] = inst_30076);

(statearr_30104_31700[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30094 === (10))){
var inst_30086 = (state_30093[(2)]);
var state_30093__$1 = (function (){var statearr_30105 = state_30093;
(statearr_30105[(8)] = inst_30086);

return statearr_30105;
})();
var statearr_30106_31701 = state_30093__$1;
(statearr_30106_31701[(2)] = null);

(statearr_30106_31701[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30094 === (8))){
var inst_30073 = (state_30093[(7)]);
var state_30093__$1 = state_30093;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30093__$1,(11),out,inst_30073);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28158__auto__ = null;
var cljs$core$async$state_machine__28158__auto____0 = (function (){
var statearr_30107 = [null,null,null,null,null,null,null,null,null];
(statearr_30107[(0)] = cljs$core$async$state_machine__28158__auto__);

(statearr_30107[(1)] = (1));

return statearr_30107;
});
var cljs$core$async$state_machine__28158__auto____1 = (function (state_30093){
while(true){
var ret_value__28159__auto__ = (function (){try{while(true){
var result__28160__auto__ = switch__28157__auto__(state_30093);
if(cljs.core.keyword_identical_QMARK_(result__28160__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28160__auto__;
}
break;
}
}catch (e30108){if((e30108 instanceof Object)){
var ex__28161__auto__ = e30108;
var statearr_30109_31702 = state_30093;
(statearr_30109_31702[(5)] = ex__28161__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30093);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30108;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28159__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31703 = state_30093;
state_30093 = G__31703;
continue;
} else {
return ret_value__28159__auto__;
}
break;
}
});
cljs$core$async$state_machine__28158__auto__ = function(state_30093){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28158__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28158__auto____1.call(this,state_30093);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28158__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28158__auto____0;
cljs$core$async$state_machine__28158__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28158__auto____1;
return cljs$core$async$state_machine__28158__auto__;
})()
})();
var state__28358__auto__ = (function (){var statearr_30110 = f__28357__auto__();
(statearr_30110[(6)] = c__28356__auto___31691);

return statearr_30110;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28358__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__30112 = arguments.length;
switch (G__30112) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__28356__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28357__auto__ = (function (){var switch__28157__auto__ = (function (state_30174){
var state_val_30175 = (state_30174[(1)]);
if((state_val_30175 === (7))){
var inst_30170 = (state_30174[(2)]);
var state_30174__$1 = state_30174;
var statearr_30176_31705 = state_30174__$1;
(statearr_30176_31705[(2)] = inst_30170);

(statearr_30176_31705[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30175 === (20))){
var inst_30140 = (state_30174[(7)]);
var inst_30151 = (state_30174[(2)]);
var inst_30152 = cljs.core.next(inst_30140);
var inst_30126 = inst_30152;
var inst_30127 = null;
var inst_30128 = (0);
var inst_30129 = (0);
var state_30174__$1 = (function (){var statearr_30177 = state_30174;
(statearr_30177[(8)] = inst_30129);

(statearr_30177[(9)] = inst_30128);

(statearr_30177[(10)] = inst_30126);

(statearr_30177[(11)] = inst_30151);

(statearr_30177[(12)] = inst_30127);

return statearr_30177;
})();
var statearr_30178_31706 = state_30174__$1;
(statearr_30178_31706[(2)] = null);

(statearr_30178_31706[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30175 === (1))){
var state_30174__$1 = state_30174;
var statearr_30179_31707 = state_30174__$1;
(statearr_30179_31707[(2)] = null);

(statearr_30179_31707[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30175 === (4))){
var inst_30115 = (state_30174[(13)]);
var inst_30115__$1 = (state_30174[(2)]);
var inst_30116 = (inst_30115__$1 == null);
var state_30174__$1 = (function (){var statearr_30180 = state_30174;
(statearr_30180[(13)] = inst_30115__$1);

return statearr_30180;
})();
if(cljs.core.truth_(inst_30116)){
var statearr_30181_31708 = state_30174__$1;
(statearr_30181_31708[(1)] = (5));

} else {
var statearr_30182_31709 = state_30174__$1;
(statearr_30182_31709[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30175 === (15))){
var state_30174__$1 = state_30174;
var statearr_30186_31710 = state_30174__$1;
(statearr_30186_31710[(2)] = null);

(statearr_30186_31710[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30175 === (21))){
var state_30174__$1 = state_30174;
var statearr_30187_31711 = state_30174__$1;
(statearr_30187_31711[(2)] = null);

(statearr_30187_31711[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30175 === (13))){
var inst_30129 = (state_30174[(8)]);
var inst_30128 = (state_30174[(9)]);
var inst_30126 = (state_30174[(10)]);
var inst_30127 = (state_30174[(12)]);
var inst_30136 = (state_30174[(2)]);
var inst_30137 = (inst_30129 + (1));
var tmp30183 = inst_30128;
var tmp30184 = inst_30126;
var tmp30185 = inst_30127;
var inst_30126__$1 = tmp30184;
var inst_30127__$1 = tmp30185;
var inst_30128__$1 = tmp30183;
var inst_30129__$1 = inst_30137;
var state_30174__$1 = (function (){var statearr_30188 = state_30174;
(statearr_30188[(14)] = inst_30136);

(statearr_30188[(8)] = inst_30129__$1);

(statearr_30188[(9)] = inst_30128__$1);

(statearr_30188[(10)] = inst_30126__$1);

(statearr_30188[(12)] = inst_30127__$1);

return statearr_30188;
})();
var statearr_30189_31712 = state_30174__$1;
(statearr_30189_31712[(2)] = null);

(statearr_30189_31712[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30175 === (22))){
var state_30174__$1 = state_30174;
var statearr_30190_31713 = state_30174__$1;
(statearr_30190_31713[(2)] = null);

(statearr_30190_31713[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30175 === (6))){
var inst_30115 = (state_30174[(13)]);
var inst_30124 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_30115) : f.call(null,inst_30115));
var inst_30125 = cljs.core.seq(inst_30124);
var inst_30126 = inst_30125;
var inst_30127 = null;
var inst_30128 = (0);
var inst_30129 = (0);
var state_30174__$1 = (function (){var statearr_30191 = state_30174;
(statearr_30191[(8)] = inst_30129);

(statearr_30191[(9)] = inst_30128);

(statearr_30191[(10)] = inst_30126);

(statearr_30191[(12)] = inst_30127);

return statearr_30191;
})();
var statearr_30192_31714 = state_30174__$1;
(statearr_30192_31714[(2)] = null);

(statearr_30192_31714[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30175 === (17))){
var inst_30140 = (state_30174[(7)]);
var inst_30144 = cljs.core.chunk_first(inst_30140);
var inst_30145 = cljs.core.chunk_rest(inst_30140);
var inst_30146 = cljs.core.count(inst_30144);
var inst_30126 = inst_30145;
var inst_30127 = inst_30144;
var inst_30128 = inst_30146;
var inst_30129 = (0);
var state_30174__$1 = (function (){var statearr_30193 = state_30174;
(statearr_30193[(8)] = inst_30129);

(statearr_30193[(9)] = inst_30128);

(statearr_30193[(10)] = inst_30126);

(statearr_30193[(12)] = inst_30127);

return statearr_30193;
})();
var statearr_30194_31715 = state_30174__$1;
(statearr_30194_31715[(2)] = null);

(statearr_30194_31715[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30175 === (3))){
var inst_30172 = (state_30174[(2)]);
var state_30174__$1 = state_30174;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30174__$1,inst_30172);
} else {
if((state_val_30175 === (12))){
var inst_30160 = (state_30174[(2)]);
var state_30174__$1 = state_30174;
var statearr_30195_31716 = state_30174__$1;
(statearr_30195_31716[(2)] = inst_30160);

(statearr_30195_31716[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30175 === (2))){
var state_30174__$1 = state_30174;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30174__$1,(4),in$);
} else {
if((state_val_30175 === (23))){
var inst_30168 = (state_30174[(2)]);
var state_30174__$1 = state_30174;
var statearr_30196_31717 = state_30174__$1;
(statearr_30196_31717[(2)] = inst_30168);

(statearr_30196_31717[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30175 === (19))){
var inst_30155 = (state_30174[(2)]);
var state_30174__$1 = state_30174;
var statearr_30197_31718 = state_30174__$1;
(statearr_30197_31718[(2)] = inst_30155);

(statearr_30197_31718[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30175 === (11))){
var inst_30126 = (state_30174[(10)]);
var inst_30140 = (state_30174[(7)]);
var inst_30140__$1 = cljs.core.seq(inst_30126);
var state_30174__$1 = (function (){var statearr_30198 = state_30174;
(statearr_30198[(7)] = inst_30140__$1);

return statearr_30198;
})();
if(inst_30140__$1){
var statearr_30199_31719 = state_30174__$1;
(statearr_30199_31719[(1)] = (14));

} else {
var statearr_30200_31720 = state_30174__$1;
(statearr_30200_31720[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30175 === (9))){
var inst_30162 = (state_30174[(2)]);
var inst_30163 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_30174__$1 = (function (){var statearr_30201 = state_30174;
(statearr_30201[(15)] = inst_30162);

return statearr_30201;
})();
if(cljs.core.truth_(inst_30163)){
var statearr_30202_31721 = state_30174__$1;
(statearr_30202_31721[(1)] = (21));

} else {
var statearr_30203_31722 = state_30174__$1;
(statearr_30203_31722[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30175 === (5))){
var inst_30118 = cljs.core.async.close_BANG_(out);
var state_30174__$1 = state_30174;
var statearr_30204_31723 = state_30174__$1;
(statearr_30204_31723[(2)] = inst_30118);

(statearr_30204_31723[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30175 === (14))){
var inst_30140 = (state_30174[(7)]);
var inst_30142 = cljs.core.chunked_seq_QMARK_(inst_30140);
var state_30174__$1 = state_30174;
if(inst_30142){
var statearr_30205_31724 = state_30174__$1;
(statearr_30205_31724[(1)] = (17));

} else {
var statearr_30206_31725 = state_30174__$1;
(statearr_30206_31725[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30175 === (16))){
var inst_30158 = (state_30174[(2)]);
var state_30174__$1 = state_30174;
var statearr_30207_31726 = state_30174__$1;
(statearr_30207_31726[(2)] = inst_30158);

(statearr_30207_31726[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30175 === (10))){
var inst_30129 = (state_30174[(8)]);
var inst_30127 = (state_30174[(12)]);
var inst_30134 = cljs.core._nth(inst_30127,inst_30129);
var state_30174__$1 = state_30174;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30174__$1,(13),out,inst_30134);
} else {
if((state_val_30175 === (18))){
var inst_30140 = (state_30174[(7)]);
var inst_30149 = cljs.core.first(inst_30140);
var state_30174__$1 = state_30174;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30174__$1,(20),out,inst_30149);
} else {
if((state_val_30175 === (8))){
var inst_30129 = (state_30174[(8)]);
var inst_30128 = (state_30174[(9)]);
var inst_30131 = (inst_30129 < inst_30128);
var inst_30132 = inst_30131;
var state_30174__$1 = state_30174;
if(cljs.core.truth_(inst_30132)){
var statearr_30208_31727 = state_30174__$1;
(statearr_30208_31727[(1)] = (10));

} else {
var statearr_30209_31728 = state_30174__$1;
(statearr_30209_31728[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__28158__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__28158__auto____0 = (function (){
var statearr_30210 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30210[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__28158__auto__);

(statearr_30210[(1)] = (1));

return statearr_30210;
});
var cljs$core$async$mapcat_STAR__$_state_machine__28158__auto____1 = (function (state_30174){
while(true){
var ret_value__28159__auto__ = (function (){try{while(true){
var result__28160__auto__ = switch__28157__auto__(state_30174);
if(cljs.core.keyword_identical_QMARK_(result__28160__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28160__auto__;
}
break;
}
}catch (e30211){if((e30211 instanceof Object)){
var ex__28161__auto__ = e30211;
var statearr_30212_31729 = state_30174;
(statearr_30212_31729[(5)] = ex__28161__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30174);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30211;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28159__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31730 = state_30174;
state_30174 = G__31730;
continue;
} else {
return ret_value__28159__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__28158__auto__ = function(state_30174){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__28158__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__28158__auto____1.call(this,state_30174);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__28158__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__28158__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__28158__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__28158__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__28158__auto__;
})()
})();
var state__28358__auto__ = (function (){var statearr_30213 = f__28357__auto__();
(statearr_30213[(6)] = c__28356__auto__);

return statearr_30213;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28358__auto__);
}));

return c__28356__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__30215 = arguments.length;
switch (G__30215) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__30217 = arguments.length;
switch (G__30217) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__30219 = arguments.length;
switch (G__30219) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28356__auto___31734 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28357__auto__ = (function (){var switch__28157__auto__ = (function (state_30243){
var state_val_30244 = (state_30243[(1)]);
if((state_val_30244 === (7))){
var inst_30238 = (state_30243[(2)]);
var state_30243__$1 = state_30243;
var statearr_30245_31735 = state_30243__$1;
(statearr_30245_31735[(2)] = inst_30238);

(statearr_30245_31735[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30244 === (1))){
var inst_30220 = null;
var state_30243__$1 = (function (){var statearr_30246 = state_30243;
(statearr_30246[(7)] = inst_30220);

return statearr_30246;
})();
var statearr_30247_31736 = state_30243__$1;
(statearr_30247_31736[(2)] = null);

(statearr_30247_31736[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30244 === (4))){
var inst_30223 = (state_30243[(8)]);
var inst_30223__$1 = (state_30243[(2)]);
var inst_30224 = (inst_30223__$1 == null);
var inst_30225 = cljs.core.not(inst_30224);
var state_30243__$1 = (function (){var statearr_30248 = state_30243;
(statearr_30248[(8)] = inst_30223__$1);

return statearr_30248;
})();
if(inst_30225){
var statearr_30249_31737 = state_30243__$1;
(statearr_30249_31737[(1)] = (5));

} else {
var statearr_30250_31738 = state_30243__$1;
(statearr_30250_31738[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30244 === (6))){
var state_30243__$1 = state_30243;
var statearr_30251_31739 = state_30243__$1;
(statearr_30251_31739[(2)] = null);

(statearr_30251_31739[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30244 === (3))){
var inst_30240 = (state_30243[(2)]);
var inst_30241 = cljs.core.async.close_BANG_(out);
var state_30243__$1 = (function (){var statearr_30252 = state_30243;
(statearr_30252[(9)] = inst_30240);

return statearr_30252;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_30243__$1,inst_30241);
} else {
if((state_val_30244 === (2))){
var state_30243__$1 = state_30243;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30243__$1,(4),ch);
} else {
if((state_val_30244 === (11))){
var inst_30223 = (state_30243[(8)]);
var inst_30232 = (state_30243[(2)]);
var inst_30220 = inst_30223;
var state_30243__$1 = (function (){var statearr_30253 = state_30243;
(statearr_30253[(10)] = inst_30232);

(statearr_30253[(7)] = inst_30220);

return statearr_30253;
})();
var statearr_30254_31740 = state_30243__$1;
(statearr_30254_31740[(2)] = null);

(statearr_30254_31740[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30244 === (9))){
var inst_30223 = (state_30243[(8)]);
var state_30243__$1 = state_30243;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30243__$1,(11),out,inst_30223);
} else {
if((state_val_30244 === (5))){
var inst_30223 = (state_30243[(8)]);
var inst_30220 = (state_30243[(7)]);
var inst_30227 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_30223,inst_30220);
var state_30243__$1 = state_30243;
if(inst_30227){
var statearr_30256_31741 = state_30243__$1;
(statearr_30256_31741[(1)] = (8));

} else {
var statearr_30257_31742 = state_30243__$1;
(statearr_30257_31742[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30244 === (10))){
var inst_30235 = (state_30243[(2)]);
var state_30243__$1 = state_30243;
var statearr_30258_31743 = state_30243__$1;
(statearr_30258_31743[(2)] = inst_30235);

(statearr_30258_31743[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30244 === (8))){
var inst_30220 = (state_30243[(7)]);
var tmp30255 = inst_30220;
var inst_30220__$1 = tmp30255;
var state_30243__$1 = (function (){var statearr_30259 = state_30243;
(statearr_30259[(7)] = inst_30220__$1);

return statearr_30259;
})();
var statearr_30260_31744 = state_30243__$1;
(statearr_30260_31744[(2)] = null);

(statearr_30260_31744[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28158__auto__ = null;
var cljs$core$async$state_machine__28158__auto____0 = (function (){
var statearr_30261 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_30261[(0)] = cljs$core$async$state_machine__28158__auto__);

(statearr_30261[(1)] = (1));

return statearr_30261;
});
var cljs$core$async$state_machine__28158__auto____1 = (function (state_30243){
while(true){
var ret_value__28159__auto__ = (function (){try{while(true){
var result__28160__auto__ = switch__28157__auto__(state_30243);
if(cljs.core.keyword_identical_QMARK_(result__28160__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28160__auto__;
}
break;
}
}catch (e30262){if((e30262 instanceof Object)){
var ex__28161__auto__ = e30262;
var statearr_30263_31745 = state_30243;
(statearr_30263_31745[(5)] = ex__28161__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30243);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30262;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28159__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31746 = state_30243;
state_30243 = G__31746;
continue;
} else {
return ret_value__28159__auto__;
}
break;
}
});
cljs$core$async$state_machine__28158__auto__ = function(state_30243){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28158__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28158__auto____1.call(this,state_30243);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28158__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28158__auto____0;
cljs$core$async$state_machine__28158__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28158__auto____1;
return cljs$core$async$state_machine__28158__auto__;
})()
})();
var state__28358__auto__ = (function (){var statearr_30264 = f__28357__auto__();
(statearr_30264[(6)] = c__28356__auto___31734);

return statearr_30264;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28358__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__30266 = arguments.length;
switch (G__30266) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28356__auto___31748 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28357__auto__ = (function (){var switch__28157__auto__ = (function (state_30304){
var state_val_30305 = (state_30304[(1)]);
if((state_val_30305 === (7))){
var inst_30300 = (state_30304[(2)]);
var state_30304__$1 = state_30304;
var statearr_30306_31749 = state_30304__$1;
(statearr_30306_31749[(2)] = inst_30300);

(statearr_30306_31749[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30305 === (1))){
var inst_30267 = (new Array(n));
var inst_30268 = inst_30267;
var inst_30269 = (0);
var state_30304__$1 = (function (){var statearr_30307 = state_30304;
(statearr_30307[(7)] = inst_30269);

(statearr_30307[(8)] = inst_30268);

return statearr_30307;
})();
var statearr_30308_31750 = state_30304__$1;
(statearr_30308_31750[(2)] = null);

(statearr_30308_31750[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30305 === (4))){
var inst_30272 = (state_30304[(9)]);
var inst_30272__$1 = (state_30304[(2)]);
var inst_30273 = (inst_30272__$1 == null);
var inst_30274 = cljs.core.not(inst_30273);
var state_30304__$1 = (function (){var statearr_30309 = state_30304;
(statearr_30309[(9)] = inst_30272__$1);

return statearr_30309;
})();
if(inst_30274){
var statearr_30310_31751 = state_30304__$1;
(statearr_30310_31751[(1)] = (5));

} else {
var statearr_30311_31752 = state_30304__$1;
(statearr_30311_31752[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30305 === (15))){
var inst_30294 = (state_30304[(2)]);
var state_30304__$1 = state_30304;
var statearr_30312_31753 = state_30304__$1;
(statearr_30312_31753[(2)] = inst_30294);

(statearr_30312_31753[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30305 === (13))){
var state_30304__$1 = state_30304;
var statearr_30313_31754 = state_30304__$1;
(statearr_30313_31754[(2)] = null);

(statearr_30313_31754[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30305 === (6))){
var inst_30269 = (state_30304[(7)]);
var inst_30290 = (inst_30269 > (0));
var state_30304__$1 = state_30304;
if(cljs.core.truth_(inst_30290)){
var statearr_30314_31755 = state_30304__$1;
(statearr_30314_31755[(1)] = (12));

} else {
var statearr_30315_31756 = state_30304__$1;
(statearr_30315_31756[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30305 === (3))){
var inst_30302 = (state_30304[(2)]);
var state_30304__$1 = state_30304;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30304__$1,inst_30302);
} else {
if((state_val_30305 === (12))){
var inst_30268 = (state_30304[(8)]);
var inst_30292 = cljs.core.vec(inst_30268);
var state_30304__$1 = state_30304;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30304__$1,(15),out,inst_30292);
} else {
if((state_val_30305 === (2))){
var state_30304__$1 = state_30304;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30304__$1,(4),ch);
} else {
if((state_val_30305 === (11))){
var inst_30284 = (state_30304[(2)]);
var inst_30285 = (new Array(n));
var inst_30268 = inst_30285;
var inst_30269 = (0);
var state_30304__$1 = (function (){var statearr_30316 = state_30304;
(statearr_30316[(7)] = inst_30269);

(statearr_30316[(8)] = inst_30268);

(statearr_30316[(10)] = inst_30284);

return statearr_30316;
})();
var statearr_30317_31757 = state_30304__$1;
(statearr_30317_31757[(2)] = null);

(statearr_30317_31757[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30305 === (9))){
var inst_30268 = (state_30304[(8)]);
var inst_30282 = cljs.core.vec(inst_30268);
var state_30304__$1 = state_30304;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30304__$1,(11),out,inst_30282);
} else {
if((state_val_30305 === (5))){
var inst_30277 = (state_30304[(11)]);
var inst_30269 = (state_30304[(7)]);
var inst_30272 = (state_30304[(9)]);
var inst_30268 = (state_30304[(8)]);
var inst_30276 = (inst_30268[inst_30269] = inst_30272);
var inst_30277__$1 = (inst_30269 + (1));
var inst_30278 = (inst_30277__$1 < n);
var state_30304__$1 = (function (){var statearr_30318 = state_30304;
(statearr_30318[(11)] = inst_30277__$1);

(statearr_30318[(12)] = inst_30276);

return statearr_30318;
})();
if(cljs.core.truth_(inst_30278)){
var statearr_30319_31758 = state_30304__$1;
(statearr_30319_31758[(1)] = (8));

} else {
var statearr_30320_31759 = state_30304__$1;
(statearr_30320_31759[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30305 === (14))){
var inst_30297 = (state_30304[(2)]);
var inst_30298 = cljs.core.async.close_BANG_(out);
var state_30304__$1 = (function (){var statearr_30322 = state_30304;
(statearr_30322[(13)] = inst_30297);

return statearr_30322;
})();
var statearr_30323_31760 = state_30304__$1;
(statearr_30323_31760[(2)] = inst_30298);

(statearr_30323_31760[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30305 === (10))){
var inst_30288 = (state_30304[(2)]);
var state_30304__$1 = state_30304;
var statearr_30324_31761 = state_30304__$1;
(statearr_30324_31761[(2)] = inst_30288);

(statearr_30324_31761[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30305 === (8))){
var inst_30277 = (state_30304[(11)]);
var inst_30268 = (state_30304[(8)]);
var tmp30321 = inst_30268;
var inst_30268__$1 = tmp30321;
var inst_30269 = inst_30277;
var state_30304__$1 = (function (){var statearr_30325 = state_30304;
(statearr_30325[(7)] = inst_30269);

(statearr_30325[(8)] = inst_30268__$1);

return statearr_30325;
})();
var statearr_30326_31762 = state_30304__$1;
(statearr_30326_31762[(2)] = null);

(statearr_30326_31762[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28158__auto__ = null;
var cljs$core$async$state_machine__28158__auto____0 = (function (){
var statearr_30327 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30327[(0)] = cljs$core$async$state_machine__28158__auto__);

(statearr_30327[(1)] = (1));

return statearr_30327;
});
var cljs$core$async$state_machine__28158__auto____1 = (function (state_30304){
while(true){
var ret_value__28159__auto__ = (function (){try{while(true){
var result__28160__auto__ = switch__28157__auto__(state_30304);
if(cljs.core.keyword_identical_QMARK_(result__28160__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28160__auto__;
}
break;
}
}catch (e30328){if((e30328 instanceof Object)){
var ex__28161__auto__ = e30328;
var statearr_30329_31763 = state_30304;
(statearr_30329_31763[(5)] = ex__28161__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30304);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30328;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28159__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31764 = state_30304;
state_30304 = G__31764;
continue;
} else {
return ret_value__28159__auto__;
}
break;
}
});
cljs$core$async$state_machine__28158__auto__ = function(state_30304){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28158__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28158__auto____1.call(this,state_30304);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28158__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28158__auto____0;
cljs$core$async$state_machine__28158__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28158__auto____1;
return cljs$core$async$state_machine__28158__auto__;
})()
})();
var state__28358__auto__ = (function (){var statearr_30330 = f__28357__auto__();
(statearr_30330[(6)] = c__28356__auto___31748);

return statearr_30330;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28358__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__30332 = arguments.length;
switch (G__30332) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28356__auto___31766 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28357__auto__ = (function (){var switch__28157__auto__ = (function (state_30374){
var state_val_30375 = (state_30374[(1)]);
if((state_val_30375 === (7))){
var inst_30370 = (state_30374[(2)]);
var state_30374__$1 = state_30374;
var statearr_30381_31767 = state_30374__$1;
(statearr_30381_31767[(2)] = inst_30370);

(statearr_30381_31767[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30375 === (1))){
var inst_30333 = [];
var inst_30334 = inst_30333;
var inst_30335 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_30374__$1 = (function (){var statearr_30382 = state_30374;
(statearr_30382[(7)] = inst_30335);

(statearr_30382[(8)] = inst_30334);

return statearr_30382;
})();
var statearr_30383_31768 = state_30374__$1;
(statearr_30383_31768[(2)] = null);

(statearr_30383_31768[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30375 === (4))){
var inst_30338 = (state_30374[(9)]);
var inst_30338__$1 = (state_30374[(2)]);
var inst_30339 = (inst_30338__$1 == null);
var inst_30340 = cljs.core.not(inst_30339);
var state_30374__$1 = (function (){var statearr_30384 = state_30374;
(statearr_30384[(9)] = inst_30338__$1);

return statearr_30384;
})();
if(inst_30340){
var statearr_30385_31769 = state_30374__$1;
(statearr_30385_31769[(1)] = (5));

} else {
var statearr_30386_31770 = state_30374__$1;
(statearr_30386_31770[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30375 === (15))){
var inst_30364 = (state_30374[(2)]);
var state_30374__$1 = state_30374;
var statearr_30387_31771 = state_30374__$1;
(statearr_30387_31771[(2)] = inst_30364);

(statearr_30387_31771[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30375 === (13))){
var state_30374__$1 = state_30374;
var statearr_30388_31772 = state_30374__$1;
(statearr_30388_31772[(2)] = null);

(statearr_30388_31772[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30375 === (6))){
var inst_30334 = (state_30374[(8)]);
var inst_30359 = inst_30334.length;
var inst_30360 = (inst_30359 > (0));
var state_30374__$1 = state_30374;
if(cljs.core.truth_(inst_30360)){
var statearr_30389_31773 = state_30374__$1;
(statearr_30389_31773[(1)] = (12));

} else {
var statearr_30390_31774 = state_30374__$1;
(statearr_30390_31774[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30375 === (3))){
var inst_30372 = (state_30374[(2)]);
var state_30374__$1 = state_30374;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30374__$1,inst_30372);
} else {
if((state_val_30375 === (12))){
var inst_30334 = (state_30374[(8)]);
var inst_30362 = cljs.core.vec(inst_30334);
var state_30374__$1 = state_30374;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30374__$1,(15),out,inst_30362);
} else {
if((state_val_30375 === (2))){
var state_30374__$1 = state_30374;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30374__$1,(4),ch);
} else {
if((state_val_30375 === (11))){
var inst_30342 = (state_30374[(10)]);
var inst_30338 = (state_30374[(9)]);
var inst_30352 = (state_30374[(2)]);
var inst_30353 = [];
var inst_30354 = inst_30353.push(inst_30338);
var inst_30334 = inst_30353;
var inst_30335 = inst_30342;
var state_30374__$1 = (function (){var statearr_30391 = state_30374;
(statearr_30391[(7)] = inst_30335);

(statearr_30391[(11)] = inst_30354);

(statearr_30391[(8)] = inst_30334);

(statearr_30391[(12)] = inst_30352);

return statearr_30391;
})();
var statearr_30392_31775 = state_30374__$1;
(statearr_30392_31775[(2)] = null);

(statearr_30392_31775[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30375 === (9))){
var inst_30334 = (state_30374[(8)]);
var inst_30350 = cljs.core.vec(inst_30334);
var state_30374__$1 = state_30374;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30374__$1,(11),out,inst_30350);
} else {
if((state_val_30375 === (5))){
var inst_30335 = (state_30374[(7)]);
var inst_30342 = (state_30374[(10)]);
var inst_30338 = (state_30374[(9)]);
var inst_30342__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_30338) : f.call(null,inst_30338));
var inst_30343 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_30342__$1,inst_30335);
var inst_30344 = cljs.core.keyword_identical_QMARK_(inst_30335,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_30345 = ((inst_30343) || (inst_30344));
var state_30374__$1 = (function (){var statearr_30393 = state_30374;
(statearr_30393[(10)] = inst_30342__$1);

return statearr_30393;
})();
if(cljs.core.truth_(inst_30345)){
var statearr_30394_31776 = state_30374__$1;
(statearr_30394_31776[(1)] = (8));

} else {
var statearr_30395_31777 = state_30374__$1;
(statearr_30395_31777[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30375 === (14))){
var inst_30367 = (state_30374[(2)]);
var inst_30368 = cljs.core.async.close_BANG_(out);
var state_30374__$1 = (function (){var statearr_30397 = state_30374;
(statearr_30397[(13)] = inst_30367);

return statearr_30397;
})();
var statearr_30398_31778 = state_30374__$1;
(statearr_30398_31778[(2)] = inst_30368);

(statearr_30398_31778[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30375 === (10))){
var inst_30357 = (state_30374[(2)]);
var state_30374__$1 = state_30374;
var statearr_30399_31779 = state_30374__$1;
(statearr_30399_31779[(2)] = inst_30357);

(statearr_30399_31779[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30375 === (8))){
var inst_30342 = (state_30374[(10)]);
var inst_30338 = (state_30374[(9)]);
var inst_30334 = (state_30374[(8)]);
var inst_30347 = inst_30334.push(inst_30338);
var tmp30396 = inst_30334;
var inst_30334__$1 = tmp30396;
var inst_30335 = inst_30342;
var state_30374__$1 = (function (){var statearr_30400 = state_30374;
(statearr_30400[(7)] = inst_30335);

(statearr_30400[(8)] = inst_30334__$1);

(statearr_30400[(14)] = inst_30347);

return statearr_30400;
})();
var statearr_30401_31780 = state_30374__$1;
(statearr_30401_31780[(2)] = null);

(statearr_30401_31780[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28158__auto__ = null;
var cljs$core$async$state_machine__28158__auto____0 = (function (){
var statearr_30402 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30402[(0)] = cljs$core$async$state_machine__28158__auto__);

(statearr_30402[(1)] = (1));

return statearr_30402;
});
var cljs$core$async$state_machine__28158__auto____1 = (function (state_30374){
while(true){
var ret_value__28159__auto__ = (function (){try{while(true){
var result__28160__auto__ = switch__28157__auto__(state_30374);
if(cljs.core.keyword_identical_QMARK_(result__28160__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28160__auto__;
}
break;
}
}catch (e30403){if((e30403 instanceof Object)){
var ex__28161__auto__ = e30403;
var statearr_30404_31781 = state_30374;
(statearr_30404_31781[(5)] = ex__28161__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30374);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30403;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28159__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31782 = state_30374;
state_30374 = G__31782;
continue;
} else {
return ret_value__28159__auto__;
}
break;
}
});
cljs$core$async$state_machine__28158__auto__ = function(state_30374){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28158__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28158__auto____1.call(this,state_30374);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28158__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28158__auto____0;
cljs$core$async$state_machine__28158__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28158__auto____1;
return cljs$core$async$state_machine__28158__auto__;
})()
})();
var state__28358__auto__ = (function (){var statearr_30405 = f__28357__auto__();
(statearr_30405[(6)] = c__28356__auto___31766);

return statearr_30405;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28358__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
