(ns ingestion.api.client.connector-template
  (:require  [cheshire.core :as json]
             [ksql.gen.reader.file-reader :as fr]))


(defn as-tempalte-name [v]
  (-> (.toString (.getFileName (.toPath v)))
      (clojure.string/split  #"\.")
      (first)
      )
  )


(defn get-default-connector-template-m []

  (let [grammar-matcher (.getPathMatcher
                          (java.nio.file.FileSystems/getDefault)
                          "glob:*.{json}")
        template-m {"es_sink" "template/es_sink.json"
                    "file_sink" "template/file_sink.json"
                    "jdbc_sql_sink" "template/jdbc_sql_sink.json"
                    "spooldir_csv_source" "template/spooldir_csv_source.json"
                    "blob_sink" "template/blob_sink.json"
                    "blob_source" "template/blob_source.json"
                    }]
    (into {} (map (fn [w ]
                    [(first w)
                     (-> (second w)
                         (clojure.java.io/resource)
                         (slurp)
                         (json/parse-string  true)
                         )
                     ]
                    )) template-m )

    #_(->> "template"
         clojure.java.io/resource
         clojure.java.io/file
         file-seq
         (filter #(.isFile %))
         (filter #(.matches grammar-matcher (.getFileName (.toPath %))))

         (mapv (fn [v]
                 [(as-tempalte-name v)
                  (json/parse-string (slurp v) true)
                  ]
                 )  )

         (into {})
         ))
  )

(comment

  (get-default-connector-template-m)

  (clojure.string/split "test.t" #"\.")

  (fr/get-all-file-name "config" "glob:*.{json}")


  )

#_(defn get-default-connector-template-m []

  (into {} (comp (map (fn [[k v]]
                        [(first (clojure.string/split k #"\."))

                         ]

                        ))) (get-template) )

  #_{"spooldir_csv_source" (json/parse-string "{\n  \"name\": \"claims-source\",\n  \"config\": {\n    \"tasks.max\": \"1\",\n    \"connector.class\": \"com.github.jcustenborder.kafka.connect.spooldir.SpoolDirCsvSourceConnector\",\n    \"input.file.pattern\": \"^claims.*.csv$\",\n    \"input.path\": \"/app/demo2/data/source\",\n    \"finished.path\": \"/app/demo2/data/finished\",\n    \"error.path\": \"/app/demo2/data/error\",\n    \"halt.on.error\": \"false\",\n    \"topic\": \"claims\",\n    \"value.schema\": \"\",\n    \"key.schema\": \"\",\n    \"csv.first.row.as.header\": \"true\",\n    \"csv.separator.char\": 59,\n    \"csv.file.charset\": \"ISO-8859-1\"\n  }\n}\n" true)
   "jdbc_sql_sink" (json/parse-string  "{\n  \"name\": \"*-sink\",\n  \"config\": {\n    \"connector.class\": \"io.confluent.connect.jdbc.JdbcSinkConnector\",\n    \"tasks.max\": \"1\",\n    \"topics\": \"\",\n    \"key.converter\": \"org.apache.kafka.connect.storage.StringConverter\",\n    \"value.converter\": \"io.confluent.connect.avro.AvroConverter\",\n    \"value.converter.schema.registry.url\": \"http://schema-registry:8081\",\n    \"connection.url\": \"jdbc:postgresql://postgres:5432/dcp?user=admin&password=letmein&characterEncoding=ISO-8859-1\",\n    \"key.converter.schemas.enable\": \"false\",\n    \"value.converter.schemas.enable\": \"true\",\n    \"auto.create\": \"true\",\n    \"auto.evolve\": \"true\",\n    \"insert.mode\": \"upsert\",\n    \"pk.fields\": \"\",\n    \"pk.mode\": \"record_key\"\n  }\n}\n"  true)
   "file_sink" (json/parse-string "{\n  \"name\": \"\",\n  \"config\": {\n    \"connector.class\": \"org.apache.kafka.connect.file.FileStreamSinkConnector\",\n    \"file\": \"/app/demo2/data_backup/\",\n    \"topics\" : \"\"\n\n  }\n}" true)
   "es_sink"   (json/parse-string "{\n  \"name\": \"\",\n  \"config\": {\n    \"topics\": \"\",\n    \"key.converter\": \"org.apache.kafka.connect.storage.StringConverter\",\n    \"value.converter\": \"io.confluent.connect.avro.AvroConverter\",\n    \"value.converter.schema.registry.url\": \"http://schema-registry:8081\",\n    \"value.converter.schemas.enable\": \"true\",\n    \"connector.class\": \"io.confluent.connect.elasticsearch.ElasticsearchSinkConnector\",\n    \"key.ignore\": \"true\",\n    \"schema.ignore\": \"true\",\n    \"type.name\": \"_doc\",\n    \"topic.index.map\": \"Test:test\",\n    \"connection.url\": \"http://elasticsearch:9200\",\n    \"transforms\": \"ExtractTimestamp\",\n    \"transforms.ExtractTimestamp.type\": \"org.apache.kafka.connect.transforms.InsertField$Value\",\n    \"transforms.ExtractTimestamp.timestamp.field\": \"EXTRACT_TS\",\n    \"transforms.routeTS.timestamp.format\":\"YYYYMMDD\",\n    \"behavior.on.null.values\": \"delete\"\n  }\n}" true)
   }


  )