(ns ingestion.api.client.dataflow-connector-api
  (:require [ingestion.api.client.ns-repo-impl :as core]
            [ksql.gen.protocol :as p]
            [ksqldb.client :as client]
            [ksql.gen.reader.mapping-reader :as md]
            [clojure.tools.logging :as log]
            [cheshire.core :as json]
            [ksql.gen.connector.core :as cc]
            [ksql.gen-connector :as conn]))



(defmethod p/invoke "df-conn-template-update"
  [{:keys [request]}]
  (let [n (get request "template-name")
        _ (when (or (nil? n)
                    (clojure.string/blank? n))
            (throw (ex-info "connector template name will not be null" {:connector-config-name n})))

        template (get request "template")
        _ (when (or (nil? template)
                    (clojure.string/blank? template))
            (throw (ex-info "connector template name will not be null" {:connector-config template})))
        template (json/parse-string template true)]

    (-> (core/get-context)
        (update :connector-template-m (fn [config-m]
                                        (swap! config-m (fn [m] (merge m {n template}))))))
    {:status "ok"}))


(defmethod p/invoke "df-conn-template"
  [{:keys [request]}]
  (let [n (get request "template-name")
        _ (when (or (nil? n)
                    (clojure.string/blank? n))
            (throw (ex-info "connector template name will not be null" {:connector-config-name n
                                                                        :e-error-des           "connector template name will not be null"
                                                                        })))
        m @(get (core/get-context) :connector-template-m)
        out (get m n "")
        out (json/generate-string (clojure.walk/stringify-keys out) {:pretty true})
        ]
    out
    ))


(defmethod p/invoke "df-conn-template-names"
  [{:keys [request]}]
  (let [m @(get (core/get-context) :connector-template-m)]
    (keys m)))



(defmethod p/invoke "df-conn-mapping-update"
  [{:keys [request]}]
  (let [
        ;m @(get (core/get-context) :connector-template-m)
       ; ans-name (get request "ans-name")
    ;    mapping (get request "mapping")
        ]

    (update (core/get-context) :connector-mapping-m (fn [v] (reset! v request ) #_(swap! v (fn [m]
                                                             (assoc m app-ns-name mapping)
                                                             ))))
    {:status "ok"}))



(defmethod p/invoke "df-conn-mapping"
  [{:keys [request]}]
  (let [
        ;ans-name (get request "ans-name")
        ]
    (-> @(get (core/get-context) :connector-mapping-m)
        )))


(defmethod p/invoke "df-api-playground-update"
  [{:keys [request]}]
  (let [
        ;m @(get (core/get-context) :connector-template-m)
        ; ans-name (get request "ans-name")
        ;mapping (get request "mapping")
        ]

    (update (core/get-context) :api-playground-v (fn [v] (reset! v request ) #_(swap! v (fn [m]
                                                                                             (assoc m app-ns-name mapping)
                                                                                             ))))
    {:status "ok"}))



(defmethod p/invoke "df-df-api-playground"
  [{:keys [request]}]
  (let [
        ;ans-name (get request "ans-name")
        ]
    (-> @(get (core/get-context) :api-playground-v)
        )))




#_(defmethod p/invoke "df-conn-mapping-names"
  [{:keys [request]}]
  (let []
    #_(when (or (nil? app-ns-name)
                (clojure.string/blank? app-ns-name))
        (throw (ex-info "mapping name will not be null" {:app-ns-name app-ns-name
                                                         :e-error-des  "mapping name will not be null"})))
    (-> @(get (core/get-context) :connector-mapping-m)
        (keys)
        #_(get app-ns-name ""))))








(defn find-delta-connection [context connector-coll]
  (let [remote-conn-set (into #{} (map :name) (client/invoke  "conn-show-connectors-status"))]
    (remove (fn [v] (contains? remote-conn-set (:name v))) connector-coll)))


(defmethod p/invoke "df-create-source-connector"
  [{:keys [request]}]
  ;(create-dataflow-by-source-mapping base-dir connector-mapping)
  (let [conn-coll (->> request
                       (conn/gen-source-connector-config p/context)
                       (find-delta-connection p/context))]
    ;(println "--" conn-coll)
    (when-not (empty? conn-coll)
      (log/info "Creating new connection")
      (p/invoke  {:op "conn-create-connector-batch" :request conn-coll} )
      #_(invoke-kafka "conn-create-connector-batch" conn-coll))))


#_(defmethod p/invoke "delete-source-connector"
    [context {:keys [request]}]
    (let [connector-name-list (conn/get-source-connector-names context request)]

      (doseq [connector-name connector-name-list]
        (client/invoke context "conn-delete-connector" connector-name)
        #_(invoke-kafka "conn-delete-connector" connector-name))))

;(defn p)


#_(defmethod p/invoke "pause-source-connector"
    [context {:keys [request]}]
    (let [
          connector-name-list (conn/get-source-connector-names context request)]
      (doseq [connector-name connector-name-list]
        (client/invoke context "conn-pause-connector" connector-name))))


#_(defmethod p/invoke "resume-source-connector"
    [context {:keys [request]}]
    (let [connector-name-list (conn/get-source-connector-names context request)]
      (doseq [connector-name connector-name-list]
        (client/invoke context "conn-resume-connector" connector-name))))


;(def create-source-connector gen/create-source-connector)
;(def delete-source-connector gen/delete-source-connector)
#_(defn create-sink-connector
    ([sink-mapping] (create-sink-connector "" sink-mapping))
    ([base-dir sink-mapping]
     (u/create-sink-connector context base-dir sink-mapping)))


(defmethod p/invoke "df-create-sink-connector"
  [{:keys [request]}]
  (let [
        conn-coll (conn/gen-sink-connector-config p/context request)

        ; req-coll (into others w)
        ;   conn-coll (crate-sink-connector-req connector-schema)
        ;   _ (  conn-coll)
        conn-coll (find-delta-connection p/context conn-coll)]

    ;(  w)
    ;(  create-sql-for-sink)
    ;(  sql-coll)

    #_(when-not (empty? ksql-coll)
        (let [ksql-coll (get-new-md-repo context ksql-coll)]
          (client/ksql-batch context ksql-coll)))
    (when-not (empty? conn-coll)
      (log/info "Creating new connection")
      ;(client/invoke context {:op "conn-create-connector-batch" :request conn-coll})
      (p/invoke  {:op "conn-create-connector-batch" :request conn-coll} ))))



(defmethod p/invoke "df-gen-sink-connector-config"
  [{:keys [request]}]
  (let [mapping request]
    (->> (conn/gen-sink-connector-config (core/get-context) mapping)
         (mapv json/generate-string))
    )
  )



(defmethod p/invoke "df-gen-source-connector-config"
  [{:keys [request]}]
  (let [mapping request]
    (->> (conn/gen-source-connector-config (core/get-context) mapping)
         (mapv json/generate-string))
    )
  )



(defn generate-connector-config [mapping-str]
  (let [mapping (md/read-request mapping-str)
        mapping (into [] (map (fn [v]
                                (if (symbol? v)
                                  (str v)
                                  v)
                                )) mapping )

        mapping (partition 4 mapping)

        {:keys [sink source]} (group-by (fn [[v]]
                                          (let [w (cc/get-template v)
                                                class-name (get-in w [:config :connector.class])
                                                _ (when (nil? class-name)
                                                    (throw (ex-info "connector class name not found in template " w)))
                                                class-name (clojure.string/lower-case class-name)]
                                            (if (clojure.string/ends-with? class-name "sinkconnector")
                                              :sink :source))
                                          ) mapping)

        source-out (conn/gen-source-connector-config (core/get-context) source)
        sink-out (conn/gen-sink-connector-config (core/get-context) sink)]
    (into source-out sink-out)
    )
  )


(defmethod p/invoke "df-gen-connector-config"
  [{:keys [request]}]
  (let [mapping-str (get request :mapping)
        pretty (get request :pretty false)
        out (generate-connector-config mapping-str)
        out (into [] (map (fn [v]
                            (json/generate-string v {:pretty pretty})
                            )) out  )

        ]
    out
    #_(into source-out sink-out)))



(defmethod p/invoke "df-create-connector"
  [ {:keys [request]}]
  (let [conn-coll (generate-connector-config request) #_(p/invoke  {:op "df-gen-connector-config" :request {:mapping request} })

        conn-coll (find-delta-connection p/context conn-coll)]
     ;(p/log-v conn-coll)
    (when-not (empty? conn-coll)
      (log/info "Creating new connection")
      (p/invoke  {:op "conn-create-connector-batch" :request conn-coll} ))))



(defmethod p/invoke "df-gen-dv-connector-mapping"
  [{:keys [request]}]
  (let [out (->> (p/get-md-schema-coll)
                 (into [] (comp (map :name)
                                (filter (fn [v] (or (clojure.string/ends-with? v "_hub")
                                                    (clojure.string/ends-with? v "_sat")
                                                    (clojure.string/ends-with? v "_link"))))
                                (map (fn [v]
                                       (cond
                                         (clojure.string/ends-with? v "_hub")
                                         [request v "hk" (str "h_" (clojure.string/replace v "_hub" ""))]
                                         (clojure.string/ends-with? v "_sat")
                                         [request v "gdp_hashdiff" (str "s_" (clojure.string/replace v "_sat" ""))]
                                         (clojure.string/ends-with? v "_link")
                                         [request v "lhk" (str "l_" (clojure.string/replace v "_link" ""))]
                                         :else
                                         nil)))

                                (remove nil?)
                                (map (fn [v] (clojure.string/join " " v) ))

                                ))
               ;  (p/log-v)
                 (clojure.string/join "\n")
                ; (p/log-v)

                 #_(hash-map :op "df-gen-connector-config" :request)
                 #_(p/invoke context)

                 )
        error_topic_name (str " jdbc_sql_sink "  (get (core/get-context) :error-stream-name ) " nil "  (get (core/get-context) :error-stream-name ))
        out (str out "\n" error_topic_name )
        ]
    out

    )
  )


#_(defmethod p/invoke "df-gen-dv-connector"
  [{:keys [request]}]
  (->> (p/get-md-schema-coll)
       (into [] (comp (map :name)
                      (filter (fn [v] (or (clojure.string/ends-with? v "_hub")
                                          (clojure.string/ends-with? v "_sat")
                                          (clojure.string/ends-with? v "_link"))))
                      (map (fn [v]
                             (cond
                               (clojure.string/ends-with? v "_hub")
                               [request v "hk" (str "h_" (clojure.string/replace v "_hub" ""))]
                               (clojure.string/ends-with? v "_sat")
                               [request v "gdp_hashdiff" (str "s_" (clojure.string/replace v "_sat" ""))]
                               (clojure.string/ends-with? v "_link")
                               [request v "lhk" (str "l_" (clojure.string/replace v "_link" ""))]
                               :else
                               nil)))
                      (remove nil?)))
       (hash-map :op "df-gen-connector-config" :request)
       (p/invoke )

       ))


