(ns ingestion.api.client.dataflow-mapping-api
  (:require [ksql.gen.protocol :as p]
            [ingestion.api.client.ns-repo-impl :as core]
            [ingestion.api.client.dataflow-mapping-gen-api :as mg]
            ))


(defmethod p/invoke "df-gen-mapping-by-file"
  [ {:keys [request]}]
  (mg/gen-mapping-by-file (get request :file-name) (get request :file)))


#_(defmethod p/invoke "df-mapping-update"
  [ {:keys [request]}]
  (p/reset-mapping! request)
  {:status "ok"})


(defmethod p/invoke "df-mapping"
  [{:keys [request]}]
  @(get p/context :mapping-v))


(defmethod p/invoke "df-md-repo"
  [ {:keys [request]}]
  (p/get-md-schema-coll)
  #_(let [schema-list (p/get-md-schema-coll)
        n request]
    (reduce (fn [acc v]
              (if (and (= n (get v :name))
                       ;(not= "struct" (get v :type))
                       )

                (let [fields (get v :fields)
                      fields  (into [] (comp
                                         (map (fn [m] (select-keys m [:name :schema]) ) )
                                         )  fields )]
                  (reduced fields  ))
                acc)
              ) []  schema-list)))



(defmethod p/invoke "df-schema"
  [ {:keys [request]}]
  (let [schema-list (p/get-md-schema-coll)
        n request]
    (reduce (fn [acc v]
              (if (= n (get v :name))

                (if (= "type" (get v :type))
                  (reduced (select-keys v [:name :type :type_of ]) )
                  (let [fields (get v :fields)
                        fields  (into [] (comp
                                           (map (fn [m] (select-keys m [:name :schema]) ) )
                                           )  fields )
                        a-schema {:name n
                                  :type "record"
                                  :namespace (get p/context :namespace)
                                  :fields fields}]
                    (reduced a-schema  )))
                acc)
              ) {}  schema-list)))



(defmethod p/invoke "df-schema-attr"
  [ {:keys [request]}]
  (let [schema-list (p/get-md-schema-coll)
        n request
        out (->> schema-list
                 (remove (fn [v]  (= "type" (get v :type))))
                 (reverse)
                 (into [] (comp
                            (map (fn [w]
                                   (let [field-list (get w :fields)
                                         n (get w :name)]
                                     (into [] (map (fn [f]
                                                 ;    (clojure.pprint/pprint f)
                                                     {:attr_name (get f :name)
                                                      :schema n
                                                      :namespace (get p/context :namespace)
                                                      :type (get-in f [:schema :type])
                                                      :logical_type (get-in f [:schema :logical-type])
                                                      :dq_rule (when-let [v (get f :validation!)]
                                                                 (pr-str v)
                                                                 )
                                                      :ref (when-let [v (get-in f [:transfer_fn])]
                                                             (pr-str v)
                                                             )
                                                      }
                                                     )) field-list ))))
                            cat
                            (filter (fn [v]
                                      (if n
                                        (clojure.string/includes? (get v :attr_name) n)
                                        true)

                                      ) )
                            )

                       )

                 )
        ]
    {:fields (take 20 out)
     :total (count out)
     }



    #_(reduce (fn [acc v]
              (if (= n (get v :name))

                (if (= "type" (get v :type))
                  (reduced (select-keys v [:name :type :type_of ]) )
                  (let [fields (get v :fields)
                        fields  (into [] (comp
                                           (map (fn [m] (select-keys m [:name :schema]) ) )
                                           )  fields )
                        a-schema {:name n
                                  :type "record"
                                  :namespace (get p/context :namespace)
                                  :fields fields}]
                    (reduced a-schema  )))
                acc)
              ) {}  schema-list)))




(defmethod p/invoke "df-schema-names"
  [ {:keys [request]}]
  (let [schema-list (p/get-md-schema-coll)
        xf (comp

             (remove (fn [m]
                    ;   (println "--" (keys m))
                       (or
                         (= "struct" (get m :type))
                         (contains? (into #{} (keys m) ) :internal )
                         )
                        ))

             (map (fn [r]

                    (get-in r [:name]) ))
             (filter (fn [n]

                       (if (and request
                                   (not (clojure.string/blank? request)))
                              (clojure.string/includes? n request)
                              true
                            ) ))
             )]
    (into #{} xf schema-list)))


