(ns io.datafy.http.boot
  (:require [io.datafy.http.server :as s]
            [clojure.tools.logging :as log]
            [clojure.tools.reader.edn :as edn]
            [environ.core :refer [env]]
            [ingestion.api.client.ns-repo-impl :as ccore]
            [azure.client.ns-repo :as br]
    ;   [io.datafy.boot.core :as datafy]
    #_[io.datafy.connector.repo.compiler.file-io :as fu]))

(def server (atom nil))
(def context (atom nil))

(defn start
  [w]
  (when (nil? @server)
    (reset! context w)
    (->> (s/start-server context w)
         (reset! server))
    #_(let [w (fu/read-ffile file-name)
            ncontext (datafy/init-context w)]
        (reset! context ncontext)
        (datafy/src-watch w context)
        ))
  )

(comment
  (start "boot.edn")

  (edn/read-string (slurp "resources/boot.edn"))

  )

(defn stop []
  (log/debug "Stoping app server ")
  (s/stop-server @server)
  (reset! server nil)
  ; (datafy/clean-context @context)
  )


#_(def cli-options
    ;; An option with a required argument
    [["-p" "--port PORT" "Port number"
      :default 80
      :parse-fn #(Integer/parseInt %)
      :validate [#(< 0 % 0x10000) "Must be a number between 0 and 65536"]]
     ;; A non-idempotent option (:default is applied first)
     ["-v" nil "Verbosity level"
      :id :verbosity
      :default 0
      :update-fn inc]                                       ; Prior to 0.4.1, you would have to use:
     ;; :assoc-fn (fn [m k _] (update-in m [k] inc))
     ;; A boolean option defaulting to nil
     ["-h" "--help"]])


(defn -main
  [& [port storage-account storage-key]]
  (let [port (Integer. (or port (env :port) "5000"))]
    (println "-----------starting port " port)
    (ccore/set-ns-repo (br/new-blob-store storage-account storage-key) #_(ccore/new-file-store) )
    (start {;:watch    true
            :storage-account storage-account
            :storage-key storage-key
            :root-url "/r"
            :pedestal {:io.pedestal.http/resource-path   "/public"
                       :io.pedestal.http/type            :jetty
                         :io.pedestal.http/host          "0.0.0.0"
                       :io.pedestal.http/join?           false
                       :io.pedestal.http/port            port
                       ;::server/allowed-origins {:creds true :allowed-origins (constantly true)}
                       :io.pedestal.http/allowed-origins {:creds true :allowed-origins (constantly true)}
                       ;:io.pedestal.http/container-options {:ssl-port 4348    :keystore "config/keystore.jks"   :key-password "password"         }
                       }})
    )


  #_(-> (first args)
        (slurp)
        (edn/read-string)
        (start))

  #_(let [c (count args)]
      (cond
        (= c 1)
        (start (first args))
        (= c 2)
        ;   (i/do-import (first args) )
        :else
        (println "Invalid argument, please provide file name ")

        )
      )

  #_(let [[option file-name] args]

      )

  #_(let [[file-name] args]
      (start file-name)))

(comment


  (start {;:watch    true
          :root-url "/r"



          :pedestal {:io.pedestal.http/resource-path   "/public"
                     :io.pedestal.http/type            :jetty
                     ;  :io.pedestal.http/host          "10.164.78.15"
                     :io.pedestal.http/join?           false
                     :io.pedestal.http/port            3001

                     ;::server/allowed-origins {:creds true :allowed-origins (constantly true)}
                     :io.pedestal.http/allowed-origins {:creds true :allowed-origins (constantly true)}
                     ;:io.pedestal.http/container-options {:ssl-port 4348    :keystore "config/keystore.jks"   :key-password "password"         }
                     }})


  @server

  (stop)


  (s/start "boot.edn")

  )