(ns ksql.gen
  (:require [ksql.gen.core :as mc]
            [ksql.gen.core_schema :as sch]
            [ksql.gen.core-error-msg :as emsg]
            [ksql.gen.macro.msg-count-impl :as mm]
    ; [ksql.client :as client]
            [ksql.gen.util :as u]
            [ksql.gen.core-gen-type :as gt]
            [ksql.gen.protocol :as p]
            [ksql.gen.emitter.ksql.core :as kc]
    #_[ksql.gen.emitter.ksql :as eksql]
            [ingestion.api.client.ns-repo-impl :as c]))


#_(defn get-reader-type [v]
    (if (string? v) :csv :default))


(defn do-read
  "Generate mapping from mapping after apply macro "
  {:added "0.10.1"}
  [context md-repo mapping]
  (->> (p/read-req (or (get context :reader) :triple) mapping)
       ;  (p/expand-flow schema)
       )

  )


#_(defn- compile-impl2 [md-repo mapping]
    (let [new-md-repo-coll (->> mapping
                                ;  (p/read-req (get p/context :reader :triple ))
                                (mc/do-compile-batch md-repo)
                                (split-at (count md-repo))
                                (second))
          xf (comp
               (map (fn [schema-m]
                      (if (sch/gen-type? schema-m)
                        (assoc-in schema-m [:with :statement] (p/gen-ksql schema-m))
                        schema-m))))]
      (into [] xf new-md-repo-coll))
    )

#_(defn do-compile2
    "Generate metadata schema after doing read and compile step "
    {:added "0.10.1"}
    ;([mapping] (do-compile {} [] mapping))
    [mapping]
    (let [mapping-coll (p/read-req (or (get p/context :reader) :triple) mapping)]
      (loop [[f-mapping & r-mapping] mapping-coll
             md-repo []
             out []]
        (if (nil? f-mapping)
          out
          (let [v (compile-impl2 md-repo [f-mapping])
                md-repo (into md-repo v)
                ;  result [f-mapping v]
                out (into out v)]
            (recur r-mapping md-repo out))))))




(defn do-compile
  "Generate metadata schema after doing read and compile step "
  {:added "0.10.1"}
  ;([mapping] (do-compile {} [] mapping))
  ([mapping] (do-compile [] mapping))
  ([md-repo mapping]
   (let [compile-schema (->> mapping
                             (p/read-req (get p/context :reader :triple)))


         ;compile-schema (into compile-schema monitor-schema)
         ;_ (clojure.pprint/pprint monitor-schema )
         new-md-repo-coll (->> compile-schema
                               (mc/do-compile-batch md-repo)
                               (split-at (count md-repo))
                               (second)
                               (vec))
         ;_ (println "--" (keys p/context))
        ;_ (println "--" (get p/context :monitor-stream))
         monitor-schema (if (get p/context :monitor-stream)
                          (->> new-md-repo-coll
                               (filter (fn [m]
                                         ;(p/log-v m)
                                         (= "stream" (clojure.string/lower-case (get m :type))) ))

                               (into #{} (map :name))
                               (mm/impl-count)
                               (p/read-req :triple)
                               (mc/do-compile-batch []))
                          [])

         new-md-repo-coll (into new-md-repo-coll monitor-schema)


         xf (comp
              (map (fn [schema-m]
                     (if (sch/gen-type? schema-m)
                       (assoc-in schema-m [:with :statement] (p/gen-ksql schema-m))
                       schema-m))))]
     (into [] xf new-md-repo-coll))))



#_(defn do-process [context md-repo mapping]
    (binding [p/gcontext context]
      (let [md-repo (do-compile context md-repo mapping)
            xf (comp
                 (map (fn [schema-m]
                        (if (sch/gen-type? schema-m)
                          (assoc-in schema-m [:with :statement] (p/gen-ksql schema-m))
                          schema-m))))]
        (into [] xf md-repo))))



(defn gen-ksql
  "Generate ksql from meta data schema  "
  {:added "0.10.1"}
  [context md-repo]
  (->> md-repo
       ;(p/log-v)
       (into [] (comp
                  (filter sch/gen-type?)
                  ;(remove  sch/struct-type? #_(fn [schema-m] (= "struct" (sch/get-type schema-m) #_(get schema-m :type)) ))
                  (map p/gen-ksql #_(fn [schema-m]
                                      (assoc schema-m :statement (p/gen-ksql schema-m))))
                  #_(map :statement))))
  #_(binding [p/gcontext context]
      ))


(defn gen-ksql-by-mapping
  "Generate ksql statement after apply read, compile and emitter process  "
  {:added "0.10.1"}
  ; ([mapping] (gen-ksql-by-mapping {} [] mapping))
  ([mapping] (gen-ksql-by-mapping [] mapping))
  ([md-repo mapping]
   (->> (do-compile md-repo mapping)
        (into [] (comp (map (fn [m]
                              (get-in m [:with :statement])
                              )) cat)))))


(defn gen-ksql-by-file [topic-name file-path]
  (let [w (last (clojure.string/split file-path #"\."))
        file-type (clojure.string/lower-case w)
        v (condp = file-type
            "json" (str "(load_md_from_json_file \"" file-path "\" )")
            "csv" (str "(load_md_from_csv_file \"" file-path "\" )")
            "xml" (str "(load_md_from_xml_file \"" file-path "\" )")
            (throw (emsg/ex-info-for-invalid-data-type file-type)
                   #_(ex-info "type does not supported, only supprt file xml, csv, json " {:provided file-type
                                                                                           :excepted #{"json" "csv" "xml"}
                                                                                           })

                   ))
        mapping [topic-name "_" v
                 topic-name "_" "(value_format 'json' )" ";"]]
    (gen-ksql-by-mapping mapping)))



