(ns ksql.gen.core-error-msg)


(defn ex-info-for-remote-exec [url m msg]
  (ex-info (or msg "remote exception ")  {:e-ref msg #_(.getMessage e)
                                :url   url  #_(get context :ksql-url)
                                :req   m
                                })
  )

(defn ex-info-for-invalid-mapping [w msg]
  (ex-info (str "Invalid mapping structure ") {:e-ref w :e-des msg}))




(defn ex-info-for-op-not-found [op api-list]
  (ex-info (str "api name " op " not found, available api \n" (clojure.string/join "\n" api-list)) {:available-op api-list
                                                                                                    :e-des        "op not found"
                                                                                                    :e-ref        op
                                                                                                    })
  )


(defn ex-info-for-null-field-or-transformation [mapping]
  (ex-info "invalid field or transformation " {:e-ref mapping
                                               :e-des "field or transformation is null"}))



(defn ex-info-for-invalid-field [sink-name mapping mapping-fields sink-fields]

  (ex-info "invalid mapping field" {:e-name  sink-name
                                    :e-ref   mapping #_(clojure.set/difference mapping-fields sink-fields)
                                    :e-field (clojure.set/difference mapping-fields sink-fields)
                                    :e-des   "invalid mapping field"
                                    }))

(defn ex-info-for-more-source-ref [entity-name mapping-field]
  (ex-info "select should be only one entity, found more than one "
           {:e-name entity-name
            :e-ref  mapping-field
            :e-des  "select should be only one entity, found more than one "
            })
  )


(defn ex-info-null-source-ref [source-name available-schema mapping-field]
  (ex-info (format "source schema is null for %s, available schema %s " source-name, available-schema)
           {:e-ref  mapping-field
            :e-name source-name
            :e-des  "source schema is null"})
  )


(defn ex-info-invalid-fields-name [mapping-field field-names]
  (ex-info (str " Field name not found " (pr-str field-names)) {:e-name field-names
                                                                :e-ref  mapping-field
                                                                :e-des  "field name not found"})
  )


(defn ex-info-for-invalid-source-ref [k v]
  (ex-info "invalid schema name " {:e-name k
                                   :e-ref  (mapv (fn [v1] (nth v1 2)) v)
                                   :e-des  "invalid schema name "})
  )


(defn ex-info-for-invalid-source-field-ref [sink-name source-field sink-fields]
  (ex-info "invalid source field" {:e-name       sink-name
                                   :e-map-fields source-field
                                   :e-fields     sink-fields
                                   :e-ref        (clojure.set/difference source-field sink-fields)
                                   :e-des        "invalid source field"})
  )


(defn ex-info-for-invalid-local-ref [field fields-name]
  (ex-info "invalid this ref " {:e-des  "invalid this ref"
                                :e-ref  field
                                :e-name fields-name})
  )


(defn ex-info-for-invalid-equal-fields [first-arg second-argv]
  (ex-info "= needs two argument " {:first first-arg :second second-argv})
  )


(defn ex-info-for-invalid-index [first-arg second-argv]
  (ex-info "index_of index is missing, please provide array index or map key" {:field_name first-arg :index second-argv})
  )


(defn ex-info-for-invalid-type-ref [ftype]
  (ex-info (str " invalid type ref, " ftype " needs to be struct type")
           {:e-des (str " invalid type ref, " ftype " needs to be struct type")
            :e-ref ftype})
  )


(defn ex-info-for-invalid-data-type [type]
  (ex-info (str type " does not supported, only support file xml, edn, csv, json ")
           {:e-ref    type
            :e-des    (str type " does not supported, only support file xml, edn, csv, json ")
            :suported #{"edn" "json" "xml" "csv"}
            })
  )


(defn ex-info-for-invalid-dv-attr [assoc_dv_attr1 refined-entity-name]
  (ex-info "business key is missing for assoc-dv-attr. it will be 2, 4 or 6 " {:msg    "business key is missing for assoc-dv-attr. it will be 2, 4 or 6 "
                                                                               :e-sug "schema_refined  \"\" (assoc_dv_attr bk_name bk_name)"
                                                                               :e-ref  assoc_dv_attr1
                                                                               :e-name refined-entity-name

                                                                               })
  )