(ns ksql.gen.macro.distinct-impl
  (:require [ksql.gen.protocol :as p]
            [ingestion.api.client.ns-repo-impl :as c]
            [ksql.gen.util :as u]))



(defn distinct-impl2

  [md-repo sink-name source-name window-str]
  (let [window-str (or window-str
                       (get p/context :distinct-duration)
                       "10 MINUTES")
        source-schema (reduce (fn [acc v]
                                (if (= (clojure.string/lower-case source-name)
                                       (clojure.string/lower-case (get v :name)))
                                  (reduced v)
                                  acc)
                                ) [] md-repo)
        fields (get source-schema :fields)

        source-detected-tab_stage (str source-name "_distinct_stage_tab_stage")
        source-detected-table (str source-name "_distinct_stage_tab")
        source-detected-stream (str source-name "_distinct_stage")

        w (str "( concat " (clojure.string/join " " (into [] (comp (map (fn [f]
                                                                          (if (= "string"
                                                                                 (get-in f [:schema :type])
                                                                                 )
                                                                            (str source-name "/" (:name f))

                                                                            (str "(cast " (str source-name "/" (:name f)) " string)")

                                                                            )
                                                                          ;(str source-name "/" v)
                                                                          ))

                                                                   ) fields)) " )")

        out_mapping [source-detected-tab_stage "" (str "(select " source-name "/* ) ")
                     source-detected-tab_stage "key0" w]



        source-name source-detected-tab_stage

        out (into out_mapping [(str source-detected-table " table")
                               (str "key0" " string ")
                               (str " ( as_value " source-name "/key0" " ) ")
                               (str source-detected-table " ")
                               (str "key1" " string ")
                               (str source-name "/key0 ")
                               ])

        detected-key-fields (map (fn [f i]
                                   [
                                    #_[source-detected-table
                                       (str "key" (+ 1 i) " " (get-in f [:schema :type]))
                                       (str source-name "/" (get f :name))]
                                    [source-detected-table
                                     (str (get f :name) " " (get-in f [:schema :type]))
                                     (str "( latest_by_offset " source-name "/" (get f :name) " )")]]
                                   ) fields (range))

        detected-fields (into out (comp cat cat) detected-key-fields)

        windows [source-detected-table "" (str "(window " window-str ") ")]
        detected-fields (into detected-fields windows)

        group-by-str (->> (map (fn [f]
                                 (str source-name "/" (get f :name))
                                 ) fields)
                          (clojure.string/join ", "))
        group-by-str [source-detected-table "" (str "(group_by " source-name "/key0 )")]
        detected-fields (into detected-fields group-by-str)


        having-vec [source-detected-table "" (str "(having (= (count  " source-name "/key0 ) 1 ))")]
        detected-fields (into detected-fields having-vec)
        ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        detected-stream-fields [(str source-detected-stream " stream " source-detected-table)
                                (str "key0" " string ")
                                ""]
        detected-stream-fields (into detected-stream-fields
                                     (comp (map (fn [f]
                                                  [source-detected-stream
                                                   (str (get f :name) " " (get-in f [:schema :type]))
                                                   ""]))
                                           cat)
                                     fields)

        ;detected-stream-fields (into [] cat detected-stream-fields)
        ;_ (clojure.pprint/pprint detected-stream-fields)


        all-fields (into detected-fields detected-stream-fields)


        ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        ;stage-fields
        #_[(str source-name "_stage") "kk string" ""
           (str source-name "_stage") "value" ""
           (str source-name "_stage_tab") "" (str "(latest_by_offset " source-name "_stage kk)")
           (str source-name "_stage_tab") "" "(key key_0)"
           ;(str source-name "_stage_tab") ""  "(key kk )"
           ]

        ;    all-fields (into detected-fields stage-fields)

        ;     having-key (first group-by-key-list)
        distinct-fields (into [] (map (fn [f]
                                        [sink-name
                                         (str (get f :name) " " (get-in f [:schema :type]))
                                         (str source-detected-stream "/" (get f :name))]
                                        )) fields)


        ;vv1

        #_(str "(concat " (clojure.string/join " " (mapv (fn [v]
                                                           (str source-detected-stream "/" v)
                                                           ) group-by-key-list)) " )")

        distinct-fields-where [[sink-name "" (str "(where (!=null " source-detected-stream "/key0" "))")]
                               ;[sink-name "" (str "(left_join " vv1 " " source-name "_stage_tab" "/key_0" ")")]
                               ]

        ;_ (println "--"      [sink-name "" (str "(left_join " vv1 " "  source-name "_stage" "/kk" ")")])

        ;        distinct-fields-where (into distinct-fields-where distinct-fields-join)

        distinct-fields (into [] cat (into distinct-fields distinct-fields-where) #_(conj (into [] distinct-fields) distinct-fields-where))

        all-fields (into all-fields distinct-fields)

        ]

    ; (p/log-v (partition 3 all-fields) )

    [all-fields])
  )





;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defn distinct-with-key-impl
  ([md-repo sink-name source-name group-by-source-key-list] (distinct-with-key-impl md-repo sink-name source-name group-by-source-key-list " 10 hours "))
  ([md-repo sink-name source-name group-by-source-key-list window-str]
   (let [w (reduce (fn [acc v]
                     (if (= (clojure.string/lower-case source-name)
                            (clojure.string/lower-case (get v :name)))
                       (reduced v)
                       acc)
                     ) [] md-repo)

         ;    _ (when (= "body" source-name) (p/log-v w))
         fields (get w :fields)

         group-by-key-list (if (or
                                 (nil? group-by-source-key-list)
                                 (empty? group-by-source-key-list))
                             (mapv :name fields)
                             group-by-source-key-list)
         ; _ (println "-------------------------" group-by-source-key-list)

         source-detected-table (str source-name "_distinct_stage_tab")
         source-detected-stream (str source-name "_distinct_stage")


         group-by-key-set (into #{} group-by-key-list)

         k-ffield-list (into [] (filter (fn [f]
                                          (contains? group-by-key-set (get f :name))
                                          )) fields)
         ;  _ (clojure.pprint/pprint k-ffield-list)
         ;    "clicks_detected table" "key1" "clicks/ip_address"
         detected-key-fields (map (fn [f i]
                                    (if (= i 0)
                                      [(str source-detected-table " table")
                                       (str "key" i " " (get-in f [:schema :type]))
                                       (str source-name "/" (get f :name))
                                       ]
                                      [source-detected-table
                                       (str "key" i " " (get-in f [:schema :type]))
                                       (str source-name "/" (get f :name))
                                       ])
                                    ) k-ffield-list (range))

         detected-value-fields (into [] (map (fn [f]
                                               [source-detected-table
                                                (str (get f :name) " " (get-in f [:schema :type]))
                                                (str "( as_value " source-name "/" (get f :name) " )")]))
                                     k-ffield-list)

         detected-value-fields (into detected-value-fields
                                     (comp
                                       (remove (fn [f]
                                                 (contains? group-by-key-set (get f :name))
                                                 ))
                                       (map (fn [f]
                                              [source-detected-table
                                               (str (get f :name) " " (get-in f [:schema :type]))
                                               (str "( latest_by_offset " source-name "/" (get f :name) " )")]))
                                       )
                                     fields
                                     ;k-ffield-list

                                     )

         detected-fields (->> (into (into [] detected-key-fields) detected-value-fields)
                              (into [] cat))

         windows [source-detected-table "" (str "(window " window-str ") ")]
         detected-fields (into detected-fields windows)

         group-by-str (->> (map (fn [f]
                                  (str source-name "/" (get f :name))
                                  ) k-ffield-list)
                           (clojure.string/join ", "))
         group-by-str [source-detected-table "" (str "(group_by " group-by-str ")")]
         detected-fields (into detected-fields group-by-str)

         having-key (first group-by-key-list)
         having-vec [source-detected-table "" (str "(having (= (count " source-name "/" having-key " ) 1 ))")]
         detected-fields (into detected-fields having-vec)
         ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

         detected-stream-fields (map (fn [f i]
                                       (if (= i 0)
                                         [(str source-detected-stream " stream " source-detected-table)
                                          (str (get f :name) " " (get-in f [:schema :type]))
                                          ""]
                                         [source-detected-stream
                                          (str (get f :name) " " (get-in f [:schema :type]))
                                          ""])
                                       ) fields (range))
         all-fields (into detected-fields cat detected-stream-fields)

         ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

         ;stage-fields
         #_[(str source-name "_stage") "kk string" ""
            (str source-name "_stage") "value" ""
            (str source-name "_stage_tab") "" (str "(latest_by_offset " source-name "_stage kk)")
            (str source-name "_stage_tab") "" "(key key_0)"
            ;(str source-name "_stage_tab") ""  "(key kk )"
            ]

         ;    all-fields (into detected-fields stage-fields)


         distinct-fields (map (fn [f]
                                [sink-name
                                 (if (= (clojure.string/lower-case having-key)
                                        (clojure.string/lower-case (get f :name))
                                        )
                                   ;" key"
                                   (str (get f :name) " " (get-in f [:schema :type]))
                                   (str (get f :name) " " (get-in f [:schema :type]))
                                   )

                                 (str source-detected-stream "/" (get f :name))

                                 ]

                                ) fields)



         ;vv1

         #_(str "(concat " (clojure.string/join " " (mapv (fn [v]
                                                            (str source-detected-stream "/" v)
                                                            ) group-by-key-list)) " )")

         distinct-fields-where [[sink-name "" (str "(where (!=null " source-detected-stream "/" having-key "))")]
                                ;[sink-name "" (str "(left_join " vv1 " " source-name "_stage_tab" "/key_0" ")")]
                                ]

         ;_ (println "--"      [sink-name "" (str "(left_join " vv1 " "  source-name "_stage" "/kk" ")")])

         ;        distinct-fields-where (into distinct-fields-where distinct-fields-join)

         distinct-fields (into [] cat (into distinct-fields distinct-fields-where) #_(conj (into [] distinct-fields) distinct-fields-where))

         all-fields (into all-fields distinct-fields)


         ;vv
         #_(str "(concat " (clojure.string/join " " (mapv (fn [v]
                                                            (str sink-name "/" v)
                                                            ) group-by-key-list)) " )")
         ; ww

         #_[(str source-name "_stage") "kk" vv
            (str source-name "_stage") "value" vv]
         ; all-fields (into all-fields ww)

         ]

     [all-fields]))
  )


(defmethod p/expand-flow "distinct"
  [md-repo mapping]
  ;(println "--mapping" )
  ;(clojure.pprint/pprint mapping)
  (let [mapping (first mapping)

        [_ source-name postfix & group-by-key-list] (get mapping :transfer_fn)

        ;group-by-key-list (remove  )
        sink-name (get mapping :name)
        ;  _ (println "---" sink-name "--------------" source-name "---------" group-by-key-list)


        group-by-key-list (if (or (= "_" sink-name)
                                  (= "" sink-name))
                            #_(str source-name "_distinct")
                            (rest group-by-key-list)
                            group-by-key-list
                            )

        window-str (if (or (= "_" sink-name)
                                  (= "" sink-name))
                            #_(str source-name "_distinct")
                            (first group-by-key-list)
                            postfix

                            )


        sink-name (if (or (= "_" sink-name)
                          (= "" sink-name))
                    (str source-name "_distinct")
                    sink-name)

        ]



    (if (and group-by-key-list
             (not (empty? group-by-key-list))
             )
      (distinct-with-key-impl md-repo sink-name source-name group-by-key-list window-str)
      (distinct-impl2 md-repo sink-name source-name window-str)
      )
    ))



#_(defmethod p/expand-flow "distinct"
    [md-repo mapping]
    (let [mapping (first mapping)
          [_ source-name window-str & group-by-key-list] (get mapping :transfer_fn)
          ;_ (println "---" mapping)
          sink-name (get mapping :name)]
      (distinct-with-key-impl md-repo sink-name source-name group-by-key-list window-str)
      )
    )



#_(defmethod p/expand-flow "distinct"
    [md-repo mapping]
    ;(println "--mapping" mapping)
    (let [mapping (first mapping)
          [_ source-name & group-by-key-list] (get mapping :transfer_fn)

          ;group-by-key-list (remove  )
          sink-name (get mapping :name)
          ;  _ (println "---" sink-name "--------------" source-name "---------" group-by-key-list)

          group-by-key-list (if (or (= "_" sink-name)
                                    (= "" sink-name))
                              #_(str source-name "_distinct")
                              (rest group-by-key-list)
                              group-by-key-list)

          sink-name (if (or (= "_" sink-name)
                            (= "" sink-name))
                      (str source-name "_distinct")
                      sink-name)]
      (distinct-with-key-impl md-repo sink-name source-name group-by-key-list)))



(comment

  )


