(ns ksql.gen-connector
  (:require [cheshire.core :as json]
            [ingestion.api.client.ns-repo-impl :as core]
            [ksql.gen.protocol :as p]
            [ksql.gen.connector.core :as c]
            [ksql.gen.core_schema :as cs]
            ;[ksql.client :as client]
          ;  [ksql.metadata-api :as md]
            [ksql.gen.connector.config-generator]
            [ksql.gen.reader.file-reader :as r]
            [ksql.gen.file-util :as fio]))



;;;@todo this need to be override with file-path-extension using csv or json or anything else
(defn assoc-field-schema [e]
  ;(clojure.pprint/pprint e)
  (let [config (get e :connector)
        file-path (get e :input-file)
        topic-name (get e :topic-name)

        md-repo  (p/get-md-schema-coll)
        fields (cs/get-fields md-repo topic-name)
        fields (if fields
                 fields
                 (->> (r/read-header file-path)
                      (mapv (fn [v]
                              {:name v, :schema {:type "string"}})))
                 )
        ]
    (assoc e :fields fields)))



(defn gen-source-connector-config [context connector-mapping]
  (let [base-dir (get context :base-dir "")
        xf (comp
             (map assoc-field-schema)
             (map p/gen-connector))]
    (->> (c/as-source-connector-schema base-dir connector-mapping)
         (into [] xf))))


(comment

  (->> (gen-source-connector-config "app/azben/" [["mapping/config/csv_source.json" "data/source/raw_bnl_claim.csv"]])

       )

  )



#_(defn get-source-connector-names [context connector-mapping]
  (let [base-dir (get context :base-dir "")
        req-coll (c/as-source-connector-schema base-dir connector-mapping)]
    (into [] (comp
               (map p/gen-connector )
               (map :name)
               ) req-coll)))


(defn gen-sink-connector-config
  [context  sink-connector-mapping]
  (let [base-dir (get context :base-dir "")
        sink-connector-mapping (c/as-sink-connector-schema base-dir sink-connector-mapping)
        conn-coll (mapv p/gen-connector sink-connector-mapping)]
    conn-coll))