(ns ksqldb.client.schema-api
  (:require [cheshire.core :as json]
            [clj-http.client :as http]
            [ksql.gen.protocol :as c]
            [clojure.tools.logging :as log]
            [ksql.gen.protocol :as p]))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; Schemas


#_(defn register-schema [schema-name schema]
    (let [schema (json/generate-string schema)
          body (json/generate-string {:schema schema})
          url (str schema-url "/subjects/" schema-name "/versions")]
      (log/info "Schema url " url)
      (http/post url
                 {:body    body
                  :headers {"Content-Type" "application/vnd.schemaregistry.v1+json"}})))


(defmethod c/invoke "schema-delete"
  [ {:keys [request]}]
  (let [ ;schema (json/generate-string schema)
       ; body (json/generate-string {:schema schema})
        url (str (get p/context :schema-url) "/subjects/" request)]
    (log/info "deleting schema url " url)
    (http/delete url)))


(defmethod c/invoke "schema-register"
  [ {:keys [schema-name schema]}]
  (let [schema (json/generate-string schema)
        body (json/generate-string {:schema schema})
        url (str (get p/context :schema-url) "/subjects/" schema-name "/versions")]
    (log/info "Schema url " url)
    (http/post url
               {:body    body
                :headers {"Content-Type" "application/vnd.schemaregistry.v1+json"}})))



(defmethod c/invoke "schema-show"
  [{:keys [request]}]
  ;(println "----------------")
  (-> (http/get (str (get p/context :schema-url) "/subjects"))
      (:body)
      (json/parse-string true)))


(defmethod c/invoke "schema-describe"
  [ {:keys [request]}]
  (when (nil? request)
    (throw (ex-info "Invalid request, schema name is null - Provide schema name to get schema details " {:schema-name request}))
    )
  (-> (http/get (str (get p/context :schema-url) "/subjects/" request "/versions/latest"))
      (:body)
      (json/parse-string true)
      :schema
      (json/parse-string true))
  #_(k/get-schema request))


