(ns kioo.util
  (:refer-clojure :exclude [replace])
  (:require [clojure.string :refer [split replace capitalize]]
                                 ))

      
                               

      
                  
                                                     
                                                       
                        
                 
                
                                                           
                          
                
                         
                                                                     
                                                  
                                     
                            
                  
                         
                                                                       
                                                  
                                     
                                
                                     
                         
                                                                       
                                                  
                                                           
                                    
                          
                         
                                                                              
                                                                                  
                                                  
                                                
                              
                                     
                         
                                                                        
                                                                            
                                                  
                                                           
                             
                                     
                         
                                                                       
                                                                      
                                                                        
                                                  
                                                           
                             
                
                         
                                                                       
                                                                           
                                                  
                                     
                            
                
                         
                                                                      
                                                                     
                                                                        
                                                  
                                     
                               
                
                         
                                                                         
                                                                         
                                                  
                                        


(def dont-camel-case #{"aria" "data"})

(defn camel-case [dashed]
  (if (string? dashed)
    dashed
    (let [name-str (name dashed)
          [start & parts] (split name-str #"-")]
      (if (dont-camel-case start)
        name-str
        (apply str start (map capitalize parts))))))


(def attribute-map
  (assoc 
      (reduce #(assoc %1 (keyword (.toLowerCase (name %2))) %2) {}
              [:accessKey :allowFullScreen :allowTransparency :autoComplete
               :autoFocus :autoPlay :cellPadding :cellSpacing :charSet
               :colSpan :contentEditable :contextMenu :dateTime :encType
               :formEncType :formNoValidate :frameBorder :httpEquiv :itemProp
               :itemScope :itemType :maxLength :noValidate :radioGroup :readOnly
               :rowSpan :scrollLeft :scrollTop :spellCheck :srcDoc :tabIndex
               :gradientTransform :gradientUnits :spreadMethod :stopColor
               :stopOpacity :strokeLinecap :strokeWidth :textAnchor :viewBox])
    :accept-charset :acceptCharset
    :class          :className
    :for            :htmlFor))

(defn transform-keys [attrs]
  (reduce (fn [m [k v]]
            (assoc m (or (attribute-map k) k) v)) {} attrs))

(defn convert-attrs [attrs]
  (let [style  (when (:style attrs)
                 (let [vals (re-seq #"\s*([^:;]*)[:][\s]*([^;]+)"
                                    (:style attrs))]
                   (reduce (fn [m [_ k v]]
                             (assoc m k (.trim v)))
                           {} vals)))
        class-name (:class attrs)]
    (-> attrs
        (transform-keys)
        (assoc :style style))))


(defn flatten-nodes [nodes]
  (reduce #(if (seq? %2)
             (concat %2 %1)
             (conj %1 %2))
          '()
          (reverse nodes)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;these functions were pulled from r0man / sablono hiccup style
;;template engine for react.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defn attr-pattern
  "Returns a regular expression that matches the HTML attribute `attr`
  and it's value."
  [attr]
  (re-pattern (str "\\s+" (name attr) "\\s*=\\s*['\"][^\"']+['\"]")))

(defn strip-attr
  "Strip the HTML attribute `attr` and it's value from the string `s`."
  [s attr]
  (if s (replace s (attr-pattern attr) "")))

;;;;;;;;;;;; This file autogenerated from src/kioo/util.cljx
