/*
 * Decompiled with CFR 0.152.
 */
package datomic.impl.lucene;

import clojure.lang.ILookup;
import datomic.impl.clusterfs.Closed;
import datomic.impl.clusterfs.IClusterFS;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.lucene.store.IndexInput;

public class ClusterIndexInput
extends IndexInput {
    private final int chunkSize;
    private volatile IClusterFS cluster;
    private final ILookup olookup;
    private final String filename;
    private int chunkNo;
    private ByteBuffer chunk;

    public ClusterIndexInput(IClusterFS cluster2, ILookup olookup, String filename, int chunkSize) throws IOException {
        this.cluster = cluster2;
        this.olookup = olookup;
        this.filename = filename;
        this.chunkSize = chunkSize;
        this.seek(0L);
    }

    public void close() throws IOException {
        this.cluster = Closed.instance;
    }

    public long getFilePointer() {
        return (long)this.chunkNo * (long)this.chunkSize + (long)this.chunk.position();
    }

    public void seek(long l) throws IOException {
        if (0L <= l && l < this.cluster.fileLength(this.filename)) {
            this.chunkNo = (int)(l / (long)this.chunkSize);
            this.chunk = ByteBuffer.wrap(this.cluster.getChunk(this.olookup, this.filename, this.chunkNo));
            if (this.chunkNo < (int)(this.length() / (long)this.chunkSize) && this.chunk.remaining() != this.chunkSize) {
                throw new IllegalStateException("Invalid chunk size " + this.chunk.remaining() + "/" + this.length());
            }
        } else {
            throw new IOException("Offset " + l + " out of range");
        }
        this.chunk.position((int)(l % (long)this.chunkSize));
    }

    public long length() {
        return this.cluster.fileLength(this.filename);
    }

    private void advanceChunk() throws IOException {
        if (!this.chunk.hasRemaining()) {
            this.seek(this.getFilePointer());
        }
        if (!this.chunk.hasRemaining()) {
            throw new RuntimeException("empty chunk");
        }
    }

    public byte readByte() throws IOException {
        this.advanceChunk();
        return this.chunk.get();
    }

    public void readBytes(byte[] bytes, int offset, int len) throws IOException {
        while (len > 0) {
            this.advanceChunk();
            int size = Math.min(this.chunk.remaining(), len);
            this.chunk.get(bytes, offset, size);
            offset += size;
            len -= size;
        }
    }
}

