(ns day8.re-frame-10x.svgs)

(defn reload
  []
  [:svg {:height "23px"
         :viewBox "0 0 32 32"}
   [:path {:fill "#6EC0E6"
           :d "M27.773,22.766c2.379-6.494-0.967-13.711-7.459-16.091c-4.11-1.506-8.5-0.707-11.777,1.721l1.483-6.743L7.09,1.009  l-1.946,8.85L4.5,12.79l2.93,0.646v-0.001l8.85,1.948l0.645-2.931l-6.794-1.494c2.514-1.963,5.943-2.642,9.152-1.466  c4.939,1.81,7.486,7.302,5.676,12.242c-1.811,4.938-7.302,7.484-12.242,5.675c-4.155-1.522-6.604-5.646-6.207-9.858l-2.896-1.06  c-0.918,5.798,2.354,11.64,8.07,13.735C18.178,32.604,25.395,29.259,27.773,22.766z"}]])

(defn triangle-down
  [& {:keys [style]
      :or   {style {}}}]
  [:svg {:height "7px"
         :viewBox "0 0 12 7"
         :style   style}
   [:g {:id "Canvas"
        :transform "translate(-2344 -40)"}
    [:g {:id "Polygon"}
     [:use {:href "#path0_fill"
            :transform "matrix(-1 9.54098e-18 -9.54098e-18 -1 2356 47)"
            :fill "#6EC0E6"}]]]
   [:defs
    [:path {:id "path0_fill"
            :d "M 6.05481 0L 12 7L 0 7L 6.05481 0Z"}]]])

(defn settings
  [& {:keys [fill]
      :or   {fill "white"}}]
  [:svg {:height "30px"
         :viewBox "0 0 164 164"}
   [:path {:fill fill
           :fill-rule "evenodd"
           :clip-rule "evenodd"
           :d "M81.84,164c-15.38,0-29.768-4.246-42.059-11.625L77.6,114.557  c34.776,10.805,55.768-19.881,43.504-49.777L99.648,86.235C85.9,100.154,65.377,79.619,79.119,65.877l21.541-21.542  c-25.989-15.371-63.361,9.68-50.728,44.244l-37.29,37.289C4.638,113.223,0,98.233,0,82.16C0,36.961,36.641,0.32,81.84,0.32  c45.199,0,81.839,36.641,81.839,81.84S127.039,164,81.84,164z"}]])

(defn open-external
  []
  [:svg {:height "30px"
         :viewBox "-1 -1 10 10"}
   [:path {:fill "white"
           :d "M0 0v8h8v-2h-1v1h-6v-6h1v-1h-2zm4 0l1.5 1.5-2.5 2.5 1 1 2.5-2.5 1.5 1.5v-4h-4z"}]])

(defn skip-to-end
  [& {:keys [fill]
      :or   {fill "#6EC0E6"}}]
  [:svg {:fill fill
         :height "10px"
         :viewBox "0 0 18 19"}
   [:g {:id "Canvas"
        :transform "translate(1083 -318)"}
    [:g {:id "Polygon"}
     [:use {:href "#path0_fill"
            :transform "matrix(1.48319e-16 1 -1 1.48319e-16 -1065 318)"}]]
    [:g {:id "Rectangle 3"}
     [:use {:href "#path1_fill"
            :transform "translate(-1068 318)"}]]]
   [:defs
    [:path {:id "path0_fill"
            :d "M 9.78788 0L 19 18L 0 18L 9.78788 0Z"}]
    [:path {:id "path1_fill"
            :d "M 0 0L 3 0L 3 19L 0 19L 0 0Z"}]]])

(defn round-arrow
  []
  [:svg {:width "34"
         :height "32"
         :viewBox "0 0 34 32"}
   [:g {:id "Canvas"
        :transform "translate(-918 -1231)"}
    [:g {:id "Vector"}
     [:use {:href "#path0_stroke"
            :transform "translate(921.009 1231)"
            :fill "#767A7C"}]]]
   [:defs
    [:path {:id "path0_stroke"
            :d "M 0 0L -2.8822 5.00262L 2.8913 4.99737L 0 0ZM -0.495905 4.5006C -0.476808 11.1305 -0.366878 16.1392 0.247919 19.9008C 0.867102 23.6815 2.01224 26.3073 4.17733 28.0747C 6.32558 29.8284 9.39641 30.6673 13.6945 31.0836C 17.9937 31.4994 23.6227 31.5 30.9712 31.5L 30.9712 30.5C 23.6227 30.5 18.0419 30.5006 13.791 30.0883C 9.53899 29.6764 6.71945 28.859 4.8097 27.3001C 2.91677 25.7548 1.83627 23.4118 1.23477 19.7391C 0.628892 16.0473 0.523116 11.1182 0.504091 4.49773L -0.495905 4.5006Z"}]]])

(defn up-arrow
  []
  [:svg {:height "10px"
         :viewBox "0 0 100 100"}
   [:g
    [:path {:fill "#6EC0E6"
            :d "M43.1,21.3L4.6,67.1c-4.9,5.8-0.8,14.8,6.9,14.8h77c7.6,0,11.8-8.9,6.9-14.8L56.9,21.3C53.3,17.1,46.7,17.1,43.1,21.3z"}]]])

(defn down-arrow
  []
  [:svg {:height "10px"
         :viewBox "0 0 100 100"}
   [:g
    [:path {:fill "#6EC0E6"
            :d "M56.9,78.7l38.5-45.7c4.9-5.8,0.8-14.8-6.9-14.8h-77c-7.6,0-11.8,8.9-6.9,14.8l38.5,45.7C46.7,82.9,53.3,82.9,56.9,78.7z"}]]])

(defn left
  [& {:keys [fill]}]
  [:svg {:fill fill
         :height "10px"
         :viewBox "0 0 100 100"}
   [:g
    [:path {:d "M4.5,53.6l42.5,26c2.9,1.7,6.5-0.3,6.5-3.6V61.7h40.6c1.9,0,3.4-1.5,3.4-3.4V41.7c0-1.9-1.5-3.4-3.4-3.4H53.5V24    c0-3.3-3.7-5.4-6.5-3.6l-42.5,26C1.8,48,1.8,52,4.5,53.6z"}]]])

(defn right
  [& {:keys [fill]}]
  [:svg {:fill fill
         :height "10px"
         :viewBox "0 0 100 100"}
   [:g
    [:path {:d "M95.5,46.4L53,20.3c-2.9-1.7-6.5,0.3-6.5,3.6v14.3H5.9c-1.9,0-3.4,1.5-3.4,3.4v16.7c0,1.9,1.5,3.4,3.4,3.4h40.6V76    c0,3.3,3.7,5.4,6.5,3.6l42.5-26C98.2,52,98.2,48,95.5,46.4z"}]]])