(ns dda.pallet.crate.dda-httpd-crate.domain-test
  (:require
   [clojure.test :refer :all]
   [dda.pallet.domain.dda-httpd-crate :as sut]
   [dda.pallet.crate.dda-httpd-crate.vhost-test :as vhost-test]))


(def pair-vhost-test-convention-config-1
  {:input-config {:domain-name "domain.name"}
   :expected {:domain-name "domain.name"
              :listening-port "443"
              :server-admin-email "admin@localdomain"
              :access-control ["Order allow,deny" "Allow from all" ""]}})

(def pair-vhost-test-convention-config-2
  {:input-config {:domain-name "domain.name"
                  :listening-port "420"
                  :access-control ["Override" "Access" "Control"]}
   :expected {:domain-name "domain.name"
              :listening-port "420"
              :access-control ["Override" "Access" "Control"]
              :server-admin-email "admin@localdomain"}})

(def domain-config
  {:vhosts
   {:example-vhost
    {:domain-name "my-domain"}}})

;TODO: compilation error
;(deftest config-test)
;  (is (= (sut/create-stack-vhost-config
;          (:input-config pair-vhost-test-convention-config-1)
;         (:expected pair-vhost-test-convention-config-1)}}}
;  (is (= (sut/create-stack-vhost-config
;          (:input-config pair-vhost-test-convention-config-2)
;         (:expected pair-vhost-test-convention-config-2)}}})
