#!/bin/bash

echo -e "\n====================\n"
echo -e "Waiting for ingress being up and running"
echo -e "\n====================\n"
 kubectl wait --namespace ingress-nginx \
  --for=condition=ready pod \
  --selector=app.kubernetes.io/component=controller \
  --timeout=120s

echo -e "\n====================\n"
echo -e "should show the correct ingress version"
echo -e "\n====================\n"
POD_NAMESPACE=ingress-nginx
POD_NAME=$(kubectl get pods -n $POD_NAMESPACE -l app.kubernetes.io/name=ingress-nginx --field-selector=status.phase=Running -o jsonpath='{.items[0].metadata.name}')
kubectl exec -it $POD_NAME -n $POD_NAMESPACE -- /nginx-ingress-controller --version

echo -e "\n====================\n"
echo -e "ingress-nginx   has type: LoadBalancer & external ip"
echo -e "\n====================\n"
kubectl get all --namespace ingress-nginx
