/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim;

import ddf.minim.AudioSignal;
import java.util.HashSet;
import java.util.Vector;

public class SignalChain
implements AudioSignal {
    private Vector<AudioSignal> signals = new Vector();
    private Vector<AudioSignal> signalsToRemove = new Vector();
    private HashSet<AudioSignal> enabled = new HashSet();
    private float[] tmpL;
    private float[] tmpR;

    public synchronized void add(AudioSignal signal) {
        this.signals.add(signal);
        this.enabled.add(signal);
    }

    public synchronized void remove(AudioSignal signal) {
        this.signalsToRemove.add(signal);
    }

    public synchronized AudioSignal remove(int i) {
        AudioSignal s = this.signals.remove(i);
        this.enabled.remove(s);
        return s;
    }

    public synchronized AudioSignal get(int i) {
        return this.signals.get(i);
    }

    public synchronized boolean contains(AudioSignal s) {
        return this.signals.contains(s);
    }

    public synchronized void enable(int i) {
        this.enabled.add(this.get(i));
    }

    public synchronized void enable(AudioSignal signal) {
        if (this.signals.contains(signal)) {
            this.enabled.add(signal);
        }
    }

    public synchronized void enableAll() {
        this.enabled.addAll(this.signals);
    }

    public synchronized boolean hasEnabled() {
        return this.enabled.size() > 0;
    }

    public synchronized boolean isEnabled(AudioSignal signal) {
        return this.enabled.contains(signal);
    }

    public synchronized void disable(int i) {
        this.enabled.remove(this.get(i));
    }

    public synchronized void disable(AudioSignal signal) {
        this.enabled.remove(signal);
    }

    public synchronized void disableAll() {
        this.enabled.clear();
    }

    public synchronized int size() {
        return this.signals.size();
    }

    public synchronized void clear() {
        this.signals.clear();
        this.enabled.clear();
    }

    public synchronized void generate(float[] signal) {
        if (this.tmpL == null) {
            this.tmpL = new float[signal.length];
        }
        for (int i = 0; i < this.signals.size(); ++i) {
            AudioSignal s = this.signals.get(i);
            if (!this.enabled.contains(s)) continue;
            for (int it = 0; it < this.tmpL.length; ++it) {
                this.tmpL[it] = 0.0f;
            }
            s.generate(this.tmpL);
            for (int is = 0; is < signal.length; ++is) {
                int n = is;
                signal[n] = signal[n] + this.tmpL[is];
            }
        }
        this.signals.removeAll(this.signalsToRemove);
        this.signalsToRemove.removeAllElements();
    }

    public synchronized void generate(float[] left, float[] right) {
        if (this.tmpL == null) {
            this.tmpL = new float[left.length];
        }
        if (this.tmpR == null) {
            this.tmpR = new float[right.length];
        }
        for (int i = 0; i < this.signals.size(); ++i) {
            AudioSignal s = this.signals.get(i);
            if (!this.enabled.contains(s)) continue;
            s.generate(this.tmpL, this.tmpR);
            for (int j = 0; j < left.length; ++j) {
                int n = j;
                left[n] = left[n] + this.tmpL[j];
                int n2 = j;
                right[n2] = right[n2] + this.tmpR[j];
            }
        }
        this.signals.removeAll(this.signalsToRemove);
        this.signalsToRemove.removeAllElements();
    }
}

