/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim;

import ddf.minim.AudioOutput;
import ddf.minim.Minim;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class UGen {
    private ArrayList<UGenInput> m_allInputs = new ArrayList();
    private float[] m_lastValues = new float[0];
    private float m_sampleRate;
    private int m_nOutputs = 0;
    private int m_currentTick = 0;

    protected UGen() {
    }

    public final UGen patch(UGen connectToUGen) {
        this.setSampleRate(connectToUGen.m_sampleRate);
        connectToUGen.addInput(this);
        ++this.m_nOutputs;
        Minim.debug("m_nOutputs = " + this.m_nOutputs);
        return connectToUGen;
    }

    public final UGen patch(UGenInput connectToInput) {
        this.setSampleRate(connectToInput.getOuterUGen().m_sampleRate);
        connectToInput.setIncomingUGen(this);
        ++this.m_nOutputs;
        Minim.debug("m_nOutputs = " + this.m_nOutputs);
        return connectToInput.getOuterUGen();
    }

    public final void patch(AudioOutput audioOutput) {
        Minim.debug("Patching " + this + " to the output " + audioOutput + ".");
        this.setSampleRate(audioOutput.sampleRate());
        this.setChannelCount(audioOutput.getFormat().getChannels());
        this.patch(audioOutput.bus);
    }

    protected void addInput(UGen input) {
        Minim.debug("UGen addInput called.");
        if (this.m_allInputs.size() > 0) {
            Minim.debug("Initializing default input on something");
            this.m_allInputs.get(0).setIncomingUGen(input);
        } else {
            System.err.println("Trying to connect to UGen with no default input.");
        }
    }

    public final void unpatch(AudioOutput audioOutput) {
        Minim.debug("Unpatching " + this + " from the output " + audioOutput + ".");
        this.unpatch(audioOutput.bus);
    }

    public final void unpatch(UGen fromUGen) {
        fromUGen.removeInput(this);
        --this.m_nOutputs;
        Minim.debug("m_nOutputs = " + this.m_nOutputs);
    }

    protected void removeInput(UGen input) {
        Minim.debug("UGen removeInput called.");
        for (int i = 0; i < this.m_allInputs.size(); ++i) {
            if (this.m_allInputs.get(i).getIncomingUGen() != input) continue;
            this.m_allInputs.get(i).setIncomingUGen(null);
        }
    }

    public final void tick(float[] channels) {
        if (this.m_nOutputs > 0) {
            this.m_currentTick = (this.m_currentTick + 1) % this.m_nOutputs;
        }
        if (0 == this.m_currentTick) {
            int i;
            for (i = 0; i < this.m_allInputs.size(); ++i) {
                this.m_allInputs.get(i).tick();
            }
            this.uGenerate(channels);
            for (i = 0; i < channels.length && i < this.m_lastValues.length; ++i) {
                this.m_lastValues[i] = channels[i];
            }
        } else {
            for (int i = 0; i < channels.length && i < this.m_lastValues.length; ++i) {
                channels[i] = this.m_lastValues[i];
            }
        }
    }

    protected abstract void uGenerate(float[] var1);

    public final float[] getLastValues() {
        return this.m_lastValues;
    }

    public final float sampleRate() {
        return this.m_sampleRate;
    }

    protected void sampleRateChanged() {
    }

    public final void setSampleRate(float newSampleRate) {
        if (this.m_sampleRate != newSampleRate) {
            this.m_sampleRate = newSampleRate;
            this.sampleRateChanged();
            for (int i = 0; i < this.m_allInputs.size(); ++i) {
                UGen inputIncoming = this.m_allInputs.get(i).getIncomingUGen();
                if (inputIncoming == null) continue;
                inputIncoming.setSampleRate(newSampleRate);
            }
        }
    }

    public void setChannelCount(int numberOfChannels) {
        for (int i = 0; i < this.m_allInputs.size(); ++i) {
            UGenInput input = this.m_allInputs.get(i);
            if (input.getInputType() != InputType.AUDIO) continue;
            input.setChannelCount(numberOfChannels);
        }
        if (this.m_lastValues.length != numberOfChannels) {
            this.m_lastValues = new float[numberOfChannels];
            this.channelCountChanged();
        }
    }

    public int channelCount() {
        return this.m_lastValues.length;
    }

    protected void channelCountChanged() {
    }

    public void printInputs() {
        for (int i = 0; i < this.m_allInputs.size(); ++i) {
            Minim.debug("m_allInputs " + i + " ");
            if (this.m_allInputs.get(i) == null) {
                Minim.debug("null");
                continue;
            }
            this.m_allInputs.get(i).printInput();
        }
    }

    protected UGenInput addControl() {
        return new UGenInput(InputType.CONTROL);
    }

    protected UGenInput addControl(float initialValue) {
        return new UGenInput(InputType.CONTROL, initialValue);
    }

    protected UGenInput addAudio() {
        return new UGenInput(InputType.AUDIO);
    }

    public final class UGenInput {
        private UGen m_incoming;
        private InputType m_inputType;
        private float[] m_lastValues;

        public UGenInput(InputType type) {
            this.m_inputType = type;
            UGen.this.m_allInputs.add(this);
            this.m_lastValues = new float[1];
        }

        public UGenInput(InputType type, float value) {
            this.m_inputType = type;
            UGen.this.m_allInputs.add(this);
            this.m_lastValues = new float[1];
            this.m_lastValues[0] = value;
        }

        public void setChannelCount(int numberOfChannels) {
            if (this.m_lastValues.length != numberOfChannels) {
                float val = this.m_lastValues.length > 0 ? this.m_lastValues[0] : 0.0f;
                this.m_lastValues = new float[numberOfChannels];
                Arrays.fill(this.m_lastValues, val);
            }
            if (this.m_incoming != null) {
                this.m_incoming.setChannelCount(numberOfChannels);
            }
        }

        public int channelCount() {
            return this.m_lastValues.length;
        }

        public InputType getInputType() {
            return this.m_inputType;
        }

        public UGen getOuterUGen() {
            return UGen.this;
        }

        public UGen getIncomingUGen() {
            return this.m_incoming;
        }

        public void setIncomingUGen(UGen in) {
            this.m_incoming = in;
            if (this.m_incoming != null) {
                this.m_incoming.setChannelCount(this.m_lastValues.length);
            }
        }

        public boolean isPatched() {
            return this.m_incoming != null;
        }

        public float[] getLastValues() {
            return this.m_lastValues;
        }

        public float getLastValue() {
            return this.m_lastValues[0];
        }

        public void setLastValue(float value) {
            for (int i = 0; i < this.m_lastValues.length; ++i) {
                this.m_lastValues[i] = value;
            }
        }

        void tick() {
            if (this.m_incoming != null) {
                this.m_incoming.tick(this.m_lastValues);
            }
        }

        public String getInputTypeAsString() {
            String typeLabel = null;
            switch (this.m_inputType) {
                case AUDIO: {
                    typeLabel = "AUDIO";
                    break;
                }
                case CONTROL: {
                    typeLabel = "CONTROL";
                }
            }
            return typeLabel;
        }

        public void printInput() {
            Minim.debug("UGenInput:  signal = " + this.getInputTypeAsString() + " " + (this.m_incoming != null));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InputType {
        CONTROL,
        AUDIO;

    }
}

