/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.javasound;

import ddf.minim.javasound.JSMinim;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessControlException;
import java.util.HashMap;
import java.util.Map;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.Header;
import javazoom.spi.mpeg.sampled.file.IcyListener;
import javazoom.spi.mpeg.sampled.file.MpegAudioFileFormat;
import javazoom.spi.mpeg.sampled.file.MpegAudioFormat;
import javazoom.spi.mpeg.sampled.file.MpegEncoding;
import javazoom.spi.mpeg.sampled.file.MpegFileFormatType;
import javazoom.spi.mpeg.sampled.file.tag.IcyInputStream;
import javazoom.spi.mpeg.sampled.file.tag.MP3Tag;
import javazoom.spi.mpeg.sampled.file.tag.TagParseListener;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.file.TAudioFileReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MpegAudioFileReader
extends TAudioFileReader {
    public static final String VERSION = "MP3SPI 1.9.4";
    private String weak = null;
    private final AudioFormat.Encoding[][] sm_aEncodings = new AudioFormat.Encoding[][]{{MpegEncoding.MPEG2L1, MpegEncoding.MPEG2L2, MpegEncoding.MPEG2L3}, {MpegEncoding.MPEG1L1, MpegEncoding.MPEG1L2, MpegEncoding.MPEG1L3}, {MpegEncoding.MPEG2DOT5L1, MpegEncoding.MPEG2DOT5L2, MpegEncoding.MPEG2DOT5L3}};
    public static final int INITAL_READ_LENGTH = 128000;
    private static final int MARK_LIMIT = 128001;
    private static final String[] id3v1genres = new String[]{"Blues", "Classic Rock", "Country", "Dance", "Disco", "Funk", "Grunge", "Hip-Hop", "Jazz", "Metal", "New Age", "Oldies", "Other", "Pop", "R&B", "Rap", "Reggae", "Rock", "Techno", "Industrial", "Alternative", "Ska", "Death Metal", "Pranks", "Soundtrack", "Euro-Techno", "Ambient", "Trip-Hop", "Vocal", "Jazz+Funk", "Fusion", "Trance", "Classical", "Instrumental", "Acid", "House", "Game", "Sound Clip", "Gospel", "Noise", "AlternRock", "Bass", "Soul", "Punk", "Space", "Meditative", "Instrumental Pop", "Instrumental Rock", "Ethnic", "Gothic", "Darkwave", "Techno-Industrial", "Electronic", "Pop-Folk", "Eurodance", "Dream", "Southern Rock", "Comedy", "Cult", "Gangsta", "Top 40", "Christian Rap", "Pop/Funk", "Jungle", "Native American", "Cabaret", "New Wave", "Psychadelic", "Rave", "Showtunes", "Trailer", "Lo-Fi", "Tribal", "Acid Punk", "Acid Jazz", "Polka", "Retro", "Musical", "Rock & Roll", "Hard Rock", "Folk", "Folk-Rock", "National Folk", "Swing", "Fast Fusion", "Bebob", "Latin", "Revival", "Celtic", "Bluegrass", "Avantgarde", "Gothic Rock", "Progressive Rock", "Psychedelic Rock", "Symphonic Rock", "Slow Rock", "Big Band", "Chorus", "Easy Listening", "Acoustic", "Humour", "Speech", "Chanson", "Opera", "Chamber Music", "Sonata", "Symphony", "Booty Brass", "Primus", "Porn Groove", "Satire", "Slow Jam", "Club", "Tango", "Samba", "Folklore", "Ballad", "Power Ballad", "Rhythmic Soul", "Freestyle", "Duet", "Punk Rock", "Drum Solo", "A Capela", "Euro-House", "Dance Hall", "Goa", "Drum & Bass", "Club-House", "Hardcore", "Terror", "Indie", "BritPop", "Negerpunk", "Polsk Punk", "Beat", "Christian Gangsta Rap", "Heavy Metal", "Black Metal", "Crossover", "Contemporary Christian", "Christian Rock", "Merengue", "Salsa", "Thrash Metal", "Anime", "JPop", "SynthPop"};
    private Map<String, String> codeToPropName;
    protected JSMinim system;
    private static String[] ENC_TYPES = new String[]{"ISO-8859-1", "UTF16", "UTF-16BE", "UTF-8"};

    MpegAudioFileReader(JSMinim sys) {
        super(128001, true);
        this.system = sys;
        if (TDebug.TraceAudioFileReader) {
            TDebug.out((String)VERSION);
        }
        try {
            this.weak = System.getProperty("mp3spi.weak");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        this.codeToPropName = new HashMap<String, String>();
        this.codeToPropName.put("TAL", "album");
        this.codeToPropName.put("TT2", "title");
        this.codeToPropName.put("TYE", "date");
        this.codeToPropName.put("TP1", "author");
        this.codeToPropName.put("TCR", "copyright");
        this.codeToPropName.put("COM", "comment");
        this.codeToPropName.put("TCO", "mp3.id3tag.genre");
        this.codeToPropName.put("TRK", "mp3.id3tag.track");
        this.codeToPropName.put("TPA", "mp3.id3tag.disc");
        this.codeToPropName.put("TCM", "mp3.id3tag.composer");
        this.codeToPropName.put("TT1", "mp3.id3tag.grouping");
        this.codeToPropName.put("TEN", "mp3.id3tag.encoded");
        this.codeToPropName.put("TPB", "mp3.id3tag.publisher");
        this.codeToPropName.put("TP2", "mp3.id3tag.orchestra");
        this.codeToPropName.put("TLE", "mp3.id3tag.length");
        this.codeToPropName.put("TALB", "album");
        this.codeToPropName.put("TIT2", "title");
        this.codeToPropName.put("TYER", "date");
        this.codeToPropName.put("TDRC", "date");
        this.codeToPropName.put("TPE1", "author");
        this.codeToPropName.put("TCOP", "copyright");
        this.codeToPropName.put("WCOP", "copyright");
        this.codeToPropName.put("COMM", "comment");
        this.codeToPropName.put("TCON", "mp3.id3tag.genre");
        this.codeToPropName.put("TRCK", "mp3.id3tag.track");
        this.codeToPropName.put("TPOS", "mp3.id3tag.disc");
        this.codeToPropName.put("TCOM", "mp3.id3tag.composer");
        this.codeToPropName.put("TIT1", "mp3.id3tag.grouping");
        this.codeToPropName.put("TENC", "mp3.id3tag.encoded");
        this.codeToPropName.put("TPUB", "mp3.id3tag.publisher");
        this.codeToPropName.put("TPE2", "mp3.id3tag.orchestra");
        this.codeToPropName.put("TLEN", "mp3.id3tag.length");
        this.codeToPropName.put("USLT", "mp3.id3tag.lyrics");
    }

    public AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        return super.getAudioFileFormat(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioFileFormat getAudioFileFormat(URL url) throws UnsupportedAudioFileException, IOException {
        if (TDebug.TraceAudioFileReader) {
            TDebug.out((String)"MpegAudioFileReader.getAudioFileFormat(URL): begin");
        }
        long lFileLengthInBytes = -1L;
        URLConnection conn = url.openConnection();
        conn.setRequestProperty("Icy-Metadata", "1");
        InputStream inputStream = conn.getInputStream();
        AudioFileFormat audioFileFormat = null;
        try {
            audioFileFormat = this.getAudioFileFormat(inputStream, lFileLengthInBytes);
        }
        finally {
            inputStream.close();
        }
        if (TDebug.TraceAudioFileReader) {
            TDebug.out((String)"MpegAudioFileReader.getAudioFileFormat(URL): end");
        }
        return audioFileFormat;
    }

    public AudioFileFormat getAudioFileFormat(InputStream inputStream, long mediaLength) throws UnsupportedAudioFileException, IOException {
        this.system.debug("MpegAudioFileReader.getAudioFileFormat(InputStream inputStream, long mediaLength): begin");
        HashMap<String, Object> aff_properties = new HashMap<String, Object>();
        HashMap<String, Comparable<Boolean>> af_properties = new HashMap<String, Comparable<Boolean>>();
        int mLength = (int)mediaLength;
        int size = inputStream.available();
        PushbackInputStream pis = new PushbackInputStream(inputStream, 128001);
        byte[] head = new byte[22];
        pis.read(head);
        this.system.debug("InputStream : " + inputStream + " =>" + new String(head));
        if (head[0] == 82 && head[1] == 73 && head[2] == 70 && head[3] == 70 && head[8] == 87 && head[9] == 65 && head[10] == 86 && head[11] == 69) {
            this.system.debug("RIFF/WAV stream found");
            int isPCM = head[21] << 8 & 0xFF00 | head[20] & 0xFF;
            if (this.weak == null && isPCM == 1) {
                throw new UnsupportedAudioFileException("WAV PCM stream found");
            }
        } else if (head[0] == 46 && head[1] == 115 && head[2] == 110 && head[3] == 100) {
            this.system.debug("AU stream found");
            if (this.weak == null) {
                throw new UnsupportedAudioFileException("AU stream found");
            }
        } else if (head[0] == 70 && head[1] == 79 && head[2] == 82 && head[3] == 77 && head[8] == 65 && head[9] == 73 && head[10] == 70 && head[11] == 70) {
            this.system.debug("AIFF stream found");
            if (this.weak == null) {
                throw new UnsupportedAudioFileException("AIFF stream found");
            }
        } else if (head[0] == 77 | head[0] == 109 && head[1] == 65 | head[1] == 97 && head[2] == 67 | head[2] == 99) {
            this.system.debug("APE stream found");
            if (this.weak == null) {
                throw new UnsupportedAudioFileException("APE stream found");
            }
        } else if (head[0] == 70 | head[0] == 102 && head[1] == 76 | head[1] == 108 && head[2] == 65 | head[2] == 97 && head[3] == 67 | head[3] == 99) {
            this.system.debug("FLAC stream found");
            if (this.weak == null) {
                throw new UnsupportedAudioFileException("FLAC stream found");
            }
        } else if (head[0] == 73 | head[0] == 105 && head[1] == 67 | head[1] == 99 && head[2] == 89 | head[2] == 121) {
            pis.unread(head);
            this.loadShoutcastInfo(pis, aff_properties);
        } else if (head[0] == 79 | head[0] == 111 && head[1] == 71 | head[1] == 103 && head[2] == 71 | head[2] == 103) {
            this.system.debug("Ogg stream found");
            if (this.weak == null) {
                throw new UnsupportedAudioFileException("Ogg stream found");
            }
        } else {
            pis.unread(head);
        }
        int nVersion = -1;
        int nLayer = -1;
        int nMode = -1;
        int FrameSize = -1;
        int nFrequency = -1;
        int nTotalFrames = -1;
        float FrameRate = -1.0f;
        int BitRate = -1;
        int nChannels = -1;
        int nHeader = -1;
        int nTotalMS = -1;
        boolean nVBR = false;
        AudioFormat.Encoding encoding = null;
        try {
            Bitstream m_bitstream = new Bitstream((InputStream)pis);
            aff_properties.put("mp3.header.pos", new Integer(m_bitstream.header_pos()));
            Header m_header = m_bitstream.readFrame();
            nVersion = m_header.version();
            if (nVersion == 2) {
                aff_properties.put("mp3.version.mpeg", Float.toString(2.5f));
            } else {
                aff_properties.put("mp3.version.mpeg", Integer.toString(2 - nVersion));
            }
            nLayer = m_header.layer();
            aff_properties.put("mp3.version.layer", Integer.toString(nLayer));
            nMode = m_header.mode();
            aff_properties.put("mp3.mode", new Integer(nMode));
            nChannels = nMode == 3 ? 1 : 2;
            aff_properties.put("mp3.channels", new Integer(nChannels));
            nVBR = m_header.vbr();
            af_properties.put("vbr", new Boolean(nVBR));
            aff_properties.put("mp3.vbr", new Boolean(nVBR));
            aff_properties.put("mp3.vbr.scale", new Integer(m_header.vbr_scale()));
            FrameSize = m_header.calculate_framesize();
            aff_properties.put("mp3.framesize.bytes", new Integer(FrameSize));
            if (FrameSize < 0) {
                throw new UnsupportedAudioFileException("Invalid FrameSize : " + FrameSize);
            }
            nFrequency = m_header.frequency();
            aff_properties.put("mp3.frequency.hz", new Integer(nFrequency));
            FrameRate = (float)(1.0 / (double)m_header.ms_per_frame() * 1000.0);
            aff_properties.put("mp3.framerate.fps", new Float(FrameRate));
            if (FrameRate < 0.0f) {
                throw new UnsupportedAudioFileException("Invalid FrameRate : " + FrameRate);
            }
            if (mLength != -1) {
                aff_properties.put("mp3.length.bytes", new Integer(mLength));
                nTotalFrames = m_header.max_number_of_frames(mLength);
                aff_properties.put("mp3.length.frames", new Integer(nTotalFrames));
            }
            BitRate = m_header.bitrate();
            af_properties.put("bitrate", new Integer(BitRate));
            aff_properties.put("mp3.bitrate.nominal.bps", new Integer(BitRate));
            nHeader = m_header.getSyncHeader();
            encoding = this.sm_aEncodings[nVersion][nLayer - 1];
            aff_properties.put("mp3.version.encoding", encoding.toString());
            if (mLength != -1) {
                nTotalMS = Math.round(m_header.total_ms(mLength));
                aff_properties.put("duration", new Long((long)nTotalMS * 1000L));
            }
            aff_properties.put("mp3.copyright", new Boolean(m_header.copyright()));
            aff_properties.put("mp3.original", new Boolean(m_header.original()));
            aff_properties.put("mp3.crc", new Boolean(m_header.checksums()));
            aff_properties.put("mp3.padding", new Boolean(m_header.padding()));
            InputStream id3v2 = m_bitstream.getRawID3v2();
            if (id3v2 != null) {
                aff_properties.put("mp3.id3tag.v2", id3v2);
                this.parseID3v2Frames(id3v2, aff_properties);
            }
            if (TDebug.TraceAudioFileReader) {
                TDebug.out((String)m_header.toString());
            }
        }
        catch (Exception e) {
            this.system.debug("not a MPEG stream:" + e.getMessage());
            throw new UnsupportedAudioFileException("not a MPEG stream:" + e.getMessage());
        }
        int cVersion = nHeader >> 19 & 3;
        if (cVersion == 1) {
            this.system.debug("not a MPEG stream: wrong version");
            throw new UnsupportedAudioFileException("not a MPEG stream: wrong version");
        }
        int cSFIndex = nHeader >> 10 & 3;
        if (cSFIndex == 3) {
            this.system.debug("not a MPEG stream: wrong sampling rate");
            throw new UnsupportedAudioFileException("not a MPEG stream: wrong sampling rate");
        }
        if ((long)size == mediaLength && mediaLength != -1L) {
            byte[] id3v1 = new byte[128];
            int toSkip = inputStream.available() - id3v1.length;
            if (toSkip > 0) {
                inputStream.skip(inputStream.available() - id3v1.length);
            }
            inputStream.read(id3v1, 0, id3v1.length);
            if (id3v1[0] == 84 && id3v1[1] == 65 && id3v1[2] == 71) {
                this.parseID3v1Frames(id3v1, aff_properties);
            }
        }
        MpegAudioFormat format = new MpegAudioFormat(encoding, (float)nFrequency, -1, nChannels, -1, FrameRate, true, af_properties);
        return new MpegAudioFileFormat(MpegFileFormatType.MP3, (AudioFormat)format, nTotalFrames, mLength, aff_properties);
    }

    public AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        if (TDebug.TraceAudioFileReader) {
            TDebug.out((String)"getAudioInputStream(File file)");
        }
        FileInputStream inputStream = new FileInputStream(file);
        try {
            return this.getAudioInputStream(inputStream);
        }
        catch (UnsupportedAudioFileException e) {
            if (inputStream != null) {
                ((InputStream)inputStream).close();
            }
            throw e;
        }
        catch (IOException e) {
            if (inputStream != null) {
                ((InputStream)inputStream).close();
            }
            throw e;
        }
    }

    public AudioInputStream getAudioInputStream(URL url) throws UnsupportedAudioFileException, IOException {
        this.system.debug("MpegAudioFileReader.getAudioInputStream(URL): begin");
        long lFileLengthInBytes = -1L;
        URLConnection conn = url.openConnection();
        boolean isShout = false;
        int toRead = 4;
        byte[] head = new byte[toRead];
        conn.setRequestProperty("Icy-Metadata", "1");
        BufferedInputStream bInputStream = new BufferedInputStream(conn.getInputStream());
        bInputStream.mark(toRead);
        int read = bInputStream.read(head, 0, toRead);
        if (read > 2 && head[0] == 73 | head[0] == 105 && head[1] == 67 | head[1] == 99 && head[2] == 89 | head[2] == 121) {
            isShout = true;
        }
        bInputStream.reset();
        BufferedInputStream inputStream = null;
        if (isShout) {
            IcyInputStream icyStream = new IcyInputStream((InputStream)bInputStream);
            icyStream.addTagParseListener((TagParseListener)IcyListener.getInstance());
            inputStream = icyStream;
        } else {
            String metaint = conn.getHeaderField("icy-metaint");
            if (metaint != null) {
                IcyInputStream icyStream = new IcyInputStream((InputStream)bInputStream, metaint);
                icyStream.addTagParseListener((TagParseListener)IcyListener.getInstance());
                inputStream = icyStream;
            } else {
                inputStream = bInputStream;
            }
        }
        AudioInputStream audioInputStream = null;
        try {
            audioInputStream = this.getAudioInputStream(inputStream, lFileLengthInBytes);
        }
        catch (UnsupportedAudioFileException e) {
            ((InputStream)inputStream).close();
            throw e;
        }
        catch (IOException e) {
            ((InputStream)inputStream).close();
            throw e;
        }
        this.system.debug("MpegAudioFileReader.getAudioInputStream(URL): end");
        return audioInputStream;
    }

    public AudioInputStream getAudioInputStream(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        this.system.debug("MpegAudioFileReader.getAudioInputStream(InputStream inputStream)");
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream);
        }
        return super.getAudioInputStream(inputStream);
    }

    protected void parseID3v1Frames(byte[] frames, HashMap<String, Object> props) {
        String genrev2;
        int genrev1;
        int start;
        String tag;
        block12: {
            if (TDebug.TraceAudioFileReader) {
                TDebug.out((String)"Parsing ID3v1");
            }
            tag = null;
            try {
                tag = new String(frames, 0, frames.length, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException e) {
                tag = new String(frames, 0, frames.length);
                if (!TDebug.TraceAudioFileReader) break block12;
                TDebug.out((String)"Cannot use ISO-8859-1");
            }
        }
        if (TDebug.TraceAudioFileReader) {
            TDebug.out((String)("ID3v1 frame dump='" + tag + "'"));
        }
        String titlev1 = this.chopSubstring(tag, start = 3, start += 30);
        String titlev2 = (String)props.get("title");
        if ((titlev2 == null || titlev2.length() == 0) && titlev1 != null) {
            props.put("title", titlev1);
        }
        String artistv1 = this.chopSubstring(tag, start, start += 30);
        String artistv2 = (String)props.get("author");
        if ((artistv2 == null || artistv2.length() == 0) && artistv1 != null) {
            props.put("author", artistv1);
        }
        String albumv1 = this.chopSubstring(tag, start, start += 30);
        String albumv2 = (String)props.get("album");
        if ((albumv2 == null || albumv2.length() == 0) && albumv1 != null) {
            props.put("album", albumv1);
        }
        String yearv1 = this.chopSubstring(tag, start, start += 4);
        String yearv2 = (String)props.get("year");
        if ((yearv2 == null || yearv2.length() == 0) && yearv1 != null) {
            props.put("date", yearv1);
        }
        String commentv1 = this.chopSubstring(tag, start, start += 28);
        String commentv2 = (String)props.get("comment");
        if ((commentv2 == null || commentv2.length() == 0) && commentv1 != null) {
            props.put("comment", commentv1);
        }
        String trackv1 = "" + (frames[126] & 0xFF);
        String trackv2 = (String)props.get("mp3.id3tag.track");
        if ((trackv2 == null || trackv2.length() == 0) && trackv1 != null) {
            props.put("mp3.id3tag.track", trackv1);
        }
        if ((genrev1 = frames[127] & 0xFF) >= 0 && genrev1 < id3v1genres.length && ((genrev2 = (String)props.get("mp3.id3tag.genre")) == null || genrev2.length() == 0)) {
            props.put("mp3.id3tag.genre", id3v1genres[genrev1]);
        }
        if (TDebug.TraceAudioFileReader) {
            TDebug.out((String)"ID3v1 parsed");
        }
    }

    private String chopSubstring(String s, int start, int end) {
        String str = null;
        try {
            str = s.substring(start, end);
            int loc = str.indexOf(0);
            if (loc != -1) {
                str = str.substring(0, loc);
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            this.system.error("Cannot chopSubString " + e.getMessage());
        }
        return str;
    }

    protected void parseID3v2Frames(InputStream frames, HashMap<String, Object> props) {
        byte[] bframes = null;
        int size = -1;
        try {
            size = frames.available();
            bframes = new byte[size];
            frames.mark(size);
            frames.read(bframes);
            frames.reset();
        }
        catch (IOException e) {
            this.system.error("Cannot parse ID3v2 :" + e.getMessage());
        }
        if (!"ID3".equals(new String(bframes, 0, 3))) {
            this.system.error("No ID3v2 header found!");
            return;
        }
        int v2version = bframes[3] & 0xFF;
        props.put("mp3.id3tag.v2.version", String.valueOf(v2version));
        if (v2version < 2 || v2version > 4) {
            this.system.error("Unsupported ID3v2 version " + v2version + "!");
            return;
        }
        try {
            this.system.debug("ID3v2 frame dump='" + new String(bframes, 0, bframes.length) + "'");
            String value = null;
            for (int i = 10; i < bframes.length && bframes[i] > 0; i += size) {
                String propName;
                if (v2version == 3 || v2version == 4) {
                    String code = new String(bframes, i, 4);
                    size = bframes[i + 4] << 24 & 0xFF000000 | bframes[i + 5] << 16 & 0xFF0000 | bframes[i + 6] << 8 & 0xFF00 | bframes[i + 7] & 0xFF;
                    i += 10;
                    if (!this.codeToPropName.containsKey(code)) {
                        this.system.error("Don't know the ID3 code " + code);
                        continue;
                    }
                    value = code.equals("COMM") || code.equals("USLT") ? this.parseComment(bframes, i, size) : (code.startsWith("W") ? this.parseText(bframes, i, size, 0) : this.parseText(bframes, i, size, 1));
                    if (value == null) {
                        value = "";
                    }
                    propName = this.codeToPropName.get(code);
                    props.put(propName, value);
                    continue;
                }
                String scode = new String(bframes, i, 3);
                size = 0 + (bframes[i + 3] << 16) + (bframes[i + 4] << 8) + bframes[i + 5];
                i += 6;
                if (!this.codeToPropName.containsKey(scode)) {
                    this.system.error("Don't know the ID3 code " + scode);
                    continue;
                }
                value = scode.equals("COM") ? this.parseText(bframes, i, size, 5) : this.parseText(bframes, i, size, 1);
                if (value == null) {
                    value = "";
                }
                propName = this.codeToPropName.get(scode);
                props.put(propName, value);
            }
        }
        catch (RuntimeException e) {
            this.system.error("Error parsing ID3v2: " + e.getMessage());
        }
        this.system.debug("ID3v2 parsed");
    }

    protected String parseText(byte[] bframes, int offset, int size, int skip) {
        String value = null;
        try {
            String enc = ENC_TYPES[0];
            if (bframes[offset] >= 0 && bframes[offset] < 4) {
                enc = ENC_TYPES[bframes[offset]];
            }
            value = new String(bframes, offset + skip, size - skip, enc);
            value = this.chopSubstring(value, 0, value.length());
        }
        catch (UnsupportedEncodingException e) {
            this.system.error("ID3v2 Encoding error: " + e.getMessage());
        }
        return value;
    }

    protected String parseComment(byte[] bframes, int offset, int size) {
        String value = null;
        try {
            int skip;
            String enc = ENC_TYPES[0];
            if (bframes[offset] >= 0 && bframes[offset] < 4) {
                enc = ENC_TYPES[bframes[offset]];
            }
            for (skip = 4; bframes[offset + skip] != 0 && skip < size; ++skip) {
            }
            while (bframes[offset + skip] == 0 && skip < size) {
                ++skip;
            }
            value = new String(bframes, offset + skip, size - skip, enc);
            value = this.chopSubstring(value, 0, value.length());
        }
        catch (UnsupportedEncodingException e) {
            this.system.error("ID3v2 Encoding error: " + e.getMessage());
        }
        return value;
    }

    protected void loadShoutcastInfo(InputStream input, HashMap<String, Object> props) throws IOException {
        MP3Tag[] meta;
        IcyInputStream icy = new IcyInputStream((InputStream)new BufferedInputStream(input));
        MP3Tag titleMP3Tag = icy.getTag("icy-name");
        if (titleMP3Tag != null) {
            props.put("title", ((String)titleMP3Tag.getValue()).trim());
        }
        if ((meta = icy.getTags()) != null) {
            for (int i = 0; i < meta.length; ++i) {
                String key = meta[i].getName();
                String value = ((String)icy.getTag(key).getValue()).trim();
                props.put("mp3.shoutcast.metadata." + key, value);
            }
        }
    }
}

