/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.UGen;
import ddf.minim.ugens.Frequency;
import ddf.minim.ugens.Waveform;
import ddf.minim.ugens.Waves;
import java.util.Arrays;

public class Oscil
extends UGen {
    public UGen.UGenInput amplitude = new UGen.UGenInput(UGen.InputType.CONTROL);
    public UGen.UGenInput frequency;
    public UGen.UGenInput phase;
    public UGen.UGenInput offset;
    private Waveform wave;
    private float step;
    private float stepSize;
    private float prevFreq;
    private float oneOverSampleRate;

    public Oscil(float frequencyInHertz, float amplitude, Waveform waveform) {
        this(Frequency.ofHertz(frequencyInHertz), amplitude, waveform);
    }

    public Oscil(float frequencyInHertz, float amplitude) {
        this(Frequency.ofHertz(frequencyInHertz), amplitude);
    }

    public Oscil(Frequency frequency, float amplitude) {
        this(frequency, amplitude, (Waveform)Waves.SINE);
    }

    public Oscil(Frequency frequency, float amplitude, Waveform waveform) {
        this.amplitude.setLastValue(amplitude);
        this.frequency = new UGen.UGenInput(UGen.InputType.CONTROL);
        this.frequency.setLastValue(frequency.asHz());
        this.phase = new UGen.UGenInput(UGen.InputType.CONTROL);
        this.phase.setLastValue(0.0f);
        this.offset = new UGen.UGenInput(UGen.InputType.CONTROL);
        this.offset.setLastValue(0.0f);
        this.wave = waveform;
        this.step = 0.0f;
        this.oneOverSampleRate = 1.0f;
    }

    protected void sampleRateChanged() {
        this.oneOverSampleRate = 1.0f / this.sampleRate();
        this.stepSize = this.frequency.getLastValue() * this.oneOverSampleRate;
        this.prevFreq = this.frequency.getLastValue();
    }

    private void updateStepSize() {
        float currFreq = this.frequency.getLastValue();
        if (this.prevFreq != currFreq) {
            this.stepSize = currFreq * this.oneOverSampleRate;
            this.prevFreq = currFreq;
        }
    }

    public void setFrequency(float hz) {
        this.frequency.setLastValue(hz);
        this.updateStepSize();
    }

    public void setFrequency(Frequency newFreq) {
        this.frequency.setLastValue(newFreq.asHz());
        this.updateStepSize();
    }

    public void setAmplitude(float newAmp) {
        this.amplitude.setLastValue(newAmp);
    }

    public void setPhase(float newPhase) {
        this.phase.setLastValue(newPhase);
    }

    public void setWaveform(Waveform theWaveform) {
        this.wave = theWaveform;
    }

    public Waveform getWaveform() {
        return this.wave;
    }

    public void reset() {
        this.step = this.phase.getLastValue();
    }

    protected void uGenerate(float[] channels) {
        float outAmp = this.amplitude.getLastValue();
        float tmpStep = this.step + this.phase.getLastValue();
        if (tmpStep < 0.0f) {
            tmpStep -= (float)((int)tmpStep) - 1.0f;
        }
        if (tmpStep > 1.0f) {
            tmpStep -= (float)((int)tmpStep);
        }
        float sample = outAmp * this.wave.value(tmpStep) + this.offset.getLastValue();
        Arrays.fill(channels, sample);
        this.updateStepSize();
        this.step += this.stepSize;
        if (this.step < 0.0f) {
            this.step -= (float)((int)this.step) - 1.0f;
        }
        if (this.step > 1.0f) {
            this.step -= (float)((int)this.step);
        }
    }
}

