/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim;

import ddf.minim.Recordable;
import ddf.minim.spi.AudioRecordingStream;
import ddf.minim.spi.SampleRecorder;

public class AudioRecorder {
    private Recordable source;
    private SampleRecorder recorder;

    public AudioRecorder(Recordable recordSource, SampleRecorder recorder) {
        this.source = recordSource;
        this.recorder = recorder;
        this.source.addListener(recorder);
    }

    public void beginRecord() {
        this.recorder.beginRecord();
    }

    public void endRecord() {
        this.recorder.endRecord();
    }

    public boolean isRecording() {
        return this.recorder.isRecording();
    }

    public AudioRecordingStream save() {
        return this.recorder.save();
    }

    public void setRecordSource(Recordable recordSource) {
        this.source.removeListener(this.recorder);
        this.source = recordSource;
        this.source.addListener(this.recorder);
    }

    public void setSampleRecorder(SampleRecorder recorder) {
        this.recorder.endRecord();
        this.recorder.save();
        this.source.removeListener(this.recorder);
        this.source.addListener(recorder);
        this.recorder = recorder;
    }
}

