/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.UGen;

public class TickRate
extends UGen {
    private UGen audio;
    public UGen.UGenInput value = new UGen.UGenInput(UGen.InputType.CONTROL);
    private float[] currentSample;
    private float[] nextSample;
    private float sampleCount;
    private boolean bInterpolate;

    public TickRate() {
        this(1.0f);
    }

    public TickRate(float tickRate) {
        this.value.setLastValue(tickRate);
        this.sampleCount = 0.0f;
        this.currentSample = new float[2];
        this.nextSample = new float[2];
        this.bInterpolate = false;
    }

    public final void setInterpolation(boolean doInterpolate) {
        this.bInterpolate = doInterpolate;
    }

    public final boolean isInterpolating() {
        return this.bInterpolate;
    }

    protected void addInput(UGen in) {
        this.audio = in;
        this.audio.setChannelCount(this.currentSample.length);
    }

    protected void removeInput(UGen in) {
        if (this.audio == in) {
            this.audio = null;
        }
    }

    protected void sampleRateChanged() {
        if (this.audio != null) {
            this.audio.setSampleRate(this.sampleRate());
        }
    }

    protected void channelCountChanged() {
        this.currentSample = new float[this.channelCount()];
        this.nextSample = new float[this.channelCount()];
        if (this.audio != null) {
            this.audio.setChannelCount(this.channelCount());
            this.audio.tick(this.currentSample);
            this.audio.tick(this.nextSample);
            this.sampleCount = 0.0f;
        }
    }

    protected void uGenerate(float[] channels) {
        float sampleStep = this.value.getLastValue();
        if (sampleStep <= 0.0f) {
            for (int i = 0; i < channels.length; ++i) {
                channels[i] = 0.0f;
            }
            return;
        }
        if (this.bInterpolate) {
            for (int i = 0; i < channels.length; ++i) {
                float sampleDiff = this.nextSample[i] - this.currentSample[i];
                channels[i] = this.currentSample[i] + sampleDiff * this.sampleCount;
            }
        } else {
            System.arraycopy(this.currentSample, 0, channels, 0, channels.length);
        }
        if (this.audio != null) {
            this.sampleCount += sampleStep;
            while (this.sampleCount >= 1.0f) {
                System.arraycopy(this.nextSample, 0, this.currentSample, 0, this.nextSample.length);
                this.audio.tick(this.nextSample);
                this.sampleCount -= 1.0f;
            }
        }
    }
}

