/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.effects;

import ddf.minim.AudioEffect;
import ddf.minim.UGen;

public abstract class IIRFilter
extends UGen
implements AudioEffect {
    public final UGen.UGenInput audio;
    public final UGen.UGenInput cutoff;
    protected float[] a;
    protected float[] b;
    private float[][] in;
    private float[][] out;
    private float prevCutoff;

    public IIRFilter(float freq, float sampleRate) {
        this.setSampleRate(sampleRate);
        this.audio = new UGen.UGenInput(this, UGen.InputType.AUDIO);
        this.cutoff = new UGen.UGenInput(this, UGen.InputType.CONTROL);
        this.cutoff.setLastValue(freq);
        this.prevCutoff = -1.0f;
    }

    private final void initArrays(int numChannels) {
        int memSize = this.a.length >= this.b.length ? this.a.length : this.b.length;
        this.in = new float[numChannels][memSize];
        this.out = new float[numChannels][memSize];
    }

    public final synchronized void uGenerate(float[] channels) {
        if (this.cutoff.getLastValue() != this.prevCutoff) {
            this.calcCoeff();
            this.prevCutoff = this.cutoff.getLastValue();
        }
        if (this.in == null || this.in.length < channels.length || this.in[0].length < this.a.length && this.in[0].length < this.b.length) {
            this.initArrays(channels.length);
        }
        int i = 0;
        while (i < channels.length) {
            System.arraycopy(this.in[i], 0, this.in[i], 1, this.in[i].length - 1);
            this.in[i][0] = this.audio.getLastValues()[i];
            float y = 0.0f;
            int ci = 0;
            while (ci < this.a.length) {
                y += this.a[ci] * this.in[i][ci];
                ++ci;
            }
            ci = 0;
            while (ci < this.b.length) {
                y += this.b[ci] * this.out[i][ci];
                ++ci;
            }
            System.arraycopy(this.out[i], 0, this.out[i], 1, this.out[i].length - 1);
            this.out[i][0] = y;
            channels[i] = y;
            ++i;
        }
    }

    public final synchronized void process(float[] signal) {
        this.setChannelCount(1);
        float[] tmp = new float[1];
        int i = 0;
        while (i < signal.length) {
            this.audio.setLastValue(signal[i]);
            this.uGenerate(tmp);
            signal[i] = tmp[0];
            ++i;
        }
    }

    public final synchronized void process(float[] sigLeft, float[] sigRight) {
        this.setChannelCount(2);
        float[] tmp = new float[2];
        int i = 0;
        while (i < sigLeft.length) {
            this.audio.getLastValues()[0] = sigLeft[i];
            this.audio.getLastValues()[1] = sigRight[i];
            this.uGenerate(tmp);
            sigLeft[i] = tmp[0];
            sigRight[i] = tmp[1];
            ++i;
        }
    }

    public final void setFreq(float f) {
        if (this.validFreq(f) && f != this.cutoff.getLastValue()) {
            this.prevCutoff = f;
            this.cutoff.setLastValue(f);
            this.calcCoeff();
        }
    }

    public boolean validFreq(float f) {
        return f > 0.0f;
    }

    public final float frequency() {
        return this.cutoff.getLastValue();
    }

    protected abstract void calcCoeff();

    public final void printCoeff() {
        int i;
        System.out.println("Filter coefficients: ");
        if (this.a != null) {
            i = 0;
            while (i < this.a.length) {
                System.out.print("  A" + i + ": " + this.a[i]);
                ++i;
            }
        }
        System.out.println();
        if (this.b != null) {
            i = 0;
            while (i < this.b.length) {
                System.out.print("  B" + (i + 1) + ": " + this.b[i]);
                ++i;
            }
            System.out.println();
        }
    }
}

