/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.UGen;

public class EnvelopeFollower
extends UGen {
    public UGen.UGenInput audio;
    private float m_attack;
    private float m_release;
    private float m_ga;
    private float m_gr;
    private float[] m_buffer;
    private int m_bufferCount;
    private float m_envelope;
    private float m_prevEnvelope;

    public EnvelopeFollower(float attackInSeconds, float releaseInSeconds, int bufferSize) {
        this.m_attack = attackInSeconds;
        this.m_release = releaseInSeconds;
        this.m_buffer = new float[bufferSize];
        this.m_bufferCount = 0;
        this.m_envelope = 0.0f;
        this.m_prevEnvelope = 0.0f;
        this.audio = new UGen.UGenInput(UGen.InputType.AUDIO);
    }

    protected void sampleRateChanged() {
        this.m_ga = (float)Math.exp(-1.0f / (this.sampleRate() * this.m_attack));
        this.m_gr = (float)Math.exp(-1.0f / (this.sampleRate() * this.m_release));
    }

    protected void uGenerate(float[] out) {
        float signal = 0.0f;
        float[] lastValues = this.audio.getLastValues();
        int i = 0;
        while (i < lastValues.length) {
            signal += lastValues[i] / (float)lastValues.length;
            ++i;
        }
        this.m_buffer[this.m_bufferCount++] = signal;
        if (this.m_bufferCount == this.m_buffer.length) {
            this.m_prevEnvelope = this.m_envelope;
            this.m_envelope = 0.0f;
            i = 0;
            while (i < this.m_buffer.length) {
                float envIn = Math.abs(this.m_buffer[i]);
                if (this.m_envelope < envIn) {
                    this.m_envelope *= this.m_ga;
                    this.m_envelope += (1.0f - this.m_ga) * envIn;
                } else {
                    this.m_envelope *= this.m_gr;
                    this.m_envelope += (1.0f - this.m_gr) * envIn;
                }
                ++i;
            }
            this.m_bufferCount = 0;
        }
        float outEnv = this.m_prevEnvelope + (this.m_envelope - this.m_prevEnvelope) * ((float)this.m_bufferCount / (float)this.m_buffer.length);
        int i2 = 0;
        while (i2 < out.length) {
            out[i2] = outEnv;
            ++i2;
        }
    }
}

