/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.AudioSignal;
import ddf.minim.Minim;
import ddf.minim.UGen;
import java.util.ArrayList;
import java.util.Arrays;

public class Summer
extends UGen
implements AudioSignal {
    private ArrayList<UGen> m_ugens = new ArrayList();
    private float[] m_tickBuffer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addInput(UGen input) {
        input.setChannelCount(this.channelCount());
        ArrayList<UGen> arrayList = this.m_ugens;
        synchronized (arrayList) {
            this.m_ugens.add(input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeInput(UGen input) {
        Minim.debug("Bus::removeInput - Removing " + input + " to the m_ugens list of " + this);
        ArrayList<UGen> arrayList = this.m_ugens;
        synchronized (arrayList) {
            int i = 0;
            while (i < this.m_ugens.size()) {
                if (this.m_ugens.get(i) == input) {
                    this.m_ugens.set(i, null);
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sampleRateChanged() {
        ArrayList<UGen> arrayList = this.m_ugens;
        synchronized (arrayList) {
            int i = 0;
            while (i < this.m_ugens.size()) {
                UGen u = this.m_ugens.get(i);
                if (u != null) {
                    u.setSampleRate(this.sampleRate());
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelCountChanged() {
        ArrayList<UGen> arrayList = this.m_ugens;
        synchronized (arrayList) {
            int i = 0;
            while (i < this.m_ugens.size()) {
                UGen u = this.m_ugens.get(i);
                if (u != null) {
                    u.setChannelCount(this.channelCount());
                }
                ++i;
            }
        }
        this.m_tickBuffer = new float[this.channelCount()];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void uGenerate(float[] channels) {
        UGen u;
        int i;
        ArrayList<UGen> arrayList;
        if (this.m_tickBuffer == null || this.m_tickBuffer.length != channels.length) {
            this.m_tickBuffer = new float[channels.length];
            arrayList = this.m_ugens;
            synchronized (arrayList) {
                i = 0;
                while (i < this.m_ugens.size()) {
                    u = this.m_ugens.get(i);
                    if (u != null) {
                        u.setChannelCount(channels.length);
                    } else {
                        this.m_ugens.remove(i);
                        --i;
                    }
                    ++i;
                }
            }
        }
        Arrays.fill(channels, 0.0f);
        arrayList = this.m_ugens;
        synchronized (arrayList) {
            i = 0;
            while (i < this.m_ugens.size()) {
                u = this.m_ugens.get(i);
                if (u != null) {
                    u.tick(this.m_tickBuffer);
                    this.processSampleFrame(this.m_tickBuffer, channels);
                } else {
                    this.m_ugens.remove(i);
                    --i;
                }
                ++i;
            }
        }
    }

    protected void processSampleFrame(float[] in, float[] out) {
        int i = 0;
        while (i < out.length) {
            int n = i;
            out[n] = out[n] + in[i];
            ++i;
        }
    }

    public void generate(float[] mono) {
        float[] sample = new float[1];
        int i = 0;
        while (i < mono.length) {
            this.tick(sample);
            mono[i] = sample[0];
            ++i;
        }
    }

    public void generate(float[] left, float[] right) {
        float[] sample = new float[2];
        int i = 0;
        while (i < left.length) {
            this.tick(sample);
            left[i] = sample[0];
            right[i] = sample[1];
            ++i;
        }
    }
}

