/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.UGen;
import ddf.minim.analysis.FFT;

public class Vocoder
extends UGen {
    public UGen.UGenInput audio = new UGen.UGenInput(UGen.InputType.AUDIO);
    public UGen.UGenInput modulator = new UGen.UGenInput(UGen.InputType.AUDIO);
    private int m_windowSize;
    private int m_windowSpacing;
    private float[] m_audioSamples;
    private float[] m_modulatorSamples;
    private float[] m_outputSamples;
    private int m_index;
    private int m_outputIndex;
    private int m_triggerCount;
    private float[] m_analysisSamples;
    private float m_outputScale;
    private FFT m_audioFFT;
    private FFT m_modulatorFFT;

    public Vocoder(int windowSize, int windowCount) {
        float overlapPercent = 1.0f;
        this.m_outputScale = 1.0f;
        if (windowCount > 1) {
            overlapPercent = 1.0f / (float)windowCount;
            this.m_outputScale = overlapPercent / 8.0f;
        }
        this.m_windowSize = windowSize;
        this.m_windowSpacing = (int)((float)windowSize * overlapPercent);
        int bufferSize = this.m_windowSize * 2 - this.m_windowSpacing;
        this.m_audioSamples = new float[bufferSize];
        this.m_modulatorSamples = new float[bufferSize];
        this.m_outputSamples = new float[bufferSize];
        this.m_analysisSamples = new float[windowSize];
        this.m_index = 0;
        this.m_triggerCount = this.m_windowSize;
    }

    protected void sampleRateChanged() {
        this.m_audioFFT = new FFT(this.m_windowSize, this.sampleRate());
        this.m_audioFFT.window(FFT.HAMMING);
        this.m_modulatorFFT = new FFT(this.m_windowSize, this.sampleRate());
        this.m_modulatorFFT.window(FFT.HAMMING);
    }

    private void analyze(FFT fft, float[] src) {
        int i = this.m_index - this.m_windowSize;
        int j = 0;
        while (i < this.m_index) {
            this.m_analysisSamples[j] = i < 0 ? src[src.length + i] : src[i];
            ++i;
            ++j;
        }
        fft.forward(this.m_analysisSamples);
    }

    protected void uGenerate(float[] out) {
        int i;
        this.m_audioSamples[this.m_index] = this.audio.getLastValue();
        this.m_modulatorSamples[this.m_index] = this.modulator.getLastValue();
        ++this.m_index;
        --this.m_triggerCount;
        if (this.m_index == this.m_audioSamples.length) {
            this.m_index = 0;
        }
        if (this.m_triggerCount == 0) {
            this.analyze(this.m_audioFFT, this.m_audioSamples);
            this.analyze(this.m_modulatorFFT, this.m_modulatorSamples);
            i = 0;
            while (i < this.m_audioFFT.specSize()) {
                this.m_audioFFT.scaleBand(i, this.m_modulatorFFT.getBand(i));
                ++i;
            }
            this.m_audioFFT.inverse(this.m_analysisSamples);
            FFT.HAMMING.apply(this.m_analysisSamples);
            int a = 0;
            while (a < this.m_windowSize) {
                int outIndex = this.m_outputIndex + a;
                if (outIndex >= this.m_outputSamples.length) {
                    outIndex -= this.m_outputSamples.length;
                }
                int n = outIndex;
                this.m_outputSamples[n] = this.m_outputSamples[n] + this.m_analysisSamples[a] * this.m_outputScale;
                ++a;
            }
            this.m_triggerCount = this.m_windowSpacing;
        }
        i = 0;
        while (i < out.length) {
            out[i] = this.m_outputSamples[this.m_outputIndex];
            ++i;
        }
        this.m_outputSamples[this.m_outputIndex] = 0.0f;
        ++this.m_outputIndex;
        if (this.m_outputIndex == this.m_outputSamples.length) {
            this.m_outputIndex = 0;
        }
    }
}

