/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.analysis;

import ddf.minim.Minim;
import ddf.minim.analysis.FourierTransform;

public class FFT
extends FourierTransform {
    private int[] reverse;
    private float[] sinlookup;
    private float[] coslookup;

    public FFT(int timeSize, float sampleRate) {
        super(timeSize, sampleRate);
        if ((timeSize & timeSize - 1) != 0) {
            throw new IllegalArgumentException("FFT: timeSize must be a power of two.");
        }
        this.buildReverseTable();
        this.buildTrigTables();
    }

    protected void allocateArrays() {
        this.spectrum = new float[this.timeSize / 2 + 1];
        this.real = new float[this.timeSize];
        this.imag = new float[this.timeSize];
    }

    public void scaleBand(int i, float s) {
        if (s < 0.0f) {
            Minim.error("Can't scale a frequency band by a negative value.");
            return;
        }
        int n = i;
        this.real[n] = this.real[n] * s;
        int n2 = i;
        this.imag[n2] = this.imag[n2] * s;
        int n3 = i;
        this.spectrum[n3] = this.spectrum[n3] * s;
        if (i != 0 && i != this.timeSize / 2) {
            this.real[this.timeSize - i] = this.real[i];
            this.imag[this.timeSize - i] = -this.imag[i];
        }
    }

    public void setBand(int i, float a) {
        if (a < 0.0f) {
            Minim.error("Can't set a frequency band to a negative value.");
            return;
        }
        if (this.real[i] == 0.0f && this.imag[i] == 0.0f) {
            this.real[i] = a;
            this.spectrum[i] = a;
        } else {
            int n = i;
            this.real[n] = this.real[n] / this.spectrum[i];
            int n2 = i;
            this.imag[n2] = this.imag[n2] / this.spectrum[i];
            this.spectrum[i] = a;
            int n3 = i;
            this.real[n3] = this.real[n3] * this.spectrum[i];
            int n4 = i;
            this.imag[n4] = this.imag[n4] * this.spectrum[i];
        }
        if (i != 0 && i != this.timeSize / 2) {
            this.real[this.timeSize - i] = this.real[i];
            this.imag[this.timeSize - i] = -this.imag[i];
        }
    }

    private void fft() {
        int halfSize = 1;
        while (halfSize < this.real.length) {
            float phaseShiftStepR = this.cos(halfSize);
            float phaseShiftStepI = this.sin(halfSize);
            float currentPhaseShiftR = 1.0f;
            float currentPhaseShiftI = 0.0f;
            int fftStep = 0;
            while (fftStep < halfSize) {
                int i = fftStep;
                while (i < this.real.length) {
                    int off = i + halfSize;
                    float tr = currentPhaseShiftR * this.real[off] - currentPhaseShiftI * this.imag[off];
                    float ti = currentPhaseShiftR * this.imag[off] + currentPhaseShiftI * this.real[off];
                    this.real[off] = this.real[i] - tr;
                    this.imag[off] = this.imag[i] - ti;
                    int n = i;
                    this.real[n] = this.real[n] + tr;
                    int n2 = i;
                    this.imag[n2] = this.imag[n2] + ti;
                    i += 2 * halfSize;
                }
                float tmpR = currentPhaseShiftR;
                currentPhaseShiftR = tmpR * phaseShiftStepR - currentPhaseShiftI * phaseShiftStepI;
                currentPhaseShiftI = tmpR * phaseShiftStepI + currentPhaseShiftI * phaseShiftStepR;
                ++fftStep;
            }
            halfSize *= 2;
        }
    }

    public void forward(float[] buffer) {
        if (buffer.length != this.timeSize) {
            Minim.error("FFT.forward: The length of the passed sample buffer must be equal to timeSize().");
            return;
        }
        this.doWindow(buffer);
        this.bitReverseSamples(buffer, 0);
        this.fft();
        this.fillSpectrum();
    }

    public void forward(float[] buffer, int startAt) {
        if (buffer.length - startAt < this.timeSize) {
            Minim.error("FourierTransform.forward: not enough samples in the buffer between " + startAt + " and " + buffer.length + " to perform a transform.");
            return;
        }
        this.currentWindow.apply(buffer, startAt, this.timeSize);
        this.bitReverseSamples(buffer, startAt);
        this.fft();
        this.fillSpectrum();
    }

    public void forward(float[] buffReal, float[] buffImag) {
        if (buffReal.length != this.timeSize || buffImag.length != this.timeSize) {
            Minim.error("FFT.forward: The length of the passed buffers must be equal to timeSize().");
            return;
        }
        this.setComplex(buffReal, buffImag);
        this.bitReverseComplex();
        this.fft();
        this.fillSpectrum();
    }

    public void inverse(float[] buffer) {
        if (buffer.length > this.real.length) {
            Minim.error("FFT.inverse: the passed array's length must equal FFT.timeSize().");
            return;
        }
        int i = 0;
        while (i < this.timeSize) {
            int n = i++;
            this.imag[n] = this.imag[n] * -1.0f;
        }
        this.bitReverseComplex();
        this.fft();
        i = 0;
        while (i < buffer.length) {
            buffer[i] = this.real[i] / (float)this.real.length;
            ++i;
        }
    }

    private void buildReverseTable() {
        int N = this.timeSize;
        this.reverse = new int[N];
        this.reverse[0] = 0;
        int limit = 1;
        int bit = N / 2;
        while (limit < N) {
            int i = 0;
            while (i < limit) {
                this.reverse[i + limit] = this.reverse[i] + bit;
                ++i;
            }
            limit <<= 1;
            bit >>= 1;
        }
    }

    private void bitReverseSamples(float[] samples, int startAt) {
        int i = 0;
        while (i < this.timeSize) {
            this.real[i] = samples[startAt + this.reverse[i]];
            this.imag[i] = 0.0f;
            ++i;
        }
    }

    private void bitReverseComplex() {
        float[] revReal = new float[this.real.length];
        float[] revImag = new float[this.imag.length];
        int i = 0;
        while (i < this.real.length) {
            revReal[i] = this.real[this.reverse[i]];
            revImag[i] = this.imag[this.reverse[i]];
            ++i;
        }
        this.real = revReal;
        this.imag = revImag;
    }

    private float sin(int i) {
        return this.sinlookup[i];
    }

    private float cos(int i) {
        return this.coslookup[i];
    }

    private void buildTrigTables() {
        int N = this.timeSize;
        this.sinlookup = new float[N];
        this.coslookup = new float[N];
        int i = 0;
        while (i < N) {
            this.sinlookup[i] = (float)Math.sin((float)(-Math.PI) / (float)i);
            this.coslookup[i] = (float)Math.cos((float)(-Math.PI) / (float)i);
            ++i;
        }
    }
}

