/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.analysis;

import ddf.minim.AudioBuffer;
import ddf.minim.Minim;
import ddf.minim.analysis.BartlettHannWindow;
import ddf.minim.analysis.BartlettWindow;
import ddf.minim.analysis.BlackmanWindow;
import ddf.minim.analysis.CosineWindow;
import ddf.minim.analysis.GaussWindow;
import ddf.minim.analysis.HammingWindow;
import ddf.minim.analysis.HannWindow;
import ddf.minim.analysis.LanczosWindow;
import ddf.minim.analysis.RectangularWindow;
import ddf.minim.analysis.TriangularWindow;
import ddf.minim.analysis.WindowFunction;

public abstract class FourierTransform {
    public static final WindowFunction NONE = new RectangularWindow();
    public static final WindowFunction HAMMING = new HammingWindow();
    public static final WindowFunction HANN = new HannWindow();
    public static final WindowFunction COSINE = new CosineWindow();
    public static final WindowFunction TRIANGULAR = new TriangularWindow();
    public static final WindowFunction BARTLETT = new BartlettWindow();
    public static final WindowFunction BARTLETTHANN = new BartlettHannWindow();
    public static final WindowFunction LANCZOS = new LanczosWindow();
    public static final WindowFunction BLACKMAN = new BlackmanWindow();
    public static final WindowFunction GAUSS = new GaussWindow();
    protected static final int LINAVG = 1;
    protected static final int LOGAVG = 2;
    protected static final int NOAVG = 3;
    protected static final float TWO_PI = (float)Math.PI * 2;
    protected int timeSize;
    protected int sampleRate;
    protected float bandWidth;
    protected WindowFunction currentWindow;
    protected float[] real;
    protected float[] imag;
    protected float[] spectrum;
    protected float[] averages;
    protected int whichAverage;
    protected int octaves;
    protected int avgPerOctave;

    FourierTransform(int ts, float sr) {
        this.timeSize = ts;
        this.sampleRate = (int)sr;
        this.bandWidth = 2.0f / (float)this.timeSize * ((float)this.sampleRate / 2.0f);
        this.noAverages();
        this.allocateArrays();
        this.currentWindow = new RectangularWindow();
    }

    protected abstract void allocateArrays();

    protected void setComplex(float[] r, float[] i) {
        if (this.real.length != r.length && this.imag.length != i.length) {
            Minim.error("FourierTransform.setComplex: the two arrays must be the same length as their member counterparts.");
        } else {
            System.arraycopy(r, 0, this.real, 0, r.length);
            System.arraycopy(i, 0, this.imag, 0, i.length);
        }
    }

    protected void fillSpectrum() {
        block6: {
            int i;
            block5: {
                i = 0;
                while (i < this.spectrum.length) {
                    this.spectrum[i] = (float)Math.sqrt(this.real[i] * this.real[i] + this.imag[i] * this.imag[i]);
                    ++i;
                }
                if (this.whichAverage != 1) break block5;
                int avgWidth = this.spectrum.length / this.averages.length;
                int i2 = 0;
                while (i2 < this.averages.length) {
                    float avg = 0.0f;
                    int j = 0;
                    while (j < avgWidth) {
                        int offset = j + i2 * avgWidth;
                        if (offset >= this.spectrum.length) break;
                        avg += this.spectrum[offset];
                        ++j;
                    }
                    this.averages[i2] = avg /= (float)(j + 1);
                    ++i2;
                }
                break block6;
            }
            if (this.whichAverage != 2) break block6;
            i = 0;
            while (i < this.octaves) {
                float lowFreq = i == 0 ? 0.0f : (float)(this.sampleRate / 2) / (float)Math.pow(2.0, this.octaves - i);
                float hiFreq = (float)(this.sampleRate / 2) / (float)Math.pow(2.0, this.octaves - i - 1);
                float freqStep = (hiFreq - lowFreq) / (float)this.avgPerOctave;
                float f = lowFreq;
                int j = 0;
                while (j < this.avgPerOctave) {
                    int offset = j + i * this.avgPerOctave;
                    this.averages[offset] = this.calcAvg(f, f + freqStep);
                    f += freqStep;
                    ++j;
                }
                ++i;
            }
        }
    }

    public void noAverages() {
        this.averages = new float[0];
        this.whichAverage = 3;
    }

    public void linAverages(int numAvg) {
        if (numAvg > this.spectrum.length / 2) {
            Minim.error("The number of averages for this transform can be at most " + this.spectrum.length / 2 + ".");
            return;
        }
        this.averages = new float[numAvg];
        this.whichAverage = 1;
    }

    public void logAverages(int minBandwidth, int bandsPerOctave) {
        float nyq = (float)this.sampleRate / 2.0f;
        this.octaves = 1;
        while ((nyq /= 2.0f) > (float)minBandwidth) {
            ++this.octaves;
        }
        Minim.debug("Number of octaves = " + this.octaves);
        this.avgPerOctave = bandsPerOctave;
        this.averages = new float[this.octaves * bandsPerOctave];
        this.whichAverage = 2;
    }

    public void window(WindowFunction windowFunction) {
        this.currentWindow = windowFunction;
    }

    protected void doWindow(float[] samples) {
        this.currentWindow.apply(samples);
    }

    public int timeSize() {
        return this.timeSize;
    }

    public int specSize() {
        return this.spectrum.length;
    }

    public float getBand(int i) {
        if (i < 0) {
            i = 0;
        }
        if (i > this.spectrum.length - 1) {
            i = this.spectrum.length - 1;
        }
        return this.spectrum[i];
    }

    public float getBandWidth() {
        return this.bandWidth;
    }

    public float getAverageBandWidth(int averageIndex) {
        if (this.whichAverage == 1) {
            int avgWidth = this.spectrum.length / this.averages.length;
            return (float)avgWidth * this.getBandWidth();
        }
        if (this.whichAverage == 2) {
            int octave = averageIndex / this.avgPerOctave;
            float lowFreq = octave == 0 ? 0.0f : (float)(this.sampleRate / 2) / (float)Math.pow(2.0, this.octaves - octave);
            float hiFreq = (float)(this.sampleRate / 2) / (float)Math.pow(2.0, this.octaves - octave - 1);
            float freqStep = (hiFreq - lowFreq) / (float)this.avgPerOctave;
            return freqStep;
        }
        return 0.0f;
    }

    public abstract void setBand(int var1, float var2);

    public abstract void scaleBand(int var1, float var2);

    public int freqToIndex(float freq) {
        if (freq < this.getBandWidth() / 2.0f) {
            return 0;
        }
        if (freq > (float)(this.sampleRate / 2) - this.getBandWidth() / 2.0f) {
            return this.spectrum.length - 1;
        }
        float fraction = freq / (float)this.sampleRate;
        int i = Math.round((float)this.timeSize * fraction);
        return i;
    }

    public float indexToFreq(int i) {
        float bw = this.getBandWidth();
        if (i == 0) {
            return bw * 0.25f;
        }
        if (i == this.spectrum.length - 1) {
            float lastBinBeginFreq = (float)(this.sampleRate / 2) - bw / 2.0f;
            float binHalfWidth = bw * 0.25f;
            return lastBinBeginFreq + binHalfWidth;
        }
        return (float)i * bw;
    }

    public float getAverageCenterFrequency(int i) {
        if (this.whichAverage == 1) {
            int avgWidth = this.spectrum.length / this.averages.length;
            int centerBinIndex = i * avgWidth + avgWidth / 2;
            return this.indexToFreq(centerBinIndex);
        }
        if (this.whichAverage == 2) {
            int octave = i / this.avgPerOctave;
            int offset = i % this.avgPerOctave;
            float lowFreq = octave == 0 ? 0.0f : (float)(this.sampleRate / 2) / (float)Math.pow(2.0, this.octaves - octave);
            float hiFreq = (float)(this.sampleRate / 2) / (float)Math.pow(2.0, this.octaves - octave - 1);
            float freqStep = (hiFreq - lowFreq) / (float)this.avgPerOctave;
            float f = lowFreq + (float)offset * freqStep;
            return f + freqStep / 2.0f;
        }
        return 0.0f;
    }

    public float getFreq(float freq) {
        return this.getBand(this.freqToIndex(freq));
    }

    public void setFreq(float freq, float a) {
        this.setBand(this.freqToIndex(freq), a);
    }

    public void scaleFreq(float freq, float s) {
        this.scaleBand(this.freqToIndex(freq), s);
    }

    public int avgSize() {
        return this.averages.length;
    }

    public float getAvg(int i) {
        float ret = this.averages.length > 0 ? this.averages[i] : 0.0f;
        return ret;
    }

    public float calcAvg(float lowFreq, float hiFreq) {
        int lowBound = this.freqToIndex(lowFreq);
        int hiBound = this.freqToIndex(hiFreq);
        float avg = 0.0f;
        int i = lowBound;
        while (i <= hiBound) {
            avg += this.spectrum[i];
            ++i;
        }
        return avg /= (float)(hiBound - lowBound + 1);
    }

    public float[] getSpectrumReal() {
        return this.real;
    }

    public float[] getSpectrumImaginary() {
        return this.imag;
    }

    public abstract void forward(float[] var1);

    public void forward(float[] buffer, int startAt) {
        if (buffer.length - startAt < this.timeSize) {
            Minim.error("FourierTransform.forward: not enough samples in the buffer between " + startAt + " and " + buffer.length + " to perform a transform.");
            return;
        }
        float[] section = new float[this.timeSize];
        System.arraycopy(buffer, startAt, section, 0, section.length);
        this.forward(section);
    }

    public void forward(AudioBuffer buffer) {
        this.forward(buffer.toArray());
    }

    public void forward(AudioBuffer buffer, int startAt) {
        this.forward(buffer.toArray(), startAt);
    }

    public abstract void inverse(float[] var1);

    public void inverse(AudioBuffer buffer) {
        this.inverse(buffer.toArray());
    }

    public void inverse(float[] freqReal, float[] freqImag, float[] buffer) {
        this.setComplex(freqReal, freqImag);
        this.inverse(buffer);
    }
}

