/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.analysis;

public abstract class WindowFunction {
    protected static final float TWO_PI = (float)Math.PI * 2;
    protected int length;

    public void apply(float[] samples) {
        this.length = samples.length;
        int n = 0;
        while (n < samples.length) {
            int n2 = n;
            samples[n2] = samples[n2] * this.value(samples.length, n);
            ++n;
        }
    }

    public void apply(float[] samples, int offset, int length) {
        this.length = length;
        int n = offset;
        while (n < offset + length) {
            int n2 = n;
            samples[n2] = samples[n2] * this.value(length, n - offset);
            ++n;
        }
    }

    public float[] generateCurve(int length) {
        float[] samples = new float[length];
        int n = 0;
        while (n < length) {
            samples[n] = 1.0f * this.value(length, n);
            ++n;
        }
        return samples;
    }

    protected abstract float value(int var1, int var2);
}

