/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.signals;

import ddf.minim.AudioSignal;

public class PinkNoise
implements AudioSignal {
    protected float amp;
    protected float pan;
    protected float leftScale;
    protected float rightScale;
    private int maxKey;
    private int key;
    private int range;
    private float[] whiteValues;
    private float maxSumEver;

    public PinkNoise() {
        this.amp = 1.0f;
        this.pan = 0.0f;
        this.rightScale = 1.0f;
        this.leftScale = 1.0f;
        this.initPink();
    }

    public PinkNoise(float amp) {
        this.setAmp(amp);
        this.pan = 0.0f;
        this.rightScale = 1.0f;
        this.leftScale = 1.0f;
        this.initPink();
    }

    public void setAmp(float a) {
        this.amp = this.constrain(a, 0.0f, 1.0f);
    }

    public void setPan(float p) {
        this.pan = this.constrain(p, -1.0f, 1.0f);
        this.calcLRScale();
    }

    public void generate(float[] signal) {
        int i = 0;
        while (i < signal.length) {
            signal[i] = this.amp * this.pink();
            ++i;
        }
    }

    public void generate(float[] left, float[] right) {
        int i = 0;
        while (i < left.length) {
            left[i] = this.leftScale * this.amp * this.pink();
            right[i] = this.rightScale * this.amp * this.pink();
            ++i;
        }
    }

    private void initPink() {
        this.maxKey = 31;
        this.range = 128;
        this.maxSumEver = 90.0f;
        this.key = 0;
        this.whiteValues = new float[6];
        int i = 0;
        while (i < 6) {
            this.whiteValues[i] = (float)Math.random() * 9.223372E18f % (float)(this.range / 6);
            ++i;
        }
    }

    private float pink() {
        int last_key = this.key++;
        if (this.key > this.maxKey) {
            this.key = 0;
        }
        int diff = last_key ^ this.key;
        float sum = 0.0f;
        int i = 0;
        while (i < 6) {
            if ((diff & 1 << i) != 0) {
                this.whiteValues[i] = (float)Math.random() * 9.223372E18f % (float)(this.range / 6);
            }
            sum += this.whiteValues[i];
            ++i;
        }
        if (sum > this.maxSumEver) {
            this.maxSumEver = sum;
        }
        sum = 2.0f * (sum / this.maxSumEver) - 1.0f;
        return sum;
    }

    private void calcLRScale() {
        if (this.pan <= 0.0f) {
            this.rightScale = this.pan + 1.0f;
            this.leftScale = 1.0f;
        }
        if (this.pan >= 0.0f) {
            this.leftScale = 1.0f - this.pan;
            this.rightScale = 1.0f;
        }
        if (this.pan == 0.0f) {
            this.rightScale = 1.0f;
            this.leftScale = 1.0f;
        }
    }

    float constrain(float val, float min, float max) {
        return val < min ? min : (val > max ? max : val);
    }
}

