/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.signals;

import ddf.minim.AudioSignal;

public class WhiteNoise
implements AudioSignal {
    protected float amp;
    protected float pan;
    protected float leftScale;
    protected float rightScale;

    public WhiteNoise() {
        this.amp = 1.0f;
        this.pan = 0.0f;
        this.rightScale = 1.0f;
        this.leftScale = 1.0f;
    }

    public WhiteNoise(float amp) {
        this.setAmp(amp);
        this.pan = 0.0f;
        this.rightScale = 1.0f;
        this.leftScale = 1.0f;
    }

    public void setAmp(float a) {
        this.amp = this.constrain(a, 0.0f, 1.0f);
    }

    public void setPan(float p) {
        this.pan = this.constrain(p, -1.0f, 1.0f);
        this.calcLRScale();
    }

    public void generate(float[] signal) {
        int i = 0;
        while (i < signal.length) {
            signal[i] = this.amp * (2.0f * (float)Math.random() - 1.0f);
            ++i;
        }
    }

    public void generate(float[] left, float[] right) {
        int i = 0;
        while (i < left.length) {
            left[i] = this.leftScale * this.amp * (2.0f * (float)Math.random() - 1.0f);
            right[i] = this.rightScale * this.amp * (2.0f * (float)Math.random() - 1.0f);
            ++i;
        }
    }

    private void calcLRScale() {
        if (this.pan <= 0.0f) {
            this.rightScale = this.pan + 1.0f;
            this.leftScale = 1.0f;
        }
        if (this.pan >= 0.0f) {
            this.leftScale = 1.0f - this.pan;
            this.rightScale = 1.0f;
        }
        if (this.pan == 0.0f) {
            this.rightScale = 1.0f;
            this.leftScale = 1.0f;
        }
    }

    float constrain(float val, float min, float max) {
        return val < min ? min : (val > max ? max : val);
    }
}

