// Compiled by ClojureScript 1.10.339 {}
goog.provide('cljs.compiler');
goog.require('cljs.core');
goog.require('goog.string');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.tools.reader');
goog.require('cljs.env');
goog.require('cljs.analyzer');
goog.require('cljs.source_map');
goog.require('goog.string.StringBuffer');
cljs.compiler.js_reserved = cljs.analyzer.js_reserved;
cljs.compiler.es5_GT__EQ_ = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.comp.call(null,cljs.core.mapcat.call(null,(function (lang){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lang,cljs.core.keyword.call(null,clojure.string.replace(cljs.core.name.call(null,lang),/^ecmascript/,"es"))], null);
}))),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ecmascript5","ecmascript5",342717552),new cljs.core.Keyword(null,"ecmascript5-strict","ecmascript5-strict",888234811),new cljs.core.Keyword(null,"ecmascript6","ecmascript6",723864898),new cljs.core.Keyword(null,"ecmascript6-strict","ecmascript6-strict",-786049555),new cljs.core.Keyword(null,"ecmascript-2015","ecmascript-2015",-902254444),new cljs.core.Keyword(null,"ecmascript6-typed","ecmascript6-typed",-1978203054),new cljs.core.Keyword(null,"ecmascript-2016","ecmascript-2016",471574729),new cljs.core.Keyword(null,"ecmascript-2017","ecmascript-2017",620145058),new cljs.core.Keyword(null,"ecmascript-next","ecmascript-next",-1935155962)], null));
cljs.compiler._STAR_recompiled_STAR_ = null;
cljs.compiler._STAR_inputs_STAR_ = null;
cljs.compiler._STAR_source_map_data_STAR_ = null;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.PersistentArrayMap.EMPTY;
cljs.compiler.cljs_reserved_file_names = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["deps.cljs",null], null), null);
/**
 * Gets the part up to the first `.` of a namespace.
 * Returns the empty string for nil.
 * Returns the entire string if no `.` in namespace
 */
cljs.compiler.get_first_ns_segment = (function cljs$compiler$get_first_ns_segment(ns){
var ns__$1 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)].join('');
var idx = ns__$1.indexOf(".");
if(((-1) === idx)){
return ns__$1;
} else {
return cljs.core.subs.call(null,ns__$1,(0),idx);
}
});
cljs.compiler.find_ns_starts_with = (function cljs$compiler$find_ns_starts_with(needle){
return cljs.core.reduce_kv.call(null,(function (xs,ns,_){
if(cljs.core._EQ_.call(null,needle,cljs.compiler.get_first_ns_segment.call(null,ns))){
return cljs.core.reduced.call(null,needle);
} else {
return null;
}
}),null,new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
});
cljs.compiler.shadow_depth = (function cljs$compiler$shadow_depth(s){
var map__11735 = s;
var map__11735__$1 = ((((!((map__11735 == null)))?(((((map__11735.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11735.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11735):map__11735);
var name = cljs.core.get.call(null,map__11735__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.call(null,map__11735__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var d = (0);
var G__11738 = info;
var map__11739 = G__11738;
var map__11739__$1 = ((((!((map__11739 == null)))?(((((map__11739.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11739.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11739):map__11739);
var shadow = cljs.core.get.call(null,map__11739__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
var d__$1 = d;
var G__11738__$1 = G__11738;
while(true){
var d__$2 = d__$1;
var map__11741 = G__11738__$1;
var map__11741__$1 = ((((!((map__11741 == null)))?(((((map__11741.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11741.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11741):map__11741);
var shadow__$1 = cljs.core.get.call(null,map__11741__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
if(cljs.core.truth_(shadow__$1)){
var G__11743 = (d__$2 + (1));
var G__11744 = shadow__$1;
d__$1 = G__11743;
G__11738__$1 = G__11744;
continue;
} else {
if(cljs.core.truth_(cljs.compiler.find_ns_starts_with.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('')))){
return (d__$2 + (1));
} else {
return d__$2;

}
}
break;
}
});
cljs.compiler.hash_scope = (function cljs$compiler$hash_scope(s){
return cljs.core.hash_combine.call(null,cljs.core._hash.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(s)),cljs.compiler.shadow_depth.call(null,s));
});
cljs.compiler.fn_self_name = (function cljs$compiler$fn_self_name(p__11745){
var map__11746 = p__11745;
var map__11746__$1 = ((((!((map__11746 == null)))?(((((map__11746.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11746.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11746):map__11746);
var name_var = map__11746__$1;
var name = cljs.core.get.call(null,map__11746__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.call(null,map__11746__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var name__$1 = clojure.string.replace([cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''),"..","_DOT__DOT_");
var map__11748 = info;
var map__11748__$1 = ((((!((map__11748 == null)))?(((((map__11748.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11748.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11748):map__11748);
var ns = cljs.core.get.call(null,map__11748__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var fn_scope = cljs.core.get.call(null,map__11748__$1,new cljs.core.Keyword(null,"fn-scope","fn-scope",-865664859));
var scoped_name = cljs.core.apply.call(null,cljs.core.str,cljs.core.interpose.call(null,"_$_",cljs.core.concat.call(null,cljs.core.map.call(null,cljs.core.comp.call(null,cljs.core.str,new cljs.core.Keyword(null,"name","name",1843675177)),fn_scope),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [name__$1], null))));
return cljs.core.symbol.call(null,cljs.compiler.munge.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.replace([cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)].join(''),".","$")),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(scoped_name)].join('')));
});
cljs.compiler.munge_reserved = (function cljs$compiler$munge_reserved(reserved){
return (function (s){
if(!((cljs.core.get.call(null,reserved,s) == null))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"$"].join('');
} else {
return s;
}
});
});
cljs.compiler.munge = (function cljs$compiler$munge(var_args){
var G__11751 = arguments.length;
switch (G__11751) {
case 1:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.compiler.munge.call(null,s,cljs.compiler.js_reserved);
});

cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2 = (function (s,reserved){
if(cljs.analyzer.cljs_map_QMARK_.call(null,s)){
var name_var = s;
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(name_var);
var field = new cljs.core.Keyword(null,"field","field",-1302436500).cljs$core$IFn$_invoke$arity$1(name_var);
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(name_var);
if(!((new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531).cljs$core$IFn$_invoke$arity$1(info) == null))){
return cljs.compiler.fn_self_name.call(null,s);
} else {
var depth = cljs.compiler.shadow_depth.call(null,s);
var code = cljs.compiler.hash_scope.call(null,s);
var renamed = cljs.core.get.call(null,cljs.compiler._STAR_lexical_renames_STAR_,code);
var name__$1 = ((field === true)?["self__.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):((!((renamed == null)))?renamed:name
));
var munged_name = cljs.compiler.munge.call(null,name__$1,reserved);
if(((field === true) || ((depth === (0))))){
return munged_name;
} else {
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(munged_name),"__$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(depth)].join(''));
}
}
} else {
var ss = clojure.string.replace([cljs.core.str.cljs$core$IFn$_invoke$arity$1(s)].join(''),"..","_DOT__DOT_");
var ss__$1 = clojure.string.replace(ss,(new RegExp("\\/(.)")),".$1");
var rf = cljs.compiler.munge_reserved.call(null,reserved);
var ss__$2 = cljs.core.map.call(null,rf,clojure.string.split(ss__$1,/\./));
var ss__$3 = clojure.string.join(".",ss__$2);
var ms = cljs.core.munge_str.call(null,ss__$3);
if((s instanceof cljs.core.Symbol)){
return cljs.core.symbol.call(null,ms);
} else {
return ms;
}
}
});

cljs.compiler.munge.cljs$lang$maxFixedArity = 2;

cljs.compiler.comma_sep = (function cljs$compiler$comma_sep(xs){
return cljs.core.interpose.call(null,",",xs);
});
cljs.compiler.escape_char = (function cljs$compiler$escape_char(c){
var cp = goog.string.hashCode(c);
var G__11753 = cp;
switch (G__11753) {
case (34):
return "\\\"";

break;
case (92):
return "\\\\";

break;
case (8):
return "\\b";

break;
case (12):
return "\\f";

break;
case (10):
return "\\n";

break;
case (13):
return "\\r";

break;
case (9):
return "\\t";

break;
default:
if(((((31) < cp)) && ((cp < (127))))){
return c;
} else {
var unpadded = cp.toString((16));
var pad = cljs.core.subs.call(null,"0000",unpadded.length);
return ["\\u",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pad),cljs.core.str.cljs$core$IFn$_invoke$arity$1(unpadded)].join('');
}

}
});
cljs.compiler.escape_string = (function cljs$compiler$escape_string(s){
var sb = (new goog.string.StringBuffer());
var seq__11755_11759 = cljs.core.seq.call(null,s);
var chunk__11756_11760 = null;
var count__11757_11761 = (0);
var i__11758_11762 = (0);
while(true){
if((i__11758_11762 < count__11757_11761)){
var c_11763 = cljs.core._nth.call(null,chunk__11756_11760,i__11758_11762);
sb.append(cljs.compiler.escape_char.call(null,c_11763));


var G__11764 = seq__11755_11759;
var G__11765 = chunk__11756_11760;
var G__11766 = count__11757_11761;
var G__11767 = (i__11758_11762 + (1));
seq__11755_11759 = G__11764;
chunk__11756_11760 = G__11765;
count__11757_11761 = G__11766;
i__11758_11762 = G__11767;
continue;
} else {
var temp__5457__auto___11768 = cljs.core.seq.call(null,seq__11755_11759);
if(temp__5457__auto___11768){
var seq__11755_11769__$1 = temp__5457__auto___11768;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11755_11769__$1)){
var c__4351__auto___11770 = cljs.core.chunk_first.call(null,seq__11755_11769__$1);
var G__11771 = cljs.core.chunk_rest.call(null,seq__11755_11769__$1);
var G__11772 = c__4351__auto___11770;
var G__11773 = cljs.core.count.call(null,c__4351__auto___11770);
var G__11774 = (0);
seq__11755_11759 = G__11771;
chunk__11756_11760 = G__11772;
count__11757_11761 = G__11773;
i__11758_11762 = G__11774;
continue;
} else {
var c_11775 = cljs.core.first.call(null,seq__11755_11769__$1);
sb.append(cljs.compiler.escape_char.call(null,c_11775));


var G__11776 = cljs.core.next.call(null,seq__11755_11769__$1);
var G__11777 = null;
var G__11778 = (0);
var G__11779 = (0);
seq__11755_11759 = G__11776;
chunk__11756_11760 = G__11777;
count__11757_11761 = G__11778;
i__11758_11762 = G__11779;
continue;
}
} else {
}
}
break;
}

return sb.toString();
});
cljs.compiler.wrap_in_double_quotes = (function cljs$compiler$wrap_in_double_quotes(x){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1("\""),cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\"")].join('');
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_STAR_ = (function (){var method_table__4414__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4415__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4416__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4417__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4418__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"cljs.compiler","emit*"),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4418__auto__,method_table__4414__auto__,prefer_table__4415__auto__,method_cache__4416__auto__,cached_hierarchy__4417__auto__));
})();
}
cljs.compiler.emit = (function cljs$compiler$emit(ast){
var val__10128__auto__ = cljs.env._STAR_compiler_STAR_;
if((val__10128__auto__ == null)){
cljs.env._STAR_compiler_STAR_ = cljs.env.default_compiler_env.call(null);
} else {
}

try{if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
var map__11780_11785 = ast;
var map__11780_11786__$1 = ((((!((map__11780_11785 == null)))?(((((map__11780_11785.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11780_11785.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11780_11785):map__11780_11785);
var env_11787 = cljs.core.get.call(null,map__11780_11786__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core.truth_(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(env_11787))){
var map__11782_11788 = env_11787;
var map__11782_11789__$1 = ((((!((map__11782_11788 == null)))?(((((map__11782_11788.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11782_11788.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11782_11788):map__11782_11788);
var line_11790 = cljs.core.get.call(null,map__11782_11789__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_11791 = cljs.core.get.call(null,map__11782_11789__$1,new cljs.core.Keyword(null,"column","column",2078222095));
cljs.core.swap_BANG_.call(null,cljs.compiler._STAR_source_map_data_STAR_,((function (map__11782_11788,map__11782_11789__$1,line_11790,column_11791,map__11780_11785,map__11780_11786__$1,env_11787,val__10128__auto__){
return (function (m){
var minfo = (function (){var G__11784 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gcol","gcol",309250807),new cljs.core.Keyword(null,"gen-col","gen-col",1901918303).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"gline","gline",-1086242431),new cljs.core.Keyword(null,"gen-line","gen-line",589592125).cljs$core$IFn$_invoke$arity$1(m)], null);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(ast),new cljs.core.Keyword(null,"var","var",-769682797))){
return cljs.core.assoc.call(null,G__11784,new cljs.core.Keyword(null,"name","name",1843675177),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(ast)))].join(''));
} else {
return G__11784;
}
})();
return cljs.core.update_in.call(null,m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"source-map","source-map",1706252311),(line_11790 - (1))], null),cljs.core.fnil.call(null,((function (minfo,map__11782_11788,map__11782_11789__$1,line_11790,column_11791,map__11780_11785,map__11780_11786__$1,env_11787,val__10128__auto__){
return (function (line__$1){
return cljs.core.update_in.call(null,line__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(column_11791)?(column_11791 - (1)):(0))], null),cljs.core.fnil.call(null,((function (minfo,map__11782_11788,map__11782_11789__$1,line_11790,column_11791,map__11780_11785,map__11780_11786__$1,env_11787,val__10128__auto__){
return (function (column__$1){
return cljs.core.conj.call(null,column__$1,minfo);
});})(minfo,map__11782_11788,map__11782_11789__$1,line_11790,column_11791,map__11780_11785,map__11780_11786__$1,env_11787,val__10128__auto__))
,cljs.core.PersistentVector.EMPTY));
});})(minfo,map__11782_11788,map__11782_11789__$1,line_11790,column_11791,map__11780_11785,map__11780_11786__$1,env_11787,val__10128__auto__))
,cljs.core.sorted_map.call(null)));
});})(map__11782_11788,map__11782_11789__$1,line_11790,column_11791,map__11780_11785,map__11780_11786__$1,env_11787,val__10128__auto__))
);
} else {
}
} else {
}

return cljs.compiler.emit_STAR_.call(null,ast);
}finally {if((val__10128__auto__ == null)){
cljs.env._STAR_compiler_STAR_ = null;
} else {
}
}});
cljs.compiler.emits = (function cljs$compiler$emits(var_args){
var args__4534__auto__ = [];
var len__4531__auto___11798 = arguments.length;
var i__4532__auto___11799 = (0);
while(true){
if((i__4532__auto___11799 < len__4531__auto___11798)){
args__4534__auto__.push((arguments[i__4532__auto___11799]));

var G__11800 = (i__4532__auto___11799 + (1));
i__4532__auto___11799 = G__11800;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((0) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((0)),(0),null)):null);
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(argseq__4535__auto__);
});

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic = (function (xs){
var seq__11794_11801 = cljs.core.seq.call(null,xs);
var chunk__11795_11802 = null;
var count__11796_11803 = (0);
var i__11797_11804 = (0);
while(true){
if((i__11797_11804 < count__11796_11803)){
var x_11805 = cljs.core._nth.call(null,chunk__11795_11802,i__11797_11804);
if((x_11805 == null)){
} else {
if(cljs.analyzer.cljs_map_QMARK_.call(null,x_11805)){
cljs.compiler.emit.call(null,x_11805);
} else {
if(cljs.analyzer.cljs_seq_QMARK_.call(null,x_11805)){
cljs.core.apply.call(null,cljs.compiler.emits,x_11805);
} else {
if(goog.isFunction(x_11805)){
x_11805.call(null);
} else {
var s_11806 = cljs.core.print_str.call(null,x_11805);
if((cljs.compiler._STAR_source_map_data_STAR_ == null)){
} else {
cljs.core.swap_BANG_.call(null,cljs.compiler._STAR_source_map_data_STAR_,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gen-col","gen-col",1901918303)], null),((function (seq__11794_11801,chunk__11795_11802,count__11796_11803,i__11797_11804,s_11806,x_11805){
return (function (p1__11792_SHARP_){
return (p1__11792_SHARP_ + cljs.core.count.call(null,s_11806));
});})(seq__11794_11801,chunk__11795_11802,count__11796_11803,i__11797_11804,s_11806,x_11805))
);
}

cljs.core.print.call(null,s_11806);

}
}
}
}


var G__11807 = seq__11794_11801;
var G__11808 = chunk__11795_11802;
var G__11809 = count__11796_11803;
var G__11810 = (i__11797_11804 + (1));
seq__11794_11801 = G__11807;
chunk__11795_11802 = G__11808;
count__11796_11803 = G__11809;
i__11797_11804 = G__11810;
continue;
} else {
var temp__5457__auto___11811 = cljs.core.seq.call(null,seq__11794_11801);
if(temp__5457__auto___11811){
var seq__11794_11812__$1 = temp__5457__auto___11811;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11794_11812__$1)){
var c__4351__auto___11813 = cljs.core.chunk_first.call(null,seq__11794_11812__$1);
var G__11814 = cljs.core.chunk_rest.call(null,seq__11794_11812__$1);
var G__11815 = c__4351__auto___11813;
var G__11816 = cljs.core.count.call(null,c__4351__auto___11813);
var G__11817 = (0);
seq__11794_11801 = G__11814;
chunk__11795_11802 = G__11815;
count__11796_11803 = G__11816;
i__11797_11804 = G__11817;
continue;
} else {
var x_11818 = cljs.core.first.call(null,seq__11794_11812__$1);
if((x_11818 == null)){
} else {
if(cljs.analyzer.cljs_map_QMARK_.call(null,x_11818)){
cljs.compiler.emit.call(null,x_11818);
} else {
if(cljs.analyzer.cljs_seq_QMARK_.call(null,x_11818)){
cljs.core.apply.call(null,cljs.compiler.emits,x_11818);
} else {
if(goog.isFunction(x_11818)){
x_11818.call(null);
} else {
var s_11819 = cljs.core.print_str.call(null,x_11818);
if((cljs.compiler._STAR_source_map_data_STAR_ == null)){
} else {
cljs.core.swap_BANG_.call(null,cljs.compiler._STAR_source_map_data_STAR_,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gen-col","gen-col",1901918303)], null),((function (seq__11794_11801,chunk__11795_11802,count__11796_11803,i__11797_11804,s_11819,x_11818,seq__11794_11812__$1,temp__5457__auto___11811){
return (function (p1__11792_SHARP_){
return (p1__11792_SHARP_ + cljs.core.count.call(null,s_11819));
});})(seq__11794_11801,chunk__11795_11802,count__11796_11803,i__11797_11804,s_11819,x_11818,seq__11794_11812__$1,temp__5457__auto___11811))
);
}

cljs.core.print.call(null,s_11819);

}
}
}
}


var G__11820 = cljs.core.next.call(null,seq__11794_11812__$1);
var G__11821 = null;
var G__11822 = (0);
var G__11823 = (0);
seq__11794_11801 = G__11820;
chunk__11795_11802 = G__11821;
count__11796_11803 = G__11822;
i__11797_11804 = G__11823;
continue;
}
} else {
}
}
break;
}

return null;
});

cljs.compiler.emits.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
cljs.compiler.emits.cljs$lang$applyTo = (function (seq11793){
var self__4519__auto__ = this;
return self__4519__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq11793));
});

cljs.compiler.emitln = (function cljs$compiler$emitln(var_args){
var args__4534__auto__ = [];
var len__4531__auto___11829 = arguments.length;
var i__4532__auto___11830 = (0);
while(true){
if((i__4532__auto___11830 < len__4531__auto___11829)){
args__4534__auto__.push((arguments[i__4532__auto___11830]));

var G__11831 = (i__4532__auto___11830 + (1));
i__4532__auto___11830 = G__11831;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((0) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((0)),(0),null)):null);
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(argseq__4535__auto__);
});

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic = (function (xs){
cljs.core.apply.call(null,cljs.compiler.emits,xs);

var _STAR_flush_on_newline_STAR_11825_11832 = cljs.core._STAR_flush_on_newline_STAR_;
cljs.core._STAR_flush_on_newline_STAR_ = false;

try{cljs.core.println.call(null);
}finally {cljs.core._STAR_flush_on_newline_STAR_ = _STAR_flush_on_newline_STAR_11825_11832;
}
if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
cljs.core.swap_BANG_.call(null,cljs.compiler._STAR_source_map_data_STAR_,(function (p__11826){
var map__11827 = p__11826;
var map__11827__$1 = ((((!((map__11827 == null)))?(((((map__11827.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11827.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11827):map__11827);
var m = map__11827__$1;
var gen_line = cljs.core.get.call(null,map__11827__$1,new cljs.core.Keyword(null,"gen-line","gen-line",589592125));
return cljs.core.assoc.call(null,m,new cljs.core.Keyword(null,"gen-line","gen-line",589592125),(gen_line + (1)),new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(0));
}));
} else {
}

return null;
});

cljs.compiler.emitln.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
cljs.compiler.emitln.cljs$lang$applyTo = (function (seq11824){
var self__4519__auto__ = this;
return self__4519__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq11824));
});

cljs.compiler.emit_str = (function cljs$compiler$emit_str(expr){
var sb__4462__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR_11833_11835 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR_11834_11836 = cljs.core._STAR_print_fn_STAR_;
cljs.core._STAR_print_newline_STAR_ = true;

cljs.core._STAR_print_fn_STAR_ = ((function (_STAR_print_newline_STAR_11833_11835,_STAR_print_fn_STAR_11834_11836,sb__4462__auto__){
return (function (x__4463__auto__){
return sb__4462__auto__.append(x__4463__auto__);
});})(_STAR_print_newline_STAR_11833_11835,_STAR_print_fn_STAR_11834_11836,sb__4462__auto__))
;

try{cljs.compiler.emit.call(null,expr);
}finally {cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR_11834_11836;

cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR_11833_11835;
}
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4462__auto__)].join('');
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_constant !== 'undefined')){
} else {
cljs.compiler.emit_constant = (function (){var method_table__4414__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4415__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4416__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4417__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4418__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"cljs.compiler","emit-constant"),cljs.core.type,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4418__auto__,method_table__4414__auto__,prefer_table__4415__auto__,method_cache__4416__auto__,cached_hierarchy__4417__auto__));
})();
}
cljs.core._add_method.call(null,cljs.compiler.emit_constant,new cljs.core.Keyword(null,"default","default",-1987822328),(function (x){
throw cljs.core.ex_info.call(null,["failed compiling constant: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"; ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type.call(null,x))," is not a valid ClojureScript constant."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"constant","constant",-379609303),x,new cljs.core.Keyword(null,"type","type",1174270348),cljs.core.type.call(null,x)], null));
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant,null,(function (x){
return cljs.compiler.emits.call(null,"null");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant,Number,(function (x){
if(cljs.core.truth_(isNaN(x))){
return cljs.compiler.emits.call(null,"NaN");
} else {
if(cljs.core.not.call(null,isFinite(x))){
return cljs.compiler.emits.call(null,(((x > (0)))?"Infinity":"-Infinity"));
} else {
return cljs.compiler.emits.call(null,"(",x,")");

}
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant,String,(function (x){
return cljs.compiler.emits.call(null,cljs.compiler.wrap_in_double_quotes.call(null,cljs.compiler.escape_string.call(null,x)));
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant,Boolean,(function (x){
return cljs.compiler.emits.call(null,(cljs.core.truth_(x)?"true":"false"));
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant,RegExp,(function (x){
if(cljs.core._EQ_.call(null,"",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''))){
return cljs.compiler.emits.call(null,"(new RegExp(\"\"))");
} else {
var vec__11837 = cljs.core.re_find.call(null,/^(?:\(\?([idmsux]*)\))?(.*)/,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''));
var _ = cljs.core.nth.call(null,vec__11837,(0),null);
var flags = cljs.core.nth.call(null,vec__11837,(1),null);
var pattern = cljs.core.nth.call(null,vec__11837,(2),null);
return cljs.compiler.emits.call(null,pattern);
}
}));
cljs.compiler.emits_keyword = (function cljs$compiler$emits_keyword(kw){
var ns = cljs.core.namespace.call(null,kw);
var name = cljs.core.name.call(null,kw);
cljs.compiler.emits.call(null,"new cljs.core.Keyword(");

cljs.compiler.emit_constant.call(null,ns);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,name);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,(cljs.core.truth_(ns)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):name));

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,cljs.core.hash.call(null,kw));

return cljs.compiler.emits.call(null,")");
});
cljs.compiler.emits_symbol = (function cljs$compiler$emits_symbol(sym){
var ns = cljs.core.namespace.call(null,sym);
var name = cljs.core.name.call(null,sym);
var symstr = ((!((ns == null)))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):name);
cljs.compiler.emits.call(null,"new cljs.core.Symbol(");

cljs.compiler.emit_constant.call(null,ns);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,name);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,symstr);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,cljs.core.hash.call(null,sym));

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,null);

return cljs.compiler.emits.call(null,")");
});
cljs.core._add_method.call(null,cljs.compiler.emit_constant,cljs.core.Keyword,(function (x){
var temp__5455__auto__ = (function (){var and__3938__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__3938__auto__)){
return x.call(null,new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
} else {
return and__3938__auto__;
}
})();
if(cljs.core.truth_(temp__5455__auto__)){
var value = temp__5455__auto__;
return cljs.compiler.emits.call(null,"cljs.core.",value);
} else {
return cljs.compiler.emits_keyword.call(null,x);
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant,cljs.core.Symbol,(function (x){
var temp__5455__auto__ = (function (){var and__3938__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__3938__auto__)){
return x.call(null,new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
} else {
return and__3938__auto__;
}
})();
if(cljs.core.truth_(temp__5455__auto__)){
var value = temp__5455__auto__;
return cljs.compiler.emits.call(null,"cljs.core.",value);
} else {
return cljs.compiler.emits_symbol.call(null,x);
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant,Date,(function (date){
return cljs.compiler.emits.call(null,"new Date(",date.getTime(),")");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant,cljs.core.UUID,(function (uuid){
var uuid_str = uuid.toString();
return cljs.compiler.emits.call(null,"new cljs.core.UUID(\"",uuid_str,"\", ",cljs.core.hash.call(null,uuid_str),")");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"no-op","no-op",-93046065),(function (m){
return null;
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"var","var",-769682797),(function (p__11841){
var map__11842 = p__11841;
var map__11842__$1 = ((((!((map__11842 == null)))?(((((map__11842.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11842.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11842):map__11842);
var ast = map__11842__$1;
var info = cljs.core.get.call(null,map__11842__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var env = cljs.core.get.call(null,map__11842__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var form = cljs.core.get.call(null,map__11842__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var temp__5455__auto__ = new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292).cljs$core$IFn$_invoke$arity$1(ast);
if(cljs.core.truth_(temp__5455__auto__)){
var const_expr = temp__5455__auto__;
return cljs.compiler.emit.call(null,cljs.core.assoc.call(null,const_expr,new cljs.core.Keyword(null,"env","env",-1815813235),env));
} else {
var map__11844 = cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_);
var map__11844__$1 = ((((!((map__11844 == null)))?(((((map__11844.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11844.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11844):map__11844);
var cenv = map__11844__$1;
var options = cljs.core.get.call(null,map__11844__$1,new cljs.core.Keyword(null,"options","options",99638489));
var var_name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
var info__$1 = ((cljs.core._EQ_.call(null,cljs.core.namespace.call(null,var_name),"js"))?(function (){var js_module_name = cljs.core.get_in.call(null,cenv,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-module-index","js-module-index",2072061931),cljs.core.name.call(null,var_name),new cljs.core.Keyword(null,"name","name",1843675177)], null));
var or__3949__auto__ = js_module_name;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return cljs.core.name.call(null,var_name);
}
})():info);
if(cljs.core.truth_(new cljs.core.Keyword(null,"binding-form?","binding-form?",1728940169).cljs$core$IFn$_invoke$arity$1(ast))){
return cljs.compiler.emits.call(null,cljs.compiler.munge.call(null,ast));
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var reserved = (function (){var G__11846 = cljs.compiler.js_reserved;
if(cljs.core.truth_((function (){var and__3938__auto__ = cljs.compiler.es5_GT__EQ_.call(null,new cljs.core.Keyword(null,"language-out","language-out",334619882).cljs$core$IFn$_invoke$arity$1(options));
if(cljs.core.truth_(and__3938__auto__)){
return !((cljs.core.namespace.call(null,var_name) == null));
} else {
return and__3938__auto__;
}
})())){
return clojure.set.difference(G__11846,cljs.analyzer.es5_allowed);
} else {
return G__11846;
}
})();
var js_module = cljs.core.get_in.call(null,cenv,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-namespaces","js-namespaces",-471353612),(function (){var or__3949__auto__ = cljs.core.namespace.call(null,var_name);
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return cljs.core.name.call(null,var_name);
}
})()], null));
var info__$2 = (function (){var G__11847 = info__$1;
if(cljs.core.not_EQ_.call(null,form,new cljs.core.Symbol("js","-Infinity","js/-Infinity",958706333,null))){
return cljs.compiler.munge.call(null,G__11847,reserved);
} else {
return G__11847;
}
})();
var env__11727__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__11727__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

var G__11848_11849 = new cljs.core.Keyword(null,"module-type","module-type",1392760304).cljs$core$IFn$_invoke$arity$1(js_module);
var G__11848_11850__$1 = (((G__11848_11849 instanceof cljs.core.Keyword))?G__11848_11849.fqn:null);
switch (G__11848_11850__$1) {
case "commonjs":
if(cljs.core.truth_(cljs.core.namespace.call(null,var_name))){
cljs.compiler.emits.call(null,cljs.compiler.munge.call(null,cljs.core.namespace.call(null,var_name),reserved),"[\"default\"].",cljs.compiler.munge.call(null,cljs.core.name.call(null,var_name),reserved));
} else {
cljs.compiler.emits.call(null,cljs.compiler.munge.call(null,cljs.core.name.call(null,var_name),reserved),"[\"default\"]");
}

break;
case "es6":
if(cljs.core.truth_((function (){var and__3938__auto__ = cljs.core.namespace.call(null,var_name);
if(cljs.core.truth_(and__3938__auto__)){
return cljs.core._EQ_.call(null,"default",cljs.core.name.call(null,var_name));
} else {
return and__3938__auto__;
}
})())){
cljs.compiler.emits.call(null,cljs.compiler.munge.call(null,cljs.core.namespace.call(null,var_name),reserved),"[\"default\"]");
} else {
cljs.compiler.emits.call(null,info__$2);
}

break;
default:
cljs.compiler.emits.call(null,info__$2);

}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__11727__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}
}
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"the-var","the-var",1428415613),(function (p__11852){
var map__11853 = p__11852;
var map__11853__$1 = ((((!((map__11853 == null)))?(((((map__11853.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11853.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11853):map__11853);
var arg = map__11853__$1;
var env = cljs.core.get.call(null,map__11853__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var var$ = cljs.core.get.call(null,map__11853__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var sym = cljs.core.get.call(null,map__11853__$1,new cljs.core.Keyword(null,"sym","sym",-1444860305));
var meta = cljs.core.get.call(null,map__11853__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
if(cljs.analyzer.ast_QMARK_.call(null,sym)){
} else {
throw (new Error("Assert failed: (ana/ast? sym)"));
}

if(cljs.analyzer.ast_QMARK_.call(null,meta)){
} else {
throw (new Error("Assert failed: (ana/ast? meta)"));
}

var map__11855 = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(var$);
var map__11855__$1 = ((((!((map__11855 == null)))?(((((map__11855.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11855.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11855):map__11855);
var name = cljs.core.get.call(null,map__11855__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env__11727__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__11727__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"new cljs.core.Var(function(){return ",cljs.compiler.munge.call(null,name),";},",sym,",",meta,")");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__11727__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"with-meta","with-meta",-1566856820),(function (p__11857){
var map__11858 = p__11857;
var map__11858__$1 = ((((!((map__11858 == null)))?(((((map__11858.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11858.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11858):map__11858);
var expr = cljs.core.get.call(null,map__11858__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var meta = cljs.core.get.call(null,map__11858__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var env = cljs.core.get.call(null,map__11858__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__11727__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__11727__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"cljs.core.with_meta(",expr,",",meta,")");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__11727__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.array_map_threshold = (8);
cljs.compiler.distinct_keys_QMARK_ = (function cljs$compiler$distinct_keys_QMARK_(keys){
return ((cljs.core.every_QMARK_.call(null,(function (p1__11860_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__11860_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),keys)) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,keys)),cljs.core.count.call(null,keys))));
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"map","map",1371690461),(function (p__11861){
var map__11862 = p__11861;
var map__11862__$1 = ((((!((map__11862 == null)))?(((((map__11862.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11862.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11862):map__11862);
var env = cljs.core.get.call(null,map__11862__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var keys = cljs.core.get.call(null,map__11862__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.call(null,map__11862__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env__11727__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__11727__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if((cljs.core.count.call(null,keys) === (0))){
cljs.compiler.emits.call(null,"cljs.core.PersistentArrayMap.EMPTY");
} else {
if((cljs.core.count.call(null,keys) <= cljs.compiler.array_map_threshold)){
if(cljs.core.truth_(cljs.compiler.distinct_keys_QMARK_.call(null,keys))){
cljs.compiler.emits.call(null,"new cljs.core.PersistentArrayMap(null, ",cljs.core.count.call(null,keys),", [",cljs.compiler.comma_sep.call(null,cljs.core.interleave.call(null,keys,vals)),"], null)");
} else {
cljs.compiler.emits.call(null,"cljs.core.PersistentArrayMap.createAsIfByAssoc([",cljs.compiler.comma_sep.call(null,cljs.core.interleave.call(null,keys,vals)),"])");
}
} else {
cljs.compiler.emits.call(null,"cljs.core.PersistentHashMap.fromArrays([",cljs.compiler.comma_sep.call(null,keys),"],[",cljs.compiler.comma_sep.call(null,vals),"])");

}
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__11727__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"list","list",765357683),(function (p__11864){
var map__11865 = p__11864;
var map__11865__$1 = ((((!((map__11865 == null)))?(((((map__11865.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11865.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11865):map__11865);
var items = cljs.core.get.call(null,map__11865__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.call(null,map__11865__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__11727__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__11727__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(cljs.core.empty_QMARK_.call(null,items)){
cljs.compiler.emits.call(null,"cljs.core.List.EMPTY");
} else {
cljs.compiler.emits.call(null,"cljs.core.list(",cljs.compiler.comma_sep.call(null,items),")");
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__11727__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"vector","vector",1902966158),(function (p__11867){
var map__11868 = p__11867;
var map__11868__$1 = ((((!((map__11868 == null)))?(((((map__11868.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11868.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11868):map__11868);
var items = cljs.core.get.call(null,map__11868__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.call(null,map__11868__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__11727__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__11727__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(cljs.core.empty_QMARK_.call(null,items)){
cljs.compiler.emits.call(null,"cljs.core.PersistentVector.EMPTY");
} else {
var cnt_11870 = cljs.core.count.call(null,items);
if((cnt_11870 < (32))){
cljs.compiler.emits.call(null,"new cljs.core.PersistentVector(null, ",cnt_11870,", 5, cljs.core.PersistentVector.EMPTY_NODE, [",cljs.compiler.comma_sep.call(null,items),"], null)");
} else {
cljs.compiler.emits.call(null,"cljs.core.PersistentVector.fromArray([",cljs.compiler.comma_sep.call(null,items),"], true)");
}
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__11727__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.distinct_constants_QMARK_ = (function cljs$compiler$distinct_constants_QMARK_(items){
return ((cljs.core.every_QMARK_.call(null,(function (p1__11871_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__11871_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),items)) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,items)),cljs.core.count.call(null,items))));
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"set","set",304602554),(function (p__11872){
var map__11873 = p__11872;
var map__11873__$1 = ((((!((map__11873 == null)))?(((((map__11873.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11873.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11873):map__11873);
var items = cljs.core.get.call(null,map__11873__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.call(null,map__11873__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__11727__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__11727__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(cljs.core.empty_QMARK_.call(null,items)){
cljs.compiler.emits.call(null,"cljs.core.PersistentHashSet.EMPTY");
} else {
if(cljs.core.truth_(cljs.compiler.distinct_constants_QMARK_.call(null,items))){
cljs.compiler.emits.call(null,"new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, ",cljs.core.count.call(null,items),", [",cljs.compiler.comma_sep.call(null,cljs.core.interleave.call(null,items,cljs.core.repeat.call(null,"null"))),"], null), null)");
} else {
cljs.compiler.emits.call(null,"cljs.core.PersistentHashSet.createAsIfByAssoc([",cljs.compiler.comma_sep.call(null,items),"])");

}
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__11727__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"js-value","js-value",-758336661),(function (p__11875){
var map__11876 = p__11875;
var map__11876__$1 = ((((!((map__11876 == null)))?(((((map__11876.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11876.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11876):map__11876);
var items = cljs.core.get.call(null,map__11876__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var js_type = cljs.core.get.call(null,map__11876__$1,new cljs.core.Keyword(null,"js-type","js-type",539386702));
var env = cljs.core.get.call(null,map__11876__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__11727__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__11727__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(cljs.core._EQ_.call(null,js_type,new cljs.core.Keyword(null,"object","object",1474613949))){
cljs.compiler.emits.call(null,"({");

var temp__5457__auto___11894 = cljs.core.seq.call(null,items);
if(temp__5457__auto___11894){
var items_11895__$1 = temp__5457__auto___11894;
var vec__11878_11896 = items_11895__$1;
var seq__11879_11897 = cljs.core.seq.call(null,vec__11878_11896);
var first__11880_11898 = cljs.core.first.call(null,seq__11879_11897);
var seq__11879_11899__$1 = cljs.core.next.call(null,seq__11879_11897);
var vec__11881_11900 = first__11880_11898;
var k_11901 = cljs.core.nth.call(null,vec__11881_11900,(0),null);
var v_11902 = cljs.core.nth.call(null,vec__11881_11900,(1),null);
var r_11903 = seq__11879_11899__$1;
cljs.compiler.emits.call(null,"\"",cljs.core.name.call(null,k_11901),"\": ",v_11902);

var seq__11884_11904 = cljs.core.seq.call(null,r_11903);
var chunk__11885_11905 = null;
var count__11886_11906 = (0);
var i__11887_11907 = (0);
while(true){
if((i__11887_11907 < count__11886_11906)){
var vec__11888_11908 = cljs.core._nth.call(null,chunk__11885_11905,i__11887_11907);
var k_11909__$1 = cljs.core.nth.call(null,vec__11888_11908,(0),null);
var v_11910__$1 = cljs.core.nth.call(null,vec__11888_11908,(1),null);
cljs.compiler.emits.call(null,", \"",cljs.core.name.call(null,k_11909__$1),"\": ",v_11910__$1);


var G__11911 = seq__11884_11904;
var G__11912 = chunk__11885_11905;
var G__11913 = count__11886_11906;
var G__11914 = (i__11887_11907 + (1));
seq__11884_11904 = G__11911;
chunk__11885_11905 = G__11912;
count__11886_11906 = G__11913;
i__11887_11907 = G__11914;
continue;
} else {
var temp__5457__auto___11915__$1 = cljs.core.seq.call(null,seq__11884_11904);
if(temp__5457__auto___11915__$1){
var seq__11884_11916__$1 = temp__5457__auto___11915__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11884_11916__$1)){
var c__4351__auto___11917 = cljs.core.chunk_first.call(null,seq__11884_11916__$1);
var G__11918 = cljs.core.chunk_rest.call(null,seq__11884_11916__$1);
var G__11919 = c__4351__auto___11917;
var G__11920 = cljs.core.count.call(null,c__4351__auto___11917);
var G__11921 = (0);
seq__11884_11904 = G__11918;
chunk__11885_11905 = G__11919;
count__11886_11906 = G__11920;
i__11887_11907 = G__11921;
continue;
} else {
var vec__11891_11922 = cljs.core.first.call(null,seq__11884_11916__$1);
var k_11923__$1 = cljs.core.nth.call(null,vec__11891_11922,(0),null);
var v_11924__$1 = cljs.core.nth.call(null,vec__11891_11922,(1),null);
cljs.compiler.emits.call(null,", \"",cljs.core.name.call(null,k_11923__$1),"\": ",v_11924__$1);


var G__11925 = cljs.core.next.call(null,seq__11884_11916__$1);
var G__11926 = null;
var G__11927 = (0);
var G__11928 = (0);
seq__11884_11904 = G__11925;
chunk__11885_11905 = G__11926;
count__11886_11906 = G__11927;
i__11887_11907 = G__11928;
continue;
}
} else {
}
}
break;
}
} else {
}

cljs.compiler.emits.call(null,"})");
} else {
cljs.compiler.emits.call(null,"[",cljs.compiler.comma_sep.call(null,items),"]");
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__11727__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"record-value","record-value",-367500392),(function (p__11929){
var map__11930 = p__11929;
var map__11930__$1 = ((((!((map__11930 == null)))?(((((map__11930.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11930.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11930):map__11930);
var items = cljs.core.get.call(null,map__11930__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var ns = cljs.core.get.call(null,map__11930__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var name = cljs.core.get.call(null,map__11930__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.call(null,map__11930__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__11727__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__11727__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,ns,".map__GT_",name,"(",items,")");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__11727__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"const","const",1709929842),(function (p__11932){
var map__11933 = p__11932;
var map__11933__$1 = ((((!((map__11933 == null)))?(((((map__11933.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11933.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11933):map__11933);
var form = cljs.core.get.call(null,map__11933__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var env = cljs.core.get.call(null,map__11933__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var env__11727__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__11727__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_constant.call(null,form);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__11727__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}
}));
cljs.compiler.truthy_constant_QMARK_ = (function cljs$compiler$truthy_constant_QMARK_(p__11935){
var map__11936 = p__11935;
var map__11936__$1 = ((((!((map__11936 == null)))?(((((map__11936.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11936.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11936):map__11936);
var op = cljs.core.get.call(null,map__11936__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.call(null,map__11936__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.call(null,map__11936__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__3949__auto__ = (function (){var and__3938__auto__ = cljs.core._EQ_.call(null,op,new cljs.core.Keyword(null,"const","const",1709929842));
if(and__3938__auto__){
var and__3938__auto____$1 = form;
if(cljs.core.truth_(and__3938__auto____$1)){
return !(((((typeof form === 'string') && (cljs.core._EQ_.call(null,form,"")))) || (((typeof form === 'number') && ((form === (0)))))));
} else {
return and__3938__auto____$1;
}
} else {
return and__3938__auto__;
}
})();
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
var and__3938__auto__ = !((const_expr == null));
if(and__3938__auto__){
return cljs.compiler.truthy_constant_QMARK_.call(null,const_expr);
} else {
return and__3938__auto__;
}
}
});
cljs.compiler.falsey_constant_QMARK_ = (function cljs$compiler$falsey_constant_QMARK_(p__11938){
var map__11939 = p__11938;
var map__11939__$1 = ((((!((map__11939 == null)))?(((((map__11939.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11939.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11939):map__11939);
var op = cljs.core.get.call(null,map__11939__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.call(null,map__11939__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.call(null,map__11939__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__3949__auto__ = ((cljs.core._EQ_.call(null,op,new cljs.core.Keyword(null,"const","const",1709929842))) && (((form === false) || ((form == null)))));
if(or__3949__auto__){
return or__3949__auto__;
} else {
var and__3938__auto__ = !((const_expr == null));
if(and__3938__auto__){
return cljs.compiler.falsey_constant_QMARK_.call(null,const_expr);
} else {
return and__3938__auto__;
}
}
});
cljs.compiler.safe_test_QMARK_ = (function cljs$compiler$safe_test_QMARK_(env,e){
var tag = cljs.analyzer.infer_tag.call(null,env,e);
var or__3949__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"seq","seq",-177272256,null),null,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),null], null), null).call(null,tag);
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return cljs.compiler.truthy_constant_QMARK_.call(null,e);
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"if","if",-458814265),(function (p__11941){
var map__11942 = p__11941;
var map__11942__$1 = ((((!((map__11942 == null)))?(((((map__11942.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11942.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11942):map__11942);
var test = cljs.core.get.call(null,map__11942__$1,new cljs.core.Keyword(null,"test","test",577538877));
var then = cljs.core.get.call(null,map__11942__$1,new cljs.core.Keyword(null,"then","then",460598070));
var else$ = cljs.core.get.call(null,map__11942__$1,new cljs.core.Keyword(null,"else","else",-1508377146));
var env = cljs.core.get.call(null,map__11942__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var unchecked = cljs.core.get.call(null,map__11942__$1,new cljs.core.Keyword(null,"unchecked","unchecked",924418378));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
var checked = cljs.core.not.call(null,(function (){var or__3949__auto__ = unchecked;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return cljs.compiler.safe_test_QMARK_.call(null,env,test);
}
})());
if(cljs.core.truth_(cljs.compiler.truthy_constant_QMARK_.call(null,test))){
return cljs.compiler.emitln.call(null,then);
} else {
if(cljs.core.truth_(cljs.compiler.falsey_constant_QMARK_.call(null,test))){
return cljs.compiler.emitln.call(null,else$);
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"(",((checked)?"cljs.core.truth_":null),"(",test,")?",then,":",else$,")");
} else {
if(checked){
cljs.compiler.emitln.call(null,"if(cljs.core.truth_(",test,")){");
} else {
cljs.compiler.emitln.call(null,"if(",test,"){");
}

cljs.compiler.emitln.call(null,then,"} else {");

return cljs.compiler.emitln.call(null,else$,"}");
}

}
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"case*","case*",716180697),(function (p__11944){
var map__11945 = p__11944;
var map__11945__$1 = ((((!((map__11945 == null)))?(((((map__11945.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11945.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11945):map__11945);
var v = cljs.core.get.call(null,map__11945__$1,new cljs.core.Keyword(null,"v","v",21465059));
var tests = cljs.core.get.call(null,map__11945__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var thens = cljs.core.get.call(null,map__11945__$1,new cljs.core.Keyword(null,"thens","thens",226631442));
var default$ = cljs.core.get.call(null,map__11945__$1,new cljs.core.Keyword(null,"default","default",-1987822328));
var env = cljs.core.get.call(null,map__11945__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env),new cljs.core.Keyword(null,"expr","expr",745722291))){
cljs.compiler.emitln.call(null,"(function(){");
} else {
}

var gs = cljs.core.gensym.call(null,"caseval__");
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"var ",gs,";");
} else {
}

cljs.compiler.emitln.call(null,"switch (",v,") {");

var seq__11947_11965 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),cljs.core.interleave.call(null,tests,thens)));
var chunk__11948_11966 = null;
var count__11949_11967 = (0);
var i__11950_11968 = (0);
while(true){
if((i__11950_11968 < count__11949_11967)){
var vec__11951_11969 = cljs.core._nth.call(null,chunk__11948_11966,i__11950_11968);
var ts_11970 = cljs.core.nth.call(null,vec__11951_11969,(0),null);
var then_11971 = cljs.core.nth.call(null,vec__11951_11969,(1),null);
var seq__11954_11972 = cljs.core.seq.call(null,ts_11970);
var chunk__11955_11973 = null;
var count__11956_11974 = (0);
var i__11957_11975 = (0);
while(true){
if((i__11957_11975 < count__11956_11974)){
var test_11976 = cljs.core._nth.call(null,chunk__11955_11973,i__11957_11975);
cljs.compiler.emitln.call(null,"case ",test_11976,":");


var G__11977 = seq__11954_11972;
var G__11978 = chunk__11955_11973;
var G__11979 = count__11956_11974;
var G__11980 = (i__11957_11975 + (1));
seq__11954_11972 = G__11977;
chunk__11955_11973 = G__11978;
count__11956_11974 = G__11979;
i__11957_11975 = G__11980;
continue;
} else {
var temp__5457__auto___11981 = cljs.core.seq.call(null,seq__11954_11972);
if(temp__5457__auto___11981){
var seq__11954_11982__$1 = temp__5457__auto___11981;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11954_11982__$1)){
var c__4351__auto___11983 = cljs.core.chunk_first.call(null,seq__11954_11982__$1);
var G__11984 = cljs.core.chunk_rest.call(null,seq__11954_11982__$1);
var G__11985 = c__4351__auto___11983;
var G__11986 = cljs.core.count.call(null,c__4351__auto___11983);
var G__11987 = (0);
seq__11954_11972 = G__11984;
chunk__11955_11973 = G__11985;
count__11956_11974 = G__11986;
i__11957_11975 = G__11987;
continue;
} else {
var test_11988 = cljs.core.first.call(null,seq__11954_11982__$1);
cljs.compiler.emitln.call(null,"case ",test_11988,":");


var G__11989 = cljs.core.next.call(null,seq__11954_11982__$1);
var G__11990 = null;
var G__11991 = (0);
var G__11992 = (0);
seq__11954_11972 = G__11989;
chunk__11955_11973 = G__11990;
count__11956_11974 = G__11991;
i__11957_11975 = G__11992;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,gs,"=",then_11971);
} else {
cljs.compiler.emitln.call(null,then_11971);
}

cljs.compiler.emitln.call(null,"break;");


var G__11993 = seq__11947_11965;
var G__11994 = chunk__11948_11966;
var G__11995 = count__11949_11967;
var G__11996 = (i__11950_11968 + (1));
seq__11947_11965 = G__11993;
chunk__11948_11966 = G__11994;
count__11949_11967 = G__11995;
i__11950_11968 = G__11996;
continue;
} else {
var temp__5457__auto___11997 = cljs.core.seq.call(null,seq__11947_11965);
if(temp__5457__auto___11997){
var seq__11947_11998__$1 = temp__5457__auto___11997;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11947_11998__$1)){
var c__4351__auto___11999 = cljs.core.chunk_first.call(null,seq__11947_11998__$1);
var G__12000 = cljs.core.chunk_rest.call(null,seq__11947_11998__$1);
var G__12001 = c__4351__auto___11999;
var G__12002 = cljs.core.count.call(null,c__4351__auto___11999);
var G__12003 = (0);
seq__11947_11965 = G__12000;
chunk__11948_11966 = G__12001;
count__11949_11967 = G__12002;
i__11950_11968 = G__12003;
continue;
} else {
var vec__11958_12004 = cljs.core.first.call(null,seq__11947_11998__$1);
var ts_12005 = cljs.core.nth.call(null,vec__11958_12004,(0),null);
var then_12006 = cljs.core.nth.call(null,vec__11958_12004,(1),null);
var seq__11961_12007 = cljs.core.seq.call(null,ts_12005);
var chunk__11962_12008 = null;
var count__11963_12009 = (0);
var i__11964_12010 = (0);
while(true){
if((i__11964_12010 < count__11963_12009)){
var test_12011 = cljs.core._nth.call(null,chunk__11962_12008,i__11964_12010);
cljs.compiler.emitln.call(null,"case ",test_12011,":");


var G__12012 = seq__11961_12007;
var G__12013 = chunk__11962_12008;
var G__12014 = count__11963_12009;
var G__12015 = (i__11964_12010 + (1));
seq__11961_12007 = G__12012;
chunk__11962_12008 = G__12013;
count__11963_12009 = G__12014;
i__11964_12010 = G__12015;
continue;
} else {
var temp__5457__auto___12016__$1 = cljs.core.seq.call(null,seq__11961_12007);
if(temp__5457__auto___12016__$1){
var seq__11961_12017__$1 = temp__5457__auto___12016__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11961_12017__$1)){
var c__4351__auto___12018 = cljs.core.chunk_first.call(null,seq__11961_12017__$1);
var G__12019 = cljs.core.chunk_rest.call(null,seq__11961_12017__$1);
var G__12020 = c__4351__auto___12018;
var G__12021 = cljs.core.count.call(null,c__4351__auto___12018);
var G__12022 = (0);
seq__11961_12007 = G__12019;
chunk__11962_12008 = G__12020;
count__11963_12009 = G__12021;
i__11964_12010 = G__12022;
continue;
} else {
var test_12023 = cljs.core.first.call(null,seq__11961_12017__$1);
cljs.compiler.emitln.call(null,"case ",test_12023,":");


var G__12024 = cljs.core.next.call(null,seq__11961_12017__$1);
var G__12025 = null;
var G__12026 = (0);
var G__12027 = (0);
seq__11961_12007 = G__12024;
chunk__11962_12008 = G__12025;
count__11963_12009 = G__12026;
i__11964_12010 = G__12027;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,gs,"=",then_12006);
} else {
cljs.compiler.emitln.call(null,then_12006);
}

cljs.compiler.emitln.call(null,"break;");


var G__12028 = cljs.core.next.call(null,seq__11947_11998__$1);
var G__12029 = null;
var G__12030 = (0);
var G__12031 = (0);
seq__11947_11965 = G__12028;
chunk__11948_11966 = G__12029;
count__11949_11967 = G__12030;
i__11950_11968 = G__12031;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(default$)){
cljs.compiler.emitln.call(null,"default:");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,gs,"=",default$);
} else {
cljs.compiler.emitln.call(null,default$);
}
} else {
}

cljs.compiler.emitln.call(null,"}");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.call(null,"return ",gs,";})()");
} else {
return null;
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"throw","throw",-1044625833),(function (p__12032){
var map__12033 = p__12032;
var map__12033__$1 = ((((!((map__12033 == null)))?(((((map__12033.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12033.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12033):map__12033);
var throw$ = cljs.core.get.call(null,map__12033__$1,new cljs.core.Keyword(null,"throw","throw",-1044625833));
var env = cljs.core.get.call(null,map__12033__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emits.call(null,"(function(){throw ",throw$,"})()");
} else {
return cljs.compiler.emitln.call(null,"throw ",throw$,";");
}
}));
cljs.compiler.base_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, ["boolean",null,"object",null,"*",null,"string",null,"Object",null,"Number",null,"null",null,"Date",null,"number",null,"String",null,"RegExp",null,"...*",null,"Array",null,"array",null,"Boolean",null], null), null);
cljs.compiler.mapped_types = new cljs.core.PersistentArrayMap(null, 1, ["nil","null"], null);
cljs.compiler.resolve_type = (function cljs$compiler$resolve_type(env,t){
if(cljs.core.truth_(cljs.core.get.call(null,cljs.compiler.base_types,t))){
return t;
} else {
if(cljs.core.truth_(cljs.core.get.call(null,cljs.compiler.mapped_types,t))){
return cljs.core.get.call(null,cljs.compiler.mapped_types,t);
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"!"))){
return ["!",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.resolve_type.call(null,env,cljs.core.subs.call(null,t,(1))))].join('');
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"{"))){
return t;
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"function"))){
var idx = t.lastIndexOf(":");
var vec__12036 = ((!(((-1) === idx)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.subs.call(null,t,(0),idx),cljs.core.subs.call(null,t,(idx + (1)),cljs.core.count.call(null,t))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [t,null], null));
var fstr = cljs.core.nth.call(null,vec__12036,(0),null);
var rstr = cljs.core.nth.call(null,vec__12036,(1),null);
var ret_t = (cljs.core.truth_(rstr)?cljs.compiler.resolve_type.call(null,env,rstr):null);
var axstr = cljs.core.subs.call(null,fstr,(9),(cljs.core.count.call(null,fstr) - (1)));
var args_ts = (cljs.core.truth_(clojure.string.blank_QMARK_(axstr))?null:cljs.core.map.call(null,cljs.core.comp.call(null,((function (idx,vec__12036,fstr,rstr,ret_t,axstr){
return (function (p1__12035_SHARP_){
return cljs.compiler.resolve_type.call(null,env,p1__12035_SHARP_);
});})(idx,vec__12036,fstr,rstr,ret_t,axstr))
,clojure.string.trim),clojure.string.split(axstr,/,/)));
var G__12039 = ["function(",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join(",",args_ts)),")"].join('');
if(cljs.core.truth_(ret_t)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__12039),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ret_t)].join('');
} else {
return G__12039;
}
} else {
if(cljs.core.truth_(goog.string.endsWith(t,"="))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.resolve_type.call(null,env,cljs.core.subs.call(null,t,(0),(cljs.core.count.call(null,t) - (1))))),"="].join('');
} else {
return cljs.compiler.munge.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.call(null,env,cljs.core.symbol.call(null,t))))].join(''));

}
}
}
}
}
}
});
cljs.compiler.resolve_types = (function cljs$compiler$resolve_types(env,ts){
var ts__$1 = cljs.core.subs.call(null,clojure.string.trim(ts),(1),(cljs.core.count.call(null,ts) - (1)));
var xs = clojure.string.split(ts__$1,/\|/);
return ["{",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join("|",cljs.core.map.call(null,((function (ts__$1,xs){
return (function (p1__12040_SHARP_){
return cljs.compiler.resolve_type.call(null,env,p1__12040_SHARP_);
});})(ts__$1,xs))
,xs))),"}"].join('');
});
cljs.compiler.munge_param_return = (function cljs$compiler$munge_param_return(env,line){
if(cljs.core.truth_(cljs.core.re_find.call(null,/@param/,line))){
var vec__12041 = cljs.core.map.call(null,clojure.string.trim,clojure.string.split(clojure.string.trim(line),/ /));
var seq__12042 = cljs.core.seq.call(null,vec__12041);
var first__12043 = cljs.core.first.call(null,seq__12042);
var seq__12042__$1 = cljs.core.next.call(null,seq__12042);
var p = first__12043;
var first__12043__$1 = cljs.core.first.call(null,seq__12042__$1);
var seq__12042__$2 = cljs.core.next.call(null,seq__12042__$1);
var ts = first__12043__$1;
var first__12043__$2 = cljs.core.first.call(null,seq__12042__$2);
var seq__12042__$3 = cljs.core.next.call(null,seq__12042__$2);
var n = first__12043__$2;
var xs = seq__12042__$3;
if(cljs.core.truth_((function (){var and__3938__auto__ = cljs.core._EQ_.call(null,"@param",p);
if(and__3938__auto__){
var and__3938__auto____$1 = ts;
if(cljs.core.truth_(and__3938__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__3938__auto____$1;
}
} else {
return and__3938__auto__;
}
})())){
return clojure.string.join(" ",cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types.call(null,env,ts),cljs.compiler.munge.call(null,n)], null),xs));
} else {
return line;
}
} else {
if(cljs.core.truth_(cljs.core.re_find.call(null,/@return/,line))){
var vec__12044 = cljs.core.map.call(null,clojure.string.trim,clojure.string.split(clojure.string.trim(line),/ /));
var seq__12045 = cljs.core.seq.call(null,vec__12044);
var first__12046 = cljs.core.first.call(null,seq__12045);
var seq__12045__$1 = cljs.core.next.call(null,seq__12045);
var p = first__12046;
var first__12046__$1 = cljs.core.first.call(null,seq__12045__$1);
var seq__12045__$2 = cljs.core.next.call(null,seq__12045__$1);
var ts = first__12046__$1;
var xs = seq__12045__$2;
if(cljs.core.truth_((function (){var and__3938__auto__ = cljs.core._EQ_.call(null,"@return",p);
if(and__3938__auto__){
var and__3938__auto____$1 = ts;
if(cljs.core.truth_(and__3938__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__3938__auto____$1;
}
} else {
return and__3938__auto__;
}
})())){
return clojure.string.join(" ",cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types.call(null,env,ts)], null),xs));
} else {
return line;
}
} else {
return line;

}
}
});
cljs.compiler.checking_types_QMARK_ = (function cljs$compiler$checking_types_QMARK_(){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"warning","warning",-1685650671),null,new cljs.core.Keyword(null,"error","error",-978969032),null], null), null).call(null,cljs.core.get_in.call(null,cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"closure-warnings","closure-warnings",1362834211),new cljs.core.Keyword(null,"check-types","check-types",-833794607)], null)));
});
/**
 * Emit a nicely formatted comment string.
 */
cljs.compiler.emit_comment = (function cljs$compiler$emit_comment(var_args){
var G__12049 = arguments.length;
switch (G__12049) {
case 2:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2 = (function (doc,jsdoc){
return cljs.compiler.emit_comment.call(null,null,doc,jsdoc);
});

cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3 = (function (env,doc,jsdoc){
var docs = (cljs.core.truth_(doc)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [doc], null):null);
var docs__$1 = (cljs.core.truth_(jsdoc)?cljs.core.concat.call(null,docs,jsdoc):docs);
var docs__$2 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,docs__$1);
var print_comment_lines = ((function (docs,docs__$1,docs__$2){
return (function cljs$compiler$print_comment_lines(e){
var vec__12057 = cljs.core.map.call(null,((function (docs,docs__$1,docs__$2){
return (function (p1__12047_SHARP_){
if(cljs.core.truth_(cljs.compiler.checking_types_QMARK_.call(null))){
return cljs.compiler.munge_param_return.call(null,env,p1__12047_SHARP_);
} else {
return p1__12047_SHARP_;
}
});})(docs,docs__$1,docs__$2))
,clojure.string.split_lines(e));
var seq__12058 = cljs.core.seq.call(null,vec__12057);
var first__12059 = cljs.core.first.call(null,seq__12058);
var seq__12058__$1 = cljs.core.next.call(null,seq__12058);
var x = first__12059;
var ys = seq__12058__$1;
cljs.compiler.emitln.call(null," * ",clojure.string.replace(x,"*/","* /"));

var seq__12060 = cljs.core.seq.call(null,ys);
var chunk__12061 = null;
var count__12062 = (0);
var i__12063 = (0);
while(true){
if((i__12063 < count__12062)){
var next_line = cljs.core._nth.call(null,chunk__12061,i__12063);
cljs.compiler.emitln.call(null," * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__12069 = seq__12060;
var G__12070 = chunk__12061;
var G__12071 = count__12062;
var G__12072 = (i__12063 + (1));
seq__12060 = G__12069;
chunk__12061 = G__12070;
count__12062 = G__12071;
i__12063 = G__12072;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__12060);
if(temp__5457__auto__){
var seq__12060__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12060__$1)){
var c__4351__auto__ = cljs.core.chunk_first.call(null,seq__12060__$1);
var G__12073 = cljs.core.chunk_rest.call(null,seq__12060__$1);
var G__12074 = c__4351__auto__;
var G__12075 = cljs.core.count.call(null,c__4351__auto__);
var G__12076 = (0);
seq__12060 = G__12073;
chunk__12061 = G__12074;
count__12062 = G__12075;
i__12063 = G__12076;
continue;
} else {
var next_line = cljs.core.first.call(null,seq__12060__$1);
cljs.compiler.emitln.call(null," * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__12077 = cljs.core.next.call(null,seq__12060__$1);
var G__12078 = null;
var G__12079 = (0);
var G__12080 = (0);
seq__12060 = G__12077;
chunk__12061 = G__12078;
count__12062 = G__12079;
i__12063 = G__12080;
continue;
}
} else {
return null;
}
}
break;
}
});})(docs,docs__$1,docs__$2))
;
if(cljs.core.seq.call(null,docs__$2)){
cljs.compiler.emitln.call(null,"/**");

var seq__12064_12081 = cljs.core.seq.call(null,docs__$2);
var chunk__12065_12082 = null;
var count__12066_12083 = (0);
var i__12067_12084 = (0);
while(true){
if((i__12067_12084 < count__12066_12083)){
var e_12085 = cljs.core._nth.call(null,chunk__12065_12082,i__12067_12084);
if(cljs.core.truth_(e_12085)){
print_comment_lines.call(null,e_12085);
} else {
}


var G__12086 = seq__12064_12081;
var G__12087 = chunk__12065_12082;
var G__12088 = count__12066_12083;
var G__12089 = (i__12067_12084 + (1));
seq__12064_12081 = G__12086;
chunk__12065_12082 = G__12087;
count__12066_12083 = G__12088;
i__12067_12084 = G__12089;
continue;
} else {
var temp__5457__auto___12090 = cljs.core.seq.call(null,seq__12064_12081);
if(temp__5457__auto___12090){
var seq__12064_12091__$1 = temp__5457__auto___12090;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12064_12091__$1)){
var c__4351__auto___12092 = cljs.core.chunk_first.call(null,seq__12064_12091__$1);
var G__12093 = cljs.core.chunk_rest.call(null,seq__12064_12091__$1);
var G__12094 = c__4351__auto___12092;
var G__12095 = cljs.core.count.call(null,c__4351__auto___12092);
var G__12096 = (0);
seq__12064_12081 = G__12093;
chunk__12065_12082 = G__12094;
count__12066_12083 = G__12095;
i__12067_12084 = G__12096;
continue;
} else {
var e_12097 = cljs.core.first.call(null,seq__12064_12091__$1);
if(cljs.core.truth_(e_12097)){
print_comment_lines.call(null,e_12097);
} else {
}


var G__12098 = cljs.core.next.call(null,seq__12064_12091__$1);
var G__12099 = null;
var G__12100 = (0);
var G__12101 = (0);
seq__12064_12081 = G__12098;
chunk__12065_12082 = G__12099;
count__12066_12083 = G__12100;
i__12067_12084 = G__12101;
continue;
}
} else {
}
}
break;
}

return cljs.compiler.emitln.call(null," */");
} else {
return null;
}
});

cljs.compiler.emit_comment.cljs$lang$maxFixedArity = 3;

cljs.compiler.valid_define_value_QMARK_ = (function cljs$compiler$valid_define_value_QMARK_(x){
return ((typeof x === 'string') || (x === true) || (x === false) || (typeof x === 'number'));
});
cljs.compiler.get_define = (function cljs$compiler$get_define(mname,jsdoc){
var opts = cljs.core.get.call(null,cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_),new cljs.core.Keyword(null,"options","options",99638489));
var and__3938__auto__ = cljs.core.some.call(null,((function (opts){
return (function (p1__12103_SHARP_){
return goog.string.startsWith(p1__12103_SHARP_,"@define");
});})(opts))
,jsdoc);
if(cljs.core.truth_(and__3938__auto__)){
var and__3938__auto____$1 = opts;
if(cljs.core.truth_(and__3938__auto____$1)){
var and__3938__auto____$2 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"none","none",1333468478));
if(and__3938__auto____$2){
var define = cljs.core.get_in.call(null,opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"closure-defines","closure-defines",-1213856476),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname)].join('')], null));
if(cljs.core.truth_(cljs.compiler.valid_define_value_QMARK_.call(null,define))){
return cljs.core.pr_str.call(null,define);
} else {
return null;
}
} else {
return and__3938__auto____$2;
}
} else {
return and__3938__auto____$1;
}
} else {
return and__3938__auto__;
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"def","def",-1043430536),(function (p__12104){
var map__12105 = p__12104;
var map__12105__$1 = ((((!((map__12105 == null)))?(((((map__12105.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12105.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12105):map__12105);
var name = cljs.core.get.call(null,map__12105__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var var$ = cljs.core.get.call(null,map__12105__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var init = cljs.core.get.call(null,map__12105__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
var env = cljs.core.get.call(null,map__12105__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var doc = cljs.core.get.call(null,map__12105__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var jsdoc = cljs.core.get.call(null,map__12105__$1,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516));
var export$ = cljs.core.get.call(null,map__12105__$1,new cljs.core.Keyword(null,"export","export",214356590));
var test = cljs.core.get.call(null,map__12105__$1,new cljs.core.Keyword(null,"test","test",577538877));
var var_ast = cljs.core.get.call(null,map__12105__$1,new cljs.core.Keyword(null,"var-ast","var-ast",1200379319));
if(cljs.core.truth_((function (){var or__3949__auto__ = init;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env);
}
})())){
var mname = cljs.compiler.munge.call(null,name);
cljs.compiler.emit_comment.call(null,env,doc,cljs.core.concat.call(null,jsdoc,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516).cljs$core$IFn$_invoke$arity$1(init)));

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"return (");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"(function (){");
} else {
}

cljs.compiler.emits.call(null,var$);

if(cljs.core.truth_(init)){
cljs.compiler.emits.call(null," = ",(function (){var temp__5455__auto__ = cljs.compiler.get_define.call(null,mname,jsdoc);
if(cljs.core.truth_(temp__5455__auto__)){
var define = temp__5455__auto__;
return define;
} else {
return init;
}
})());
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"; return (");

cljs.compiler.emits.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"the-var","the-var",1428415613),new cljs.core.Keyword(null,"env","env",-1815813235),cljs.core.assoc.call(null,env,new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Keyword(null,"expr","expr",745722291))], null),var_ast));

cljs.compiler.emitln.call(null,");})()");
} else {
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,")");
} else {
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emitln.call(null,";");
}

if(cljs.core.truth_(export$)){
cljs.compiler.emitln.call(null,"goog.exportSymbol('",cljs.compiler.munge.call(null,export$),"', ",mname,");");
} else {
}

if(cljs.core.truth_((function (){var and__3938__auto__ = cljs.analyzer._STAR_load_tests_STAR_;
if(and__3938__auto__){
return test;
} else {
return and__3938__auto__;
}
})())){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,";");
} else {
}

return cljs.compiler.emitln.call(null,var$,".cljs$lang$test = ",test,";");
} else {
return null;
}
} else {
return null;
}
}));
cljs.compiler.emit_apply_to = (function cljs$compiler$emit_apply_to(p__12107){
var map__12108 = p__12107;
var map__12108__$1 = ((((!((map__12108 == null)))?(((((map__12108.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12108.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12108):map__12108);
var name = cljs.core.get.call(null,map__12108__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.call(null,map__12108__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.call(null,map__12108__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var arglist = cljs.core.gensym.call(null,"arglist__");
var delegate_name = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,name)),"__delegate"].join('');
cljs.compiler.emitln.call(null,"(function (",arglist,"){");

var seq__12110_12128 = cljs.core.seq.call(null,cljs.core.map_indexed.call(null,cljs.core.vector,cljs.core.drop_last.call(null,(2),params)));
var chunk__12111_12129 = null;
var count__12112_12130 = (0);
var i__12113_12131 = (0);
while(true){
if((i__12113_12131 < count__12112_12130)){
var vec__12114_12132 = cljs.core._nth.call(null,chunk__12111_12129,i__12113_12131);
var i_12133 = cljs.core.nth.call(null,vec__12114_12132,(0),null);
var param_12134 = cljs.core.nth.call(null,vec__12114_12132,(1),null);
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,param_12134);

cljs.compiler.emits.call(null," = cljs.core.first(");

cljs.compiler.emitln.call(null,arglist,");");

cljs.compiler.emitln.call(null,arglist," = cljs.core.next(",arglist,");");


var G__12135 = seq__12110_12128;
var G__12136 = chunk__12111_12129;
var G__12137 = count__12112_12130;
var G__12138 = (i__12113_12131 + (1));
seq__12110_12128 = G__12135;
chunk__12111_12129 = G__12136;
count__12112_12130 = G__12137;
i__12113_12131 = G__12138;
continue;
} else {
var temp__5457__auto___12139 = cljs.core.seq.call(null,seq__12110_12128);
if(temp__5457__auto___12139){
var seq__12110_12140__$1 = temp__5457__auto___12139;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12110_12140__$1)){
var c__4351__auto___12141 = cljs.core.chunk_first.call(null,seq__12110_12140__$1);
var G__12142 = cljs.core.chunk_rest.call(null,seq__12110_12140__$1);
var G__12143 = c__4351__auto___12141;
var G__12144 = cljs.core.count.call(null,c__4351__auto___12141);
var G__12145 = (0);
seq__12110_12128 = G__12142;
chunk__12111_12129 = G__12143;
count__12112_12130 = G__12144;
i__12113_12131 = G__12145;
continue;
} else {
var vec__12117_12146 = cljs.core.first.call(null,seq__12110_12140__$1);
var i_12147 = cljs.core.nth.call(null,vec__12117_12146,(0),null);
var param_12148 = cljs.core.nth.call(null,vec__12117_12146,(1),null);
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,param_12148);

cljs.compiler.emits.call(null," = cljs.core.first(");

cljs.compiler.emitln.call(null,arglist,");");

cljs.compiler.emitln.call(null,arglist," = cljs.core.next(",arglist,");");


var G__12149 = cljs.core.next.call(null,seq__12110_12140__$1);
var G__12150 = null;
var G__12151 = (0);
var G__12152 = (0);
seq__12110_12128 = G__12149;
chunk__12111_12129 = G__12150;
count__12112_12130 = G__12151;
i__12113_12131 = G__12152;
continue;
}
} else {
}
}
break;
}

if(((1) < cljs.core.count.call(null,params))){
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,cljs.core.butlast.call(null,params)));

cljs.compiler.emitln.call(null," = cljs.core.first(",arglist,");");

cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,params));

cljs.compiler.emitln.call(null," = cljs.core.rest(",arglist,");");

cljs.compiler.emits.call(null,"return ",delegate_name,"(");

var seq__12120_12153 = cljs.core.seq.call(null,params);
var chunk__12121_12154 = null;
var count__12122_12155 = (0);
var i__12123_12156 = (0);
while(true){
if((i__12123_12156 < count__12122_12155)){
var param_12157 = cljs.core._nth.call(null,chunk__12121_12154,i__12123_12156);
cljs.compiler.emit.call(null,param_12157);

if(cljs.core._EQ_.call(null,param_12157,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__12158 = seq__12120_12153;
var G__12159 = chunk__12121_12154;
var G__12160 = count__12122_12155;
var G__12161 = (i__12123_12156 + (1));
seq__12120_12153 = G__12158;
chunk__12121_12154 = G__12159;
count__12122_12155 = G__12160;
i__12123_12156 = G__12161;
continue;
} else {
var temp__5457__auto___12162 = cljs.core.seq.call(null,seq__12120_12153);
if(temp__5457__auto___12162){
var seq__12120_12163__$1 = temp__5457__auto___12162;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12120_12163__$1)){
var c__4351__auto___12164 = cljs.core.chunk_first.call(null,seq__12120_12163__$1);
var G__12165 = cljs.core.chunk_rest.call(null,seq__12120_12163__$1);
var G__12166 = c__4351__auto___12164;
var G__12167 = cljs.core.count.call(null,c__4351__auto___12164);
var G__12168 = (0);
seq__12120_12153 = G__12165;
chunk__12121_12154 = G__12166;
count__12122_12155 = G__12167;
i__12123_12156 = G__12168;
continue;
} else {
var param_12169 = cljs.core.first.call(null,seq__12120_12163__$1);
cljs.compiler.emit.call(null,param_12169);

if(cljs.core._EQ_.call(null,param_12169,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__12170 = cljs.core.next.call(null,seq__12120_12163__$1);
var G__12171 = null;
var G__12172 = (0);
var G__12173 = (0);
seq__12120_12153 = G__12170;
chunk__12121_12154 = G__12171;
count__12122_12155 = G__12172;
i__12123_12156 = G__12173;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,");");
} else {
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,params));

cljs.compiler.emitln.call(null," = cljs.core.seq(",arglist,");");

cljs.compiler.emits.call(null,"return ",delegate_name,"(");

var seq__12124_12174 = cljs.core.seq.call(null,params);
var chunk__12125_12175 = null;
var count__12126_12176 = (0);
var i__12127_12177 = (0);
while(true){
if((i__12127_12177 < count__12126_12176)){
var param_12178 = cljs.core._nth.call(null,chunk__12125_12175,i__12127_12177);
cljs.compiler.emit.call(null,param_12178);

if(cljs.core._EQ_.call(null,param_12178,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__12179 = seq__12124_12174;
var G__12180 = chunk__12125_12175;
var G__12181 = count__12126_12176;
var G__12182 = (i__12127_12177 + (1));
seq__12124_12174 = G__12179;
chunk__12125_12175 = G__12180;
count__12126_12176 = G__12181;
i__12127_12177 = G__12182;
continue;
} else {
var temp__5457__auto___12183 = cljs.core.seq.call(null,seq__12124_12174);
if(temp__5457__auto___12183){
var seq__12124_12184__$1 = temp__5457__auto___12183;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12124_12184__$1)){
var c__4351__auto___12185 = cljs.core.chunk_first.call(null,seq__12124_12184__$1);
var G__12186 = cljs.core.chunk_rest.call(null,seq__12124_12184__$1);
var G__12187 = c__4351__auto___12185;
var G__12188 = cljs.core.count.call(null,c__4351__auto___12185);
var G__12189 = (0);
seq__12124_12174 = G__12186;
chunk__12125_12175 = G__12187;
count__12126_12176 = G__12188;
i__12127_12177 = G__12189;
continue;
} else {
var param_12190 = cljs.core.first.call(null,seq__12124_12184__$1);
cljs.compiler.emit.call(null,param_12190);

if(cljs.core._EQ_.call(null,param_12190,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__12191 = cljs.core.next.call(null,seq__12124_12184__$1);
var G__12192 = null;
var G__12193 = (0);
var G__12194 = (0);
seq__12124_12174 = G__12191;
chunk__12125_12175 = G__12192;
count__12126_12176 = G__12193;
i__12127_12177 = G__12194;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,");");
}

return cljs.compiler.emits.call(null,"})");
});
cljs.compiler.emit_fn_params = (function cljs$compiler$emit_fn_params(params){
var seq__12195 = cljs.core.seq.call(null,params);
var chunk__12196 = null;
var count__12197 = (0);
var i__12198 = (0);
while(true){
if((i__12198 < count__12197)){
var param = cljs.core._nth.call(null,chunk__12196,i__12198);
cljs.compiler.emit.call(null,param);

if(cljs.core._EQ_.call(null,param,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__12199 = seq__12195;
var G__12200 = chunk__12196;
var G__12201 = count__12197;
var G__12202 = (i__12198 + (1));
seq__12195 = G__12199;
chunk__12196 = G__12200;
count__12197 = G__12201;
i__12198 = G__12202;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__12195);
if(temp__5457__auto__){
var seq__12195__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12195__$1)){
var c__4351__auto__ = cljs.core.chunk_first.call(null,seq__12195__$1);
var G__12203 = cljs.core.chunk_rest.call(null,seq__12195__$1);
var G__12204 = c__4351__auto__;
var G__12205 = cljs.core.count.call(null,c__4351__auto__);
var G__12206 = (0);
seq__12195 = G__12203;
chunk__12196 = G__12204;
count__12197 = G__12205;
i__12198 = G__12206;
continue;
} else {
var param = cljs.core.first.call(null,seq__12195__$1);
cljs.compiler.emit.call(null,param);

if(cljs.core._EQ_.call(null,param,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__12207 = cljs.core.next.call(null,seq__12195__$1);
var G__12208 = null;
var G__12209 = (0);
var G__12210 = (0);
seq__12195 = G__12207;
chunk__12196 = G__12208;
count__12197 = G__12209;
i__12198 = G__12210;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_fn_method = (function cljs$compiler$emit_fn_method(p__12211){
var map__12212 = p__12211;
var map__12212__$1 = ((((!((map__12212 == null)))?(((((map__12212.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12212.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12212):map__12212);
var type = cljs.core.get.call(null,map__12212__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.call(null,map__12212__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var variadic = cljs.core.get.call(null,map__12212__$1,new cljs.core.Keyword(null,"variadic","variadic",882626057));
var params = cljs.core.get.call(null,map__12212__$1,new cljs.core.Keyword(null,"params","params",710516235));
var expr = cljs.core.get.call(null,map__12212__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var env = cljs.core.get.call(null,map__12212__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.call(null,map__12212__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var max_fixed_arity = cljs.core.get.call(null,map__12212__$1,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543));
var env__11727__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__11727__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"(function ",cljs.compiler.munge.call(null,name),"(");

cljs.compiler.emit_fn_params.call(null,params);

cljs.compiler.emitln.call(null,"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.call(null,"var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"while(true){");
} else {
}

cljs.compiler.emits.call(null,expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"break;");

cljs.compiler.emitln.call(null,"}");
} else {
}

cljs.compiler.emits.call(null,"})");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__11727__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
});
/**
 * Emit code that copies function arguments into an array starting at an index.
 *   Returns name of var holding the array.
 */
cljs.compiler.emit_arguments_to_array = (function cljs$compiler$emit_arguments_to_array(startslice){
if((((startslice >= (0))) && (cljs.core.integer_QMARK_.call(null,startslice)))){
} else {
throw (new Error("Assert failed: (and (>= startslice 0) (integer? startslice))"));
}

var mname = cljs.compiler.munge.call(null,cljs.core.gensym.call(null));
var i = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__i"].join('');
var a = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__a"].join('');
cljs.compiler.emitln.call(null,"var ",i," = 0, ",a," = new Array(arguments.length -  ",startslice,");");

cljs.compiler.emitln.call(null,"while (",i," < ",a,".length) {",a,"[",i,"] = arguments[",i," + ",startslice,"]; ++",i,";}");

return a;
});
cljs.compiler.emit_variadic_fn_method = (function cljs$compiler$emit_variadic_fn_method(p__12214){
var map__12215 = p__12214;
var map__12215__$1 = ((((!((map__12215 == null)))?(((((map__12215.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12215.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12215):map__12215);
var f = map__12215__$1;
var type = cljs.core.get.call(null,map__12215__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.call(null,map__12215__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var variadic = cljs.core.get.call(null,map__12215__$1,new cljs.core.Keyword(null,"variadic","variadic",882626057));
var params = cljs.core.get.call(null,map__12215__$1,new cljs.core.Keyword(null,"params","params",710516235));
var expr = cljs.core.get.call(null,map__12215__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var env = cljs.core.get.call(null,map__12215__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.call(null,map__12215__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var max_fixed_arity = cljs.core.get.call(null,map__12215__$1,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543));
var env__11727__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__11727__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

var name_12225__$1 = (function (){var or__3949__auto__ = name;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return cljs.core.gensym.call(null);
}
})();
var mname_12226 = cljs.compiler.munge.call(null,name_12225__$1);
var delegate_name_12227 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_12226),"__delegate"].join('');
cljs.compiler.emitln.call(null,"(function() { ");

cljs.compiler.emits.call(null,"var ",delegate_name_12227," = function (");

var seq__12217_12228 = cljs.core.seq.call(null,params);
var chunk__12218_12229 = null;
var count__12219_12230 = (0);
var i__12220_12231 = (0);
while(true){
if((i__12220_12231 < count__12219_12230)){
var param_12232 = cljs.core._nth.call(null,chunk__12218_12229,i__12220_12231);
cljs.compiler.emit.call(null,param_12232);

if(cljs.core._EQ_.call(null,param_12232,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__12233 = seq__12217_12228;
var G__12234 = chunk__12218_12229;
var G__12235 = count__12219_12230;
var G__12236 = (i__12220_12231 + (1));
seq__12217_12228 = G__12233;
chunk__12218_12229 = G__12234;
count__12219_12230 = G__12235;
i__12220_12231 = G__12236;
continue;
} else {
var temp__5457__auto___12237 = cljs.core.seq.call(null,seq__12217_12228);
if(temp__5457__auto___12237){
var seq__12217_12238__$1 = temp__5457__auto___12237;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12217_12238__$1)){
var c__4351__auto___12239 = cljs.core.chunk_first.call(null,seq__12217_12238__$1);
var G__12240 = cljs.core.chunk_rest.call(null,seq__12217_12238__$1);
var G__12241 = c__4351__auto___12239;
var G__12242 = cljs.core.count.call(null,c__4351__auto___12239);
var G__12243 = (0);
seq__12217_12228 = G__12240;
chunk__12218_12229 = G__12241;
count__12219_12230 = G__12242;
i__12220_12231 = G__12243;
continue;
} else {
var param_12244 = cljs.core.first.call(null,seq__12217_12238__$1);
cljs.compiler.emit.call(null,param_12244);

if(cljs.core._EQ_.call(null,param_12244,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__12245 = cljs.core.next.call(null,seq__12217_12238__$1);
var G__12246 = null;
var G__12247 = (0);
var G__12248 = (0);
seq__12217_12228 = G__12245;
chunk__12218_12229 = G__12246;
count__12219_12230 = G__12247;
i__12220_12231 = G__12248;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.call(null,"var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"while(true){");
} else {
}

cljs.compiler.emits.call(null,expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"break;");

cljs.compiler.emitln.call(null,"}");
} else {
}

cljs.compiler.emitln.call(null,"};");

cljs.compiler.emitln.call(null,"var ",mname_12226," = function (",cljs.compiler.comma_sep.call(null,(cljs.core.truth_(variadic)?cljs.core.concat.call(null,cljs.core.butlast.call(null,params),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):params)),"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.call(null,"var self__ = this;");
} else {
}

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,params));

cljs.compiler.emitln.call(null," = null;");

cljs.compiler.emitln.call(null,"if (arguments.length > ",(cljs.core.count.call(null,params) - (1)),") {");

var a_12249 = cljs.compiler.emit_arguments_to_array.call(null,(cljs.core.count.call(null,params) - (1)));
cljs.compiler.emitln.call(null,"  ",cljs.core.last.call(null,params)," = new cljs.core.IndexedSeq(",a_12249,",0,null);");

cljs.compiler.emitln.call(null,"} ");
} else {
}

cljs.compiler.emits.call(null,"return ",delegate_name_12227,".call(this,");

var seq__12221_12250 = cljs.core.seq.call(null,params);
var chunk__12222_12251 = null;
var count__12223_12252 = (0);
var i__12224_12253 = (0);
while(true){
if((i__12224_12253 < count__12223_12252)){
var param_12254 = cljs.core._nth.call(null,chunk__12222_12251,i__12224_12253);
cljs.compiler.emit.call(null,param_12254);

if(cljs.core._EQ_.call(null,param_12254,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__12255 = seq__12221_12250;
var G__12256 = chunk__12222_12251;
var G__12257 = count__12223_12252;
var G__12258 = (i__12224_12253 + (1));
seq__12221_12250 = G__12255;
chunk__12222_12251 = G__12256;
count__12223_12252 = G__12257;
i__12224_12253 = G__12258;
continue;
} else {
var temp__5457__auto___12259 = cljs.core.seq.call(null,seq__12221_12250);
if(temp__5457__auto___12259){
var seq__12221_12260__$1 = temp__5457__auto___12259;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12221_12260__$1)){
var c__4351__auto___12261 = cljs.core.chunk_first.call(null,seq__12221_12260__$1);
var G__12262 = cljs.core.chunk_rest.call(null,seq__12221_12260__$1);
var G__12263 = c__4351__auto___12261;
var G__12264 = cljs.core.count.call(null,c__4351__auto___12261);
var G__12265 = (0);
seq__12221_12250 = G__12262;
chunk__12222_12251 = G__12263;
count__12223_12252 = G__12264;
i__12224_12253 = G__12265;
continue;
} else {
var param_12266 = cljs.core.first.call(null,seq__12221_12260__$1);
cljs.compiler.emit.call(null,param_12266);

if(cljs.core._EQ_.call(null,param_12266,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__12267 = cljs.core.next.call(null,seq__12221_12260__$1);
var G__12268 = null;
var G__12269 = (0);
var G__12270 = (0);
seq__12221_12250 = G__12267;
chunk__12222_12251 = G__12268;
count__12223_12252 = G__12269;
i__12224_12253 = G__12270;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.call(null,");");

cljs.compiler.emitln.call(null,"};");

cljs.compiler.emitln.call(null,mname_12226,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emits.call(null,mname_12226,".cljs$lang$applyTo = ");

cljs.compiler.emit_apply_to.call(null,cljs.core.assoc.call(null,f,new cljs.core.Keyword(null,"name","name",1843675177),name_12225__$1));

cljs.compiler.emitln.call(null,";");

cljs.compiler.emitln.call(null,mname_12226,".cljs$core$IFn$_invoke$arity$variadic = ",delegate_name_12227,";");

cljs.compiler.emitln.call(null,"return ",mname_12226,";");

cljs.compiler.emitln.call(null,"})()");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__11727__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"fn","fn",-1175266204),(function (p__12274){
var map__12275 = p__12274;
var map__12275__$1 = ((((!((map__12275 == null)))?(((((map__12275.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12275.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12275):map__12275);
var name = cljs.core.get.call(null,map__12275__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.call(null,map__12275__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var methods$ = cljs.core.get.call(null,map__12275__$1,new cljs.core.Keyword(null,"methods","methods",453930866));
var max_fixed_arity = cljs.core.get.call(null,map__12275__$1,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543));
var variadic = cljs.core.get.call(null,map__12275__$1,new cljs.core.Keyword(null,"variadic","variadic",882626057));
var recur_frames = cljs.core.get.call(null,map__12275__$1,new cljs.core.Keyword(null,"recur-frames","recur-frames",-307205196));
var loop_lets = cljs.core.get.call(null,map__12275__$1,new cljs.core.Keyword(null,"loop-lets","loop-lets",2036794185));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var loop_locals = cljs.core.seq.call(null,cljs.core.map.call(null,cljs.compiler.munge,cljs.core.concat.call(null,cljs.core.mapcat.call(null,new cljs.core.Keyword(null,"params","params",710516235),cljs.core.filter.call(null,((function (map__12275,map__12275__$1,name,env,methods$,max_fixed_arity,variadic,recur_frames,loop_lets){
return (function (p1__12271_SHARP_){
var and__3938__auto__ = p1__12271_SHARP_;
if(cljs.core.truth_(and__3938__auto__)){
return cljs.core.deref.call(null,new cljs.core.Keyword(null,"flag","flag",1088647881).cljs$core$IFn$_invoke$arity$1(p1__12271_SHARP_));
} else {
return and__3938__auto__;
}
});})(map__12275,map__12275__$1,name,env,methods$,max_fixed_arity,variadic,recur_frames,loop_lets))
,recur_frames)),cljs.core.mapcat.call(null,new cljs.core.Keyword(null,"params","params",710516235),loop_lets))));
if(loop_locals){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emitln.call(null,"((function (",cljs.compiler.comma_sep.call(null,cljs.core.map.call(null,cljs.compiler.munge,loop_locals)),"){");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emits.call(null,"return ");
}
} else {
}

if(cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,methods$))){
if(cljs.core.truth_(variadic)){
cljs.compiler.emit_variadic_fn_method.call(null,cljs.core.assoc.call(null,cljs.core.first.call(null,methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
} else {
cljs.compiler.emit_fn_method.call(null,cljs.core.assoc.call(null,cljs.core.first.call(null,methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
}
} else {
var name_12310__$1 = (function (){var or__3949__auto__ = name;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return cljs.core.gensym.call(null);
}
})();
var mname_12311 = cljs.compiler.munge.call(null,name_12310__$1);
var maxparams_12312 = cljs.core.apply.call(null,cljs.core.max_key,cljs.core.count,cljs.core.map.call(null,new cljs.core.Keyword(null,"params","params",710516235),methods$));
var mmap_12313 = cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,((function (name_12310__$1,mname_12311,maxparams_12312,loop_locals,map__12275,map__12275__$1,name,env,methods$,max_fixed_arity,variadic,recur_frames,loop_lets){
return (function (method){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.compiler.munge.call(null,cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_12311),"__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(method)))].join(''))),method], null);
});})(name_12310__$1,mname_12311,maxparams_12312,loop_locals,map__12275,map__12275__$1,name,env,methods$,max_fixed_arity,variadic,recur_frames,loop_lets))
,methods$));
var ms_12314 = cljs.core.sort_by.call(null,((function (name_12310__$1,mname_12311,maxparams_12312,mmap_12313,loop_locals,map__12275,map__12275__$1,name,env,methods$,max_fixed_arity,variadic,recur_frames,loop_lets){
return (function (p1__12272_SHARP_){
return cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,p1__12272_SHARP_)));
});})(name_12310__$1,mname_12311,maxparams_12312,mmap_12313,loop_locals,map__12275,map__12275__$1,name,env,methods$,max_fixed_arity,variadic,recur_frames,loop_lets))
,cljs.core.seq.call(null,mmap_12313));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emitln.call(null,"(function() {");

cljs.compiler.emitln.call(null,"var ",mname_12311," = null;");

var seq__12277_12315 = cljs.core.seq.call(null,ms_12314);
var chunk__12278_12316 = null;
var count__12279_12317 = (0);
var i__12280_12318 = (0);
while(true){
if((i__12280_12318 < count__12279_12317)){
var vec__12281_12319 = cljs.core._nth.call(null,chunk__12278_12316,i__12280_12318);
var n_12320 = cljs.core.nth.call(null,vec__12281_12319,(0),null);
var meth_12321 = cljs.core.nth.call(null,vec__12281_12319,(1),null);
cljs.compiler.emits.call(null,"var ",n_12320," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic","variadic",882626057).cljs$core$IFn$_invoke$arity$1(meth_12321))){
cljs.compiler.emit_variadic_fn_method.call(null,meth_12321);
} else {
cljs.compiler.emit_fn_method.call(null,meth_12321);
}

cljs.compiler.emitln.call(null,";");


var G__12322 = seq__12277_12315;
var G__12323 = chunk__12278_12316;
var G__12324 = count__12279_12317;
var G__12325 = (i__12280_12318 + (1));
seq__12277_12315 = G__12322;
chunk__12278_12316 = G__12323;
count__12279_12317 = G__12324;
i__12280_12318 = G__12325;
continue;
} else {
var temp__5457__auto___12326 = cljs.core.seq.call(null,seq__12277_12315);
if(temp__5457__auto___12326){
var seq__12277_12327__$1 = temp__5457__auto___12326;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12277_12327__$1)){
var c__4351__auto___12328 = cljs.core.chunk_first.call(null,seq__12277_12327__$1);
var G__12329 = cljs.core.chunk_rest.call(null,seq__12277_12327__$1);
var G__12330 = c__4351__auto___12328;
var G__12331 = cljs.core.count.call(null,c__4351__auto___12328);
var G__12332 = (0);
seq__12277_12315 = G__12329;
chunk__12278_12316 = G__12330;
count__12279_12317 = G__12331;
i__12280_12318 = G__12332;
continue;
} else {
var vec__12284_12333 = cljs.core.first.call(null,seq__12277_12327__$1);
var n_12334 = cljs.core.nth.call(null,vec__12284_12333,(0),null);
var meth_12335 = cljs.core.nth.call(null,vec__12284_12333,(1),null);
cljs.compiler.emits.call(null,"var ",n_12334," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic","variadic",882626057).cljs$core$IFn$_invoke$arity$1(meth_12335))){
cljs.compiler.emit_variadic_fn_method.call(null,meth_12335);
} else {
cljs.compiler.emit_fn_method.call(null,meth_12335);
}

cljs.compiler.emitln.call(null,";");


var G__12336 = cljs.core.next.call(null,seq__12277_12327__$1);
var G__12337 = null;
var G__12338 = (0);
var G__12339 = (0);
seq__12277_12315 = G__12336;
chunk__12278_12316 = G__12337;
count__12279_12317 = G__12338;
i__12280_12318 = G__12339;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,mname_12311," = function(",cljs.compiler.comma_sep.call(null,(cljs.core.truth_(variadic)?cljs.core.concat.call(null,cljs.core.butlast.call(null,maxparams_12312),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):maxparams_12312)),"){");

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,maxparams_12312));

cljs.compiler.emitln.call(null," = var_args;");
} else {
}

cljs.compiler.emitln.call(null,"switch(arguments.length){");

var seq__12287_12340 = cljs.core.seq.call(null,ms_12314);
var chunk__12288_12341 = null;
var count__12289_12342 = (0);
var i__12290_12343 = (0);
while(true){
if((i__12290_12343 < count__12289_12342)){
var vec__12291_12344 = cljs.core._nth.call(null,chunk__12288_12341,i__12290_12343);
var n_12345 = cljs.core.nth.call(null,vec__12291_12344,(0),null);
var meth_12346 = cljs.core.nth.call(null,vec__12291_12344,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic","variadic",882626057).cljs$core$IFn$_invoke$arity$1(meth_12346))){
cljs.compiler.emitln.call(null,"default:");

var restarg_12347 = cljs.compiler.munge.call(null,cljs.core.gensym.call(null));
cljs.compiler.emitln.call(null,"var ",restarg_12347," = null;");

cljs.compiler.emitln.call(null,"if (arguments.length > ",max_fixed_arity,") {");

var a_12348 = cljs.compiler.emit_arguments_to_array.call(null,max_fixed_arity);
cljs.compiler.emitln.call(null,restarg_12347," = new cljs.core.IndexedSeq(",a_12348,",0,null);");

cljs.compiler.emitln.call(null,"}");

cljs.compiler.emitln.call(null,"return ",n_12345,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep.call(null,cljs.core.butlast.call(null,maxparams_12312)),(((cljs.core.count.call(null,maxparams_12312) > (1)))?", ":null),restarg_12347,");");
} else {
var pcnt_12349 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_12346));
cljs.compiler.emitln.call(null,"case ",pcnt_12349,":");

cljs.compiler.emitln.call(null,"return ",n_12345,".call(this",(((pcnt_12349 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep.call(null,cljs.core.take.call(null,pcnt_12349,maxparams_12312)),null,(1),null)),(2),null))),");");
}


var G__12350 = seq__12287_12340;
var G__12351 = chunk__12288_12341;
var G__12352 = count__12289_12342;
var G__12353 = (i__12290_12343 + (1));
seq__12287_12340 = G__12350;
chunk__12288_12341 = G__12351;
count__12289_12342 = G__12352;
i__12290_12343 = G__12353;
continue;
} else {
var temp__5457__auto___12354 = cljs.core.seq.call(null,seq__12287_12340);
if(temp__5457__auto___12354){
var seq__12287_12355__$1 = temp__5457__auto___12354;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12287_12355__$1)){
var c__4351__auto___12356 = cljs.core.chunk_first.call(null,seq__12287_12355__$1);
var G__12357 = cljs.core.chunk_rest.call(null,seq__12287_12355__$1);
var G__12358 = c__4351__auto___12356;
var G__12359 = cljs.core.count.call(null,c__4351__auto___12356);
var G__12360 = (0);
seq__12287_12340 = G__12357;
chunk__12288_12341 = G__12358;
count__12289_12342 = G__12359;
i__12290_12343 = G__12360;
continue;
} else {
var vec__12294_12361 = cljs.core.first.call(null,seq__12287_12355__$1);
var n_12362 = cljs.core.nth.call(null,vec__12294_12361,(0),null);
var meth_12363 = cljs.core.nth.call(null,vec__12294_12361,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic","variadic",882626057).cljs$core$IFn$_invoke$arity$1(meth_12363))){
cljs.compiler.emitln.call(null,"default:");

var restarg_12364 = cljs.compiler.munge.call(null,cljs.core.gensym.call(null));
cljs.compiler.emitln.call(null,"var ",restarg_12364," = null;");

cljs.compiler.emitln.call(null,"if (arguments.length > ",max_fixed_arity,") {");

var a_12365 = cljs.compiler.emit_arguments_to_array.call(null,max_fixed_arity);
cljs.compiler.emitln.call(null,restarg_12364," = new cljs.core.IndexedSeq(",a_12365,",0,null);");

cljs.compiler.emitln.call(null,"}");

cljs.compiler.emitln.call(null,"return ",n_12362,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep.call(null,cljs.core.butlast.call(null,maxparams_12312)),(((cljs.core.count.call(null,maxparams_12312) > (1)))?", ":null),restarg_12364,");");
} else {
var pcnt_12366 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_12363));
cljs.compiler.emitln.call(null,"case ",pcnt_12366,":");

cljs.compiler.emitln.call(null,"return ",n_12362,".call(this",(((pcnt_12366 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep.call(null,cljs.core.take.call(null,pcnt_12366,maxparams_12312)),null,(1),null)),(2),null))),");");
}


var G__12367 = cljs.core.next.call(null,seq__12287_12355__$1);
var G__12368 = null;
var G__12369 = (0);
var G__12370 = (0);
seq__12287_12340 = G__12367;
chunk__12288_12341 = G__12368;
count__12289_12342 = G__12369;
i__12290_12343 = G__12370;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"}");

var arg_count_js_12371 = ((cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"self__","self__",-153190816,null),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,cljs.core.first.call(null,ms_12314)))))))?"(arguments.length - 1)":"arguments.length");
cljs.compiler.emitln.call(null,"throw(new Error('Invalid arity: ' + ",arg_count_js_12371,"));");

cljs.compiler.emitln.call(null,"};");

if(cljs.core.truth_(variadic)){
cljs.compiler.emitln.call(null,mname_12311,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emitln.call(null,mname_12311,".cljs$lang$applyTo = ",cljs.core.some.call(null,((function (name_12310__$1,mname_12311,maxparams_12312,mmap_12313,ms_12314,loop_locals,map__12275,map__12275__$1,name,env,methods$,max_fixed_arity,variadic,recur_frames,loop_lets){
return (function (p1__12273_SHARP_){
var vec__12297 = p1__12273_SHARP_;
var n = cljs.core.nth.call(null,vec__12297,(0),null);
var m = cljs.core.nth.call(null,vec__12297,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic","variadic",882626057).cljs$core$IFn$_invoke$arity$1(m))){
return n;
} else {
return null;
}
});})(name_12310__$1,mname_12311,maxparams_12312,mmap_12313,ms_12314,loop_locals,map__12275,map__12275__$1,name,env,methods$,max_fixed_arity,variadic,recur_frames,loop_lets))
,ms_12314),".cljs$lang$applyTo;");
} else {
}

var seq__12300_12372 = cljs.core.seq.call(null,ms_12314);
var chunk__12301_12373 = null;
var count__12302_12374 = (0);
var i__12303_12375 = (0);
while(true){
if((i__12303_12375 < count__12302_12374)){
var vec__12304_12376 = cljs.core._nth.call(null,chunk__12301_12373,i__12303_12375);
var n_12377 = cljs.core.nth.call(null,vec__12304_12376,(0),null);
var meth_12378 = cljs.core.nth.call(null,vec__12304_12376,(1),null);
var c_12379 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_12378));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic","variadic",882626057).cljs$core$IFn$_invoke$arity$1(meth_12378))){
cljs.compiler.emitln.call(null,mname_12311,".cljs$core$IFn$_invoke$arity$variadic = ",n_12377,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.call(null,mname_12311,".cljs$core$IFn$_invoke$arity$",c_12379," = ",n_12377,";");
}


var G__12380 = seq__12300_12372;
var G__12381 = chunk__12301_12373;
var G__12382 = count__12302_12374;
var G__12383 = (i__12303_12375 + (1));
seq__12300_12372 = G__12380;
chunk__12301_12373 = G__12381;
count__12302_12374 = G__12382;
i__12303_12375 = G__12383;
continue;
} else {
var temp__5457__auto___12384 = cljs.core.seq.call(null,seq__12300_12372);
if(temp__5457__auto___12384){
var seq__12300_12385__$1 = temp__5457__auto___12384;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12300_12385__$1)){
var c__4351__auto___12386 = cljs.core.chunk_first.call(null,seq__12300_12385__$1);
var G__12387 = cljs.core.chunk_rest.call(null,seq__12300_12385__$1);
var G__12388 = c__4351__auto___12386;
var G__12389 = cljs.core.count.call(null,c__4351__auto___12386);
var G__12390 = (0);
seq__12300_12372 = G__12387;
chunk__12301_12373 = G__12388;
count__12302_12374 = G__12389;
i__12303_12375 = G__12390;
continue;
} else {
var vec__12307_12391 = cljs.core.first.call(null,seq__12300_12385__$1);
var n_12392 = cljs.core.nth.call(null,vec__12307_12391,(0),null);
var meth_12393 = cljs.core.nth.call(null,vec__12307_12391,(1),null);
var c_12394 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_12393));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic","variadic",882626057).cljs$core$IFn$_invoke$arity$1(meth_12393))){
cljs.compiler.emitln.call(null,mname_12311,".cljs$core$IFn$_invoke$arity$variadic = ",n_12392,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.call(null,mname_12311,".cljs$core$IFn$_invoke$arity$",c_12394," = ",n_12392,";");
}


var G__12395 = cljs.core.next.call(null,seq__12300_12385__$1);
var G__12396 = null;
var G__12397 = (0);
var G__12398 = (0);
seq__12300_12372 = G__12395;
chunk__12301_12373 = G__12396;
count__12302_12374 = G__12397;
i__12303_12375 = G__12398;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"return ",mname_12311,";");

cljs.compiler.emitln.call(null,"})()");
}

if(loop_locals){
return cljs.compiler.emitln.call(null,";})(",cljs.compiler.comma_sep.call(null,loop_locals),"))");
} else {
return null;
}
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"do","do",46310725),(function (p__12399){
var map__12400 = p__12399;
var map__12400__$1 = ((((!((map__12400 == null)))?(((((map__12400.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12400.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12400):map__12400);
var statements = cljs.core.get.call(null,map__12400__$1,new cljs.core.Keyword(null,"statements","statements",600349855));
var ret = cljs.core.get.call(null,map__12400__$1,new cljs.core.Keyword(null,"ret","ret",-468222814));
var env = cljs.core.get.call(null,map__12400__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var and__3938__auto__ = statements;
if(cljs.core.truth_(and__3938__auto__)){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context);
} else {
return and__3938__auto__;
}
})())){
cljs.compiler.emitln.call(null,"(function (){");
} else {
}

var seq__12402_12406 = cljs.core.seq.call(null,statements);
var chunk__12403_12407 = null;
var count__12404_12408 = (0);
var i__12405_12409 = (0);
while(true){
if((i__12405_12409 < count__12404_12408)){
var s_12410 = cljs.core._nth.call(null,chunk__12403_12407,i__12405_12409);
cljs.compiler.emitln.call(null,s_12410);


var G__12411 = seq__12402_12406;
var G__12412 = chunk__12403_12407;
var G__12413 = count__12404_12408;
var G__12414 = (i__12405_12409 + (1));
seq__12402_12406 = G__12411;
chunk__12403_12407 = G__12412;
count__12404_12408 = G__12413;
i__12405_12409 = G__12414;
continue;
} else {
var temp__5457__auto___12415 = cljs.core.seq.call(null,seq__12402_12406);
if(temp__5457__auto___12415){
var seq__12402_12416__$1 = temp__5457__auto___12415;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12402_12416__$1)){
var c__4351__auto___12417 = cljs.core.chunk_first.call(null,seq__12402_12416__$1);
var G__12418 = cljs.core.chunk_rest.call(null,seq__12402_12416__$1);
var G__12419 = c__4351__auto___12417;
var G__12420 = cljs.core.count.call(null,c__4351__auto___12417);
var G__12421 = (0);
seq__12402_12406 = G__12418;
chunk__12403_12407 = G__12419;
count__12404_12408 = G__12420;
i__12405_12409 = G__12421;
continue;
} else {
var s_12422 = cljs.core.first.call(null,seq__12402_12416__$1);
cljs.compiler.emitln.call(null,s_12422);


var G__12423 = cljs.core.next.call(null,seq__12402_12416__$1);
var G__12424 = null;
var G__12425 = (0);
var G__12426 = (0);
seq__12402_12406 = G__12423;
chunk__12403_12407 = G__12424;
count__12404_12408 = G__12425;
i__12405_12409 = G__12426;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emit.call(null,ret);

if(cljs.core.truth_((function (){var and__3938__auto__ = statements;
if(cljs.core.truth_(and__3938__auto__)){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context);
} else {
return and__3938__auto__;
}
})())){
return cljs.compiler.emitln.call(null,"})()");
} else {
return null;
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"try","try",1380742522),(function (p__12427){
var map__12428 = p__12427;
var map__12428__$1 = ((((!((map__12428 == null)))?(((((map__12428.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12428.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12428):map__12428);
var env = cljs.core.get.call(null,map__12428__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var try$ = cljs.core.get.call(null,map__12428__$1,new cljs.core.Keyword(null,"try","try",1380742522));
var catch$ = cljs.core.get.call(null,map__12428__$1,new cljs.core.Keyword(null,"catch","catch",1038065524));
var name = cljs.core.get.call(null,map__12428__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var finally$ = cljs.core.get.call(null,map__12428__$1,new cljs.core.Keyword(null,"finally","finally",1589088705));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var or__3949__auto__ = name;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return finally$;
}
})())){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.call(null,"(function (){");
} else {
}

cljs.compiler.emits.call(null,"try{",try$,"}");

if(cljs.core.truth_(name)){
cljs.compiler.emits.call(null,"catch (",cljs.compiler.munge.call(null,name),"){",catch$,"}");
} else {
}

if(cljs.core.truth_(finally$)){
if(cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"const","const",1709929842),new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(finally$))){
} else {
throw (new Error(["Assert failed: ","finally block cannot contain constant","\n","(not= :const (:op finally))"].join('')));
}

cljs.compiler.emits.call(null,"finally {",finally$,"}");
} else {
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"})()");
} else {
return null;
}
} else {
return cljs.compiler.emits.call(null,try$);
}
}));
cljs.compiler.emit_let = (function cljs$compiler$emit_let(p__12430,is_loop){
var map__12431 = p__12430;
var map__12431__$1 = ((((!((map__12431 == null)))?(((((map__12431.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12431.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12431):map__12431);
var bindings = cljs.core.get.call(null,map__12431__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var expr = cljs.core.get.call(null,map__12431__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var env = cljs.core.get.call(null,map__12431__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.call(null,"(function (){");
} else {
}

var _STAR_lexical_renames_STAR_12433_12442 = cljs.compiler._STAR_lexical_renames_STAR_;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.into.call(null,cljs.compiler._STAR_lexical_renames_STAR_,((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),context))?cljs.core.map.call(null,((function (_STAR_lexical_renames_STAR_12433_12442,context,map__12431,map__12431__$1,bindings,expr,env){
return (function (binding){
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(binding);
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.compiler.hash_scope.call(null,binding),cljs.core.gensym.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"-"].join(''))],null));
});})(_STAR_lexical_renames_STAR_12433_12442,context,map__12431,map__12431__$1,bindings,expr,env))
,bindings):null));

try{var seq__12434_12443 = cljs.core.seq.call(null,bindings);
var chunk__12435_12444 = null;
var count__12436_12445 = (0);
var i__12437_12446 = (0);
while(true){
if((i__12437_12446 < count__12436_12445)){
var map__12438_12447 = cljs.core._nth.call(null,chunk__12435_12444,i__12437_12446);
var map__12438_12448__$1 = ((((!((map__12438_12447 == null)))?(((((map__12438_12447.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12438_12447.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12438_12447):map__12438_12447);
var binding_12449 = map__12438_12448__$1;
var init_12450 = cljs.core.get.call(null,map__12438_12448__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,binding_12449);

cljs.compiler.emitln.call(null," = ",init_12450,";");


var G__12451 = seq__12434_12443;
var G__12452 = chunk__12435_12444;
var G__12453 = count__12436_12445;
var G__12454 = (i__12437_12446 + (1));
seq__12434_12443 = G__12451;
chunk__12435_12444 = G__12452;
count__12436_12445 = G__12453;
i__12437_12446 = G__12454;
continue;
} else {
var temp__5457__auto___12455 = cljs.core.seq.call(null,seq__12434_12443);
if(temp__5457__auto___12455){
var seq__12434_12456__$1 = temp__5457__auto___12455;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12434_12456__$1)){
var c__4351__auto___12457 = cljs.core.chunk_first.call(null,seq__12434_12456__$1);
var G__12458 = cljs.core.chunk_rest.call(null,seq__12434_12456__$1);
var G__12459 = c__4351__auto___12457;
var G__12460 = cljs.core.count.call(null,c__4351__auto___12457);
var G__12461 = (0);
seq__12434_12443 = G__12458;
chunk__12435_12444 = G__12459;
count__12436_12445 = G__12460;
i__12437_12446 = G__12461;
continue;
} else {
var map__12440_12462 = cljs.core.first.call(null,seq__12434_12456__$1);
var map__12440_12463__$1 = ((((!((map__12440_12462 == null)))?(((((map__12440_12462.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12440_12462.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12440_12462):map__12440_12462);
var binding_12464 = map__12440_12463__$1;
var init_12465 = cljs.core.get.call(null,map__12440_12463__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,binding_12464);

cljs.compiler.emitln.call(null," = ",init_12465,";");


var G__12466 = cljs.core.next.call(null,seq__12434_12456__$1);
var G__12467 = null;
var G__12468 = (0);
var G__12469 = (0);
seq__12434_12443 = G__12466;
chunk__12435_12444 = G__12467;
count__12436_12445 = G__12468;
i__12437_12446 = G__12469;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.call(null,"while(true){");
} else {
}

cljs.compiler.emits.call(null,expr);

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.call(null,"break;");

cljs.compiler.emitln.call(null,"}");
} else {
}
}finally {cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR_12433_12442;
}
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"})()");
} else {
return null;
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"let","let",-1282412701),(function (ast){
return cljs.compiler.emit_let.call(null,ast,false);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"loop","loop",-395552849),(function (ast){
return cljs.compiler.emit_let.call(null,ast,true);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"recur","recur",-437573268),(function (p__12470){
var map__12471 = p__12470;
var map__12471__$1 = ((((!((map__12471 == null)))?(((((map__12471.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12471.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12471):map__12471);
var frame = cljs.core.get.call(null,map__12471__$1,new cljs.core.Keyword(null,"frame","frame",-1711082588));
var exprs = cljs.core.get.call(null,map__12471__$1,new cljs.core.Keyword(null,"exprs","exprs",1795829094));
var env = cljs.core.get.call(null,map__12471__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var temps = cljs.core.vec.call(null,cljs.core.take.call(null,cljs.core.count.call(null,exprs),cljs.core.repeatedly.call(null,cljs.core.gensym)));
var params = new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(frame);
var n__4408__auto___12473 = cljs.core.count.call(null,exprs);
var i_12474 = (0);
while(true){
if((i_12474 < n__4408__auto___12473)){
cljs.compiler.emitln.call(null,"var ",temps.call(null,i_12474)," = ",exprs.call(null,i_12474),";");

var G__12475 = (i_12474 + (1));
i_12474 = G__12475;
continue;
} else {
}
break;
}

var n__4408__auto___12476 = cljs.core.count.call(null,exprs);
var i_12477 = (0);
while(true){
if((i_12477 < n__4408__auto___12476)){
cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,params.call(null,i_12477))," = ",temps.call(null,i_12477),";");

var G__12478 = (i_12477 + (1));
i_12477 = G__12478;
continue;
} else {
}
break;
}

return cljs.compiler.emitln.call(null,"continue;");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"letfn","letfn",-2121022354),(function (p__12479){
var map__12480 = p__12479;
var map__12480__$1 = ((((!((map__12480 == null)))?(((((map__12480.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12480.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12480):map__12480);
var bindings = cljs.core.get.call(null,map__12480__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var expr = cljs.core.get.call(null,map__12480__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var env = cljs.core.get.call(null,map__12480__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.call(null,"(function (){");
} else {
}

var seq__12482_12490 = cljs.core.seq.call(null,bindings);
var chunk__12483_12491 = null;
var count__12484_12492 = (0);
var i__12485_12493 = (0);
while(true){
if((i__12485_12493 < count__12484_12492)){
var map__12486_12494 = cljs.core._nth.call(null,chunk__12483_12491,i__12485_12493);
var map__12486_12495__$1 = ((((!((map__12486_12494 == null)))?(((((map__12486_12494.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12486_12494.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12486_12494):map__12486_12494);
var binding_12496 = map__12486_12495__$1;
var init_12497 = cljs.core.get.call(null,map__12486_12495__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.call(null,"var ",cljs.compiler.munge.call(null,binding_12496)," = ",init_12497,";");


var G__12498 = seq__12482_12490;
var G__12499 = chunk__12483_12491;
var G__12500 = count__12484_12492;
var G__12501 = (i__12485_12493 + (1));
seq__12482_12490 = G__12498;
chunk__12483_12491 = G__12499;
count__12484_12492 = G__12500;
i__12485_12493 = G__12501;
continue;
} else {
var temp__5457__auto___12502 = cljs.core.seq.call(null,seq__12482_12490);
if(temp__5457__auto___12502){
var seq__12482_12503__$1 = temp__5457__auto___12502;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12482_12503__$1)){
var c__4351__auto___12504 = cljs.core.chunk_first.call(null,seq__12482_12503__$1);
var G__12505 = cljs.core.chunk_rest.call(null,seq__12482_12503__$1);
var G__12506 = c__4351__auto___12504;
var G__12507 = cljs.core.count.call(null,c__4351__auto___12504);
var G__12508 = (0);
seq__12482_12490 = G__12505;
chunk__12483_12491 = G__12506;
count__12484_12492 = G__12507;
i__12485_12493 = G__12508;
continue;
} else {
var map__12488_12509 = cljs.core.first.call(null,seq__12482_12503__$1);
var map__12488_12510__$1 = ((((!((map__12488_12509 == null)))?(((((map__12488_12509.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12488_12509.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12488_12509):map__12488_12509);
var binding_12511 = map__12488_12510__$1;
var init_12512 = cljs.core.get.call(null,map__12488_12510__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.call(null,"var ",cljs.compiler.munge.call(null,binding_12511)," = ",init_12512,";");


var G__12513 = cljs.core.next.call(null,seq__12482_12503__$1);
var G__12514 = null;
var G__12515 = (0);
var G__12516 = (0);
seq__12482_12490 = G__12513;
chunk__12483_12491 = G__12514;
count__12484_12492 = G__12515;
i__12485_12493 = G__12516;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.call(null,expr);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"})()");
} else {
return null;
}
}));
cljs.compiler.protocol_prefix = (function cljs$compiler$protocol_prefix(psym){
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym)].join('').replace((new RegExp("\\.","g")),"$").replace("/","$")),"$"].join(''));
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"invoke","invoke",1145927159),(function (p__12519){
var map__12520 = p__12519;
var map__12520__$1 = ((((!((map__12520 == null)))?(((((map__12520.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12520.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12520):map__12520);
var expr = map__12520__$1;
var f = cljs.core.get.call(null,map__12520__$1,new cljs.core.Keyword(null,"f","f",-1597136552));
var args = cljs.core.get.call(null,map__12520__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.call(null,map__12520__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(f);
var fn_QMARK_ = (function (){var and__3938__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(and__3938__auto__){
var and__3938__auto____$1 = cljs.core.not.call(null,new cljs.core.Keyword(null,"dynamic","dynamic",704819571).cljs$core$IFn$_invoke$arity$1(info));
if(and__3938__auto____$1){
return new cljs.core.Keyword(null,"fn-var","fn-var",1086204730).cljs$core$IFn$_invoke$arity$1(info);
} else {
return and__3938__auto____$1;
}
} else {
return and__3938__auto__;
}
})();
var protocol = new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(info);
var tag = cljs.analyzer.infer_tag.call(null,env,cljs.core.first.call(null,new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var proto_QMARK_ = (function (){var and__3938__auto__ = protocol;
if(cljs.core.truth_(and__3938__auto__)){
var and__3938__auto____$1 = tag;
if(cljs.core.truth_(and__3938__auto____$1)){
var or__3949__auto__ = (function (){var and__3938__auto____$2 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(and__3938__auto____$2){
var and__3938__auto____$3 = protocol;
if(cljs.core.truth_(and__3938__auto____$3)){
return cljs.core._EQ_.call(null,tag,new cljs.core.Symbol(null,"not-native","not-native",-236392494,null));
} else {
return and__3938__auto____$3;
}
} else {
return and__3938__auto____$2;
}
})();
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
var and__3938__auto____$2 = (function (){var or__3949__auto____$1 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(or__3949__auto____$1){
return or__3949__auto____$1;
} else {
return new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556).cljs$core$IFn$_invoke$arity$1(env);
}
})();
if(cljs.core.truth_(and__3938__auto____$2)){
var or__3949__auto____$1 = cljs.core._EQ_.call(null,protocol,tag);
if(or__3949__auto____$1){
return or__3949__auto____$1;
} else {
var and__3938__auto____$3 = !(cljs.core.set_QMARK_.call(null,tag));
if(and__3938__auto____$3){
var and__3938__auto____$4 = cljs.core.not.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Symbol(null,"clj","clj",980036099,null),null,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),null,new cljs.core.Symbol(null,"object","object",-1179821820,null),null,new cljs.core.Symbol(null,"any","any",-948528346,null),null,new cljs.core.Symbol(null,"js","js",-886355190,null),null,new cljs.core.Symbol(null,"number","number",-1084057331,null),null,new cljs.core.Symbol(null,"clj-or-nil","clj-or-nil",-2008798668,null),null,new cljs.core.Symbol(null,"array","array",-440182315,null),null,new cljs.core.Symbol(null,"string","string",-349010059,null),null,new cljs.core.Symbol(null,"function","function",-486723946,null),null,new cljs.core.Symbol(null,"clj-nil","clj-nil",1321798654,null),null], null), null).call(null,tag));
if(and__3938__auto____$4){
var temp__5457__auto__ = new cljs.core.Keyword(null,"protocols","protocols",-5615896).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_existing_var.call(null,env,tag));
if(cljs.core.truth_(temp__5457__auto__)){
var ps = temp__5457__auto__;
return ps.call(null,protocol);
} else {
return null;
}
} else {
return and__3938__auto____$4;
}
} else {
return and__3938__auto____$3;
}
}
} else {
return and__3938__auto____$2;
}
}
} else {
return and__3938__auto____$1;
}
} else {
return and__3938__auto__;
}
})();
var opt_not_QMARK_ = ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","not","cljs.core/not",100665144,null))) && (cljs.core._EQ_.call(null,cljs.analyzer.infer_tag.call(null,env,cljs.core.first.call(null,new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr))),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null))));
var ns = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(info);
var js_QMARK_ = ((cljs.core._EQ_.call(null,ns,new cljs.core.Symbol(null,"js","js",-886355190,null))) || (cljs.core._EQ_.call(null,ns,new cljs.core.Symbol(null,"Math","Math",2033287572,null))));
var goog_QMARK_ = (cljs.core.truth_(ns)?(function (){var or__3949__auto__ = cljs.core._EQ_.call(null,ns,new cljs.core.Symbol(null,"goog","goog",-70603925,null));
if(or__3949__auto__){
return or__3949__auto__;
} else {
var or__3949__auto____$1 = (function (){var temp__5457__auto__ = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)].join('');
if(cljs.core.truth_(temp__5457__auto__)){
var ns_str = temp__5457__auto__;
return cljs.core._EQ_.call(null,cljs.core.get.call(null,clojure.string.split(ns_str,/\./),(0),null),"goog");
} else {
return null;
}
})();
if(cljs.core.truth_(or__3949__auto____$1)){
return or__3949__auto____$1;
} else {
return !(cljs.core.contains_QMARK_.call(null,new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)),ns));
}
}
})():null);
var keyword_QMARK_ = ((cljs.core._EQ_.call(null,new cljs.core.Symbol("cljs.core","Keyword","cljs.core/Keyword",-451434488,null),cljs.analyzer.infer_tag.call(null,env,f))) || (((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f),new cljs.core.Keyword(null,"const","const",1709929842))) && ((new cljs.core.Keyword(null,"form","form",-1624062471).cljs$core$IFn$_invoke$arity$1(f) instanceof cljs.core.Keyword)))));
var vec__12522 = (cljs.core.truth_(fn_QMARK_)?(function (){var arity = cljs.core.count.call(null,args);
var variadic_QMARK_ = new cljs.core.Keyword(null,"variadic","variadic",882626057).cljs$core$IFn$_invoke$arity$1(info);
var mps = new cljs.core.Keyword(null,"method-params","method-params",-980792179).cljs$core$IFn$_invoke$arity$1(info);
var mfa = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(info);
if(((cljs.core.not.call(null,variadic_QMARK_)) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,mps),(1))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
} else {
if(cljs.core.truth_((function (){var and__3938__auto__ = variadic_QMARK_;
if(cljs.core.truth_(and__3938__auto__)){
return (arity > mfa);
} else {
return and__3938__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.call(null,f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),((function (arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__12520,map__12520__$1,expr,f,args,env){
return (function (info__$1){
return cljs.core.update_in.call(null,cljs.core.assoc.call(null,info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,info__$1)),".cljs$core$IFn$_invoke$arity$variadic"].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),((function (arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__12520,map__12520__$1,expr,f,args,env){
return (function (p1__12517_SHARP_){
return cljs.core.dissoc.call(null,cljs.core.dissoc.call(null,p1__12517_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
});})(arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__12520,map__12520__$1,expr,f,args,env))
);
});})(arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__12520,map__12520__$1,expr,f,args,env))
),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),mfa], null)], null);
} else {
var arities = cljs.core.map.call(null,cljs.core.count,mps);
if(cljs.core.truth_(cljs.core.some.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([arity]),arities))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.call(null,f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),((function (arities,arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__12520,map__12520__$1,expr,f,args,env){
return (function (info__$1){
return cljs.core.update_in.call(null,cljs.core.assoc.call(null,info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,info__$1)),".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arity)].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),((function (arities,arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__12520,map__12520__$1,expr,f,args,env){
return (function (p1__12518_SHARP_){
return cljs.core.dissoc.call(null,cljs.core.dissoc.call(null,p1__12518_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
});})(arities,arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__12520,map__12520__$1,expr,f,args,env))
);
});})(arities,arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__12520,map__12520__$1,expr,f,args,env))
),null], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
}

}
}
})():new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null));
var f__$1 = cljs.core.nth.call(null,vec__12522,(0),null);
var variadic_invoke = cljs.core.nth.call(null,vec__12522,(1),null);
var env__11727__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__11727__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(opt_not_QMARK_){
cljs.compiler.emits.call(null,"!(",cljs.core.first.call(null,args),")");
} else {
if(cljs.core.truth_(proto_QMARK_)){
var pimpl_12525 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,cljs.compiler.protocol_prefix.call(null,protocol))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,cljs.core.name.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info)))),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,args))].join('');
cljs.compiler.emits.call(null,cljs.core.first.call(null,args),".",pimpl_12525,"(",cljs.compiler.comma_sep.call(null,cljs.core.cons.call(null,"null",cljs.core.rest.call(null,args))),")");
} else {
if(keyword_QMARK_){
cljs.compiler.emits.call(null,f__$1,".cljs$core$IFn$_invoke$arity$",cljs.core.count.call(null,args),"(",cljs.compiler.comma_sep.call(null,args),")");
} else {
if(cljs.core.truth_(variadic_invoke)){
var mfa_12526 = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(variadic_invoke);
cljs.compiler.emits.call(null,f__$1,"(",cljs.compiler.comma_sep.call(null,cljs.core.take.call(null,mfa_12526,args)),(((mfa_12526 === (0)))?null:","),"cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([",cljs.compiler.comma_sep.call(null,cljs.core.drop.call(null,mfa_12526,args)),"], 0))");
} else {
if(cljs.core.truth_((function (){var or__3949__auto__ = fn_QMARK_;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
var or__3949__auto____$1 = js_QMARK_;
if(or__3949__auto____$1){
return or__3949__auto____$1;
} else {
return goog_QMARK_;
}
}
})())){
cljs.compiler.emits.call(null,f__$1,"(",cljs.compiler.comma_sep.call(null,args),")");
} else {
if(((cljs.analyzer._STAR_cljs_static_fns_STAR_) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1),new cljs.core.Keyword(null,"var","var",-769682797))))){
var fprop_12527 = [".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,args))].join('');
if(cljs.analyzer._STAR_fn_invoke_direct_STAR_){
cljs.compiler.emits.call(null,"(",f__$1,fprop_12527," ? ",f__$1,fprop_12527,"(",cljs.compiler.comma_sep.call(null,args),") : ",f__$1,"(",cljs.compiler.comma_sep.call(null,args),"))");
} else {
cljs.compiler.emits.call(null,"(",f__$1,fprop_12527," ? ",f__$1,fprop_12527,"(",cljs.compiler.comma_sep.call(null,args),") : ",f__$1,".call(",cljs.compiler.comma_sep.call(null,cljs.core.cons.call(null,"null",args)),"))");
}
} else {
cljs.compiler.emits.call(null,f__$1,".call(",cljs.compiler.comma_sep.call(null,cljs.core.cons.call(null,"null",args)),")");
}

}
}
}
}
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__11727__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"new","new",-2085437848),(function (p__12528){
var map__12529 = p__12528;
var map__12529__$1 = ((((!((map__12529 == null)))?(((((map__12529.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12529.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12529):map__12529);
var ctor = cljs.core.get.call(null,map__12529__$1,new cljs.core.Keyword(null,"ctor","ctor",1750864802));
var args = cljs.core.get.call(null,map__12529__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.call(null,map__12529__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__11727__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__11727__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"(new ",ctor,"(",cljs.compiler.comma_sep.call(null,args),"))");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__11727__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"set!","set!",-1389817006),(function (p__12531){
var map__12532 = p__12531;
var map__12532__$1 = ((((!((map__12532 == null)))?(((((map__12532.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12532.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12532):map__12532);
var target = cljs.core.get.call(null,map__12532__$1,new cljs.core.Keyword(null,"target","target",253001721));
var val = cljs.core.get.call(null,map__12532__$1,new cljs.core.Keyword(null,"val","val",128701612));
var env = cljs.core.get.call(null,map__12532__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__11727__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__11727__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,target," = ",val);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__11727__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.load_libs = (function cljs$compiler$load_libs(libs,seen,reloads,deps,ns_name){
var map__12534 = cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_);
var map__12534__$1 = ((((!((map__12534 == null)))?(((((map__12534.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12534.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12534):map__12534);
var options = cljs.core.get.call(null,map__12534__$1,new cljs.core.Keyword(null,"options","options",99638489));
var js_dependency_index = cljs.core.get.call(null,map__12534__$1,new cljs.core.Keyword(null,"js-dependency-index","js-dependency-index",-1887042131));
var map__12535 = options;
var map__12535__$1 = ((((!((map__12535 == null)))?(((((map__12535.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12535.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12535):map__12535);
var target = cljs.core.get.call(null,map__12535__$1,new cljs.core.Keyword(null,"target","target",253001721));
var optimizations = cljs.core.get.call(null,map__12535__$1,new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854));
var loaded_libs = cljs.compiler.munge.call(null,new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null));
var loaded_libs_temp = cljs.compiler.munge.call(null,cljs.core.gensym.call(null,new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null)));
var vec__12536 = (function (){var libs__$1 = cljs.core.remove.call(null,cljs.core.set.call(null,cljs.core.vals.call(null,seen)),cljs.core.filter.call(null,cljs.core.set.call(null,cljs.core.vals.call(null,libs)),deps));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"nodejs","nodejs",321212524),target)){
var map__12541 = cljs.core.group_by.call(null,cljs.analyzer.node_module_dep_QMARK_,libs__$1);
var map__12541__$1 = ((((!((map__12541 == null)))?(((((map__12541.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12541.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12541):map__12541);
var node_libs = cljs.core.get.call(null,map__12541__$1,true);
var libs_to_load = cljs.core.get.call(null,map__12541__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [node_libs,libs_to_load], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,libs__$1], null);
}
})();
var node_libs = cljs.core.nth.call(null,vec__12536,(0),null);
var libs_to_load = cljs.core.nth.call(null,vec__12536,(1),null);
var global_exports_libs = cljs.core.filter.call(null,cljs.analyzer.dep_has_global_exports_QMARK_,libs_to_load);
if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs)))){
cljs.compiler.emitln.call(null,"if(!COMPILED) ",loaded_libs_temp," = ",loaded_libs," || cljs.core.set([\"cljs.core\"]);");

cljs.compiler.emitln.call(null,"if(!COMPILED) ",loaded_libs," = cljs.core.set([\"cljs.core\"]);");
} else {
}

var seq__12543_12559 = cljs.core.seq.call(null,libs_to_load);
var chunk__12544_12560 = null;
var count__12545_12561 = (0);
var i__12546_12562 = (0);
while(true){
if((i__12546_12562 < count__12545_12561)){
var lib_12563 = cljs.core._nth.call(null,chunk__12544_12560,i__12546_12562);
if(((cljs.analyzer.foreign_dep_QMARK_.call(null,lib_12563)) && (!(cljs.core.keyword_identical_QMARK_.call(null,optimizations,new cljs.core.Keyword(null,"none","none",1333468478)))))){
} else {
if(cljs.core.truth_((function (){var or__3949__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_12563),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_12563),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__3949__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_12563),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_12563),"', 'reload-all');");
} else {
if(cljs.core._EQ_.call(null,lib_12563,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_12563),"');");
}

}
}
}


var G__12564 = seq__12543_12559;
var G__12565 = chunk__12544_12560;
var G__12566 = count__12545_12561;
var G__12567 = (i__12546_12562 + (1));
seq__12543_12559 = G__12564;
chunk__12544_12560 = G__12565;
count__12545_12561 = G__12566;
i__12546_12562 = G__12567;
continue;
} else {
var temp__5457__auto___12568 = cljs.core.seq.call(null,seq__12543_12559);
if(temp__5457__auto___12568){
var seq__12543_12569__$1 = temp__5457__auto___12568;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12543_12569__$1)){
var c__4351__auto___12570 = cljs.core.chunk_first.call(null,seq__12543_12569__$1);
var G__12571 = cljs.core.chunk_rest.call(null,seq__12543_12569__$1);
var G__12572 = c__4351__auto___12570;
var G__12573 = cljs.core.count.call(null,c__4351__auto___12570);
var G__12574 = (0);
seq__12543_12559 = G__12571;
chunk__12544_12560 = G__12572;
count__12545_12561 = G__12573;
i__12546_12562 = G__12574;
continue;
} else {
var lib_12575 = cljs.core.first.call(null,seq__12543_12569__$1);
if(((cljs.analyzer.foreign_dep_QMARK_.call(null,lib_12575)) && (!(cljs.core.keyword_identical_QMARK_.call(null,optimizations,new cljs.core.Keyword(null,"none","none",1333468478)))))){
} else {
if(cljs.core.truth_((function (){var or__3949__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_12575),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_12575),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__3949__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_12575),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_12575),"', 'reload-all');");
} else {
if(cljs.core._EQ_.call(null,lib_12575,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_12575),"');");
}

}
}
}


var G__12576 = cljs.core.next.call(null,seq__12543_12569__$1);
var G__12577 = null;
var G__12578 = (0);
var G__12579 = (0);
seq__12543_12559 = G__12576;
chunk__12544_12560 = G__12577;
count__12545_12561 = G__12578;
i__12546_12562 = G__12579;
continue;
}
} else {
}
}
break;
}

var seq__12547_12580 = cljs.core.seq.call(null,node_libs);
var chunk__12548_12581 = null;
var count__12549_12582 = (0);
var i__12550_12583 = (0);
while(true){
if((i__12550_12583 < count__12549_12582)){
var lib_12584 = cljs.core._nth.call(null,chunk__12548_12581,i__12550_12583);
cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,ns_name),".",cljs.analyzer.munge_node_lib.call(null,lib_12584)," = require('",lib_12584,"');");


var G__12585 = seq__12547_12580;
var G__12586 = chunk__12548_12581;
var G__12587 = count__12549_12582;
var G__12588 = (i__12550_12583 + (1));
seq__12547_12580 = G__12585;
chunk__12548_12581 = G__12586;
count__12549_12582 = G__12587;
i__12550_12583 = G__12588;
continue;
} else {
var temp__5457__auto___12589 = cljs.core.seq.call(null,seq__12547_12580);
if(temp__5457__auto___12589){
var seq__12547_12590__$1 = temp__5457__auto___12589;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12547_12590__$1)){
var c__4351__auto___12591 = cljs.core.chunk_first.call(null,seq__12547_12590__$1);
var G__12592 = cljs.core.chunk_rest.call(null,seq__12547_12590__$1);
var G__12593 = c__4351__auto___12591;
var G__12594 = cljs.core.count.call(null,c__4351__auto___12591);
var G__12595 = (0);
seq__12547_12580 = G__12592;
chunk__12548_12581 = G__12593;
count__12549_12582 = G__12594;
i__12550_12583 = G__12595;
continue;
} else {
var lib_12596 = cljs.core.first.call(null,seq__12547_12590__$1);
cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,ns_name),".",cljs.analyzer.munge_node_lib.call(null,lib_12596)," = require('",lib_12596,"');");


var G__12597 = cljs.core.next.call(null,seq__12547_12590__$1);
var G__12598 = null;
var G__12599 = (0);
var G__12600 = (0);
seq__12547_12580 = G__12597;
chunk__12548_12581 = G__12598;
count__12549_12582 = G__12599;
i__12550_12583 = G__12600;
continue;
}
} else {
}
}
break;
}

var seq__12551_12601 = cljs.core.seq.call(null,global_exports_libs);
var chunk__12552_12602 = null;
var count__12553_12603 = (0);
var i__12554_12604 = (0);
while(true){
if((i__12554_12604 < count__12553_12603)){
var lib_12605 = cljs.core._nth.call(null,chunk__12552_12602,i__12554_12604);
var map__12555_12606 = cljs.core.get.call(null,js_dependency_index,cljs.core.name.call(null,lib_12605));
var map__12555_12607__$1 = ((((!((map__12555_12606 == null)))?(((((map__12555_12606.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12555_12606.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12555_12606):map__12555_12606);
var global_exports_12608 = cljs.core.get.call(null,map__12555_12607__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,ns_name),".",cljs.analyzer.munge_global_export.call(null,lib_12605)," = goog.global[\"",cljs.core.get.call(null,global_exports_12608,cljs.core.symbol.call(null,lib_12605)),"\"];");


var G__12609 = seq__12551_12601;
var G__12610 = chunk__12552_12602;
var G__12611 = count__12553_12603;
var G__12612 = (i__12554_12604 + (1));
seq__12551_12601 = G__12609;
chunk__12552_12602 = G__12610;
count__12553_12603 = G__12611;
i__12554_12604 = G__12612;
continue;
} else {
var temp__5457__auto___12613 = cljs.core.seq.call(null,seq__12551_12601);
if(temp__5457__auto___12613){
var seq__12551_12614__$1 = temp__5457__auto___12613;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12551_12614__$1)){
var c__4351__auto___12615 = cljs.core.chunk_first.call(null,seq__12551_12614__$1);
var G__12616 = cljs.core.chunk_rest.call(null,seq__12551_12614__$1);
var G__12617 = c__4351__auto___12615;
var G__12618 = cljs.core.count.call(null,c__4351__auto___12615);
var G__12619 = (0);
seq__12551_12601 = G__12616;
chunk__12552_12602 = G__12617;
count__12553_12603 = G__12618;
i__12554_12604 = G__12619;
continue;
} else {
var lib_12620 = cljs.core.first.call(null,seq__12551_12614__$1);
var map__12557_12621 = cljs.core.get.call(null,js_dependency_index,cljs.core.name.call(null,lib_12620));
var map__12557_12622__$1 = ((((!((map__12557_12621 == null)))?(((((map__12557_12621.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12557_12621.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12557_12621):map__12557_12621);
var global_exports_12623 = cljs.core.get.call(null,map__12557_12622__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,ns_name),".",cljs.analyzer.munge_global_export.call(null,lib_12620)," = goog.global[\"",cljs.core.get.call(null,global_exports_12623,cljs.core.symbol.call(null,lib_12620)),"\"];");


var G__12624 = cljs.core.next.call(null,seq__12551_12614__$1);
var G__12625 = null;
var G__12626 = (0);
var G__12627 = (0);
seq__12551_12601 = G__12624;
chunk__12552_12602 = G__12625;
count__12553_12603 = G__12626;
i__12554_12604 = G__12627;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs)))){
return cljs.compiler.emitln.call(null,"if(!COMPILED) ",loaded_libs," = cljs.core.into(",loaded_libs_temp,", ",loaded_libs,");");
} else {
return null;
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"ns*","ns*",200417856),(function (p__12628){
var map__12629 = p__12628;
var map__12629__$1 = ((((!((map__12629 == null)))?(((((map__12629.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12629.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12629):map__12629);
var name = cljs.core.get.call(null,map__12629__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.call(null,map__12629__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.call(null,map__12629__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.call(null,map__12629__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.call(null,map__12629__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.call(null,map__12629__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.call(null,map__12629__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.load_libs.call(null,requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

cljs.compiler.load_libs.call(null,uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

if(cljs.core.truth_(new cljs.core.Keyword(null,"repl-env","repl-env",-1976503928).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.call(null,"null;");
} else {
return null;
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"ns","ns",441598760),(function (p__12631){
var map__12632 = p__12631;
var map__12632__$1 = ((((!((map__12632 == null)))?(((((map__12632.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12632.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12632):map__12632);
var name = cljs.core.get.call(null,map__12632__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.call(null,map__12632__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.call(null,map__12632__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.call(null,map__12632__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.call(null,map__12632__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.call(null,map__12632__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.call(null,map__12632__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.emitln.call(null,"goog.provide('",cljs.compiler.munge.call(null,name),"');");

if(cljs.core._EQ_.call(null,name,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null))){
} else {
cljs.compiler.emitln.call(null,"goog.require('cljs.core');");

if(cljs.core.truth_(new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_))))){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,cljs.analyzer.constants_ns_sym),"');");
} else {
}
}

cljs.compiler.load_libs.call(null,requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

return cljs.compiler.load_libs.call(null,uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"deftype","deftype",340294561),(function (p__12634){
var map__12635 = p__12634;
var map__12635__$1 = ((((!((map__12635 == null)))?(((((map__12635.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12635.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12635):map__12635);
var t = cljs.core.get.call(null,map__12635__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.call(null,map__12635__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.call(null,map__12635__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.call(null,map__12635__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.call(null,map__12635__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.map.call(null,cljs.compiler.munge,fields);
cljs.compiler.emitln.call(null,"");

cljs.compiler.emitln.call(null,"/**");

cljs.compiler.emitln.call(null,"* @constructor");

var seq__12637_12655 = cljs.core.seq.call(null,protocols);
var chunk__12638_12656 = null;
var count__12639_12657 = (0);
var i__12640_12658 = (0);
while(true){
if((i__12640_12658 < count__12639_12657)){
var protocol_12659 = cljs.core._nth.call(null,chunk__12638_12656,i__12640_12658);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_12659)].join('')),"}");


var G__12660 = seq__12637_12655;
var G__12661 = chunk__12638_12656;
var G__12662 = count__12639_12657;
var G__12663 = (i__12640_12658 + (1));
seq__12637_12655 = G__12660;
chunk__12638_12656 = G__12661;
count__12639_12657 = G__12662;
i__12640_12658 = G__12663;
continue;
} else {
var temp__5457__auto___12664 = cljs.core.seq.call(null,seq__12637_12655);
if(temp__5457__auto___12664){
var seq__12637_12665__$1 = temp__5457__auto___12664;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12637_12665__$1)){
var c__4351__auto___12666 = cljs.core.chunk_first.call(null,seq__12637_12665__$1);
var G__12667 = cljs.core.chunk_rest.call(null,seq__12637_12665__$1);
var G__12668 = c__4351__auto___12666;
var G__12669 = cljs.core.count.call(null,c__4351__auto___12666);
var G__12670 = (0);
seq__12637_12655 = G__12667;
chunk__12638_12656 = G__12668;
count__12639_12657 = G__12669;
i__12640_12658 = G__12670;
continue;
} else {
var protocol_12671 = cljs.core.first.call(null,seq__12637_12665__$1);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_12671)].join('')),"}");


var G__12672 = cljs.core.next.call(null,seq__12637_12665__$1);
var G__12673 = null;
var G__12674 = (0);
var G__12675 = (0);
seq__12637_12655 = G__12672;
chunk__12638_12656 = G__12673;
count__12639_12657 = G__12674;
i__12640_12658 = G__12675;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"*/");

cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,t)," = (function (",cljs.compiler.comma_sep.call(null,fields__$1),"){");

var seq__12641_12676 = cljs.core.seq.call(null,fields__$1);
var chunk__12642_12677 = null;
var count__12643_12678 = (0);
var i__12644_12679 = (0);
while(true){
if((i__12644_12679 < count__12643_12678)){
var fld_12680 = cljs.core._nth.call(null,chunk__12642_12677,i__12644_12679);
cljs.compiler.emitln.call(null,"this.",fld_12680," = ",fld_12680,";");


var G__12681 = seq__12641_12676;
var G__12682 = chunk__12642_12677;
var G__12683 = count__12643_12678;
var G__12684 = (i__12644_12679 + (1));
seq__12641_12676 = G__12681;
chunk__12642_12677 = G__12682;
count__12643_12678 = G__12683;
i__12644_12679 = G__12684;
continue;
} else {
var temp__5457__auto___12685 = cljs.core.seq.call(null,seq__12641_12676);
if(temp__5457__auto___12685){
var seq__12641_12686__$1 = temp__5457__auto___12685;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12641_12686__$1)){
var c__4351__auto___12687 = cljs.core.chunk_first.call(null,seq__12641_12686__$1);
var G__12688 = cljs.core.chunk_rest.call(null,seq__12641_12686__$1);
var G__12689 = c__4351__auto___12687;
var G__12690 = cljs.core.count.call(null,c__4351__auto___12687);
var G__12691 = (0);
seq__12641_12676 = G__12688;
chunk__12642_12677 = G__12689;
count__12643_12678 = G__12690;
i__12644_12679 = G__12691;
continue;
} else {
var fld_12692 = cljs.core.first.call(null,seq__12641_12686__$1);
cljs.compiler.emitln.call(null,"this.",fld_12692," = ",fld_12692,";");


var G__12693 = cljs.core.next.call(null,seq__12641_12686__$1);
var G__12694 = null;
var G__12695 = (0);
var G__12696 = (0);
seq__12641_12676 = G__12693;
chunk__12642_12677 = G__12694;
count__12643_12678 = G__12695;
i__12644_12679 = G__12696;
continue;
}
} else {
}
}
break;
}

var seq__12645_12697 = cljs.core.seq.call(null,pmasks);
var chunk__12646_12698 = null;
var count__12647_12699 = (0);
var i__12648_12700 = (0);
while(true){
if((i__12648_12700 < count__12647_12699)){
var vec__12649_12701 = cljs.core._nth.call(null,chunk__12646_12698,i__12648_12700);
var pno_12702 = cljs.core.nth.call(null,vec__12649_12701,(0),null);
var pmask_12703 = cljs.core.nth.call(null,vec__12649_12701,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_12702,"$ = ",pmask_12703,";");


var G__12704 = seq__12645_12697;
var G__12705 = chunk__12646_12698;
var G__12706 = count__12647_12699;
var G__12707 = (i__12648_12700 + (1));
seq__12645_12697 = G__12704;
chunk__12646_12698 = G__12705;
count__12647_12699 = G__12706;
i__12648_12700 = G__12707;
continue;
} else {
var temp__5457__auto___12708 = cljs.core.seq.call(null,seq__12645_12697);
if(temp__5457__auto___12708){
var seq__12645_12709__$1 = temp__5457__auto___12708;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12645_12709__$1)){
var c__4351__auto___12710 = cljs.core.chunk_first.call(null,seq__12645_12709__$1);
var G__12711 = cljs.core.chunk_rest.call(null,seq__12645_12709__$1);
var G__12712 = c__4351__auto___12710;
var G__12713 = cljs.core.count.call(null,c__4351__auto___12710);
var G__12714 = (0);
seq__12645_12697 = G__12711;
chunk__12646_12698 = G__12712;
count__12647_12699 = G__12713;
i__12648_12700 = G__12714;
continue;
} else {
var vec__12652_12715 = cljs.core.first.call(null,seq__12645_12709__$1);
var pno_12716 = cljs.core.nth.call(null,vec__12652_12715,(0),null);
var pmask_12717 = cljs.core.nth.call(null,vec__12652_12715,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_12716,"$ = ",pmask_12717,";");


var G__12718 = cljs.core.next.call(null,seq__12645_12709__$1);
var G__12719 = null;
var G__12720 = (0);
var G__12721 = (0);
seq__12645_12697 = G__12718;
chunk__12646_12698 = G__12719;
count__12647_12699 = G__12720;
i__12648_12700 = G__12721;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"});");

return cljs.compiler.emit.call(null,body);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"defrecord","defrecord",-1367493418),(function (p__12722){
var map__12723 = p__12722;
var map__12723__$1 = ((((!((map__12723 == null)))?(((((map__12723.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12723.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12723):map__12723);
var t = cljs.core.get.call(null,map__12723__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.call(null,map__12723__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.call(null,map__12723__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.call(null,map__12723__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.call(null,map__12723__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.concat.call(null,cljs.core.map.call(null,cljs.compiler.munge,fields),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"__meta","__meta",-946752628,null),new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null));
cljs.compiler.emitln.call(null,"");

cljs.compiler.emitln.call(null,"/**");

cljs.compiler.emitln.call(null,"* @constructor");

var seq__12725_12743 = cljs.core.seq.call(null,protocols);
var chunk__12726_12744 = null;
var count__12727_12745 = (0);
var i__12728_12746 = (0);
while(true){
if((i__12728_12746 < count__12727_12745)){
var protocol_12747 = cljs.core._nth.call(null,chunk__12726_12744,i__12728_12746);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_12747)].join('')),"}");


var G__12748 = seq__12725_12743;
var G__12749 = chunk__12726_12744;
var G__12750 = count__12727_12745;
var G__12751 = (i__12728_12746 + (1));
seq__12725_12743 = G__12748;
chunk__12726_12744 = G__12749;
count__12727_12745 = G__12750;
i__12728_12746 = G__12751;
continue;
} else {
var temp__5457__auto___12752 = cljs.core.seq.call(null,seq__12725_12743);
if(temp__5457__auto___12752){
var seq__12725_12753__$1 = temp__5457__auto___12752;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12725_12753__$1)){
var c__4351__auto___12754 = cljs.core.chunk_first.call(null,seq__12725_12753__$1);
var G__12755 = cljs.core.chunk_rest.call(null,seq__12725_12753__$1);
var G__12756 = c__4351__auto___12754;
var G__12757 = cljs.core.count.call(null,c__4351__auto___12754);
var G__12758 = (0);
seq__12725_12743 = G__12755;
chunk__12726_12744 = G__12756;
count__12727_12745 = G__12757;
i__12728_12746 = G__12758;
continue;
} else {
var protocol_12759 = cljs.core.first.call(null,seq__12725_12753__$1);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_12759)].join('')),"}");


var G__12760 = cljs.core.next.call(null,seq__12725_12753__$1);
var G__12761 = null;
var G__12762 = (0);
var G__12763 = (0);
seq__12725_12743 = G__12760;
chunk__12726_12744 = G__12761;
count__12727_12745 = G__12762;
i__12728_12746 = G__12763;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"*/");

cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,t)," = (function (",cljs.compiler.comma_sep.call(null,fields__$1),"){");

var seq__12729_12764 = cljs.core.seq.call(null,fields__$1);
var chunk__12730_12765 = null;
var count__12731_12766 = (0);
var i__12732_12767 = (0);
while(true){
if((i__12732_12767 < count__12731_12766)){
var fld_12768 = cljs.core._nth.call(null,chunk__12730_12765,i__12732_12767);
cljs.compiler.emitln.call(null,"this.",fld_12768," = ",fld_12768,";");


var G__12769 = seq__12729_12764;
var G__12770 = chunk__12730_12765;
var G__12771 = count__12731_12766;
var G__12772 = (i__12732_12767 + (1));
seq__12729_12764 = G__12769;
chunk__12730_12765 = G__12770;
count__12731_12766 = G__12771;
i__12732_12767 = G__12772;
continue;
} else {
var temp__5457__auto___12773 = cljs.core.seq.call(null,seq__12729_12764);
if(temp__5457__auto___12773){
var seq__12729_12774__$1 = temp__5457__auto___12773;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12729_12774__$1)){
var c__4351__auto___12775 = cljs.core.chunk_first.call(null,seq__12729_12774__$1);
var G__12776 = cljs.core.chunk_rest.call(null,seq__12729_12774__$1);
var G__12777 = c__4351__auto___12775;
var G__12778 = cljs.core.count.call(null,c__4351__auto___12775);
var G__12779 = (0);
seq__12729_12764 = G__12776;
chunk__12730_12765 = G__12777;
count__12731_12766 = G__12778;
i__12732_12767 = G__12779;
continue;
} else {
var fld_12780 = cljs.core.first.call(null,seq__12729_12774__$1);
cljs.compiler.emitln.call(null,"this.",fld_12780," = ",fld_12780,";");


var G__12781 = cljs.core.next.call(null,seq__12729_12774__$1);
var G__12782 = null;
var G__12783 = (0);
var G__12784 = (0);
seq__12729_12764 = G__12781;
chunk__12730_12765 = G__12782;
count__12731_12766 = G__12783;
i__12732_12767 = G__12784;
continue;
}
} else {
}
}
break;
}

var seq__12733_12785 = cljs.core.seq.call(null,pmasks);
var chunk__12734_12786 = null;
var count__12735_12787 = (0);
var i__12736_12788 = (0);
while(true){
if((i__12736_12788 < count__12735_12787)){
var vec__12737_12789 = cljs.core._nth.call(null,chunk__12734_12786,i__12736_12788);
var pno_12790 = cljs.core.nth.call(null,vec__12737_12789,(0),null);
var pmask_12791 = cljs.core.nth.call(null,vec__12737_12789,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_12790,"$ = ",pmask_12791,";");


var G__12792 = seq__12733_12785;
var G__12793 = chunk__12734_12786;
var G__12794 = count__12735_12787;
var G__12795 = (i__12736_12788 + (1));
seq__12733_12785 = G__12792;
chunk__12734_12786 = G__12793;
count__12735_12787 = G__12794;
i__12736_12788 = G__12795;
continue;
} else {
var temp__5457__auto___12796 = cljs.core.seq.call(null,seq__12733_12785);
if(temp__5457__auto___12796){
var seq__12733_12797__$1 = temp__5457__auto___12796;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12733_12797__$1)){
var c__4351__auto___12798 = cljs.core.chunk_first.call(null,seq__12733_12797__$1);
var G__12799 = cljs.core.chunk_rest.call(null,seq__12733_12797__$1);
var G__12800 = c__4351__auto___12798;
var G__12801 = cljs.core.count.call(null,c__4351__auto___12798);
var G__12802 = (0);
seq__12733_12785 = G__12799;
chunk__12734_12786 = G__12800;
count__12735_12787 = G__12801;
i__12736_12788 = G__12802;
continue;
} else {
var vec__12740_12803 = cljs.core.first.call(null,seq__12733_12797__$1);
var pno_12804 = cljs.core.nth.call(null,vec__12740_12803,(0),null);
var pmask_12805 = cljs.core.nth.call(null,vec__12740_12803,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_12804,"$ = ",pmask_12805,";");


var G__12806 = cljs.core.next.call(null,seq__12733_12797__$1);
var G__12807 = null;
var G__12808 = (0);
var G__12809 = (0);
seq__12733_12785 = G__12806;
chunk__12734_12786 = G__12807;
count__12735_12787 = G__12808;
i__12736_12788 = G__12809;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"});");

return cljs.compiler.emit.call(null,body);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"dot","dot",1442709401),(function (p__12810){
var map__12811 = p__12810;
var map__12811__$1 = ((((!((map__12811 == null)))?(((((map__12811.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12811.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12811):map__12811);
var target = cljs.core.get.call(null,map__12811__$1,new cljs.core.Keyword(null,"target","target",253001721));
var field = cljs.core.get.call(null,map__12811__$1,new cljs.core.Keyword(null,"field","field",-1302436500));
var method = cljs.core.get.call(null,map__12811__$1,new cljs.core.Keyword(null,"method","method",55703592));
var args = cljs.core.get.call(null,map__12811__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.call(null,map__12811__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__11727__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__11727__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(cljs.core.truth_(field)){
cljs.compiler.emits.call(null,target,".",cljs.compiler.munge.call(null,field,cljs.core.PersistentHashSet.EMPTY));
} else {
cljs.compiler.emits.call(null,target,".",cljs.compiler.munge.call(null,method,cljs.core.PersistentHashSet.EMPTY),"(",cljs.compiler.comma_sep.call(null,args),")");
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__11727__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"js","js",1768080579),(function (p__12813){
var map__12814 = p__12813;
var map__12814__$1 = ((((!((map__12814 == null)))?(((((map__12814.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12814.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12814):map__12814);
var op = cljs.core.get.call(null,map__12814__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var env = cljs.core.get.call(null,map__12814__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var code = cljs.core.get.call(null,map__12814__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var segs = cljs.core.get.call(null,map__12814__$1,new cljs.core.Keyword(null,"segs","segs",-1940299576));
var args = cljs.core.get.call(null,map__12814__$1,new cljs.core.Keyword(null,"args","args",1315556576));
if(cljs.core.truth_((function (){var and__3938__auto__ = code;
if(cljs.core.truth_(and__3938__auto__)){
return goog.string.startsWith(clojure.string.trim(code),"/*");
} else {
return and__3938__auto__;
}
})())){
return cljs.compiler.emits.call(null,code);
} else {
var env__11727__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__11727__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(cljs.core.truth_(code)){
cljs.compiler.emits.call(null,code);
} else {
cljs.compiler.emits.call(null,cljs.core.interleave.call(null,cljs.core.concat.call(null,segs,cljs.core.repeat.call(null,null)),cljs.core.concat.call(null,args,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null))));
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__11727__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}
}));
cljs.compiler.emit_constants_table = (function cljs$compiler$emit_constants_table(table){
cljs.compiler.emitln.call(null,"goog.provide('",cljs.compiler.munge.call(null,cljs.analyzer.constants_ns_sym),"');");

cljs.compiler.emitln.call(null,"goog.require('cljs.core');");

var seq__12819 = cljs.core.seq.call(null,table);
var chunk__12820 = null;
var count__12821 = (0);
var i__12822 = (0);
while(true){
if((i__12822 < count__12821)){
var vec__12823 = cljs.core._nth.call(null,chunk__12820,i__12822);
var sym = cljs.core.nth.call(null,vec__12823,(0),null);
var value = cljs.core.nth.call(null,vec__12823,(1),null);
var ns_12829 = cljs.core.namespace.call(null,sym);
var name_12830 = cljs.core.name.call(null,sym);
cljs.compiler.emits.call(null,"cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword.call(null,sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol.call(null,sym);
} else {
throw cljs.core.ex_info.call(null,["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type.call(null,sym))].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471)], null));

}
}

cljs.compiler.emits.call(null,";\n");


var G__12831 = seq__12819;
var G__12832 = chunk__12820;
var G__12833 = count__12821;
var G__12834 = (i__12822 + (1));
seq__12819 = G__12831;
chunk__12820 = G__12832;
count__12821 = G__12833;
i__12822 = G__12834;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__12819);
if(temp__5457__auto__){
var seq__12819__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12819__$1)){
var c__4351__auto__ = cljs.core.chunk_first.call(null,seq__12819__$1);
var G__12835 = cljs.core.chunk_rest.call(null,seq__12819__$1);
var G__12836 = c__4351__auto__;
var G__12837 = cljs.core.count.call(null,c__4351__auto__);
var G__12838 = (0);
seq__12819 = G__12835;
chunk__12820 = G__12836;
count__12821 = G__12837;
i__12822 = G__12838;
continue;
} else {
var vec__12826 = cljs.core.first.call(null,seq__12819__$1);
var sym = cljs.core.nth.call(null,vec__12826,(0),null);
var value = cljs.core.nth.call(null,vec__12826,(1),null);
var ns_12839 = cljs.core.namespace.call(null,sym);
var name_12840 = cljs.core.name.call(null,sym);
cljs.compiler.emits.call(null,"cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword.call(null,sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol.call(null,sym);
} else {
throw cljs.core.ex_info.call(null,["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type.call(null,sym))].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471)], null));

}
}

cljs.compiler.emits.call(null,";\n");


var G__12841 = cljs.core.next.call(null,seq__12819__$1);
var G__12842 = null;
var G__12843 = (0);
var G__12844 = (0);
seq__12819 = G__12841;
chunk__12820 = G__12842;
count__12821 = G__12843;
i__12822 = G__12844;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_externs = (function cljs$compiler$emit_externs(var_args){
var G__12846 = arguments.length;
switch (G__12846) {
case 1:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1 = (function (externs){
return cljs.compiler.emit_externs.call(null,cljs.core.PersistentVector.EMPTY,externs,cljs.core.atom.call(null,cljs.core.PersistentHashSet.EMPTY),(cljs.core.truth_(cljs.env._STAR_compiler_STAR_)?new cljs.core.Keyword("cljs.analyzer","externs","cljs.analyzer/externs",893359239).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)):null));
});

cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4 = (function (prefix,externs,top_level,known_externs){
var ks = cljs.core.seq.call(null,cljs.core.keys.call(null,externs));
while(true){
if(ks){
var k_12851 = cljs.core.first.call(null,ks);
var vec__12847_12852 = cljs.core.conj.call(null,prefix,k_12851);
var top_12853 = cljs.core.nth.call(null,vec__12847_12852,(0),null);
var prefix_SINGLEQUOTE__12854 = vec__12847_12852;
if(((cljs.core.not_EQ_.call(null,new cljs.core.Symbol(null,"prototype","prototype",519166522,null),k_12851)) && ((cljs.core.get_in.call(null,known_externs,prefix_SINGLEQUOTE__12854) == null)))){
if(!(((cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,top_level),top_12853)) || (cljs.core.contains_QMARK_.call(null,known_externs,top_12853))))){
cljs.compiler.emitln.call(null,"var ",clojure.string.join(".",cljs.core.map.call(null,cljs.compiler.munge,prefix_SINGLEQUOTE__12854)),";");

cljs.core.swap_BANG_.call(null,top_level,cljs.core.conj,top_12853);
} else {
cljs.compiler.emitln.call(null,clojure.string.join(".",cljs.core.map.call(null,cljs.compiler.munge,prefix_SINGLEQUOTE__12854)),";");
}
} else {
}

var m_12855 = cljs.core.get.call(null,externs,k_12851);
if(cljs.core.empty_QMARK_.call(null,m_12855)){
} else {
cljs.compiler.emit_externs.call(null,prefix_SINGLEQUOTE__12854,m_12855,top_level,known_externs);
}

var G__12856 = cljs.core.next.call(null,ks);
ks = G__12856;
continue;
} else {
return null;
}
break;
}
});

cljs.compiler.emit_externs.cljs$lang$maxFixedArity = 4;


//# sourceMappingURL=compiler.js.map
