// Compiled by ClojureScript 1.10.339 {}
goog.provide('cljs.source_map');
goog.require('cljs.core');
goog.require('goog.object');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.source_map.base64_vlq');
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.call(null,(function (m,p__11113){
var vec__11114 = p__11113;
var i = cljs.core.nth.call(null,vec__11114,(0),null);
var v = cljs.core.nth.call(null,vec__11114,(1),null);
return cljs.core.assoc.call(null,m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.call(null,(function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources.call(null,sources);
return ((function (sources__$1){
return (function (a,b){
return cljs.core.compare.call(null,sources__$1.call(null,a),sources__$1.call(null,b));
});
;})(sources__$1))
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__11117 = seg;
var gcol = cljs.core.nth.call(null,vec__11117,(0),null);
var source = cljs.core.nth.call(null,vec__11117,(1),null);
var line = cljs.core.nth.call(null,vec__11117,(2),null);
var col = cljs.core.nth.call(null,vec__11117,(3),null);
var name = cljs.core.nth.call(null,vec__11117,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol,new cljs.core.Keyword(null,"source","source",-433931539),(goog.object.get(source_map,"sources")[source]),new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"name","name",1843675177),(function (){var temp__5457__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,seg));
if(cljs.core.truth_(temp__5457__auto__)){
var name__$1 = temp__5457__auto__;
return (goog.object.get(source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__11120 = seg;
var gcol = cljs.core.nth.call(null,vec__11120,(0),null);
var source = cljs.core.nth.call(null,vec__11120,(1),null);
var line = cljs.core.nth.call(null,vec__11120,(2),null);
var col = cljs.core.nth.call(null,vec__11120,(3),null);
var name = cljs.core.nth.call(null,vec__11120,(4),null);
var vec__11123 = relseg;
var rgcol = cljs.core.nth.call(null,vec__11123,(0),null);
var rsource = cljs.core.nth.call(null,vec__11123,(1),null);
var rline = cljs.core.nth.call(null,vec__11123,(2),null);
var rcol = cljs.core.nth.call(null,vec__11123,(3),null);
var rname = cljs.core.nth.call(null,vec__11123,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__3949__auto__ = source;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__3949__auto__ = line;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__3949__auto__ = col;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__3949__auto__ = name;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta.call(null,nseg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__11126 = segmap;
var map__11126__$1 = ((((!((map__11126 == null)))?(((((map__11126.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11126.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11126):map__11126);
var gcol = cljs.core.get.call(null,map__11126__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.call(null,map__11126__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.call(null,map__11126__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.call(null,map__11126__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.call(null,map__11126__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gline","gline",-1086242431),gline,new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.call(null,d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.call(null,result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.call(null,((function (map__11126,map__11126__$1,gcol,source,line,col,name,d,d__$1){
return (function (m){
return cljs.core.update_in.call(null,m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.call(null,((function (map__11126,map__11126__$1,gcol,source,line,col,name,d,d__$1){
return (function (m__$1){
return cljs.core.update_in.call(null,m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.call(null,((function (map__11126,map__11126__$1,gcol,source,line,col,name,d,d__$1){
return (function (v){
return cljs.core.conj.call(null,v,d__$1);
});})(map__11126,map__11126__$1,gcol,source,line,col,name,d,d__$1))
,cljs.core.PersistentVector.EMPTY));
});})(map__11126,map__11126__$1,gcol,source,line,col,name,d,d__$1))
,cljs.core.sorted_map.call(null)));
});})(map__11126,map__11126__$1,gcol,source,line,col,name,d,d__$1))
,cljs.core.sorted_map.call(null)));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__11129 = arguments.length;
switch (G__11129) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.call(null,goog.object.get(source_map,"mappings"),source_map);
});

cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq.call(null,clojure.string.split(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by.call(null,cljs.source_map.source_compare.call(null,sources));
while(true){
if(lines__$1){
var line = cljs.core.first.call(null,lines__$1);
var vec__11130 = (cljs.core.truth_(clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq.call(null,clojure.string.split(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first.call(null,segs__$1);
var nrelseg = cljs.source_map.seg_combine.call(null,cljs.source_map.base64_vlq.decode.call(null,seg),relseg__$1);
var G__11134 = cljs.core.next.call(null,segs__$1);
var G__11135 = nrelseg;
var G__11136 = cljs.source_map.update_reverse_result.call(null,result__$1,cljs.source_map.seg__GT_map.call(null,nrelseg,source_map),gline);
segs__$1 = G__11134;
relseg__$1 = G__11135;
result__$1 = G__11136;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.call(null,vec__11130,(0),null);
var relseg__$1 = cljs.core.nth.call(null,vec__11130,(1),null);
var G__11137 = (gline + (1));
var G__11138 = cljs.core.next.call(null,lines__$1);
var G__11139 = cljs.core.assoc.call(null,relseg__$1,(0),(0));
var G__11140 = result__$1;
gline = G__11137;
lines__$1 = G__11138;
relseg = G__11139;
result = G__11140;
continue;
} else {
return result;
}
break;
}
});

cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2;

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__11142 = segmap;
var map__11142__$1 = ((((!((map__11142 == null)))?(((((map__11142.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11142.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11142):map__11142);
var gcol = cljs.core.get.call(null,map__11142__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.call(null,map__11142__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.call(null,map__11142__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.call(null,map__11142__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.call(null,map__11142__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"source","source",-433931539),source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.call(null,d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.call(null,result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.call(null,((function (map__11142,map__11142__$1,gcol,source,line,col,name,d,d__$1){
return (function (m){
return cljs.core.update_in.call(null,m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.call(null,((function (map__11142,map__11142__$1,gcol,source,line,col,name,d,d__$1){
return (function (p1__11141_SHARP_){
return cljs.core.conj.call(null,p1__11141_SHARP_,d__$1);
});})(map__11142,map__11142__$1,gcol,source,line,col,name,d,d__$1))
,cljs.core.PersistentVector.EMPTY));
});})(map__11142,map__11142__$1,gcol,source,line,col,name,d,d__$1))
,cljs.core.sorted_map.call(null)));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__11145 = arguments.length;
switch (G__11145) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.call(null,goog.object.get(source_map,"mappings"),source_map);
});

cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq.call(null,clojure.string.split(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first.call(null,lines__$1);
var vec__11146 = (cljs.core.truth_(clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq.call(null,clojure.string.split(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first.call(null,segs__$1);
var nrelseg = cljs.source_map.seg_combine.call(null,cljs.source_map.base64_vlq.decode.call(null,seg),relseg__$1);
var G__11150 = cljs.core.next.call(null,segs__$1);
var G__11151 = nrelseg;
var G__11152 = cljs.source_map.update_result.call(null,result__$1,cljs.source_map.seg__GT_map.call(null,nrelseg,source_map),gline);
segs__$1 = G__11150;
relseg__$1 = G__11151;
result__$1 = G__11152;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.call(null,vec__11146,(0),null);
var relseg__$1 = cljs.core.nth.call(null,vec__11146,(1),null);
var G__11153 = (gline + (1));
var G__11154 = cljs.core.next.call(null,lines__$1);
var G__11155 = cljs.core.assoc.call(null,relseg__$1,(0),(0));
var G__11156 = result__$1;
gline = G__11153;
lines__$1 = G__11154;
relseg = G__11155;
result = G__11156;
continue;
} else {
return result;
}
break;
}
});

cljs.source_map.decode.cljs$lang$maxFixedArity = 2;

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.call(null,((function (relseg){
return (function (segs,cols){
cljs.core.swap_BANG_.call(null,relseg,((function (relseg){
return (function (p__11157){
var vec__11158 = p__11157;
var _ = cljs.core.nth.call(null,vec__11158,(0),null);
var source = cljs.core.nth.call(null,vec__11158,(1),null);
var line = cljs.core.nth.call(null,vec__11158,(2),null);
var col = cljs.core.nth.call(null,vec__11158,(3),null);
var name = cljs.core.nth.call(null,vec__11158,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
});})(relseg))
);

return cljs.core.conj.call(null,segs,cljs.core.reduce.call(null,((function (relseg){
return (function (cols__$1,p__11161){
var vec__11162 = p__11161;
var gcol = cljs.core.nth.call(null,vec__11162,(0),null);
var sidx = cljs.core.nth.call(null,vec__11162,(1),null);
var line = cljs.core.nth.call(null,vec__11162,(2),null);
var col = cljs.core.nth.call(null,vec__11162,(3),null);
var name = cljs.core.nth.call(null,vec__11162,(4),null);
var seg = vec__11162;
var offset = cljs.core.map.call(null,cljs.core._,seg,cljs.core.deref.call(null,relseg));
cljs.core.swap_BANG_.call(null,relseg,((function (offset,vec__11162,gcol,sidx,line,col,name,seg,relseg){
return (function (p__11165){
var vec__11166 = p__11165;
var _ = cljs.core.nth.call(null,vec__11166,(0),null);
var ___$1 = cljs.core.nth.call(null,vec__11166,(1),null);
var ___$2 = cljs.core.nth.call(null,vec__11166,(2),null);
var ___$3 = cljs.core.nth.call(null,vec__11166,(3),null);
var lname = cljs.core.nth.call(null,vec__11166,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__3949__auto__ = name;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return lname;
}
})()], null);
});})(offset,vec__11162,gcol,sidx,line,col,name,seg,relseg))
);

return cljs.core.conj.call(null,cols__$1,cljs.source_map.base64_vlq.encode.call(null,offset));
});})(relseg))
,cljs.core.PersistentVector.EMPTY,cols));
});})(relseg))
,cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.call(null,(0));
var preamble_lines = cljs.core.take.call(null,(function (){var or__3949__auto__ = new cljs.core.Keyword(null,"preamble-line-count","preamble-line-count",-659949744).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.call(null,cljs.core.PersistentVector.EMPTY));
var info__GT_segv = ((function (lines,names__GT_idx,name_idx,preamble_lines){
return (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gcol","gcol",309250807).cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5455__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5455__auto__)){
var name = temp__5455__auto__;
var idx = (function (){var temp__5455__auto____$1 = cljs.core.get.call(null,cljs.core.deref.call(null,names__GT_idx),name);
if(cljs.core.truth_(temp__5455__auto____$1)){
var idx = temp__5455__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref.call(null,name_idx);
cljs.core.swap_BANG_.call(null,names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.call(null,name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.call(null,segv,idx);
} else {
return segv;
}
});})(lines,names__GT_idx,name_idx,preamble_lines))
;
var encode_cols = ((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (infos,source_idx,line,col){
var seq__11172 = cljs.core.seq.call(null,infos);
var chunk__11173 = null;
var count__11174 = (0);
var i__11175 = (0);
while(true){
if((i__11175 < count__11174)){
var info = cljs.core._nth.call(null,chunk__11173,i__11175);
var segv_11254 = info__GT_segv.call(null,info,source_idx,line,col);
var gline_11255 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_11256 = cljs.core.count.call(null,cljs.core.deref.call(null,lines));
if((gline_11255 > (lc_11256 - (1)))){
cljs.core.swap_BANG_.call(null,lines,((function (seq__11172,chunk__11173,count__11174,i__11175,segv_11254,gline_11255,lc_11256,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.call(null,cljs.core.into.call(null,lines__$1,cljs.core.repeat.call(null,((gline_11255 - (lc_11256 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_11254], null));
});})(seq__11172,chunk__11173,count__11174,i__11175,segv_11254,gline_11255,lc_11256,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.call(null,lines,((function (seq__11172,chunk__11173,count__11174,i__11175,segv_11254,gline_11255,lc_11256,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.call(null,lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_11255], null),cljs.core.conj,segv_11254);
});})(seq__11172,chunk__11173,count__11174,i__11175,segv_11254,gline_11255,lc_11256,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__11257 = seq__11172;
var G__11258 = chunk__11173;
var G__11259 = count__11174;
var G__11260 = (i__11175 + (1));
seq__11172 = G__11257;
chunk__11173 = G__11258;
count__11174 = G__11259;
i__11175 = G__11260;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__11172);
if(temp__5457__auto__){
var seq__11172__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11172__$1)){
var c__4351__auto__ = cljs.core.chunk_first.call(null,seq__11172__$1);
var G__11261 = cljs.core.chunk_rest.call(null,seq__11172__$1);
var G__11262 = c__4351__auto__;
var G__11263 = cljs.core.count.call(null,c__4351__auto__);
var G__11264 = (0);
seq__11172 = G__11261;
chunk__11173 = G__11262;
count__11174 = G__11263;
i__11175 = G__11264;
continue;
} else {
var info = cljs.core.first.call(null,seq__11172__$1);
var segv_11265 = info__GT_segv.call(null,info,source_idx,line,col);
var gline_11266 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_11267 = cljs.core.count.call(null,cljs.core.deref.call(null,lines));
if((gline_11266 > (lc_11267 - (1)))){
cljs.core.swap_BANG_.call(null,lines,((function (seq__11172,chunk__11173,count__11174,i__11175,segv_11265,gline_11266,lc_11267,info,seq__11172__$1,temp__5457__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.call(null,cljs.core.into.call(null,lines__$1,cljs.core.repeat.call(null,((gline_11266 - (lc_11267 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_11265], null));
});})(seq__11172,chunk__11173,count__11174,i__11175,segv_11265,gline_11266,lc_11267,info,seq__11172__$1,temp__5457__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.call(null,lines,((function (seq__11172,chunk__11173,count__11174,i__11175,segv_11265,gline_11266,lc_11267,info,seq__11172__$1,temp__5457__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.call(null,lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_11266], null),cljs.core.conj,segv_11265);
});})(seq__11172,chunk__11173,count__11174,i__11175,segv_11265,gline_11266,lc_11267,info,seq__11172__$1,temp__5457__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__11268 = cljs.core.next.call(null,seq__11172__$1);
var G__11269 = null;
var G__11270 = (0);
var G__11271 = (0);
seq__11172 = G__11268;
chunk__11173 = G__11269;
count__11174 = G__11270;
i__11175 = G__11271;
continue;
}
} else {
return null;
}
}
break;
}
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
;
var seq__11176_11272 = cljs.core.seq.call(null,cljs.core.map_indexed.call(null,((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__11177_11273 = null;
var count__11178_11274 = (0);
var i__11179_11275 = (0);
while(true){
if((i__11179_11275 < count__11178_11274)){
var vec__11180_11276 = cljs.core._nth.call(null,chunk__11177_11273,i__11179_11275);
var source_idx_11277 = cljs.core.nth.call(null,vec__11180_11276,(0),null);
var vec__11183_11278 = cljs.core.nth.call(null,vec__11180_11276,(1),null);
var __11279 = cljs.core.nth.call(null,vec__11183_11278,(0),null);
var lines_11280__$1 = cljs.core.nth.call(null,vec__11183_11278,(1),null);
var seq__11186_11281 = cljs.core.seq.call(null,lines_11280__$1);
var chunk__11187_11282 = null;
var count__11188_11283 = (0);
var i__11189_11284 = (0);
while(true){
if((i__11189_11284 < count__11188_11283)){
var vec__11190_11285 = cljs.core._nth.call(null,chunk__11187_11282,i__11189_11284);
var line_11286 = cljs.core.nth.call(null,vec__11190_11285,(0),null);
var cols_11287 = cljs.core.nth.call(null,vec__11190_11285,(1),null);
var seq__11193_11288 = cljs.core.seq.call(null,cols_11287);
var chunk__11194_11289 = null;
var count__11195_11290 = (0);
var i__11196_11291 = (0);
while(true){
if((i__11196_11291 < count__11195_11290)){
var vec__11197_11292 = cljs.core._nth.call(null,chunk__11194_11289,i__11196_11291);
var col_11293 = cljs.core.nth.call(null,vec__11197_11292,(0),null);
var infos_11294 = cljs.core.nth.call(null,vec__11197_11292,(1),null);
encode_cols.call(null,infos_11294,source_idx_11277,line_11286,col_11293);


var G__11295 = seq__11193_11288;
var G__11296 = chunk__11194_11289;
var G__11297 = count__11195_11290;
var G__11298 = (i__11196_11291 + (1));
seq__11193_11288 = G__11295;
chunk__11194_11289 = G__11296;
count__11195_11290 = G__11297;
i__11196_11291 = G__11298;
continue;
} else {
var temp__5457__auto___11299 = cljs.core.seq.call(null,seq__11193_11288);
if(temp__5457__auto___11299){
var seq__11193_11300__$1 = temp__5457__auto___11299;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11193_11300__$1)){
var c__4351__auto___11301 = cljs.core.chunk_first.call(null,seq__11193_11300__$1);
var G__11302 = cljs.core.chunk_rest.call(null,seq__11193_11300__$1);
var G__11303 = c__4351__auto___11301;
var G__11304 = cljs.core.count.call(null,c__4351__auto___11301);
var G__11305 = (0);
seq__11193_11288 = G__11302;
chunk__11194_11289 = G__11303;
count__11195_11290 = G__11304;
i__11196_11291 = G__11305;
continue;
} else {
var vec__11200_11306 = cljs.core.first.call(null,seq__11193_11300__$1);
var col_11307 = cljs.core.nth.call(null,vec__11200_11306,(0),null);
var infos_11308 = cljs.core.nth.call(null,vec__11200_11306,(1),null);
encode_cols.call(null,infos_11308,source_idx_11277,line_11286,col_11307);


var G__11309 = cljs.core.next.call(null,seq__11193_11300__$1);
var G__11310 = null;
var G__11311 = (0);
var G__11312 = (0);
seq__11193_11288 = G__11309;
chunk__11194_11289 = G__11310;
count__11195_11290 = G__11311;
i__11196_11291 = G__11312;
continue;
}
} else {
}
}
break;
}


var G__11313 = seq__11186_11281;
var G__11314 = chunk__11187_11282;
var G__11315 = count__11188_11283;
var G__11316 = (i__11189_11284 + (1));
seq__11186_11281 = G__11313;
chunk__11187_11282 = G__11314;
count__11188_11283 = G__11315;
i__11189_11284 = G__11316;
continue;
} else {
var temp__5457__auto___11317 = cljs.core.seq.call(null,seq__11186_11281);
if(temp__5457__auto___11317){
var seq__11186_11318__$1 = temp__5457__auto___11317;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11186_11318__$1)){
var c__4351__auto___11319 = cljs.core.chunk_first.call(null,seq__11186_11318__$1);
var G__11320 = cljs.core.chunk_rest.call(null,seq__11186_11318__$1);
var G__11321 = c__4351__auto___11319;
var G__11322 = cljs.core.count.call(null,c__4351__auto___11319);
var G__11323 = (0);
seq__11186_11281 = G__11320;
chunk__11187_11282 = G__11321;
count__11188_11283 = G__11322;
i__11189_11284 = G__11323;
continue;
} else {
var vec__11203_11324 = cljs.core.first.call(null,seq__11186_11318__$1);
var line_11325 = cljs.core.nth.call(null,vec__11203_11324,(0),null);
var cols_11326 = cljs.core.nth.call(null,vec__11203_11324,(1),null);
var seq__11206_11327 = cljs.core.seq.call(null,cols_11326);
var chunk__11207_11328 = null;
var count__11208_11329 = (0);
var i__11209_11330 = (0);
while(true){
if((i__11209_11330 < count__11208_11329)){
var vec__11210_11331 = cljs.core._nth.call(null,chunk__11207_11328,i__11209_11330);
var col_11332 = cljs.core.nth.call(null,vec__11210_11331,(0),null);
var infos_11333 = cljs.core.nth.call(null,vec__11210_11331,(1),null);
encode_cols.call(null,infos_11333,source_idx_11277,line_11325,col_11332);


var G__11334 = seq__11206_11327;
var G__11335 = chunk__11207_11328;
var G__11336 = count__11208_11329;
var G__11337 = (i__11209_11330 + (1));
seq__11206_11327 = G__11334;
chunk__11207_11328 = G__11335;
count__11208_11329 = G__11336;
i__11209_11330 = G__11337;
continue;
} else {
var temp__5457__auto___11338__$1 = cljs.core.seq.call(null,seq__11206_11327);
if(temp__5457__auto___11338__$1){
var seq__11206_11339__$1 = temp__5457__auto___11338__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11206_11339__$1)){
var c__4351__auto___11340 = cljs.core.chunk_first.call(null,seq__11206_11339__$1);
var G__11341 = cljs.core.chunk_rest.call(null,seq__11206_11339__$1);
var G__11342 = c__4351__auto___11340;
var G__11343 = cljs.core.count.call(null,c__4351__auto___11340);
var G__11344 = (0);
seq__11206_11327 = G__11341;
chunk__11207_11328 = G__11342;
count__11208_11329 = G__11343;
i__11209_11330 = G__11344;
continue;
} else {
var vec__11213_11345 = cljs.core.first.call(null,seq__11206_11339__$1);
var col_11346 = cljs.core.nth.call(null,vec__11213_11345,(0),null);
var infos_11347 = cljs.core.nth.call(null,vec__11213_11345,(1),null);
encode_cols.call(null,infos_11347,source_idx_11277,line_11325,col_11346);


var G__11348 = cljs.core.next.call(null,seq__11206_11339__$1);
var G__11349 = null;
var G__11350 = (0);
var G__11351 = (0);
seq__11206_11327 = G__11348;
chunk__11207_11328 = G__11349;
count__11208_11329 = G__11350;
i__11209_11330 = G__11351;
continue;
}
} else {
}
}
break;
}


var G__11352 = cljs.core.next.call(null,seq__11186_11318__$1);
var G__11353 = null;
var G__11354 = (0);
var G__11355 = (0);
seq__11186_11281 = G__11352;
chunk__11187_11282 = G__11353;
count__11188_11283 = G__11354;
i__11189_11284 = G__11355;
continue;
}
} else {
}
}
break;
}


var G__11356 = seq__11176_11272;
var G__11357 = chunk__11177_11273;
var G__11358 = count__11178_11274;
var G__11359 = (i__11179_11275 + (1));
seq__11176_11272 = G__11356;
chunk__11177_11273 = G__11357;
count__11178_11274 = G__11358;
i__11179_11275 = G__11359;
continue;
} else {
var temp__5457__auto___11360 = cljs.core.seq.call(null,seq__11176_11272);
if(temp__5457__auto___11360){
var seq__11176_11361__$1 = temp__5457__auto___11360;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11176_11361__$1)){
var c__4351__auto___11362 = cljs.core.chunk_first.call(null,seq__11176_11361__$1);
var G__11363 = cljs.core.chunk_rest.call(null,seq__11176_11361__$1);
var G__11364 = c__4351__auto___11362;
var G__11365 = cljs.core.count.call(null,c__4351__auto___11362);
var G__11366 = (0);
seq__11176_11272 = G__11363;
chunk__11177_11273 = G__11364;
count__11178_11274 = G__11365;
i__11179_11275 = G__11366;
continue;
} else {
var vec__11216_11367 = cljs.core.first.call(null,seq__11176_11361__$1);
var source_idx_11368 = cljs.core.nth.call(null,vec__11216_11367,(0),null);
var vec__11219_11369 = cljs.core.nth.call(null,vec__11216_11367,(1),null);
var __11370 = cljs.core.nth.call(null,vec__11219_11369,(0),null);
var lines_11371__$1 = cljs.core.nth.call(null,vec__11219_11369,(1),null);
var seq__11222_11372 = cljs.core.seq.call(null,lines_11371__$1);
var chunk__11223_11373 = null;
var count__11224_11374 = (0);
var i__11225_11375 = (0);
while(true){
if((i__11225_11375 < count__11224_11374)){
var vec__11226_11376 = cljs.core._nth.call(null,chunk__11223_11373,i__11225_11375);
var line_11377 = cljs.core.nth.call(null,vec__11226_11376,(0),null);
var cols_11378 = cljs.core.nth.call(null,vec__11226_11376,(1),null);
var seq__11229_11379 = cljs.core.seq.call(null,cols_11378);
var chunk__11230_11380 = null;
var count__11231_11381 = (0);
var i__11232_11382 = (0);
while(true){
if((i__11232_11382 < count__11231_11381)){
var vec__11233_11383 = cljs.core._nth.call(null,chunk__11230_11380,i__11232_11382);
var col_11384 = cljs.core.nth.call(null,vec__11233_11383,(0),null);
var infos_11385 = cljs.core.nth.call(null,vec__11233_11383,(1),null);
encode_cols.call(null,infos_11385,source_idx_11368,line_11377,col_11384);


var G__11386 = seq__11229_11379;
var G__11387 = chunk__11230_11380;
var G__11388 = count__11231_11381;
var G__11389 = (i__11232_11382 + (1));
seq__11229_11379 = G__11386;
chunk__11230_11380 = G__11387;
count__11231_11381 = G__11388;
i__11232_11382 = G__11389;
continue;
} else {
var temp__5457__auto___11390__$1 = cljs.core.seq.call(null,seq__11229_11379);
if(temp__5457__auto___11390__$1){
var seq__11229_11391__$1 = temp__5457__auto___11390__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11229_11391__$1)){
var c__4351__auto___11392 = cljs.core.chunk_first.call(null,seq__11229_11391__$1);
var G__11393 = cljs.core.chunk_rest.call(null,seq__11229_11391__$1);
var G__11394 = c__4351__auto___11392;
var G__11395 = cljs.core.count.call(null,c__4351__auto___11392);
var G__11396 = (0);
seq__11229_11379 = G__11393;
chunk__11230_11380 = G__11394;
count__11231_11381 = G__11395;
i__11232_11382 = G__11396;
continue;
} else {
var vec__11236_11397 = cljs.core.first.call(null,seq__11229_11391__$1);
var col_11398 = cljs.core.nth.call(null,vec__11236_11397,(0),null);
var infos_11399 = cljs.core.nth.call(null,vec__11236_11397,(1),null);
encode_cols.call(null,infos_11399,source_idx_11368,line_11377,col_11398);


var G__11400 = cljs.core.next.call(null,seq__11229_11391__$1);
var G__11401 = null;
var G__11402 = (0);
var G__11403 = (0);
seq__11229_11379 = G__11400;
chunk__11230_11380 = G__11401;
count__11231_11381 = G__11402;
i__11232_11382 = G__11403;
continue;
}
} else {
}
}
break;
}


var G__11404 = seq__11222_11372;
var G__11405 = chunk__11223_11373;
var G__11406 = count__11224_11374;
var G__11407 = (i__11225_11375 + (1));
seq__11222_11372 = G__11404;
chunk__11223_11373 = G__11405;
count__11224_11374 = G__11406;
i__11225_11375 = G__11407;
continue;
} else {
var temp__5457__auto___11408__$1 = cljs.core.seq.call(null,seq__11222_11372);
if(temp__5457__auto___11408__$1){
var seq__11222_11409__$1 = temp__5457__auto___11408__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11222_11409__$1)){
var c__4351__auto___11410 = cljs.core.chunk_first.call(null,seq__11222_11409__$1);
var G__11411 = cljs.core.chunk_rest.call(null,seq__11222_11409__$1);
var G__11412 = c__4351__auto___11410;
var G__11413 = cljs.core.count.call(null,c__4351__auto___11410);
var G__11414 = (0);
seq__11222_11372 = G__11411;
chunk__11223_11373 = G__11412;
count__11224_11374 = G__11413;
i__11225_11375 = G__11414;
continue;
} else {
var vec__11239_11415 = cljs.core.first.call(null,seq__11222_11409__$1);
var line_11416 = cljs.core.nth.call(null,vec__11239_11415,(0),null);
var cols_11417 = cljs.core.nth.call(null,vec__11239_11415,(1),null);
var seq__11242_11418 = cljs.core.seq.call(null,cols_11417);
var chunk__11243_11419 = null;
var count__11244_11420 = (0);
var i__11245_11421 = (0);
while(true){
if((i__11245_11421 < count__11244_11420)){
var vec__11246_11422 = cljs.core._nth.call(null,chunk__11243_11419,i__11245_11421);
var col_11423 = cljs.core.nth.call(null,vec__11246_11422,(0),null);
var infos_11424 = cljs.core.nth.call(null,vec__11246_11422,(1),null);
encode_cols.call(null,infos_11424,source_idx_11368,line_11416,col_11423);


var G__11425 = seq__11242_11418;
var G__11426 = chunk__11243_11419;
var G__11427 = count__11244_11420;
var G__11428 = (i__11245_11421 + (1));
seq__11242_11418 = G__11425;
chunk__11243_11419 = G__11426;
count__11244_11420 = G__11427;
i__11245_11421 = G__11428;
continue;
} else {
var temp__5457__auto___11429__$2 = cljs.core.seq.call(null,seq__11242_11418);
if(temp__5457__auto___11429__$2){
var seq__11242_11430__$1 = temp__5457__auto___11429__$2;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11242_11430__$1)){
var c__4351__auto___11431 = cljs.core.chunk_first.call(null,seq__11242_11430__$1);
var G__11432 = cljs.core.chunk_rest.call(null,seq__11242_11430__$1);
var G__11433 = c__4351__auto___11431;
var G__11434 = cljs.core.count.call(null,c__4351__auto___11431);
var G__11435 = (0);
seq__11242_11418 = G__11432;
chunk__11243_11419 = G__11433;
count__11244_11420 = G__11434;
i__11245_11421 = G__11435;
continue;
} else {
var vec__11249_11436 = cljs.core.first.call(null,seq__11242_11430__$1);
var col_11437 = cljs.core.nth.call(null,vec__11249_11436,(0),null);
var infos_11438 = cljs.core.nth.call(null,vec__11249_11436,(1),null);
encode_cols.call(null,infos_11438,source_idx_11368,line_11416,col_11437);


var G__11439 = cljs.core.next.call(null,seq__11242_11430__$1);
var G__11440 = null;
var G__11441 = (0);
var G__11442 = (0);
seq__11242_11418 = G__11439;
chunk__11243_11419 = G__11440;
count__11244_11420 = G__11441;
i__11245_11421 = G__11442;
continue;
}
} else {
}
}
break;
}


var G__11443 = cljs.core.next.call(null,seq__11222_11409__$1);
var G__11444 = null;
var G__11445 = (0);
var G__11446 = (0);
seq__11222_11372 = G__11443;
chunk__11223_11373 = G__11444;
count__11224_11374 = G__11445;
i__11225_11375 = G__11446;
continue;
}
} else {
}
}
break;
}


var G__11447 = cljs.core.next.call(null,seq__11176_11361__$1);
var G__11448 = null;
var G__11449 = (0);
var G__11450 = (0);
seq__11176_11272 = G__11447;
chunk__11177_11273 = G__11448;
count__11178_11274 = G__11449;
i__11179_11275 = G__11450;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__11252 = ({"version": (3), "file": new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys.call(null,m);
var f = cljs.core.comp.call(null,((new cljs.core.Keyword(null,"source-map-timestamp","source-map-timestamp",1973015633).cljs$core$IFn$_invoke$arity$1(opts) === true)?((function (paths,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (p1__11169_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__11169_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
});})(paths,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
:cljs.core.identity),((function (paths,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (p1__11170_SHARP_){
return cljs.core.last.call(null,clojure.string.split(p1__11170_SHARP_,/\//));
});})(paths,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
);
return cljs.core.into_array.call(null,cljs.core.map.call(null,f,paths));
})(), "lineCount": new cljs.core.Keyword(null,"lines","lines",-700165781).cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join(";",cljs.core.map.call(null,((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (p1__11171_SHARP_){
return clojure.string.join(",",p1__11171_SHARP_);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,cljs.source_map.lines__GT_segs.call(null,cljs.core.concat.call(null,preamble_lines,cljs.core.deref.call(null,lines))))), "names": cljs.core.into_array.call(null,cljs.core.map.call(null,clojure.set.map_invert(cljs.core.deref.call(null,names__GT_idx)),cljs.core.range.call(null,cljs.core.count.call(null,cljs.core.deref.call(null,names__GT_idx)))))});
if(cljs.core.truth_(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts))){
var G__11253 = G__11252;
goog.object.set(G__11253,"sourcesContent",cljs.core.into_array.call(null,new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts)));

return G__11253;
} else {
return G__11252;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq.call(null,cljs_map);
var new_lines = cljs.core.sorted_map.call(null);
while(true){
if(line_map_seq){
var vec__11451 = cljs.core.first.call(null,line_map_seq);
var line = cljs.core.nth.call(null,vec__11451,(0),null);
var col_map = cljs.core.nth.call(null,vec__11451,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq.call(null,col_map);
var new_cols = cljs.core.sorted_map.call(null);
while(true){
if(col_map_seq){
var vec__11454 = cljs.core.first.call(null,col_map_seq);
var col = cljs.core.nth.call(null,vec__11454,(0),null);
var infos = cljs.core.nth.call(null,vec__11454,(1),null);
var G__11460 = cljs.core.next.call(null,col_map_seq);
var G__11461 = cljs.core.assoc.call(null,new_cols,col,cljs.core.reduce.call(null,((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__11454,col,infos,vec__11451,line,col_map){
return (function (v,p__11457){
var map__11458 = p__11457;
var map__11458__$1 = ((((!((map__11458 == null)))?(((((map__11458.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11458.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11458):map__11458);
var gline = cljs.core.get.call(null,map__11458__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol = cljs.core.get.call(null,map__11458__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
return cljs.core.into.call(null,v,cljs.core.get_in.call(null,js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__11454,col,infos,vec__11451,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__11460;
new_cols = G__11461;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__11462 = cljs.core.next.call(null,line_map_seq);
var G__11463 = cljs.core.assoc.call(null,new_lines,line,new_cols);
line_map_seq = G__11462;
new_lines = G__11463;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.call(null,cljs.core.sorted_map.call(null));
var seq__11464_11526 = cljs.core.seq.call(null,reverse_map);
var chunk__11465_11527 = null;
var count__11466_11528 = (0);
var i__11467_11529 = (0);
while(true){
if((i__11467_11529 < count__11466_11528)){
var vec__11468_11530 = cljs.core._nth.call(null,chunk__11465_11527,i__11467_11529);
var line_11531 = cljs.core.nth.call(null,vec__11468_11530,(0),null);
var columns_11532 = cljs.core.nth.call(null,vec__11468_11530,(1),null);
var seq__11471_11533 = cljs.core.seq.call(null,columns_11532);
var chunk__11472_11534 = null;
var count__11473_11535 = (0);
var i__11474_11536 = (0);
while(true){
if((i__11474_11536 < count__11473_11535)){
var vec__11475_11537 = cljs.core._nth.call(null,chunk__11472_11534,i__11474_11536);
var column_11538 = cljs.core.nth.call(null,vec__11475_11537,(0),null);
var column_info_11539 = cljs.core.nth.call(null,vec__11475_11537,(1),null);
var seq__11478_11540 = cljs.core.seq.call(null,column_info_11539);
var chunk__11479_11541 = null;
var count__11480_11542 = (0);
var i__11481_11543 = (0);
while(true){
if((i__11481_11543 < count__11480_11542)){
var map__11482_11544 = cljs.core._nth.call(null,chunk__11479_11541,i__11481_11543);
var map__11482_11545__$1 = ((((!((map__11482_11544 == null)))?(((((map__11482_11544.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11482_11544.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11482_11544):map__11482_11544);
var gline_11546 = cljs.core.get.call(null,map__11482_11545__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_11547 = cljs.core.get.call(null,map__11482_11545__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_11548 = cljs.core.get.call(null,map__11482_11545__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_11546], null),cljs.core.fnil.call(null,((function (seq__11478_11540,chunk__11479_11541,count__11480_11542,i__11481_11543,seq__11471_11533,chunk__11472_11534,count__11473_11535,i__11474_11536,seq__11464_11526,chunk__11465_11527,count__11466_11528,i__11467_11529,map__11482_11544,map__11482_11545__$1,gline_11546,gcol_11547,name_11548,vec__11475_11537,column_11538,column_info_11539,vec__11468_11530,line_11531,columns_11532,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_11547], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_11531,new cljs.core.Keyword(null,"col","col",-1959363084),column_11538,new cljs.core.Keyword(null,"name","name",1843675177),name_11548], null));
});})(seq__11478_11540,chunk__11479_11541,count__11480_11542,i__11481_11543,seq__11471_11533,chunk__11472_11534,count__11473_11535,i__11474_11536,seq__11464_11526,chunk__11465_11527,count__11466_11528,i__11467_11529,map__11482_11544,map__11482_11545__$1,gline_11546,gcol_11547,name_11548,vec__11475_11537,column_11538,column_info_11539,vec__11468_11530,line_11531,columns_11532,inverted))
,cljs.core.sorted_map.call(null)));


var G__11549 = seq__11478_11540;
var G__11550 = chunk__11479_11541;
var G__11551 = count__11480_11542;
var G__11552 = (i__11481_11543 + (1));
seq__11478_11540 = G__11549;
chunk__11479_11541 = G__11550;
count__11480_11542 = G__11551;
i__11481_11543 = G__11552;
continue;
} else {
var temp__5457__auto___11553 = cljs.core.seq.call(null,seq__11478_11540);
if(temp__5457__auto___11553){
var seq__11478_11554__$1 = temp__5457__auto___11553;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11478_11554__$1)){
var c__4351__auto___11555 = cljs.core.chunk_first.call(null,seq__11478_11554__$1);
var G__11556 = cljs.core.chunk_rest.call(null,seq__11478_11554__$1);
var G__11557 = c__4351__auto___11555;
var G__11558 = cljs.core.count.call(null,c__4351__auto___11555);
var G__11559 = (0);
seq__11478_11540 = G__11556;
chunk__11479_11541 = G__11557;
count__11480_11542 = G__11558;
i__11481_11543 = G__11559;
continue;
} else {
var map__11484_11560 = cljs.core.first.call(null,seq__11478_11554__$1);
var map__11484_11561__$1 = ((((!((map__11484_11560 == null)))?(((((map__11484_11560.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11484_11560.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11484_11560):map__11484_11560);
var gline_11562 = cljs.core.get.call(null,map__11484_11561__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_11563 = cljs.core.get.call(null,map__11484_11561__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_11564 = cljs.core.get.call(null,map__11484_11561__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_11562], null),cljs.core.fnil.call(null,((function (seq__11478_11540,chunk__11479_11541,count__11480_11542,i__11481_11543,seq__11471_11533,chunk__11472_11534,count__11473_11535,i__11474_11536,seq__11464_11526,chunk__11465_11527,count__11466_11528,i__11467_11529,map__11484_11560,map__11484_11561__$1,gline_11562,gcol_11563,name_11564,seq__11478_11554__$1,temp__5457__auto___11553,vec__11475_11537,column_11538,column_info_11539,vec__11468_11530,line_11531,columns_11532,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_11563], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_11531,new cljs.core.Keyword(null,"col","col",-1959363084),column_11538,new cljs.core.Keyword(null,"name","name",1843675177),name_11564], null));
});})(seq__11478_11540,chunk__11479_11541,count__11480_11542,i__11481_11543,seq__11471_11533,chunk__11472_11534,count__11473_11535,i__11474_11536,seq__11464_11526,chunk__11465_11527,count__11466_11528,i__11467_11529,map__11484_11560,map__11484_11561__$1,gline_11562,gcol_11563,name_11564,seq__11478_11554__$1,temp__5457__auto___11553,vec__11475_11537,column_11538,column_info_11539,vec__11468_11530,line_11531,columns_11532,inverted))
,cljs.core.sorted_map.call(null)));


var G__11565 = cljs.core.next.call(null,seq__11478_11554__$1);
var G__11566 = null;
var G__11567 = (0);
var G__11568 = (0);
seq__11478_11540 = G__11565;
chunk__11479_11541 = G__11566;
count__11480_11542 = G__11567;
i__11481_11543 = G__11568;
continue;
}
} else {
}
}
break;
}


var G__11569 = seq__11471_11533;
var G__11570 = chunk__11472_11534;
var G__11571 = count__11473_11535;
var G__11572 = (i__11474_11536 + (1));
seq__11471_11533 = G__11569;
chunk__11472_11534 = G__11570;
count__11473_11535 = G__11571;
i__11474_11536 = G__11572;
continue;
} else {
var temp__5457__auto___11573 = cljs.core.seq.call(null,seq__11471_11533);
if(temp__5457__auto___11573){
var seq__11471_11574__$1 = temp__5457__auto___11573;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11471_11574__$1)){
var c__4351__auto___11575 = cljs.core.chunk_first.call(null,seq__11471_11574__$1);
var G__11576 = cljs.core.chunk_rest.call(null,seq__11471_11574__$1);
var G__11577 = c__4351__auto___11575;
var G__11578 = cljs.core.count.call(null,c__4351__auto___11575);
var G__11579 = (0);
seq__11471_11533 = G__11576;
chunk__11472_11534 = G__11577;
count__11473_11535 = G__11578;
i__11474_11536 = G__11579;
continue;
} else {
var vec__11486_11580 = cljs.core.first.call(null,seq__11471_11574__$1);
var column_11581 = cljs.core.nth.call(null,vec__11486_11580,(0),null);
var column_info_11582 = cljs.core.nth.call(null,vec__11486_11580,(1),null);
var seq__11489_11583 = cljs.core.seq.call(null,column_info_11582);
var chunk__11490_11584 = null;
var count__11491_11585 = (0);
var i__11492_11586 = (0);
while(true){
if((i__11492_11586 < count__11491_11585)){
var map__11493_11587 = cljs.core._nth.call(null,chunk__11490_11584,i__11492_11586);
var map__11493_11588__$1 = ((((!((map__11493_11587 == null)))?(((((map__11493_11587.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11493_11587.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11493_11587):map__11493_11587);
var gline_11589 = cljs.core.get.call(null,map__11493_11588__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_11590 = cljs.core.get.call(null,map__11493_11588__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_11591 = cljs.core.get.call(null,map__11493_11588__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_11589], null),cljs.core.fnil.call(null,((function (seq__11489_11583,chunk__11490_11584,count__11491_11585,i__11492_11586,seq__11471_11533,chunk__11472_11534,count__11473_11535,i__11474_11536,seq__11464_11526,chunk__11465_11527,count__11466_11528,i__11467_11529,map__11493_11587,map__11493_11588__$1,gline_11589,gcol_11590,name_11591,vec__11486_11580,column_11581,column_info_11582,seq__11471_11574__$1,temp__5457__auto___11573,vec__11468_11530,line_11531,columns_11532,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_11590], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_11531,new cljs.core.Keyword(null,"col","col",-1959363084),column_11581,new cljs.core.Keyword(null,"name","name",1843675177),name_11591], null));
});})(seq__11489_11583,chunk__11490_11584,count__11491_11585,i__11492_11586,seq__11471_11533,chunk__11472_11534,count__11473_11535,i__11474_11536,seq__11464_11526,chunk__11465_11527,count__11466_11528,i__11467_11529,map__11493_11587,map__11493_11588__$1,gline_11589,gcol_11590,name_11591,vec__11486_11580,column_11581,column_info_11582,seq__11471_11574__$1,temp__5457__auto___11573,vec__11468_11530,line_11531,columns_11532,inverted))
,cljs.core.sorted_map.call(null)));


var G__11592 = seq__11489_11583;
var G__11593 = chunk__11490_11584;
var G__11594 = count__11491_11585;
var G__11595 = (i__11492_11586 + (1));
seq__11489_11583 = G__11592;
chunk__11490_11584 = G__11593;
count__11491_11585 = G__11594;
i__11492_11586 = G__11595;
continue;
} else {
var temp__5457__auto___11596__$1 = cljs.core.seq.call(null,seq__11489_11583);
if(temp__5457__auto___11596__$1){
var seq__11489_11597__$1 = temp__5457__auto___11596__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11489_11597__$1)){
var c__4351__auto___11598 = cljs.core.chunk_first.call(null,seq__11489_11597__$1);
var G__11599 = cljs.core.chunk_rest.call(null,seq__11489_11597__$1);
var G__11600 = c__4351__auto___11598;
var G__11601 = cljs.core.count.call(null,c__4351__auto___11598);
var G__11602 = (0);
seq__11489_11583 = G__11599;
chunk__11490_11584 = G__11600;
count__11491_11585 = G__11601;
i__11492_11586 = G__11602;
continue;
} else {
var map__11495_11603 = cljs.core.first.call(null,seq__11489_11597__$1);
var map__11495_11604__$1 = ((((!((map__11495_11603 == null)))?(((((map__11495_11603.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11495_11603.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11495_11603):map__11495_11603);
var gline_11605 = cljs.core.get.call(null,map__11495_11604__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_11606 = cljs.core.get.call(null,map__11495_11604__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_11607 = cljs.core.get.call(null,map__11495_11604__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_11605], null),cljs.core.fnil.call(null,((function (seq__11489_11583,chunk__11490_11584,count__11491_11585,i__11492_11586,seq__11471_11533,chunk__11472_11534,count__11473_11535,i__11474_11536,seq__11464_11526,chunk__11465_11527,count__11466_11528,i__11467_11529,map__11495_11603,map__11495_11604__$1,gline_11605,gcol_11606,name_11607,seq__11489_11597__$1,temp__5457__auto___11596__$1,vec__11486_11580,column_11581,column_info_11582,seq__11471_11574__$1,temp__5457__auto___11573,vec__11468_11530,line_11531,columns_11532,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_11606], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_11531,new cljs.core.Keyword(null,"col","col",-1959363084),column_11581,new cljs.core.Keyword(null,"name","name",1843675177),name_11607], null));
});})(seq__11489_11583,chunk__11490_11584,count__11491_11585,i__11492_11586,seq__11471_11533,chunk__11472_11534,count__11473_11535,i__11474_11536,seq__11464_11526,chunk__11465_11527,count__11466_11528,i__11467_11529,map__11495_11603,map__11495_11604__$1,gline_11605,gcol_11606,name_11607,seq__11489_11597__$1,temp__5457__auto___11596__$1,vec__11486_11580,column_11581,column_info_11582,seq__11471_11574__$1,temp__5457__auto___11573,vec__11468_11530,line_11531,columns_11532,inverted))
,cljs.core.sorted_map.call(null)));


var G__11608 = cljs.core.next.call(null,seq__11489_11597__$1);
var G__11609 = null;
var G__11610 = (0);
var G__11611 = (0);
seq__11489_11583 = G__11608;
chunk__11490_11584 = G__11609;
count__11491_11585 = G__11610;
i__11492_11586 = G__11611;
continue;
}
} else {
}
}
break;
}


var G__11612 = cljs.core.next.call(null,seq__11471_11574__$1);
var G__11613 = null;
var G__11614 = (0);
var G__11615 = (0);
seq__11471_11533 = G__11612;
chunk__11472_11534 = G__11613;
count__11473_11535 = G__11614;
i__11474_11536 = G__11615;
continue;
}
} else {
}
}
break;
}


var G__11616 = seq__11464_11526;
var G__11617 = chunk__11465_11527;
var G__11618 = count__11466_11528;
var G__11619 = (i__11467_11529 + (1));
seq__11464_11526 = G__11616;
chunk__11465_11527 = G__11617;
count__11466_11528 = G__11618;
i__11467_11529 = G__11619;
continue;
} else {
var temp__5457__auto___11620 = cljs.core.seq.call(null,seq__11464_11526);
if(temp__5457__auto___11620){
var seq__11464_11621__$1 = temp__5457__auto___11620;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11464_11621__$1)){
var c__4351__auto___11622 = cljs.core.chunk_first.call(null,seq__11464_11621__$1);
var G__11623 = cljs.core.chunk_rest.call(null,seq__11464_11621__$1);
var G__11624 = c__4351__auto___11622;
var G__11625 = cljs.core.count.call(null,c__4351__auto___11622);
var G__11626 = (0);
seq__11464_11526 = G__11623;
chunk__11465_11527 = G__11624;
count__11466_11528 = G__11625;
i__11467_11529 = G__11626;
continue;
} else {
var vec__11497_11627 = cljs.core.first.call(null,seq__11464_11621__$1);
var line_11628 = cljs.core.nth.call(null,vec__11497_11627,(0),null);
var columns_11629 = cljs.core.nth.call(null,vec__11497_11627,(1),null);
var seq__11500_11630 = cljs.core.seq.call(null,columns_11629);
var chunk__11501_11631 = null;
var count__11502_11632 = (0);
var i__11503_11633 = (0);
while(true){
if((i__11503_11633 < count__11502_11632)){
var vec__11504_11634 = cljs.core._nth.call(null,chunk__11501_11631,i__11503_11633);
var column_11635 = cljs.core.nth.call(null,vec__11504_11634,(0),null);
var column_info_11636 = cljs.core.nth.call(null,vec__11504_11634,(1),null);
var seq__11507_11637 = cljs.core.seq.call(null,column_info_11636);
var chunk__11508_11638 = null;
var count__11509_11639 = (0);
var i__11510_11640 = (0);
while(true){
if((i__11510_11640 < count__11509_11639)){
var map__11511_11641 = cljs.core._nth.call(null,chunk__11508_11638,i__11510_11640);
var map__11511_11642__$1 = ((((!((map__11511_11641 == null)))?(((((map__11511_11641.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11511_11641.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11511_11641):map__11511_11641);
var gline_11643 = cljs.core.get.call(null,map__11511_11642__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_11644 = cljs.core.get.call(null,map__11511_11642__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_11645 = cljs.core.get.call(null,map__11511_11642__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_11643], null),cljs.core.fnil.call(null,((function (seq__11507_11637,chunk__11508_11638,count__11509_11639,i__11510_11640,seq__11500_11630,chunk__11501_11631,count__11502_11632,i__11503_11633,seq__11464_11526,chunk__11465_11527,count__11466_11528,i__11467_11529,map__11511_11641,map__11511_11642__$1,gline_11643,gcol_11644,name_11645,vec__11504_11634,column_11635,column_info_11636,vec__11497_11627,line_11628,columns_11629,seq__11464_11621__$1,temp__5457__auto___11620,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_11644], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_11628,new cljs.core.Keyword(null,"col","col",-1959363084),column_11635,new cljs.core.Keyword(null,"name","name",1843675177),name_11645], null));
});})(seq__11507_11637,chunk__11508_11638,count__11509_11639,i__11510_11640,seq__11500_11630,chunk__11501_11631,count__11502_11632,i__11503_11633,seq__11464_11526,chunk__11465_11527,count__11466_11528,i__11467_11529,map__11511_11641,map__11511_11642__$1,gline_11643,gcol_11644,name_11645,vec__11504_11634,column_11635,column_info_11636,vec__11497_11627,line_11628,columns_11629,seq__11464_11621__$1,temp__5457__auto___11620,inverted))
,cljs.core.sorted_map.call(null)));


var G__11646 = seq__11507_11637;
var G__11647 = chunk__11508_11638;
var G__11648 = count__11509_11639;
var G__11649 = (i__11510_11640 + (1));
seq__11507_11637 = G__11646;
chunk__11508_11638 = G__11647;
count__11509_11639 = G__11648;
i__11510_11640 = G__11649;
continue;
} else {
var temp__5457__auto___11650__$1 = cljs.core.seq.call(null,seq__11507_11637);
if(temp__5457__auto___11650__$1){
var seq__11507_11651__$1 = temp__5457__auto___11650__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11507_11651__$1)){
var c__4351__auto___11652 = cljs.core.chunk_first.call(null,seq__11507_11651__$1);
var G__11653 = cljs.core.chunk_rest.call(null,seq__11507_11651__$1);
var G__11654 = c__4351__auto___11652;
var G__11655 = cljs.core.count.call(null,c__4351__auto___11652);
var G__11656 = (0);
seq__11507_11637 = G__11653;
chunk__11508_11638 = G__11654;
count__11509_11639 = G__11655;
i__11510_11640 = G__11656;
continue;
} else {
var map__11513_11657 = cljs.core.first.call(null,seq__11507_11651__$1);
var map__11513_11658__$1 = ((((!((map__11513_11657 == null)))?(((((map__11513_11657.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11513_11657.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11513_11657):map__11513_11657);
var gline_11659 = cljs.core.get.call(null,map__11513_11658__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_11660 = cljs.core.get.call(null,map__11513_11658__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_11661 = cljs.core.get.call(null,map__11513_11658__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_11659], null),cljs.core.fnil.call(null,((function (seq__11507_11637,chunk__11508_11638,count__11509_11639,i__11510_11640,seq__11500_11630,chunk__11501_11631,count__11502_11632,i__11503_11633,seq__11464_11526,chunk__11465_11527,count__11466_11528,i__11467_11529,map__11513_11657,map__11513_11658__$1,gline_11659,gcol_11660,name_11661,seq__11507_11651__$1,temp__5457__auto___11650__$1,vec__11504_11634,column_11635,column_info_11636,vec__11497_11627,line_11628,columns_11629,seq__11464_11621__$1,temp__5457__auto___11620,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_11660], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_11628,new cljs.core.Keyword(null,"col","col",-1959363084),column_11635,new cljs.core.Keyword(null,"name","name",1843675177),name_11661], null));
});})(seq__11507_11637,chunk__11508_11638,count__11509_11639,i__11510_11640,seq__11500_11630,chunk__11501_11631,count__11502_11632,i__11503_11633,seq__11464_11526,chunk__11465_11527,count__11466_11528,i__11467_11529,map__11513_11657,map__11513_11658__$1,gline_11659,gcol_11660,name_11661,seq__11507_11651__$1,temp__5457__auto___11650__$1,vec__11504_11634,column_11635,column_info_11636,vec__11497_11627,line_11628,columns_11629,seq__11464_11621__$1,temp__5457__auto___11620,inverted))
,cljs.core.sorted_map.call(null)));


var G__11662 = cljs.core.next.call(null,seq__11507_11651__$1);
var G__11663 = null;
var G__11664 = (0);
var G__11665 = (0);
seq__11507_11637 = G__11662;
chunk__11508_11638 = G__11663;
count__11509_11639 = G__11664;
i__11510_11640 = G__11665;
continue;
}
} else {
}
}
break;
}


var G__11666 = seq__11500_11630;
var G__11667 = chunk__11501_11631;
var G__11668 = count__11502_11632;
var G__11669 = (i__11503_11633 + (1));
seq__11500_11630 = G__11666;
chunk__11501_11631 = G__11667;
count__11502_11632 = G__11668;
i__11503_11633 = G__11669;
continue;
} else {
var temp__5457__auto___11670__$1 = cljs.core.seq.call(null,seq__11500_11630);
if(temp__5457__auto___11670__$1){
var seq__11500_11671__$1 = temp__5457__auto___11670__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11500_11671__$1)){
var c__4351__auto___11672 = cljs.core.chunk_first.call(null,seq__11500_11671__$1);
var G__11673 = cljs.core.chunk_rest.call(null,seq__11500_11671__$1);
var G__11674 = c__4351__auto___11672;
var G__11675 = cljs.core.count.call(null,c__4351__auto___11672);
var G__11676 = (0);
seq__11500_11630 = G__11673;
chunk__11501_11631 = G__11674;
count__11502_11632 = G__11675;
i__11503_11633 = G__11676;
continue;
} else {
var vec__11515_11677 = cljs.core.first.call(null,seq__11500_11671__$1);
var column_11678 = cljs.core.nth.call(null,vec__11515_11677,(0),null);
var column_info_11679 = cljs.core.nth.call(null,vec__11515_11677,(1),null);
var seq__11518_11680 = cljs.core.seq.call(null,column_info_11679);
var chunk__11519_11681 = null;
var count__11520_11682 = (0);
var i__11521_11683 = (0);
while(true){
if((i__11521_11683 < count__11520_11682)){
var map__11522_11684 = cljs.core._nth.call(null,chunk__11519_11681,i__11521_11683);
var map__11522_11685__$1 = ((((!((map__11522_11684 == null)))?(((((map__11522_11684.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11522_11684.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11522_11684):map__11522_11684);
var gline_11686 = cljs.core.get.call(null,map__11522_11685__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_11687 = cljs.core.get.call(null,map__11522_11685__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_11688 = cljs.core.get.call(null,map__11522_11685__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_11686], null),cljs.core.fnil.call(null,((function (seq__11518_11680,chunk__11519_11681,count__11520_11682,i__11521_11683,seq__11500_11630,chunk__11501_11631,count__11502_11632,i__11503_11633,seq__11464_11526,chunk__11465_11527,count__11466_11528,i__11467_11529,map__11522_11684,map__11522_11685__$1,gline_11686,gcol_11687,name_11688,vec__11515_11677,column_11678,column_info_11679,seq__11500_11671__$1,temp__5457__auto___11670__$1,vec__11497_11627,line_11628,columns_11629,seq__11464_11621__$1,temp__5457__auto___11620,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_11687], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_11628,new cljs.core.Keyword(null,"col","col",-1959363084),column_11678,new cljs.core.Keyword(null,"name","name",1843675177),name_11688], null));
});})(seq__11518_11680,chunk__11519_11681,count__11520_11682,i__11521_11683,seq__11500_11630,chunk__11501_11631,count__11502_11632,i__11503_11633,seq__11464_11526,chunk__11465_11527,count__11466_11528,i__11467_11529,map__11522_11684,map__11522_11685__$1,gline_11686,gcol_11687,name_11688,vec__11515_11677,column_11678,column_info_11679,seq__11500_11671__$1,temp__5457__auto___11670__$1,vec__11497_11627,line_11628,columns_11629,seq__11464_11621__$1,temp__5457__auto___11620,inverted))
,cljs.core.sorted_map.call(null)));


var G__11689 = seq__11518_11680;
var G__11690 = chunk__11519_11681;
var G__11691 = count__11520_11682;
var G__11692 = (i__11521_11683 + (1));
seq__11518_11680 = G__11689;
chunk__11519_11681 = G__11690;
count__11520_11682 = G__11691;
i__11521_11683 = G__11692;
continue;
} else {
var temp__5457__auto___11693__$2 = cljs.core.seq.call(null,seq__11518_11680);
if(temp__5457__auto___11693__$2){
var seq__11518_11694__$1 = temp__5457__auto___11693__$2;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11518_11694__$1)){
var c__4351__auto___11695 = cljs.core.chunk_first.call(null,seq__11518_11694__$1);
var G__11696 = cljs.core.chunk_rest.call(null,seq__11518_11694__$1);
var G__11697 = c__4351__auto___11695;
var G__11698 = cljs.core.count.call(null,c__4351__auto___11695);
var G__11699 = (0);
seq__11518_11680 = G__11696;
chunk__11519_11681 = G__11697;
count__11520_11682 = G__11698;
i__11521_11683 = G__11699;
continue;
} else {
var map__11524_11700 = cljs.core.first.call(null,seq__11518_11694__$1);
var map__11524_11701__$1 = ((((!((map__11524_11700 == null)))?(((((map__11524_11700.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11524_11700.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11524_11700):map__11524_11700);
var gline_11702 = cljs.core.get.call(null,map__11524_11701__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_11703 = cljs.core.get.call(null,map__11524_11701__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_11704 = cljs.core.get.call(null,map__11524_11701__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_11702], null),cljs.core.fnil.call(null,((function (seq__11518_11680,chunk__11519_11681,count__11520_11682,i__11521_11683,seq__11500_11630,chunk__11501_11631,count__11502_11632,i__11503_11633,seq__11464_11526,chunk__11465_11527,count__11466_11528,i__11467_11529,map__11524_11700,map__11524_11701__$1,gline_11702,gcol_11703,name_11704,seq__11518_11694__$1,temp__5457__auto___11693__$2,vec__11515_11677,column_11678,column_info_11679,seq__11500_11671__$1,temp__5457__auto___11670__$1,vec__11497_11627,line_11628,columns_11629,seq__11464_11621__$1,temp__5457__auto___11620,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_11703], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_11628,new cljs.core.Keyword(null,"col","col",-1959363084),column_11678,new cljs.core.Keyword(null,"name","name",1843675177),name_11704], null));
});})(seq__11518_11680,chunk__11519_11681,count__11520_11682,i__11521_11683,seq__11500_11630,chunk__11501_11631,count__11502_11632,i__11503_11633,seq__11464_11526,chunk__11465_11527,count__11466_11528,i__11467_11529,map__11524_11700,map__11524_11701__$1,gline_11702,gcol_11703,name_11704,seq__11518_11694__$1,temp__5457__auto___11693__$2,vec__11515_11677,column_11678,column_info_11679,seq__11500_11671__$1,temp__5457__auto___11670__$1,vec__11497_11627,line_11628,columns_11629,seq__11464_11621__$1,temp__5457__auto___11620,inverted))
,cljs.core.sorted_map.call(null)));


var G__11705 = cljs.core.next.call(null,seq__11518_11694__$1);
var G__11706 = null;
var G__11707 = (0);
var G__11708 = (0);
seq__11518_11680 = G__11705;
chunk__11519_11681 = G__11706;
count__11520_11682 = G__11707;
i__11521_11683 = G__11708;
continue;
}
} else {
}
}
break;
}


var G__11709 = cljs.core.next.call(null,seq__11500_11671__$1);
var G__11710 = null;
var G__11711 = (0);
var G__11712 = (0);
seq__11500_11630 = G__11709;
chunk__11501_11631 = G__11710;
count__11502_11632 = G__11711;
i__11503_11633 = G__11712;
continue;
}
} else {
}
}
break;
}


var G__11713 = cljs.core.next.call(null,seq__11464_11621__$1);
var G__11714 = null;
var G__11715 = (0);
var G__11716 = (0);
seq__11464_11526 = G__11713;
chunk__11465_11527 = G__11714;
count__11466_11528 = G__11715;
i__11467_11529 = G__11716;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref.call(null,inverted);
});

//# sourceMappingURL=source_map.js.map
