// Compiled by ClojureScript 1.10.238 {}
goog.provide('active.clojure.config');
goog.require('cljs.core');
goog.require('active.clojure.condition');
goog.require('clojure.set');
goog.require('active.clojure.cljs.record');





/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
active.clojure.config.ValueRange = (function (description,completer,reduce,diff,__meta,__extmap,__hash){
this.description = description;
this.completer = completer;
this.reduce = reduce;
this.diff = diff;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
active.clojure.config.ValueRange.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__14195__auto__,k__14196__auto__){
var self__ = this;
var this__14195__auto____$1 = this;
return this__14195__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__14196__auto__,null);
});

active.clojure.config.ValueRange.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__14197__auto__,k14352,else__14198__auto__){
var self__ = this;
var this__14197__auto____$1 = this;
var G__14356 = k14352;
var G__14356__$1 = (((G__14356 instanceof cljs.core.Keyword))?G__14356.fqn:null);
switch (G__14356__$1) {
case "description":
return self__.description;

break;
case "completer":
return self__.completer;

break;
case "reduce":
return self__.reduce;

break;
case "diff":
return self__.diff;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k14352,else__14198__auto__);

}
});

active.clojure.config.ValueRange.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__14205__auto__,writer__14206__auto__,opts__14207__auto__){
var self__ = this;
var this__14205__auto____$1 = this;
var pr_pair__14208__auto__ = ((function (this__14205__auto____$1){
return (function (keyval__14209__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__14206__auto__,cljs.core.pr_writer,""," ","",opts__14207__auto__,keyval__14209__auto__);
});})(this__14205__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__14206__auto__,pr_pair__14208__auto__,"#active.clojure.config.ValueRange{",", ","}",opts__14207__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"description","description",-1428560544),self__.description],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"completer","completer",-1402861773),self__.completer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"reduce","reduce",-281692167),self__.reduce],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"diff","diff",2135942783),self__.diff],null))], null),self__.__extmap));
});

active.clojure.config.ValueRange.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__14351){
var self__ = this;
var G__14351__$1 = this;
return (new cljs.core.RecordIter((0),G__14351__$1,4,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.Keyword(null,"completer","completer",-1402861773),new cljs.core.Keyword(null,"reduce","reduce",-281692167),new cljs.core.Keyword(null,"diff","diff",2135942783)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

active.clojure.config.ValueRange.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__14193__auto__){
var self__ = this;
var this__14193__auto____$1 = this;
return self__.__meta;
});

active.clojure.config.ValueRange.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__14190__auto__){
var self__ = this;
var this__14190__auto____$1 = this;
return (new active.clojure.config.ValueRange(self__.description,self__.completer,self__.reduce,self__.diff,self__.__meta,self__.__extmap,self__.__hash));
});

active.clojure.config.ValueRange.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__14199__auto__){
var self__ = this;
var this__14199__auto____$1 = this;
return (4 + cljs.core.count.call(null,self__.__extmap));
});

active.clojure.config.ValueRange.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__14191__auto__){
var self__ = this;
var this__14191__auto____$1 = this;
var h__4030__auto__ = self__.__hash;
if(!((h__4030__auto__ == null))){
return h__4030__auto__;
} else {
var h__4030__auto____$1 = ((function (h__4030__auto__,this__14191__auto____$1){
return (function (coll__14192__auto__){
return (-1447145930 ^ cljs.core.hash_unordered_coll.call(null,coll__14192__auto__));
});})(h__4030__auto__,this__14191__auto____$1))
.call(null,this__14191__auto____$1);
self__.__hash = h__4030__auto____$1;

return h__4030__auto____$1;
}
});

active.clojure.config.ValueRange.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this14353,other14354){
var self__ = this;
var this14353__$1 = this;
return ((!((other14354 == null))) && ((this14353__$1.constructor === other14354.constructor)) && (cljs.core._EQ_.call(null,this14353__$1.description,other14354.description)) && (cljs.core._EQ_.call(null,this14353__$1.completer,other14354.completer)) && (cljs.core._EQ_.call(null,this14353__$1.reduce,other14354.reduce)) && (cljs.core._EQ_.call(null,this14353__$1.diff,other14354.diff)) && (cljs.core._EQ_.call(null,this14353__$1.__extmap,other14354.__extmap)));
});

active.clojure.config.ValueRange.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__14188__auto__,k__14189__auto__){
var self__ = this;
var this__14188__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"description","description",-1428560544),null,new cljs.core.Keyword(null,"completer","completer",-1402861773),null,new cljs.core.Keyword(null,"reduce","reduce",-281692167),null,new cljs.core.Keyword(null,"diff","diff",2135942783),null], null), null),k__14189__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__14188__auto____$1),self__.__meta),k__14189__auto__);
} else {
return (new active.clojure.config.ValueRange(self__.description,self__.completer,self__.reduce,self__.diff,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__14189__auto__)),null));
}
});

active.clojure.config.ValueRange.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__14186__auto__,k__14187__auto__,G__14351){
var self__ = this;
var this__14186__auto____$1 = this;
var pred__14357 = cljs.core.keyword_identical_QMARK_;
var expr__14358 = k__14187__auto__;
if(cljs.core.truth_(pred__14357.call(null,new cljs.core.Keyword(null,"description","description",-1428560544),expr__14358))){
return (new active.clojure.config.ValueRange(G__14351,self__.completer,self__.reduce,self__.diff,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__14357.call(null,new cljs.core.Keyword(null,"completer","completer",-1402861773),expr__14358))){
return (new active.clojure.config.ValueRange(self__.description,G__14351,self__.reduce,self__.diff,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__14357.call(null,new cljs.core.Keyword(null,"reduce","reduce",-281692167),expr__14358))){
return (new active.clojure.config.ValueRange(self__.description,self__.completer,G__14351,self__.diff,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__14357.call(null,new cljs.core.Keyword(null,"diff","diff",2135942783),expr__14358))){
return (new active.clojure.config.ValueRange(self__.description,self__.completer,self__.reduce,G__14351,self__.__meta,self__.__extmap,null));
} else {
return (new active.clojure.config.ValueRange(self__.description,self__.completer,self__.reduce,self__.diff,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__14187__auto__,G__14351),null));
}
}
}
}
});

active.clojure.config.ValueRange.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__14203__auto__){
var self__ = this;
var this__14203__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"description","description",-1428560544),self__.description],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"completer","completer",-1402861773),self__.completer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"reduce","reduce",-281692167),self__.reduce],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"diff","diff",2135942783),self__.diff],null))], null),self__.__extmap));
});

active.clojure.config.ValueRange.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__14194__auto__,G__14351){
var self__ = this;
var this__14194__auto____$1 = this;
return (new active.clojure.config.ValueRange(self__.description,self__.completer,self__.reduce,self__.diff,G__14351,self__.__extmap,self__.__hash));
});

active.clojure.config.ValueRange.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__14200__auto__,entry__14201__auto__){
var self__ = this;
var this__14200__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__14201__auto__)){
return this__14200__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__14201__auto__,(0)),cljs.core._nth.call(null,entry__14201__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__14200__auto____$1,entry__14201__auto__);
}
});

active.clojure.config.ValueRange.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"description","description",211970983,null),new cljs.core.Symbol(null,"completer","completer",237669754,null),new cljs.core.Symbol(null,"reduce","reduce",1358839360,null),new cljs.core.Symbol(null,"diff","diff",-518492986,null)], null);
});

active.clojure.config.ValueRange.cljs$lang$type = true;

active.clojure.config.ValueRange.cljs$lang$ctorPrSeq = (function (this__14281__auto__){
return (new cljs.core.List(null,"active.clojure.config/ValueRange",null,(1),null));
});

active.clojure.config.ValueRange.cljs$lang$ctorPrWriter = (function (this__14281__auto__,writer__14282__auto__){
return cljs.core._write.call(null,writer__14282__auto__,"active.clojure.config/ValueRange");
});

if(cljs.core._EQ_.call(null,false,new cljs.core.Keyword(null,"arrow-constructor?","arrow-constructor?",-1068727936).cljs$core$IFn$_invoke$arity$1(null))){
} else {
/**
 * Description of a range of values.
 */
active.clojure.config.__GT_ValueRange = (function active$clojure$config$__GT_ValueRange(description,completer,reduce,diff){
return (new active.clojure.config.ValueRange(description,completer,reduce,diff,null,null,null));
});
}

/**
 * Description of a range of values.
 */
active.clojure.config.map__GT_ValueRange = (function active$clojure$config$map__GT_ValueRange(G__14355){
return (new active.clojure.config.ValueRange(new cljs.core.Keyword(null,"description","description",-1428560544).cljs$core$IFn$_invoke$arity$1(G__14355),new cljs.core.Keyword(null,"completer","completer",-1402861773).cljs$core$IFn$_invoke$arity$1(G__14355),new cljs.core.Keyword(null,"reduce","reduce",-281692167).cljs$core$IFn$_invoke$arity$1(G__14355),new cljs.core.Keyword(null,"diff","diff",2135942783).cljs$core$IFn$_invoke$arity$1(G__14355),null,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,G__14355,new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.Keyword(null,"completer","completer",-1402861773),new cljs.core.Keyword(null,"reduce","reduce",-281692167),new cljs.core.Keyword(null,"diff","diff",2135942783))),null));
});

/**
 * Is object a `ValueRange` record? See [[active.clojure.config/really-make-range]].
 */
active.clojure.config.range_QMARK_ = (function active$clojure$config$range_QMARK_(x__14283__auto__){
return (x__14283__auto__ instanceof active.clojure.config.ValueRange);
});

/**
 * Make a [[Range]] range object.
 *   - `description' is a human-readable string
 *   - `completer' is a function that accepts a range, a key, and a value,
 *   and either returns a "completed" value that takes defaults etc. into account,
 *   or a [[RangeError]] object.
 *   - `reduce` is a function accepting a range, a key, a function, an initial result,
 *   and a value, reducing collection values similar to clojure [[reduce]], calling
 *   `(f range key res v)` on all scalar values.
 *   - `diff` is a function accepting two values that returns a sequence of `[path v1 v2]`, see
 *  diff functions below
 */
active.clojure.config.really_make_range = (function active$clojure$config$really_make_range(description,completer,reduce,diff){
return (new active.clojure.config.ValueRange(description,completer,reduce,diff,null,null,null));
});





/**
 * Lens for the `description` field from a [[ValueRange]] record. See [[active.clojure.config/really-make-range]].
 */
active.clojure.config.range_description = active.clojure.lens.lens.call(null,(function (rec__14262__auto__){
if((rec__14262__auto__ instanceof active.clojure.config.ValueRange)){
} else {
throw (new Error("Wrong record type (rec__14262__auto__) passed to accessor (range-description)."));
}

return rec__14262__auto__.description;
}),(function (data__14263__auto__,v__14264__auto__){
return (new active.clojure.config.ValueRange(v__14264__auto__,active.clojure.config.range_completer.call(null,data__14263__auto__),active.clojure.config.range_reduce.call(null,data__14263__auto__),active.clojure.config.range_diff.call(null,data__14263__auto__),null,null,null));
}));


/**
 * Lens for the `completer` field from a [[ValueRange]] record. See [[active.clojure.config/really-make-range]].
 */
active.clojure.config.range_completer = active.clojure.lens.lens.call(null,(function (rec__14262__auto__){
if((rec__14262__auto__ instanceof active.clojure.config.ValueRange)){
} else {
throw (new Error("Wrong record type (rec__14262__auto__) passed to accessor (range-completer)."));
}

return rec__14262__auto__.completer;
}),(function (data__14263__auto__,v__14264__auto__){
return (new active.clojure.config.ValueRange(active.clojure.config.range_description.call(null,data__14263__auto__),v__14264__auto__,active.clojure.config.range_reduce.call(null,data__14263__auto__),active.clojure.config.range_diff.call(null,data__14263__auto__),null,null,null));
}));


/**
 * Lens for the `reduce` field from a [[ValueRange]] record. See [[active.clojure.config/really-make-range]].
 */
active.clojure.config.range_reduce = active.clojure.lens.lens.call(null,(function (rec__14262__auto__){
if((rec__14262__auto__ instanceof active.clojure.config.ValueRange)){
} else {
throw (new Error("Wrong record type (rec__14262__auto__) passed to accessor (range-reduce)."));
}

return rec__14262__auto__.reduce;
}),(function (data__14263__auto__,v__14264__auto__){
return (new active.clojure.config.ValueRange(active.clojure.config.range_description.call(null,data__14263__auto__),active.clojure.config.range_completer.call(null,data__14263__auto__),v__14264__auto__,active.clojure.config.range_diff.call(null,data__14263__auto__),null,null,null));
}));


/**
 * Lens for the `diff` field from a [[ValueRange]] record. See [[active.clojure.config/really-make-range]].
 */
active.clojure.config.range_diff = active.clojure.lens.lens.call(null,(function (rec__14262__auto__){
if((rec__14262__auto__ instanceof active.clojure.config.ValueRange)){
} else {
throw (new Error("Wrong record type (rec__14262__auto__) passed to accessor (range-diff)."));
}

return rec__14262__auto__.diff;
}),(function (data__14263__auto__,v__14264__auto__){
return (new active.clojure.config.ValueRange(active.clojure.config.range_description.call(null,data__14263__auto__),active.clojure.config.range_completer.call(null,data__14263__auto__),active.clojure.config.range_reduce.call(null,data__14263__auto__),v__14264__auto__,null,null,null));
}));



active.clojure.config.make_range = (function active$clojure$config$make_range(var_args){
var G__14362 = arguments.length;
switch (G__14362) {
case 3:
return active.clojure.config.make_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return active.clojure.config.make_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

active.clojure.config.make_range.cljs$core$IFn$_invoke$arity$3 = (function (description,completer,reduce){
return active.clojure.config.make_range.call(null,description,completer,reduce,(function (a,b){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,a,b], null)], null);
}));
});

active.clojure.config.make_range.cljs$core$IFn$_invoke$arity$4 = (function (description,completer,reduce,diff){
return active.clojure.config.really_make_range.call(null,description,completer,reduce,diff);
});

active.clojure.config.make_range.cljs$lang$maxFixedArity = 4;





/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
active.clojure.config.RangeError = (function (range,path,value,__meta,__extmap,__hash){
this.range = range;
this.path = path;
this.value = value;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
active.clojure.config.RangeError.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__14195__auto__,k__14196__auto__){
var self__ = this;
var this__14195__auto____$1 = this;
return this__14195__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__14196__auto__,null);
});

active.clojure.config.RangeError.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__14197__auto__,k14365,else__14198__auto__){
var self__ = this;
var this__14197__auto____$1 = this;
var G__14369 = k14365;
var G__14369__$1 = (((G__14369 instanceof cljs.core.Keyword))?G__14369.fqn:null);
switch (G__14369__$1) {
case "range":
return self__.range;

break;
case "path":
return self__.path;

break;
case "value":
return self__.value;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k14365,else__14198__auto__);

}
});

active.clojure.config.RangeError.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__14205__auto__,writer__14206__auto__,opts__14207__auto__){
var self__ = this;
var this__14205__auto____$1 = this;
var pr_pair__14208__auto__ = ((function (this__14205__auto____$1){
return (function (keyval__14209__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__14206__auto__,cljs.core.pr_writer,""," ","",opts__14207__auto__,keyval__14209__auto__);
});})(this__14205__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__14206__auto__,pr_pair__14208__auto__,"#active.clojure.config.RangeError{",", ","}",opts__14207__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"range","range",1639692286),self__.range],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"path","path",-188191168),self__.path],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"value","value",305978217),self__.value],null))], null),self__.__extmap));
});

active.clojure.config.RangeError.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__14364){
var self__ = this;
var G__14364__$1 = this;
return (new cljs.core.RecordIter((0),G__14364__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"range","range",1639692286),new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.Keyword(null,"value","value",305978217)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

active.clojure.config.RangeError.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__14193__auto__){
var self__ = this;
var this__14193__auto____$1 = this;
return self__.__meta;
});

active.clojure.config.RangeError.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__14190__auto__){
var self__ = this;
var this__14190__auto____$1 = this;
return (new active.clojure.config.RangeError(self__.range,self__.path,self__.value,self__.__meta,self__.__extmap,self__.__hash));
});

active.clojure.config.RangeError.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__14199__auto__){
var self__ = this;
var this__14199__auto____$1 = this;
return (3 + cljs.core.count.call(null,self__.__extmap));
});

active.clojure.config.RangeError.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__14191__auto__){
var self__ = this;
var this__14191__auto____$1 = this;
var h__4030__auto__ = self__.__hash;
if(!((h__4030__auto__ == null))){
return h__4030__auto__;
} else {
var h__4030__auto____$1 = ((function (h__4030__auto__,this__14191__auto____$1){
return (function (coll__14192__auto__){
return (-40616897 ^ cljs.core.hash_unordered_coll.call(null,coll__14192__auto__));
});})(h__4030__auto__,this__14191__auto____$1))
.call(null,this__14191__auto____$1);
self__.__hash = h__4030__auto____$1;

return h__4030__auto____$1;
}
});

active.clojure.config.RangeError.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this14366,other14367){
var self__ = this;
var this14366__$1 = this;
return ((!((other14367 == null))) && ((this14366__$1.constructor === other14367.constructor)) && (cljs.core._EQ_.call(null,this14366__$1.range,other14367.range)) && (cljs.core._EQ_.call(null,this14366__$1.path,other14367.path)) && (cljs.core._EQ_.call(null,this14366__$1.value,other14367.value)) && (cljs.core._EQ_.call(null,this14366__$1.__extmap,other14367.__extmap)));
});

active.clojure.config.RangeError.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__14188__auto__,k__14189__auto__){
var self__ = this;
var this__14188__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"path","path",-188191168),null,new cljs.core.Keyword(null,"value","value",305978217),null,new cljs.core.Keyword(null,"range","range",1639692286),null], null), null),k__14189__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__14188__auto____$1),self__.__meta),k__14189__auto__);
} else {
return (new active.clojure.config.RangeError(self__.range,self__.path,self__.value,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__14189__auto__)),null));
}
});

active.clojure.config.RangeError.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__14186__auto__,k__14187__auto__,G__14364){
var self__ = this;
var this__14186__auto____$1 = this;
var pred__14370 = cljs.core.keyword_identical_QMARK_;
var expr__14371 = k__14187__auto__;
if(cljs.core.truth_(pred__14370.call(null,new cljs.core.Keyword(null,"range","range",1639692286),expr__14371))){
return (new active.clojure.config.RangeError(G__14364,self__.path,self__.value,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__14370.call(null,new cljs.core.Keyword(null,"path","path",-188191168),expr__14371))){
return (new active.clojure.config.RangeError(self__.range,G__14364,self__.value,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__14370.call(null,new cljs.core.Keyword(null,"value","value",305978217),expr__14371))){
return (new active.clojure.config.RangeError(self__.range,self__.path,G__14364,self__.__meta,self__.__extmap,null));
} else {
return (new active.clojure.config.RangeError(self__.range,self__.path,self__.value,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__14187__auto__,G__14364),null));
}
}
}
});

active.clojure.config.RangeError.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__14203__auto__){
var self__ = this;
var this__14203__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"range","range",1639692286),self__.range],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"path","path",-188191168),self__.path],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"value","value",305978217),self__.value],null))], null),self__.__extmap));
});

active.clojure.config.RangeError.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__14194__auto__,G__14364){
var self__ = this;
var this__14194__auto____$1 = this;
return (new active.clojure.config.RangeError(self__.range,self__.path,self__.value,G__14364,self__.__extmap,self__.__hash));
});

active.clojure.config.RangeError.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__14200__auto__,entry__14201__auto__){
var self__ = this;
var this__14200__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__14201__auto__)){
return this__14200__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__14201__auto__,(0)),cljs.core._nth.call(null,entry__14201__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__14200__auto____$1,entry__14201__auto__);
}
});

active.clojure.config.RangeError.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"range","range",-1014743483,null),new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"value","value",1946509744,null)], null);
});

active.clojure.config.RangeError.cljs$lang$type = true;

active.clojure.config.RangeError.cljs$lang$ctorPrSeq = (function (this__14281__auto__){
return (new cljs.core.List(null,"active.clojure.config/RangeError",null,(1),null));
});

active.clojure.config.RangeError.cljs$lang$ctorPrWriter = (function (this__14281__auto__,writer__14282__auto__){
return cljs.core._write.call(null,writer__14282__auto__,"active.clojure.config/RangeError");
});

if(cljs.core._EQ_.call(null,false,new cljs.core.Keyword(null,"arrow-constructor?","arrow-constructor?",-1068727936).cljs$core$IFn$_invoke$arity$1(null))){
} else {
/**
 * Description of an error that occurred during range checking
 */
active.clojure.config.__GT_RangeError = (function active$clojure$config$__GT_RangeError(range,path,value){
return (new active.clojure.config.RangeError(range,path,value,null,null,null));
});
}

/**
 * Description of an error that occurred during range checking
 */
active.clojure.config.map__GT_RangeError = (function active$clojure$config$map__GT_RangeError(G__14368){
return (new active.clojure.config.RangeError(new cljs.core.Keyword(null,"range","range",1639692286).cljs$core$IFn$_invoke$arity$1(G__14368),new cljs.core.Keyword(null,"path","path",-188191168).cljs$core$IFn$_invoke$arity$1(G__14368),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(G__14368),null,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,G__14368,new cljs.core.Keyword(null,"range","range",1639692286),new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.Keyword(null,"value","value",305978217))),null));
});

/**
 * Is object a `RangeError` record? See [[active.clojure.config/make-range-error]].
 */
active.clojure.config.range_error_QMARK_ = (function active$clojure$config$range_error_QMARK_(x__14283__auto__){
return (x__14283__auto__ instanceof active.clojure.config.RangeError);
});

/**
 * Make a a [[RangeError]] object describing an error from range checking.
 *   - `range` is the range that caused the error
 *   - `path` is the path in the configuration that describes where the error is.
 *   - `value` is the value that was wrong.
 * 
 *   `range` can be `nil' if `key` does not appear in the schema.
 */
active.clojure.config.make_range_error = (function active$clojure$config$make_range_error(range,path,value){
return (new active.clojure.config.RangeError(range,path,value,null,null,null));
});




/**
 * Lens for the `range` field from a [[RangeError]] record. See [[active.clojure.config/make-range-error]].
 */
active.clojure.config.range_error_range = active.clojure.lens.lens.call(null,(function (rec__14262__auto__){
if((rec__14262__auto__ instanceof active.clojure.config.RangeError)){
} else {
throw (new Error("Wrong record type (rec__14262__auto__) passed to accessor (range-error-range)."));
}

return rec__14262__auto__.range;
}),(function (data__14263__auto__,v__14264__auto__){
return (new active.clojure.config.RangeError(v__14264__auto__,active.clojure.config.range_error_path.call(null,data__14263__auto__),active.clojure.config.range_error_value.call(null,data__14263__auto__),null,null,null));
}));


/**
 * Lens for the `path` field from a [[RangeError]] record. See [[active.clojure.config/make-range-error]].
 */
active.clojure.config.range_error_path = active.clojure.lens.lens.call(null,(function (rec__14262__auto__){
if((rec__14262__auto__ instanceof active.clojure.config.RangeError)){
} else {
throw (new Error("Wrong record type (rec__14262__auto__) passed to accessor (range-error-path)."));
}

return rec__14262__auto__.path;
}),(function (data__14263__auto__,v__14264__auto__){
return (new active.clojure.config.RangeError(active.clojure.config.range_error_range.call(null,data__14263__auto__),v__14264__auto__,active.clojure.config.range_error_value.call(null,data__14263__auto__),null,null,null));
}));


/**
 * Lens for the `value` field from a [[RangeError]] record. See [[active.clojure.config/make-range-error]].
 */
active.clojure.config.range_error_value = active.clojure.lens.lens.call(null,(function (rec__14262__auto__){
if((rec__14262__auto__ instanceof active.clojure.config.RangeError)){
} else {
throw (new Error("Wrong record type (rec__14262__auto__) passed to accessor (range-error-value)."));
}

return rec__14262__auto__.value;
}),(function (data__14263__auto__,v__14264__auto__){
return (new active.clojure.config.RangeError(active.clojure.config.range_error_range.call(null,data__14263__auto__),active.clojure.config.range_error_path.call(null,data__14263__auto__),v__14264__auto__,null,null,null));
}));



active.clojure.config.scalar_range_reduce = (function active$clojure$config$scalar_range_reduce(completer){
return (function (range,path,f,res,val){
var v_SINGLEQUOTE_ = completer.call(null,range,path,val);
if(cljs.core.not.call(null,active.clojure.config.range_error_QMARK_.call(null,v_SINGLEQUOTE_))){
} else {
active.clojure.condition.assertion_violation.call(null,null,["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,v_SINGLEQUOTE_))].join(''),active.clojure.condition.make_location_condition.call(null,"active.clojure.config","/private/var/folders/fp/cxskw0351hv72t2yybts104w0000gn/T/form-init18044649893498323638.clj",93),cljs.core.list(new cljs.core.Symbol(null,"not","not",1044554643,null),cljs.core.list(new cljs.core.Symbol(null,"range-error?","range-error?",527793672,null),new cljs.core.Symbol(null,"v'","v'",572219448,null))));
}

return f.call(null,range,path,res,v_SINGLEQUOTE_);
});
});
/**
 * Make a range for unstructured, non-collection ranges.
 */
active.clojure.config.make_scalar_range = (function active$clojure$config$make_scalar_range(var_args){
var G__14375 = arguments.length;
switch (G__14375) {
case 2:
return active.clojure.config.make_scalar_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return active.clojure.config.make_scalar_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

active.clojure.config.make_scalar_range.cljs$core$IFn$_invoke$arity$2 = (function (description,completer){
return active.clojure.config.make_range.call(null,description,completer,active.clojure.config.scalar_range_reduce.call(null,completer));
});

active.clojure.config.make_scalar_range.cljs$core$IFn$_invoke$arity$3 = (function (description,completer,diff){
return active.clojure.config.make_range.call(null,description,completer,active.clojure.config.scalar_range_reduce.call(null,completer),diff);
});

active.clojure.config.make_scalar_range.cljs$lang$maxFixedArity = 3;

/**
 * Range for any value at all.
 */
active.clojure.config.any_value_range = (function active$clojure$config$any_value_range(dflt){
return active.clojure.config.make_scalar_range.call(null,"any value at all",(function (range,path,val){
if((val == null)){
return dflt;
} else {
return val;
}
}));
});
/**
 * Range for any non-nil value.
 */
active.clojure.config.non_nil_range = active.clojure.config.make_scalar_range.call(null,"non-nil value",(function (range,path,val){
if(!((val == null))){
return val;
} else {
return active.clojure.config.make_range_error.call(null,range,path,val);
}
}));
/**
 * Range specified by a simple predicate.
 */
active.clojure.config.predicate_range = (function active$clojure$config$predicate_range(desc,pred,dflt){
return active.clojure.config.make_scalar_range.call(null,desc,(function (range,path,val){
if((val == null)){
return dflt;
} else {
if(cljs.core.truth_(pred.call(null,val))){
return val;
} else {
return active.clojure.config.make_range_error.call(null,range,path,val);

}
}
}));
});
/**
 * Check if a value is a boolean.
 */
active.clojure.config.boolean_QMARK_ = (function active$clojure$config$boolean_QMARK_(x){
return ((cljs.core._EQ_.call(null,x,true)) || (cljs.core._EQ_.call(null,x,false)));
});
/**
 * Range for a boolean, with explicit default.
 */
active.clojure.config.boolean_range = (function active$clojure$config$boolean_range(dflt){
return active.clojure.config.predicate_range.call(null,"true or false",active.clojure.config.boolean_QMARK_,dflt);
});
/**
 * Range for something that may be in an underlying range or `nil`.
 */
active.clojure.config.optional_range = (function active$clojure$config$optional_range(range){
return active.clojure.config.make_range.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(active.clojure.config.range_description.call(null,range))," (optional)"].join(''),(function (this_range,path,val){
if((val == null)){
return null;
} else {
return active.clojure.config.range_completer.call(null,range).call(null,range,path,val);
}
}),(function (this_range,path,f,res,val){
if((val == null)){
return f.call(null,range,path,res,null);
} else {
return active.clojure.config.range_reduce.call(null,range).call(null,range,path,f,res,val);
}
}),(function (a,b){
return active.clojure.config.range_diff.call(null,range).call(null,a,b);
}));
});
/**
 * Range for something that may be in an underlying range. If it is nil, then `dflt` is used, which must be in the underlying range too.
 */
active.clojure.config.optional_default_range = (function active$clojure$config$optional_default_range(range,dflt){
return active.clojure.config.make_range.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(active.clojure.config.range_description.call(null,range))," (optional with default)"].join(''),(function (this_range,path,val){
return active.clojure.config.range_completer.call(null,range).call(null,range,path,(((val == null))?dflt:val));
}),(function (this_range,path,f,res,val){
return active.clojure.config.range_reduce.call(null,range).call(null,range,path,f,res,(((val == null))?dflt:val));
}),(function (a,b){
return active.clojure.config.range_diff.call(null,range).call(null,a,b);
}));
});
/**
 * Range for an integer from a specified range, with explicit default.
 */
active.clojure.config.integer_between_range = (function active$clojure$config$integer_between_range(min,max,dflt){
return active.clojure.config.make_scalar_range.call(null,["integer between ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(min)," and ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max)].join(''),(function (range,path,val){
if((val == null)){
return dflt;
} else {
if(((cljs.core.integer_QMARK_.call(null,val)) && ((val >= min)) && ((val <= max)))){
return val;
} else {
return active.clojure.config.make_range_error.call(null,range,path,val);

}
}
}));
});
active.clojure.config.keyword_range = active.clojure.config.make_scalar_range.call(null,"keyword",(function (range,path,val){
if((val instanceof cljs.core.Keyword)){
return val;
} else {
return active.clojure.config.make_range_error.call(null,range,path,val);
}
}));
active.clojure.config.default_string_range = (function active$clojure$config$default_string_range(dflt){

return active.clojure.config.make_scalar_range.call(null,"string",(function (range,path,val){
if((val == null)){
return dflt;
} else {
if(typeof val === 'string'){
return val;
} else {
return active.clojure.config.make_range_error.call(null,range,path,val);

}
}
}));
});
/**
 * Range for an abitrary string, default is empty string.
 */
active.clojure.config.string_range = active.clojure.config.default_string_range.call(null,"");
/**
 * Range for a non-empty string with optional max length.
 */
active.clojure.config.nonempty_string_range = (function active$clojure$config$nonempty_string_range(var_args){
var args__4502__auto__ = [];
var len__4499__auto___14382 = arguments.length;
var i__4500__auto___14383 = (0);
while(true){
if((i__4500__auto___14383 < len__4499__auto___14382)){
args__4502__auto__.push((arguments[i__4500__auto___14383]));

var G__14384 = (i__4500__auto___14383 + (1));
i__4500__auto___14383 = G__14384;
continue;
} else {
}
break;
}

var argseq__4503__auto__ = ((((0) < args__4502__auto__.length))?(new cljs.core.IndexedSeq(args__4502__auto__.slice((0)),(0),null)):null);
return active.clojure.config.nonempty_string_range.cljs$core$IFn$_invoke$arity$variadic(argseq__4503__auto__);
});

active.clojure.config.nonempty_string_range.cljs$core$IFn$_invoke$arity$variadic = (function (p__14378){
var vec__14379 = p__14378;
var max_length = cljs.core.nth.call(null,vec__14379,(0),null);
return active.clojure.config.make_scalar_range.call(null,["non-empty string",cljs.core.str.cljs$core$IFn$_invoke$arity$1(((!((max_length == null)))?[" with maximum length of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_length)].join(''):""))].join(''),((function (vec__14379,max_length){
return (function (range,path,val){
if((function (){var and__3911__auto__ = typeof val === 'string';
if(and__3911__auto__){
var and__3911__auto____$1 = !(cljs.core.empty_QMARK_.call(null,val));
if(and__3911__auto____$1){
if(!((max_length == null))){
return (cljs.core.count.call(null,val) <= max_length);
} else {
return true;
}
} else {
return and__3911__auto____$1;
}
} else {
return and__3911__auto__;
}
})()){
return val;
} else {
return active.clojure.config.make_range_error.call(null,range,path,val);
}
});})(vec__14379,max_length))
);
});

active.clojure.config.nonempty_string_range.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
active.clojure.config.nonempty_string_range.cljs$lang$applyTo = (function (seq14377){
var self__4487__auto__ = this;
return self__4487__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq14377));
});

active.clojure.config.max_string_range = (function active$clojure$config$max_string_range(max_length){

return active.clojure.config.make_scalar_range.call(null,["Arbitrary string with maximum length of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_length)].join(''),(function (range,path,val){
if(((typeof val === 'string') && ((cljs.core.count.call(null,val) <= max_length)))){
return val;
} else {
return active.clojure.config.make_range_error.call(null,range,path,val);
}
}));
});
/**
 * Range that satisfies one of the ranges, tried from left to right.
 */
active.clojure.config.any_range = (function active$clojure$config$any_range(var_args){
var args__4502__auto__ = [];
var len__4499__auto___14387 = arguments.length;
var i__4500__auto___14388 = (0);
while(true){
if((i__4500__auto___14388 < len__4499__auto___14387)){
args__4502__auto__.push((arguments[i__4500__auto___14388]));

var G__14389 = (i__4500__auto___14388 + (1));
i__4500__auto___14388 = G__14389;
continue;
} else {
}
break;
}

var argseq__4503__auto__ = ((((0) < args__4502__auto__.length))?(new cljs.core.IndexedSeq(args__4502__auto__.slice((0)),(0),null)):null);
return active.clojure.config.any_range.cljs$core$IFn$_invoke$arity$variadic(argseq__4503__auto__);
});

active.clojure.config.any_range.cljs$core$IFn$_invoke$arity$variadic = (function (rs){
return active.clojure.config.make_range.call(null,cljs.core.apply.call(null,cljs.core.str,"any:",cljs.core.map.call(null,(function (p1__14385_SHARP_){
return [" <",cljs.core.str.cljs$core$IFn$_invoke$arity$1(active.clojure.config.range_description.call(null,p1__14385_SHARP_)),">"].join('');
}),rs)),(function (range,path,val){
var rs__$1 = rs;
while(true){
if(cljs.core.empty_QMARK_.call(null,rs__$1)){
return active.clojure.config.make_range_error.call(null,range,path,val);
} else {
var res = active.clojure.config.range_completer.call(null,cljs.core.first.call(null,rs__$1)).call(null,cljs.core.first.call(null,rs__$1),path,val);
if(cljs.core.truth_(active.clojure.config.range_error_QMARK_.call(null,res))){
var G__14390 = cljs.core.rest.call(null,rs__$1);
rs__$1 = G__14390;
continue;
} else {
return res;
}
}
break;
}
}),(function (range,path,f,res,val){
var rs__$1 = rs;
while(true){
if(cljs.core.empty_QMARK_.call(null,rs__$1)){
return active.clojure.condition.assertion_violation.call(null,null,["Assertion failed"].join(''),active.clojure.condition.make_location_condition.call(null,"active.clojure.config","/private/var/folders/fp/cxskw0351hv72t2yybts104w0000gn/T/form-init18044649893498323638.clj",245),false);

} else {
var this_range = cljs.core.first.call(null,rs__$1);
var v = active.clojure.config.range_completer.call(null,this_range).call(null,this_range,path,val);
if(cljs.core.truth_(active.clojure.config.range_error_QMARK_.call(null,v))){
var G__14391 = cljs.core.rest.call(null,rs__$1);
rs__$1 = G__14391;
continue;
} else {
return active.clojure.config.range_reduce.call(null,this_range).call(null,this_range,path,f,res,v);
}
}
break;
}
}));
});

active.clojure.config.any_range.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
active.clojure.config.any_range.cljs$lang$applyTo = (function (seq14386){
var self__4487__auto__ = this;
return self__4487__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq14386));
});

/**
 * Range for one of a set of values, with explicit default.
 */
active.clojure.config.one_of_range = (function active$clojure$config$one_of_range(vals,dflt){
return active.clojure.config.make_scalar_range.call(null,cljs.core.apply.call(null,cljs.core.str,"one of:",cljs.core.map.call(null,(function (p1__14392_SHARP_){
return [" ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__14392_SHARP_)].join('');
}),vals)),(function (){var s = cljs.core.set.call(null,vals);
return ((function (s){
return (function (range,path,val){
if((val == null)){
return dflt;
} else {
if(cljs.core.contains_QMARK_.call(null,s,val)){
return val;
} else {
return active.clojure.config.make_range_error.call(null,range,path,val);

}
}
});
;})(s))
})());
});
/**
 * Range for one of a set of values, with custom compare function,
 *   with explicit default.
 */
active.clojure.config.one_of_range_custom_compare = (function active$clojure$config$one_of_range_custom_compare(vals,dflt,compare_fn){
return active.clojure.config.make_scalar_range.call(null,cljs.core.apply.call(null,cljs.core.str,"one of:",cljs.core.map.call(null,(function (p1__14393_SHARP_){
return [" ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__14393_SHARP_)].join('');
}),vals)),(function (){var s = cljs.core.set.call(null,vals);
return ((function (s){
return (function (range,path,val){
if((val == null)){
return dflt;
} else {
if(cljs.core.truth_(cljs.core.some.call(null,((function (s){
return (function (p1__14394_SHARP_){
return compare_fn.call(null,val,p1__14394_SHARP_);
});})(s))
,s))){
return val;
} else {
return active.clojure.config.make_range_error.call(null,range,path,val);

}
}
});
;})(s))
})());
});
/**
 * Test if something can be coerced to a seq.
 */
active.clojure.config.sequable_QMARK_ = (function active$clojure$config$sequable_QMARK_(thing){
try{cljs.core.seq.call(null,thing);

return true;
}catch (e14395){if((e14395 instanceof Error)){
var e = e14395;
return false;
} else {
throw e14395;

}
}});
/**
 * Range for a sequence of values of an underlying range.
 */
active.clojure.config.sequence_of_range = (function active$clojure$config$sequence_of_range(range){
return active.clojure.config.make_range.call(null,["sequence of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(active.clojure.config.range_description.call(null,range))].join(''),(function (){var complete = active.clojure.config.range_completer.call(null,range);
return ((function (complete){
return (function (this_range,path,val){
if((val == null)){
return cljs.core.PersistentVector.EMPTY;
} else {
if(cljs.core.not.call(null,active.clojure.config.sequable_QMARK_.call(null,val))){
return active.clojure.config.make_range_error.call(null,this_range,path,val);
} else {
var i = (0);
var vals = cljs.core.seq.call(null,val);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if(vals){
var res = complete.call(null,range,cljs.core.conj.call(null,path,i),cljs.core.first.call(null,vals));
if(cljs.core.truth_(active.clojure.config.range_error_QMARK_.call(null,res))){
return res;
} else {
var G__14400 = (i + (1));
var G__14401 = cljs.core.next.call(null,vals);
var G__14402 = cljs.core.conj.call(null,ret,res);
i = G__14400;
vals = G__14401;
ret = G__14402;
continue;
}
} else {
return ret;
}
break;
}

}
}
});
;})(complete))
})(),(function (this_range,path,f,res,val){
var v = active.clojure.config.range_completer.call(null,this_range).call(null,this_range,path,val);
if(cljs.core.not.call(null,active.clojure.config.range_error_QMARK_.call(null,v))){
} else {
active.clojure.condition.assertion_violation.call(null,null,["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,v))].join(''),active.clojure.condition.make_location_condition.call(null,"active.clojure.config","/private/var/folders/fp/cxskw0351hv72t2yybts104w0000gn/T/form-init18044649893498323638.clj",316),cljs.core.list(new cljs.core.Symbol(null,"not","not",1044554643,null),cljs.core.list(new cljs.core.Symbol(null,"range-error?","range-error?",527793672,null),new cljs.core.Symbol(null,"v","v",1661996586,null))));
}

return cljs.core.reduce.call(null,((function (v){
return (function (res__$1,p__14396){
var vec__14397 = p__14396;
var i = cljs.core.nth.call(null,vec__14397,(0),null);
var x = cljs.core.nth.call(null,vec__14397,(1),null);
return active.clojure.config.range_reduce.call(null,range).call(null,range,cljs.core.conj.call(null,path,i),f,res__$1,x);
});})(v))
,res,cljs.core.map_indexed.call(null,cljs.core.vector,v));
}));
});
/**
 * Range constructed by transforming values matching an existing range.
 */
active.clojure.config.range_map = (function active$clojure$config$range_map(var_args){
var args__4502__auto__ = [];
var len__4499__auto___14407 = arguments.length;
var i__4500__auto___14408 = (0);
while(true){
if((i__4500__auto___14408 < len__4499__auto___14407)){
args__4502__auto__.push((arguments[i__4500__auto___14408]));

var G__14409 = (i__4500__auto___14408 + (1));
i__4500__auto___14408 = G__14409;
continue;
} else {
}
break;
}

var argseq__4503__auto__ = ((((3) < args__4502__auto__.length))?(new cljs.core.IndexedSeq(args__4502__auto__.slice((3)),(0),null)):null);
return active.clojure.config.range_map.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4503__auto__);
});

active.clojure.config.range_map.cljs$core$IFn$_invoke$arity$variadic = (function (descr,range,f,args){
return active.clojure.config.make_range.call(null,descr,(function (){var complete = active.clojure.config.range_completer.call(null,range);
return ((function (complete){
return (function (this_range,path,val){
var res = complete.call(null,this_range,path,val);
if(cljs.core.truth_(active.clojure.config.range_error_QMARK_.call(null,res))){
return res;
} else {
return cljs.core.apply.call(null,f,res,args);
}
});
;})(complete))
})(),active.clojure.config.range_reduce.call(null,range));
});

active.clojure.config.range_map.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
active.clojure.config.range_map.cljs$lang$applyTo = (function (seq14403){
var G__14404 = cljs.core.first.call(null,seq14403);
var seq14403__$1 = cljs.core.next.call(null,seq14403);
var G__14405 = cljs.core.first.call(null,seq14403__$1);
var seq14403__$2 = cljs.core.next.call(null,seq14403__$1);
var G__14406 = cljs.core.first.call(null,seq14403__$2);
var seq14403__$3 = cljs.core.next.call(null,seq14403__$2);
var self__4486__auto__ = this;
return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14404,G__14405,G__14406,seq14403__$3);
});

/**
 * Range for a set of values of an underlying range.
 */
active.clojure.config.set_of_range = (function active$clojure$config$set_of_range(range){
return active.clojure.config.range_map.call(null,["set of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(active.clojure.config.range_description.call(null,range))].join(''),active.clojure.config.sequence_of_range.call(null,range),cljs.core.set);
});
/**
 * Range for a sequence of mixed underlying ranges.
 */
active.clojure.config.tuple_of_range = (function active$clojure$config$tuple_of_range(var_args){
var args__4502__auto__ = [];
var len__4499__auto___14423 = arguments.length;
var i__4500__auto___14424 = (0);
while(true){
if((i__4500__auto___14424 < len__4499__auto___14423)){
args__4502__auto__.push((arguments[i__4500__auto___14424]));

var G__14425 = (i__4500__auto___14424 + (1));
i__4500__auto___14424 = G__14425;
continue;
} else {
}
break;
}

var argseq__4503__auto__ = ((((0) < args__4502__auto__.length))?(new cljs.core.IndexedSeq(args__4502__auto__.slice((0)),(0),null)):null);
return active.clojure.config.tuple_of_range.cljs$core$IFn$_invoke$arity$variadic(argseq__4503__auto__);
});

active.clojure.config.tuple_of_range.cljs$core$IFn$_invoke$arity$variadic = (function (rs){
return active.clojure.config.make_range.call(null,cljs.core.apply.call(null,cljs.core.str,"tuple of: ",cljs.core.interpose.call(null,", ",cljs.core.map.call(null,active.clojure.config.range_description,rs))),(function (this_range,path,val){
if(cljs.core.truth_(active.clojure.config.sequable_QMARK_.call(null,val))){
var res = cljs.core.map_indexed.call(null,(function (i,p__14412){
var vec__14413 = p__14412;
var v = cljs.core.nth.call(null,vec__14413,(0),null);
var range = cljs.core.nth.call(null,vec__14413,(1),null);
return active.clojure.config.range_completer.call(null,range).call(null,range,cljs.core.conj.call(null,path,i),v);
}),cljs.core.map.call(null,cljs.core.vector,cljs.core.seq.call(null,val),rs));
var or__3922__auto__ = cljs.core.some.call(null,((function (res){
return (function (p1__14410_SHARP_){
var and__3911__auto__ = active.clojure.config.range_error_QMARK_.call(null,p1__14410_SHARP_);
if(cljs.core.truth_(and__3911__auto__)){
return p1__14410_SHARP_;
} else {
return and__3911__auto__;
}
});})(res))
,res);
if(cljs.core.truth_(or__3922__auto__)){
return or__3922__auto__;
} else {
return cljs.core.vec.call(null,res);
}
} else {
return active.clojure.config.make_range_error.call(null,this_range,path,val);

}
}),(function (this_range,path,f,res,val){
var v = active.clojure.config.range_completer.call(null,this_range).call(null,this_range,path,val);
if(cljs.core.not.call(null,active.clojure.config.range_error_QMARK_.call(null,v))){
} else {
active.clojure.condition.assertion_violation.call(null,null,["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,v))].join(''),active.clojure.condition.make_location_condition.call(null,"active.clojure.config","/private/var/folders/fp/cxskw0351hv72t2yybts104w0000gn/T/form-init18044649893498323638.clj",361),cljs.core.list(new cljs.core.Symbol(null,"not","not",1044554643,null),cljs.core.list(new cljs.core.Symbol(null,"range-error?","range-error?",527793672,null),new cljs.core.Symbol(null,"v","v",1661996586,null))));
}

return cljs.core.reduce.call(null,((function (v){
return (function (res__$1,p__14416){
var vec__14417 = p__14416;
var i = cljs.core.nth.call(null,vec__14417,(0),null);
var vec__14420 = cljs.core.nth.call(null,vec__14417,(1),null);
var v__$1 = cljs.core.nth.call(null,vec__14420,(0),null);
var range = cljs.core.nth.call(null,vec__14420,(1),null);
return active.clojure.config.range_reduce.call(null,range).call(null,range,cljs.core.conj.call(null,path,i),f,res__$1,v__$1);
});})(v))
,res,cljs.core.map_indexed.call(null,cljs.core.vector,cljs.core.map.call(null,cljs.core.vector,v,rs)));
}));
});

active.clojure.config.tuple_of_range.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
active.clojure.config.tuple_of_range.cljs$lang$applyTo = (function (seq14411){
var self__4487__auto__ = this;
return self__4487__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq14411));
});

active.clojure.config.map_of_ranges_diff_fn = (function active$clojure$config$map_of_ranges_diff_fn(range){
return (function (a,b){
var keys_in_both = clojure.set.union.call(null,cljs.core.set.call(null,cljs.core.keys.call(null,a)),cljs.core.set.call(null,cljs.core.keys.call(null,b)));
return cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.mapcat.call(null,((function (keys_in_both){
return (function (k){
var v_a = cljs.core.get.call(null,a,k);
var v_b = cljs.core.get.call(null,b,k);
if(cljs.core.not_EQ_.call(null,v_a,v_b)){
return cljs.core.map.call(null,((function (v_a,v_b,keys_in_both){
return (function (p__14426){
var vec__14427 = p__14426;
var p_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__14427,(0),null);
var v1_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__14427,(1),null);
var v2_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__14427,(2),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),p_SINGLEQUOTE_),v1_SINGLEQUOTE_,v2_SINGLEQUOTE_], null);
});})(v_a,v_b,keys_in_both))
,active.clojure.config.range_diff.call(null,range).call(null,cljs.core.get.call(null,a,k),cljs.core.get.call(null,b,k)));
} else {
return null;
}
});})(keys_in_both))
,keys_in_both));
});
});
/**
 * Range for a map with keys and values of underlying ranges, respectively.
 */
active.clojure.config.map_of_range = (function active$clojure$config$map_of_range(key_range,val_range){
return active.clojure.config.make_range.call(null,["map from ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(active.clojure.config.range_description.call(null,key_range))," to ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(active.clojure.config.range_description.call(null,val_range))].join(''),(function (){var complete_val = active.clojure.config.range_completer.call(null,val_range);
var complete_key = active.clojure.config.range_completer.call(null,key_range);
return ((function (complete_val,complete_key){
return (function (this_range,ky,vl){
if((vl == null)){
return cljs.core.PersistentArrayMap.EMPTY;
} else {
if(cljs.core.map_QMARK_.call(null,vl)){
var kvs = cljs.core.seq.call(null,vl);
var ret = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(kvs){
var kv = cljs.core.first.call(null,kvs);
var p = cljs.core.conj.call(null,ky,cljs.core.key.call(null,kv));
var k = complete_key.call(null,key_range,p,cljs.core.key.call(null,kv));
var v = complete_val.call(null,val_range,p,cljs.core.val.call(null,kv));
if(cljs.core.truth_(active.clojure.config.range_error_QMARK_.call(null,k))){
return k;
} else {
if(cljs.core.truth_(active.clojure.config.range_error_QMARK_.call(null,v))){
return v;
} else {
var G__14434 = cljs.core.next.call(null,kvs);
var G__14435 = cljs.core.assoc.call(null,ret,k,v);
kvs = G__14434;
ret = G__14435;
continue;

}
}
} else {
return ret;
}
break;
}
} else {
return active.clojure.config.make_range_error.call(null,this_range,ky,vl);

}
}
});
;})(complete_val,complete_key))
})(),(function (this_range,path,f,res,val){
var v = active.clojure.config.range_completer.call(null,this_range).call(null,this_range,path,val);
if(cljs.core.not.call(null,active.clojure.config.range_error_QMARK_.call(null,v))){
} else {
active.clojure.condition.assertion_violation.call(null,null,["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,v))].join(''),active.clojure.condition.make_location_condition.call(null,"active.clojure.config","/private/var/folders/fp/cxskw0351hv72t2yybts104w0000gn/T/form-init18044649893498323638.clj",413),cljs.core.list(new cljs.core.Symbol(null,"not","not",1044554643,null),cljs.core.list(new cljs.core.Symbol(null,"range-error?","range-error?",527793672,null),new cljs.core.Symbol(null,"v","v",1661996586,null))));
}

return cljs.core.reduce.call(null,((function (v){
return (function (res__$1,p__14430){
var vec__14431 = p__14430;
var k = cljs.core.nth.call(null,vec__14431,(0),null);
var v__$1 = cljs.core.nth.call(null,vec__14431,(1),null);
return active.clojure.config.range_reduce.call(null,val_range).call(null,val_range,cljs.core.conj.call(null,path,k),f,active.clojure.config.range_reduce.call(null,key_range).call(null,key_range,path,f,res__$1,k),v__$1);
});})(v))
,res,v);
}),active.clojure.config.map_of_ranges_diff_fn.call(null,val_range));
});





/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
active.clojure.config.Setting = (function (key,description,range,inherit_QMARK_,__meta,__extmap,__hash){
this.key = key;
this.description = description;
this.range = range;
this.inherit_QMARK_ = inherit_QMARK_;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
active.clojure.config.Setting.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__14195__auto__,k__14196__auto__){
var self__ = this;
var this__14195__auto____$1 = this;
return this__14195__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__14196__auto__,null);
});

active.clojure.config.Setting.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__14197__auto__,k14437,else__14198__auto__){
var self__ = this;
var this__14197__auto____$1 = this;
var G__14441 = k14437;
var G__14441__$1 = (((G__14441 instanceof cljs.core.Keyword))?G__14441.fqn:null);
switch (G__14441__$1) {
case "key":
return self__.key;

break;
case "description":
return self__.description;

break;
case "range":
return self__.range;

break;
case "inherit?":
return self__.inherit_QMARK_;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k14437,else__14198__auto__);

}
});

active.clojure.config.Setting.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__14205__auto__,writer__14206__auto__,opts__14207__auto__){
var self__ = this;
var this__14205__auto____$1 = this;
var pr_pair__14208__auto__ = ((function (this__14205__auto____$1){
return (function (keyval__14209__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__14206__auto__,cljs.core.pr_writer,""," ","",opts__14207__auto__,keyval__14209__auto__);
});})(this__14205__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__14206__auto__,pr_pair__14208__auto__,"#active.clojure.config.Setting{",", ","}",opts__14207__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"key","key",-1516042587),self__.key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"description","description",-1428560544),self__.description],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"range","range",1639692286),self__.range],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"inherit?","inherit?",1253457936),self__.inherit_QMARK_],null))], null),self__.__extmap));
});

active.clojure.config.Setting.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__14436){
var self__ = this;
var G__14436__$1 = this;
return (new cljs.core.RecordIter((0),G__14436__$1,4,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"key","key",-1516042587),new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.Keyword(null,"range","range",1639692286),new cljs.core.Keyword(null,"inherit?","inherit?",1253457936)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

active.clojure.config.Setting.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__14193__auto__){
var self__ = this;
var this__14193__auto____$1 = this;
return self__.__meta;
});

active.clojure.config.Setting.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__14190__auto__){
var self__ = this;
var this__14190__auto____$1 = this;
return (new active.clojure.config.Setting(self__.key,self__.description,self__.range,self__.inherit_QMARK_,self__.__meta,self__.__extmap,self__.__hash));
});

active.clojure.config.Setting.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__14199__auto__){
var self__ = this;
var this__14199__auto____$1 = this;
return (4 + cljs.core.count.call(null,self__.__extmap));
});

active.clojure.config.Setting.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__14191__auto__){
var self__ = this;
var this__14191__auto____$1 = this;
var h__4030__auto__ = self__.__hash;
if(!((h__4030__auto__ == null))){
return h__4030__auto__;
} else {
var h__4030__auto____$1 = ((function (h__4030__auto__,this__14191__auto____$1){
return (function (coll__14192__auto__){
return (-867259672 ^ cljs.core.hash_unordered_coll.call(null,coll__14192__auto__));
});})(h__4030__auto__,this__14191__auto____$1))
.call(null,this__14191__auto____$1);
self__.__hash = h__4030__auto____$1;

return h__4030__auto____$1;
}
});

active.clojure.config.Setting.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this14438,other14439){
var self__ = this;
var this14438__$1 = this;
return ((!((other14439 == null))) && ((this14438__$1.constructor === other14439.constructor)) && (cljs.core._EQ_.call(null,this14438__$1.key,other14439.key)) && (cljs.core._EQ_.call(null,this14438__$1.description,other14439.description)) && (cljs.core._EQ_.call(null,this14438__$1.range,other14439.range)) && (cljs.core._EQ_.call(null,this14438__$1.inherit_QMARK_,other14439.inherit_QMARK_)) && (cljs.core._EQ_.call(null,this14438__$1.__extmap,other14439.__extmap)));
});

active.clojure.config.Setting.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__14188__auto__,k__14189__auto__){
var self__ = this;
var this__14188__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"description","description",-1428560544),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"inherit?","inherit?",1253457936),null,new cljs.core.Keyword(null,"range","range",1639692286),null], null), null),k__14189__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__14188__auto____$1),self__.__meta),k__14189__auto__);
} else {
return (new active.clojure.config.Setting(self__.key,self__.description,self__.range,self__.inherit_QMARK_,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__14189__auto__)),null));
}
});

active.clojure.config.Setting.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__14186__auto__,k__14187__auto__,G__14436){
var self__ = this;
var this__14186__auto____$1 = this;
var pred__14442 = cljs.core.keyword_identical_QMARK_;
var expr__14443 = k__14187__auto__;
if(cljs.core.truth_(pred__14442.call(null,new cljs.core.Keyword(null,"key","key",-1516042587),expr__14443))){
return (new active.clojure.config.Setting(G__14436,self__.description,self__.range,self__.inherit_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__14442.call(null,new cljs.core.Keyword(null,"description","description",-1428560544),expr__14443))){
return (new active.clojure.config.Setting(self__.key,G__14436,self__.range,self__.inherit_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__14442.call(null,new cljs.core.Keyword(null,"range","range",1639692286),expr__14443))){
return (new active.clojure.config.Setting(self__.key,self__.description,G__14436,self__.inherit_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__14442.call(null,new cljs.core.Keyword(null,"inherit?","inherit?",1253457936),expr__14443))){
return (new active.clojure.config.Setting(self__.key,self__.description,self__.range,G__14436,self__.__meta,self__.__extmap,null));
} else {
return (new active.clojure.config.Setting(self__.key,self__.description,self__.range,self__.inherit_QMARK_,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__14187__auto__,G__14436),null));
}
}
}
}
});

active.clojure.config.Setting.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__14203__auto__){
var self__ = this;
var this__14203__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"key","key",-1516042587),self__.key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"description","description",-1428560544),self__.description],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"range","range",1639692286),self__.range],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"inherit?","inherit?",1253457936),self__.inherit_QMARK_],null))], null),self__.__extmap));
});

active.clojure.config.Setting.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__14194__auto__,G__14436){
var self__ = this;
var this__14194__auto____$1 = this;
return (new active.clojure.config.Setting(self__.key,self__.description,self__.range,self__.inherit_QMARK_,G__14436,self__.__extmap,self__.__hash));
});

active.clojure.config.Setting.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__14200__auto__,entry__14201__auto__){
var self__ = this;
var this__14200__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__14201__auto__)){
return this__14200__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__14201__auto__,(0)),cljs.core._nth.call(null,entry__14201__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__14200__auto____$1,entry__14201__auto__);
}
});

active.clojure.config.Setting.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"description","description",211970983,null),new cljs.core.Symbol(null,"range","range",-1014743483,null),new cljs.core.Symbol(null,"inherit?","inherit?",-1400977833,null)], null);
});

active.clojure.config.Setting.cljs$lang$type = true;

active.clojure.config.Setting.cljs$lang$ctorPrSeq = (function (this__14281__auto__){
return (new cljs.core.List(null,"active.clojure.config/Setting",null,(1),null));
});

active.clojure.config.Setting.cljs$lang$ctorPrWriter = (function (this__14281__auto__,writer__14282__auto__){
return cljs.core._write.call(null,writer__14282__auto__,"active.clojure.config/Setting");
});

if(cljs.core._EQ_.call(null,false,new cljs.core.Keyword(null,"arrow-constructor?","arrow-constructor?",-1068727936).cljs$core$IFn$_invoke$arity$1(null))){
} else {
/**
 * Named setting within a config.
 */
active.clojure.config.__GT_Setting = (function active$clojure$config$__GT_Setting(key,description,range,inherit_QMARK_){
return (new active.clojure.config.Setting(key,description,range,inherit_QMARK_,null,null,null));
});
}

/**
 * Named setting within a config.
 */
active.clojure.config.map__GT_Setting = (function active$clojure$config$map__GT_Setting(G__14440){
return (new active.clojure.config.Setting(new cljs.core.Keyword(null,"key","key",-1516042587).cljs$core$IFn$_invoke$arity$1(G__14440),new cljs.core.Keyword(null,"description","description",-1428560544).cljs$core$IFn$_invoke$arity$1(G__14440),new cljs.core.Keyword(null,"range","range",1639692286).cljs$core$IFn$_invoke$arity$1(G__14440),new cljs.core.Keyword(null,"inherit?","inherit?",1253457936).cljs$core$IFn$_invoke$arity$1(G__14440),null,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,G__14440,new cljs.core.Keyword(null,"key","key",-1516042587),new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.Keyword(null,"range","range",1639692286),new cljs.core.Keyword(null,"inherit?","inherit?",1253457936))),null));
});

/**
 * Is object a `Setting` record? See [[active.clojure.config/make-setting]].
 */
active.clojure.config.setting_QMARK_ = (function active$clojure$config$setting_QMARK_(x__14283__auto__){
return (x__14283__auto__ instanceof active.clojure.config.Setting);
});

/**
 * Make a named schema [[Setting]] object.
 *   - `key` is a keyword naming the setting
 *   - `description` is a human-readable description object
 *   - `range` is a [[Range]] for the admissible values of the setting
 *   - `inherit?` says whether the setting values may be inherited from a surrounding section
 */
active.clojure.config.make_setting = (function active$clojure$config$make_setting(key,description,range,inherit_QMARK_){
return (new active.clojure.config.Setting(key,description,range,inherit_QMARK_,null,null,null));
});





/**
 * Lens for the `key` field from a [[Setting]] record. See [[active.clojure.config/make-setting]].
 */
active.clojure.config.setting_key = active.clojure.lens.lens.call(null,(function (rec__14262__auto__){
if((rec__14262__auto__ instanceof active.clojure.config.Setting)){
} else {
throw (new Error("Wrong record type (rec__14262__auto__) passed to accessor (setting-key)."));
}

return rec__14262__auto__.key;
}),(function (data__14263__auto__,v__14264__auto__){
return (new active.clojure.config.Setting(v__14264__auto__,active.clojure.config.setting_description.call(null,data__14263__auto__),active.clojure.config.setting_range.call(null,data__14263__auto__),active.clojure.config.setting_inherit_QMARK_.call(null,data__14263__auto__),null,null,null));
}));


/**
 * Lens for the `description` field from a [[Setting]] record. See [[active.clojure.config/make-setting]].
 */
active.clojure.config.setting_description = active.clojure.lens.lens.call(null,(function (rec__14262__auto__){
if((rec__14262__auto__ instanceof active.clojure.config.Setting)){
} else {
throw (new Error("Wrong record type (rec__14262__auto__) passed to accessor (setting-description)."));
}

return rec__14262__auto__.description;
}),(function (data__14263__auto__,v__14264__auto__){
return (new active.clojure.config.Setting(active.clojure.config.setting_key.call(null,data__14263__auto__),v__14264__auto__,active.clojure.config.setting_range.call(null,data__14263__auto__),active.clojure.config.setting_inherit_QMARK_.call(null,data__14263__auto__),null,null,null));
}));


/**
 * Lens for the `range` field from a [[Setting]] record. See [[active.clojure.config/make-setting]].
 */
active.clojure.config.setting_range = active.clojure.lens.lens.call(null,(function (rec__14262__auto__){
if((rec__14262__auto__ instanceof active.clojure.config.Setting)){
} else {
throw (new Error("Wrong record type (rec__14262__auto__) passed to accessor (setting-range)."));
}

return rec__14262__auto__.range;
}),(function (data__14263__auto__,v__14264__auto__){
return (new active.clojure.config.Setting(active.clojure.config.setting_key.call(null,data__14263__auto__),active.clojure.config.setting_description.call(null,data__14263__auto__),v__14264__auto__,active.clojure.config.setting_inherit_QMARK_.call(null,data__14263__auto__),null,null,null));
}));


/**
 * Lens for the `inherit?` field from a [[Setting]] record. See [[active.clojure.config/make-setting]].
 */
active.clojure.config.setting_inherit_QMARK_ = active.clojure.lens.lens.call(null,(function (rec__14262__auto__){
if((rec__14262__auto__ instanceof active.clojure.config.Setting)){
} else {
throw (new Error("Wrong record type (rec__14262__auto__) passed to accessor (setting-inherit?)."));
}

return rec__14262__auto__.inherit_QMARK_;
}),(function (data__14263__auto__,v__14264__auto__){
return (new active.clojure.config.Setting(active.clojure.config.setting_key.call(null,data__14263__auto__),active.clojure.config.setting_description.call(null,data__14263__auto__),active.clojure.config.setting_range.call(null,data__14263__auto__),v__14264__auto__,null,null,null));
}));



/**
 * Construct a setting.
 *   - `key` is a keyword naming the setting
 *   - `description` is a human-readable description object
 *   - `range` is a [[Range]] for the admissible values of the setting
 *   - `inherit?` says whether the setting values may be inherited from a surrounding section
 */
active.clojure.config.setting = (function active$clojure$config$setting(var_args){
var args__4502__auto__ = [];
var len__4499__auto___14453 = arguments.length;
var i__4500__auto___14454 = (0);
while(true){
if((i__4500__auto___14454 < len__4499__auto___14453)){
args__4502__auto__.push((arguments[i__4500__auto___14454]));

var G__14455 = (i__4500__auto___14454 + (1));
i__4500__auto___14454 = G__14455;
continue;
} else {
}
break;
}

var argseq__4503__auto__ = ((((3) < args__4502__auto__.length))?(new cljs.core.IndexedSeq(args__4502__auto__.slice((3)),(0),null)):null);
return active.clojure.config.setting.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4503__auto__);
});

active.clojure.config.setting.cljs$core$IFn$_invoke$arity$variadic = (function (key,description,range,p__14450){
var map__14451 = p__14450;
var map__14451__$1 = ((((!((map__14451 == null)))?(((((map__14451.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14451.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14451):map__14451);
var inherit_QMARK_ = cljs.core.get.call(null,map__14451__$1,new cljs.core.Keyword(null,"inherit?","inherit?",1253457936));
if(typeof description === 'string'){
} else {
throw (new Error("Assert failed: (string? description)"));
}

return active.clojure.config.make_setting.call(null,key,description,range,(cljs.core.truth_(inherit_QMARK_)?true:false));
});

active.clojure.config.setting.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
active.clojure.config.setting.cljs$lang$applyTo = (function (seq14446){
var G__14447 = cljs.core.first.call(null,seq14446);
var seq14446__$1 = cljs.core.next.call(null,seq14446);
var G__14448 = cljs.core.first.call(null,seq14446__$1);
var seq14446__$2 = cljs.core.next.call(null,seq14446__$1);
var G__14449 = cljs.core.first.call(null,seq14446__$2);
var seq14446__$3 = cljs.core.next.call(null,seq14446__$2);
var self__4486__auto__ = this;
return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14447,G__14448,G__14449,seq14446__$3);
});

/**
 * Compute the default value for a setting.
 */
active.clojure.config.setting_default_value = (function active$clojure$config$setting_default_value(setting){
var range = active.clojure.config.setting_range.call(null,setting);
var val = active.clojure.config.range_completer.call(null,range).call(null,range,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [active.clojure.config.setting_key.call(null,setting)], null),null);
if(cljs.core.truth_(active.clojure.config.range_error_QMARK_.call(null,val))){
return active.clojure.condition.error.call(null,new cljs.core.Symbol("active.clojure.config","setting-default-value","active.clojure.config/setting-default-value",-1897314404,null),["setting ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.vec.call(null,active.clojure.config.range_error_path.call(null,val)))," is missing in configuration map"].join(''),val);
} else {
return val;
}
});




/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
active.clojure.config.Section = (function (key,schema,inherit_QMARK_,__meta,__extmap,__hash){
this.key = key;
this.schema = schema;
this.inherit_QMARK_ = inherit_QMARK_;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
active.clojure.config.Section.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__14195__auto__,k__14196__auto__){
var self__ = this;
var this__14195__auto____$1 = this;
return this__14195__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__14196__auto__,null);
});

active.clojure.config.Section.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__14197__auto__,k14457,else__14198__auto__){
var self__ = this;
var this__14197__auto____$1 = this;
var G__14461 = k14457;
var G__14461__$1 = (((G__14461 instanceof cljs.core.Keyword))?G__14461.fqn:null);
switch (G__14461__$1) {
case "key":
return self__.key;

break;
case "schema":
return self__.schema;

break;
case "inherit?":
return self__.inherit_QMARK_;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k14457,else__14198__auto__);

}
});

active.clojure.config.Section.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__14205__auto__,writer__14206__auto__,opts__14207__auto__){
var self__ = this;
var this__14205__auto____$1 = this;
var pr_pair__14208__auto__ = ((function (this__14205__auto____$1){
return (function (keyval__14209__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__14206__auto__,cljs.core.pr_writer,""," ","",opts__14207__auto__,keyval__14209__auto__);
});})(this__14205__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__14206__auto__,pr_pair__14208__auto__,"#active.clojure.config.Section{",", ","}",opts__14207__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"key","key",-1516042587),self__.key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"inherit?","inherit?",1253457936),self__.inherit_QMARK_],null))], null),self__.__extmap));
});

active.clojure.config.Section.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__14456){
var self__ = this;
var G__14456__$1 = this;
return (new cljs.core.RecordIter((0),G__14456__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"key","key",-1516042587),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"inherit?","inherit?",1253457936)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

active.clojure.config.Section.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__14193__auto__){
var self__ = this;
var this__14193__auto____$1 = this;
return self__.__meta;
});

active.clojure.config.Section.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__14190__auto__){
var self__ = this;
var this__14190__auto____$1 = this;
return (new active.clojure.config.Section(self__.key,self__.schema,self__.inherit_QMARK_,self__.__meta,self__.__extmap,self__.__hash));
});

active.clojure.config.Section.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__14199__auto__){
var self__ = this;
var this__14199__auto____$1 = this;
return (3 + cljs.core.count.call(null,self__.__extmap));
});

active.clojure.config.Section.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__14191__auto__){
var self__ = this;
var this__14191__auto____$1 = this;
var h__4030__auto__ = self__.__hash;
if(!((h__4030__auto__ == null))){
return h__4030__auto__;
} else {
var h__4030__auto____$1 = ((function (h__4030__auto__,this__14191__auto____$1){
return (function (coll__14192__auto__){
return (907123784 ^ cljs.core.hash_unordered_coll.call(null,coll__14192__auto__));
});})(h__4030__auto__,this__14191__auto____$1))
.call(null,this__14191__auto____$1);
self__.__hash = h__4030__auto____$1;

return h__4030__auto____$1;
}
});

active.clojure.config.Section.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this14458,other14459){
var self__ = this;
var this14458__$1 = this;
return ((!((other14459 == null))) && ((this14458__$1.constructor === other14459.constructor)) && (cljs.core._EQ_.call(null,this14458__$1.key,other14459.key)) && (cljs.core._EQ_.call(null,this14458__$1.schema,other14459.schema)) && (cljs.core._EQ_.call(null,this14458__$1.inherit_QMARK_,other14459.inherit_QMARK_)) && (cljs.core._EQ_.call(null,this14458__$1.__extmap,other14459.__extmap)));
});

active.clojure.config.Section.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__14188__auto__,k__14189__auto__){
var self__ = this;
var this__14188__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),null,new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"inherit?","inherit?",1253457936),null], null), null),k__14189__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__14188__auto____$1),self__.__meta),k__14189__auto__);
} else {
return (new active.clojure.config.Section(self__.key,self__.schema,self__.inherit_QMARK_,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__14189__auto__)),null));
}
});

active.clojure.config.Section.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__14186__auto__,k__14187__auto__,G__14456){
var self__ = this;
var this__14186__auto____$1 = this;
var pred__14462 = cljs.core.keyword_identical_QMARK_;
var expr__14463 = k__14187__auto__;
if(cljs.core.truth_(pred__14462.call(null,new cljs.core.Keyword(null,"key","key",-1516042587),expr__14463))){
return (new active.clojure.config.Section(G__14456,self__.schema,self__.inherit_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__14462.call(null,new cljs.core.Keyword(null,"schema","schema",-1582001791),expr__14463))){
return (new active.clojure.config.Section(self__.key,G__14456,self__.inherit_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__14462.call(null,new cljs.core.Keyword(null,"inherit?","inherit?",1253457936),expr__14463))){
return (new active.clojure.config.Section(self__.key,self__.schema,G__14456,self__.__meta,self__.__extmap,null));
} else {
return (new active.clojure.config.Section(self__.key,self__.schema,self__.inherit_QMARK_,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__14187__auto__,G__14456),null));
}
}
}
});

active.clojure.config.Section.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__14203__auto__){
var self__ = this;
var this__14203__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"key","key",-1516042587),self__.key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"inherit?","inherit?",1253457936),self__.inherit_QMARK_],null))], null),self__.__extmap));
});

active.clojure.config.Section.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__14194__auto__,G__14456){
var self__ = this;
var this__14194__auto____$1 = this;
return (new active.clojure.config.Section(self__.key,self__.schema,self__.inherit_QMARK_,G__14456,self__.__extmap,self__.__hash));
});

active.clojure.config.Section.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__14200__auto__,entry__14201__auto__){
var self__ = this;
var this__14200__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__14201__auto__)){
return this__14200__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__14201__auto__,(0)),cljs.core._nth.call(null,entry__14201__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__14200__auto____$1,entry__14201__auto__);
}
});

active.clojure.config.Section.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"doc","doc",-741138878,null),"keyword naming the section"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"doc","doc",-741138878,null),"sub-schema describing the section's format"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"inherit?","inherit?",-1400977833,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"doc","doc",-741138878,null),"whether this section inherits from outer levels"], null))], null);
});

active.clojure.config.Section.cljs$lang$type = true;

active.clojure.config.Section.cljs$lang$ctorPrSeq = (function (this__14281__auto__){
return (new cljs.core.List(null,"active.clojure.config/Section",null,(1),null));
});

active.clojure.config.Section.cljs$lang$ctorPrWriter = (function (this__14281__auto__,writer__14282__auto__){
return cljs.core._write.call(null,writer__14282__auto__,"active.clojure.config/Section");
});

if(cljs.core._EQ_.call(null,false,new cljs.core.Keyword(null,"arrow-constructor?","arrow-constructor?",-1068727936).cljs$core$IFn$_invoke$arity$1(null))){
} else {
/**
 * Section within a config with settings of its own.
 */
active.clojure.config.__GT_Section = (function active$clojure$config$__GT_Section(key,schema,inherit_QMARK_){
return (new active.clojure.config.Section(key,schema,inherit_QMARK_,null,null,null));
});
}

/**
 * Section within a config with settings of its own.
 */
active.clojure.config.map__GT_Section = (function active$clojure$config$map__GT_Section(G__14460){
return (new active.clojure.config.Section(new cljs.core.Keyword(null,"key","key",-1516042587).cljs$core$IFn$_invoke$arity$1(G__14460),new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__14460),new cljs.core.Keyword(null,"inherit?","inherit?",1253457936).cljs$core$IFn$_invoke$arity$1(G__14460),null,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,G__14460,new cljs.core.Keyword(null,"key","key",-1516042587),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"inherit?","inherit?",1253457936))),null));
});

/**
 * Is object a `Section` record? See [[active.clojure.config/make-section]].
 */
active.clojure.config.section_QMARK_ = (function active$clojure$config$section_QMARK_(x__14283__auto__){
return (x__14283__auto__ instanceof active.clojure.config.Section);
});

/**
 * Construct a `Section` (Section within a config with settings of its own.) record.
 * 
 * `key`: access via [[active.clojure.config/section-key]]
 * `schema`: access via [[active.clojure.config/section-schema]]
 * `inherit?`: access via [[active.clojure.config/section-inherit?]]
 */
active.clojure.config.make_section = (function active$clojure$config$make_section(key,schema,inherit_QMARK_){
return (new active.clojure.config.Section(key,schema,inherit_QMARK_,null,null,null));
});




/**
 * Lens for the `key` field from a [[Section]] record. See [[active.clojure.config/make-section]].
 */
active.clojure.config.section_key = active.clojure.lens.lens.call(null,(function (rec__14262__auto__){
if((rec__14262__auto__ instanceof active.clojure.config.Section)){
} else {
throw (new Error("Wrong record type (rec__14262__auto__) passed to accessor (section-key)."));
}

return rec__14262__auto__.key;
}),(function (data__14263__auto__,v__14264__auto__){
return (new active.clojure.config.Section(v__14264__auto__,active.clojure.config.section_schema.call(null,data__14263__auto__),active.clojure.config.section_inherit_QMARK_.call(null,data__14263__auto__),null,null,null));
}));


/**
 * Lens for the `schema` field from a [[Section]] record. See [[active.clojure.config/make-section]].
 */
active.clojure.config.section_schema = active.clojure.lens.lens.call(null,(function (rec__14262__auto__){
if((rec__14262__auto__ instanceof active.clojure.config.Section)){
} else {
throw (new Error("Wrong record type (rec__14262__auto__) passed to accessor (section-schema)."));
}

return rec__14262__auto__.schema;
}),(function (data__14263__auto__,v__14264__auto__){
return (new active.clojure.config.Section(active.clojure.config.section_key.call(null,data__14263__auto__),v__14264__auto__,active.clojure.config.section_inherit_QMARK_.call(null,data__14263__auto__),null,null,null));
}));


/**
 * Lens for the `inherit?` field from a [[Section]] record. See [[active.clojure.config/make-section]].
 */
active.clojure.config.section_inherit_QMARK_ = active.clojure.lens.lens.call(null,(function (rec__14262__auto__){
if((rec__14262__auto__ instanceof active.clojure.config.Section)){
} else {
throw (new Error("Wrong record type (rec__14262__auto__) passed to accessor (section-inherit?)."));
}

return rec__14262__auto__.inherit_QMARK_;
}),(function (data__14263__auto__,v__14264__auto__){
return (new active.clojure.config.Section(active.clojure.config.section_key.call(null,data__14263__auto__),active.clojure.config.section_schema.call(null,data__14263__auto__),v__14264__auto__,null,null,null));
}));



/**
 * Make a section within a config with settings of its own.
 */
active.clojure.config.section = (function active$clojure$config$section(var_args){
var args__4502__auto__ = [];
var len__4499__auto___14472 = arguments.length;
var i__4500__auto___14473 = (0);
while(true){
if((i__4500__auto___14473 < len__4499__auto___14472)){
args__4502__auto__.push((arguments[i__4500__auto___14473]));

var G__14474 = (i__4500__auto___14473 + (1));
i__4500__auto___14473 = G__14474;
continue;
} else {
}
break;
}

var argseq__4503__auto__ = ((((2) < args__4502__auto__.length))?(new cljs.core.IndexedSeq(args__4502__auto__.slice((2)),(0),null)):null);
return active.clojure.config.section.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4503__auto__);
});

active.clojure.config.section.cljs$core$IFn$_invoke$arity$variadic = (function (key,schema,p__14469){
var map__14470 = p__14469;
var map__14470__$1 = ((((!((map__14470 == null)))?(((((map__14470.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14470.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14470):map__14470);
var inherit_QMARK_ = cljs.core.get.call(null,map__14470__$1,new cljs.core.Keyword(null,"inherit?","inherit?",1253457936));
return active.clojure.config.make_section.call(null,key,schema,(cljs.core.truth_(inherit_QMARK_)?true:false));
});

active.clojure.config.section.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
active.clojure.config.section.cljs$lang$applyTo = (function (seq14466){
var G__14467 = cljs.core.first.call(null,seq14466);
var seq14466__$1 = cljs.core.next.call(null,seq14466);
var G__14468 = cljs.core.first.call(null,seq14466__$1);
var seq14466__$2 = cljs.core.next.call(null,seq14466__$1);
var self__4486__auto__ = this;
return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14467,G__14468,seq14466__$2);
});







/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
active.clojure.config.Schema = (function (description,settings,settings_map,sections,sections_map,__meta,__extmap,__hash){
this.description = description;
this.settings = settings;
this.settings_map = settings_map;
this.sections = sections;
this.sections_map = sections_map;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
active.clojure.config.Schema.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__14195__auto__,k__14196__auto__){
var self__ = this;
var this__14195__auto____$1 = this;
return this__14195__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__14196__auto__,null);
});

active.clojure.config.Schema.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__14197__auto__,k14476,else__14198__auto__){
var self__ = this;
var this__14197__auto____$1 = this;
var G__14480 = k14476;
var G__14480__$1 = (((G__14480 instanceof cljs.core.Keyword))?G__14480.fqn:null);
switch (G__14480__$1) {
case "description":
return self__.description;

break;
case "settings":
return self__.settings;

break;
case "settings-map":
return self__.settings_map;

break;
case "sections":
return self__.sections;

break;
case "sections-map":
return self__.sections_map;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k14476,else__14198__auto__);

}
});

active.clojure.config.Schema.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__14205__auto__,writer__14206__auto__,opts__14207__auto__){
var self__ = this;
var this__14205__auto____$1 = this;
var pr_pair__14208__auto__ = ((function (this__14205__auto____$1){
return (function (keyval__14209__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__14206__auto__,cljs.core.pr_writer,""," ","",opts__14207__auto__,keyval__14209__auto__);
});})(this__14205__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__14206__auto__,pr_pair__14208__auto__,"#active.clojure.config.Schema{",", ","}",opts__14207__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"description","description",-1428560544),self__.description],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"settings-map","settings-map",627120582),self__.settings_map],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"sections","sections",-886710106),self__.sections],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"sections-map","sections-map",98610924),self__.sections_map],null))], null),self__.__extmap));
});

active.clojure.config.Schema.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__14475){
var self__ = this;
var G__14475__$1 = this;
return (new cljs.core.RecordIter((0),G__14475__$1,5,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"settings-map","settings-map",627120582),new cljs.core.Keyword(null,"sections","sections",-886710106),new cljs.core.Keyword(null,"sections-map","sections-map",98610924)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

active.clojure.config.Schema.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__14193__auto__){
var self__ = this;
var this__14193__auto____$1 = this;
return self__.__meta;
});

active.clojure.config.Schema.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__14190__auto__){
var self__ = this;
var this__14190__auto____$1 = this;
return (new active.clojure.config.Schema(self__.description,self__.settings,self__.settings_map,self__.sections,self__.sections_map,self__.__meta,self__.__extmap,self__.__hash));
});

active.clojure.config.Schema.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__14199__auto__){
var self__ = this;
var this__14199__auto____$1 = this;
return (5 + cljs.core.count.call(null,self__.__extmap));
});

active.clojure.config.Schema.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__14191__auto__){
var self__ = this;
var this__14191__auto____$1 = this;
var h__4030__auto__ = self__.__hash;
if(!((h__4030__auto__ == null))){
return h__4030__auto__;
} else {
var h__4030__auto____$1 = ((function (h__4030__auto__,this__14191__auto____$1){
return (function (coll__14192__auto__){
return (242145994 ^ cljs.core.hash_unordered_coll.call(null,coll__14192__auto__));
});})(h__4030__auto__,this__14191__auto____$1))
.call(null,this__14191__auto____$1);
self__.__hash = h__4030__auto____$1;

return h__4030__auto____$1;
}
});

active.clojure.config.Schema.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this14477,other14478){
var self__ = this;
var this14477__$1 = this;
return ((!((other14478 == null))) && ((this14477__$1.constructor === other14478.constructor)) && (cljs.core._EQ_.call(null,this14477__$1.description,other14478.description)) && (cljs.core._EQ_.call(null,this14477__$1.settings,other14478.settings)) && (cljs.core._EQ_.call(null,this14477__$1.settings_map,other14478.settings_map)) && (cljs.core._EQ_.call(null,this14477__$1.sections,other14478.sections)) && (cljs.core._EQ_.call(null,this14477__$1.sections_map,other14478.sections_map)) && (cljs.core._EQ_.call(null,this14477__$1.__extmap,other14478.__extmap)));
});

active.clojure.config.Schema.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__14188__auto__,k__14189__auto__){
var self__ = this;
var this__14188__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"description","description",-1428560544),null,new cljs.core.Keyword(null,"sections","sections",-886710106),null,new cljs.core.Keyword(null,"settings-map","settings-map",627120582),null,new cljs.core.Keyword(null,"settings","settings",1556144875),null,new cljs.core.Keyword(null,"sections-map","sections-map",98610924),null], null), null),k__14189__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__14188__auto____$1),self__.__meta),k__14189__auto__);
} else {
return (new active.clojure.config.Schema(self__.description,self__.settings,self__.settings_map,self__.sections,self__.sections_map,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__14189__auto__)),null));
}
});

active.clojure.config.Schema.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__14186__auto__,k__14187__auto__,G__14475){
var self__ = this;
var this__14186__auto____$1 = this;
var pred__14481 = cljs.core.keyword_identical_QMARK_;
var expr__14482 = k__14187__auto__;
if(cljs.core.truth_(pred__14481.call(null,new cljs.core.Keyword(null,"description","description",-1428560544),expr__14482))){
return (new active.clojure.config.Schema(G__14475,self__.settings,self__.settings_map,self__.sections,self__.sections_map,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__14481.call(null,new cljs.core.Keyword(null,"settings","settings",1556144875),expr__14482))){
return (new active.clojure.config.Schema(self__.description,G__14475,self__.settings_map,self__.sections,self__.sections_map,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__14481.call(null,new cljs.core.Keyword(null,"settings-map","settings-map",627120582),expr__14482))){
return (new active.clojure.config.Schema(self__.description,self__.settings,G__14475,self__.sections,self__.sections_map,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__14481.call(null,new cljs.core.Keyword(null,"sections","sections",-886710106),expr__14482))){
return (new active.clojure.config.Schema(self__.description,self__.settings,self__.settings_map,G__14475,self__.sections_map,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__14481.call(null,new cljs.core.Keyword(null,"sections-map","sections-map",98610924),expr__14482))){
return (new active.clojure.config.Schema(self__.description,self__.settings,self__.settings_map,self__.sections,G__14475,self__.__meta,self__.__extmap,null));
} else {
return (new active.clojure.config.Schema(self__.description,self__.settings,self__.settings_map,self__.sections,self__.sections_map,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__14187__auto__,G__14475),null));
}
}
}
}
}
});

active.clojure.config.Schema.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__14203__auto__){
var self__ = this;
var this__14203__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"description","description",-1428560544),self__.description],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"settings-map","settings-map",627120582),self__.settings_map],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"sections","sections",-886710106),self__.sections],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"sections-map","sections-map",98610924),self__.sections_map],null))], null),self__.__extmap));
});

active.clojure.config.Schema.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__14194__auto__,G__14475){
var self__ = this;
var this__14194__auto____$1 = this;
return (new active.clojure.config.Schema(self__.description,self__.settings,self__.settings_map,self__.sections,self__.sections_map,G__14475,self__.__extmap,self__.__hash));
});

active.clojure.config.Schema.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__14200__auto__,entry__14201__auto__){
var self__ = this;
var this__14200__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__14201__auto__)){
return this__14200__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__14201__auto__,(0)),cljs.core._nth.call(null,entry__14201__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__14200__auto____$1,entry__14201__auto__);
}
});

active.clojure.config.Schema.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"description","description",211970983,null),new cljs.core.Symbol(null,"settings","settings",-1098290894,null),new cljs.core.Symbol(null,"settings-map","settings-map",-2027315187,null),new cljs.core.Symbol(null,"sections","sections",753821421,null),new cljs.core.Symbol(null,"sections-map","sections-map",1739142451,null)], null);
});

active.clojure.config.Schema.cljs$lang$type = true;

active.clojure.config.Schema.cljs$lang$ctorPrSeq = (function (this__14281__auto__){
return (new cljs.core.List(null,"active.clojure.config/Schema",null,(1),null));
});

active.clojure.config.Schema.cljs$lang$ctorPrWriter = (function (this__14281__auto__,writer__14282__auto__){
return cljs.core._write.call(null,writer__14282__auto__,"active.clojure.config/Schema");
});

if(cljs.core._EQ_.call(null,false,new cljs.core.Keyword(null,"arrow-constructor?","arrow-constructor?",-1068727936).cljs$core$IFn$_invoke$arity$1(null))){
} else {
/**
 * A schema describes a map-structured config format, and can be used for
 *   validation and completion.
 */
active.clojure.config.__GT_Schema = (function active$clojure$config$__GT_Schema(description,settings,settings_map,sections,sections_map){
return (new active.clojure.config.Schema(description,settings,settings_map,sections,sections_map,null,null,null));
});
}

/**
 * A schema describes a map-structured config format, and can be used for
 *   validation and completion.
 */
active.clojure.config.map__GT_Schema = (function active$clojure$config$map__GT_Schema(G__14479){
return (new active.clojure.config.Schema(new cljs.core.Keyword(null,"description","description",-1428560544).cljs$core$IFn$_invoke$arity$1(G__14479),new cljs.core.Keyword(null,"settings","settings",1556144875).cljs$core$IFn$_invoke$arity$1(G__14479),new cljs.core.Keyword(null,"settings-map","settings-map",627120582).cljs$core$IFn$_invoke$arity$1(G__14479),new cljs.core.Keyword(null,"sections","sections",-886710106).cljs$core$IFn$_invoke$arity$1(G__14479),new cljs.core.Keyword(null,"sections-map","sections-map",98610924).cljs$core$IFn$_invoke$arity$1(G__14479),null,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,G__14479,new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"settings-map","settings-map",627120582),new cljs.core.Keyword(null,"sections","sections",-886710106),new cljs.core.Keyword(null,"sections-map","sections-map",98610924))),null));
});

/**
 * Is object a `Schema` record? See [[active.clojure.config/make-map-schema]].
 */
active.clojure.config.map_schema_QMARK_ = (function active$clojure$config$map_schema_QMARK_(x__14283__auto__){
return (x__14283__auto__ instanceof active.clojure.config.Schema);
});

/**
 * Make a [[Schema]] object describing a config format.
 *   *For internal use;* you should use [[schema]].
 * 
 *   - `description` is a human-readable description
 *   - `settings` is a collection of [[Setting]]s
 *   - `settings-map` is a map from setting keys to settings
 *   - `sections` is a collection of [[Section]]s
 *   - `sections-map` is a map from section keys to sections
 */
active.clojure.config.make_map_schema = (function active$clojure$config$make_map_schema(description,settings,settings_map,sections,sections_map){
return (new active.clojure.config.Schema(description,settings,settings_map,sections,sections_map,null,null,null));
});






/**
 * Lens for the `description` field from a [[Schema]] record. See [[active.clojure.config/make-map-schema]].
 */
active.clojure.config.map_schema_description = active.clojure.lens.lens.call(null,(function (rec__14262__auto__){
if((rec__14262__auto__ instanceof active.clojure.config.Schema)){
} else {
throw (new Error("Wrong record type (rec__14262__auto__) passed to accessor (map-schema-description)."));
}

return rec__14262__auto__.description;
}),(function (data__14263__auto__,v__14264__auto__){
return (new active.clojure.config.Schema(v__14264__auto__,active.clojure.config.map_schema_settings.call(null,data__14263__auto__),active.clojure.config.map_schema_settings_map.call(null,data__14263__auto__),active.clojure.config.map_schema_sections.call(null,data__14263__auto__),active.clojure.config.map_schema_sections_map.call(null,data__14263__auto__),null,null,null));
}));


/**
 * Lens for the `settings` field from a [[Schema]] record. See [[active.clojure.config/make-map-schema]].
 */
active.clojure.config.map_schema_settings = active.clojure.lens.lens.call(null,(function (rec__14262__auto__){
if((rec__14262__auto__ instanceof active.clojure.config.Schema)){
} else {
throw (new Error("Wrong record type (rec__14262__auto__) passed to accessor (map-schema-settings)."));
}

return rec__14262__auto__.settings;
}),(function (data__14263__auto__,v__14264__auto__){
return (new active.clojure.config.Schema(active.clojure.config.map_schema_description.call(null,data__14263__auto__),v__14264__auto__,active.clojure.config.map_schema_settings_map.call(null,data__14263__auto__),active.clojure.config.map_schema_sections.call(null,data__14263__auto__),active.clojure.config.map_schema_sections_map.call(null,data__14263__auto__),null,null,null));
}));


/**
 * Lens for the `settings-map` field from a [[Schema]] record. See [[active.clojure.config/make-map-schema]].
 */
active.clojure.config.map_schema_settings_map = active.clojure.lens.lens.call(null,(function (rec__14262__auto__){
if((rec__14262__auto__ instanceof active.clojure.config.Schema)){
} else {
throw (new Error("Wrong record type (rec__14262__auto__) passed to accessor (map-schema-settings-map)."));
}

return rec__14262__auto__.settings_map;
}),(function (data__14263__auto__,v__14264__auto__){
return (new active.clojure.config.Schema(active.clojure.config.map_schema_description.call(null,data__14263__auto__),active.clojure.config.map_schema_settings.call(null,data__14263__auto__),v__14264__auto__,active.clojure.config.map_schema_sections.call(null,data__14263__auto__),active.clojure.config.map_schema_sections_map.call(null,data__14263__auto__),null,null,null));
}));


/**
 * Lens for the `sections` field from a [[Schema]] record. See [[active.clojure.config/make-map-schema]].
 */
active.clojure.config.map_schema_sections = active.clojure.lens.lens.call(null,(function (rec__14262__auto__){
if((rec__14262__auto__ instanceof active.clojure.config.Schema)){
} else {
throw (new Error("Wrong record type (rec__14262__auto__) passed to accessor (map-schema-sections)."));
}

return rec__14262__auto__.sections;
}),(function (data__14263__auto__,v__14264__auto__){
return (new active.clojure.config.Schema(active.clojure.config.map_schema_description.call(null,data__14263__auto__),active.clojure.config.map_schema_settings.call(null,data__14263__auto__),active.clojure.config.map_schema_settings_map.call(null,data__14263__auto__),v__14264__auto__,active.clojure.config.map_schema_sections_map.call(null,data__14263__auto__),null,null,null));
}));


/**
 * Lens for the `sections-map` field from a [[Schema]] record. See [[active.clojure.config/make-map-schema]].
 */
active.clojure.config.map_schema_sections_map = active.clojure.lens.lens.call(null,(function (rec__14262__auto__){
if((rec__14262__auto__ instanceof active.clojure.config.Schema)){
} else {
throw (new Error("Wrong record type (rec__14262__auto__) passed to accessor (map-schema-sections-map)."));
}

return rec__14262__auto__.sections_map;
}),(function (data__14263__auto__,v__14264__auto__){
return (new active.clojure.config.Schema(active.clojure.config.map_schema_description.call(null,data__14263__auto__),active.clojure.config.map_schema_settings.call(null,data__14263__auto__),active.clojure.config.map_schema_settings_map.call(null,data__14263__auto__),active.clojure.config.map_schema_sections.call(null,data__14263__auto__),v__14264__auto__,null,null,null));
}));






/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
active.clojure.config.SequenceSchema = (function (description,element_schema,__meta,__extmap,__hash){
this.description = description;
this.element_schema = element_schema;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
active.clojure.config.SequenceSchema.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__14195__auto__,k__14196__auto__){
var self__ = this;
var this__14195__auto____$1 = this;
return this__14195__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__14196__auto__,null);
});

active.clojure.config.SequenceSchema.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__14197__auto__,k14486,else__14198__auto__){
var self__ = this;
var this__14197__auto____$1 = this;
var G__14490 = k14486;
var G__14490__$1 = (((G__14490 instanceof cljs.core.Keyword))?G__14490.fqn:null);
switch (G__14490__$1) {
case "description":
return self__.description;

break;
case "element-schema":
return self__.element_schema;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k14486,else__14198__auto__);

}
});

active.clojure.config.SequenceSchema.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__14205__auto__,writer__14206__auto__,opts__14207__auto__){
var self__ = this;
var this__14205__auto____$1 = this;
var pr_pair__14208__auto__ = ((function (this__14205__auto____$1){
return (function (keyval__14209__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__14206__auto__,cljs.core.pr_writer,""," ","",opts__14207__auto__,keyval__14209__auto__);
});})(this__14205__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__14206__auto__,pr_pair__14208__auto__,"#active.clojure.config.SequenceSchema{",", ","}",opts__14207__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"description","description",-1428560544),self__.description],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"element-schema","element-schema",-865548916),self__.element_schema],null))], null),self__.__extmap));
});

active.clojure.config.SequenceSchema.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__14485){
var self__ = this;
var G__14485__$1 = this;
return (new cljs.core.RecordIter((0),G__14485__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.Keyword(null,"element-schema","element-schema",-865548916)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

active.clojure.config.SequenceSchema.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__14193__auto__){
var self__ = this;
var this__14193__auto____$1 = this;
return self__.__meta;
});

active.clojure.config.SequenceSchema.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__14190__auto__){
var self__ = this;
var this__14190__auto____$1 = this;
return (new active.clojure.config.SequenceSchema(self__.description,self__.element_schema,self__.__meta,self__.__extmap,self__.__hash));
});

active.clojure.config.SequenceSchema.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__14199__auto__){
var self__ = this;
var this__14199__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});

active.clojure.config.SequenceSchema.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__14191__auto__){
var self__ = this;
var this__14191__auto____$1 = this;
var h__4030__auto__ = self__.__hash;
if(!((h__4030__auto__ == null))){
return h__4030__auto__;
} else {
var h__4030__auto____$1 = ((function (h__4030__auto__,this__14191__auto____$1){
return (function (coll__14192__auto__){
return (1998884718 ^ cljs.core.hash_unordered_coll.call(null,coll__14192__auto__));
});})(h__4030__auto__,this__14191__auto____$1))
.call(null,this__14191__auto____$1);
self__.__hash = h__4030__auto____$1;

return h__4030__auto____$1;
}
});

active.clojure.config.SequenceSchema.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this14487,other14488){
var self__ = this;
var this14487__$1 = this;
return ((!((other14488 == null))) && ((this14487__$1.constructor === other14488.constructor)) && (cljs.core._EQ_.call(null,this14487__$1.description,other14488.description)) && (cljs.core._EQ_.call(null,this14487__$1.element_schema,other14488.element_schema)) && (cljs.core._EQ_.call(null,this14487__$1.__extmap,other14488.__extmap)));
});

active.clojure.config.SequenceSchema.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__14188__auto__,k__14189__auto__){
var self__ = this;
var this__14188__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"description","description",-1428560544),null,new cljs.core.Keyword(null,"element-schema","element-schema",-865548916),null], null), null),k__14189__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__14188__auto____$1),self__.__meta),k__14189__auto__);
} else {
return (new active.clojure.config.SequenceSchema(self__.description,self__.element_schema,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__14189__auto__)),null));
}
});

active.clojure.config.SequenceSchema.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__14186__auto__,k__14187__auto__,G__14485){
var self__ = this;
var this__14186__auto____$1 = this;
var pred__14491 = cljs.core.keyword_identical_QMARK_;
var expr__14492 = k__14187__auto__;
if(cljs.core.truth_(pred__14491.call(null,new cljs.core.Keyword(null,"description","description",-1428560544),expr__14492))){
return (new active.clojure.config.SequenceSchema(G__14485,self__.element_schema,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__14491.call(null,new cljs.core.Keyword(null,"element-schema","element-schema",-865548916),expr__14492))){
return (new active.clojure.config.SequenceSchema(self__.description,G__14485,self__.__meta,self__.__extmap,null));
} else {
return (new active.clojure.config.SequenceSchema(self__.description,self__.element_schema,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__14187__auto__,G__14485),null));
}
}
});

active.clojure.config.SequenceSchema.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__14203__auto__){
var self__ = this;
var this__14203__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"description","description",-1428560544),self__.description],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"element-schema","element-schema",-865548916),self__.element_schema],null))], null),self__.__extmap));
});

active.clojure.config.SequenceSchema.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__14194__auto__,G__14485){
var self__ = this;
var this__14194__auto____$1 = this;
return (new active.clojure.config.SequenceSchema(self__.description,self__.element_schema,G__14485,self__.__extmap,self__.__hash));
});

active.clojure.config.SequenceSchema.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__14200__auto__,entry__14201__auto__){
var self__ = this;
var this__14200__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__14201__auto__)){
return this__14200__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__14201__auto__,(0)),cljs.core._nth.call(null,entry__14201__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__14200__auto____$1,entry__14201__auto__);
}
});

active.clojure.config.SequenceSchema.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"description","description",211970983,null),new cljs.core.Symbol(null,"element-schema","element-schema",774982611,null)], null);
});

active.clojure.config.SequenceSchema.cljs$lang$type = true;

active.clojure.config.SequenceSchema.cljs$lang$ctorPrSeq = (function (this__14281__auto__){
return (new cljs.core.List(null,"active.clojure.config/SequenceSchema",null,(1),null));
});

active.clojure.config.SequenceSchema.cljs$lang$ctorPrWriter = (function (this__14281__auto__,writer__14282__auto__){
return cljs.core._write.call(null,writer__14282__auto__,"active.clojure.config/SequenceSchema");
});

if(cljs.core._EQ_.call(null,false,new cljs.core.Keyword(null,"arrow-constructor?","arrow-constructor?",-1068727936).cljs$core$IFn$_invoke$arity$1(null))){
} else {
/**
 * A sequence schema describes a sequence config format.
 */
active.clojure.config.__GT_SequenceSchema = (function active$clojure$config$__GT_SequenceSchema(description,element_schema){
return (new active.clojure.config.SequenceSchema(description,element_schema,null,null,null));
});
}

/**
 * A sequence schema describes a sequence config format.
 */
active.clojure.config.map__GT_SequenceSchema = (function active$clojure$config$map__GT_SequenceSchema(G__14489){
return (new active.clojure.config.SequenceSchema(new cljs.core.Keyword(null,"description","description",-1428560544).cljs$core$IFn$_invoke$arity$1(G__14489),new cljs.core.Keyword(null,"element-schema","element-schema",-865548916).cljs$core$IFn$_invoke$arity$1(G__14489),null,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,G__14489,new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.Keyword(null,"element-schema","element-schema",-865548916))),null));
});

/**
 * Is object a `SequenceSchema` record? See [[active.clojure.config/make-sequence-schema]].
 */
active.clojure.config.sequence_schema_QMARK_ = (function active$clojure$config$sequence_schema_QMARK_(x__14283__auto__){
return (x__14283__auto__ instanceof active.clojure.config.SequenceSchema);
});

/**
 * Construct a `SequenceSchema` (A sequence schema describes a sequence config format.) record.
 * 
 * `description`: access via [[active.clojure.config/sequence-schema-description]]
 * `element-schema`: access via [[active.clojure.config/sequence-schema-element-schema]]
 */
active.clojure.config.make_sequence_schema = (function active$clojure$config$make_sequence_schema(description,element_schema){
return (new active.clojure.config.SequenceSchema(description,element_schema,null,null,null));
});



/**
 * Lens for the `description` field from a [[SequenceSchema]] record. See [[active.clojure.config/make-sequence-schema]].
 */
active.clojure.config.sequence_schema_description = active.clojure.lens.lens.call(null,(function (rec__14262__auto__){
if((rec__14262__auto__ instanceof active.clojure.config.SequenceSchema)){
} else {
throw (new Error("Wrong record type (rec__14262__auto__) passed to accessor (sequence-schema-description)."));
}

return rec__14262__auto__.description;
}),(function (data__14263__auto__,v__14264__auto__){
return (new active.clojure.config.SequenceSchema(v__14264__auto__,active.clojure.config.sequence_schema_element_schema.call(null,data__14263__auto__),null,null,null));
}));


/**
 * Lens for the `element-schema` field from a [[SequenceSchema]] record. See [[active.clojure.config/make-sequence-schema]].
 */
active.clojure.config.sequence_schema_element_schema = active.clojure.lens.lens.call(null,(function (rec__14262__auto__){
if((rec__14262__auto__ instanceof active.clojure.config.SequenceSchema)){
} else {
throw (new Error("Wrong record type (rec__14262__auto__) passed to accessor (sequence-schema-element-schema)."));
}

return rec__14262__auto__.element_schema;
}),(function (data__14263__auto__,v__14264__auto__){
return (new active.clojure.config.SequenceSchema(active.clojure.config.sequence_schema_description.call(null,data__14263__auto__),v__14264__auto__,null,null,null));
}));



active.clojure.config.sequence_schema = (function active$clojure$config$sequence_schema(desc,el_schema){
return active.clojure.config.make_sequence_schema.call(null,desc,el_schema);
});
active.clojure.config.schema_reduce = (function active$clojure$config$schema_reduce(schema,range,path,f,res,val){
if(cljs.core.truth_(active.clojure.config.map_schema_QMARK_.call(null,schema))){
var cmap = active.clojure.config.range_completer.call(null,range).call(null,range,path,val);
var settings = active.clojure.config.map_schema_settings_map.call(null,schema);
var sections = active.clojure.config.map_schema_sections_map.call(null,schema);
if(cljs.core.not.call(null,active.clojure.config.range_error_QMARK_.call(null,cmap))){
} else {
active.clojure.condition.assertion_violation.call(null,null,["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,cmap))].join(''),active.clojure.condition.make_location_condition.call(null,"active.clojure.config","/private/var/folders/fp/cxskw0351hv72t2yybts104w0000gn/T/form-init18044649893498323638.clj",538),cljs.core.list(new cljs.core.Symbol(null,"not","not",1044554643,null),cljs.core.list(new cljs.core.Symbol(null,"range-error?","range-error?",527793672,null),new cljs.core.Symbol(null,"cmap","cmap",1947829886,null))));
}

return cljs.core.reduce.call(null,((function (cmap,settings,sections){
return (function (res__$1,p__14495){
var vec__14496 = p__14495;
var k = cljs.core.nth.call(null,vec__14496,(0),null);
var v = cljs.core.nth.call(null,vec__14496,(1),null);
var temp__5455__auto__ = cljs.core.get.call(null,settings,k);
if(cljs.core.truth_(temp__5455__auto__)){
var setting = temp__5455__auto__;
return active.clojure.config.range_reduce.call(null,active.clojure.config.setting_range.call(null,setting)).call(null,active.clojure.config.setting_range.call(null,setting),cljs.core.conj.call(null,path,active.clojure.config.setting_key.call(null,setting)),f,res__$1,v);
} else {
var section = cljs.core.get.call(null,sections,k);
var schema__$1 = active.clojure.config.section_schema.call(null,section);
return active.clojure.config.schema_reduce.call(null,schema__$1,active.clojure.config.schema_range.call(null,schema__$1),cljs.core.conj.call(null,path,active.clojure.config.section_key.call(null,section)),f,res__$1,v);
}
});})(cmap,settings,sections))
,res,cmap);
} else {
if(cljs.core.truth_(active.clojure.config.sequence_schema_QMARK_.call(null,schema))){
var v = active.clojure.config.range_completer.call(null,range).call(null,range,path,val);
var element_schema = active.clojure.config.sequence_schema_element_schema.call(null,schema);
var element_range = active.clojure.config.schema_range.call(null,element_schema);
if(cljs.core.not.call(null,active.clojure.config.range_error_QMARK_.call(null,v))){
} else {
active.clojure.condition.assertion_violation.call(null,null,["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,v))].join(''),active.clojure.condition.make_location_condition.call(null,"active.clojure.config","/private/var/folders/fp/cxskw0351hv72t2yybts104w0000gn/T/form-init18044649893498323638.clj",560),cljs.core.list(new cljs.core.Symbol(null,"not","not",1044554643,null),cljs.core.list(new cljs.core.Symbol(null,"range-error?","range-error?",527793672,null),new cljs.core.Symbol(null,"v","v",1661996586,null))));
}

return cljs.core.reduce.call(null,((function (v,element_schema,element_range){
return (function (res__$1,p__14499){
var vec__14500 = p__14499;
var i = cljs.core.nth.call(null,vec__14500,(0),null);
var x = cljs.core.nth.call(null,vec__14500,(1),null);
return active.clojure.config.schema_reduce.call(null,element_schema,element_range,cljs.core.conj.call(null,path,i),f,res__$1,x);
});})(v,element_schema,element_range))
,res,cljs.core.map_indexed.call(null,cljs.core.vector,v));
} else {
return null;
}
}
});
/**
 * Range for a configuration object matching a schema.
 */
active.clojure.config.schema_range = (function active$clojure$config$schema_range(schema){
if(cljs.core.truth_(active.clojure.config.map_schema_QMARK_.call(null,schema))){
return active.clojure.config.make_range.call(null,active.clojure.config.map_schema_description.call(null,schema),(function (range,path,val){
if((val == null)){
return active.clojure.config.normalize_AMPERSAND_check_config_object.call(null,schema,cljs.core.PersistentVector.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
} else {
if(cljs.core.map_QMARK_.call(null,val)){
return active.clojure.config.normalize_AMPERSAND_check_config_object.call(null,schema,cljs.core.PersistentVector.EMPTY,val);
} else {
return active.clojure.config.make_range_error.call(null,range,path,val);

}
}
}),cljs.core.partial.call(null,active.clojure.config.schema_reduce,schema));
} else {
if(cljs.core.truth_(active.clojure.config.sequence_schema_QMARK_.call(null,schema))){
return active.clojure.config.sequence_of_range.call(null,active.clojure.config.schema_range.call(null,active.clojure.config.sequence_schema_element_schema.call(null,schema)));
} else {
return null;
}
}
});
/**
 * Construct a map schema.
 * 
 *   - `description` is a human-readable description
 *   - `element-list' is a list of the [[Setting]]s and [[Section]]s of the schema
 */
active.clojure.config.schema = (function active$clojure$config$schema(var_args){
var args__4502__auto__ = [];
var len__4499__auto___14505 = arguments.length;
var i__4500__auto___14506 = (0);
while(true){
if((i__4500__auto___14506 < len__4499__auto___14505)){
args__4502__auto__.push((arguments[i__4500__auto___14506]));

var G__14507 = (i__4500__auto___14506 + (1));
i__4500__auto___14506 = G__14507;
continue;
} else {
}
break;
}

var argseq__4503__auto__ = ((((1) < args__4502__auto__.length))?(new cljs.core.IndexedSeq(args__4502__auto__.slice((1)),(0),null)):null);
return active.clojure.config.schema.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4503__auto__);
});

active.clojure.config.schema.cljs$core$IFn$_invoke$arity$variadic = (function (description,element_list){
if(typeof description === 'string'){
} else {
throw (new Error("Assert failed: (string? description)"));
}

var settings = cljs.core.filter.call(null,active.clojure.config.setting_QMARK_,element_list);
var sections = cljs.core.filter.call(null,active.clojure.config.section_QMARK_,element_list);
return active.clojure.config.make_map_schema.call(null,description,cljs.core.set.call(null,settings),cljs.core.zipmap.call(null,cljs.core.map.call(null,active.clojure.config.setting_key,settings),settings),cljs.core.set.call(null,sections),cljs.core.zipmap.call(null,cljs.core.map.call(null,active.clojure.config.section_key,sections),sections));
});

active.clojure.config.schema.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
active.clojure.config.schema.cljs$lang$applyTo = (function (seq14503){
var G__14504 = cljs.core.first.call(null,seq14503);
var seq14503__$1 = cljs.core.next.call(null,seq14503);
var self__4486__auto__ = this;
return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14504,seq14503__$1);
});

/**
 * Merge two configs into one, with the latter taking precedence.
 * 
 *   This helper assumes there are no profiles.
 */
active.clojure.config.merge_config_objects_sans_profiles = (function active$clojure$config$merge_config_objects_sans_profiles(schema,path,c1,c2){
if(cljs.core.truth_(active.clojure.config.map_schema_QMARK_.call(null,schema))){
if(cljs.core.map_QMARK_.call(null,c1)){
} else {
active.clojure.condition.error.call(null,new cljs.core.Symbol("active.clojure.config","merge-config-objects-sans-profiles","active.clojure.config/merge-config-objects-sans-profiles",-394760467,null),["configuration at ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(path)," is not a map: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(c1)].join(''),path,c1);
}

if(cljs.core.map_QMARK_.call(null,c2)){
} else {
active.clojure.condition.error.call(null,new cljs.core.Symbol("active.clojure.config","merge-config-objects-sans-profiles","active.clojure.config/merge-config-objects-sans-profiles",-394760467,null),["configuration at ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(path)," is not a map: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(c2)].join(''),path,c2);
}

var sections_map = active.clojure.config.map_schema_sections_map.call(null,schema);
var settings_map = active.clojure.config.map_schema_settings_map.call(null,schema);
var c = cljs.core.PersistentArrayMap.EMPTY;
var all_keys = cljs.core.seq.call(null,clojure.set.union.call(null,cljs.core.set.call(null,cljs.core.keys.call(null,c1)),cljs.core.set.call(null,cljs.core.keys.call(null,c2))));
while(true){
if(all_keys){
var key = cljs.core.first.call(null,all_keys);
var val1 = cljs.core.get.call(null,c1,key);
var val2 = cljs.core.get.call(null,c2,key);
if(cljs.core.contains_QMARK_.call(null,settings_map,key)){
var G__14508 = cljs.core.assoc.call(null,c,key,((cljs.core.contains_QMARK_.call(null,c2,key))?val2:val1));
var G__14509 = cljs.core.next.call(null,all_keys);
c = G__14508;
all_keys = G__14509;
continue;
} else {
var temp__5455__auto__ = cljs.core.get.call(null,sections_map,key);
if(cljs.core.truth_(temp__5455__auto__)){
var section = temp__5455__auto__;
var G__14510 = cljs.core.assoc.call(null,c,key,active.clojure.config.merge_config_objects_sans_profiles.call(null,active.clojure.config.section_schema.call(null,section),cljs.core.conj.call(null,cljs.core.vec.call(null,path),key),(function (){var or__3922__auto__ = val1;
if(cljs.core.truth_(or__3922__auto__)){
return or__3922__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),(function (){var or__3922__auto__ = val2;
if(cljs.core.truth_(or__3922__auto__)){
return or__3922__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})()));
var G__14511 = cljs.core.next.call(null,all_keys);
c = G__14510;
all_keys = G__14511;
continue;
} else {
return active.clojure.condition.error.call(null,new cljs.core.Symbol("active.clojure.config","merge-config-objects-sans-profiles","active.clojure.config/merge-config-objects-sans-profiles",-394760467,null),["unknown path ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.vec.call(null,cljs.core.conj.call(null,path,key)))," in config"].join(''),cljs.core.conj.call(null,path,key),((cljs.core.contains_QMARK_.call(null,c1,key))?val1:val2),null,((cljs.core.contains_QMARK_.call(null,c1,key))?c1:c2));
}
}
} else {
return c;
}
break;
}
} else {
if(cljs.core.truth_(active.clojure.config.sequence_schema_QMARK_.call(null,schema))){
if(cljs.core.truth_(active.clojure.config.sequable_QMARK_.call(null,c1))){
} else {
active.clojure.condition.error.call(null,new cljs.core.Symbol("active.clojure.config","merge-config-objects-sans-profiles","active.clojure.config/merge-config-objects-sans-profiles",-394760467,null),["configuration at ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(path)," is not a sequence: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,c1))].join(''),path,c1);
}

if(cljs.core.truth_(active.clojure.config.sequable_QMARK_.call(null,c2))){
} else {
active.clojure.condition.error.call(null,new cljs.core.Symbol("active.clojure.config","merge-config-objects-sans-profiles","active.clojure.config/merge-config-objects-sans-profiles",-394760467,null),["configuration at ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(path)," is not a sequence: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,c2))].join(''),path,c2);
}

return cljs.core.concat.call(null,c1,c2);
} else {
return null;
}
}
});
/**
 * Merge several config maps into one, with the latter taking precedence.
 */
active.clojure.config.merge_config_objects = (function active$clojure$config$merge_config_objects(var_args){
var G__14517 = arguments.length;
switch (G__14517) {
case 2:
return active.clojure.config.merge_config_objects.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return active.clojure.config.merge_config_objects.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__4514__auto__ = [];
var len__4499__auto___14519 = arguments.length;
var i__4500__auto___14520 = (0);
while(true){
if((i__4500__auto___14520 < len__4499__auto___14519)){
args_arr__4514__auto__.push((arguments[i__4500__auto___14520]));

var G__14521 = (i__4500__auto___14520 + (1));
i__4500__auto___14520 = G__14521;
continue;
} else {
}
break;
}

var argseq__4515__auto__ = (new cljs.core.IndexedSeq(args_arr__4514__auto__.slice((3)),(0),null));
return active.clojure.config.merge_config_objects.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4515__auto__);

}
});

active.clojure.config.merge_config_objects.cljs$core$IFn$_invoke$arity$2 = (function (schema,c){
return c;
});

active.clojure.config.merge_config_objects.cljs$core$IFn$_invoke$arity$3 = (function (schema,c1,c2){
var profiles_1 = cljs.core.get.call(null,c1,new cljs.core.Keyword(null,"profiles","profiles",507634713));
var profiles_2 = cljs.core.get.call(null,c2,new cljs.core.Keyword(null,"profiles","profiles",507634713));
return cljs.core.assoc.call(null,active.clojure.config.merge_config_objects_sans_profiles.call(null,schema,cljs.core.PersistentVector.EMPTY,cljs.core.dissoc.call(null,c1,new cljs.core.Keyword(null,"profiles","profiles",507634713)),cljs.core.dissoc.call(null,c2,new cljs.core.Keyword(null,"profiles","profiles",507634713))),new cljs.core.Keyword(null,"profiles","profiles",507634713),cljs.core.merge.call(null,profiles_1,profiles_2));
});

active.clojure.config.merge_config_objects.cljs$core$IFn$_invoke$arity$variadic = (function (schema,c1,c2,cs){
return cljs.core.reduce.call(null,cljs.core.partial.call(null,active.clojure.config.merge_config_objects,schema),cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [c1,c2], null),cs));
});

/** @this {Function} */
active.clojure.config.merge_config_objects.cljs$lang$applyTo = (function (seq14513){
var G__14514 = cljs.core.first.call(null,seq14513);
var seq14513__$1 = cljs.core.next.call(null,seq14513);
var G__14515 = cljs.core.first.call(null,seq14513__$1);
var seq14513__$2 = cljs.core.next.call(null,seq14513__$1);
var G__14516 = cljs.core.first.call(null,seq14513__$2);
var seq14513__$3 = cljs.core.next.call(null,seq14513__$2);
var self__4486__auto__ = this;
return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14514,G__14515,G__14516,seq14513__$3);
});

active.clojure.config.merge_config_objects.cljs$lang$maxFixedArity = (3);

/**
 * Apply named profiles within a config map.
 */
active.clojure.config.apply_profiles = (function active$clojure$config$apply_profiles(schema,config_object,profile_names){
var temp__5455__auto__ = new cljs.core.Keyword(null,"profiles","profiles",507634713).cljs$core$IFn$_invoke$arity$1(config_object);
if(cljs.core.truth_(temp__5455__auto__)){
var profile_map = temp__5455__auto__;
var config_object__$1 = cljs.core.dissoc.call(null,config_object,new cljs.core.Keyword(null,"profiles","profiles",507634713));
var profiles = cljs.core.map.call(null,((function (config_object__$1,profile_map,temp__5455__auto__){
return (function (n){
var or__3922__auto__ = profile_map.call(null,n);
if(cljs.core.truth_(or__3922__auto__)){
return or__3922__auto__;
} else {
return active.clojure.condition.error.call(null,new cljs.core.Symbol("active.clojure.config","apply-profiles","active.clojure.config/apply-profiles",1460321674,null),"profile does not exist",n);
}
});})(config_object__$1,profile_map,temp__5455__auto__))
,profile_names);
return cljs.core.reduce.call(null,cljs.core.partial.call(null,active.clojure.config.merge_config_objects_sans_profiles,schema,cljs.core.PersistentVector.EMPTY),config_object__$1,profiles);
} else {
return config_object;
}
});
active.clojure.config.complete_section = (function active$clojure$config$complete_section(inherited_map,path,section){
var key = active.clojure.config.section_key.call(null,section);
var temp__5455__auto__ = cljs.core.get.call(null,inherited_map,key);
if(cljs.core.truth_(temp__5455__auto__)){
var entry = temp__5455__auto__;
return cljs.core.PersistentArrayMap.createAsIfByAssoc([key,entry]);
} else {
var res = active.clojure.config.normalize_AMPERSAND_check_config_object_internal.call(null,active.clojure.config.section_schema.call(null,section),cljs.core.PersistentArrayMap.EMPTY,inherited_map,cljs.core.concat.call(null,path,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [key], null)));
if(cljs.core.not.call(null,active.clojure.config.range_error_QMARK_.call(null,res))){
} else {
active.clojure.condition.assertion_violation.call(null,null,["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,res))].join(''),active.clojure.condition.make_location_condition.call(null,"active.clojure.config","/private/var/folders/fp/cxskw0351hv72t2yybts104w0000gn/T/form-init18044649893498323638.clj",696),cljs.core.list(new cljs.core.Symbol(null,"not","not",1044554643,null),cljs.core.list(new cljs.core.Symbol(null,"range-error?","range-error?",527793672,null),new cljs.core.Symbol(null,"res","res",245523648,null))));
}

return cljs.core.PersistentArrayMap.createAsIfByAssoc([key,res]);
}
});
active.clojure.config.complete_settings = (function active$clojure$config$complete_settings(inherited_map,settings_map){
return cljs.core.zipmap.call(null,cljs.core.keys.call(null,settings_map),cljs.core.map.call(null,(function (setting){
var or__3922__auto__ = cljs.core.get.call(null,inherited_map,active.clojure.config.setting_key.call(null,setting));
if(cljs.core.truth_(or__3922__auto__)){
return or__3922__auto__;
} else {
return active.clojure.config.setting_default_value.call(null,setting);
}
}),cljs.core.vals.call(null,settings_map)));
});
active.clojure.config.check_section = (function active$clojure$config$check_section(section,val,inherited_map,path){
return active.clojure.config.normalize_AMPERSAND_check_config_object_internal.call(null,active.clojure.config.section_schema.call(null,section),val,inherited_map,cljs.core.conj.call(null,cljs.core.vec.call(null,path),active.clojure.config.section_key.call(null,section)));
});
active.clojure.config.normalize_AMPERSAND_check_config_object_internal = (function active$clojure$config$normalize_AMPERSAND_check_config_object_internal(schema,config,inherited_map,path){
if(cljs.core.truth_(active.clojure.config.map_schema_QMARK_.call(null,schema))){
if(((!(cljs.core.map_QMARK_.call(null,config))) && (!((config == null))))){
return active.clojure.config.make_range_error.call(null,new cljs.core.Keyword(null,"not-a-map","not-a-map",-1206682743),path,config);
} else {
var sections_map = active.clojure.config.map_schema_sections_map.call(null,schema);
var res = (function (){var entries = cljs.core.seq.call(null,config);
var c = cljs.core.PersistentArrayMap.EMPTY;
var inherited_map__$1 = inherited_map;
var settings_map = active.clojure.config.map_schema_settings_map.call(null,schema);
while(true){
if(entries){
var vec__14522 = cljs.core.first.call(null,entries);
var key = cljs.core.nth.call(null,vec__14522,(0),null);
var val = cljs.core.nth.call(null,vec__14522,(1),null);
var temp__5455__auto__ = cljs.core.get.call(null,settings_map,key);
if(cljs.core.truth_(temp__5455__auto__)){
var setting = temp__5455__auto__;
var range = active.clojure.config.setting_range.call(null,setting);
var res = active.clojure.config.range_completer.call(null,range).call(null,range,cljs.core.concat.call(null,path,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [key], null)),val);
if(cljs.core.truth_(active.clojure.config.range_error_QMARK_.call(null,res))){
return res;
} else {
var G__14531 = cljs.core.next.call(null,entries);
var G__14532 = cljs.core.assoc.call(null,c,key,res);
var G__14533 = (cljs.core.truth_(active.clojure.config.setting_inherit_QMARK_.call(null,setting))?cljs.core.assoc.call(null,inherited_map__$1,key,val):inherited_map__$1);
var G__14534 = cljs.core.dissoc.call(null,settings_map,key);
entries = G__14531;
c = G__14532;
inherited_map__$1 = G__14533;
settings_map = G__14534;
continue;
}
} else {
if(cljs.core.contains_QMARK_.call(null,sections_map,key)){
var G__14535 = cljs.core.next.call(null,entries);
var G__14536 = c;
var G__14537 = inherited_map__$1;
var G__14538 = settings_map;
entries = G__14535;
c = G__14536;
inherited_map__$1 = G__14537;
settings_map = G__14538;
continue;
} else {
return active.clojure.config.make_range_error.call(null,new cljs.core.Keyword(null,"unknown-section","unknown-section",-1835167562),cljs.core.concat.call(null,path,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [key], null)),val);
}
}
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,c,active.clojure.config.complete_settings.call(null,inherited_map__$1,settings_map)),inherited_map__$1,settings_map], null);
}
break;
}
})();
if(cljs.core.truth_(active.clojure.config.range_error_QMARK_.call(null,res))){
return res;
} else {
var vec__14525 = res;
var c = cljs.core.nth.call(null,vec__14525,(0),null);
var inherited_map__$1 = cljs.core.nth.call(null,vec__14525,(1),null);
var settings_map = cljs.core.nth.call(null,vec__14525,(2),null);
var entries = cljs.core.seq.call(null,config);
var c__$1 = c;
var inherited_map__$2 = inherited_map__$1;
var sections_map__$1 = sections_map;
while(true){
if(entries){
var vec__14528 = cljs.core.first.call(null,entries);
var key = cljs.core.nth.call(null,vec__14528,(0),null);
var val = cljs.core.nth.call(null,vec__14528,(1),null);
var temp__5455__auto__ = cljs.core.get.call(null,sections_map__$1,key);
if(cljs.core.truth_(temp__5455__auto__)){
var section = temp__5455__auto__;
var res__$1 = active.clojure.config.check_section.call(null,section,val,inherited_map__$2,path);
if(cljs.core.truth_(active.clojure.config.range_error_QMARK_.call(null,res__$1))){
return res__$1;
} else {
var G__14539 = cljs.core.next.call(null,entries);
var G__14540 = cljs.core.assoc.call(null,c__$1,key,res__$1);
var G__14541 = (cljs.core.truth_(active.clojure.config.section_inherit_QMARK_.call(null,section))?cljs.core.assoc.call(null,inherited_map__$2,key,res__$1):inherited_map__$2);
var G__14542 = cljs.core.dissoc.call(null,sections_map__$1,key);
entries = G__14539;
c__$1 = G__14540;
inherited_map__$2 = G__14541;
sections_map__$1 = G__14542;
continue;
}
} else {
var G__14543 = cljs.core.next.call(null,entries);
var G__14544 = c__$1;
var G__14545 = inherited_map__$2;
var G__14546 = sections_map__$1;
entries = G__14543;
c__$1 = G__14544;
inherited_map__$2 = G__14545;
sections_map__$1 = G__14546;
continue;
}
} else {
return cljs.core.apply.call(null,cljs.core.merge,c__$1,cljs.core.map.call(null,cljs.core.partial.call(null,active.clojure.config.complete_section,inherited_map__$2,path),cljs.core.vals.call(null,sections_map__$1)));
}
break;
}
}
}
} else {
if(cljs.core.truth_(active.clojure.config.sequence_schema_QMARK_.call(null,schema))){
var el_schema = active.clojure.config.sequence_schema_element_schema.call(null,schema);
var idx = (0);
var els = config;
var res = cljs.core.transient$.call(null,cljs.core.PersistentVector.EMPTY);
while(true){
if(cljs.core.empty_QMARK_.call(null,els)){
return cljs.core.persistent_BANG_.call(null,res);
} else {
var r = active.clojure.config.normalize_AMPERSAND_check_config_object_internal.call(null,el_schema,cljs.core.first.call(null,els),inherited_map,cljs.core.concat.call(null,path,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [idx], null)));
if(cljs.core.truth_(active.clojure.config.range_error_QMARK_.call(null,r))){
return r;
} else {
var G__14547 = ((1) + idx);
var G__14548 = cljs.core.rest.call(null,els);
var G__14549 = cljs.core.conj_BANG_.call(null,res,r);
idx = G__14547;
els = G__14548;
res = G__14549;
continue;
}
}
break;
}
} else {
return null;
}
}
});
/**
 * Normalize and check the validity of a configuration object.
 * 
 *   In  the result, every setting has an associated value.
 */
active.clojure.config.normalize_AMPERSAND_check_config_object = (function active$clojure$config$normalize_AMPERSAND_check_config_object(var_args){
var G__14551 = arguments.length;
switch (G__14551) {
case 3:
return active.clojure.config.normalize_AMPERSAND_check_config_object.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 5:
return active.clojure.config.normalize_AMPERSAND_check_config_object.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

active.clojure.config.normalize_AMPERSAND_check_config_object.cljs$core$IFn$_invoke$arity$3 = (function (schema,profile_names,config){
return active.clojure.config.normalize_AMPERSAND_check_config_object.call(null,schema,profile_names,config,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentVector.EMPTY);
});

active.clojure.config.normalize_AMPERSAND_check_config_object.cljs$core$IFn$_invoke$arity$5 = (function (schema,profile_names,config,inherited_map,path){
var config__$1 = active.clojure.config.apply_profiles.call(null,schema,config,profile_names);
return active.clojure.config.normalize_AMPERSAND_check_config_object_internal.call(null,schema,config__$1,inherited_map,path);
});

active.clojure.config.normalize_AMPERSAND_check_config_object.cljs$lang$maxFixedArity = 5;




/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
active.clojure.config.Configuration = (function (object,schema,__meta,__extmap,__hash){
this.object = object;
this.schema = schema;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
active.clojure.config.Configuration.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__14195__auto__,k__14196__auto__){
var self__ = this;
var this__14195__auto____$1 = this;
return this__14195__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__14196__auto__,null);
});

active.clojure.config.Configuration.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__14197__auto__,k14554,else__14198__auto__){
var self__ = this;
var this__14197__auto____$1 = this;
var G__14558 = k14554;
var G__14558__$1 = (((G__14558 instanceof cljs.core.Keyword))?G__14558.fqn:null);
switch (G__14558__$1) {
case "object":
return self__.object;

break;
case "schema":
return self__.schema;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k14554,else__14198__auto__);

}
});

active.clojure.config.Configuration.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__14205__auto__,writer__14206__auto__,opts__14207__auto__){
var self__ = this;
var this__14205__auto____$1 = this;
var pr_pair__14208__auto__ = ((function (this__14205__auto____$1){
return (function (keyval__14209__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__14206__auto__,cljs.core.pr_writer,""," ","",opts__14207__auto__,keyval__14209__auto__);
});})(this__14205__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__14206__auto__,pr_pair__14208__auto__,"#active.clojure.config.Configuration{",", ","}",opts__14207__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"object","object",1474613949),self__.object],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null))], null),self__.__extmap));
});

active.clojure.config.Configuration.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__14553){
var self__ = this;
var G__14553__$1 = this;
return (new cljs.core.RecordIter((0),G__14553__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"object","object",1474613949),new cljs.core.Keyword(null,"schema","schema",-1582001791)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

active.clojure.config.Configuration.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__14193__auto__){
var self__ = this;
var this__14193__auto____$1 = this;
return self__.__meta;
});

active.clojure.config.Configuration.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__14190__auto__){
var self__ = this;
var this__14190__auto____$1 = this;
return (new active.clojure.config.Configuration(self__.object,self__.schema,self__.__meta,self__.__extmap,self__.__hash));
});

active.clojure.config.Configuration.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__14199__auto__){
var self__ = this;
var this__14199__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});

active.clojure.config.Configuration.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__14191__auto__){
var self__ = this;
var this__14191__auto____$1 = this;
var h__4030__auto__ = self__.__hash;
if(!((h__4030__auto__ == null))){
return h__4030__auto__;
} else {
var h__4030__auto____$1 = ((function (h__4030__auto__,this__14191__auto____$1){
return (function (coll__14192__auto__){
return (-338548218 ^ cljs.core.hash_unordered_coll.call(null,coll__14192__auto__));
});})(h__4030__auto__,this__14191__auto____$1))
.call(null,this__14191__auto____$1);
self__.__hash = h__4030__auto____$1;

return h__4030__auto____$1;
}
});

active.clojure.config.Configuration.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this14555,other14556){
var self__ = this;
var this14555__$1 = this;
return ((!((other14556 == null))) && ((this14555__$1.constructor === other14556.constructor)) && (cljs.core._EQ_.call(null,this14555__$1.object,other14556.object)) && (cljs.core._EQ_.call(null,this14555__$1.schema,other14556.schema)) && (cljs.core._EQ_.call(null,this14555__$1.__extmap,other14556.__extmap)));
});

active.clojure.config.Configuration.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__14188__auto__,k__14189__auto__){
var self__ = this;
var this__14188__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),null,new cljs.core.Keyword(null,"object","object",1474613949),null], null), null),k__14189__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__14188__auto____$1),self__.__meta),k__14189__auto__);
} else {
return (new active.clojure.config.Configuration(self__.object,self__.schema,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__14189__auto__)),null));
}
});

active.clojure.config.Configuration.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__14186__auto__,k__14187__auto__,G__14553){
var self__ = this;
var this__14186__auto____$1 = this;
var pred__14559 = cljs.core.keyword_identical_QMARK_;
var expr__14560 = k__14187__auto__;
if(cljs.core.truth_(pred__14559.call(null,new cljs.core.Keyword(null,"object","object",1474613949),expr__14560))){
return (new active.clojure.config.Configuration(G__14553,self__.schema,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__14559.call(null,new cljs.core.Keyword(null,"schema","schema",-1582001791),expr__14560))){
return (new active.clojure.config.Configuration(self__.object,G__14553,self__.__meta,self__.__extmap,null));
} else {
return (new active.clojure.config.Configuration(self__.object,self__.schema,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__14187__auto__,G__14553),null));
}
}
});

active.clojure.config.Configuration.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__14203__auto__){
var self__ = this;
var this__14203__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"object","object",1474613949),self__.object],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null))], null),self__.__extmap));
});

active.clojure.config.Configuration.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__14194__auto__,G__14553){
var self__ = this;
var this__14194__auto____$1 = this;
return (new active.clojure.config.Configuration(self__.object,self__.schema,G__14553,self__.__extmap,self__.__hash));
});

active.clojure.config.Configuration.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__14200__auto__,entry__14201__auto__){
var self__ = this;
var this__14200__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__14201__auto__)){
return this__14200__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__14201__auto__,(0)),cljs.core._nth.call(null,entry__14201__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__14200__auto____$1,entry__14201__auto__);
}
});

active.clojure.config.Configuration.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"object","object",-1179821820,null),new cljs.core.Symbol(null,"schema","schema",58529736,null)], null);
});

active.clojure.config.Configuration.cljs$lang$type = true;

active.clojure.config.Configuration.cljs$lang$ctorPrSeq = (function (this__14281__auto__){
return (new cljs.core.List(null,"active.clojure.config/Configuration",null,(1),null));
});

active.clojure.config.Configuration.cljs$lang$ctorPrWriter = (function (this__14281__auto__,writer__14282__auto__){
return cljs.core._write.call(null,writer__14282__auto__,"active.clojure.config/Configuration");
});

if(cljs.core._EQ_.call(null,false,new cljs.core.Keyword(null,"arrow-constructor?","arrow-constructor?",-1068727936).cljs$core$IFn$_invoke$arity$1(null))){
} else {
/**
 * Validated and expanded configuration object.
 */
active.clojure.config.__GT_Configuration = (function active$clojure$config$__GT_Configuration(object,schema){
return (new active.clojure.config.Configuration(object,schema,null,null,null));
});
}

/**
 * Validated and expanded configuration object.
 */
active.clojure.config.map__GT_Configuration = (function active$clojure$config$map__GT_Configuration(G__14557){
return (new active.clojure.config.Configuration(new cljs.core.Keyword(null,"object","object",1474613949).cljs$core$IFn$_invoke$arity$1(G__14557),new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__14557),null,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,G__14557,new cljs.core.Keyword(null,"object","object",1474613949),new cljs.core.Keyword(null,"schema","schema",-1582001791))),null));
});

/**
 * Is object a `Configuration` record? See [[active.clojure.config/really-make-configuration]].
 */
active.clojure.config.configuration_QMARK_ = (function active$clojure$config$configuration_QMARK_(x__14283__auto__){
return (x__14283__auto__ instanceof active.clojure.config.Configuration);
});

/**
 * Construct a `Configuration` (Validated and expanded configuration object.) record.
 * 
 * `object`: access via [[active.clojure.config/configuration-object]]
 * `schema`: access via [[active.clojure.config/configuration-schema]]
 */
active.clojure.config.really_make_configuration = (function active$clojure$config$really_make_configuration(object,schema){
return (new active.clojure.config.Configuration(object,schema,null,null,null));
});



/**
 * Lens for the `object` field from a [[Configuration]] record. See [[active.clojure.config/really-make-configuration]].
 */
active.clojure.config.configuration_object = active.clojure.lens.lens.call(null,(function (rec__14262__auto__){
if((rec__14262__auto__ instanceof active.clojure.config.Configuration)){
} else {
throw (new Error("Wrong record type (rec__14262__auto__) passed to accessor (configuration-object)."));
}

return rec__14262__auto__.object;
}),(function (data__14263__auto__,v__14264__auto__){
return (new active.clojure.config.Configuration(v__14264__auto__,active.clojure.config.configuration_schema.call(null,data__14263__auto__),null,null,null));
}));


/**
 * Lens for the `schema` field from a [[Configuration]] record. See [[active.clojure.config/really-make-configuration]].
 */
active.clojure.config.configuration_schema = active.clojure.lens.lens.call(null,(function (rec__14262__auto__){
if((rec__14262__auto__ instanceof active.clojure.config.Configuration)){
} else {
throw (new Error("Wrong record type (rec__14262__auto__) passed to accessor (configuration-schema)."));
}

return rec__14262__auto__.schema;
}),(function (data__14263__auto__,v__14264__auto__){
return (new active.clojure.config.Configuration(active.clojure.config.configuration_object.call(null,data__14263__auto__),v__14264__auto__,null,null,null));
}));



/**
 * Make a configuration from a map.
 */
active.clojure.config.make_configuration = (function active$clojure$config$make_configuration(schema,profile_names,config_object){
var res = active.clojure.config.normalize_AMPERSAND_check_config_object.call(null,schema,profile_names,config_object);
if(cljs.core.truth_(active.clojure.config.range_error_QMARK_.call(null,res))){
return active.clojure.condition.error.call(null,new cljs.core.Symbol("active.clojure.config","make-configuration","active.clojure.config/make-configuration",-1176808890,null),["range error at path ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.vec.call(null,active.clojure.config.range_error_path.call(null,res)))," in configuration map: ","value ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,active.clojure.config.range_error_value.call(null,res)))," should be in range ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var r = active.clojure.config.range_error_range.call(null,res);
if(cljs.core.truth_(active.clojure.config.range_QMARK_.call(null,r))){
return active.clojure.config.range_description.call(null,r);
} else {
return cljs.core.pr_str.call(null,r);
}
})())," but isn't"].join(''),res);
} else {
return active.clojure.config.really_make_configuration.call(null,res,schema);
}
});
/**
 * Returns sequence of triples `[path-vector version-1 version-2]` of settings that differ.
 * Handles some ranges more intelligently.
 */
active.clojure.config.diff_setting_values = (function active$clojure$config$diff_setting_values(setting,path,v1,v2){
return cljs.core.map.call(null,(function (p__14563){
var vec__14564 = p__14563;
var p_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__14564,(0),null);
var v1_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__14564,(1),null);
var v2_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__14564,(2),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.call(null,path,p_SINGLEQUOTE_),v1_SINGLEQUOTE_,v2_SINGLEQUOTE_], null);
}),active.clojure.config.range_diff.call(null,active.clojure.config.setting_range.call(null,setting)).call(null,v1,v2));
});
/**
 * Returns sequence of triples `[path-vector version-1 version-2]` of settings that differ.
 * 
 *   The config objects must be validated and completed.
 */
active.clojure.config.diff_configuration_objects = (function active$clojure$config$diff_configuration_objects(schema,config_object_1,config_object_2){
if(cljs.core.truth_(active.clojure.config.map_schema_QMARK_.call(null,schema))){
return cljs.core.concat.call(null,cljs.core.filter.call(null,cljs.core.identity,cljs.core.mapcat.call(null,(function (p__14567){
var vec__14568 = p__14567;
var key = cljs.core.nth.call(null,vec__14568,(0),null);
var setting = cljs.core.nth.call(null,vec__14568,(1),null);
var v1 = cljs.core.get.call(null,config_object_1,key);
var v2 = cljs.core.get.call(null,config_object_2,key);
if(cljs.core.not_EQ_.call(null,v1,v2)){
return active.clojure.config.diff_setting_values.call(null,setting,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [key], null),v1,v2);
} else {
return cljs.core.PersistentVector.EMPTY;
}
}),active.clojure.config.map_schema_settings_map.call(null,schema))),cljs.core.mapcat.call(null,(function (p__14571){
var vec__14572 = p__14571;
var key = cljs.core.nth.call(null,vec__14572,(0),null);
var section = cljs.core.nth.call(null,vec__14572,(1),null);
return cljs.core.map.call(null,((function (vec__14572,key,section){
return (function (p__14575){
var vec__14576 = p__14575;
var path = cljs.core.nth.call(null,vec__14576,(0),null);
var v1 = cljs.core.nth.call(null,vec__14576,(1),null);
var v2 = cljs.core.nth.call(null,vec__14576,(2),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.vec.call(null,cljs.core.cons.call(null,key,path)),v1,v2], null);
});})(vec__14572,key,section))
,active.clojure.config.diff_configuration_objects.call(null,active.clojure.config.section_schema.call(null,section),cljs.core.get.call(null,config_object_1,key),cljs.core.get.call(null,config_object_2,key)));
}),active.clojure.config.map_schema_sections_map.call(null,schema)));
} else {
if(cljs.core.truth_(active.clojure.config.sequence_schema_QMARK_.call(null,schema))){
var count1 = cljs.core.count.call(null,config_object_1);
var count2 = cljs.core.count.call(null,config_object_2);
var common_count = (function (){var x__4009__auto__ = count1;
var y__4010__auto__ = count2;
return ((x__4009__auto__ < y__4010__auto__) ? x__4009__auto__ : y__4010__auto__);
})();
var el_schema = active.clojure.config.sequence_schema_element_schema.call(null,schema);
var triples_common = cljs.core.mapcat.call(null,((function (count1,count2,common_count,el_schema){
return (function (idx,el1,el2){
return cljs.core.map.call(null,((function (count1,count2,common_count,el_schema){
return (function (p__14579){
var vec__14580 = p__14579;
var path = cljs.core.nth.call(null,vec__14580,(0),null);
var v1 = cljs.core.nth.call(null,vec__14580,(1),null);
var v2 = cljs.core.nth.call(null,vec__14580,(2),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.vec.call(null,cljs.core.cons.call(null,idx,path)),v1,v2], null);
});})(count1,count2,common_count,el_schema))
,active.clojure.config.diff_configuration_objects.call(null,el_schema,el1,el2));
});})(count1,count2,common_count,el_schema))
,cljs.core.range.call(null),cljs.core.take.call(null,common_count,config_object_1),cljs.core.take.call(null,common_count,config_object_2));
var triples_1 = (((count1 > count2))?cljs.core.map.call(null,((function (count1,count2,common_count,el_schema,triples_common){
return (function (idx,v){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(idx + count2)], null),v,null], null);
});})(count1,count2,common_count,el_schema,triples_common))
,cljs.core.range.call(null),config_object_1):cljs.core.PersistentVector.EMPTY);
var triples_2 = (((count2 > count1))?cljs.core.map.call(null,((function (count1,count2,common_count,el_schema,triples_common,triples_1){
return (function (idx,v){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(idx + count1)], null),null,v], null);
});})(count1,count2,common_count,el_schema,triples_common,triples_1))
,cljs.core.range.call(null),config_object_2):cljs.core.PersistentVector.EMPTY);
return cljs.core.concat.call(null,triples_common,triples_1,triples_2);
} else {
return null;
}
}
});
/**
 * Returns sequence of triples [path-vectors version-1 version-2] of settings that differ.
 */
active.clojure.config.diff_configurations = (function active$clojure$config$diff_configurations(schema,config_1,config_2){
return active.clojure.config.diff_configuration_objects.call(null,schema,active.clojure.config.configuration_object.call(null,config_1),active.clojure.config.configuration_object.call(null,config_2));
});
/**
 * Access the settings of a section.
 * 
 *   - `on-last` is a function to be applied the config object at the end of the path
 */
active.clojure.config.access_section = (function active$clojure$config$access_section(config,sections,on_last){
var recurse = (function active$clojure$config$access_section_$_recurse(sections__$1,cf){
if(cljs.core.empty_QMARK_.call(null,sections__$1)){
return on_last.call(null,cf);
} else {
var sec = cljs.core.first.call(null,sections__$1);
var cf__$1 = cljs.core.get.call(null,cf,active.clojure.config.section_key.call(null,sec),new cljs.core.Keyword("active.clojure.config","section-not-found","active.clojure.config/section-not-found",-1713483771));
var G__14584 = cf__$1;
var G__14584__$1 = (((G__14584 instanceof cljs.core.Keyword))?G__14584.fqn:null);
switch (G__14584__$1) {
case "active.clojure.config/section-not-found":
var path = cljs.core.map.call(null,active.clojure.config.section_key,sections__$1);
return active.clojure.condition.assertion_violation.call(null,new cljs.core.Symbol("active.clojure.config","access-section","active.clojure.config/access-section",-710566389,null),["section ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.vec.call(null,path))," not found"].join(''),path,config);

break;
default:
var schemarec = ((function (G__14584,G__14584__$1,sec,cf__$1){
return (function active$clojure$config$access_section_$_recurse_$_schemarec(schema,cf__$2){
if(cljs.core.truth_(active.clojure.config.map_schema_QMARK_.call(null,schema))){
return active$clojure$config$access_section_$_recurse.call(null,cljs.core.rest.call(null,sections__$1),cf__$2);
} else {
if(cljs.core.truth_(active.clojure.config.sequence_schema_QMARK_.call(null,schema))){
return cljs.core.map.call(null,((function (G__14584,G__14584__$1,sec,cf__$1){
return (function (subcf){
return active$clojure$config$access_section_$_recurse_$_schemarec.call(null,active.clojure.config.sequence_schema_element_schema.call(null,schema),subcf);
});})(G__14584,G__14584__$1,sec,cf__$1))
,cf__$2);
} else {
return null;
}
}
});})(G__14584,G__14584__$1,sec,cf__$1))
;
return schemarec.call(null,active.clojure.config.section_schema.call(null,sec),cf__$1);

}
}
});
return recurse.call(null,sections,active.clojure.config.configuration_object.call(null,config));
});
active.clojure.config.setting_or_section_key = (function active$clojure$config$setting_or_section_key(sos){
if(cljs.core.truth_(active.clojure.config.setting_QMARK_.call(null,sos))){
return active.clojure.config.setting_key.call(null,sos);
} else {
if(cljs.core.truth_(active.clojure.config.section_QMARK_.call(null,sos))){
return active.clojure.config.section_key.call(null,sos);
} else {
return null;
}
}
});
/**
 * Access the value of a setting or map of a section.
 * 
 *   Note that the setting comes first, followed by the access path.
 */
active.clojure.config.access = (function active$clojure$config$access(var_args){
var args__4502__auto__ = [];
var len__4499__auto___14589 = arguments.length;
var i__4500__auto___14590 = (0);
while(true){
if((i__4500__auto___14590 < len__4499__auto___14589)){
args__4502__auto__.push((arguments[i__4500__auto___14590]));

var G__14591 = (i__4500__auto___14590 + (1));
i__4500__auto___14590 = G__14591;
continue;
} else {
}
break;
}

var argseq__4503__auto__ = ((((2) < args__4502__auto__.length))?(new cljs.core.IndexedSeq(args__4502__auto__.slice((2)),(0),null)):null);
return active.clojure.config.access.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4503__auto__);
});

active.clojure.config.access.cljs$core$IFn$_invoke$arity$variadic = (function (config,setting_or_section,sections){
return active.clojure.config.access_section.call(null,config,sections,(function (cf){
var key = active.clojure.config.setting_or_section_key.call(null,setting_or_section);
var val = cljs.core.get.call(null,cf,key,new cljs.core.Keyword("active.clojure.config","setting-not-found","active.clojure.config/setting-not-found",-1925455223));
if(cljs.core._EQ_.call(null,val,new cljs.core.Keyword("active.clojure.config","setting-not-found","active.clojure.config/setting-not-found",-1925455223))){
var path = cljs.core.map.call(null,active.clojure.config.section_key,sections);
return active.clojure.condition.assertion_violation.call(null,new cljs.core.Symbol("active.clojure.config","access","active.clojure.config/access",217694667,null),["setting ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)," not found at path ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.vec.call(null,path))].join(''),path,setting_or_section,config);
} else {
return val;
}
}));
});

active.clojure.config.access.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
active.clojure.config.access.cljs$lang$applyTo = (function (seq14586){
var G__14587 = cljs.core.first.call(null,seq14586);
var seq14586__$1 = cljs.core.next.call(null,seq14586);
var G__14588 = cljs.core.first.call(null,seq14586__$1);
var seq14586__$2 = cljs.core.next.call(null,seq14586__$1);
var self__4486__auto__ = this;
return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14587,G__14588,seq14586__$2);
});

/**
 * Extract a section from a config as a config.
 */
active.clojure.config.section_subconfig = (function active$clojure$config$section_subconfig(var_args){
var args__4502__auto__ = [];
var len__4499__auto___14594 = arguments.length;
var i__4500__auto___14595 = (0);
while(true){
if((i__4500__auto___14595 < len__4499__auto___14594)){
args__4502__auto__.push((arguments[i__4500__auto___14595]));

var G__14596 = (i__4500__auto___14595 + (1));
i__4500__auto___14595 = G__14596;
continue;
} else {
}
break;
}

var argseq__4503__auto__ = ((((1) < args__4502__auto__.length))?(new cljs.core.IndexedSeq(args__4502__auto__.slice((1)),(0),null)):null);
return active.clojure.config.section_subconfig.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4503__auto__);
});

active.clojure.config.section_subconfig.cljs$core$IFn$_invoke$arity$variadic = (function (config,sections){
return active.clojure.config.access_section.call(null,config,sections,(function (cf){
return active.clojure.config.really_make_configuration.call(null,cf,active.clojure.config.section_schema.call(null,cljs.core.last.call(null,sections)));
}));
});

active.clojure.config.section_subconfig.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
active.clojure.config.section_subconfig.cljs$lang$applyTo = (function (seq14592){
var G__14593 = cljs.core.first.call(null,seq14592);
var seq14592__$1 = cljs.core.next.call(null,seq14592);
var self__4486__auto__ = this;
return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14593,seq14592__$1);
});

/**
 * Given range `r` is required in the first line,
 * the remainder of the lines the field holds ".".
 */
active.clojure.config.or_dot_range = (function active$clojure$config$or_dot_range(r){
return active.clojure.config.any_range.call(null,active.clojure.config.one_of_range.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [".",null], null), null),null),r);
});

//# sourceMappingURL=config.js.map
