(ns ^:no-doc active.clojure.monad.list
  "List monad config"
  (:require [active.clojure.monad.commands :as commands]
            [active.clojure.monad.core :as monad]))

(commands/declare-command ^:private list-cmd [vs])

(defn list [& vs] (list-cmd vs)) ;; call it lift?

(def ^:private list-command-impls
  {(var internals/return) (fn [v] (clojure.core/list v))
   #'list-cmd (fn [vs] vs)
                                   
   (var internals/bind)
   (commands/recursive (fn [eval m f]
                         (list-cmd (mapcat (comp eval f) (eval m)))))})

(def list-command-config
  (commands/command-config list-command-impls))
