// Compiled by ClojureScript 1.10.339 {}
goog.provide('active_viz.scale.time_scale');
goog.require('cljs.core');
goog.require('cljs_time.coerce');
goog.require('cljs_time.core');
goog.require('cljs_time.format');
goog.require('active_viz.scale.linear_scale');
goog.require('active.clojure.record');
goog.require('active_viz.ticks');
goog.require('active_viz.scale.util');

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
active_viz.scale.time_scale.Unit = (function (time_unit,time_constructor,approx_ms,nice_values,__meta,__extmap,__hash){
this.time_unit = time_unit;
this.time_constructor = time_constructor;
this.approx_ms = approx_ms;
this.nice_values = nice_values;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
active_viz.scale.time_scale.Unit.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4203__auto__,k__4204__auto__){
var self__ = this;
var this__4203__auto____$1 = this;
return this__4203__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4204__auto__,null);
});

active_viz.scale.time_scale.Unit.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4205__auto__,k8611,else__4206__auto__){
var self__ = this;
var this__4205__auto____$1 = this;
var G__8615 = k8611;
var G__8615__$1 = (((G__8615 instanceof cljs.core.Keyword))?G__8615.fqn:null);
switch (G__8615__$1) {
case "time-unit":
return self__.time_unit;

break;
case "time-constructor":
return self__.time_constructor;

break;
case "approx-ms":
return self__.approx_ms;

break;
case "nice-values":
return self__.nice_values;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k8611,else__4206__auto__);

}
});

active_viz.scale.time_scale.Unit.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4217__auto__,writer__4218__auto__,opts__4219__auto__){
var self__ = this;
var this__4217__auto____$1 = this;
var pr_pair__4220__auto__ = ((function (this__4217__auto____$1){
return (function (keyval__4221__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4218__auto__,cljs.core.pr_writer,""," ","",opts__4219__auto__,keyval__4221__auto__);
});})(this__4217__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__4218__auto__,pr_pair__4220__auto__,"#active-viz.scale.time-scale.Unit{",", ","}",opts__4219__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"time-unit","time-unit",658316264),self__.time_unit],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"time-constructor","time-constructor",334533276),self__.time_constructor],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"approx-ms","approx-ms",1724733247),self__.approx_ms],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"nice-values","nice-values",9595080),self__.nice_values],null))], null),self__.__extmap));
});

active_viz.scale.time_scale.Unit.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__8610){
var self__ = this;
var G__8610__$1 = this;
return (new cljs.core.RecordIter((0),G__8610__$1,4,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"time-unit","time-unit",658316264),new cljs.core.Keyword(null,"time-constructor","time-constructor",334533276),new cljs.core.Keyword(null,"approx-ms","approx-ms",1724733247),new cljs.core.Keyword(null,"nice-values","nice-values",9595080)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

active_viz.scale.time_scale.Unit.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4201__auto__){
var self__ = this;
var this__4201__auto____$1 = this;
return self__.__meta;
});

active_viz.scale.time_scale.Unit.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4198__auto__){
var self__ = this;
var this__4198__auto____$1 = this;
return (new active_viz.scale.time_scale.Unit(self__.time_unit,self__.time_constructor,self__.approx_ms,self__.nice_values,self__.__meta,self__.__extmap,self__.__hash));
});

active_viz.scale.time_scale.Unit.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4207__auto__){
var self__ = this;
var this__4207__auto____$1 = this;
return (4 + cljs.core.count.call(null,self__.__extmap));
});

active_viz.scale.time_scale.Unit.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4199__auto__){
var self__ = this;
var this__4199__auto____$1 = this;
var h__4061__auto__ = self__.__hash;
if(!((h__4061__auto__ == null))){
return h__4061__auto__;
} else {
var h__4061__auto____$1 = ((function (h__4061__auto__,this__4199__auto____$1){
return (function (coll__4200__auto__){
return (1780693712 ^ cljs.core.hash_unordered_coll.call(null,coll__4200__auto__));
});})(h__4061__auto__,this__4199__auto____$1))
.call(null,this__4199__auto____$1);
self__.__hash = h__4061__auto____$1;

return h__4061__auto____$1;
}
});

active_viz.scale.time_scale.Unit.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this8612,other8613){
var self__ = this;
var this8612__$1 = this;
return ((!((other8613 == null))) && ((this8612__$1.constructor === other8613.constructor)) && (cljs.core._EQ_.call(null,this8612__$1.time_unit,other8613.time_unit)) && (cljs.core._EQ_.call(null,this8612__$1.time_constructor,other8613.time_constructor)) && (cljs.core._EQ_.call(null,this8612__$1.approx_ms,other8613.approx_ms)) && (cljs.core._EQ_.call(null,this8612__$1.nice_values,other8613.nice_values)) && (cljs.core._EQ_.call(null,this8612__$1.__extmap,other8613.__extmap)));
});

active_viz.scale.time_scale.Unit.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4212__auto__,k__4213__auto__){
var self__ = this;
var this__4212__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"nice-values","nice-values",9595080),null,new cljs.core.Keyword(null,"time-unit","time-unit",658316264),null,new cljs.core.Keyword(null,"time-constructor","time-constructor",334533276),null,new cljs.core.Keyword(null,"approx-ms","approx-ms",1724733247),null], null), null),k__4213__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4212__auto____$1),self__.__meta),k__4213__auto__);
} else {
return (new active_viz.scale.time_scale.Unit(self__.time_unit,self__.time_constructor,self__.approx_ms,self__.nice_values,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4213__auto__)),null));
}
});

active_viz.scale.time_scale.Unit.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4210__auto__,k__4211__auto__,G__8610){
var self__ = this;
var this__4210__auto____$1 = this;
var pred__8616 = cljs.core.keyword_identical_QMARK_;
var expr__8617 = k__4211__auto__;
if(cljs.core.truth_(pred__8616.call(null,new cljs.core.Keyword(null,"time-unit","time-unit",658316264),expr__8617))){
return (new active_viz.scale.time_scale.Unit(G__8610,self__.time_constructor,self__.approx_ms,self__.nice_values,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__8616.call(null,new cljs.core.Keyword(null,"time-constructor","time-constructor",334533276),expr__8617))){
return (new active_viz.scale.time_scale.Unit(self__.time_unit,G__8610,self__.approx_ms,self__.nice_values,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__8616.call(null,new cljs.core.Keyword(null,"approx-ms","approx-ms",1724733247),expr__8617))){
return (new active_viz.scale.time_scale.Unit(self__.time_unit,self__.time_constructor,G__8610,self__.nice_values,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__8616.call(null,new cljs.core.Keyword(null,"nice-values","nice-values",9595080),expr__8617))){
return (new active_viz.scale.time_scale.Unit(self__.time_unit,self__.time_constructor,self__.approx_ms,G__8610,self__.__meta,self__.__extmap,null));
} else {
return (new active_viz.scale.time_scale.Unit(self__.time_unit,self__.time_constructor,self__.approx_ms,self__.nice_values,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4211__auto__,G__8610),null));
}
}
}
}
});

active_viz.scale.time_scale.Unit.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4215__auto__){
var self__ = this;
var this__4215__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"time-unit","time-unit",658316264),self__.time_unit,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"time-constructor","time-constructor",334533276),self__.time_constructor,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"approx-ms","approx-ms",1724733247),self__.approx_ms,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"nice-values","nice-values",9595080),self__.nice_values,null))], null),self__.__extmap));
});

active_viz.scale.time_scale.Unit.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4202__auto__,G__8610){
var self__ = this;
var this__4202__auto____$1 = this;
return (new active_viz.scale.time_scale.Unit(self__.time_unit,self__.time_constructor,self__.approx_ms,self__.nice_values,G__8610,self__.__extmap,self__.__hash));
});

active_viz.scale.time_scale.Unit.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4208__auto__,entry__4209__auto__){
var self__ = this;
var this__4208__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4209__auto__)){
return this__4208__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4209__auto__,(0)),cljs.core._nth.call(null,entry__4209__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4208__auto____$1,entry__4209__auto__);
}
});

active_viz.scale.time_scale.Unit.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"time-unit","time-unit",-1996119505,null),new cljs.core.Symbol(null,"time-constructor","time-constructor",1975064803,null),new cljs.core.Symbol(null,"approx-ms","approx-ms",-929702522,null),new cljs.core.Symbol(null,"nice-values","nice-values",1650126607,null)], null);
});

active_viz.scale.time_scale.Unit.cljs$lang$type = true;

active_viz.scale.time_scale.Unit.cljs$lang$ctorPrSeq = (function (this__4240__auto__){
return (new cljs.core.List(null,"active-viz.scale.time-scale/Unit",null,(1),null));
});

active_viz.scale.time_scale.Unit.cljs$lang$ctorPrWriter = (function (this__4240__auto__,writer__4241__auto__){
return cljs.core._write.call(null,writer__4241__auto__,"active-viz.scale.time-scale/Unit");
});

/**
 * Positional factory function for active-viz.scale.time-scale/Unit.
 */
active_viz.scale.time_scale.__GT_Unit = (function active_viz$scale$time_scale$__GT_Unit(time_unit,time_constructor,approx_ms,nice_values){
return (new active_viz.scale.time_scale.Unit(time_unit,time_constructor,approx_ms,nice_values,null,null,null));
});

/**
 * Factory function for active-viz.scale.time-scale/Unit, taking a map of keywords to field values.
 */
active_viz.scale.time_scale.map__GT_Unit = (function active_viz$scale$time_scale$map__GT_Unit(G__8614){
var extmap__4236__auto__ = (function (){var G__8619 = cljs.core.dissoc.call(null,G__8614,new cljs.core.Keyword(null,"time-unit","time-unit",658316264),new cljs.core.Keyword(null,"time-constructor","time-constructor",334533276),new cljs.core.Keyword(null,"approx-ms","approx-ms",1724733247),new cljs.core.Keyword(null,"nice-values","nice-values",9595080));
if(cljs.core.record_QMARK_.call(null,G__8614)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__8619);
} else {
return G__8619;
}
})();
return (new active_viz.scale.time_scale.Unit(new cljs.core.Keyword(null,"time-unit","time-unit",658316264).cljs$core$IFn$_invoke$arity$1(G__8614),new cljs.core.Keyword(null,"time-constructor","time-constructor",334533276).cljs$core$IFn$_invoke$arity$1(G__8614),new cljs.core.Keyword(null,"approx-ms","approx-ms",1724733247).cljs$core$IFn$_invoke$arity$1(G__8614),new cljs.core.Keyword(null,"nice-values","nice-values",9595080).cljs$core$IFn$_invoke$arity$1(G__8614),null,cljs.core.not_empty.call(null,extmap__4236__auto__),null));
});


/**
 * Is object a `Unit` record? See [[active-viz.scale.time-scale/make-unit]].
 */
active_viz.scale.time_scale.unit_QMARK_ = (function active_viz$scale$time_scale$unit_QMARK_(x__8514__auto__){
return (x__8514__auto__ instanceof active_viz.scale.time_scale.Unit);
});

/**
 * Construct a `Unit` record.
 * 
 * `time-unit`: access via [[active-viz.scale.time-scale/unit-time-unit]]
 * `time-constructor`: access via [[active-viz.scale.time-scale/unit-time-constructor]]
 * `approx-ms`: access via [[active-viz.scale.time-scale/unit-approx-ms]]
 * `nice-values`: access via [[active-viz.scale.time-scale/unit-nice-values]]
 */
active_viz.scale.time_scale.make_unit = (function active_viz$scale$time_scale$make_unit(time_unit,time_constructor,approx_ms,nice_values){
return (new active_viz.scale.time_scale.Unit(time_unit,time_constructor,approx_ms,nice_values,null,null,null));
});





/**
 * Access `time-unit` field from a [[Unit]] record. See [[active-viz.scale.time-scale/make-unit]].
 */
active_viz.scale.time_scale.unit_time_unit = (function active_viz$scale$time_scale$unit_time_unit(rec__8511__auto__){
active.clojure.record.check_type.call(null,active_viz.scale.time_scale.Unit,rec__8511__auto__);

return rec__8511__auto__.time_unit;
});

/**
 * Access `time-constructor` field from a [[Unit]] record. See [[active-viz.scale.time-scale/make-unit]].
 */
active_viz.scale.time_scale.unit_time_constructor = (function active_viz$scale$time_scale$unit_time_constructor(rec__8511__auto__){
active.clojure.record.check_type.call(null,active_viz.scale.time_scale.Unit,rec__8511__auto__);

return rec__8511__auto__.time_constructor;
});

/**
 * Access `approx-ms` field from a [[Unit]] record. See [[active-viz.scale.time-scale/make-unit]].
 */
active_viz.scale.time_scale.unit_approx_ms = (function active_viz$scale$time_scale$unit_approx_ms(rec__8511__auto__){
active.clojure.record.check_type.call(null,active_viz.scale.time_scale.Unit,rec__8511__auto__);

return rec__8511__auto__.approx_ms;
});

/**
 * Access `nice-values` field from a [[Unit]] record. See [[active-viz.scale.time-scale/make-unit]].
 */
active_viz.scale.time_scale.unit_nice_values = (function active_viz$scale$time_scale$unit_nice_values(rec__8511__auto__){
active.clojure.record.check_type.call(null,active_viz.scale.time_scale.Unit,rec__8511__auto__);

return rec__8511__auto__.nice_values;
});
active_viz.scale.time_scale.millisecond = (1);
active_viz.scale.time_scale.second_ms = ((1000) * active_viz.scale.time_scale.millisecond);
active_viz.scale.time_scale.minute_ms = ((60) * active_viz.scale.time_scale.second_ms);
active_viz.scale.time_scale.hour_ms = ((60) * active_viz.scale.time_scale.minute_ms);
active_viz.scale.time_scale.day_ms = ((24) * active_viz.scale.time_scale.hour_ms);
active_viz.scale.time_scale.month_ms = ((30) * active_viz.scale.time_scale.day_ms);
active_viz.scale.time_scale.year_ms = ((365) * active_viz.scale.time_scale.day_ms);
active_viz.scale.time_scale.millisecond_nice = new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),(5),(2),2.5,(3),(4),1.5,(7),(6),(8),(9)], null);
active_viz.scale.time_scale.second_nice = new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),(2),(3),(4),(5),(10),(20),(30),(60)], null);
active_viz.scale.time_scale.minute_nice = new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),(2),(5),(10),(15),(30),(60)], null);
active_viz.scale.time_scale.hour_nice = new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),(2),(4),(6),(8),(24)], null);
active_viz.scale.time_scale.day_nice = new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),(2),(4),(6),(8),(10),(15),(30),182.5,(365)], null);
active_viz.scale.time_scale.month_nice = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),(3)], null);
active_viz.scale.time_scale.year_nice = new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),(2),(3),(4),(5),(6),(7),(8),(9)], null);
active_viz.scale.time_scale.year_unit = active_viz.scale.time_scale.make_unit.call(null,cljs_time.core.year,cljs_time.core.years,active_viz.scale.time_scale.year_ms,active_viz.scale.time_scale.year_nice);
active_viz.scale.time_scale.month_unit = active_viz.scale.time_scale.make_unit.call(null,cljs_time.core.month,cljs_time.core.months,active_viz.scale.time_scale.month_ms,active_viz.scale.time_scale.month_nice);
active_viz.scale.time_scale.day_unit = active_viz.scale.time_scale.make_unit.call(null,cljs_time.core.day,cljs_time.core.days,active_viz.scale.time_scale.day_ms,active_viz.scale.time_scale.day_nice);
active_viz.scale.time_scale.hour_unit = active_viz.scale.time_scale.make_unit.call(null,cljs_time.core.hour,cljs_time.core.hours,active_viz.scale.time_scale.hour_ms,active_viz.scale.time_scale.hour_nice);
active_viz.scale.time_scale.minute_unit = active_viz.scale.time_scale.make_unit.call(null,cljs_time.core.minute,cljs_time.core.minutes,active_viz.scale.time_scale.minute_ms,active_viz.scale.time_scale.minute_nice);
active_viz.scale.time_scale.second_unit = active_viz.scale.time_scale.make_unit.call(null,cljs_time.core.second,cljs_time.core.seconds,active_viz.scale.time_scale.second_ms,active_viz.scale.time_scale.second_nice);
active_viz.scale.time_scale.ms_unit = active_viz.scale.time_scale.make_unit.call(null,cljs_time.core.millis,cljs_time.core.millis,active_viz.scale.time_scale.millisecond,active_viz.scale.time_scale.millisecond_nice);
active_viz.scale.time_scale.time_scale = (function active_viz$scale$time_scale$time_scale(p__8621,p__8622){
var vec__8623 = p__8621;
var domain_min = cljs.core.nth.call(null,vec__8623,(0),null);
var domain_max = cljs.core.nth.call(null,vec__8623,(1),null);
var vec__8626 = p__8622;
var range_min = cljs.core.nth.call(null,vec__8626,(0),null);
var range_max = cljs.core.nth.call(null,vec__8626,(1),null);
var start_date_ms = cljs_time.coerce.to_long.call(null,domain_min);
var end_date_ms = cljs_time.coerce.to_long.call(null,domain_max);
var scale = active_viz.scale.util.scale_scale_fn.call(null,active_viz.scale.linear_scale.linear_scale.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_date_ms,end_date_ms], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [range_min,range_max], null)));
return active_viz.scale.util.make_scale.call(null,domain_min,domain_max,range_min,range_max,((function (start_date_ms,end_date_ms,scale,vec__8623,domain_min,domain_max,vec__8626,range_min,range_max){
return (function (value){
return scale.call(null,cljs_time.coerce.to_long.call(null,value));
});})(start_date_ms,end_date_ms,scale,vec__8623,domain_min,domain_max,vec__8626,range_min,range_max))
);
});
active_viz.scale.time_scale.indivisible_unit_constructor_QMARK_ = (function active_viz$scale$time_scale$indivisible_unit_constructor_QMARK_(constr){
return ((cljs.core._EQ_.call(null,constr,cljs_time.core.months)) || (cljs.core._EQ_.call(null,constr,cljs_time.core.years)));
});
active_viz.scale.time_scale.round_indivisible = (function active_viz$scale$time_scale$round_indivisible(v){
var x__4037__auto__ = (1);
var y__4038__auto__ = Math.floor(v);
return ((x__4037__auto__ > y__4038__auto__) ? x__4037__auto__ : y__4038__auto__);
});
active_viz.scale.time_scale.round = (function active_viz$scale$time_scale$round(a){
return (Math.round(((1000000) * a)) / (1000000));
});
active_viz.scale.time_scale.create_time_ticks = (function active_viz$scale$time_scale$create_time_ticks(p__8630,first_date,last_date,time_unit_constructor){
var map__8631 = p__8630;
var map__8631__$1 = ((((!((map__8631 == null)))?(((((map__8631.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__8631.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__8631):map__8631);
var lmin = cljs.core.get.call(null,map__8631__$1,new cljs.core.Keyword(null,"lmin","lmin",2139111947));
var lmax = cljs.core.get.call(null,map__8631__$1,new cljs.core.Keyword(null,"lmax","lmax",-1390660950));
var lstep = cljs.core.get.call(null,map__8631__$1,new cljs.core.Keyword(null,"lstep","lstep",-1243990033));
var fix_indivisible_QMARK_ = (function (){var and__3938__auto__ = active_viz.scale.time_scale.indivisible_unit_constructor_QMARK_.call(null,time_unit_constructor);
if(cljs.core.truth_(and__3938__auto__)){
return !(cljs.core.int_QMARK_.call(null,lstep));
} else {
return and__3938__auto__;
}
})();
var ticks_step = (cljs.core.truth_(fix_indivisible_QMARK_)?active_viz.scale.time_scale.round_indivisible.call(null,lstep):active_viz.scale.time_scale.round.call(null,lstep));
var inc_datetime = ((function (fix_indivisible_QMARK_,ticks_step,map__8631,map__8631__$1,lmin,lmax,lstep){
return (function (p1__8629_SHARP_){
return cljs_time.core.plus.call(null,p1__8629_SHARP_,time_unit_constructor.call(null,ticks_step));
});})(fix_indivisible_QMARK_,ticks_step,map__8631,map__8631__$1,lmin,lmax,lstep))
;
return cljs.core.reverse.call(null,(function (){var current = lmin;
var acc = cljs.core.PersistentVector.EMPTY;
while(true){
if((current <= lmax)){
var G__8633 = active_viz.scale.time_scale.round.call(null,(current + ticks_step));
var G__8634 = ((cljs.core.empty_QMARK_.call(null,acc))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [first_date], null):cljs.core.cons.call(null,inc_datetime.call(null,cljs.core.first.call(null,acc)),acc));
current = G__8633;
acc = G__8634;
continue;
} else {
if((cljs_time.coerce.to_long.call(null,cljs.core.first.call(null,acc)) < cljs_time.coerce.to_long.call(null,last_date))){
return cljs.core.cons.call(null,inc_datetime.call(null,cljs.core.first.call(null,acc)),acc);
} else {
return acc;
}
}
break;
}
})());
});
active_viz.scale.time_scale.create_ticks = (function active_viz$scale$time_scale$create_ticks(start_date,end_date,num_ticks,unit){
var constructor$ = active_viz.scale.time_scale.unit_time_constructor.call(null,unit);
var nice_values = active_viz.scale.time_scale.unit_nice_values.call(null,unit);
var unit_ms = active_viz.scale.time_scale.unit_approx_ms.call(null,unit);
var time_unit = active_viz.scale.time_scale.unit_time_unit.call(null,unit);
var first_ticks_date = cljs_time.core.floor.call(null,start_date,time_unit);
var first_ticks_date_ms = cljs_time.coerce.to_long.call(null,first_ticks_date);
var relative_start_date_ms = (cljs_time.coerce.to_long.call(null,start_date) - first_ticks_date_ms);
var relative_end_date_ms = (cljs_time.coerce.to_long.call(null,end_date) - first_ticks_date_ms);
var G__8635 = active_viz.ticks.nice_ticks.call(null,(relative_start_date_ms / unit_ms),(relative_end_date_ms / unit_ms),num_ticks,nice_values);
if((G__8635 == null)){
return null;
} else {
return active_viz.scale.time_scale.create_time_ticks.call(null,G__8635,first_ticks_date,end_date,constructor$);
}
});
active_viz.scale.time_scale.choose_unit = (function active_viz$scale$time_scale$choose_unit(kw){
var G__8636 = kw;
var G__8636__$1 = (((G__8636 instanceof cljs.core.Keyword))?G__8636.fqn:null);
switch (G__8636__$1) {
case "year":
return active_viz.scale.time_scale.year_unit;

break;
case "month":
return active_viz.scale.time_scale.month_unit;

break;
case "day":
return active_viz.scale.time_scale.day_unit;

break;
case "hour":
return active_viz.scale.time_scale.hour_unit;

break;
case "minute":
return active_viz.scale.time_scale.minute_unit;

break;
case "second":
return active_viz.scale.time_scale.second_unit;

break;
case "millisecond":
return active_viz.scale.time_scale.ms_unit;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__8636__$1)].join('')));

}
});
active_viz.scale.time_scale.time_scale__GT_ticks = (function active_viz$scale$time_scale$time_scale__GT_ticks(scale,type,num_ticks){
var start_date = active_viz.scale.util.scale_domain_min.call(null,scale);
var end_date = active_viz.scale.util.scale_domain_max.call(null,scale);
var start_date_ms = cljs_time.coerce.to_long.call(null,start_date);
var end_date_ms = cljs_time.coerce.to_long.call(null,end_date);
var unit = active_viz.scale.time_scale.choose_unit.call(null,type);
return active_viz.scale.time_scale.create_ticks.call(null,start_date,end_date,num_ticks,unit);
});
active_viz.scale.time_scale.year_formatter = cljs_time.format.formatter.call(null,"yyyy");
active_viz.scale.time_scale.format_year = (function active_viz$scale$time_scale$format_year(dt){
if(cljs.core._EQ_.call(null,(1),cljs_time.core.month.call(null,dt))){
return cljs_time.format.unparse.call(null,active_viz.scale.time_scale.year_formatter,dt);
} else {
return "";
}
});
active_viz.scale.time_scale.month_formatter = cljs_time.format.formatter.call(null,"MM/yyyy");
active_viz.scale.time_scale.format_month = (function active_viz$scale$time_scale$format_month(dt){
return cljs_time.format.unparse.call(null,active_viz.scale.time_scale.month_formatter,dt);
});

//# sourceMappingURL=time_scale.js.map
