// Compiled by ClojureScript 1.10.339 {}
goog.provide('active_viz.scale_test');
goog.require('cljs.core');
goog.require('active_viz.scale');
goog.require('active_viz.scale.linear_scale');
goog.require('active_viz.scale.time_scale');
goog.require('cljs_time.core');
goog.require('cljs.test');
active_viz.scale_test.eps = 1.0E-5;
active_viz.scale_test.eq = (function active_viz$scale_test$eq(a,b){
return ((((b + active_viz.scale_test.eps) > a)) && (((b - active_viz.scale_test.eps) < a)));
});
active_viz.scale_test.scale = (function active_viz$scale_test$scale(){
return cljs.test.test_var.call(null,active_viz.scale_test.scale.cljs$lang$var);
});
active_viz.scale_test.scale.cljs$lang$test = (function (){
cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.conj,"combines two scales properly");

try{var start_date_8836 = cljs_time.core.date_time.call(null,(2018),(1),(1),(0),(0),(0),(0));
var end_date_8837 = cljs_time.core.date_time.call(null,(2019),(1),(1),(0),(0),(0),(0));
var time_scale_8838 = active_viz.scale.time_scale.make_time_scale.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_date_8836,end_date_8837], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(100),(246)], null));
var linear_scale_8839 = active_viz.scale.linear_scale.make_linear_scale.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(100),(246)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(1000)], null));
var combined_scale_8840 = active_viz.scale._GT__GT_.call(null,time_scale_8838,linear_scale_8839);
try{var values__8634__auto___8841 = (new cljs.core.List(null,active_viz.scale.scale.call(null,combined_scale_8840,start_date_8836),(new cljs.core.List(null,(0),null,(1),null)),(2),null));
var result__8635__auto___8842 = cljs.core.apply.call(null,cljs.core._EQ_,values__8634__auto___8841);
if(cljs.core.truth_(result__8635__auto___8842)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"combined-scale","combined-scale",-1463311509,null),new cljs.core.Symbol(null,"start-date","start-date",1935700258,null)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8634__auto___8841),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"combined-scale","combined-scale",-1463311509,null),new cljs.core.Symbol(null,"start-date","start-date",1935700258,null)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8634__auto___8841),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e8813){var t__8679__auto___8843 = e8813;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"combined-scale","combined-scale",-1463311509,null),new cljs.core.Symbol(null,"start-date","start-date",1935700258,null)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8679__auto___8843,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8634__auto___8844 = (new cljs.core.List(null,(1000),(new cljs.core.List(null,active_viz.scale.scale.call(null,combined_scale_8840,end_date_8837),null,(1),null)),(2),null));
var result__8635__auto___8845 = cljs.core.apply.call(null,active_viz.scale_test.eq,values__8634__auto___8844);
if(cljs.core.truth_(result__8635__auto___8845)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"eq","eq",1021992460,null),(1000),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"combined-scale","combined-scale",-1463311509,null),new cljs.core.Symbol(null,"end-date","end-date",1432271885,null))),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,active_viz.scale_test.eq,values__8634__auto___8844),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"eq","eq",1021992460,null),(1000),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"combined-scale","combined-scale",-1463311509,null),new cljs.core.Symbol(null,"end-date","end-date",1432271885,null))),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"eq","eq",1021992460,null),values__8634__auto___8844),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e8814){var t__8679__auto___8846 = e8814;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"eq","eq",1021992460,null),(1000),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"combined-scale","combined-scale",-1463311509,null),new cljs.core.Symbol(null,"end-date","end-date",1432271885,null))),new cljs.core.Keyword(null,"actual","actual",107306363),t__8679__auto___8846,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}}finally {cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.rest);
}
cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.conj,"inverts a scale range");

try{var linear_scale_8847 = active_viz.scale.linear_scale.make_linear_scale.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(100)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(200)], null));
var inverted_8848 = active_viz.scale.invert.call(null,linear_scale_8847);
var orig_8849 = active_viz.scale.invert.call(null,inverted_8848);
try{var values__8634__auto___8850 = (new cljs.core.List(null,active_viz.scale.scale.call(null,inverted_8848,(0)),(new cljs.core.List(null,(200),null,(1),null)),(2),null));
var result__8635__auto___8851 = cljs.core.apply.call(null,cljs.core._EQ_,values__8634__auto___8850);
if(cljs.core.truth_(result__8635__auto___8851)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(0)),(200)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8634__auto___8850),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(0)),(200)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8634__auto___8850),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e8815){var t__8679__auto___8852 = e8815;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(0)),(200)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8679__auto___8852,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8634__auto___8853 = (new cljs.core.List(null,active_viz.scale.scale.call(null,inverted_8848,(50)),(new cljs.core.List(null,(100),null,(1),null)),(2),null));
var result__8635__auto___8854 = cljs.core.apply.call(null,cljs.core._EQ_,values__8634__auto___8853);
if(cljs.core.truth_(result__8635__auto___8854)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(50)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8634__auto___8853),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(50)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8634__auto___8853),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e8816){var t__8679__auto___8855 = e8816;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(50)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8679__auto___8855,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8634__auto___8856 = (new cljs.core.List(null,active_viz.scale.scale.call(null,inverted_8848,(100)),(new cljs.core.List(null,(0),null,(1),null)),(2),null));
var result__8635__auto___8857 = cljs.core.apply.call(null,cljs.core._EQ_,values__8634__auto___8856);
if(cljs.core.truth_(result__8635__auto___8857)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(100)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8634__auto___8856),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(100)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8634__auto___8856),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e8817){var t__8679__auto___8858 = e8817;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(100)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8679__auto___8858,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8634__auto___8859 = (new cljs.core.List(null,active_viz.scale.scale.call(null,linear_scale_8847,(25)),(new cljs.core.List(null,active_viz.scale.scale.call(null,orig_8849,(25)),null,(1),null)),(2),null));
var result__8635__auto___8860 = cljs.core.apply.call(null,cljs.core._EQ_,values__8634__auto___8859);
if(cljs.core.truth_(result__8635__auto___8860)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"linear-scale","linear-scale",91410306,null),(25)),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"orig","orig",-37778343,null),(25))),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8634__auto___8859),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"linear-scale","linear-scale",91410306,null),(25)),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"orig","orig",-37778343,null),(25))),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8634__auto___8859),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e8818){var t__8679__auto___8861 = e8818;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"linear-scale","linear-scale",91410306,null),(25)),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"orig","orig",-37778343,null),(25))),new cljs.core.Keyword(null,"actual","actual",107306363),t__8679__auto___8861,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8634__auto___8862 = (new cljs.core.List(null,active_viz.scale.scale_inverted.call(null,inverted_8848,(0)),(new cljs.core.List(null,(100),null,(1),null)),(2),null));
var result__8635__auto___8863 = cljs.core.apply.call(null,cljs.core._EQ_,values__8634__auto___8862);
if(cljs.core.truth_(result__8635__auto___8863)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(0)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8634__auto___8862),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(0)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8634__auto___8862),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e8819){var t__8679__auto___8864 = e8819;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(0)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8679__auto___8864,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8634__auto___8865 = (new cljs.core.List(null,active_viz.scale.scale_inverted.call(null,inverted_8848,(100)),(new cljs.core.List(null,(50),null,(1),null)),(2),null));
var result__8635__auto___8866 = cljs.core.apply.call(null,cljs.core._EQ_,values__8634__auto___8865);
if(cljs.core.truth_(result__8635__auto___8866)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(100)),(50)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8634__auto___8865),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(100)),(50)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8634__auto___8865),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e8820){var t__8679__auto___8867 = e8820;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(100)),(50)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8679__auto___8867,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8634__auto___8868 = (new cljs.core.List(null,active_viz.scale.scale_inverted.call(null,inverted_8848,(200)),(new cljs.core.List(null,(0),null,(1),null)),(2),null));
var result__8635__auto___8869 = cljs.core.apply.call(null,cljs.core._EQ_,values__8634__auto___8868);
if(cljs.core.truth_(result__8635__auto___8869)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(200)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8634__auto___8868),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(200)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8634__auto___8868),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e8821){var t__8679__auto___8870 = e8821;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(200)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8679__auto___8870,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}}finally {cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.rest);
}
cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.conj,"pads a scale");

try{var scale_8871 = active_viz.scale.linear_scale.make_linear_scale.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(100)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(200)], null));
var pad_scale_8872 = active_viz.scale.pad.call(null,scale_8871,(50));
try{var values__8634__auto___8873 = (new cljs.core.List(null,active_viz.scale.scale.call(null,pad_scale_8872,(0)),(new cljs.core.List(null,(50),null,(1),null)),(2),null));
var result__8635__auto___8874 = cljs.core.apply.call(null,cljs.core._EQ_,values__8634__auto___8873);
if(cljs.core.truth_(result__8635__auto___8874)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(0)),(50)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8634__auto___8873),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(0)),(50)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8634__auto___8873),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e8822){var t__8679__auto___8875 = e8822;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(0)),(50)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8679__auto___8875,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8634__auto___8876 = (new cljs.core.List(null,active_viz.scale.scale.call(null,pad_scale_8872,(50)),(new cljs.core.List(null,(150),null,(1),null)),(2),null));
var result__8635__auto___8877 = cljs.core.apply.call(null,cljs.core._EQ_,values__8634__auto___8876);
if(cljs.core.truth_(result__8635__auto___8877)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(50)),(150)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8634__auto___8876),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(50)),(150)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8634__auto___8876),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e8823){var t__8679__auto___8878 = e8823;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(50)),(150)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8679__auto___8878,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8634__auto___8879 = (new cljs.core.List(null,active_viz.scale.scale.call(null,pad_scale_8872,(100)),(new cljs.core.List(null,(250),null,(1),null)),(2),null));
var result__8635__auto___8880 = cljs.core.apply.call(null,cljs.core._EQ_,values__8634__auto___8879);
if(cljs.core.truth_(result__8635__auto___8880)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(100)),(250)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8634__auto___8879),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(100)),(250)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8634__auto___8879),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e8824){var t__8679__auto___8881 = e8824;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(100)),(250)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8679__auto___8881,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8634__auto___8882 = (new cljs.core.List(null,active_viz.scale.scale_inverted.call(null,pad_scale_8872,(50)),(new cljs.core.List(null,(0),null,(1),null)),(2),null));
var result__8635__auto___8883 = cljs.core.apply.call(null,cljs.core._EQ_,values__8634__auto___8882);
if(cljs.core.truth_(result__8635__auto___8883)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(50)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8634__auto___8882),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(50)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8634__auto___8882),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e8825){var t__8679__auto___8884 = e8825;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(50)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8679__auto___8884,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8634__auto___8885 = (new cljs.core.List(null,active_viz.scale.scale_inverted.call(null,pad_scale_8872,(150)),(new cljs.core.List(null,(50),null,(1),null)),(2),null));
var result__8635__auto___8886 = cljs.core.apply.call(null,cljs.core._EQ_,values__8634__auto___8885);
if(cljs.core.truth_(result__8635__auto___8886)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(150)),(50)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8634__auto___8885),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(150)),(50)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8634__auto___8885),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e8826){var t__8679__auto___8887 = e8826;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(150)),(50)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8679__auto___8887,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8634__auto___8888 = (new cljs.core.List(null,active_viz.scale.scale_inverted.call(null,pad_scale_8872,(250)),(new cljs.core.List(null,(100),null,(1),null)),(2),null));
var result__8635__auto___8889 = cljs.core.apply.call(null,cljs.core._EQ_,values__8634__auto___8888);
if(cljs.core.truth_(result__8635__auto___8889)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(250)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8634__auto___8888),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(250)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8634__auto___8888),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e8827){var t__8679__auto___8890 = e8827;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(250)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8679__auto___8890,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}}finally {cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.rest);
}
cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.conj,"pads a scale to zero");

try{var neg_scale = active_viz.scale.linear_scale.make_linear_scale.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(-100),(100)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(-200),(200)], null));
var pad_scale = active_viz.scale.pad_to_zero.call(null,neg_scale);
var pos_scale = active_viz.scale.linear_scale.make_linear_scale.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(-100),(100)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(200),(600)], null));
var pad_scale_2 = active_viz.scale.pad_to_zero.call(null,pos_scale);
try{var values__8634__auto___8891 = (new cljs.core.List(null,active_viz.scale.scale.call(null,pad_scale,(-100)),(new cljs.core.List(null,(0),null,(1),null)),(2),null));
var result__8635__auto___8892 = cljs.core.apply.call(null,cljs.core._EQ_,values__8634__auto___8891);
if(cljs.core.truth_(result__8635__auto___8892)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(-100)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8634__auto___8891),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(-100)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8634__auto___8891),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e8828){var t__8679__auto___8893 = e8828;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(-100)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8679__auto___8893,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8634__auto___8894 = (new cljs.core.List(null,active_viz.scale.scale.call(null,pad_scale,(100)),(new cljs.core.List(null,(400),null,(1),null)),(2),null));
var result__8635__auto___8895 = cljs.core.apply.call(null,cljs.core._EQ_,values__8634__auto___8894);
if(cljs.core.truth_(result__8635__auto___8895)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(100)),(400)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8634__auto___8894),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(100)),(400)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8634__auto___8894),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e8829){var t__8679__auto___8896 = e8829;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(100)),(400)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8679__auto___8896,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8634__auto___8897 = (new cljs.core.List(null,active_viz.scale.scale.call(null,pad_scale_2,(-100)),(new cljs.core.List(null,(0),null,(1),null)),(2),null));
var result__8635__auto___8898 = cljs.core.apply.call(null,cljs.core._EQ_,values__8634__auto___8897);
if(cljs.core.truth_(result__8635__auto___8898)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(-100)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8634__auto___8897),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(-100)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8634__auto___8897),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e8830){var t__8679__auto___8899 = e8830;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(-100)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8679__auto___8899,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8634__auto___8900 = (new cljs.core.List(null,active_viz.scale.scale.call(null,pad_scale_2,(100)),(new cljs.core.List(null,(400),null,(1),null)),(2),null));
var result__8635__auto___8901 = cljs.core.apply.call(null,cljs.core._EQ_,values__8634__auto___8900);
if(cljs.core.truth_(result__8635__auto___8901)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(100)),(400)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8634__auto___8900),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(100)),(400)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8634__auto___8900),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e8831){var t__8679__auto___8902 = e8831;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(100)),(400)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8679__auto___8902,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8634__auto___8903 = (new cljs.core.List(null,active_viz.scale.scale_inverted.call(null,pad_scale,(0)),(new cljs.core.List(null,(-100),null,(1),null)),(2),null));
var result__8635__auto___8904 = cljs.core.apply.call(null,cljs.core._EQ_,values__8634__auto___8903);
if(cljs.core.truth_(result__8635__auto___8904)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(0)),(-100)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8634__auto___8903),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(0)),(-100)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8634__auto___8903),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e8832){var t__8679__auto___8905 = e8832;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(0)),(-100)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8679__auto___8905,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8634__auto___8906 = (new cljs.core.List(null,active_viz.scale.scale_inverted.call(null,pad_scale,(400)),(new cljs.core.List(null,(100),null,(1),null)),(2),null));
var result__8635__auto___8907 = cljs.core.apply.call(null,cljs.core._EQ_,values__8634__auto___8906);
if(cljs.core.truth_(result__8635__auto___8907)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(400)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8634__auto___8906),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(400)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8634__auto___8906),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e8833){var t__8679__auto___8908 = e8833;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(400)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8679__auto___8908,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8634__auto___8909 = (new cljs.core.List(null,active_viz.scale.scale_inverted.call(null,pad_scale_2,(0)),(new cljs.core.List(null,(-100),null,(1),null)),(2),null));
var result__8635__auto___8910 = cljs.core.apply.call(null,cljs.core._EQ_,values__8634__auto___8909);
if(cljs.core.truth_(result__8635__auto___8910)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(0)),(-100)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8634__auto___8909),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(0)),(-100)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8634__auto___8909),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e8834){var t__8679__auto___8911 = e8834;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(0)),(-100)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8679__auto___8911,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8634__auto__ = (new cljs.core.List(null,active_viz.scale.scale_inverted.call(null,pad_scale_2,(400)),(new cljs.core.List(null,(100),null,(1),null)),(2),null));
var result__8635__auto__ = cljs.core.apply.call(null,cljs.core._EQ_,values__8634__auto__);
if(cljs.core.truth_(result__8635__auto__)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(400)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8634__auto__),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(400)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8634__auto__),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

return result__8635__auto__;
}catch (e8835){var t__8679__auto__ = e8835;
return cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(400)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8679__auto__,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}}finally {cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.rest);
}});

active_viz.scale_test.scale.cljs$lang$var = new cljs.core.Var(function(){return active_viz.scale_test.scale;},new cljs.core.Symbol("active-viz.scale-test","scale","active-viz.scale-test/scale",1189529197,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"active-viz.scale-test","active-viz.scale-test",-1253028839,null),new cljs.core.Symbol(null,"scale","scale",1410104174,null),"/home/simon/git/active-viz/test/active_viz/scale_test.cljs",15,1,16,16,cljs.core.List.EMPTY,null,(cljs.core.truth_(active_viz.scale_test.scale)?active_viz.scale_test.scale.cljs$lang$test:null)]));

//# sourceMappingURL=scale_test.js.map
