// Compiled by ClojureScript 1.10.339 {}
goog.provide('active_viz.scale_test');
goog.require('cljs.core');
goog.require('active_viz.scale');
goog.require('active_viz.scale.linear_scale');
goog.require('active_viz.scale.time_scale');
goog.require('cljs_time.core');
goog.require('cljs.test');
active_viz.scale_test.eps = 1.0E-5;
active_viz.scale_test.eq = (function active_viz$scale_test$eq(a,b){
return ((((b + active_viz.scale_test.eps) > a)) && (((b - active_viz.scale_test.eps) < a)));
});
active_viz.scale_test.scale = (function active_viz$scale_test$scale(){
return cljs.test.test_var.call(null,active_viz.scale_test.scale.cljs$lang$var);
});
active_viz.scale_test.scale.cljs$lang$test = (function (){
cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.conj,"combines two scales properly");

try{var start_date_8979 = cljs_time.core.date_time.call(null,(2018),(1),(1),(0),(0),(0),(0));
var end_date_8980 = cljs_time.core.date_time.call(null,(2019),(1),(1),(0),(0),(0),(0));
var time_scale_8981 = active_viz.scale.time_scale.make_time_scale.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_date_8979,end_date_8980], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(100),(246)], null));
var linear_scale_8982 = active_viz.scale.linear_scale.make_linear_scale.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(100),(246)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(1000)], null));
var combined_scale_8983 = active_viz.scale._GT__GT_.call(null,time_scale_8981,linear_scale_8982);
try{var values__8667__auto___8984 = (new cljs.core.List(null,active_viz.scale.scale.call(null,combined_scale_8983,start_date_8979),(new cljs.core.List(null,(0),null,(1),null)),(2),null));
var result__8668__auto___8985 = cljs.core.apply.call(null,cljs.core._EQ_,values__8667__auto___8984);
if(cljs.core.truth_(result__8668__auto___8985)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"combined-scale","combined-scale",-1463311509,null),new cljs.core.Symbol(null,"start-date","start-date",1935700258,null)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8667__auto___8984),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"combined-scale","combined-scale",-1463311509,null),new cljs.core.Symbol(null,"start-date","start-date",1935700258,null)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8667__auto___8984),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e8956){var t__8712__auto___8986 = e8956;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"combined-scale","combined-scale",-1463311509,null),new cljs.core.Symbol(null,"start-date","start-date",1935700258,null)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8712__auto___8986,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8667__auto___8987 = (new cljs.core.List(null,(1000),(new cljs.core.List(null,active_viz.scale.scale.call(null,combined_scale_8983,end_date_8980),null,(1),null)),(2),null));
var result__8668__auto___8988 = cljs.core.apply.call(null,active_viz.scale_test.eq,values__8667__auto___8987);
if(cljs.core.truth_(result__8668__auto___8988)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"eq","eq",1021992460,null),(1000),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"combined-scale","combined-scale",-1463311509,null),new cljs.core.Symbol(null,"end-date","end-date",1432271885,null))),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,active_viz.scale_test.eq,values__8667__auto___8987),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"eq","eq",1021992460,null),(1000),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"combined-scale","combined-scale",-1463311509,null),new cljs.core.Symbol(null,"end-date","end-date",1432271885,null))),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"eq","eq",1021992460,null),values__8667__auto___8987),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e8957){var t__8712__auto___8989 = e8957;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"eq","eq",1021992460,null),(1000),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"combined-scale","combined-scale",-1463311509,null),new cljs.core.Symbol(null,"end-date","end-date",1432271885,null))),new cljs.core.Keyword(null,"actual","actual",107306363),t__8712__auto___8989,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}}finally {cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.rest);
}
cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.conj,"inverts a scale range");

try{var linear_scale_8990 = active_viz.scale.linear_scale.make_linear_scale.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(100)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(200)], null));
var inverted_8991 = active_viz.scale.invert.call(null,linear_scale_8990);
var orig_8992 = active_viz.scale.invert.call(null,inverted_8991);
try{var values__8667__auto___8993 = (new cljs.core.List(null,active_viz.scale.scale.call(null,inverted_8991,(0)),(new cljs.core.List(null,(200),null,(1),null)),(2),null));
var result__8668__auto___8994 = cljs.core.apply.call(null,cljs.core._EQ_,values__8667__auto___8993);
if(cljs.core.truth_(result__8668__auto___8994)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(0)),(200)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8667__auto___8993),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(0)),(200)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8667__auto___8993),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e8958){var t__8712__auto___8995 = e8958;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(0)),(200)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8712__auto___8995,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8667__auto___8996 = (new cljs.core.List(null,active_viz.scale.scale.call(null,inverted_8991,(50)),(new cljs.core.List(null,(100),null,(1),null)),(2),null));
var result__8668__auto___8997 = cljs.core.apply.call(null,cljs.core._EQ_,values__8667__auto___8996);
if(cljs.core.truth_(result__8668__auto___8997)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(50)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8667__auto___8996),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(50)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8667__auto___8996),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e8959){var t__8712__auto___8998 = e8959;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(50)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8712__auto___8998,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8667__auto___8999 = (new cljs.core.List(null,active_viz.scale.scale.call(null,inverted_8991,(100)),(new cljs.core.List(null,(0),null,(1),null)),(2),null));
var result__8668__auto___9000 = cljs.core.apply.call(null,cljs.core._EQ_,values__8667__auto___8999);
if(cljs.core.truth_(result__8668__auto___9000)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(100)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8667__auto___8999),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(100)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8667__auto___8999),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e8960){var t__8712__auto___9001 = e8960;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(100)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8712__auto___9001,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8667__auto___9002 = (new cljs.core.List(null,active_viz.scale.scale.call(null,linear_scale_8990,(25)),(new cljs.core.List(null,active_viz.scale.scale.call(null,orig_8992,(25)),null,(1),null)),(2),null));
var result__8668__auto___9003 = cljs.core.apply.call(null,cljs.core._EQ_,values__8667__auto___9002);
if(cljs.core.truth_(result__8668__auto___9003)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"linear-scale","linear-scale",91410306,null),(25)),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"orig","orig",-37778343,null),(25))),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8667__auto___9002),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"linear-scale","linear-scale",91410306,null),(25)),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"orig","orig",-37778343,null),(25))),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8667__auto___9002),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e8961){var t__8712__auto___9004 = e8961;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"linear-scale","linear-scale",91410306,null),(25)),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"orig","orig",-37778343,null),(25))),new cljs.core.Keyword(null,"actual","actual",107306363),t__8712__auto___9004,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8667__auto___9005 = (new cljs.core.List(null,active_viz.scale.scale_inverted.call(null,inverted_8991,(0)),(new cljs.core.List(null,(100),null,(1),null)),(2),null));
var result__8668__auto___9006 = cljs.core.apply.call(null,cljs.core._EQ_,values__8667__auto___9005);
if(cljs.core.truth_(result__8668__auto___9006)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(0)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8667__auto___9005),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(0)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8667__auto___9005),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e8962){var t__8712__auto___9007 = e8962;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(0)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8712__auto___9007,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8667__auto___9008 = (new cljs.core.List(null,active_viz.scale.scale_inverted.call(null,inverted_8991,(100)),(new cljs.core.List(null,(50),null,(1),null)),(2),null));
var result__8668__auto___9009 = cljs.core.apply.call(null,cljs.core._EQ_,values__8667__auto___9008);
if(cljs.core.truth_(result__8668__auto___9009)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(100)),(50)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8667__auto___9008),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(100)),(50)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8667__auto___9008),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e8963){var t__8712__auto___9010 = e8963;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(100)),(50)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8712__auto___9010,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8667__auto___9011 = (new cljs.core.List(null,active_viz.scale.scale_inverted.call(null,inverted_8991,(200)),(new cljs.core.List(null,(0),null,(1),null)),(2),null));
var result__8668__auto___9012 = cljs.core.apply.call(null,cljs.core._EQ_,values__8667__auto___9011);
if(cljs.core.truth_(result__8668__auto___9012)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(200)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8667__auto___9011),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(200)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8667__auto___9011),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e8964){var t__8712__auto___9013 = e8964;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(200)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8712__auto___9013,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}}finally {cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.rest);
}
cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.conj,"pads a scale");

try{var scale_9014 = active_viz.scale.linear_scale.make_linear_scale.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(100)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(200)], null));
var pad_scale_9015 = active_viz.scale.pad.call(null,scale_9014,(50));
try{var values__8667__auto___9016 = (new cljs.core.List(null,active_viz.scale.scale.call(null,pad_scale_9015,(0)),(new cljs.core.List(null,(50),null,(1),null)),(2),null));
var result__8668__auto___9017 = cljs.core.apply.call(null,cljs.core._EQ_,values__8667__auto___9016);
if(cljs.core.truth_(result__8668__auto___9017)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(0)),(50)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8667__auto___9016),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(0)),(50)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8667__auto___9016),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e8965){var t__8712__auto___9018 = e8965;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(0)),(50)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8712__auto___9018,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8667__auto___9019 = (new cljs.core.List(null,active_viz.scale.scale.call(null,pad_scale_9015,(50)),(new cljs.core.List(null,(150),null,(1),null)),(2),null));
var result__8668__auto___9020 = cljs.core.apply.call(null,cljs.core._EQ_,values__8667__auto___9019);
if(cljs.core.truth_(result__8668__auto___9020)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(50)),(150)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8667__auto___9019),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(50)),(150)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8667__auto___9019),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e8966){var t__8712__auto___9021 = e8966;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(50)),(150)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8712__auto___9021,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8667__auto___9022 = (new cljs.core.List(null,active_viz.scale.scale.call(null,pad_scale_9015,(100)),(new cljs.core.List(null,(250),null,(1),null)),(2),null));
var result__8668__auto___9023 = cljs.core.apply.call(null,cljs.core._EQ_,values__8667__auto___9022);
if(cljs.core.truth_(result__8668__auto___9023)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(100)),(250)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8667__auto___9022),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(100)),(250)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8667__auto___9022),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e8967){var t__8712__auto___9024 = e8967;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(100)),(250)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8712__auto___9024,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8667__auto___9025 = (new cljs.core.List(null,active_viz.scale.scale_inverted.call(null,pad_scale_9015,(50)),(new cljs.core.List(null,(0),null,(1),null)),(2),null));
var result__8668__auto___9026 = cljs.core.apply.call(null,cljs.core._EQ_,values__8667__auto___9025);
if(cljs.core.truth_(result__8668__auto___9026)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(50)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8667__auto___9025),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(50)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8667__auto___9025),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e8968){var t__8712__auto___9027 = e8968;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(50)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8712__auto___9027,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8667__auto___9028 = (new cljs.core.List(null,active_viz.scale.scale_inverted.call(null,pad_scale_9015,(150)),(new cljs.core.List(null,(50),null,(1),null)),(2),null));
var result__8668__auto___9029 = cljs.core.apply.call(null,cljs.core._EQ_,values__8667__auto___9028);
if(cljs.core.truth_(result__8668__auto___9029)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(150)),(50)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8667__auto___9028),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(150)),(50)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8667__auto___9028),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e8969){var t__8712__auto___9030 = e8969;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(150)),(50)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8712__auto___9030,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8667__auto___9031 = (new cljs.core.List(null,active_viz.scale.scale_inverted.call(null,pad_scale_9015,(250)),(new cljs.core.List(null,(100),null,(1),null)),(2),null));
var result__8668__auto___9032 = cljs.core.apply.call(null,cljs.core._EQ_,values__8667__auto___9031);
if(cljs.core.truth_(result__8668__auto___9032)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(250)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8667__auto___9031),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(250)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8667__auto___9031),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e8970){var t__8712__auto___9033 = e8970;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(250)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8712__auto___9033,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}}finally {cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.rest);
}
cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.conj,"pads a scale to zero");

try{var neg_scale = active_viz.scale.linear_scale.make_linear_scale.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(-100),(100)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(-200),(200)], null));
var pad_scale = active_viz.scale.pad_to_zero.call(null,neg_scale);
var pos_scale = active_viz.scale.linear_scale.make_linear_scale.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(-100),(100)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(200),(600)], null));
var pad_scale_2 = active_viz.scale.pad_to_zero.call(null,pos_scale);
try{var values__8667__auto___9034 = (new cljs.core.List(null,active_viz.scale.scale.call(null,pad_scale,(-100)),(new cljs.core.List(null,(0),null,(1),null)),(2),null));
var result__8668__auto___9035 = cljs.core.apply.call(null,cljs.core._EQ_,values__8667__auto___9034);
if(cljs.core.truth_(result__8668__auto___9035)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(-100)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8667__auto___9034),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(-100)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8667__auto___9034),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e8971){var t__8712__auto___9036 = e8971;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(-100)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8712__auto___9036,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8667__auto___9037 = (new cljs.core.List(null,active_viz.scale.scale.call(null,pad_scale,(100)),(new cljs.core.List(null,(400),null,(1),null)),(2),null));
var result__8668__auto___9038 = cljs.core.apply.call(null,cljs.core._EQ_,values__8667__auto___9037);
if(cljs.core.truth_(result__8668__auto___9038)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(100)),(400)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8667__auto___9037),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(100)),(400)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8667__auto___9037),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e8972){var t__8712__auto___9039 = e8972;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(100)),(400)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8712__auto___9039,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8667__auto___9040 = (new cljs.core.List(null,active_viz.scale.scale.call(null,pad_scale_2,(-100)),(new cljs.core.List(null,(0),null,(1),null)),(2),null));
var result__8668__auto___9041 = cljs.core.apply.call(null,cljs.core._EQ_,values__8667__auto___9040);
if(cljs.core.truth_(result__8668__auto___9041)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(-100)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8667__auto___9040),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(-100)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8667__auto___9040),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e8973){var t__8712__auto___9042 = e8973;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(-100)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8712__auto___9042,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8667__auto___9043 = (new cljs.core.List(null,active_viz.scale.scale.call(null,pad_scale_2,(100)),(new cljs.core.List(null,(400),null,(1),null)),(2),null));
var result__8668__auto___9044 = cljs.core.apply.call(null,cljs.core._EQ_,values__8667__auto___9043);
if(cljs.core.truth_(result__8668__auto___9044)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(100)),(400)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8667__auto___9043),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(100)),(400)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8667__auto___9043),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e8974){var t__8712__auto___9045 = e8974;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(100)),(400)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8712__auto___9045,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8667__auto___9046 = (new cljs.core.List(null,active_viz.scale.scale_inverted.call(null,pad_scale,(0)),(new cljs.core.List(null,(-100),null,(1),null)),(2),null));
var result__8668__auto___9047 = cljs.core.apply.call(null,cljs.core._EQ_,values__8667__auto___9046);
if(cljs.core.truth_(result__8668__auto___9047)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(0)),(-100)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8667__auto___9046),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(0)),(-100)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8667__auto___9046),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e8975){var t__8712__auto___9048 = e8975;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(0)),(-100)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8712__auto___9048,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8667__auto___9049 = (new cljs.core.List(null,active_viz.scale.scale_inverted.call(null,pad_scale,(400)),(new cljs.core.List(null,(100),null,(1),null)),(2),null));
var result__8668__auto___9050 = cljs.core.apply.call(null,cljs.core._EQ_,values__8667__auto___9049);
if(cljs.core.truth_(result__8668__auto___9050)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(400)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8667__auto___9049),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(400)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8667__auto___9049),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e8976){var t__8712__auto___9051 = e8976;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(400)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8712__auto___9051,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8667__auto___9052 = (new cljs.core.List(null,active_viz.scale.scale_inverted.call(null,pad_scale_2,(0)),(new cljs.core.List(null,(-100),null,(1),null)),(2),null));
var result__8668__auto___9053 = cljs.core.apply.call(null,cljs.core._EQ_,values__8667__auto___9052);
if(cljs.core.truth_(result__8668__auto___9053)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(0)),(-100)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8667__auto___9052),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(0)),(-100)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8667__auto___9052),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e8977){var t__8712__auto___9054 = e8977;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(0)),(-100)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8712__auto___9054,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8667__auto__ = (new cljs.core.List(null,active_viz.scale.scale_inverted.call(null,pad_scale_2,(400)),(new cljs.core.List(null,(100),null,(1),null)),(2),null));
var result__8668__auto__ = cljs.core.apply.call(null,cljs.core._EQ_,values__8667__auto__);
if(cljs.core.truth_(result__8668__auto__)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(400)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8667__auto__),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(400)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8667__auto__),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

return result__8668__auto__;
}catch (e8978){var t__8712__auto__ = e8978;
return cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(400)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8712__auto__,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}}finally {cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.rest);
}});

active_viz.scale_test.scale.cljs$lang$var = new cljs.core.Var(function(){return active_viz.scale_test.scale;},new cljs.core.Symbol("active-viz.scale-test","scale","active-viz.scale-test/scale",1189529197,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"active-viz.scale-test","active-viz.scale-test",-1253028839,null),new cljs.core.Symbol(null,"scale","scale",1410104174,null),"/home/simon/git/active-viz/test/active_viz/scale_test.cljs",15,1,16,16,cljs.core.List.EMPTY,null,(cljs.core.truth_(active_viz.scale_test.scale)?active_viz.scale_test.scale.cljs$lang$test:null)]));

//# sourceMappingURL=scale_test.js.map
