// Compiled by ClojureScript 1.10.339 {}
goog.provide('active_viz.scale_test');
goog.require('cljs.core');
goog.require('active_viz.scale');
goog.require('active_viz.scale.linear_scale');
goog.require('active_viz.scale.time_scale');
goog.require('cljs_time.core');
goog.require('cljs.test');
active_viz.scale_test.eps = 1.0E-5;
active_viz.scale_test.eq = (function active_viz$scale_test$eq(a,b){
return ((((b + active_viz.scale_test.eps) > a)) && (((b - active_viz.scale_test.eps) < a)));
});
active_viz.scale_test.scale = (function active_viz$scale_test$scale(){
return cljs.test.test_var.call(null,active_viz.scale_test.scale.cljs$lang$var);
});
active_viz.scale_test.scale.cljs$lang$test = (function (){
cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.conj,"combines two scales properly");

try{var start_date_9022 = cljs_time.core.date_time.call(null,(2018),(1),(1),(0),(0),(0),(0));
var end_date_9023 = cljs_time.core.date_time.call(null,(2019),(1),(1),(0),(0),(0),(0));
var time_scale_9024 = active_viz.scale.time_scale.make_time_scale.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_date_9022,end_date_9023], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(100),(246)], null));
var linear_scale_9025 = active_viz.scale.linear_scale.make_linear_scale.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(100),(246)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(1000)], null));
var combined_scale_9026 = active_viz.scale._GT__GT_.call(null,time_scale_9024,linear_scale_9025);
try{var values__8710__auto___9027 = (new cljs.core.List(null,active_viz.scale.scale.call(null,combined_scale_9026,start_date_9022),(new cljs.core.List(null,(0),null,(1),null)),(2),null));
var result__8711__auto___9028 = cljs.core.apply.call(null,cljs.core._EQ_,values__8710__auto___9027);
if(cljs.core.truth_(result__8711__auto___9028)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"combined-scale","combined-scale",-1463311509,null),new cljs.core.Symbol(null,"start-date","start-date",1935700258,null)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8710__auto___9027),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"combined-scale","combined-scale",-1463311509,null),new cljs.core.Symbol(null,"start-date","start-date",1935700258,null)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8710__auto___9027),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e8999){var t__8755__auto___9029 = e8999;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"combined-scale","combined-scale",-1463311509,null),new cljs.core.Symbol(null,"start-date","start-date",1935700258,null)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8755__auto___9029,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8710__auto___9030 = (new cljs.core.List(null,(1000),(new cljs.core.List(null,active_viz.scale.scale.call(null,combined_scale_9026,end_date_9023),null,(1),null)),(2),null));
var result__8711__auto___9031 = cljs.core.apply.call(null,active_viz.scale_test.eq,values__8710__auto___9030);
if(cljs.core.truth_(result__8711__auto___9031)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"eq","eq",1021992460,null),(1000),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"combined-scale","combined-scale",-1463311509,null),new cljs.core.Symbol(null,"end-date","end-date",1432271885,null))),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,active_viz.scale_test.eq,values__8710__auto___9030),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"eq","eq",1021992460,null),(1000),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"combined-scale","combined-scale",-1463311509,null),new cljs.core.Symbol(null,"end-date","end-date",1432271885,null))),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"eq","eq",1021992460,null),values__8710__auto___9030),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9000){var t__8755__auto___9032 = e9000;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"eq","eq",1021992460,null),(1000),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"combined-scale","combined-scale",-1463311509,null),new cljs.core.Symbol(null,"end-date","end-date",1432271885,null))),new cljs.core.Keyword(null,"actual","actual",107306363),t__8755__auto___9032,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}}finally {cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.rest);
}
cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.conj,"inverts a scale range");

try{var linear_scale_9033 = active_viz.scale.linear_scale.make_linear_scale.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(100)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(200)], null));
var inverted_9034 = active_viz.scale.invert.call(null,linear_scale_9033);
var orig_9035 = active_viz.scale.invert.call(null,inverted_9034);
try{var values__8710__auto___9036 = (new cljs.core.List(null,active_viz.scale.scale.call(null,inverted_9034,(0)),(new cljs.core.List(null,(200),null,(1),null)),(2),null));
var result__8711__auto___9037 = cljs.core.apply.call(null,cljs.core._EQ_,values__8710__auto___9036);
if(cljs.core.truth_(result__8711__auto___9037)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(0)),(200)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8710__auto___9036),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(0)),(200)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8710__auto___9036),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9001){var t__8755__auto___9038 = e9001;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(0)),(200)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8755__auto___9038,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8710__auto___9039 = (new cljs.core.List(null,active_viz.scale.scale.call(null,inverted_9034,(50)),(new cljs.core.List(null,(100),null,(1),null)),(2),null));
var result__8711__auto___9040 = cljs.core.apply.call(null,cljs.core._EQ_,values__8710__auto___9039);
if(cljs.core.truth_(result__8711__auto___9040)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(50)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8710__auto___9039),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(50)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8710__auto___9039),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9002){var t__8755__auto___9041 = e9002;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(50)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8755__auto___9041,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8710__auto___9042 = (new cljs.core.List(null,active_viz.scale.scale.call(null,inverted_9034,(100)),(new cljs.core.List(null,(0),null,(1),null)),(2),null));
var result__8711__auto___9043 = cljs.core.apply.call(null,cljs.core._EQ_,values__8710__auto___9042);
if(cljs.core.truth_(result__8711__auto___9043)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(100)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8710__auto___9042),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(100)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8710__auto___9042),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9003){var t__8755__auto___9044 = e9003;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(100)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8755__auto___9044,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8710__auto___9045 = (new cljs.core.List(null,active_viz.scale.scale.call(null,linear_scale_9033,(25)),(new cljs.core.List(null,active_viz.scale.scale.call(null,orig_9035,(25)),null,(1),null)),(2),null));
var result__8711__auto___9046 = cljs.core.apply.call(null,cljs.core._EQ_,values__8710__auto___9045);
if(cljs.core.truth_(result__8711__auto___9046)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"linear-scale","linear-scale",91410306,null),(25)),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"orig","orig",-37778343,null),(25))),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8710__auto___9045),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"linear-scale","linear-scale",91410306,null),(25)),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"orig","orig",-37778343,null),(25))),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8710__auto___9045),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9004){var t__8755__auto___9047 = e9004;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"linear-scale","linear-scale",91410306,null),(25)),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"orig","orig",-37778343,null),(25))),new cljs.core.Keyword(null,"actual","actual",107306363),t__8755__auto___9047,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8710__auto___9048 = (new cljs.core.List(null,active_viz.scale.scale_inverted.call(null,inverted_9034,(0)),(new cljs.core.List(null,(100),null,(1),null)),(2),null));
var result__8711__auto___9049 = cljs.core.apply.call(null,cljs.core._EQ_,values__8710__auto___9048);
if(cljs.core.truth_(result__8711__auto___9049)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(0)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8710__auto___9048),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(0)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8710__auto___9048),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9005){var t__8755__auto___9050 = e9005;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(0)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8755__auto___9050,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8710__auto___9051 = (new cljs.core.List(null,active_viz.scale.scale_inverted.call(null,inverted_9034,(100)),(new cljs.core.List(null,(50),null,(1),null)),(2),null));
var result__8711__auto___9052 = cljs.core.apply.call(null,cljs.core._EQ_,values__8710__auto___9051);
if(cljs.core.truth_(result__8711__auto___9052)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(100)),(50)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8710__auto___9051),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(100)),(50)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8710__auto___9051),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9006){var t__8755__auto___9053 = e9006;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(100)),(50)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8755__auto___9053,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8710__auto___9054 = (new cljs.core.List(null,active_viz.scale.scale_inverted.call(null,inverted_9034,(200)),(new cljs.core.List(null,(0),null,(1),null)),(2),null));
var result__8711__auto___9055 = cljs.core.apply.call(null,cljs.core._EQ_,values__8710__auto___9054);
if(cljs.core.truth_(result__8711__auto___9055)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(200)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8710__auto___9054),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(200)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8710__auto___9054),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9007){var t__8755__auto___9056 = e9007;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(200)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8755__auto___9056,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}}finally {cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.rest);
}
cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.conj,"pads a scale");

try{var scale_9057 = active_viz.scale.linear_scale.make_linear_scale.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(100)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(200)], null));
var pad_scale_9058 = active_viz.scale.pad.call(null,scale_9057,(50));
try{var values__8710__auto___9059 = (new cljs.core.List(null,active_viz.scale.scale.call(null,pad_scale_9058,(0)),(new cljs.core.List(null,(50),null,(1),null)),(2),null));
var result__8711__auto___9060 = cljs.core.apply.call(null,cljs.core._EQ_,values__8710__auto___9059);
if(cljs.core.truth_(result__8711__auto___9060)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(0)),(50)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8710__auto___9059),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(0)),(50)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8710__auto___9059),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9008){var t__8755__auto___9061 = e9008;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(0)),(50)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8755__auto___9061,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8710__auto___9062 = (new cljs.core.List(null,active_viz.scale.scale.call(null,pad_scale_9058,(50)),(new cljs.core.List(null,(150),null,(1),null)),(2),null));
var result__8711__auto___9063 = cljs.core.apply.call(null,cljs.core._EQ_,values__8710__auto___9062);
if(cljs.core.truth_(result__8711__auto___9063)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(50)),(150)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8710__auto___9062),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(50)),(150)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8710__auto___9062),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9009){var t__8755__auto___9064 = e9009;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(50)),(150)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8755__auto___9064,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8710__auto___9065 = (new cljs.core.List(null,active_viz.scale.scale.call(null,pad_scale_9058,(100)),(new cljs.core.List(null,(250),null,(1),null)),(2),null));
var result__8711__auto___9066 = cljs.core.apply.call(null,cljs.core._EQ_,values__8710__auto___9065);
if(cljs.core.truth_(result__8711__auto___9066)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(100)),(250)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8710__auto___9065),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(100)),(250)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8710__auto___9065),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9010){var t__8755__auto___9067 = e9010;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(100)),(250)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8755__auto___9067,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8710__auto___9068 = (new cljs.core.List(null,active_viz.scale.scale_inverted.call(null,pad_scale_9058,(50)),(new cljs.core.List(null,(0),null,(1),null)),(2),null));
var result__8711__auto___9069 = cljs.core.apply.call(null,cljs.core._EQ_,values__8710__auto___9068);
if(cljs.core.truth_(result__8711__auto___9069)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(50)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8710__auto___9068),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(50)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8710__auto___9068),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9011){var t__8755__auto___9070 = e9011;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(50)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8755__auto___9070,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8710__auto___9071 = (new cljs.core.List(null,active_viz.scale.scale_inverted.call(null,pad_scale_9058,(150)),(new cljs.core.List(null,(50),null,(1),null)),(2),null));
var result__8711__auto___9072 = cljs.core.apply.call(null,cljs.core._EQ_,values__8710__auto___9071);
if(cljs.core.truth_(result__8711__auto___9072)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(150)),(50)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8710__auto___9071),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(150)),(50)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8710__auto___9071),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9012){var t__8755__auto___9073 = e9012;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(150)),(50)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8755__auto___9073,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8710__auto___9074 = (new cljs.core.List(null,active_viz.scale.scale_inverted.call(null,pad_scale_9058,(250)),(new cljs.core.List(null,(100),null,(1),null)),(2),null));
var result__8711__auto___9075 = cljs.core.apply.call(null,cljs.core._EQ_,values__8710__auto___9074);
if(cljs.core.truth_(result__8711__auto___9075)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(250)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8710__auto___9074),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(250)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8710__auto___9074),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9013){var t__8755__auto___9076 = e9013;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(250)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8755__auto___9076,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}}finally {cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.rest);
}
cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.conj,"pads a scale to zero");

try{var neg_scale = active_viz.scale.linear_scale.make_linear_scale.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(-100),(100)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(-200),(200)], null));
var pad_scale = active_viz.scale.pad_to_zero.call(null,neg_scale);
var pos_scale = active_viz.scale.linear_scale.make_linear_scale.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(-100),(100)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(200),(600)], null));
var pad_scale_2 = active_viz.scale.pad_to_zero.call(null,pos_scale);
try{var values__8710__auto___9077 = (new cljs.core.List(null,active_viz.scale.scale.call(null,pad_scale,(-100)),(new cljs.core.List(null,(0),null,(1),null)),(2),null));
var result__8711__auto___9078 = cljs.core.apply.call(null,cljs.core._EQ_,values__8710__auto___9077);
if(cljs.core.truth_(result__8711__auto___9078)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(-100)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8710__auto___9077),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(-100)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8710__auto___9077),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9014){var t__8755__auto___9079 = e9014;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(-100)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8755__auto___9079,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8710__auto___9080 = (new cljs.core.List(null,active_viz.scale.scale.call(null,pad_scale,(100)),(new cljs.core.List(null,(400),null,(1),null)),(2),null));
var result__8711__auto___9081 = cljs.core.apply.call(null,cljs.core._EQ_,values__8710__auto___9080);
if(cljs.core.truth_(result__8711__auto___9081)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(100)),(400)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8710__auto___9080),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(100)),(400)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8710__auto___9080),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9015){var t__8755__auto___9082 = e9015;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(100)),(400)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8755__auto___9082,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8710__auto___9083 = (new cljs.core.List(null,active_viz.scale.scale.call(null,pad_scale_2,(-100)),(new cljs.core.List(null,(0),null,(1),null)),(2),null));
var result__8711__auto___9084 = cljs.core.apply.call(null,cljs.core._EQ_,values__8710__auto___9083);
if(cljs.core.truth_(result__8711__auto___9084)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(-100)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8710__auto___9083),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(-100)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8710__auto___9083),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9016){var t__8755__auto___9085 = e9016;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(-100)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8755__auto___9085,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8710__auto___9086 = (new cljs.core.List(null,active_viz.scale.scale.call(null,pad_scale_2,(100)),(new cljs.core.List(null,(400),null,(1),null)),(2),null));
var result__8711__auto___9087 = cljs.core.apply.call(null,cljs.core._EQ_,values__8710__auto___9086);
if(cljs.core.truth_(result__8711__auto___9087)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(100)),(400)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8710__auto___9086),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(100)),(400)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8710__auto___9086),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9017){var t__8755__auto___9088 = e9017;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(100)),(400)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8755__auto___9088,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8710__auto___9089 = (new cljs.core.List(null,active_viz.scale.scale_inverted.call(null,pad_scale,(0)),(new cljs.core.List(null,(-100),null,(1),null)),(2),null));
var result__8711__auto___9090 = cljs.core.apply.call(null,cljs.core._EQ_,values__8710__auto___9089);
if(cljs.core.truth_(result__8711__auto___9090)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(0)),(-100)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8710__auto___9089),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(0)),(-100)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8710__auto___9089),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9018){var t__8755__auto___9091 = e9018;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(0)),(-100)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8755__auto___9091,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8710__auto___9092 = (new cljs.core.List(null,active_viz.scale.scale_inverted.call(null,pad_scale,(400)),(new cljs.core.List(null,(100),null,(1),null)),(2),null));
var result__8711__auto___9093 = cljs.core.apply.call(null,cljs.core._EQ_,values__8710__auto___9092);
if(cljs.core.truth_(result__8711__auto___9093)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(400)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8710__auto___9092),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(400)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8710__auto___9092),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9019){var t__8755__auto___9094 = e9019;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(400)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8755__auto___9094,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8710__auto___9095 = (new cljs.core.List(null,active_viz.scale.scale_inverted.call(null,pad_scale_2,(0)),(new cljs.core.List(null,(-100),null,(1),null)),(2),null));
var result__8711__auto___9096 = cljs.core.apply.call(null,cljs.core._EQ_,values__8710__auto___9095);
if(cljs.core.truth_(result__8711__auto___9096)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(0)),(-100)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8710__auto___9095),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(0)),(-100)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8710__auto___9095),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9020){var t__8755__auto___9097 = e9020;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(0)),(-100)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8755__auto___9097,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__8710__auto__ = (new cljs.core.List(null,active_viz.scale.scale_inverted.call(null,pad_scale_2,(400)),(new cljs.core.List(null,(100),null,(1),null)),(2),null));
var result__8711__auto__ = cljs.core.apply.call(null,cljs.core._EQ_,values__8710__auto__);
if(cljs.core.truth_(result__8711__auto__)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(400)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__8710__auto__),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(400)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__8710__auto__),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

return result__8711__auto__;
}catch (e9021){var t__8755__auto__ = e9021;
return cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(400)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),t__8755__auto__,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}}finally {cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.rest);
}});

active_viz.scale_test.scale.cljs$lang$var = new cljs.core.Var(function(){return active_viz.scale_test.scale;},new cljs.core.Symbol("active-viz.scale-test","scale","active-viz.scale-test/scale",1189529197,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"active-viz.scale-test","active-viz.scale-test",-1253028839,null),new cljs.core.Symbol(null,"scale","scale",1410104174,null),"/home/simon/git/active-viz/test/active_viz/scale_test.cljs",15,1,16,16,cljs.core.List.EMPTY,null,(cljs.core.truth_(active_viz.scale_test.scale)?active_viz.scale_test.scale.cljs$lang$test:null)]));

//# sourceMappingURL=scale_test.js.map
